__all__ = [
    'OperationType',
    'Operation',
    'AnalyticsOperation',
    'PoolOperation',
    'PoolArchiveOperation',
    'PoolCloneOperation',
    'PoolCloseOperation',
    'PoolOpenOperation',
    'TrainingOperation',
    'TrainingArchiveOperation',
    'TrainingCloneOperation',
    'TrainingCloseOperation',
    'TrainingOpenOperation',
    'ProjectArchiveOperation',
    'TasksCreateOperation',
    'TaskSuiteCreateBatchOperation',
    'AggregatedSolutionOperation',
    'UserBonusCreateBatchOperation',
]
import datetime
import toloka.client.primitives.base
import toloka.util._extendable_enum
import typing


class OperationType(toloka.util._extendable_enum.ExtendableStrEnum):
    """An enumeration.
    """

    PSEUDO = 'PSEUDO.PSEUDO'
    ANALYTICS = 'ANALYTICS'
    KNOWN_SOLUTIONS_GENERATE = 'KNOWN_SOLUTIONS.GENERATE'
    POOL_ARCHIVE = 'POOL.ARCHIVE'
    POOL_CLONE = 'POOL.CLONE'
    POOL_CLOSE = 'POOL.CLOSE'
    POOL_OPEN = 'POOL.OPEN'
    PROJECT_ARCHIVE = 'PROJECT.ARCHIVE'
    SOLUTION_AGGREGATE = 'SOLUTION.AGGREGATE'
    TASK_BATCH_CREATE = 'TASK.BATCH_CREATE'
    TASK_SUITE_BATCH_CREATE = 'TASK_SUITE.BATCH_CREATE'
    TRAINING_ARCHIVE = 'TRAINING.ARCHIVE'
    TRAINING_CLONE = 'TRAINING.CLONE'
    TRAINING_CLOSE = 'TRAINING.CLOSE'
    TRAINING_OPEN = 'TRAINING.OPEN'
    USER_BONUS_BATCH_CREATE = 'USER_BONUS.BATCH_CREATE'


class Operation(toloka.client.primitives.base.BaseTolokaObject):
    """Tracking Operation

    Some API requests (opening and closing a pool, archiving a pool or a project, loading multiple tasks,
    awarding bonuses) are processed as asynchronous operations that run in the background.

    Attributes:
        id: Operation ID.
        status: The status of the operation.
        submitted: The UTC date and time the request was sent.
        parameters: Operation parameters (depending on the operation type).
        started: The UTC date and time the operation started.
        finished: The UTC date and time the operation finished.
        progress: The percentage of the operation completed.
        details: Details of the operation completion.
    """

    class Status(toloka.util._extendable_enum.ExtendableStrEnum):
        """The status of the operation:

        Attributes:
            PENDING: Not started yet.
            RUNNING: In progress.
            SUCCESS: Completed successfully.
            FAIL: Not completed.
        """

        PENDING = 'PENDING'
        RUNNING = 'RUNNING'
        SUCCESS = 'SUCCESS'
        FAIL = 'FAIL'

    class Parameters(toloka.client.primitives.base.BaseTolokaObject):
        """Operation parameters (depending on the operation type).
        """

        def __init__(self) -> None:
            """Method generated by attrs for class Operation.Parameters.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]

    def is_completed(self):
        """Returns True if the operation is completed. Status equals SUCCESS or FAIL.
        """
        ...

    def raise_on_fail(self):
        """Raises FailedOperation exception if status is FAIL. Otherwise does nothing.
        """
        ...

    def __init__(
        self,
        *,
        id: typing.Optional[str] = None,
        status: typing.Union[Status, str, None] = None,
        submitted: typing.Optional[datetime.datetime] = None,
        parameters: typing.Optional[Parameters] = None,
        started: typing.Optional[datetime.datetime] = None,
        finished: typing.Optional[datetime.datetime] = None,
        progress: typing.Optional[int] = None,
        details: typing.Optional[typing.Any] = None
    ) -> None:
        """Method generated by attrs for class Operation.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    id: typing.Optional[str]
    status: typing.Optional[Status]
    submitted: typing.Optional[datetime.datetime]
    parameters: typing.Optional[Parameters]
    started: typing.Optional[datetime.datetime]
    finished: typing.Optional[datetime.datetime]
    progress: typing.Optional[int]
    details: typing.Optional[typing.Any]


class AnalyticsOperation(Operation):
    """Operation returned when requesting analytics via TolokaClient.get_analytics()

    Attributes:
        id: Operation ID.
        status: The status of the operation.
        submitted: The UTC date and time the request was sent.
        parameters: Operation parameters (depending on the operation type).
        started: The UTC date and time the operation started.
        finished: The UTC date and time the operation finished.
        progress: The percentage of the operation completed.
        details: Details of the operation completion.
    """

    def __init__(
        self,
        *,
        id: typing.Optional[str] = None,
        status: typing.Union[Operation.Status, str, None] = None,
        submitted: typing.Optional[datetime.datetime] = None,
        parameters: typing.Optional[Operation.Parameters] = None,
        started: typing.Optional[datetime.datetime] = None,
        finished: typing.Optional[datetime.datetime] = None,
        progress: typing.Optional[int] = None,
        details: typing.Optional[typing.Any] = None
    ) -> None:
        """Method generated by attrs for class AnalyticsOperation.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    id: typing.Optional[str]
    status: typing.Optional[Operation.Status]
    submitted: typing.Optional[datetime.datetime]
    parameters: typing.Optional[Operation.Parameters]
    started: typing.Optional[datetime.datetime]
    finished: typing.Optional[datetime.datetime]
    progress: typing.Optional[int]
    details: typing.Optional[typing.Any]


class PoolOperation(Operation):
    """Base class for all operations on pool

    Attributes:
        id: Operation ID.
        status: The status of the operation.
        submitted: The UTC date and time the request was sent.
        started: The UTC date and time the operation started.
        finished: The UTC date and time the operation finished.
        progress: The percentage of the operation completed.
        details: Details of the operation completion.
        parameters: Operation parameters (depending on the operation type).
        parameters.pool_id: On which pool operation is performed.
    """

    class Parameters(Operation.Parameters):
        def __init__(self, *, pool_id: typing.Optional[str] = None) -> None:
            """Method generated by attrs for class PoolOperation.Parameters.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        pool_id: typing.Optional[str]

    def __init__(
        self,
        *,
        id: typing.Optional[str] = None,
        status: typing.Union[Operation.Status, str, None] = None,
        submitted: typing.Optional[datetime.datetime] = None,
        started: typing.Optional[datetime.datetime] = None,
        finished: typing.Optional[datetime.datetime] = None,
        progress: typing.Optional[int] = None,
        details: typing.Optional[typing.Any] = None,
        parameters: typing.Optional[Parameters] = None
    ) -> None:
        """Method generated by attrs for class PoolOperation.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    id: typing.Optional[str]
    status: typing.Optional[Operation.Status]
    submitted: typing.Optional[datetime.datetime]
    parameters: typing.Optional[Parameters]
    started: typing.Optional[datetime.datetime]
    finished: typing.Optional[datetime.datetime]
    progress: typing.Optional[int]
    details: typing.Optional[typing.Any]


class PoolArchiveOperation(PoolOperation):
    """Operation returned by an asynchronous archive pool via TolokaClient.archive_pool_async()

    Attributes:
        id: Operation ID.
        status: The status of the operation.
        submitted: The UTC date and time the request was sent.
        started: The UTC date and time the operation started.
        finished: The UTC date and time the operation finished.
        progress: The percentage of the operation completed.
        details: Details of the operation completion.
        parameters: Operation parameters (depending on the operation type).
        parameters.pool_id: On which pool operation is performed.
    """

    def __init__(
        self,
        *,
        id: typing.Optional[str] = None,
        status: typing.Union[Operation.Status, str, None] = None,
        submitted: typing.Optional[datetime.datetime] = None,
        started: typing.Optional[datetime.datetime] = None,
        finished: typing.Optional[datetime.datetime] = None,
        progress: typing.Optional[int] = None,
        details: typing.Optional[typing.Any] = None,
        parameters: typing.Optional[PoolOperation.Parameters] = None
    ) -> None:
        """Method generated by attrs for class PoolArchiveOperation.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    id: typing.Optional[str]
    status: typing.Optional[Operation.Status]
    submitted: typing.Optional[datetime.datetime]
    parameters: typing.Optional[PoolOperation.Parameters]
    started: typing.Optional[datetime.datetime]
    finished: typing.Optional[datetime.datetime]
    progress: typing.Optional[int]
    details: typing.Optional[typing.Any]


class PoolCloneOperation(PoolOperation):
    """Operation returned by an asynchronous cloning pool via TolokaClient.clone_pool_async()

    As parameters.pool_id contains id of the pool that needs to be cloned.
    New pool id stored in details.pool_id.
    Don't be mistaken.

    Attributes:
        id: Operation ID.
        status: The status of the operation.
        submitted: The UTC date and time the request was sent.
        started: The UTC date and time the operation started.
        finished: The UTC date and time the operation finished.
        progress: The percentage of the operation completed.
        parameters: Operation parameters (depending on the operation type).
        details: Details of the operation completion.
        parameters.pool_id: On which pool operation is performed.
        details.pool_id: New pool id created after cloning.
    """

    class Details(PoolOperation.Parameters):
        def __init__(self, *, pool_id: typing.Optional[str] = None) -> None:
            """Method generated by attrs for class PoolCloneOperation.Details.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        pool_id: typing.Optional[str]

    def __init__(
        self,
        *,
        id: typing.Optional[str] = None,
        status: typing.Union[Operation.Status, str, None] = None,
        submitted: typing.Optional[datetime.datetime] = None,
        started: typing.Optional[datetime.datetime] = None,
        finished: typing.Optional[datetime.datetime] = None,
        progress: typing.Optional[int] = None,
        parameters: typing.Optional[PoolOperation.Parameters] = None,
        details: typing.Optional[Details] = None
    ) -> None:
        """Method generated by attrs for class PoolCloneOperation.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    id: typing.Optional[str]
    status: typing.Optional[Operation.Status]
    submitted: typing.Optional[datetime.datetime]
    parameters: typing.Optional[PoolOperation.Parameters]
    started: typing.Optional[datetime.datetime]
    finished: typing.Optional[datetime.datetime]
    progress: typing.Optional[int]
    details: typing.Optional[Details]


class PoolCloseOperation(PoolOperation):
    """Operation returned by an asynchronous closing pool via TolokaClient.close_pool_async()

    Attributes:
        id: Operation ID.
        status: The status of the operation.
        submitted: The UTC date and time the request was sent.
        started: The UTC date and time the operation started.
        finished: The UTC date and time the operation finished.
        progress: The percentage of the operation completed.
        details: Details of the operation completion.
        parameters: Operation parameters (depending on the operation type).
        parameters.pool_id: On which pool operation is performed.
    """

    def __init__(
        self,
        *,
        id: typing.Optional[str] = None,
        status: typing.Union[Operation.Status, str, None] = None,
        submitted: typing.Optional[datetime.datetime] = None,
        started: typing.Optional[datetime.datetime] = None,
        finished: typing.Optional[datetime.datetime] = None,
        progress: typing.Optional[int] = None,
        details: typing.Optional[typing.Any] = None,
        parameters: typing.Optional[PoolOperation.Parameters] = None
    ) -> None:
        """Method generated by attrs for class PoolCloseOperation.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    id: typing.Optional[str]
    status: typing.Optional[Operation.Status]
    submitted: typing.Optional[datetime.datetime]
    parameters: typing.Optional[PoolOperation.Parameters]
    started: typing.Optional[datetime.datetime]
    finished: typing.Optional[datetime.datetime]
    progress: typing.Optional[int]
    details: typing.Optional[typing.Any]


class PoolOpenOperation(PoolOperation):
    """Operation returned by an asynchronous opening pool via TolokaClient.open_pool_async()

    Attributes:
        id: Operation ID.
        status: The status of the operation.
        submitted: The UTC date and time the request was sent.
        started: The UTC date and time the operation started.
        finished: The UTC date and time the operation finished.
        progress: The percentage of the operation completed.
        details: Details of the operation completion.
        parameters: Operation parameters (depending on the operation type).
        parameters.pool_id: On which pool operation is performed.
    """

    def __init__(
        self,
        *,
        id: typing.Optional[str] = None,
        status: typing.Union[Operation.Status, str, None] = None,
        submitted: typing.Optional[datetime.datetime] = None,
        started: typing.Optional[datetime.datetime] = None,
        finished: typing.Optional[datetime.datetime] = None,
        progress: typing.Optional[int] = None,
        details: typing.Optional[typing.Any] = None,
        parameters: typing.Optional[PoolOperation.Parameters] = None
    ) -> None:
        """Method generated by attrs for class PoolOpenOperation.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    id: typing.Optional[str]
    status: typing.Optional[Operation.Status]
    submitted: typing.Optional[datetime.datetime]
    parameters: typing.Optional[PoolOperation.Parameters]
    started: typing.Optional[datetime.datetime]
    finished: typing.Optional[datetime.datetime]
    progress: typing.Optional[int]
    details: typing.Optional[typing.Any]


class TrainingOperation(Operation):
    """Base class for all operations on training pool

    Attributes:
        id: Operation ID.
        status: The status of the operation.
        submitted: The UTC date and time the request was sent.
        started: The UTC date and time the operation started.
        finished: The UTC date and time the operation finished.
        progress: The percentage of the operation completed.
        details: Details of the operation completion.
        parameters: Operation parameters (depending on the operation type).
        parameters.training_id: On which training pool operation is performed.
    """

    class Parameters(Operation.Parameters):
        def __init__(self, *, training_id: typing.Optional[str] = None) -> None:
            """Method generated by attrs for class TrainingOperation.Parameters.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        training_id: typing.Optional[str]

    def __init__(
        self,
        *,
        id: typing.Optional[str] = None,
        status: typing.Union[Operation.Status, str, None] = None,
        submitted: typing.Optional[datetime.datetime] = None,
        started: typing.Optional[datetime.datetime] = None,
        finished: typing.Optional[datetime.datetime] = None,
        progress: typing.Optional[int] = None,
        details: typing.Optional[typing.Any] = None,
        parameters: typing.Optional[Parameters] = None
    ) -> None:
        """Method generated by attrs for class TrainingOperation.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    id: typing.Optional[str]
    status: typing.Optional[Operation.Status]
    submitted: typing.Optional[datetime.datetime]
    parameters: typing.Optional[Parameters]
    started: typing.Optional[datetime.datetime]
    finished: typing.Optional[datetime.datetime]
    progress: typing.Optional[int]
    details: typing.Optional[typing.Any]


class TrainingArchiveOperation(TrainingOperation):
    """Operation returned by an asynchronous archive training pool via TolokaClient.archive_training_async()

    Attributes:
        id: Operation ID.
        status: The status of the operation.
        submitted: The UTC date and time the request was sent.
        started: The UTC date and time the operation started.
        finished: The UTC date and time the operation finished.
        progress: The percentage of the operation completed.
        details: Details of the operation completion.
        parameters: Operation parameters (depending on the operation type).
        parameters.training_id: On which training pool operation is performed.
    """

    def __init__(
        self,
        *,
        id: typing.Optional[str] = None,
        status: typing.Union[Operation.Status, str, None] = None,
        submitted: typing.Optional[datetime.datetime] = None,
        started: typing.Optional[datetime.datetime] = None,
        finished: typing.Optional[datetime.datetime] = None,
        progress: typing.Optional[int] = None,
        details: typing.Optional[typing.Any] = None,
        parameters: typing.Optional[TrainingOperation.Parameters] = None
    ) -> None:
        """Method generated by attrs for class TrainingArchiveOperation.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    id: typing.Optional[str]
    status: typing.Optional[Operation.Status]
    submitted: typing.Optional[datetime.datetime]
    parameters: typing.Optional[TrainingOperation.Parameters]
    started: typing.Optional[datetime.datetime]
    finished: typing.Optional[datetime.datetime]
    progress: typing.Optional[int]
    details: typing.Optional[typing.Any]


class TrainingCloneOperation(TrainingOperation):
    """Operation returned by an asynchronous cloning training pool via TolokaClient.clone_training_async()

    As parameters.training_id contains id of the training pool that needs to be cloned.
    New training pool id stored in details.training_id.
    Don't be mistaken.

    Attributes:
        id: Operation ID.
        status: The status of the operation.
        submitted: The UTC date and time the request was sent.
        started: The UTC date and time the operation started.
        finished: The UTC date and time the operation finished.
        progress: The percentage of the operation completed.
        parameters: Operation parameters (depending on the operation type).
        details: Details of the operation completion.
        parameters.training_id: On which training pool operation is performed.
        details.pool_id: New training pool id created after cloning.
    """

    class Details(TrainingOperation.Parameters):
        def __init__(self, *, training_id: typing.Optional[str] = None) -> None:
            """Method generated by attrs for class TrainingCloneOperation.Details.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        training_id: typing.Optional[str]

    def __init__(
        self,
        *,
        id: typing.Optional[str] = None,
        status: typing.Union[Operation.Status, str, None] = None,
        submitted: typing.Optional[datetime.datetime] = None,
        started: typing.Optional[datetime.datetime] = None,
        finished: typing.Optional[datetime.datetime] = None,
        progress: typing.Optional[int] = None,
        parameters: typing.Optional[TrainingOperation.Parameters] = None,
        details: typing.Optional[Details] = None
    ) -> None:
        """Method generated by attrs for class TrainingCloneOperation.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    id: typing.Optional[str]
    status: typing.Optional[Operation.Status]
    submitted: typing.Optional[datetime.datetime]
    parameters: typing.Optional[TrainingOperation.Parameters]
    started: typing.Optional[datetime.datetime]
    finished: typing.Optional[datetime.datetime]
    progress: typing.Optional[int]
    details: typing.Optional[Details]


class TrainingCloseOperation(TrainingOperation):
    """Operation returned by an asynchronous closing training pool via TolokaClient.close_training_async()

    Attributes:
        id: Operation ID.
        status: The status of the operation.
        submitted: The UTC date and time the request was sent.
        started: The UTC date and time the operation started.
        finished: The UTC date and time the operation finished.
        progress: The percentage of the operation completed.
        details: Details of the operation completion.
        parameters: Operation parameters (depending on the operation type).
        parameters.training_id: On which training pool operation is performed.
    """

    def __init__(
        self,
        *,
        id: typing.Optional[str] = None,
        status: typing.Union[Operation.Status, str, None] = None,
        submitted: typing.Optional[datetime.datetime] = None,
        started: typing.Optional[datetime.datetime] = None,
        finished: typing.Optional[datetime.datetime] = None,
        progress: typing.Optional[int] = None,
        details: typing.Optional[typing.Any] = None,
        parameters: typing.Optional[TrainingOperation.Parameters] = None
    ) -> None:
        """Method generated by attrs for class TrainingCloseOperation.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    id: typing.Optional[str]
    status: typing.Optional[Operation.Status]
    submitted: typing.Optional[datetime.datetime]
    parameters: typing.Optional[TrainingOperation.Parameters]
    started: typing.Optional[datetime.datetime]
    finished: typing.Optional[datetime.datetime]
    progress: typing.Optional[int]
    details: typing.Optional[typing.Any]


class TrainingOpenOperation(TrainingOperation):
    """Operation returned by an asynchronous opening training pool via TolokaClient.open_training_async()

    Attributes:
        id: Operation ID.
        status: The status of the operation.
        submitted: The UTC date and time the request was sent.
        started: The UTC date and time the operation started.
        finished: The UTC date and time the operation finished.
        progress: The percentage of the operation completed.
        details: Details of the operation completion.
        parameters: Operation parameters (depending on the operation type).
        parameters.training_id: On which training pool operation is performed.
    """

    def __init__(
        self,
        *,
        id: typing.Optional[str] = None,
        status: typing.Union[Operation.Status, str, None] = None,
        submitted: typing.Optional[datetime.datetime] = None,
        started: typing.Optional[datetime.datetime] = None,
        finished: typing.Optional[datetime.datetime] = None,
        progress: typing.Optional[int] = None,
        details: typing.Optional[typing.Any] = None,
        parameters: typing.Optional[TrainingOperation.Parameters] = None
    ) -> None:
        """Method generated by attrs for class TrainingOpenOperation.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    id: typing.Optional[str]
    status: typing.Optional[Operation.Status]
    submitted: typing.Optional[datetime.datetime]
    parameters: typing.Optional[TrainingOperation.Parameters]
    started: typing.Optional[datetime.datetime]
    finished: typing.Optional[datetime.datetime]
    progress: typing.Optional[int]
    details: typing.Optional[typing.Any]


class ProjectArchiveOperation(Operation):
    """Operation returned by an asynchronous archive project via TolokaClient.archive_project_async()

    Attributes:
        id: Operation ID.
        status: The status of the operation.
        submitted: The UTC date and time the request was sent.
        started: The UTC date and time the operation started.
        finished: The UTC date and time the operation finished.
        progress: The percentage of the operation completed.
        details: Details of the operation completion.
        parameters: Operation parameters (depending on the operation type).
        parameters.project_id: On which project operation is performed.
    """

    class Parameters(Operation.Parameters):
        def __init__(self, *, project_id: typing.Optional[str] = None) -> None:
            """Method generated by attrs for class ProjectArchiveOperation.Parameters.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        project_id: typing.Optional[str]

    def __init__(
        self,
        *,
        id: typing.Optional[str] = None,
        status: typing.Union[Operation.Status, str, None] = None,
        submitted: typing.Optional[datetime.datetime] = None,
        started: typing.Optional[datetime.datetime] = None,
        finished: typing.Optional[datetime.datetime] = None,
        progress: typing.Optional[int] = None,
        details: typing.Optional[typing.Any] = None,
        parameters: typing.Optional[Parameters] = None
    ) -> None:
        """Method generated by attrs for class ProjectArchiveOperation.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    id: typing.Optional[str]
    status: typing.Optional[Operation.Status]
    submitted: typing.Optional[datetime.datetime]
    parameters: typing.Optional[Parameters]
    started: typing.Optional[datetime.datetime]
    finished: typing.Optional[datetime.datetime]
    progress: typing.Optional[int]
    details: typing.Optional[typing.Any]


class TasksCreateOperation(Operation):
    """Operation returned by an asynchronous creating tasks via TolokaClient.create_tasks_async()

    All parameters are for reference only and describe the initial parameters of the request that this operation monitors.

    Attributes:
        id: Operation ID.
        status: The status of the operation.
        submitted: The UTC date and time the request was sent.
        started: The UTC date and time the operation started.
        progress: The percentage of the operation completed.
        parameters: Operation parameters (depending on the operation type).
        finished: The UTC date and time the operation finished.
        details: Details of the operation completion.
        parameters.skip_invalid_items: Validation parameters for JSON objects:
            * True - Create the tasks that passed validation. Skip the rest of the tasks.
            * False - If at least one of the tasks didn't pass validation, stop the operation and
                don't create any tasks.
        parameters.allow_defaults: Overlap settings:
            * True - Use the overlap that is set in the pool parameters
                (in the defaults.default_overlap_for_new_tasks key).
            * False - Use the overlap that is set in the task parameters (in the overlap field).
        parameters.open_pool: Open the pool immediately after creating the tasks, if the pool is closed.
    """

    class Parameters(Operation.Parameters):
        def __init__(
            self,
            *,
            skip_invalid_items: typing.Optional[bool] = None,
            allow_defaults: typing.Optional[bool] = None,
            open_pool: typing.Optional[bool] = None
        ) -> None:
            """Method generated by attrs for class TasksCreateOperation.Parameters.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        skip_invalid_items: typing.Optional[bool]
        allow_defaults: typing.Optional[bool]
        open_pool: typing.Optional[bool]

    def __init__(
        self,
        *,
        id: typing.Optional[str] = None,
        status: typing.Union[Operation.Status, str, None] = None,
        submitted: typing.Optional[datetime.datetime] = None,
        started: typing.Optional[datetime.datetime] = None,
        progress: typing.Optional[int] = None,
        parameters: typing.Optional[Parameters] = None,
        finished: typing.Optional[datetime.datetime] = None,
        details: typing.Optional[typing.Any] = None
    ) -> None:
        """Method generated by attrs for class TasksCreateOperation.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    id: typing.Optional[str]
    status: typing.Optional[Operation.Status]
    submitted: typing.Optional[datetime.datetime]
    parameters: typing.Optional[Parameters]
    started: typing.Optional[datetime.datetime]
    finished: typing.Optional[datetime.datetime]
    progress: typing.Optional[int]
    details: typing.Optional[typing.Any]


class TaskSuiteCreateBatchOperation(Operation):
    """Operation returned by an asynchronous creating TaskSuite's via TolokaClient.create_task_suites_async()

    All parameters are for reference only and describe the initial parameters of the request that this operation monitors.

    Attributes:
        id: Operation ID.
        status: The status of the operation.
        submitted: The UTC date and time the request was sent.
        started: The UTC date and time the operation started.
        progress: The percentage of the operation completed.
        parameters: Operation parameters (depending on the operation type).
        finished: The UTC date and time the operation finished.
        details: Details of the operation completion.
        parameters.skip_invalid_items: Validation parameters for JSON objects:
            * True - Create the task suites that passed validation. Skip the rest of the task suites.
            * False - If at least one of the task suites didn't pass validation, stop the operation and
                don't create any task suites.
        parameters.allow_defaults: Overlap settings:
            * True - Use the overlap that is set in the pool parameters.
            * False - Use the overlap that is set in the task parameters (in the overlap field).
        parameters.open_pool: Open the pool immediately after creating the task suites, if the pool is closed.
    """

    class Parameters(Operation.Parameters):
        def __init__(
            self,
            *,
            skip_invalid_items: typing.Optional[bool] = None,
            allow_defaults: typing.Optional[bool] = None,
            open_pool: typing.Optional[bool] = None
        ) -> None:
            """Method generated by attrs for class TaskSuiteCreateBatchOperation.Parameters.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        skip_invalid_items: typing.Optional[bool]
        allow_defaults: typing.Optional[bool]
        open_pool: typing.Optional[bool]

    def __init__(
        self,
        *,
        id: typing.Optional[str] = None,
        status: typing.Union[Operation.Status, str, None] = None,
        submitted: typing.Optional[datetime.datetime] = None,
        started: typing.Optional[datetime.datetime] = None,
        progress: typing.Optional[int] = None,
        parameters: typing.Optional[Parameters] = None,
        finished: typing.Optional[datetime.datetime] = None,
        details: typing.Optional[typing.Any] = None
    ) -> None:
        """Method generated by attrs for class TaskSuiteCreateBatchOperation.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    id: typing.Optional[str]
    status: typing.Optional[Operation.Status]
    submitted: typing.Optional[datetime.datetime]
    parameters: typing.Optional[Parameters]
    started: typing.Optional[datetime.datetime]
    finished: typing.Optional[datetime.datetime]
    progress: typing.Optional[int]
    details: typing.Optional[typing.Any]


class AggregatedSolutionOperation(Operation):
    """Operation returned by an asynchronous aggregation responses in pool via TolokaClient.aggregate_solutions_by_pool()

    Attributes:
        id: Operation ID.
        status: The status of the operation.
        submitted: The UTC date and time the request was sent.
        started: The UTC date and time the operation started.
        finished: The UTC date and time the operation finished.
        progress: The percentage of the operation completed.
        details: Details of the operation completion.
        parameters: Operation parameters (depending on the operation type).
        parameters.pool_id: In which pool the responses are aggregated.
    """

    class Parameters(Operation.Parameters):
        def __init__(self, *, pool_id: typing.Optional[str] = None) -> None:
            """Method generated by attrs for class AggregatedSolutionOperation.Parameters.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        pool_id: typing.Optional[str]

    def __init__(
        self,
        *,
        id: typing.Optional[str] = None,
        status: typing.Union[Operation.Status, str, None] = None,
        submitted: typing.Optional[datetime.datetime] = None,
        started: typing.Optional[datetime.datetime] = None,
        finished: typing.Optional[datetime.datetime] = None,
        progress: typing.Optional[int] = None,
        details: typing.Optional[typing.Any] = None,
        parameters: typing.Optional[Parameters] = None
    ) -> None:
        """Method generated by attrs for class AggregatedSolutionOperation.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    id: typing.Optional[str]
    status: typing.Optional[Operation.Status]
    submitted: typing.Optional[datetime.datetime]
    parameters: typing.Optional[Parameters]
    started: typing.Optional[datetime.datetime]
    finished: typing.Optional[datetime.datetime]
    progress: typing.Optional[int]
    details: typing.Optional[typing.Any]


class UserBonusCreateBatchOperation(Operation):
    """Operation returned by the `TolokaClient.create_user_bonuses_async()` method.

    All parameters are for reference only and describe the initial parameters of the request that this operation monitors.

    Attributes:
        id: Operation ID.
        status: The status of the operation.
        submitted: The UTC date and time the request was sent.
        started: The UTC date and time the operation started.
        finished: The UTC date and time the operation finished.
        progress: The percentage of the operation completed.
        parameters: Operation parameters (depending on the operation type).
        details: Details of the operation completion.
        parameters.skip_invalid_items: Validation parameters for JSON objects:
            * True - Create rewards using `UserBonus` instances that passed validation. Skip the rest of the `UserBonus` instances.
            * False - If at least one of the `UserBonus` instances didn't pass validation, stop the operation and
                don't create any rewards.
        details.pool_id: 
        details.total_count: The number of bonuses in the request.
        details.valid_count: The number of JSON objects with bonus information that have passed validation.
        details.not_valid_count: The number of JSON objects with bonus information that failed validation.
        details.success_count: Number of bonuses issued.
        details.failed_count: The number of bonuses that were not issued.
    """

    class Parameters(Operation.Parameters):
        def __init__(self, *, skip_invalid_items: typing.Optional[bool] = None) -> None:
            """Method generated by attrs for class UserBonusCreateBatchOperation.Parameters.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        skip_invalid_items: typing.Optional[bool]

    class Details(PoolOperation.Parameters):
        def __init__(
            self,
            *,
            pool_id: typing.Optional[str] = None,
            total_count: typing.Optional[int] = None,
            valid_count: typing.Optional[int] = None,
            not_valid_count: typing.Optional[int] = None,
            success_count: typing.Optional[int] = None,
            failed_count: typing.Optional[int] = None
        ) -> None:
            """Method generated by attrs for class UserBonusCreateBatchOperation.Details.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        pool_id: typing.Optional[str]
        total_count: typing.Optional[int]
        valid_count: typing.Optional[int]
        not_valid_count: typing.Optional[int]
        success_count: typing.Optional[int]
        failed_count: typing.Optional[int]

    def __init__(
        self,
        *,
        id: typing.Optional[str] = None,
        status: typing.Union[Operation.Status, str, None] = None,
        submitted: typing.Optional[datetime.datetime] = None,
        started: typing.Optional[datetime.datetime] = None,
        finished: typing.Optional[datetime.datetime] = None,
        progress: typing.Optional[int] = None,
        parameters: typing.Optional[Parameters] = None,
        details: typing.Optional[Details] = None
    ) -> None:
        """Method generated by attrs for class UserBonusCreateBatchOperation.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    id: typing.Optional[str]
    status: typing.Optional[Operation.Status]
    submitted: typing.Optional[datetime.datetime]
    parameters: typing.Optional[Parameters]
    started: typing.Optional[datetime.datetime]
    finished: typing.Optional[datetime.datetime]
    progress: typing.Optional[int]
    details: typing.Optional[Details]
