__all__ = [
    'DynamicPricingConfig',
]
import toloka.client.primitives.base
import toloka.util._extendable_enum
import typing


class DynamicPricingConfig(toloka.client.primitives.base.BaseTolokaObject):
    """The dynamic pricing settings.

    Attributes:
        type: Parameter type for calculating dynamic pricing. The SKILL value.
        skill_id: ID of the skill that the task price is based on
        intervals: Skill level intervals. Must not overlap.
            A Toloker with a skill level that is not included in any interval will receive the basic
            price for a task suite.
    """

    class Type(toloka.util._extendable_enum.ExtendableStrEnum):
        """Dynamic pricing type
        """

        SKILL = 'SKILL'

    class Interval(toloka.client.primitives.base.BaseTolokaObject):
        """Skill level interval

        Attributes:
            from_: Lower bound of the interval.
            to: dynamic_pricing_config.intervals.to
            reward_per_assignment: The price per task page for a Toloker with the specified skill level.
        """

        def __init__(
            self,
            *,
            from_: typing.Optional[int] = None,
            to: typing.Optional[int] = None,
            reward_per_assignment: typing.Optional[float] = None
        ) -> None:
            """Method generated by attrs for class DynamicPricingConfig.Interval.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        from_: typing.Optional[int]
        to: typing.Optional[int]
        reward_per_assignment: typing.Optional[float]

    def __init__(
        self,
        type: typing.Union[Type, str, None] = None,
        skill_id: typing.Optional[str] = None,
        intervals: typing.Optional[typing.List[Interval]] = None
    ) -> None:
        """Method generated by attrs for class DynamicPricingConfig.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    type: typing.Optional[Type]
    skill_id: typing.Optional[str]
    intervals: typing.Optional[typing.List[Interval]]
