__all__ = [
    'SpeedQualityBalanceConfig',
    'TopPercentageByQuality',
    'BestConcurrentUsersByQuality',
]
import toloka.client.primitives.base
import toloka.util._extendable_enum
import typing


class SpeedQualityBalanceConfig(toloka.client.primitives.base.BaseTolokaObject):
    """Adjust balance between speed and quality.
    """

    class Type(toloka.util._extendable_enum.ExtendableStrEnum):
        """The type of speed quality balance:

        Attributes:
            TOP_PERCENTAGE_BY_QUALITY: get top XX% Tolokers by quality.
            BEST_CONCURRENT_USERS_BY_QUALITY: get top x Tolokers by quality.
        """

        TOP_PERCENTAGE_BY_QUALITY = 'TOP_PERCENTAGE_BY_QUALITY'
        BEST_CONCURRENT_USERS_BY_QUALITY = 'BEST_CONCURRENT_USERS_BY_QUALITY'

    def __init__(self) -> None:
        """Method generated by attrs for class SpeedQualityBalanceConfig.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]


class TopPercentageByQuality(SpeedQualityBalanceConfig):
    """The percentage of Tolokers ordered by quality that will work on pool.
    """

    def __init__(self, *, percent: typing.Optional[int] = None) -> None:
        """Method generated by attrs for class TopPercentageByQuality.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    percent: typing.Optional[int]


class BestConcurrentUsersByQuality(SpeedQualityBalanceConfig):
    """How many concurrent Tolokers ordered by quality will work on pool.
    """

    def __init__(self, *, count: typing.Optional[int] = None) -> None:
        """Method generated by attrs for class BestConcurrentUsersByQuality.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    count: typing.Optional[int]
