__all__ = [
    'BaseHelperV1',
    'ConcatArraysHelperV1',
    'Entries2ObjectHelperV1',
    'IfHelperV1',
    'JoinHelperV1',
    'Object2EntriesHelperV1',
    'ReplaceHelperV1',
    'SearchQueryHelperV1',
    'SwitchHelperV1',
    'TextTransformHelperV1',
    'TransformHelperV1',
    'TranslateHelperV1',
    'YandexDiskProxyHelperV1',
]
import toloka.client.project.template_builder.base
import toloka.util._extendable_enum
import typing


class BaseHelperV1(toloka.client.project.template_builder.base.BaseComponent, metaclass=toloka.client.project.template_builder.base.VersionedBaseComponentMetaclass):
    """Perform various operations, such as if-then-else or switch-case.
    """

    def __init__(self, *, version: typing.Optional[str] = '1.0.0') -> None:
        """Method generated by attrs for class BaseHelperV1.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    version: typing.Optional[str]


class ConcatArraysHelperV1(BaseHelperV1):
    """Merging multiple arrays into a single array.

    For example, let's say you have multiple arrays:
    ([1, 2, 3], [4, 5, 6], [7, 8, 9])
    Their elements can be combined into a single array to show simultaneously:
    [1, 2, 3, 4, 5, 6, 7, 8, 9]
    Attributes:
        items: Arrays to combine.
    """

    def __init__(
        self,
        items: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, typing.List[typing.Any]]] = None,
        *,
        version: typing.Optional[str] = '1.0.0'
    ) -> None:
        """Method generated by attrs for class ConcatArraysHelperV1.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    version: typing.Optional[str]
    items: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, typing.List[typing.Any]]]


class Entries2ObjectHelperV1(BaseHelperV1):
    """Creating an object from a specified array of key-value pairs.

    For example, let's say you have an array like this:
    [
        {
            "key": "foo",
            "value": "hello"
        },
        {
            "key": "bar",
            "value": "world"
        }
    ]
    It is converted to an object whose elements consist of the values of the original array:
    { "foo": "hello", "bar": "world" }
    Attributes:
        entries: Source array of key-value pairs.
    """

    class Entry(toloka.client.project.template_builder.base.BaseTemplate):
        def __init__(
            self,
            key: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, str]] = None,
            value: typing.Optional[typing.Any] = None
        ) -> None:
            """Method generated by attrs for class Entries2ObjectHelperV1.Entry.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        key: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, str]]
        value: typing.Optional[typing.Any]

    def __init__(
        self,
        entries: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, typing.List[typing.Union[toloka.client.project.template_builder.base.BaseComponent, Entry]]]] = None,
        *,
        version: typing.Optional[str] = '1.0.0'
    ) -> None:
        """Method generated by attrs for class Entries2ObjectHelperV1.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    version: typing.Optional[str]
    entries: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, typing.List[typing.Union[toloka.client.project.template_builder.base.BaseComponent, Entry]]]]


class IfHelperV1(BaseHelperV1):
    """The If...Then...Else operator.

    Allows you to execute either one block of code or another, depending on the condition. If you need more options,
    use helper.switch.

    For example, if you want to conduct a survey, you can use the helper.if component to ask the gender of the
    respondent and add different sets of questions, depending on whether the respondent is male or female.
    How it works: If the condition in if is true (returns true), the code specified in the then property will be
    executed. Otherwise (the condition is false and returns false) the code specified in else will be executed.
    The else property is optional. For example, let's say you ask a Toloker "Do you like the image?". You can make a
    comment field appear when a negative response is received, but nothing happens when a positive response is received.
    Attributes:
        condition: Condition to check.
        then: The element that is returned if the condition from the condition property is true (returns true).
        else_: The element that is returned if the condition from the condition property is false (returns false).

    Example:
        How to show a part of the interface by condition.

        >>> hidden_ui = tb.helpers.IfHelperV1(
        >>>     tb.conditions.EqualsConditionV1(tb.data.OutputData('show_me'), 'show'),
        >>>     tb.view.ListViewV1([header, buttons, images]),
        >>> )
        ...
    """

    def __init__(
        self,
        condition: typing.Optional[toloka.client.project.template_builder.base.BaseComponent] = None,
        then: typing.Optional[typing.Any] = None,
        *,
        else_: typing.Optional[typing.Any] = None,
        version: typing.Optional[str] = '1.0.0'
    ) -> None:
        """Method generated by attrs for class IfHelperV1.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    version: typing.Optional[str]
    condition: typing.Optional[toloka.client.project.template_builder.base.BaseComponent]
    then: typing.Optional[typing.Any]
    else_: typing.Optional[typing.Any]


class JoinHelperV1(BaseHelperV1):
    """The component combines two or more strings into one.

    You can add a delimiter to separate the strings, such as a space or comma.
    Attributes:
        items: Array of strings to join.
        by: Delimiter for joining strings. You can use any number of characters in the delimiter.
    """

    def __init__(
        self,
        items: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, typing.List[typing.Union[toloka.client.project.template_builder.base.BaseComponent, str]]]] = None,
        by: typing.Optional[typing.Any] = None,
        *,
        version: typing.Optional[str] = '1.0.0'
    ) -> None:
        """Method generated by attrs for class JoinHelperV1.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    version: typing.Optional[str]
    items: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, typing.List[typing.Union[toloka.client.project.template_builder.base.BaseComponent, str]]]]
    by: typing.Optional[typing.Any]


class Object2EntriesHelperV1(BaseHelperV1):
    """Creating an array of key-value pairs from the specified object.

    For example, let's say you have an object that looks like this:
    {
        "foo": "hello",
        "bar": "world"
    }
    It will be converted to an array whose objects will pair data from the source object and their designations:
    [
        {
            "key": "foo",
            "value": "hello"
        },
        {
            "key": "bar",
            "value": "world"
        }
    ]
    Attributes:
        data: The object to convert.
    """

    def __init__(
        self,
        data: typing.Optional[typing.Any] = None,
        *,
        version: typing.Optional[str] = '1.0.0'
    ) -> None:
        """Method generated by attrs for class Object2EntriesHelperV1.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    version: typing.Optional[str]
    data: typing.Optional[typing.Any]


class ReplaceHelperV1(BaseHelperV1):
    """Allows you to replace some parts of the string with others.

    This helper function returns a string in which all occurrences of `find` in `data` are replaced with `replace`.
    Because the helper.replace helper returns a string, it can be used in properties that accept string values.
    Attributes:
        data: Data to perform the replacement on.
        find: The value to search for — the string whose occurrences must be found in data and replaced with the string
            from replace.
        replace: The value to insert in place of the matches of the find value.
    """

    def __init__(
        self,
        data: typing.Optional[typing.Any] = None,
        find: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, str]] = None,
        replace: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, str]] = None,
        *,
        version: typing.Optional[str] = '1.0.0'
    ) -> None:
        """Method generated by attrs for class ReplaceHelperV1.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    version: typing.Optional[str]
    data: typing.Optional[typing.Any]
    find: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, str]]
    replace: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, str]]


class SearchQueryHelperV1(BaseHelperV1):
    """Component for creating a string with a search query reference.

    The list of available search engines is specified in the engine enum.
    Attributes:
        query: Search query.
        engine: Search engine.
    """

    class Engine(toloka.util._extendable_enum.ExtendableStrEnum):
        """An enumeration.
        """

        YANDEX = 'yandex'
        GOOGLE = 'google'
        BING = 'bing'
        MAILRU = 'mail.ru'
        WIKIPEDIA = 'wikipedia'
        YANDEX_COLLECTIONS = 'yandex/collections'
        YANDEX_VIDEO = 'yandex/video'
        YANDEX_IMAGES = 'yandex/images'
        GOOGLE_IMAGES = 'google/images'
        YANDEX_NEWS = 'yandex/news'
        GOOGLE_NEWS = 'google/news'

    def __init__(
        self,
        query: typing.Optional[typing.Any] = None,
        engine: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, Engine]] = None,
        *,
        version: typing.Optional[str] = '1.0.0'
    ) -> None:
        """Method generated by attrs for class SearchQueryHelperV1.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    version: typing.Optional[str]
    query: typing.Optional[typing.Any]
    engine: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, Engine]]


class SwitchHelperV1(BaseHelperV1):
    """A switch-case construction.

    Checks various conditions sequentially and executes the code from the result property when the corresponding
    condition is true.

    You can use it to perform an action or display an additional interface element only when a certain condition is met.
    View example in the sandbox.

    This helper is similar to a series of If...Then...Else logical expressions, so it is useful if there are more than
    two conditions for sequential verification. If you need to check one or two conditions, use the helper.if component.
    How the helper works:
        * The helper checks (conditions) from the array of cases objects, starting from the first one.
        * If the condition is true (returns true), the helper returns the result (block of code) specified in the result
          property for the condition object in the cases array. The helper quits and subsequent conditions are not
          checked.
        * If the condition is false (returns false), the helper checks the subsequent condition.
        * If all conditions are false as a result of all checks, the helper returns the value specified in the default
          property (if it is not defined, the helper returns nothing).
    Attributes:
        cases: An array of objects consisting of condition and result property pairs.
        default: Element that is returned if none of the checked conditions returned true.
    """

    class Case(toloka.client.project.template_builder.base.BaseTemplate):
        """Case.

        Attributes:
            condition: Condition to check.
            result: The element that is returned if the condition from the condition property is true (returns true).
        """

        def __init__(
            self,
            condition: typing.Optional[toloka.client.project.template_builder.base.BaseComponent] = None,
            result: typing.Optional[typing.Any] = None
        ) -> None:
            """Method generated by attrs for class SwitchHelperV1.Case.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        condition: typing.Optional[toloka.client.project.template_builder.base.BaseComponent]
        result: typing.Optional[typing.Any]

    def __init__(
        self,
        cases: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, typing.List[typing.Union[toloka.client.project.template_builder.base.BaseComponent, Case]]]] = None,
        default: typing.Optional[typing.Any] = None,
        *,
        version: typing.Optional[str] = '1.0.0'
    ) -> None:
        """Method generated by attrs for class SwitchHelperV1.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    version: typing.Optional[str]
    cases: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, typing.List[typing.Union[toloka.client.project.template_builder.base.BaseComponent, Case]]]]
    default: typing.Optional[typing.Any]


class TextTransformHelperV1(BaseHelperV1):
    """Allows you to change the case of the text, like make all letters uppercase.

    For example, you can use this component to automatically process input data.

    This component is available in property values with the string type, for example in the content property in the
    view.text component.
    Attributes:
        data: The text string in which you want to change the case.
        transformation: Conversion mode.
    """

    class Transformation(toloka.util._extendable_enum.ExtendableStrEnum):
        """An enumeration.
        """

        UPPERCASE = 'uppercase'
        LOWERCASE = 'lowercase'
        CAPITALIZE = 'capitalize'

    def __init__(
        self,
        data: typing.Optional[typing.Any] = None,
        transformation: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, Transformation]] = None,
        *,
        version: typing.Optional[str] = '1.0.0'
    ) -> None:
        """Method generated by attrs for class TextTransformHelperV1.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    version: typing.Optional[str]
    data: typing.Optional[typing.Any]
    transformation: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, Transformation]]


class TransformHelperV1(BaseHelperV1):
    """Creates a new array by transforming each of the elements in the original array.

    For example, you can convert an array of image links to view.image components to display these images. This may be
    useful if the number of images in the array is unknown in advance
    Attributes:
        into: Template to transform elements in the array. The array value can be substituted using the data.local
            component. To do this, use the construction { "type": "data.local", "path": "item"}
        items: The array that you want to convert. You can specify an array in three ways:
            * Specify the array itself. Example: ["one", "two", "three"].
            * Insert a reference to data (input, output, or internal). Example: {"type": "data.input",
                "path": "path.to.data"}.
            * Use a reference to another configuration element. Example: {"$ref": "vars.myarray"}.
    """

    def __init__(
        self,
        into: typing.Optional[typing.Any] = None,
        items: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, typing.List[typing.Any]]] = None,
        *,
        version: typing.Optional[str] = '1.0.0'
    ) -> None:
        """Method generated by attrs for class TransformHelperV1.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    version: typing.Optional[str]
    into: typing.Optional[typing.Any]
    items: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, typing.List[typing.Any]]]


class TranslateHelperV1(BaseHelperV1):
    """Component for translating interface elements to other languages.

    In the properties that should be displayed in different languages, add:

    {
      "type": "helper.translate",
      "key": "<key name>"
    {

    Adding the key property displays a field for entering the key text. Enter the text in the source language. In the
    "Translations" step, add translations for the keys in the desired languages.

    Attributes:
        key: The key for a text property that you will translate to other languages.
    """

    def __init__(
        self,
        key: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, str]] = None,
        *,
        version: typing.Optional[str] = '1.0.0'
    ) -> None:
        """Method generated by attrs for class TranslateHelperV1.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    version: typing.Optional[str]
    key: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, str]]


class YandexDiskProxyHelperV1(BaseHelperV1):
    """You can use this component to download files from Yandex&#160;Disk.

    To use YandexDiskProxyHelper, connect Yandex&#160;Disk to your Toloka account and add the proxy by following
    the [instructions](https://toloka.ai/docs/guide/concepts/prepare-data.html?lang=en)
    Select the component that you want to add, such as view.image for an image or view.audio for an audio file.
    In the url property of this component, use YandexDiskProxyHelper.
    Attributes:
        path: Path to the file in the <Proxy name>/<File name>.<type> format
    """

    def __init__(
        self,
        path: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, str]] = None,
        *,
        version: typing.Optional[str] = '1.0.0'
    ) -> None:
        """Method generated by attrs for class YandexDiskProxyHelperV1.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    version: typing.Optional[str]
    path: typing.Optional[typing.Union[toloka.client.project.template_builder.base.BaseComponent, str]]
