__all__ = [
    'SetUserSkillRequest',
    'UserSkill',
]
import datetime
import decimal
import toloka.client.primitives.base
import typing


class SetUserSkillRequest(toloka.client.primitives.base.BaseTolokaObject):
    """Parameters for setting the skill value of a specific Toloker.

    Used for grouping the fields required for setting the Toloker's skill.
    Usually, when calling TolokaClient.set_user_skill, you can use the expand version, passing all the class attributes to the call.

    Attributes:
        skill_id: Skill ID. What skill to set.
        user_id: Toloker's ID.
        value: Fractional value of the skill. Minimum - 0, maximum - 100.
    """

    def __init__(
        self,
        *,
        skill_id: typing.Optional[str] = None,
        user_id: typing.Optional[str] = None,
        value: typing.Optional[decimal.Decimal] = None
    ) -> None:
        """Method generated by attrs for class SetUserSkillRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    skill_id: typing.Optional[str]
    user_id: typing.Optional[str]
    value: typing.Optional[decimal.Decimal]


class UserSkill(toloka.client.primitives.base.BaseTolokaObject):
    """Describes the value of a specific skill for a specific Toloker.

    Attributes:
        id: Internal identifier of the Toloker's skill value.
        skill_id: Skill identifier, which skill is installed.
        user_id: Toloker identifier, to which Toloker the skill is installed.
        value: Skill value (from 0 to 100). Rough presentation.
        exact_value: Skill value (from 0 to 100). Exact representation.
        created: Date and time when this skill was created for the Toloker.
        modified: Date and time of the last skill change for the Toloker.
    """

    def __init__(
        self,
        *,
        id: typing.Optional[str] = None,
        skill_id: typing.Optional[str] = None,
        user_id: typing.Optional[str] = None,
        value: typing.Optional[int] = None,
        exact_value: typing.Optional[decimal.Decimal] = None,
        created: typing.Optional[datetime.datetime] = None,
        modified: typing.Optional[datetime.datetime] = None
    ) -> None:
        """Method generated by attrs for class UserSkill.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    id: typing.Optional[str]
    skill_id: typing.Optional[str]
    user_id: typing.Optional[str]
    value: typing.Optional[int]
    exact_value: typing.Optional[decimal.Decimal]
    created: typing.Optional[datetime.datetime]
    modified: typing.Optional[datetime.datetime]
