__all__ = [
    'AssignmentEvent',
    'BaseEvent',
    'MessageThreadEvent',
    'TaskEvent',
    'UserBonusEvent',
    'UserRestrictionEvent',
    'UserSkillEvent',
]
import datetime
import enum
import toloka.client.assignment
import toloka.client.message_thread
import toloka.client.primitives.base
import toloka.client.task
import toloka.client.user_bonus
import toloka.client.user_restriction
import toloka.client.user_skill
import typing


class BaseEventTypeEnum(enum.Enum):
    """An enumeration.
    """

    ...


class BaseEvent(toloka.client.primitives.base.BaseTolokaObject):
    def __init__(self, *, event_time: typing.Optional[datetime.datetime] = None) -> None:
        """Method generated by attrs for class BaseEvent.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    event_time: typing.Optional[datetime.datetime]


class AssignmentEvent(BaseEvent):
    """Assignment-related event.

    Attributes:
        event_time: Event datetime.
        event_type: One of the folllowing event types:
            * CREATED
            * SUBMITTED
            * ACCEPTED
            * REJECTED
            * SKIPPED
            * EXPIRED
        assignment: Assignment object itself.
    """

    class Type(BaseEventTypeEnum):
        """An enumeration.
        """

        CREATED = 'CREATED'
        SUBMITTED = 'SUBMITTED'
        ACCEPTED = 'ACCEPTED'
        REJECTED = 'REJECTED'
        SKIPPED = 'SKIPPED'
        EXPIRED = 'EXPIRED'

    def __init__(
        self,
        *,
        event_time: typing.Optional[datetime.datetime] = None,
        event_type: typing.Union[Type, str, None] = None,
        assignment: typing.Optional[toloka.client.assignment.Assignment] = None
    ) -> None:
        """Method generated by attrs for class AssignmentEvent.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    event_time: typing.Optional[datetime.datetime]
    event_type: typing.Optional[Type]
    assignment: typing.Optional[toloka.client.assignment.Assignment]


class TaskEvent(BaseEvent):
    """Task-related event.

    Attributes:
        event_time: Event datetime.
        task: Task object itself.
    """

    def __init__(
        self,
        *,
        event_time: typing.Optional[datetime.datetime] = None,
        task: typing.Optional[toloka.client.task.Task] = None
    ) -> None:
        """Method generated by attrs for class TaskEvent.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    event_time: typing.Optional[datetime.datetime]
    task: typing.Optional[toloka.client.task.Task]


class UserBonusEvent(BaseEvent):
    """UserBonus-related event.

    Attributes:
        event_time: Event datetime.
        user_bonus: UserBonus object itself.
    """

    def __init__(
        self,
        *,
        event_time: typing.Optional[datetime.datetime] = None,
        user_bonus: typing.Optional[toloka.client.user_bonus.UserBonus] = None
    ) -> None:
        """Method generated by attrs for class UserBonusEvent.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    event_time: typing.Optional[datetime.datetime]
    user_bonus: typing.Optional[toloka.client.user_bonus.UserBonus]


class UserSkillEvent(BaseEvent):
    """UserSkill-related event.

    Attributes:
        event_time: Event datetime.
        event_type: One of the folllowing event types:
            * CREATED
            * MODIFIED
        user_skill: UserSkill object itself.
    """

    class Type(BaseEventTypeEnum):
        """An enumeration.
        """

        CREATED = 'CREATED'
        MODIFIED = 'MODIFIED'

    def __init__(
        self,
        *,
        event_time: typing.Optional[datetime.datetime] = None,
        event_type: typing.Union[Type, str, None] = None,
        user_skill: typing.Optional[toloka.client.user_skill.UserSkill] = None
    ) -> None:
        """Method generated by attrs for class UserSkillEvent.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    event_time: typing.Optional[datetime.datetime]
    event_type: typing.Optional[Type]
    user_skill: typing.Optional[toloka.client.user_skill.UserSkill]


class UserRestrictionEvent(BaseEvent):
    """UserSkill-related event.

    Attributes:
        event_time: Event datetime.
        user_skill: UserSkill object itself.
    """

    def __init__(
        self,
        *,
        event_time: typing.Optional[datetime.datetime] = None,
        user_restriction: typing.Optional[toloka.client.user_restriction.UserRestriction] = None
    ) -> None:
        """Method generated by attrs for class UserRestrictionEvent.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    event_time: typing.Optional[datetime.datetime]
    user_restriction: typing.Optional[toloka.client.user_restriction.UserRestriction]


class MessageThreadEvent(BaseEvent):
    """MessageThread-related event.

    Args:
        event_time: Event datetime.
        user_skill: UserSkill object itself.
    """

    def __init__(
        self,
        *,
        event_time: typing.Optional[datetime.datetime] = None,
        message_thread: typing.Optional[toloka.client.message_thread.MessageThread] = None
    ) -> None:
        """Method generated by attrs for class MessageThreadEvent.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    event_time: typing.Optional[datetime.datetime]
    message_thread: typing.Optional[toloka.client.message_thread.MessageThread]
