__all__ = [
    'AppProject',
    'App',
    'AppItem',
    'AppItemsCreateRequest',
    'AppBatch',
    'AppBatchCreateRequest',
    'AppBatchPatch',
]
import datetime
import decimal
import toloka.client.primitives.base
import toloka.client.project.field_spec
import toloka.util._extendable_enum
import typing


class _AppError(toloka.client.primitives.base.BaseTolokaObject):
    """A structure for describing errors which may appear while working with App projects.

    Attributes:
        code: The short name of the error.
        message: The detailed description of the error.
        payload: Additional data provided with the error.
    """

    def __init__(
        self,
        *,
        code: typing.Optional[str] = None,
        message: typing.Optional[str] = None,
        payload: typing.Optional[typing.Any] = None
    ) -> None:
        """Method generated by attrs for class _AppError.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    code: typing.Optional[str]
    message: typing.Optional[str]
    payload: typing.Optional[typing.Any]


class AppLightestResult(toloka.client.primitives.base.BaseTolokaObject):
    """Brief information about the project template.

    Attributes:
        id: The ID of the App solution.
        name: The solution name.
    """

    def __init__(
        self,
        *,
        id: typing.Optional[str] = None,
        name: typing.Optional[str] = None
    ) -> None:
        """Method generated by attrs for class AppLightestResult.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    id: typing.Optional[str]
    name: typing.Optional[str]


class AppProject(toloka.client.primitives.base.BaseTolokaObject):
    """An [App](https://toloka.ai/en/docs/toloka-apps/concepts/) project.

    An App project is based on one of App solutions. It is created with a template interface and preconfigured data specification and quality control rules.

    To get available App solutions use the [get_apps](toloka.client.TolokaClient.get_apps.md) method.

    Attributes:
        app_id: The ID of the App solution used to create the project.
        parent_app_project_id: The ID of the parent project. It is set if this project is a clone of other project. Otherwise it is empty.
        name: The project name.
        parameters: Parameters of the solution. The parameters should follow the schema described in the `param_spec` field of the [solution](toloka.client.app.App.md).
        id: The ID of the project.
        status: The project status:
            * `CREATING` — Toloka is checking the project.
            * `READY` — The project is active.
            * `ARCHIVED` — The project was archived.
            * `ERROR` — Project creation failed due to errors.
        created: The date and time when the project was created.
        item_price: The price you pay for a processed item.
        errors: Errors found during a project check.
        read_only:
        app: Brief information about the project template.
    """

    class Status(toloka.util._extendable_enum.ExtendableStrEnum):
        """An enumeration.
        """

        CREATING = 'CREATING'
        READY = 'READY'
        ARCHIVED = 'ARCHIVED'
        ERROR = 'ERROR'

    def __init__(
        self,
        *,
        app_id: typing.Optional[str] = None,
        parent_app_project_id: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        parameters: typing.Optional[typing.Dict] = None,
        id: typing.Optional[str] = None,
        status: typing.Union[Status, str, None] = None,
        created: typing.Optional[datetime.datetime] = None,
        item_price: typing.Optional[decimal.Decimal] = None,
        errors: typing.Optional[typing.List[_AppError]] = None,
        read_only: typing.Optional[bool] = None,
        app: typing.Optional[AppLightestResult] = None
    ) -> None:
        """Method generated by attrs for class AppProject.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    app_id: typing.Optional[str]
    parent_app_project_id: typing.Optional[str]
    name: typing.Optional[str]
    parameters: typing.Optional[typing.Dict]
    id: typing.Optional[str]
    status: typing.Optional[Status]
    created: typing.Optional[datetime.datetime]
    item_price: typing.Optional[decimal.Decimal]
    errors: typing.Optional[typing.List[_AppError]]
    read_only: typing.Optional[bool]
    app: typing.Optional[AppLightestResult]


class App(toloka.client.primitives.base.BaseTolokaObject):
    """An [App](https://toloka.ai/en/docs/toloka-apps/concepts/) solution.

    Each App solution targets specific type of tasks which can be solved using Toloka.

    Attributes:
        id: The ID of the App solution.
        name: The solution name.
        image: A link to the solution interface preview image.
        description: The solution description.
        constraints_description: The description of limitations.
        default_item_price: The default cost of one annotated item.
        param_spec: The specification of parameters used to create a project.
        input_spec: The schema of solution input data.
        output_spec: The schema of solution output data.
        examples: Example description of tasks which can be solved with this solution.
        input_format_info: Information about the input data format.
    """

    def __init__(
        self,
        *,
        id: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        image: typing.Optional[str] = None,
        description: typing.Optional[str] = None,
        constraints_description: typing.Optional[str] = None,
        default_item_price: typing.Optional[decimal.Decimal] = None,
        param_spec: typing.Optional[typing.Dict] = None,
        input_spec: typing.Optional[typing.Dict[str, toloka.client.project.field_spec.FieldSpec]] = None,
        output_spec: typing.Optional[typing.Dict[str, toloka.client.project.field_spec.FieldSpec]] = None,
        examples: typing.Optional[typing.Any] = None,
        input_format_info: typing.Optional[typing.Dict] = None
    ) -> None:
        """Method generated by attrs for class App.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    id: typing.Optional[str]
    name: typing.Optional[str]
    image: typing.Optional[str]
    description: typing.Optional[str]
    constraints_description: typing.Optional[str]
    default_item_price: typing.Optional[decimal.Decimal]
    param_spec: typing.Optional[typing.Dict]
    input_spec: typing.Optional[typing.Dict[str, toloka.client.project.field_spec.FieldSpec]]
    output_spec: typing.Optional[typing.Dict[str, toloka.client.project.field_spec.FieldSpec]]
    examples: typing.Optional[typing.Any]
    input_format_info: typing.Optional[typing.Dict]


class AppItem(toloka.client.primitives.base.BaseTolokaObject):
    """A task item.

    Items are uploaded to Toloka and are grouped in batches. After uploading the status of items is set to `NEW`. Items with that status can be edited. Then entire batches are sent for labeling.

    Attributes:
        id: The ID of the item.
        app_project_id: The ID of the project that contains the item.
        batch_id: The ID of the batch that contains the item.
        input_data: Input data. It must follow the solution schema described in `App.input_spec`.
        status: The item status:
            * `NEW` — The item is uploaded to Toloka and ready for processing.
            * `PROCESSING` — The item is being processed by Tolokers.
            * `COMPLETED` — Item annotation is completed.
            * `ERROR` — An error occurred during processing.
            * `CANCELLED` — Item processing cancelled.
            * `ARCHIVE` — The item is archived.
            * `NO_MONEY` — There are not enough money for processing.
        output_data: Annotated data.
        errors: Errors occurred during annotation.
        created_at: The date and time when the item was created.
        started_at: The date and time when the item processing started.
        finished_at: The date and time when the item processing was completed.
    """

    class Status(toloka.util._extendable_enum.ExtendableStrEnum):
        """An enumeration.
        """

        NEW = 'NEW'
        PROCESSING = 'PROCESSING'
        COMPLETED = 'COMPLETED'
        ERROR = 'ERROR'
        CANCELLED = 'CANCELLED'
        ARCHIVE = 'ARCHIVE'
        NO_MONEY = 'NO_MONEY'
        STOPPED = 'STOPPED'

    def __init__(
        self,
        *,
        batch_id: typing.Optional[str] = None,
        input_data: typing.Optional[typing.Dict[str, typing.Any]] = None,
        id: typing.Optional[str] = None,
        app_project_id: typing.Optional[str] = None,
        status: typing.Union[Status, str, None] = None,
        output_data: typing.Optional[typing.Dict[str, typing.Any]] = None,
        errors: typing.Optional[typing.List[_AppError]] = None,
        created_at: typing.Optional[datetime.datetime] = None,
        started_at: typing.Optional[datetime.datetime] = None,
        finished_at: typing.Optional[datetime.datetime] = None
    ) -> None:
        """Method generated by attrs for class AppItem.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    batch_id: typing.Optional[str]
    input_data: typing.Optional[typing.Dict[str, typing.Any]]
    id: typing.Optional[str]
    app_project_id: typing.Optional[str]
    status: typing.Optional[Status]
    output_data: typing.Optional[typing.Dict[str, typing.Any]]
    errors: typing.Optional[typing.List[_AppError]]
    created_at: typing.Optional[datetime.datetime]
    started_at: typing.Optional[datetime.datetime]
    finished_at: typing.Optional[datetime.datetime]


class AppItemsCreateRequest(toloka.client.primitives.base.BaseTolokaObject):
    """Parameters of a request for creating multiple items.

    Attributes:
        batch_id: The ID of the batch to place items to.
        items: A list with items. The items must follow the solution schema described in `App.input_spec`.
    """

    def __init__(
        self,
        *,
        batch_id: typing.Optional[str] = None,
        items: typing.Optional[typing.List[typing.Dict[str, typing.Any]]] = None
    ) -> None:
        """Method generated by attrs for class AppItemsCreateRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    batch_id: typing.Optional[str]
    items: typing.Optional[typing.List[typing.Dict[str, typing.Any]]]


class AppItemImport(toloka.client.primitives.base.BaseTolokaObject):
    """Meta-information on asynchronous loading operation (possible via UI).

    Attributes:
        id:
        records_count: Number of items in the loading operation.
        records_processed: Number of successfully loaded items in the loading operation.
        errors: Errors during the loading operation.
    """

    def __init__(
        self,
        *,
        id: typing.Optional[str] = None,
        records_count: typing.Optional[int] = None,
        records_processed: typing.Optional[int] = None,
        errors: typing.Optional[typing.Dict] = None
    ) -> None:
        """Method generated by attrs for class AppItemImport.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    id: typing.Optional[str]
    records_count: typing.Optional[int]
    records_processed: typing.Optional[int]
    errors: typing.Optional[typing.Dict]


class AppBatch(toloka.client.primitives.base.BaseTolokaObject):
    """An App batch.

    A batch contains task items that are sent for labeling together.

    Attributes:
        id: The ID of the batch.
        app_project_id: The ID of the project containing the batch.
        name: The batch name.
        status: The batch status:
            * `NEW` — The processing of the batch items is not started.
            * `PROCESSING` — Batch items are being processed by Tolokers.
            * `COMPLETED` — Annotation of all batch items is completed.
            * `ERROR` — An error occurred during processing.
            * `CANCELLED` — Batch processing cancelled.
            * `ARCHIVE` — The batch is archived.
            * `NO_MONEY` — There are not enough money for processing.
        items_count: The number of items in the batch.
        item_price: The cost of processing a single item in the batch.
        cost: The cost of processing the batch.
        cost_of_processed: Cost of already processed task items.
        created_at: The date and time when the batch was created.
        started_at: The date and time when batch processing started.
        finished_at: The date and time when batch processing was completed.
        read_only:
        last_items_import: Meta-information on asynchronous loading operation (possible via UI).
        confidence_avg: Average labeling quality.
        items_processed_count: Number of labeled items.
        eta: Expected date and time when batch processing will be completed.
        items_per_state: Statistics on the number of items in each state.
    """

    class Status(toloka.util._extendable_enum.ExtendableStrEnum):
        """An enumeration.
        """

        NEW = 'NEW'
        PROCESSING = 'PROCESSING'
        COMPLETED = 'COMPLETED'
        ERROR = 'ERROR'
        CANCELLED = 'CANCELLED'
        NO_MONEY = 'NO_MONEY'
        ARCHIVE = 'ARCHIVE'
        LOADING = 'LOADING'
        STOPPING = 'STOPPING'
        STOPPED = 'STOPPED'

    def __init__(
        self,
        *,
        id: typing.Optional[str] = None,
        app_project_id: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        status: typing.Union[Status, str, None] = None,
        items_count: typing.Optional[int] = None,
        item_price: typing.Optional[decimal.Decimal] = None,
        cost: typing.Optional[decimal.Decimal] = None,
        cost_of_processed: typing.Optional[decimal.Decimal] = None,
        created_at: typing.Optional[datetime.datetime] = None,
        started_at: typing.Optional[datetime.datetime] = None,
        finished_at: typing.Optional[datetime.datetime] = None,
        read_only: typing.Optional[bool] = None,
        last_items_import: typing.Optional[AppItemImport] = None,
        confidence_avg: typing.Optional[float] = None,
        items_processed_count: typing.Optional[int] = None,
        eta: typing.Optional[datetime.datetime] = None,
        items_per_state: typing.Optional[typing.Dict] = None
    ) -> None:
        """Method generated by attrs for class AppBatch.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    id: typing.Optional[str]
    app_project_id: typing.Optional[str]
    name: typing.Optional[str]
    status: typing.Optional[Status]
    items_count: typing.Optional[int]
    item_price: typing.Optional[decimal.Decimal]
    cost: typing.Optional[decimal.Decimal]
    cost_of_processed: typing.Optional[decimal.Decimal]
    created_at: typing.Optional[datetime.datetime]
    started_at: typing.Optional[datetime.datetime]
    finished_at: typing.Optional[datetime.datetime]
    read_only: typing.Optional[bool]
    last_items_import: typing.Optional[AppItemImport]
    confidence_avg: typing.Optional[float]
    items_processed_count: typing.Optional[int]
    eta: typing.Optional[datetime.datetime]
    items_per_state: typing.Optional[typing.Dict]


class AppBatchCreateRequest(toloka.client.primitives.base.BaseTolokaObject):
    """Parameters of a request for creating multiple App task items in a batch.

    Attributes:
        name: Batch name.
        items: A list with task items. The items must follow the solution schema described in `App.input_spec`.
    """

    def __init__(
        self,
        *,
        name: typing.Optional[str] = None,
        items: typing.Optional[typing.List[typing.Dict[str, typing.Any]]] = None
    ) -> None:
        """Method generated by attrs for class AppBatchCreateRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    name: typing.Optional[str]
    items: typing.Optional[typing.List[typing.Dict[str, typing.Any]]]


class AppBatchPatch(toloka.client.primitives.base.BaseTolokaObject):
    """"Parameters for changing name of a specific AppBatch

    Attributes:
        name: Batch name.
    """

    def __init__(self, *, name: typing.Optional[str] = None) -> None:
        """Method generated by attrs for class AppBatchPatch.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    name: typing.Optional[str]
