__all__ = [
    'Attachment',
    'AssignmentAttachment',
]
import datetime
import toloka.client.owner
import toloka.client.primitives.base
import toloka.util._extendable_enum
import typing


class Attachment(toloka.client.primitives.base.BaseTolokaObject):
    """Attachment

    Files uploaded by Tolokers are saved in Toloka.
    Attributes:
        id: File ID.
        name: File name.
        details: Information about the pool, the task, and the Toloker who uploaded the file.
        created: Date the file was uploaded to Toloka.
        media_type: MIME data type.
        owner: Owner
    """

    class Type(toloka.util._extendable_enum.ExtendableStrEnum):
        """An enumeration.
        """

        ASSIGNMENT_ATTACHMENT = 'ASSIGNMENT_ATTACHMENT'

    class Details(toloka.client.primitives.base.BaseTolokaObject):
        """Information about the pool, task, and the Toloker from which the file was received.

        Attributes:
            user_id: ID of the Toloker from whom the file was received.
            assignment_id: ID for issuing a set of tasks to the Toloker.
            pool_id: Pool ID.
        """

        def __init__(
            self,
            *,
            user_id: typing.Optional[str] = None,
            assignment_id: typing.Optional[str] = None,
            pool_id: typing.Optional[str] = None
        ) -> None:
            """Method generated by attrs for class Attachment.Details.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        user_id: typing.Optional[str]
        assignment_id: typing.Optional[str]
        pool_id: typing.Optional[str]

    def __init__(
        self,
        *,
        id: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        details: typing.Optional[Details] = None,
        created: typing.Optional[datetime.datetime] = None,
        media_type: typing.Optional[str] = None,
        owner: typing.Optional[toloka.client.owner.Owner] = None
    ) -> None:
        """Method generated by attrs for class Attachment.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    id: typing.Optional[str]
    name: typing.Optional[str]
    details: typing.Optional[Details]
    created: typing.Optional[datetime.datetime]
    media_type: typing.Optional[str]
    owner: typing.Optional[toloka.client.owner.Owner]


class AssignmentAttachment(Attachment):
    """Assignment Attachment.

    Attributes:
        id: File ID.
        name: File name.
        details: Information about the pool, the task, and the Toloker who uploaded the file.
        created: Date the file was uploaded to Toloka.
        media_type: MIME data type.
        owner: Owner
    """

    def __init__(
        self,
        *,
        id: typing.Optional[str] = None,
        name: typing.Optional[str] = None,
        details: typing.Optional[Attachment.Details] = None,
        created: typing.Optional[datetime.datetime] = None,
        media_type: typing.Optional[str] = None,
        owner: typing.Optional[toloka.client.owner.Owner] = None
    ) -> None:
        """Method generated by attrs for class AssignmentAttachment.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    id: typing.Optional[str]
    name: typing.Optional[str]
    details: typing.Optional[Attachment.Details]
    created: typing.Optional[datetime.datetime]
    media_type: typing.Optional[str]
    owner: typing.Optional[toloka.client.owner.Owner]
