__all__ = [
    'FieldValidationError',
    'TaskBatchCreateResult',
    'TaskSuiteBatchCreateResult',
    'UserBonusBatchCreateResult',
    'WebhookSubscriptionBatchCreateResult',
]
import toloka.client.primitives.base
import toloka.client.task
import toloka.client.task_suite
import toloka.client.user_bonus
import toloka.client.webhook_subscription
import typing


class FieldValidationError(toloka.client.primitives.base.BaseTolokaObject):
    """Error that contains information about an invalid field

    Attributes:
        code: error code string.
        message: error message.
        params: additional params.
    """

    def __init__(
        self,
        *,
        code: typing.Optional[str] = None,
        message: typing.Optional[str] = None,
        params: typing.Optional[typing.List[typing.Any]] = None
    ) -> None:
        """Method generated by attrs for class FieldValidationError.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    code: typing.Optional[str]
    message: typing.Optional[str]
    params: typing.Optional[typing.List[typing.Any]]


class TaskBatchCreateResult(toloka.client.primitives.base.BaseTolokaObject):
    """The list with the results of the tasks creation operation.

    Attributes:
        items: Object with created tasks.
        validation_errors: Object with errors in tasks. Returned if the parameter is used in the request skip_invalid_items=True.
    """

    def __init__(
        self,
        *,
        items: typing.Optional[typing.Dict[str, toloka.client.task.Task]] = None,
        validation_errors: typing.Optional[typing.Dict[str, typing.Dict[str, FieldValidationError]]] = None
    ) -> None:
        """Method generated by attrs for class TaskBatchCreateResult.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.Dict[str, toloka.client.task.Task]]
    validation_errors: typing.Optional[typing.Dict[str, typing.Dict[str, FieldValidationError]]]


class TaskSuiteBatchCreateResult(toloka.client.primitives.base.BaseTolokaObject):
    """The list with the results of the task suites creation operation.

    Attributes:
        items: Object with created task suites.
        validation_errors: Object with errors in task suites. Returned if the parameter is used in the request skip_invalid_items=True.
    """

    def __init__(
        self,
        *,
        items: typing.Optional[typing.Dict[str, toloka.client.task_suite.TaskSuite]] = None,
        validation_errors: typing.Optional[typing.Dict[str, typing.Dict[str, FieldValidationError]]] = None
    ) -> None:
        """Method generated by attrs for class TaskSuiteBatchCreateResult.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.Dict[str, toloka.client.task_suite.TaskSuite]]
    validation_errors: typing.Optional[typing.Dict[str, typing.Dict[str, FieldValidationError]]]


class UserBonusBatchCreateResult(toloka.client.primitives.base.BaseTolokaObject):
    """A list with the results of creating rewards for Tolokers.

    Attributes:
        items: Object with information about issued bonuses.
        validation_errors: Object with validation errors. Returned if the parameter is used in the request skip_invalid_items=True.
    """

    def __init__(
        self,
        *,
        items: typing.Optional[typing.Dict[str, toloka.client.user_bonus.UserBonus]] = None,
        validation_errors: typing.Optional[typing.Dict[str, typing.Dict[str, FieldValidationError]]] = None
    ) -> None:
        """Method generated by attrs for class UserBonusBatchCreateResult.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.Dict[str, toloka.client.user_bonus.UserBonus]]
    validation_errors: typing.Optional[typing.Dict[str, typing.Dict[str, FieldValidationError]]]


class WebhookSubscriptionBatchCreateResult(toloka.client.primitives.base.BaseTolokaObject):
    """A list with the results of the webhook-subscriptions creation operation.

    Attributes:
        items: Object with created webhook-subscriptions.
        validation_errors: Object with validation errors.
    """

    def __init__(
        self,
        *,
        items: typing.Optional[typing.Dict[str, toloka.client.webhook_subscription.WebhookSubscription]] = None,
        validation_errors: typing.Optional[typing.Dict[str, typing.Dict[str, FieldValidationError]]] = None
    ) -> None:
        """Method generated by attrs for class WebhookSubscriptionBatchCreateResult.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.Dict[str, toloka.client.webhook_subscription.WebhookSubscription]]
    validation_errors: typing.Optional[typing.Dict[str, typing.Dict[str, FieldValidationError]]]
