__all__ = [
    'CompareOperator',
    'InclusionOperator',
    'IdentityOperator',
    'InclusionConditionMixin',
    'IdentityConditionMixin',
    'ComparableConditionMixin',
    'StatefulComparableConditionMixin',
]
import toloka.client.primitives.base
import toloka.util._extendable_enum


class CompareOperator(toloka.util._extendable_enum.ExtendableStrEnum):
    """An enumeration.
    """

    EQ = 'EQ'
    NE = 'NE'
    GT = 'GT'
    GTE = 'GTE'
    LT = 'LT'
    LTE = 'LTE'


class InclusionOperator(toloka.util._extendable_enum.ExtendableStrEnum):
    """An enumeration.
    """

    IN = 'IN'
    NOT_IN = 'NOT_IN'


class IdentityOperator(toloka.util._extendable_enum.ExtendableStrEnum):
    """An enumeration.
    """

    EQ = 'EQ'
    NE = 'NE'


def _eq_compatible_with_help(cls, value): ...


class _InclusionConditionMetaclass(toloka.client.primitives.base.BaseTolokaObjectMetaclass):
    def include(
        cls,
        *args,
        **kwargs
    ): ...

    def exclude(
        cls,
        *args,
        **kwargs
    ): ...

    def in_(
        cls,
        *args,
        **kwargs
    ): ...

    def not_in(
        cls,
        *args,
        **kwargs
    ): ...

    @staticmethod
    def __new__(
        mcs,
        name,
        bases,
        namespace,
        kw_only=False,
        **kwargs
    ): ...


class _IdentityConditionMetaclass(toloka.client.primitives.base.BaseTolokaObjectMetaclass):
    def eq(cls, value): ...

    def ne(cls, value): ...

    def __hash__(cls): ...

    def __ne__(cls, value): ...

    def __eq__(cls, value): ...

    @staticmethod
    def __new__(
        mcs,
        name,
        bases,
        namespace,
        kw_only=False,
        **kwargs
    ): ...


class _ComparableConditionMetaclass(toloka.client.primitives.base.BaseTolokaObjectMetaclass):
    def lt(cls, value): ...

    def lte(cls, value): ...

    def gt(cls, value): ...

    def gte(cls, value): ...

    def eq(cls, value): ...

    def ne(cls, value): ...

    def __hash__(cls): ...

    def __ne__(cls, value): ...

    def __lt__(cls, value): ...

    def __le__(cls, value): ...

    def __gt__(cls, value): ...

    def __ge__(cls, value): ...

    def __eq__(cls, value): ...

    @staticmethod
    def __new__(
        mcs,
        name,
        bases,
        namespace,
        kw_only=False,
        **kwargs
    ): ...


class InclusionConditionMixin(metaclass=_InclusionConditionMetaclass):
    def __init__(self, operator: InclusionOperator) -> None:
        """Method generated by attrs for class InclusionConditionMixin.
        """
        ...

    operator: InclusionOperator


class IdentityConditionMixin(metaclass=_IdentityConditionMetaclass):
    def __init__(self, operator: IdentityOperator) -> None:
        """Method generated by attrs for class IdentityConditionMixin.
        """
        ...

    operator: IdentityOperator


class ComparableConditionMixin(metaclass=_ComparableConditionMetaclass):
    def __init__(self, operator: CompareOperator) -> None:
        """Method generated by attrs for class ComparableConditionMixin.
        """
        ...

    operator: CompareOperator


class StatefulComparableConditionMixin:
    def lt(self, value): ...

    def lte(self, value): ...

    def gt(self, value): ...

    def gte(self, value): ...

    def eq(self, value): ...

    def ne(self, value): ...
