__all__ = [
    'AdditionalLanguage',
    'LocalizationConfig',
]
import enum
import toloka.client.primitives.base
import typing


class AdditionalLanguage(toloka.client.primitives.base.BaseTolokaObject):
    """Description for additional language in project

    Args:
        language: The language into which the translation is made. A string from ISO 639-1.
        public_name: Translation of the project field 'public_name' into the specified language.
        public_description: Translation of the project field 'public_description' into the specified language.
        public_instructions: Translation of the project field 'public_instructions' into the specified language.
    """

    class FieldTranslation(toloka.client.primitives.base.BaseTolokaObject):
        """Translation of one specific field

        Args:
            value: A string translated into the desired language.
            source: In creation you can pass only 'REQUESTER' right now.
        """

        class Source(enum.Enum):
            """Possible values of sources

            In creation you can pass only 'REQUESTER' right now.
            """

            REQUESTER = 'REQUESTER'

        def __init__(
            self,
            *,
            value: typing.Optional[str] = None,
            source: typing.Union[Source, str, None] = ...
        ) -> None:
            """Method generated by attrs for class AdditionalLanguage.FieldTranslation.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        value: typing.Optional[str]
        source: typing.Optional[Source]

    def __init__(
        self,
        *,
        language: typing.Optional[str] = None,
        public_name: typing.Optional[FieldTranslation] = None,
        public_description: typing.Optional[FieldTranslation] = None,
        public_instructions: typing.Optional[FieldTranslation] = None
    ) -> None:
        """Method generated by attrs for class AdditionalLanguage.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    language: typing.Optional[str]
    public_name: typing.Optional[FieldTranslation]
    public_description: typing.Optional[FieldTranslation]
    public_instructions: typing.Optional[FieldTranslation]


class LocalizationConfig(toloka.client.primitives.base.BaseTolokaObject):
    """Translates the part of the project visible to Tolokers into different languages

    It is used to make it easier for Tolokers from other countries who do not speak the necessary language to
    understand and complete tasks.

    Args:
        default_language: The source language used in the fields public_name, public_description, and public_instructions.
            Required parameter.
        additional_languages: List of translations into other languages. One element - one translation.
    """

    def __init__(
        self,
        *,
        default_language: typing.Optional[str] = None,
        additional_languages: typing.Optional[typing.List[AdditionalLanguage]] = ...
    ) -> None:
        """Method generated by attrs for class LocalizationConfig.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    default_language: typing.Optional[str]
    additional_languages: typing.Optional[typing.List[AdditionalLanguage]]
