__all__ = [
    'TaskSpec',
]
import toloka.client.primitives.base
import toloka.client.project.field_spec
import toloka.client.project.view_spec
import typing


class TaskSpec(toloka.client.primitives.base.BaseTolokaObject):
    """Parameters for input and output data and the task interface.

    Attributes:
        input_spec: The input data parameters for tasks. The complete list of parameters is shown in the
            Input and output data table.
        output_spec: Parameters for output data from the input fields. The complete list of parameters is
            shown in the Input and output data table.
        view_spec: Description of the task interface.
    """

    def __init__(
        self,
        *,
        input_spec: typing.Optional[typing.Dict[str, toloka.client.project.field_spec.FieldSpec]] = None,
        output_spec: typing.Optional[typing.Dict[str, toloka.client.project.field_spec.FieldSpec]] = None,
        view_spec: typing.Optional[toloka.client.project.view_spec.ViewSpec] = None
    ) -> None:
        """Method generated by attrs for class TaskSpec.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    input_spec: typing.Optional[typing.Dict[str, toloka.client.project.field_spec.FieldSpec]]
    output_spec: typing.Optional[typing.Dict[str, toloka.client.project.field_spec.FieldSpec]]
    view_spec: typing.Optional[toloka.client.project.view_spec.ViewSpec]
