__all__ = [
    'ViewSpec',
    'ClassicViewSpec',
    'TemplateBuilderViewSpec',
]
import toloka.client.primitives.base
import toloka.client.project.template_builder
import toloka.client.project.template_builder.base
import toloka.util._extendable_enum
import typing


class ViewSpec(toloka.client.primitives.base.BaseTolokaObject):
    """Description of the task interface
    """

    class Type(toloka.util._extendable_enum.ExtendableStrEnum):
        """A view spec type

        Attributes:
            CLASSIC: A view defined with HTML, CSS and JS
            TEMPLATE_BUILDER: A view defined with template builder components
        """

        CLASSIC = 'classic'
        TEMPLATE_BUILDER = 'tb'

    class Settings(toloka.client.primitives.base.BaseTolokaObject):
        """ViewSpec Settings

        Attributes:
            show_finish: Show the Back to main page button.
            show_fullscreen: Show the Expand to fullscreen button.
            show_instructions: Show the Instructions button.
            show_message: Show the Message for the requester button.
            show_reward: Show the price per task page.
            show_skip: Show the Skip button.
            show_submit: Show the Next button.
            show_timer: Show the timer.
            show_title: Show the project name in task titles.
        """

        def __init__(
            self,
            *,
            show_finish: typing.Optional[bool] = None,
            show_fullscreen: typing.Optional[bool] = None,
            show_instructions: typing.Optional[bool] = None,
            show_message: typing.Optional[bool] = None,
            show_reward: typing.Optional[bool] = None,
            show_skip: typing.Optional[bool] = None,
            show_submit: typing.Optional[bool] = None,
            show_timer: typing.Optional[bool] = None,
            show_title: typing.Optional[bool] = None
        ) -> None:
            """Method generated by attrs for class ViewSpec.Settings.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        show_finish: typing.Optional[bool]
        show_fullscreen: typing.Optional[bool]
        show_instructions: typing.Optional[bool]
        show_message: typing.Optional[bool]
        show_reward: typing.Optional[bool]
        show_skip: typing.Optional[bool]
        show_submit: typing.Optional[bool]
        show_timer: typing.Optional[bool]
        show_title: typing.Optional[bool]

    def __init__(self, *, settings: typing.Optional[Settings] = None) -> None:
        """Method generated by attrs for class ViewSpec.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    settings: typing.Optional[Settings]


class ClassicViewSpec(ViewSpec):
    """A classic view specification defined with HTML, CSS and JS.
    For more information, see [Toloka Requester's guide](https://toloka.ai/docs/guide/)

    Attributes:
        script: JavaScript interface for the task.
        markup: Task interface.
        styles: CSS task interface.
        assets: Linked files such as:
            * CSS styles
            * JavaScript libraries
            * Toloka assets with the $TOLOKA_ASSETS prefix
            Add items in the order they should be linked when running the task interface.
    """

    class Assets(toloka.client.primitives.base.BaseTolokaObject):
        """Linked files with assets.

        Attributes:
            style_urls: Links to CSS libraries.
            script_urls: Links to JavaScript libraries and Toloka assets.
                Toloka assets:
                * "$TOLOKA_ASSETS/js/toloka-handlebars-templates.js" — Handlebars. See the description on the template
                    engine website [here](http://handlebarsjs.com/)
                * "$TOLOKA_ASSETS/js/image-annotation.js" — Image labeling interface. See image with area selection in
                    the Requester's guide [here](https://toloka.ai/docs/guide/concepts/t-components/image-annotation.html)
                Note that the image labeling interface should only be connected together with the Handlebars helpers.
                The order of connection matters.

        Examples:
            >>> from toloka.client.project.view_spec import ClassicViewSpec
            >>> view_spec = ClassicViewSpec(
            >>>     ...,
            >>>     assets = ClassicViewSpec.Assets(
            >>>         script_utls = [
            >>>             "$TOLOKA_ASSETS/js/toloka-handlebars-templates.js",
            >>>             "$TOLOKA_ASSETS/js/image-annotation.js",
            >>>         ]
            >>>     )
            >>> )
        """

        def __init__(
            self,
            *,
            style_urls: typing.Optional[typing.List[str]] = None,
            script_urls: typing.Optional[typing.List[str]] = None
        ) -> None:
            """Method generated by attrs for class ClassicViewSpec.Assets.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        style_urls: typing.Optional[typing.List[str]]
        script_urls: typing.Optional[typing.List[str]]

    def __init__(
        self,
        *,
        settings: typing.Optional[ViewSpec.Settings] = None,
        script: typing.Optional[str] = None,
        markup: typing.Optional[str] = None,
        styles: typing.Optional[str] = None,
        assets: typing.Optional[Assets] = None
    ) -> None:
        """Method generated by attrs for class ClassicViewSpec.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    settings: typing.Optional[ViewSpec.Settings]
    script: typing.Optional[str]
    markup: typing.Optional[str]
    styles: typing.Optional[str]
    assets: typing.Optional[Assets]


class TemplateBuilderViewSpec(ViewSpec):
    """A template builder view specification that defines an interface with
    template builder components

    Attributes:
        view:
        plugins:
        vars:
        core_version: Default template components version. Most likely you do not need to change this parameter.
        infer_data_spec: You can configure the data specification automatically or manually. You can change the way the
            specification is configured using the infer_data_spec option:
            * True – The specifications of input and output data are generated automatically depending on the task interface settings.
            * False – You can configure the specification manually. In this case, automatic detection of input and output data doesn't work.
                You may need to enable this option if:
                * You don't want the specification version to be affected by changes in the instructions or other project fields.
                * You have fields that you need but they become optional or are deleted after automatic generation.


    Example:
        How to declare simple interface:

        >>> import toloka.client.project.template_builder as tb
        >>> project_interface = toloka.project.view_spec.TemplateBuilderViewSpec(
        >>>     view=tb.view.ListViewV1(
        >>>         items=[header, output_field, radiobuttons],
        >>>         validation=some_validation,
        >>>     ),
        >>>     plugins=[plugin1, plugin2]
        >>> )
        >>> # add 'project_interface' to 'toloka.project.Project' instance
        ...
    """

    def unstructure(self): ...

    @classmethod
    def structure(cls, data: dict): ...

    @typing.overload
    def __init__(
        self,
        *,
        settings: typing.Optional[ViewSpec.Settings] = None,
        config: typing.Optional[toloka.client.project.template_builder.TemplateBuilder] = None,
        core_version: typing.Optional[str] = '1.0.0',
        infer_data_spec: typing.Optional[bool] = False
    ) -> None:
        """Method generated by attrs for class TemplateBuilderViewSpec.
        """
        ...

    @typing.overload
    def __init__(
        self,
        *,
        settings: typing.Optional[ViewSpec.Settings] = None,
        view: typing.Optional[toloka.client.project.template_builder.base.BaseComponent] = None,
        plugins: typing.Optional[typing.List[toloka.client.project.template_builder.base.BaseComponent]] = None,
        vars: typing.Optional[typing.Dict[str, typing.Any]] = None,
        core_version: typing.Optional[str] = '1.0.0',
        infer_data_spec: typing.Optional[bool] = False
    ) -> None:
        """Method generated by attrs for class TemplateBuilderViewSpec.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    settings: typing.Optional[ViewSpec.Settings]
    config: typing.Optional[toloka.client.project.template_builder.TemplateBuilder]
    core_version: typing.Optional[str]
    infer_data_spec: typing.Optional[bool]
