__all__ = [
    'SortItemSelf',
    'SortItemsSelf',
    'SortOrder',
    'BaseSortItem',
    'BaseSortItems',
    'SearchRequestMetaclass',
    'BaseSearchRequest',
    'ProjectSearchRequest',
    'ProjectSortItems',
    'PoolSearchRequest',
    'PoolSortItems',
    'TrainingSearchRequest',
    'TrainingSortItems',
    'SkillSearchRequest',
    'SkillSortItems',
    'AssignmentSearchRequest',
    'AssignmentSortItems',
    'AggregatedSolutionSearchRequest',
    'AggregatedSolutionSortItems',
    'TaskSearchRequest',
    'TaskSortItems',
    'TaskSuiteSearchRequest',
    'TaskSuiteSortItems',
    'AttachmentSearchRequest',
    'AttachmentSortItems',
    'UserSkillSearchRequest',
    'UserSkillSortItems',
    'UserRestrictionSearchRequest',
    'UserRestrictionSortItems',
    'UserBonusSearchRequest',
    'UserBonusSortItems',
    'MessageThreadSearchRequest',
    'MessageThreadSortItems',
    'WebhookSubscriptionSearchRequest',
    'WebhookSubscriptionSortItems',
    'OperationSearchRequest',
    'OperationSortItems',
    'AppProjectSearchRequest',
    'AppProjectSortItems',
    'AppSearchRequest',
    'AppSortItems',
    'AppItemSearchRequest',
    'AppItemSortItems',
    'AppBatchSearchRequest',
    'AppBatchSortItems',
]
import datetime
import enum
import toloka.client.app
import toloka.client.assignment
import toloka.client.attachment
import toloka.client.message_thread
import toloka.client.operations
import toloka.client.pool
import toloka.client.primitives.base
import toloka.client.project
import toloka.client.training
import toloka.client.user_restriction
import toloka.client.webhook_subscription
import typing


SortItemSelf = typing.TypeVar('SortItemSelf', bound='BaseSortItem')

SortItemsSelf = typing.TypeVar('SortItemsSelf', bound='BaseSortItems')

class SortOrder(enum.Enum):
    """An enumeration.
    """

    ASCENDING = 1
    DESCENDING = 2


class BaseSortItem(toloka.client.primitives.base.BaseTolokaObject):
    def unstructure(self): ...

    @classmethod
    def structure(cls: typing.Type[SortItemSelf], value: typing.Union[SortItemSelf, str]) -> SortItemSelf: ...

    @classmethod
    def for_fields(
        cls,
        qualname: str,
        sort_fields: typing.List[str]
    ): ...

    def __init__(self) -> None:
        """Method generated by attrs for class BaseSortItem.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]


class BaseSortItems(toloka.client.primitives.base.BaseTolokaObject):
    def unstructure(self): ...

    @classmethod
    def structure(cls, items): ...

    @classmethod
    def for_fields(
        cls,
        qualname: str,
        sort_fields: typing.List[str],
        docstring: typing.Optional[str] = None
    ): ...

    def __init__(self) -> None:
        """Method generated by attrs for class BaseSortItems.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]


class SearchRequestMetaclass(toloka.client.primitives.base.BaseTolokaObjectMetaclass):
    @staticmethod
    def __new__(
        mcs,
        name,
        bases,
        namespace,
        kw_only=False,
        **kwargs
    ): ...


class BaseSearchRequest(toloka.client.primitives.base.BaseTolokaObject, metaclass=SearchRequestMetaclass):
    """Base class for all search request classes
    """

    class CompareFields:
        ...

    def __init__(self) -> None:
        """Method generated by attrs for class BaseSearchRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]


class ProjectSearchRequest(BaseSearchRequest):
    """Parameters for searching projects.

    Attributes:
        status: Project status.
                Refer to the [ProjectStatus](toloka.client.project.Project.ProjectStatus.md) page for more information on the available `status` values.
        id_lt: Projects with IDs less than the specified value.
        id_lte: Projects with IDs less than or equal to the specified value.
        id_gt: Projects with IDs greater than the specified value.
        id_gte: Projects with IDs greater than or equal to the specified value.
        created_lt: Projects created before the specified date.
        created_lte: Projects created before or on the specified date.
        created_gt: Projects created after the specified date.
        created_gte: Projects created after or on the specified date.
    """

    class CompareFields:
        id: str
        created: datetime.datetime

    def __init__(
        self,
        status: typing.Optional[toloka.client.project.Project.ProjectStatus] = None,
        id_lt: typing.Optional[str] = None,
        id_lte: typing.Optional[str] = None,
        id_gt: typing.Optional[str] = None,
        id_gte: typing.Optional[str] = None,
        created_lt: typing.Optional[datetime.datetime] = None,
        created_lte: typing.Optional[datetime.datetime] = None,
        created_gt: typing.Optional[datetime.datetime] = None,
        created_gte: typing.Optional[datetime.datetime] = None
    ) -> None:
        """Method generated by attrs for class ProjectSearchRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    status: typing.Optional[toloka.client.project.Project.ProjectStatus]
    id_lt: typing.Optional[str]
    id_lte: typing.Optional[str]
    id_gt: typing.Optional[str]
    id_gte: typing.Optional[str]
    created_lt: typing.Optional[datetime.datetime]
    created_lte: typing.Optional[datetime.datetime]
    created_gt: typing.Optional[datetime.datetime]
    created_gte: typing.Optional[datetime.datetime]


class ProjectSortItems(BaseSortItems):
    """Keys for sorting projects in search results.

    Attributes:
        items: A list of sorting keys. Supported values:
            * `'id'` — A project ID.
            * `'created'` — A project creation date.
            * `'public_name'` — A project name.
            * `'private_comment'` — A project private comment.

    Example:
        The example shows how to find active projects sorted by names in descending order. Projects with equal names are sorted by IDs in ascending order.

        >>> sort = toloka.client.search_requests.ProjectSortItems(['-public_name', 'id'])
        >>> result = toloka_client.find_projects(status='ACTIVE', sort=sort, limit=50)
        ...
    """

    class SortItem(BaseSortItem):
        class SortField(enum.Enum):
            """An enumeration.
            """

            ID = 'id'
            CREATED = 'created'
            PUBLIC_NAME = 'public_name'
            PRIVATE_COMMENT = 'private_comment'

        def __init__(
            self,
            field: typing.Optional[SortField] = None,
            order: typing.Optional[SortOrder] = SortOrder.ASCENDING
        ) -> None:
            """Method generated by attrs for class ProjectSortItems.SortItem.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        field: typing.Optional[SortField]
        order: typing.Optional[SortOrder]

    def __init__(self, items=None) -> None:
        """Method generated by attrs for class ProjectSortItems.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[SortItem]]


class PoolSearchRequest(BaseSearchRequest):
    """Parameters for searching pools.

    Attributes:
        status: Pool status. Refer to the [Pool.Status](toloka.client.pool.Pool.Status.md) page for more information on the available `status` values.
        project_id: Pools belonging to the project with the specified ID.
        id_lt: Pools with IDs less than the specified value.
        id_lte: Pools with IDs less than or equal to the specified value.
        id_gt: Pools with IDs greater than the specified value.
        id_gte: Pools with IDs greater than or equal to the specified value.
        created_lt: Pools created before the specified date.
        created_lte: Pools created before or on the specified date.
        created_gt: Pools created after the specified date.
        created_gte: Pools created after or on the specified date.
        last_started_lt: Pools that were opened last time before the specified date.
        last_started_lte: Pools that were opened last time before or on the specified date.
        last_started_gt: Pools that were opened last time after the specified date.
        last_started_gte: Pools that were opened last time after or on the specified date.
    """

    class CompareFields:
        id: str
        created: datetime.datetime
        last_started: datetime.datetime

    def __init__(
        self,
        status: typing.Optional[toloka.client.pool.Pool.Status] = None,
        project_id: typing.Optional[str] = None,
        id_lt: typing.Optional[str] = None,
        id_lte: typing.Optional[str] = None,
        id_gt: typing.Optional[str] = None,
        id_gte: typing.Optional[str] = None,
        created_lt: typing.Optional[datetime.datetime] = None,
        created_lte: typing.Optional[datetime.datetime] = None,
        created_gt: typing.Optional[datetime.datetime] = None,
        created_gte: typing.Optional[datetime.datetime] = None,
        last_started_lt: typing.Optional[datetime.datetime] = None,
        last_started_lte: typing.Optional[datetime.datetime] = None,
        last_started_gt: typing.Optional[datetime.datetime] = None,
        last_started_gte: typing.Optional[datetime.datetime] = None
    ) -> None:
        """Method generated by attrs for class PoolSearchRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    status: typing.Optional[toloka.client.pool.Pool.Status]
    project_id: typing.Optional[str]
    id_lt: typing.Optional[str]
    id_lte: typing.Optional[str]
    id_gt: typing.Optional[str]
    id_gte: typing.Optional[str]
    created_lt: typing.Optional[datetime.datetime]
    created_lte: typing.Optional[datetime.datetime]
    created_gt: typing.Optional[datetime.datetime]
    created_gte: typing.Optional[datetime.datetime]
    last_started_lt: typing.Optional[datetime.datetime]
    last_started_lte: typing.Optional[datetime.datetime]
    last_started_gt: typing.Optional[datetime.datetime]
    last_started_gte: typing.Optional[datetime.datetime]


class PoolSortItems(BaseSortItems):
    """Keys for sorting pools in search results.

    Attributes:
        items: A list of sorting keys. Supported values:
            * `'id'` — A pool ID.
            * `'created'` — A pool creation date.
            * `'last_started'` — The last opening date of a pool.

    Example:
        The example shows how to find opened pools sorted by the last opening date in descending order. Pools with equal opening dates are sorted by IDs in ascending order.

        >>> sort = toloka.client.search_requests.PoolSortItems(['-last_started', 'id'])
        >>> result = toloka_client.find_pools(status='OPEN', sort=sort, limit=50)
        ...
    """

    class SortItem(BaseSortItem):
        class SortField(enum.Enum):
            """An enumeration.
            """

            ID = 'id'
            CREATED = 'created'
            LAST_STARTED = 'last_started'

        def __init__(
            self,
            field: typing.Optional[SortField] = None,
            order: typing.Optional[SortOrder] = SortOrder.ASCENDING
        ) -> None:
            """Method generated by attrs for class PoolSortItems.SortItem.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        field: typing.Optional[SortField]
        order: typing.Optional[SortOrder]

    def __init__(self, items=None) -> None:
        """Method generated by attrs for class PoolSortItems.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[SortItem]]


class TrainingSearchRequest(BaseSearchRequest):
    """Parameters for searching training pools.

    Attributes:
        status: Training pool status.
                Refer to the [Training.Status](toloka.client.training.Training.Status.md) page for more information on the available `status` values.
        project_id: Training pools belonging to the project with the specified ID.
        id_lt: Training pools with IDs less than the specified value.
        id_lte: Training pools with IDs less than or equal to the specified value.
        id_gt: Training pools with IDs greater than the specified value.
        id_gte: Training pools with IDs greater than or equal to the specified value.
        created_lt: Training pools created before the specified date.
        created_lte: Training pools created before or on the specified date.
        created_gt: Training pools created after the specified date.
        created_gte: Training pools created after or on the specified date.
        last_started_lt: Training pools that were opened last time before the specified date.
        last_started_lte: Training pools that were opened last time before or on the specified date.
        last_started_gt: Training pools that were opened last time after the specified date.
        last_started_gte: Training pools that were opened last time after or on the specified date.
    """

    class CompareFields:
        id: str
        created: datetime.datetime
        last_started: datetime.datetime

    def __init__(
        self,
        status: typing.Optional[toloka.client.training.Training.Status] = None,
        project_id: typing.Optional[str] = None,
        id_lt: typing.Optional[str] = None,
        id_lte: typing.Optional[str] = None,
        id_gt: typing.Optional[str] = None,
        id_gte: typing.Optional[str] = None,
        created_lt: typing.Optional[datetime.datetime] = None,
        created_lte: typing.Optional[datetime.datetime] = None,
        created_gt: typing.Optional[datetime.datetime] = None,
        created_gte: typing.Optional[datetime.datetime] = None,
        last_started_lt: typing.Optional[datetime.datetime] = None,
        last_started_lte: typing.Optional[datetime.datetime] = None,
        last_started_gt: typing.Optional[datetime.datetime] = None,
        last_started_gte: typing.Optional[datetime.datetime] = None
    ) -> None:
        """Method generated by attrs for class TrainingSearchRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    status: typing.Optional[toloka.client.training.Training.Status]
    project_id: typing.Optional[str]
    id_lt: typing.Optional[str]
    id_lte: typing.Optional[str]
    id_gt: typing.Optional[str]
    id_gte: typing.Optional[str]
    created_lt: typing.Optional[datetime.datetime]
    created_lte: typing.Optional[datetime.datetime]
    created_gt: typing.Optional[datetime.datetime]
    created_gte: typing.Optional[datetime.datetime]
    last_started_lt: typing.Optional[datetime.datetime]
    last_started_lte: typing.Optional[datetime.datetime]
    last_started_gt: typing.Optional[datetime.datetime]
    last_started_gte: typing.Optional[datetime.datetime]


class TrainingSortItems(BaseSortItems):
    """Keys for sorting training pools in search results.

    Attributes:
        items: A list of sorting keys. Supported values:
            * `'id'` — Training pool ID.
            * `'created'` — Training pool creation date.
            * `'last_started'` — The last opening date of a training pool.

    Example:
        The example shows how to find opened training pools sorted by the last opening date in descending order. Pools with equal opening dates are sorted by IDs in ascending order.

        >>> sort = toloka.client.search_requests.TrainingSortItems(['-last_started', 'id'])
        >>> result = toloka_client.find_trainings(status='OPEN', sort=sort, limit=50)
        ...
    """

    class SortItem(BaseSortItem):
        class SortField(enum.Enum):
            """An enumeration.
            """

            ID = 'id'
            CREATED = 'created'
            LAST_STARTED = 'last_started'

        def __init__(
            self,
            field: typing.Optional[SortField] = None,
            order: typing.Optional[SortOrder] = SortOrder.ASCENDING
        ) -> None:
            """Method generated by attrs for class TrainingSortItems.SortItem.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        field: typing.Optional[SortField]
        order: typing.Optional[SortOrder]

    def __init__(self, items=None) -> None:
        """Method generated by attrs for class TrainingSortItems.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[SortItem]]


class SkillSearchRequest(BaseSearchRequest):
    """Parameters for searching skill.

    Attributes:
        name: The name of the skill.
        id_lt: Skills with IDs less than the specified value.
        id_lte: Skills with IDs less than or equal to the specified value.
        id_gt: Skills with IDs greater than the specified value.
        id_gte: Skills with IDs greater than or equal to the specified value.
        created_lt: Skills created before the specified date.
        created_lte: Skills created before or on the specified date.
        created_gt: Skills created after the specified date.
        created_gte: Skills created on or after the specified date.
    """

    class CompareFields:
        id: str
        created: datetime.datetime

    def __init__(
        self,
        name: typing.Optional[str] = None,
        id_lt: typing.Optional[str] = None,
        id_lte: typing.Optional[str] = None,
        id_gt: typing.Optional[str] = None,
        id_gte: typing.Optional[str] = None,
        created_lt: typing.Optional[datetime.datetime] = None,
        created_lte: typing.Optional[datetime.datetime] = None,
        created_gt: typing.Optional[datetime.datetime] = None,
        created_gte: typing.Optional[datetime.datetime] = None
    ) -> None:
        """Method generated by attrs for class SkillSearchRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    name: typing.Optional[str]
    id_lt: typing.Optional[str]
    id_lte: typing.Optional[str]
    id_gt: typing.Optional[str]
    id_gte: typing.Optional[str]
    created_lt: typing.Optional[datetime.datetime]
    created_lte: typing.Optional[datetime.datetime]
    created_gt: typing.Optional[datetime.datetime]
    created_gte: typing.Optional[datetime.datetime]


class SkillSortItems(BaseSortItems):
    """Keys for sorting skills in search results.

    Attributes:
        items: A list of sorting keys. Supported values:
            * `'id'` — The ID of a skill.
            * `'created'` — A skill creation date.

    Example:
        The example shows how to find skills sorted by creation date in descending order. Skills with equal creation dates are sorted by IDs in ascending order.

        >>> sort = toloka.client.search_requests.SkillSortItems(['-created', 'id'])
        >>> result = toloka_client.find_skills(name='Image annotation', sort=sort, limit=10)
        ...
    """

    class SortItem(BaseSortItem):
        class SortField(enum.Enum):
            """An enumeration.
            """

            ID = 'id'
            CREATED = 'created'

        def __init__(
            self,
            field: typing.Optional[SortField] = None,
            order: typing.Optional[SortOrder] = SortOrder.ASCENDING
        ) -> None:
            """Method generated by attrs for class SkillSortItems.SortItem.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        field: typing.Optional[SortField]
        order: typing.Optional[SortOrder]

    def __init__(self, items=None) -> None:
        """Method generated by attrs for class SkillSortItems.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[SortItem]]


class AssignmentSearchRequest(BaseSearchRequest):
    """Parameters for searching task suites assignments.

    Attributes:
        status: Assignment status or a list of statuses.
                Refer to the [Assignment.Status](toloka.client.assignment.Assignment.Status.md) page
                for more information on the available `status` values.
        task_id: Assignments containing the task with the specified ID.
        task_suite_id: Assignments for a task suite with the specified ID.
        pool_id: Assignments in a pool with the specified ID.
        user_id: Assignments from a Toloker with the specified ID.
        id_lt: Assignments with IDs less than the specified value.
        id_lte: Assignments with IDs less than or equal to the specified value.
        id_gt: Assignments with IDs greater than the specified value.
        id_gte: Assignments with IDs greater than or equal to the specified value.
        created_lt: Task suites assigned before the specified date.
        created_lte: Task suites assigned before or on the specified date.
        created_gt: Task suites assigned after the specified date.
        created_gte: Task suites assigned after or on the specified date.
        submitted_lt: Assignments completed before the specified date.
        submitted_lte: Assignments completed before or on the specified date.
        submitted_gt: Assignments completed after the specified date.
        submitted_gte: Assignments completed after or on the specified date.
        accepted_lt: Assignments accepted before the specified date.
        accepted_lte: Assignments accepted before or on the specified date.
        accepted_gt: Assignments accepted after the specified date.
        accepted_gte: Assignments accepted after or on the specified date.
        rejected_lt: Assignments rejected before the specified date.
        rejected_lte: Assignments rejected before or on the specified date.
        rejected_gt: Assignments rejected after the specified date.
        rejected_gte: Assignments rejected after or on the specified date.
        skipped_lt: Assigned task suites skipped before the specified date.
        skipped_lte: Assigned task suites skipped before or on the specified date.
        skipped_gt: Assigned task suites skipped after the specified date.
        skipped_gte: Assigned task suites skipped after or on the specified date.
        expired_lt: Assigned task suites expired before the specified date.
        expired_lte: Assigned task suites expired before or on the specified date.
        expired_gt: Assigned task suites expired after the specified date.
        expired_gte: Assigned task suites expired after or on the specified date.
    """

    class CompareFields:
        id: str
        created: datetime.datetime
        submitted: datetime.datetime
        accepted: datetime.datetime
        rejected: datetime.datetime
        skipped: datetime.datetime
        expired: datetime.datetime

    def unstructure(self) -> typing.Optional[dict]: ...

    def __init__(
        self,
        status: typing.Union[str, toloka.client.assignment.Assignment.Status, typing.List[typing.Union[str, toloka.client.assignment.Assignment.Status]]] = None,
        task_id: typing.Optional[str] = None,
        task_suite_id: typing.Optional[str] = None,
        pool_id: typing.Optional[str] = None,
        user_id: typing.Optional[str] = None,
        id_lt: typing.Optional[str] = None,
        id_lte: typing.Optional[str] = None,
        id_gt: typing.Optional[str] = None,
        id_gte: typing.Optional[str] = None,
        created_lt: typing.Optional[datetime.datetime] = None,
        created_lte: typing.Optional[datetime.datetime] = None,
        created_gt: typing.Optional[datetime.datetime] = None,
        created_gte: typing.Optional[datetime.datetime] = None,
        submitted_lt: typing.Optional[datetime.datetime] = None,
        submitted_lte: typing.Optional[datetime.datetime] = None,
        submitted_gt: typing.Optional[datetime.datetime] = None,
        submitted_gte: typing.Optional[datetime.datetime] = None,
        accepted_lt: typing.Optional[datetime.datetime] = None,
        accepted_lte: typing.Optional[datetime.datetime] = None,
        accepted_gt: typing.Optional[datetime.datetime] = None,
        accepted_gte: typing.Optional[datetime.datetime] = None,
        rejected_lt: typing.Optional[datetime.datetime] = None,
        rejected_lte: typing.Optional[datetime.datetime] = None,
        rejected_gt: typing.Optional[datetime.datetime] = None,
        rejected_gte: typing.Optional[datetime.datetime] = None,
        skipped_lt: typing.Optional[datetime.datetime] = None,
        skipped_lte: typing.Optional[datetime.datetime] = None,
        skipped_gt: typing.Optional[datetime.datetime] = None,
        skipped_gte: typing.Optional[datetime.datetime] = None,
        expired_lt: typing.Optional[datetime.datetime] = None,
        expired_lte: typing.Optional[datetime.datetime] = None,
        expired_gt: typing.Optional[datetime.datetime] = None,
        expired_gte: typing.Optional[datetime.datetime] = None
    ) -> None:
        """Method generated by attrs for class AssignmentSearchRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    status: typing.Optional[typing.List[toloka.client.assignment.Assignment.Status]]
    task_id: typing.Optional[str]
    task_suite_id: typing.Optional[str]
    pool_id: typing.Optional[str]
    user_id: typing.Optional[str]
    id_lt: typing.Optional[str]
    id_lte: typing.Optional[str]
    id_gt: typing.Optional[str]
    id_gte: typing.Optional[str]
    created_lt: typing.Optional[datetime.datetime]
    created_lte: typing.Optional[datetime.datetime]
    created_gt: typing.Optional[datetime.datetime]
    created_gte: typing.Optional[datetime.datetime]
    submitted_lt: typing.Optional[datetime.datetime]
    submitted_lte: typing.Optional[datetime.datetime]
    submitted_gt: typing.Optional[datetime.datetime]
    submitted_gte: typing.Optional[datetime.datetime]
    accepted_lt: typing.Optional[datetime.datetime]
    accepted_lte: typing.Optional[datetime.datetime]
    accepted_gt: typing.Optional[datetime.datetime]
    accepted_gte: typing.Optional[datetime.datetime]
    rejected_lt: typing.Optional[datetime.datetime]
    rejected_lte: typing.Optional[datetime.datetime]
    rejected_gt: typing.Optional[datetime.datetime]
    rejected_gte: typing.Optional[datetime.datetime]
    skipped_lt: typing.Optional[datetime.datetime]
    skipped_lte: typing.Optional[datetime.datetime]
    skipped_gt: typing.Optional[datetime.datetime]
    skipped_gte: typing.Optional[datetime.datetime]
    expired_lt: typing.Optional[datetime.datetime]
    expired_lte: typing.Optional[datetime.datetime]
    expired_gt: typing.Optional[datetime.datetime]
    expired_gte: typing.Optional[datetime.datetime]


class AssignmentSortItems(BaseSortItems):
    """Keys for sorting assignments in search results.

    Attributes:
        items: A list of sorting keys. Supported values:
            * `'id'` — An assignment ID.
            * `'created'` — The assigning date of a task suite.
            * `'submitted'` — The completion date of a task suite.
            * `'accepted'` — The acceptance date of a task suite.
            * `'rejected'` — The rejection date a task suite.
            * `'skipped'` — The date when a task suite was skipped.
            * `'expired'` — The expiration date of a task suite.

    Example:
        The example shows how to find assignments sorted by the completion date in descending order. Assignments with equal completion dates are sorted by IDs in ascending order.

        >>> sort = toloka.client.search_requests.AssignmentSortItems(['-submitted', 'id'])
        >>> result = toloka_client.find_assignments(status='SUBMITTED', sort=sort, limit=10)
        ...
    """

    class SortItem(BaseSortItem):
        class SortField(enum.Enum):
            """An enumeration.
            """

            ID = 'id'
            CREATED = 'created'
            SUBMITTED = 'submitted'
            ACCEPTED = 'accepted'
            REJECTED = 'rejected'
            SKIPPED = 'skipped'
            EXPIRED = 'expired'

        def __init__(
            self,
            field: typing.Optional[SortField] = None,
            order: typing.Optional[SortOrder] = SortOrder.ASCENDING
        ) -> None:
            """Method generated by attrs for class AssignmentSortItems.SortItem.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        field: typing.Optional[SortField]
        order: typing.Optional[SortOrder]

    def __init__(self, items=None) -> None:
        """Method generated by attrs for class AssignmentSortItems.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[SortItem]]


class AggregatedSolutionSearchRequest(BaseSearchRequest):
    """Parameters for searching aggregated responses.

    Attributes:
        task_id_lt: Responses for tasks with IDs less than the specified value.
        task_id_lte: Responses for tasks with IDs less than or equal to the specified value.
        task_id_gt: Responses for tasks with IDs greater than the specified value.
        task_id_gte: Responses for tasks with IDs greater than or equal to the specified value.
    """

    class CompareFields:
        task_id: str

    def __init__(
        self,
        task_id_lt: typing.Optional[str] = None,
        task_id_lte: typing.Optional[str] = None,
        task_id_gt: typing.Optional[str] = None,
        task_id_gte: typing.Optional[str] = None
    ) -> None:
        """Method generated by attrs for class AggregatedSolutionSearchRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    task_id_lt: typing.Optional[str]
    task_id_lte: typing.Optional[str]
    task_id_gt: typing.Optional[str]
    task_id_gte: typing.Optional[str]


class AggregatedSolutionSortItems(BaseSortItems):
    """Keys for sorting aggregated responses in search results.

    Attributes:
        items: A list of sorting keys. Supported values:
            * `'task_id'` — The ID of a task.
    """

    class SortItem(BaseSortItem):
        class SortField(enum.Enum):
            """An enumeration.
            """

            TASK_ID = 'task_id'

        def __init__(
            self,
            field: typing.Optional[SortField] = None,
            order: typing.Optional[SortOrder] = SortOrder.ASCENDING
        ) -> None:
            """Method generated by attrs for class AggregatedSolutionSortItems.SortItem.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        field: typing.Optional[SortField]
        order: typing.Optional[SortOrder]

    def __init__(self, items=None) -> None:
        """Method generated by attrs for class AggregatedSolutionSortItems.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[SortItem]]


class TaskSearchRequest(BaseSearchRequest):
    """Parameters for searching tasks.

    Attributes:
        pool_id: The ID of the pool to get tasks from.
        overlap: Tasks with an overlap equal to the specified value.
        id_lt: Tasks with IDs less than the specified value.
        id_lte: Tasks with IDs less than or equal to the specified value.
        id_gt: Tasks with IDs greater than the specified value.
        id_gte: Tasks with IDs greater than or equal to the specified value.
        created_lt: Tasks created before the specified date.
        created_lte: Tasks created before or on the specified date.
        created_gt: Tasks created after the specified date.
        created_gte: Tasks created after or on the specified date.
        overlap_lt: Tasks with an overlap less than the specified value.
        overlap_lte: Tasks with an overlap less than or equal to the specified value.
        overlap_gt: Tasks with an overlap greater than the specified value.
        overlap_gte: Tasks with an overlap greater than or equal to the specified value.
    """

    class CompareFields:
        id: str
        created: datetime.datetime
        overlap: int

    def __init__(
        self,
        pool_id: typing.Optional[str] = None,
        overlap: typing.Optional[int] = None,
        id_lt: typing.Optional[str] = None,
        id_lte: typing.Optional[str] = None,
        id_gt: typing.Optional[str] = None,
        id_gte: typing.Optional[str] = None,
        created_lt: typing.Optional[datetime.datetime] = None,
        created_lte: typing.Optional[datetime.datetime] = None,
        created_gt: typing.Optional[datetime.datetime] = None,
        created_gte: typing.Optional[datetime.datetime] = None,
        overlap_lt: typing.Optional[int] = None,
        overlap_lte: typing.Optional[int] = None,
        overlap_gt: typing.Optional[int] = None,
        overlap_gte: typing.Optional[int] = None
    ) -> None:
        """Method generated by attrs for class TaskSearchRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    pool_id: typing.Optional[str]
    overlap: typing.Optional[int]
    id_lt: typing.Optional[str]
    id_lte: typing.Optional[str]
    id_gt: typing.Optional[str]
    id_gte: typing.Optional[str]
    created_lt: typing.Optional[datetime.datetime]
    created_lte: typing.Optional[datetime.datetime]
    created_gt: typing.Optional[datetime.datetime]
    created_gte: typing.Optional[datetime.datetime]
    overlap_lt: typing.Optional[int]
    overlap_lte: typing.Optional[int]
    overlap_gt: typing.Optional[int]
    overlap_gte: typing.Optional[int]


class TaskSortItems(BaseSortItems):
    """Keys for sorting tasks in search results.

    Attributes:
        items: A list of sorting keys. Supported values:
            * `'id'` — The ID of a task.
            * `'created'` — The creation date of a task.

    Example:
        The example shows how to find tasks sorted by creation dates in descending order. Tasks with equal creation dates are sorted by IDs in ascending order.

        >>> sort = toloka.client.search_requests.TaskSortItems(['-created', 'id'])
        >>> result = toloka_client.find_tasks(pool_id=my_pool_id, sort=sort, limit=10)
        ...
    """

    class SortItem(BaseSortItem):
        class SortField(enum.Enum):
            """An enumeration.
            """

            ID = 'id'
            CREATED = 'created'

        def __init__(
            self,
            field: typing.Optional[SortField] = None,
            order: typing.Optional[SortOrder] = SortOrder.ASCENDING
        ) -> None:
            """Method generated by attrs for class TaskSortItems.SortItem.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        field: typing.Optional[SortField]
        order: typing.Optional[SortOrder]

    def __init__(self, items=None) -> None:
        """Method generated by attrs for class TaskSortItems.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[SortItem]]


class TaskSuiteSearchRequest(BaseSearchRequest):
    """Parameters for searching task suites.

    Attributes:
        task_id: Task suite containing a task with the specified ID.
        pool_id: Task suites from a pool with the specified ID.
        overlap: Task suites with an overlap equal to the specified value.
        id_lt: Task suites with IDs less than the specified value.
        id_lte: Task suites with IDs less than or equal to the specified value.
        id_gt: Task suites with IDs greater than the specified value.
        id_gte: Task suites with IDs greater than or equal to the specified value.
        created_lt: Task suites created before the specified date.
        created_lte: Task suites created before or on the specified date.
        created_gt: Task suites created after the specified date.
        created_gte: Task suites created after or on the specified date.
        overlap_lt: Task suites with an overlap less than the specified value.
        overlap_lte: Task suites with an overlap less than or equal to the specified value.
        overlap_gt: Task suites with an overlap greater than the specified value.
        overlap_gte: Task suites with an overlap greater than or equal to the specified value.
    """

    class CompareFields:
        id: str
        created: datetime.datetime
        overlap: int

    def __init__(
        self,
        task_id: typing.Optional[str] = None,
        pool_id: typing.Optional[str] = None,
        overlap: typing.Optional[int] = None,
        id_lt: typing.Optional[str] = None,
        id_lte: typing.Optional[str] = None,
        id_gt: typing.Optional[str] = None,
        id_gte: typing.Optional[str] = None,
        created_lt: typing.Optional[datetime.datetime] = None,
        created_lte: typing.Optional[datetime.datetime] = None,
        created_gt: typing.Optional[datetime.datetime] = None,
        created_gte: typing.Optional[datetime.datetime] = None,
        overlap_lt: typing.Optional[int] = None,
        overlap_lte: typing.Optional[int] = None,
        overlap_gt: typing.Optional[int] = None,
        overlap_gte: typing.Optional[int] = None
    ) -> None:
        """Method generated by attrs for class TaskSuiteSearchRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    task_id: typing.Optional[str]
    pool_id: typing.Optional[str]
    overlap: typing.Optional[int]
    id_lt: typing.Optional[str]
    id_lte: typing.Optional[str]
    id_gt: typing.Optional[str]
    id_gte: typing.Optional[str]
    created_lt: typing.Optional[datetime.datetime]
    created_lte: typing.Optional[datetime.datetime]
    created_gt: typing.Optional[datetime.datetime]
    created_gte: typing.Optional[datetime.datetime]
    overlap_lt: typing.Optional[int]
    overlap_lte: typing.Optional[int]
    overlap_gt: typing.Optional[int]
    overlap_gte: typing.Optional[int]


class TaskSuiteSortItems(BaseSortItems):
    """Keys for sorting task suites in search results.

    Attributes:
        items: A list of sorting keys. Supported values:
            * `'id'` — The ID of a task suite.
            * `'created'` — The creation date of a task suite.

    Example:
        The example shows how to find task suites sorted by the creation date in descending order. Task suites with equal creation dates are sorted by IDs in ascending order.

        >>> sort = toloka.client.search_requests.TaskSuiteSortItems(['-created', 'id'])
        >>> result = toloka_client.find_task_suites(pool_id=my_pool_id, sort=sort, limit=10)
        ...
    """

    class SortItem(BaseSortItem):
        class SortField(enum.Enum):
            """An enumeration.
            """

            ID = 'id'
            CREATED = 'created'

        def __init__(
            self,
            field: typing.Optional[SortField] = None,
            order: typing.Optional[SortOrder] = SortOrder.ASCENDING
        ) -> None:
            """Method generated by attrs for class TaskSuiteSortItems.SortItem.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        field: typing.Optional[SortField]
        order: typing.Optional[SortOrder]

    def __init__(self, items=None) -> None:
        """Method generated by attrs for class TaskSuiteSortItems.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[SortItem]]


class AttachmentSearchRequest(BaseSearchRequest):
    """Parameters for searching attachments.

    Attributes:
        name: An attachment file name.
        type: An attachment type.
              Refer to the [Attachment.Type](toloka.client.attachment.Attachment.Type.md) page for more information on the available `type` values.
        user_id: The ID of a Toloker who uploaded attachments.
        assignment_id: The ID of an assignment with attachments. Either `assignment_id` of `pool_id` is required in a search request.
        pool_id: The ID of a pool with attachments. Either `assignment_id` of `pool_id` is required in a search request.
        id_lt: Attachments with IDs less than the specified value.
        id_lte: Attachments with IDs less than or equal to the specified value.
        id_gt: Attachments with IDs greater than the specified value.
        id_gte: Attachments with IDs greater than or equal to the specified value.
        created_lt: Attachments uploaded by Tolokers before the specified date.
        created_lte: Attachments uploaded by Tolokers before or on the specified date.
        created_gt: Attachments uploaded by Tolokers after the specified date.
        created_gte: Attachments uploaded by Tolokers after or on the specified date.
    """

    class CompareFields:
        id: str
        created: datetime.datetime

    def __init__(
        self,
        name: typing.Optional[str] = None,
        type: typing.Optional[toloka.client.attachment.Attachment.Type] = None,
        user_id: typing.Optional[str] = None,
        assignment_id: typing.Optional[str] = None,
        pool_id: typing.Optional[str] = None,
        owner_id: typing.Optional[str] = None,
        owner_company_id: typing.Optional[str] = None,
        id_lt: typing.Optional[str] = None,
        id_lte: typing.Optional[str] = None,
        id_gt: typing.Optional[str] = None,
        id_gte: typing.Optional[str] = None,
        created_lt: typing.Optional[datetime.datetime] = None,
        created_lte: typing.Optional[datetime.datetime] = None,
        created_gt: typing.Optional[datetime.datetime] = None,
        created_gte: typing.Optional[datetime.datetime] = None
    ) -> None:
        """Method generated by attrs for class AttachmentSearchRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    name: typing.Optional[str]
    type: typing.Optional[toloka.client.attachment.Attachment.Type]
    user_id: typing.Optional[str]
    assignment_id: typing.Optional[str]
    pool_id: typing.Optional[str]
    owner_id: typing.Optional[str]
    owner_company_id: typing.Optional[str]
    id_lt: typing.Optional[str]
    id_lte: typing.Optional[str]
    id_gt: typing.Optional[str]
    id_gte: typing.Optional[str]
    created_lt: typing.Optional[datetime.datetime]
    created_lte: typing.Optional[datetime.datetime]
    created_gt: typing.Optional[datetime.datetime]
    created_gte: typing.Optional[datetime.datetime]


class AttachmentSortItems(BaseSortItems):
    """Keys for sorting attachments in search results.

    Attributes:
        items: A list of sorting keys. Supported values:
            * `'id'` — The ID of an attachment.
            * `'created'` — The date of uploading an attachment.

    Example:
        The example shows how to find attachments sorted by uploading date in descending order. Attachments with equal uploading dates are sorted by IDs in ascending order.

        >>> sort = toloka.client.search_requests.AttachmentSortItems(['-created', 'id'])
        >>> result = toloka_client.find_attachments(pool_id=my_pool_id, sort=sort, limit=10)
        ...
    """

    class SortItem(BaseSortItem):
        class SortField(enum.Enum):
            """An enumeration.
            """

            ID = 'id'
            CREATED = 'created'

        def __init__(
            self,
            field: typing.Optional[SortField] = None,
            order: typing.Optional[SortOrder] = SortOrder.ASCENDING
        ) -> None:
            """Method generated by attrs for class AttachmentSortItems.SortItem.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        field: typing.Optional[SortField]
        order: typing.Optional[SortOrder]

    def __init__(self, items=None) -> None:
        """Method generated by attrs for class AttachmentSortItems.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[SortItem]]


class UserSkillSearchRequest(BaseSearchRequest):
    """Parameters for searching Toloker skill.

    Attributes:
        user_id: The ID of a Toloker.
        skill_id: The ID of a skill.
        id_lt: Skills with IDs less than the specified value.
        id_lte: Skills with IDs less than or equal to the specified value.
        id_gt: Skills with IDs greater than the specified value.
        id_gte: Skills with IDs greater than or equal to the specified value.
        created_lt: Skills created before the specified date.
        created_lte: Skills created before or on the specified date.
        created_gt: Skills created after the specified date.
        created_gte: Skills created on or after the specified date.
        modified_lt: Skills that changed before the specified date.
        modified_lte: Skills that changed before the specified date.
        modified_gt: Skills changed after the specified date.
        modified_gte: Skills created on or after the specified date.
    """

    class CompareFields:
        id: str
        created: datetime.datetime
        modified: datetime.datetime

    def __init__(
        self,
        user_id: typing.Optional[str] = None,
        skill_id: typing.Optional[str] = None,
        id_lt: typing.Optional[str] = None,
        id_lte: typing.Optional[str] = None,
        id_gt: typing.Optional[str] = None,
        id_gte: typing.Optional[str] = None,
        created_lt: typing.Optional[datetime.datetime] = None,
        created_lte: typing.Optional[datetime.datetime] = None,
        created_gt: typing.Optional[datetime.datetime] = None,
        created_gte: typing.Optional[datetime.datetime] = None,
        modified_lt: typing.Optional[datetime.datetime] = None,
        modified_lte: typing.Optional[datetime.datetime] = None,
        modified_gt: typing.Optional[datetime.datetime] = None,
        modified_gte: typing.Optional[datetime.datetime] = None
    ) -> None:
        """Method generated by attrs for class UserSkillSearchRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    user_id: typing.Optional[str]
    skill_id: typing.Optional[str]
    id_lt: typing.Optional[str]
    id_lte: typing.Optional[str]
    id_gt: typing.Optional[str]
    id_gte: typing.Optional[str]
    created_lt: typing.Optional[datetime.datetime]
    created_lte: typing.Optional[datetime.datetime]
    created_gt: typing.Optional[datetime.datetime]
    created_gte: typing.Optional[datetime.datetime]
    modified_lt: typing.Optional[datetime.datetime]
    modified_lte: typing.Optional[datetime.datetime]
    modified_gt: typing.Optional[datetime.datetime]
    modified_gte: typing.Optional[datetime.datetime]


class UserSkillSortItems(BaseSortItems):
    """Keys for sorting skills in search results.

    Attributes:
        items: A list of sorting keys. Supported values:
            * `'id'` — The ID of a skill.
            * `'created'` — The date when a skill was created.
            * `'modified'` — The date when a skill was modified.

    Example:
        The example shows how to find Tolokers' skills sorted by creation date in descending order. Skills with equal creation dates are sorted by IDs in ascending order.

        >>> sort = toloka.client.search_requests.UserSkillSortItems(['-created', 'id'])
        >>> result = toloka_client.find_user_skills(skill_id=my_useful_skill_id, sort=sort, limit=10)
        ...
    """

    class SortItem(BaseSortItem):
        class SortField(enum.Enum):
            """An enumeration.
            """

            ID = 'id'
            CREATED = 'created'
            MODIFIED = 'modified'

        def __init__(
            self,
            field: typing.Optional[SortField] = None,
            order: typing.Optional[SortOrder] = SortOrder.ASCENDING
        ) -> None:
            """Method generated by attrs for class UserSkillSortItems.SortItem.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        field: typing.Optional[SortField]
        order: typing.Optional[SortOrder]

    def __init__(self, items=None) -> None:
        """Method generated by attrs for class UserSkillSortItems.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[SortItem]]


class UserRestrictionSearchRequest(BaseSearchRequest):
    """Parameters for searching Toloker restrictions.

    Attributes:
        scope: The scope of a restriction.
               Refer to the [UserRestriction.Scope](toloka.client.user_restriction.UserRestriction.Scope.md) page
               for more information on the available `scope` values.
        user_id: The Toloker's ID.
        project_id: The ID of a project with restricted access.
        pool_id: The ID of a pool with restricted access.
        id_lt: Restrictions with IDs less than the specified value.
        id_lte: Restrictions with IDs less than or equal to the specified value.
        id_gt: Restrictions with IDs greater than the specified value.
        id_gte: Restrictions with IDs greater than or equal to the specified value.
        created_lt: Restrictions created before the specified date.
        created_lte: Restrictions created before or on the specified date.
        created_gt: Restrictions created after the specified date.
        created_gte: Restrictions created after or on the specified date.
    """

    class CompareFields:
        id: str
        created: datetime.datetime

    def __init__(
        self,
        scope: typing.Optional[toloka.client.user_restriction.UserRestriction.Scope] = None,
        user_id: typing.Optional[str] = None,
        project_id: typing.Optional[str] = None,
        pool_id: typing.Optional[str] = None,
        id_lt: typing.Optional[str] = None,
        id_lte: typing.Optional[str] = None,
        id_gt: typing.Optional[str] = None,
        id_gte: typing.Optional[str] = None,
        created_lt: typing.Optional[datetime.datetime] = None,
        created_lte: typing.Optional[datetime.datetime] = None,
        created_gt: typing.Optional[datetime.datetime] = None,
        created_gte: typing.Optional[datetime.datetime] = None
    ) -> None:
        """Method generated by attrs for class UserRestrictionSearchRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    scope: typing.Optional[toloka.client.user_restriction.UserRestriction.Scope]
    user_id: typing.Optional[str]
    project_id: typing.Optional[str]
    pool_id: typing.Optional[str]
    id_lt: typing.Optional[str]
    id_lte: typing.Optional[str]
    id_gt: typing.Optional[str]
    id_gte: typing.Optional[str]
    created_lt: typing.Optional[datetime.datetime]
    created_lte: typing.Optional[datetime.datetime]
    created_gt: typing.Optional[datetime.datetime]
    created_gte: typing.Optional[datetime.datetime]


class UserRestrictionSortItems(BaseSortItems):
    """Keys for sorting Toloker restrictions in search results.

    Attributes:
        items: A list of sorting keys. Supported values:
            * `'id'` — The ID of a restriction.
            * `'created'` — The restriction creation date.

    Example:
        The example shows how to find Toloker restrictions sorted by creation date in descending order. Restrictions with equal creation dates are sorted by IDs in ascending order.

        >>> sort = toloka.client.search_requests.UserRestrictionSortItems(['-created', 'id'])
        >>> result = toloka_client.find_user_restrictions(pool_id=my_pretty_pool_id, sort=sort, limit=10)
        ...
    """

    class SortItem(BaseSortItem):
        class SortField(enum.Enum):
            """An enumeration.
            """

            ID = 'id'
            CREATED = 'created'

        def __init__(
            self,
            field: typing.Optional[SortField] = None,
            order: typing.Optional[SortOrder] = SortOrder.ASCENDING
        ) -> None:
            """Method generated by attrs for class UserRestrictionSortItems.SortItem.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        field: typing.Optional[SortField]
        order: typing.Optional[SortOrder]

    def __init__(self, items=None) -> None:
        """Method generated by attrs for class UserRestrictionSortItems.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[SortItem]]


class UserBonusSearchRequest(BaseSearchRequest):
    """Parameters for searching Tolokers' rewards.

    Attributes:
        user_id: The ID of a Toloker.
        assignment_id: The ID of an assignment a reward was granted for.
        private_comment: Rewards with specified comment.
        id_lt: Rewards with IDs less than the specified value.
        id_lte: Rewards with IDs less than or equal to the specified value.
        id_gt: Rewards with IDs greater than the specified value.
        id_gte: Rewards with IDs greater than or equal to the specified value.
        created_lt: Rewards given before the specified date.
        created_lte: Rewards given before or on the specified date.
        created_gt: Rewards given after the specified date.
        created_gte: Rewards given after or on the specified date.
    """

    class CompareFields:
        id: str
        created: datetime.datetime

    def __init__(
        self,
        user_id: typing.Optional[str] = None,
        assignment_id: typing.Optional[str] = None,
        private_comment: typing.Optional[str] = None,
        id_lt: typing.Optional[str] = None,
        id_lte: typing.Optional[str] = None,
        id_gt: typing.Optional[str] = None,
        id_gte: typing.Optional[str] = None,
        created_lt: typing.Optional[datetime.datetime] = None,
        created_lte: typing.Optional[datetime.datetime] = None,
        created_gt: typing.Optional[datetime.datetime] = None,
        created_gte: typing.Optional[datetime.datetime] = None
    ) -> None:
        """Method generated by attrs for class UserBonusSearchRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    user_id: typing.Optional[str]
    assignment_id: typing.Optional[str]
    private_comment: typing.Optional[str]
    id_lt: typing.Optional[str]
    id_lte: typing.Optional[str]
    id_gt: typing.Optional[str]
    id_gte: typing.Optional[str]
    created_lt: typing.Optional[datetime.datetime]
    created_lte: typing.Optional[datetime.datetime]
    created_gt: typing.Optional[datetime.datetime]
    created_gte: typing.Optional[datetime.datetime]


class UserBonusSortItems(BaseSortItems):
    """Keys for sorting rewards in search results.

    Attributes:
        items: A list of sorting keys. Supported values:
            * `'id'` — The ID of a reward.
            * `'created'` — The date of granting a reward.

    Example:
        The example shows how to find rewards sorted by granting date in descending order. Rewards with equal granting dates are sorted by IDs in ascending order.

        >>> sort = toloka.client.search_requests.UserBonusSortItems(['-created', 'id'])
        >>> result = toloka_client.find_user_bonuses(user_id=best_toloker_id, sort=sort, limit=10)
        ...
    """

    class SortItem(BaseSortItem):
        class SortField(enum.Enum):
            """An enumeration.
            """

            ID = 'id'
            CREATED = 'created'

        def __init__(
            self,
            field: typing.Optional[SortField] = None,
            order: typing.Optional[SortOrder] = SortOrder.ASCENDING
        ) -> None:
            """Method generated by attrs for class UserBonusSortItems.SortItem.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        field: typing.Optional[SortField]
        order: typing.Optional[SortOrder]

    def __init__(self, items=None) -> None:
        """Method generated by attrs for class UserBonusSortItems.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[SortItem]]


class MessageThreadSearchRequest(BaseSearchRequest):
    """Parameters for searching message threads.

    Attributes:
        folder: A folder where to search threads or a list of folders.
                Refer to the [Folder](toloka.client.message_thread.Folder.md) page for more information on the available `folder` values.
        folder_ne: A folder to skip or a list of folders. Supported values are the same as for `folder`.
        id_lt: Threads with IDs less than the specified value.
        id_lte: Threads with IDs less than or equal to the specified value.
        id_gt: Threads with IDs greater than the specified value.
        id_gte: Threads with IDs greater than or equal to the specified value.
        created_lt: Threads created before the specified date.
        created_lte: Threads created before or on the specified date.
        created_gt: Threads created after the specified date.
        created_gte: Threads created after or on the specified date.
    """

    class CompareFields:
        id: str
        created: datetime.datetime

    def unstructure(self) -> typing.Optional[dict]: ...

    def __init__(
        self,
        folder: typing.Union[str, toloka.client.message_thread.Folder, typing.List[typing.Union[str, toloka.client.message_thread.Folder]]] = None,
        folder_ne: typing.Union[str, toloka.client.message_thread.Folder, typing.List[typing.Union[str, toloka.client.message_thread.Folder]]] = None,
        id_lt: typing.Optional[str] = None,
        id_lte: typing.Optional[str] = None,
        id_gt: typing.Optional[str] = None,
        id_gte: typing.Optional[str] = None,
        created_lt: typing.Optional[datetime.datetime] = None,
        created_lte: typing.Optional[datetime.datetime] = None,
        created_gt: typing.Optional[datetime.datetime] = None,
        created_gte: typing.Optional[datetime.datetime] = None
    ) -> None:
        """Method generated by attrs for class MessageThreadSearchRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    folder: typing.Optional[typing.List[toloka.client.message_thread.Folder]]
    folder_ne: typing.Optional[typing.List[toloka.client.message_thread.Folder]]
    id_lt: typing.Optional[str]
    id_lte: typing.Optional[str]
    id_gt: typing.Optional[str]
    id_gte: typing.Optional[str]
    created_lt: typing.Optional[datetime.datetime]
    created_lte: typing.Optional[datetime.datetime]
    created_gt: typing.Optional[datetime.datetime]
    created_gte: typing.Optional[datetime.datetime]


class MessageThreadSortItems(BaseSortItems):
    """Keys for sorting message threads in search results.

    Attributes:
        items: A list of sorting keys. Supported values:
            * `'id'` — Message thread ID.
            * `'created'` — Message thread creation date.
    """

    class SortItem(BaseSortItem):
        class SortField(enum.Enum):
            """An enumeration.
            """

            ID = 'id'
            CREATED = 'created'

        def __init__(
            self,
            field: typing.Optional[SortField] = None,
            order: typing.Optional[SortOrder] = SortOrder.ASCENDING
        ) -> None:
            """Method generated by attrs for class MessageThreadSortItems.SortItem.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        field: typing.Optional[SortField]
        order: typing.Optional[SortOrder]

    def __init__(self, items=None) -> None:
        """Method generated by attrs for class MessageThreadSortItems.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[SortItem]]


class WebhookSubscriptionSearchRequest(BaseSearchRequest):
    """Parameters for searching event subscriptions.

    Attributes:
        event_type: Event type.
                    Refer to the [EventType](toloka.client.webhook_subscription.WebhookSubscription.EventType.md) page
                    for more information on the available `event_type` values.
        pool_id: The ID of a subscribed pool.
        id_lt: Subscriptions with IDs less than the specified value.
        id_lte: Subscriptions with IDs less than or equal to the specified value.
        id_gt: Subscriptions with IDs greater than the specified value.
        id_gte: Subscriptions with IDs greater than or equal to the specified value.
        created_lt: Subscriptions created before the specified date.
        created_lte: Subscriptions created before or on the specified date.
        created_gt: Subscriptions created after the specified date.
        created_gte: Subscriptions created after or on the specified date.
    """

    class CompareFields:
        id: str
        created: datetime.datetime

    def __init__(
        self,
        event_type: typing.Optional[toloka.client.webhook_subscription.WebhookSubscription.EventType] = None,
        pool_id: typing.Optional[str] = None,
        id_lt: typing.Optional[str] = None,
        id_lte: typing.Optional[str] = None,
        id_gt: typing.Optional[str] = None,
        id_gte: typing.Optional[str] = None,
        created_lt: typing.Optional[datetime.datetime] = None,
        created_lte: typing.Optional[datetime.datetime] = None,
        created_gt: typing.Optional[datetime.datetime] = None,
        created_gte: typing.Optional[datetime.datetime] = None
    ) -> None:
        """Method generated by attrs for class WebhookSubscriptionSearchRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    event_type: typing.Optional[toloka.client.webhook_subscription.WebhookSubscription.EventType]
    pool_id: typing.Optional[str]
    id_lt: typing.Optional[str]
    id_lte: typing.Optional[str]
    id_gt: typing.Optional[str]
    id_gte: typing.Optional[str]
    created_lt: typing.Optional[datetime.datetime]
    created_lte: typing.Optional[datetime.datetime]
    created_gt: typing.Optional[datetime.datetime]
    created_gte: typing.Optional[datetime.datetime]


class WebhookSubscriptionSortItems(BaseSortItems):
    """Keys for sorting event subscriptions in search results.

    Attributes:
        items: A list of sorting keys. Supported values:
            * `'id'` — A subscription ID.
            * `'created'` — The creation date of a subscription.

    Example:
        The example shows how to find event subscriptions sorted by creation date in descending order. Subscriptions with equal creation dates are sorted by IDs in ascending order.

        >>> sort = toloka.client.search_requests.WebhookSubscriptionSortItems(['-created', 'id'])
        >>> result = toloka_client.find_webhook_subscriptions(event_type=some_event_type, pool_id=my_pretty_pool_id, sort=sort, limit=10)
        ...
    """

    class SortItem(BaseSortItem):
        class SortField(enum.Enum):
            """An enumeration.
            """

            ID = 'id'
            CREATED = 'created'

        def __init__(
            self,
            field: typing.Optional[SortField] = None,
            order: typing.Optional[SortOrder] = SortOrder.ASCENDING
        ) -> None:
            """Method generated by attrs for class WebhookSubscriptionSortItems.SortItem.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        field: typing.Optional[SortField]
        order: typing.Optional[SortOrder]

    def __init__(self, items=None) -> None:
        """Method generated by attrs for class WebhookSubscriptionSortItems.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[SortItem]]


class OperationSearchRequest(BaseSearchRequest):
    """Parameters for searching operations.

    Attributes:
        type: Operation type.
              Refer to the [OperationType](toloka.client.operations.OperationType.md) page for more information on the available `type` values.
        status: The status of the operation.
              Refer to the [Operation.Status](toloka.client.operations.Operation.Status.md) page for more information on the available `status` values.
        id_lt: Operations with IDs less than the specified value.
        id_lte: Operations with IDs less than or equal to the specified value.
        id_gt: Operations with IDs greater than the specified value.
        id_gte: Operations with IDs greater than or equal to the specified value.
        submitted_lt: Operations submitted before the specified date.
        submitted_lte: Operations submitted before or on the specified date.
        submitted_gt: Operations submitted after the specified date.
        submitted_gte: Operations submitted after or on the specified date.
        finished_lt: Operations finished before the specified date.
        finished_lte: Operations finished before or on the specified date.
        finished_gt: Operations finished after the specified date.
        finished_gte: Operations finished after or on the specified date.
    """

    class CompareFields:
        id: str
        submitted: datetime.datetime
        finished: datetime.datetime

    def __init__(
        self,
        type: typing.Optional[toloka.client.operations.OperationType] = None,
        status: typing.Optional[toloka.client.operations.Operation.Status] = None,
        id_lt: typing.Optional[str] = None,
        id_lte: typing.Optional[str] = None,
        id_gt: typing.Optional[str] = None,
        id_gte: typing.Optional[str] = None,
        submitted_lt: typing.Optional[datetime.datetime] = None,
        submitted_lte: typing.Optional[datetime.datetime] = None,
        submitted_gt: typing.Optional[datetime.datetime] = None,
        submitted_gte: typing.Optional[datetime.datetime] = None,
        finished_lt: typing.Optional[datetime.datetime] = None,
        finished_lte: typing.Optional[datetime.datetime] = None,
        finished_gt: typing.Optional[datetime.datetime] = None,
        finished_gte: typing.Optional[datetime.datetime] = None
    ) -> None:
        """Method generated by attrs for class OperationSearchRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    type: typing.Optional[toloka.client.operations.OperationType]
    status: typing.Optional[toloka.client.operations.Operation.Status]
    id_lt: typing.Optional[str]
    id_lte: typing.Optional[str]
    id_gt: typing.Optional[str]
    id_gte: typing.Optional[str]
    submitted_lt: typing.Optional[datetime.datetime]
    submitted_lte: typing.Optional[datetime.datetime]
    submitted_gt: typing.Optional[datetime.datetime]
    submitted_gte: typing.Optional[datetime.datetime]
    finished_lt: typing.Optional[datetime.datetime]
    finished_lte: typing.Optional[datetime.datetime]
    finished_gt: typing.Optional[datetime.datetime]
    finished_gte: typing.Optional[datetime.datetime]


class OperationSortItems(BaseSortItems):
    """Keys for sorting operations in search results.

    Attributes:
        items: A list of sorting keys. Supported values:
            * `'id'` — Operation ID.
            * `'submitted'` — The date and time when the request was sent.
            * `'finished'` — The date and time when the operation was finished.

    Example:
        The example shows how to find operations sorted by finish date in descending order. Operations with equal finish dates are sorted by IDs in ascending order.

        >>> sort = toloka.client.search_requests.OperationsSearchRequest(['-finished', 'id'])
        >>> result = toloka_client.find_operations(type='POOL_OPEN', status='SUCCESS', sort=sort, limit=10)
        ...
    """

    class SortItem(BaseSortItem):
        class SortField(enum.Enum):
            """An enumeration.
            """

            ID = 'id'
            SUBMITTED = 'submitted'
            FINISHED = 'finished'

        def __init__(
            self,
            field: typing.Optional[SortField] = None,
            order: typing.Optional[SortOrder] = SortOrder.ASCENDING
        ) -> None:
            """Method generated by attrs for class OperationSortItems.SortItem.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        field: typing.Optional[SortField]
        order: typing.Optional[SortOrder]

    def __init__(self, items=None) -> None:
        """Method generated by attrs for class OperationSortItems.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[SortItem]]


class AppProjectSearchRequest(BaseSearchRequest):
    """Parameters for searching App projects.

    Attributes:
        app_id: Projects created using the solution with the specified ID.
        parent_app_project_id: Projects cloned from the project with the specified ID. Projects can be cloned in the web version of Toloka.
        status: App project status.
                Refer to the [AppProject.Status](toloka.client.app.AppProject.Status.md) page for more information on the available `status` values.
        after_id: The ID of a project used for cursor pagination.
        scope: Values:
            * `'MY'` — Projects created by you.
            * `'COMPANY'` — Projects created by requesters from your company.
            * `'REQUESTER_LIST'` — Projects created by requesters in the `requester_ids` list.
        requester_ids: A list with requester IDs separated by a comma. Use the list with parameter `scope = REQUESTER_LIST`.
        id_gt: Projects with IDs greater than the specified value.
        id_gte: Projects with IDs greater than or equal to the specified value.
        id_lt: Projects with IDs less than the specified value.
        id_lte: Projects with IDs less than or equal to the specified value.
        name_gt: Projects with a name lexicographically greater than the specified value.
        name_gte: Projects with a name lexicographically greater than or equal to the specified value.
        name_lt: Projects with a name lexicographically less than the specified value.
        name_lte: Projects with a name lexicographically less than or equal to the specified value.
        created_gt: Projects created after the specified date.
        created_gte: Projects created after or on the specified date.
        created_lt: Projects created before the specified date.
        created_lte: Projects created before or on the specified date.
    """

    class Scope(enum.Enum):
        """An enumeration.
        """

        MY = 'MY'
        COMPANY = 'COMPANY'
        REQUESTER_LIST = 'REQUESTER_LIST'

    class CompareFields:
        id: str
        name: str
        created: datetime.datetime

    def __init__(
        self,
        app_id: typing.Optional[str] = None,
        parent_app_project_id: typing.Optional[str] = None,
        status: typing.Optional[toloka.client.app.AppProject.Status] = None,
        after_id: typing.Optional[str] = None,
        scope: typing.Optional[Scope] = None,
        requester_ids: typing.Union[str, typing.List[str]] = None,
        id_lt: typing.Optional[str] = None,
        id_lte: typing.Optional[str] = None,
        id_gt: typing.Optional[str] = None,
        id_gte: typing.Optional[str] = None,
        name_lt: typing.Optional[str] = None,
        name_lte: typing.Optional[str] = None,
        name_gt: typing.Optional[str] = None,
        name_gte: typing.Optional[str] = None,
        created_lt: typing.Optional[datetime.datetime] = None,
        created_lte: typing.Optional[datetime.datetime] = None,
        created_gt: typing.Optional[datetime.datetime] = None,
        created_gte: typing.Optional[datetime.datetime] = None
    ) -> None:
        """Method generated by attrs for class AppProjectSearchRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    app_id: typing.Optional[str]
    parent_app_project_id: typing.Optional[str]
    status: typing.Optional[toloka.client.app.AppProject.Status]
    after_id: typing.Optional[str]
    scope: typing.Optional[Scope]
    requester_ids: typing.Optional[typing.List[str]]
    id_lt: typing.Optional[str]
    id_lte: typing.Optional[str]
    id_gt: typing.Optional[str]
    id_gte: typing.Optional[str]
    name_lt: typing.Optional[str]
    name_lte: typing.Optional[str]
    name_gt: typing.Optional[str]
    name_gte: typing.Optional[str]
    created_lt: typing.Optional[datetime.datetime]
    created_lte: typing.Optional[datetime.datetime]
    created_gt: typing.Optional[datetime.datetime]
    created_gte: typing.Optional[datetime.datetime]


class AppProjectSortItems(BaseSortItems):
    """Keys for sorting App projects in search results.

    Attributes:
        items: A list of sorting keys. Supported values:
            * `'id'` — An App project ID.
            * `'name'` — An App project name.
            * `'created'` — A project creation date.
    """

    class SortItem(BaseSortItem):
        class SortField(enum.Enum):
            """An enumeration.
            """

            ID = 'id'
            NAME = 'name'
            CREATED = 'created'

        def __init__(
            self,
            field: typing.Optional[SortField] = None,
            order: typing.Optional[SortOrder] = SortOrder.ASCENDING
        ) -> None:
            """Method generated by attrs for class AppProjectSortItems.SortItem.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        field: typing.Optional[SortField]
        order: typing.Optional[SortOrder]

    def __init__(self, items=None) -> None:
        """Method generated by attrs for class AppProjectSortItems.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[SortItem]]


class AppSearchRequest(BaseSearchRequest):
    """Parameters for searching App solutions.

    Attributes:
        after_id: The ID of a solution used for cursor pagination.
        lang: ISO 639 language code.
        id_gt: Solutions with IDs greater than the specified value.
        id_gte: Solutions with IDs greater than or equal to the specified value.
        id_lt: Solutions with IDs less than the specified value.
        id_lte: Solutions with IDs less than or equal to the specified value.
        name_gt: Solutions with names lexicographically greater than the specified value.
        name_gte: Solutions with names lexicographically greater than or equal to the specified value.
        name_lt: Solutions with names lexicographically less than the specified value.
        name_lte: Solutions with names lexicographically less than or equal to the specified value.
    """

    class CompareFields:
        id: str

    def __init__(
        self,
        after_id: typing.Optional[str] = None,
        lang: typing.Optional[str] = None,
        id_lt: typing.Optional[str] = None,
        id_lte: typing.Optional[str] = None,
        id_gt: typing.Optional[str] = None,
        id_gte: typing.Optional[str] = None
    ) -> None:
        """Method generated by attrs for class AppSearchRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    after_id: typing.Optional[str]
    lang: typing.Optional[str]
    id_lt: typing.Optional[str]
    id_lte: typing.Optional[str]
    id_gt: typing.Optional[str]
    id_gte: typing.Optional[str]


class AppSortItems(BaseSortItems):
    """Keys for sorting App solutions in search results.

    Attributes:
        items: A list of sorting keys. Supported values:
            * `'id'` — An App solution ID.
    """

    class SortItem(BaseSortItem):
        class SortField(enum.Enum):
            """An enumeration.
            """

            ID = 'id'

        def __init__(
            self,
            field: typing.Optional[SortField] = None,
            order: typing.Optional[SortOrder] = SortOrder.ASCENDING
        ) -> None:
            """Method generated by attrs for class AppSortItems.SortItem.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        field: typing.Optional[SortField]
        order: typing.Optional[SortOrder]

    def __init__(self, items=None) -> None:
        """Method generated by attrs for class AppSortItems.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[SortItem]]


class AppItemSearchRequest(BaseSearchRequest):
    """Parameters for searching App task items.

    Attributes:
        after_id: The ID of the item used for cursor pagination.
        batch_id: The ID of the batch to look in.
        status: App task item status.
                Refer to the [AppItem.Status](toloka.client.app.AppItem.Status.md) page for more information on the available `status` values.
        id_gt: Items with IDs greater than the specified value.
        id_gte: Items with IDs greater than or equal to the specified value.
        id_lt: Items with IDs less than the specified value.
        id_lte: Items with IDs less than or equal to the specified value.
        created_gt: Items created after the specified date.
        created_gte: Items created after or on the specified date.
        created_lt: Items created before the specified date.
        created_lte: Items created before or on the specified date.
        finished_gt: Items labeled after the specified date.
        finished_gte: Items labeled after or on the specified date.
        finished_lt: Items labeled before the specified date.
        finished_lte: Items labeled before or on the specified date.
    """

    class CompareFields:
        id: str
        created: datetime.datetime
        finished: datetime.datetime

    def __init__(
        self,
        after_id: typing.Optional[str] = None,
        batch_id: typing.Optional[str] = None,
        status: typing.Optional[toloka.client.app.AppItem.Status] = None,
        id_lt: typing.Optional[str] = None,
        id_lte: typing.Optional[str] = None,
        id_gt: typing.Optional[str] = None,
        id_gte: typing.Optional[str] = None,
        created_lt: typing.Optional[datetime.datetime] = None,
        created_lte: typing.Optional[datetime.datetime] = None,
        created_gt: typing.Optional[datetime.datetime] = None,
        created_gte: typing.Optional[datetime.datetime] = None,
        finished_lt: typing.Optional[datetime.datetime] = None,
        finished_lte: typing.Optional[datetime.datetime] = None,
        finished_gt: typing.Optional[datetime.datetime] = None,
        finished_gte: typing.Optional[datetime.datetime] = None
    ) -> None:
        """Method generated by attrs for class AppItemSearchRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    after_id: typing.Optional[str]
    batch_id: typing.Optional[str]
    status: typing.Optional[toloka.client.app.AppItem.Status]
    id_lt: typing.Optional[str]
    id_lte: typing.Optional[str]
    id_gt: typing.Optional[str]
    id_gte: typing.Optional[str]
    created_lt: typing.Optional[datetime.datetime]
    created_lte: typing.Optional[datetime.datetime]
    created_gt: typing.Optional[datetime.datetime]
    created_gte: typing.Optional[datetime.datetime]
    finished_lt: typing.Optional[datetime.datetime]
    finished_lte: typing.Optional[datetime.datetime]
    finished_gt: typing.Optional[datetime.datetime]
    finished_gte: typing.Optional[datetime.datetime]


class AppItemSortItems(BaseSortItems):
    """Keys for sorting App items in search results.

    Attributes:
        items: A list of sorting keys. Supported values:
            * `'id'` — A task item ID.
            * `'created'` — The date and time when the item was created.
            * `'finished'` — The date and time when the item processing was completed.
            * `'status'` — The item status.
    """

    class SortItem(BaseSortItem):
        class SortField(enum.Enum):
            """An enumeration.
            """

            ID = 'id'
            CREATED = 'created'
            FINISHED = 'finished'
            STATUS = 'status'

        def __init__(
            self,
            field: typing.Optional[SortField] = None,
            order: typing.Optional[SortOrder] = SortOrder.ASCENDING
        ) -> None:
            """Method generated by attrs for class AppItemSortItems.SortItem.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        field: typing.Optional[SortField]
        order: typing.Optional[SortOrder]

    def __init__(self, items=None) -> None:
        """Method generated by attrs for class AppItemSortItems.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[SortItem]]


class AppBatchSearchRequest(BaseSearchRequest):
    """Parameters for searching batches in an App project.

    Attributes:
        after_id: The ID of the batch used for cursor pagination.
        status: Refer to the [AppBatch.Status](toloka.client.app.AppBatch.Status.md) page for more information on the available `status` values.
        id_gt: Batches with IDs greater than the specified value.
        id_gte: Batches with IDs greater than or equal to the specified value.
        id_lt: Batches with IDs less than the specified value.
        id_lte: Batches with IDs less than or equal to the specified value.
        name_gt: Batches with names lexicographically greater than the specified value.
        name_gte: Batches with names lexicographically greater than or equal to the specified value.
        name_lt: Batches with names lexicographically less than the specified value.
        name_lte: Batches with names lexicographically less than or equal to the specified value.
        created_gt: Batches created after the specified date.
        created_gte: Batches created after or on the specified date.
        created_lt: Batches created before the specified date.
        created_lte: Batches created before or on the specified date.
    """

    class CompareFields:
        id: str
        name: str
        created: datetime.datetime

    def __init__(
        self,
        after_id: typing.Optional[str] = None,
        status: typing.Optional[toloka.client.app.AppBatch.Status] = None,
        id_lt: typing.Optional[str] = None,
        id_lte: typing.Optional[str] = None,
        id_gt: typing.Optional[str] = None,
        id_gte: typing.Optional[str] = None,
        name_lt: typing.Optional[str] = None,
        name_lte: typing.Optional[str] = None,
        name_gt: typing.Optional[str] = None,
        name_gte: typing.Optional[str] = None,
        created_lt: typing.Optional[datetime.datetime] = None,
        created_lte: typing.Optional[datetime.datetime] = None,
        created_gt: typing.Optional[datetime.datetime] = None,
        created_gte: typing.Optional[datetime.datetime] = None
    ) -> None:
        """Method generated by attrs for class AppBatchSearchRequest.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    after_id: typing.Optional[str]
    status: typing.Optional[toloka.client.app.AppBatch.Status]
    id_lt: typing.Optional[str]
    id_lte: typing.Optional[str]
    id_gt: typing.Optional[str]
    id_gte: typing.Optional[str]
    name_lt: typing.Optional[str]
    name_lte: typing.Optional[str]
    name_gt: typing.Optional[str]
    name_gte: typing.Optional[str]
    created_lt: typing.Optional[datetime.datetime]
    created_lte: typing.Optional[datetime.datetime]
    created_gt: typing.Optional[datetime.datetime]
    created_gte: typing.Optional[datetime.datetime]


class AppBatchSortItems(BaseSortItems):
    """Keys for sorting App batches in search results.

    Attributes:
        items: A list of sorting keys. Supported values:
            * `'id'` — A batch ID.
            * `'name'` — A batch name.
            * `'created'` — A batch creation date.
            * `'status'` — The item status.
    """

    class SortItem(BaseSortItem):
        class SortField(enum.Enum):
            """An enumeration.
            """

            ID = 'id'
            NAME = 'name'
            CREATED = 'created'
            STATUS = 'status'

        def __init__(
            self,
            field: typing.Optional[SortField] = None,
            order: typing.Optional[SortOrder] = SortOrder.ASCENDING
        ) -> None:
            """Method generated by attrs for class AppBatchSortItems.SortItem.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        field: typing.Optional[SortField]
        order: typing.Optional[SortOrder]

    def __init__(self, items=None) -> None:
        """Method generated by attrs for class AppBatchSortItems.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    items: typing.Optional[typing.List[SortItem]]
