__all__ = [
    'TaskSuite',
    'TaskSuiteCreateRequestParameters',
    'TaskSuiteOverlapPatch',
    'TaskSuitePatch',
]
import datetime
import toloka.client.primitives.base
import toloka.client.primitives.infinite_overlap
import toloka.client.primitives.parameter
import toloka.client.task
import typing
import uuid


class TaskSuite(toloka.client.primitives.infinite_overlap.InfiniteOverlapParametersMixin, toloka.client.primitives.base.BaseTolokaObject):
    """A set of tasks issued to the Toloker at a time

    TaskSuite can contain one or more tasks. The execution price is charged for one TaskSuite.
    Tolokers receive exactly one TaskSuite when they take on your task.

    Attributes:
        pool_id: The ID of the pool that task suite are uploaded to.
        tasks: Data for the tasks.
        reserved_for: IDs of Tolokers who will have access to the task suite.
        unavailable_for: IDs of Tolokers who shouldn't have access to the task suite.
        issuing_order_override: The priority of a task suite among other sets in the pool. Defines the order in which
            task suites are assigned to Tolokers. The larger the parameter value, the higher the priority.
            This parameter can be used if the pool has issue_task_suites_in_creation_order: true.
            Allowed values: from -99999.99999 to 99999.99999.
        mixed: Type of operation for creating a task suite:
            * True - Automatically with the "smart mixing" option (for details, see Toloka requester's guide).
            * False - Manually.
        traits_all_of:
        traits_any_of:
        traits_none_of_any:
        longitude: The longitude of the point on the map for the task suite.
        latitude: The latitude of the point on the map for the task suite.
        id: ID of a task suite. Read only field.
        remaining_overlap: How many times will this Task Suite be issued to Tolokers. Read only field.
        automerged: The task suite flag is created after task merging. Read Only field. Value:
            * True - The task suite is generated as a result of merging identical tasks.
            * False - A standard task suite created by "smart mixing" or by the requester.
        created: The UTC date and time when the task suite was created. Read Only field.
    """

    @typing.overload
    def add_base_task(self, base_task: toloka.client.task.BaseTask) -> 'TaskSuite': ...

    @typing.overload
    def add_base_task(
        self,
        *,
        input_values: typing.Optional[typing.Dict[str, typing.Any]] = None,
        known_solutions: typing.Optional[typing.List[toloka.client.task.BaseTask.KnownSolution]] = None,
        message_on_unknown_solution: typing.Optional[str] = None
    ) -> 'TaskSuite': ...

    def __init__(
        self,
        *,
        infinite_overlap=None,
        overlap=None,
        pool_id: typing.Optional[str] = None,
        tasks: typing.Optional[typing.List[toloka.client.task.BaseTask]] = ...,
        reserved_for: typing.Optional[typing.List[str]] = None,
        unavailable_for: typing.Optional[typing.List[str]] = None,
        issuing_order_override: typing.Optional[float] = None,
        mixed: typing.Optional[bool] = None,
        traits_all_of: typing.Optional[typing.List[str]] = None,
        traits_any_of: typing.Optional[typing.List[str]] = None,
        traits_none_of_any: typing.Optional[typing.List[str]] = None,
        longitude: typing.Optional[float] = None,
        latitude: typing.Optional[float] = None,
        id: typing.Optional[str] = None,
        remaining_overlap: typing.Optional[int] = None,
        automerged: typing.Optional[bool] = None,
        created: typing.Optional[datetime.datetime] = None
    ) -> None:
        """Method generated by attrs for class TaskSuite.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    _infinite_overlap: typing.Optional[bool]
    _overlap: typing.Optional[int]
    pool_id: typing.Optional[str]
    tasks: typing.Optional[typing.List[toloka.client.task.BaseTask]]
    reserved_for: typing.Optional[typing.List[str]]
    unavailable_for: typing.Optional[typing.List[str]]
    issuing_order_override: typing.Optional[float]
    mixed: typing.Optional[bool]
    traits_all_of: typing.Optional[typing.List[str]]
    traits_any_of: typing.Optional[typing.List[str]]
    traits_none_of_any: typing.Optional[typing.List[str]]
    longitude: typing.Optional[float]
    latitude: typing.Optional[float]
    id: typing.Optional[str]
    remaining_overlap: typing.Optional[int]
    automerged: typing.Optional[bool]
    created: typing.Optional[datetime.datetime]


class TaskSuiteCreateRequestParameters(toloka.client.primitives.parameter.Parameters):
    """Parameters for TaskSuite creation controlling

    Attributes:
        operation_id: Operation ID for asynchronous loading of task suites.
        skip_invalid_items: Validation parameters:
            * True - Create the task suites that passed validation. Skip the rest of the task suites.
            * False - If at least one of the task suites didn't pass validation, stop the operation and
                don't create the task suites.
        allow_defaults: Overlap settings:
            * True - Use the overlap that is set in the pool parameters.
            * False - Use the overlap that is set in the task suite parameters (in the `overlap` field).
        open_pool: Open the pool immediately after creating a task suite, if the pool is closed.
        async_mode: How the request is processed:
            * True — deferred. The query results in an asynchronous operation running in the background.
                Answer contains information about the operation (start and end time, status, number of sets).
            * False — synchronous. Answer contains information about the generated sets of tasks.
                You can send a maximum of 5000 task sets in a single request.
    """

    def __init__(
        self,
        *,
        operation_id: typing.Optional[uuid.UUID] = None,
        skip_invalid_items: typing.Optional[bool] = None,
        allow_defaults: typing.Optional[bool] = None,
        open_pool: typing.Optional[bool] = None,
        async_mode: typing.Optional[bool] = True
    ) -> None:
        """Method generated by attrs for class TaskSuiteCreateRequestParameters.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    operation_id: typing.Optional[uuid.UUID]
    skip_invalid_items: typing.Optional[bool]
    allow_defaults: typing.Optional[bool]
    open_pool: typing.Optional[bool]
    async_mode: typing.Optional[bool]


class TaskSuiteOverlapPatch(toloka.client.primitives.base.BaseTolokaObject):
    """Parameters to stop issuing a specific TaskSuite
    """

    def __init__(self, *, overlap: typing.Optional[int] = None) -> None:
        """Method generated by attrs for class TaskSuiteOverlapPatch.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    overlap: typing.Optional[int]


class TaskSuitePatch(toloka.client.primitives.infinite_overlap.InfiniteOverlapParametersMixin, toloka.client.primitives.base.BaseTolokaObject):
    """Parameters for changing specific TaskSuite

    Attributes:
        issuing_order_override: The priority of a task suite among other sets in the pool. Defines the order in which
            task suites are assigned to Tolokers. The larger the parameter value, the higher the priority.
            This parameter can be used if the pool has issue_task_suites_in_creation_order: true.
            Allowed values: from -99999.99999 to 99999.99999.
        open_pool: Open the pool immediately after changing a task suite, if the pool is closed.
    """

    def __init__(
        self,
        *,
        infinite_overlap=None,
        overlap=None,
        issuing_order_override: typing.Optional[float] = None,
        open_pool: typing.Optional[bool] = None
    ) -> None:
        """Method generated by attrs for class TaskSuitePatch.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    _infinite_overlap: typing.Optional[bool]
    _overlap: typing.Optional[int]
    issuing_order_override: typing.Optional[float]
    open_pool: typing.Optional[bool]
