__all__ = [
    'User',
]
import toloka.client.primitives.base
import typing


class User(toloka.client.primitives.base.BaseTolokaObject):
    """Toloker metadata.

    Attributes:
        id: Toloker ID.
        country: Toloker country code.
        languages: list of languages that Toloker know represented with language codes.
        adult_allowed: shows whether Toloker agreed to complete tasks with adult content.
        attributes: Toloker attributes.
    """

    class Attributes(toloka.client.primitives.base.BaseTolokaObject):
        def __init__(
            self,
            *,
            country_by_phone: typing.Optional[str] = None,
            country_by_ip: typing.Optional[str] = None,
            client_type: typing.Optional[str] = None,
            user_agent_type: typing.Optional[str] = None,
            device_category: typing.Optional[str] = None,
            os_family: typing.Optional[str] = None,
            os_version: typing.Optional[float] = None,
            os_version_major: typing.Optional[int] = None,
            os_version_minor: typing.Optional[int] = None,
            os_version_bugfix: typing.Optional[int] = None
        ) -> None:
            """Method generated by attrs for class User.Attributes.
            """
            ...

        _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
        country_by_phone: typing.Optional[str]
        country_by_ip: typing.Optional[str]
        client_type: typing.Optional[str]
        user_agent_type: typing.Optional[str]
        device_category: typing.Optional[str]
        os_family: typing.Optional[str]
        os_version: typing.Optional[float]
        os_version_major: typing.Optional[int]
        os_version_minor: typing.Optional[int]
        os_version_bugfix: typing.Optional[int]

    def __init__(
        self,
        *,
        id: typing.Optional[str] = None,
        country: typing.Optional[str] = None,
        languages: typing.Optional[typing.List[str]] = None,
        adult_allowed: typing.Optional[bool] = None,
        attributes: typing.Optional[Attributes] = None
    ) -> None:
        """Method generated by attrs for class User.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    id: typing.Optional[str]
    country: typing.Optional[str]
    languages: typing.Optional[typing.List[str]]
    adult_allowed: typing.Optional[bool]
    attributes: typing.Optional[Attributes]
