__all__ = [
    'WebhookSubscription',
]
import datetime
import toloka.client.primitives.base
import toloka.util._extendable_enum
import typing


class WebhookSubscription(toloka.client.primitives.base.BaseTolokaObject):
    """Webhook subscription to make a callback to the given address when some event happen.

    Attributes:
        webhook_url: The URL to which notifications will be sent.
        event_type: Event type.
        pool_id: ID of the pool for which the subscription was created.
        id: Pool ID. Read only field.
        created: When this pool was created. Read only field.
    """

    class EventType(toloka.util._extendable_enum.ExtendableStrEnum):
        """Webhook subscription event type:

        Attributes:
            POOL_CLOSED: The pool is closed.
            DYNAMIC_OVERLAP_COMPLETED: There is an aggregated estimate for dynamic overlap.
            ASSIGNMENT_CREATED: Task created.
            ASSIGNMENT_SUBMITTED: The task has been completed and is waiting for acceptance by the customer.
            ASSIGNMENT_SKIPPED: The task was taken to work, but the Toloker skipped it and did not return to it.
            ASSIGNMENT_EXPIRED: The task was taken to work, but the Toloker did not have time to complete it in the allotted time or refused it before the end of the term.
            ASSIGNMENT_APPROVED: The task was performed by the Toloker and confirmed by the customer.
            ASSIGNMENT_REJECTED: The task was completed by the Toloker, but rejected by the customer.
        """

        POOL_CLOSED = 'POOL_CLOSED'
        DYNAMIC_OVERLAP_COMPLETED = 'DYNAMIC_OVERLAP_COMPLETED'
        ASSIGNMENT_CREATED = 'ASSIGNMENT_CREATED'
        ASSIGNMENT_SUBMITTED = 'ASSIGNMENT_SUBMITTED'
        ASSIGNMENT_SKIPPED = 'ASSIGNMENT_SKIPPED'
        ASSIGNMENT_EXPIRED = 'ASSIGNMENT_EXPIRED'
        ASSIGNMENT_APPROVED = 'ASSIGNMENT_APPROVED'
        ASSIGNMENT_REJECTED = 'ASSIGNMENT_REJECTED'

    def __init__(
        self,
        *,
        webhook_url: typing.Optional[str] = None,
        event_type: typing.Union[EventType, str, None] = None,
        pool_id: typing.Optional[str] = None,
        secret_key: typing.Optional[str] = None,
        id: typing.Optional[str] = None,
        created: typing.Optional[datetime.datetime] = None
    ) -> None:
        """Method generated by attrs for class WebhookSubscription.
        """
        ...

    _unexpected: typing.Optional[typing.Dict[str, typing.Any]]
    webhook_url: typing.Optional[str]
    event_type: typing.Optional[EventType]
    pool_id: typing.Optional[str]
    secret_key: typing.Optional[str]
    id: typing.Optional[str]
    created: typing.Optional[datetime.datetime]
