# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

import httpx

from .._types import NOT_GIVEN, Body, Query, Headers, NotGiven
from .._compat import cached_property
from .._resource import SyncAPIResource, AsyncAPIResource
from .._response import (
    to_raw_response_wrapper,
    to_streamed_response_wrapper,
    async_to_raw_response_wrapper,
    async_to_streamed_response_wrapper,
)
from .._base_client import make_request_options
from ..types.nebula_hello_response import NebulaHelloResponse
from ..types.nebula_retrieve_response import NebulaRetrieveResponse

__all__ = ["NebulaResource", "AsyncNebulaResource"]


class NebulaResource(SyncAPIResource):
    @cached_property
    def with_raw_response(self) -> NebulaResourceWithRawResponse:
        """
        This property can be used as a prefix for any HTTP method call to return
        the raw response object instead of the parsed content.

        For more information, see https://www.github.com/Zywa-co/nebula-python-sdk#accessing-raw-response-data-eg-headers
        """
        return NebulaResourceWithRawResponse(self)

    @cached_property
    def with_streaming_response(self) -> NebulaResourceWithStreamingResponse:
        """
        An alternative to `.with_raw_response` that doesn't eagerly read the response body.

        For more information, see https://www.github.com/Zywa-co/nebula-python-sdk#with_streaming_response
        """
        return NebulaResourceWithStreamingResponse(self)

    def retrieve(
        self,
        *,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> NebulaRetrieveResponse:
        """This operation allows you get a hello message"""
        return self._get(
            "/v1/nebula/retrieve",
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=NebulaRetrieveResponse,
        )

    def hello(
        self,
        *,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> NebulaHelloResponse:
        """This operation allows you get a hello message"""
        return self._get(
            "/v1/nebula/hello",
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=NebulaHelloResponse,
        )


class AsyncNebulaResource(AsyncAPIResource):
    @cached_property
    def with_raw_response(self) -> AsyncNebulaResourceWithRawResponse:
        """
        This property can be used as a prefix for any HTTP method call to return
        the raw response object instead of the parsed content.

        For more information, see https://www.github.com/Zywa-co/nebula-python-sdk#accessing-raw-response-data-eg-headers
        """
        return AsyncNebulaResourceWithRawResponse(self)

    @cached_property
    def with_streaming_response(self) -> AsyncNebulaResourceWithStreamingResponse:
        """
        An alternative to `.with_raw_response` that doesn't eagerly read the response body.

        For more information, see https://www.github.com/Zywa-co/nebula-python-sdk#with_streaming_response
        """
        return AsyncNebulaResourceWithStreamingResponse(self)

    async def retrieve(
        self,
        *,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> NebulaRetrieveResponse:
        """This operation allows you get a hello message"""
        return await self._get(
            "/v1/nebula/retrieve",
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=NebulaRetrieveResponse,
        )

    async def hello(
        self,
        *,
        # Use the following arguments if you need to pass additional parameters to the API that aren't available via kwargs.
        # The extra values given here take precedence over values defined on the client or passed to this method.
        extra_headers: Headers | None = None,
        extra_query: Query | None = None,
        extra_body: Body | None = None,
        timeout: float | httpx.Timeout | None | NotGiven = NOT_GIVEN,
    ) -> NebulaHelloResponse:
        """This operation allows you get a hello message"""
        return await self._get(
            "/v1/nebula/hello",
            options=make_request_options(
                extra_headers=extra_headers, extra_query=extra_query, extra_body=extra_body, timeout=timeout
            ),
            cast_to=NebulaHelloResponse,
        )


class NebulaResourceWithRawResponse:
    def __init__(self, nebula: NebulaResource) -> None:
        self._nebula = nebula

        self.retrieve = to_raw_response_wrapper(
            nebula.retrieve,
        )
        self.hello = to_raw_response_wrapper(
            nebula.hello,
        )


class AsyncNebulaResourceWithRawResponse:
    def __init__(self, nebula: AsyncNebulaResource) -> None:
        self._nebula = nebula

        self.retrieve = async_to_raw_response_wrapper(
            nebula.retrieve,
        )
        self.hello = async_to_raw_response_wrapper(
            nebula.hello,
        )


class NebulaResourceWithStreamingResponse:
    def __init__(self, nebula: NebulaResource) -> None:
        self._nebula = nebula

        self.retrieve = to_streamed_response_wrapper(
            nebula.retrieve,
        )
        self.hello = to_streamed_response_wrapper(
            nebula.hello,
        )


class AsyncNebulaResourceWithStreamingResponse:
    def __init__(self, nebula: AsyncNebulaResource) -> None:
        self._nebula = nebula

        self.retrieve = async_to_streamed_response_wrapper(
            nebula.retrieve,
        )
        self.hello = async_to_streamed_response_wrapper(
            nebula.hello,
        )
