# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAnalyticsInstancesResult',
    'AwaitableGetAnalyticsInstancesResult',
    'get_analytics_instances',
    'get_analytics_instances_output',
]

@pulumi.output_type
class GetAnalyticsInstancesResult:
    """
    A collection of values returned by getAnalyticsInstances.
    """
    def __init__(__self__, analytics_instances=None, capacity_type=None, compartment_id=None, feature_set=None, filters=None, id=None, name=None, state=None):
        if analytics_instances and not isinstance(analytics_instances, list):
            raise TypeError("Expected argument 'analytics_instances' to be a list")
        pulumi.set(__self__, "analytics_instances", analytics_instances)
        if capacity_type and not isinstance(capacity_type, str):
            raise TypeError("Expected argument 'capacity_type' to be a str")
        pulumi.set(__self__, "capacity_type", capacity_type)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if feature_set and not isinstance(feature_set, str):
            raise TypeError("Expected argument 'feature_set' to be a str")
        pulumi.set(__self__, "feature_set", feature_set)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="analyticsInstances")
    def analytics_instances(self) -> Sequence['outputs.GetAnalyticsInstancesAnalyticsInstanceResult']:
        """
        The list of analytics_instances.
        """
        return pulumi.get(self, "analytics_instances")

    @property
    @pulumi.getter(name="capacityType")
    def capacity_type(self) -> Optional[str]:
        """
        The capacity model to use. Accepted values are: OLPU_COUNT, USER_COUNT
        """
        return pulumi.get(self, "capacity_type")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="featureSet")
    def feature_set(self) -> Optional[str]:
        """
        Analytics feature set.
        """
        return pulumi.get(self, "feature_set")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAnalyticsInstancesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the Analytics instance. This name must be unique in the tenancy and cannot be changed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of an instance.
        """
        return pulumi.get(self, "state")


class AwaitableGetAnalyticsInstancesResult(GetAnalyticsInstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAnalyticsInstancesResult(
            analytics_instances=self.analytics_instances,
            capacity_type=self.capacity_type,
            compartment_id=self.compartment_id,
            feature_set=self.feature_set,
            filters=self.filters,
            id=self.id,
            name=self.name,
            state=self.state)


def get_analytics_instances(capacity_type: Optional[str] = None,
                            compartment_id: Optional[str] = None,
                            feature_set: Optional[str] = None,
                            filters: Optional[Sequence[Union['GetAnalyticsInstancesFilterArgs', 'GetAnalyticsInstancesFilterArgsDict']]] = None,
                            name: Optional[str] = None,
                            state: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAnalyticsInstancesResult:
    """
    This data source provides the list of Analytics Instances in Oracle Cloud Infrastructure Analytics service.

    List Analytics instances.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_analytics_instances = oci.Analytics.get_analytics_instances(compartment_id=compartment_id,
        capacity_type=analytics_instance_capacity_type,
        feature_set=analytics_instance_feature_set,
        name=analytics_instance_name,
        state=analytics_instance_state)
    ```


    :param str capacity_type: A filter to only return resources matching the capacity type enum. Values are case-insensitive.
    :param str compartment_id: The OCID of the compartment.
    :param str feature_set: A filter to only return resources matching the feature set. Values are case-insensitive.
    :param str name: A filter to return only resources that match the given name exactly.
    :param str state: A filter to only return resources matching the lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['capacityType'] = capacity_type
    __args__['compartmentId'] = compartment_id
    __args__['featureSet'] = feature_set
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Analytics/getAnalyticsInstances:getAnalyticsInstances', __args__, opts=opts, typ=GetAnalyticsInstancesResult).value

    return AwaitableGetAnalyticsInstancesResult(
        analytics_instances=pulumi.get(__ret__, 'analytics_instances'),
        capacity_type=pulumi.get(__ret__, 'capacity_type'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        feature_set=pulumi.get(__ret__, 'feature_set'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        state=pulumi.get(__ret__, 'state'))
def get_analytics_instances_output(capacity_type: Optional[pulumi.Input[Optional[str]]] = None,
                                   compartment_id: Optional[pulumi.Input[str]] = None,
                                   feature_set: Optional[pulumi.Input[Optional[str]]] = None,
                                   filters: Optional[pulumi.Input[Optional[Sequence[Union['GetAnalyticsInstancesFilterArgs', 'GetAnalyticsInstancesFilterArgsDict']]]]] = None,
                                   name: Optional[pulumi.Input[Optional[str]]] = None,
                                   state: Optional[pulumi.Input[Optional[str]]] = None,
                                   opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAnalyticsInstancesResult]:
    """
    This data source provides the list of Analytics Instances in Oracle Cloud Infrastructure Analytics service.

    List Analytics instances.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_analytics_instances = oci.Analytics.get_analytics_instances(compartment_id=compartment_id,
        capacity_type=analytics_instance_capacity_type,
        feature_set=analytics_instance_feature_set,
        name=analytics_instance_name,
        state=analytics_instance_state)
    ```


    :param str capacity_type: A filter to only return resources matching the capacity type enum. Values are case-insensitive.
    :param str compartment_id: The OCID of the compartment.
    :param str feature_set: A filter to only return resources matching the feature set. Values are case-insensitive.
    :param str name: A filter to return only resources that match the given name exactly.
    :param str state: A filter to only return resources matching the lifecycle state. The state value is case-insensitive.
    """
    __args__ = dict()
    __args__['capacityType'] = capacity_type
    __args__['compartmentId'] = compartment_id
    __args__['featureSet'] = feature_set
    __args__['filters'] = filters
    __args__['name'] = name
    __args__['state'] = state
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Analytics/getAnalyticsInstances:getAnalyticsInstances', __args__, opts=opts, typ=GetAnalyticsInstancesResult)
    return __ret__.apply(lambda __response__: GetAnalyticsInstancesResult(
        analytics_instances=pulumi.get(__response__, 'analytics_instances'),
        capacity_type=pulumi.get(__response__, 'capacity_type'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        feature_set=pulumi.get(__response__, 'feature_set'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        name=pulumi.get(__response__, 'name'),
        state=pulumi.get(__response__, 'state')))
