# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['MountTargetArgs', 'MountTarget']

@pulumi.input_type
class MountTargetArgs:
    def __init__(__self__, *,
                 availability_domain: pulumi.Input[str],
                 compartment_id: pulumi.Input[str],
                 subnet_id: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 hostname_label: Optional[pulumi.Input[str]] = None,
                 idmap_type: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 is_lock_override: Optional[pulumi.Input[bool]] = None,
                 kerberos: Optional[pulumi.Input['MountTargetKerberosArgs']] = None,
                 ldap_idmap: Optional[pulumi.Input['MountTargetLdapIdmapArgs']] = None,
                 locks: Optional[pulumi.Input[Sequence[pulumi.Input['MountTargetLockArgs']]]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 requested_throughput: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a MountTarget resource.
        :param pulumi.Input[str] availability_domain: The availability domain in which to create the mount target.  Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to create the mount target.
        :param pulumi.Input[str] subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet in which to create the mount target. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My mount target`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] hostname_label: The hostname for the mount target's IP address, used for DNS resolution. The value is the hostname portion of the private IP address's fully qualified domain name (FQDN). For example, `files-1` in the FQDN `files-1.subnet123.vcn1.oraclevcn.com`. Must be unique across all VNICs in the subnet and comply with [RFC 952](https://tools.ietf.org/html/rfc952) and [RFC 1123](https://tools.ietf.org/html/rfc1123).
               
               Note: This attribute value is stored in the [PrivateIp](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/PrivateIp/) resource, not in the `mountTarget` resource. To update the `hostnameLabel`, use `GetMountTarget` to obtain the [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the mount target's private IPs (`privateIpIds`). Then, you can use [UpdatePrivateIp](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/PrivateIp/UpdatePrivateIp) to update the `hostnameLabel` value.
               
               For more information, see [DNS in Your Virtual Cloud Network](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/dns.htm).
               
               Example: `files-1`
        :param pulumi.Input[str] idmap_type: (Updatable) The method used to map a Unix UID to secondary groups, if any.
        :param pulumi.Input[str] ip_address: A private IP address of your choice. Must be an available IP address within the subnet's CIDR. If you don't specify a value, Oracle automatically assigns a private IP address from the subnet.  Example: `10.0.3.3`
        :param pulumi.Input[bool] is_lock_override: (Updatable) Whether to override locks (if any exist).
        :param pulumi.Input['MountTargetKerberosArgs'] kerberos: (Updatable) Kerberos details needed to create configuration.
        :param pulumi.Input['MountTargetLdapIdmapArgs'] ldap_idmap: (Updatable) Mount target details about the LDAP ID mapping configuration.
        :param pulumi.Input[Sequence[pulumi.Input['MountTargetLockArgs']]] locks: Locks associated with this resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) A list of Network Security Group [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with this mount target. A maximum of 5 is allowed. Setting this to an empty array after the list is created removes the mount target from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm).
        :param pulumi.Input[str] requested_throughput: (Updatable) Throughput for mount target in Gbps. Currently only 1 Gbps of requestedThroughput is supported during create MountTarget. Available shapes and corresponding throughput are listed at [Mount Target Performance](https://docs.oracle.com/iaas/Content/File/Tasks/managingmounttargets.htm#performance).
        """
        pulumi.set(__self__, "availability_domain", availability_domain)
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "subnet_id", subnet_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if hostname_label is not None:
            pulumi.set(__self__, "hostname_label", hostname_label)
        if idmap_type is not None:
            pulumi.set(__self__, "idmap_type", idmap_type)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if is_lock_override is not None:
            pulumi.set(__self__, "is_lock_override", is_lock_override)
        if kerberos is not None:
            pulumi.set(__self__, "kerberos", kerberos)
        if ldap_idmap is not None:
            pulumi.set(__self__, "ldap_idmap", ldap_idmap)
        if locks is not None:
            pulumi.set(__self__, "locks", locks)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)
        if requested_throughput is not None:
            pulumi.set(__self__, "requested_throughput", requested_throughput)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Input[str]:
        """
        The availability domain in which to create the mount target.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: pulumi.Input[str]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to create the mount target.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet in which to create the mount target. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My mount target`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="hostnameLabel")
    def hostname_label(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname for the mount target's IP address, used for DNS resolution. The value is the hostname portion of the private IP address's fully qualified domain name (FQDN). For example, `files-1` in the FQDN `files-1.subnet123.vcn1.oraclevcn.com`. Must be unique across all VNICs in the subnet and comply with [RFC 952](https://tools.ietf.org/html/rfc952) and [RFC 1123](https://tools.ietf.org/html/rfc1123).

        Note: This attribute value is stored in the [PrivateIp](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/PrivateIp/) resource, not in the `mountTarget` resource. To update the `hostnameLabel`, use `GetMountTarget` to obtain the [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the mount target's private IPs (`privateIpIds`). Then, you can use [UpdatePrivateIp](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/PrivateIp/UpdatePrivateIp) to update the `hostnameLabel` value.

        For more information, see [DNS in Your Virtual Cloud Network](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/dns.htm).

        Example: `files-1`
        """
        return pulumi.get(self, "hostname_label")

    @hostname_label.setter
    def hostname_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname_label", value)

    @property
    @pulumi.getter(name="idmapType")
    def idmap_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The method used to map a Unix UID to secondary groups, if any.
        """
        return pulumi.get(self, "idmap_type")

    @idmap_type.setter
    def idmap_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idmap_type", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        A private IP address of your choice. Must be an available IP address within the subnet's CIDR. If you don't specify a value, Oracle automatically assigns a private IP address from the subnet.  Example: `10.0.3.3`
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="isLockOverride")
    def is_lock_override(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Whether to override locks (if any exist).
        """
        return pulumi.get(self, "is_lock_override")

    @is_lock_override.setter
    def is_lock_override(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_lock_override", value)

    @property
    @pulumi.getter
    def kerberos(self) -> Optional[pulumi.Input['MountTargetKerberosArgs']]:
        """
        (Updatable) Kerberos details needed to create configuration.
        """
        return pulumi.get(self, "kerberos")

    @kerberos.setter
    def kerberos(self, value: Optional[pulumi.Input['MountTargetKerberosArgs']]):
        pulumi.set(self, "kerberos", value)

    @property
    @pulumi.getter(name="ldapIdmap")
    def ldap_idmap(self) -> Optional[pulumi.Input['MountTargetLdapIdmapArgs']]:
        """
        (Updatable) Mount target details about the LDAP ID mapping configuration.
        """
        return pulumi.get(self, "ldap_idmap")

    @ldap_idmap.setter
    def ldap_idmap(self, value: Optional[pulumi.Input['MountTargetLdapIdmapArgs']]):
        pulumi.set(self, "ldap_idmap", value)

    @property
    @pulumi.getter
    def locks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MountTargetLockArgs']]]]:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @locks.setter
    def locks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MountTargetLockArgs']]]]):
        pulumi.set(self, "locks", value)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A list of Network Security Group [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with this mount target. A maximum of 5 is allowed. Setting this to an empty array after the list is created removes the mount target from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm).
        """
        return pulumi.get(self, "nsg_ids")

    @nsg_ids.setter
    def nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "nsg_ids", value)

    @property
    @pulumi.getter(name="requestedThroughput")
    def requested_throughput(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Throughput for mount target in Gbps. Currently only 1 Gbps of requestedThroughput is supported during create MountTarget. Available shapes and corresponding throughput are listed at [Mount Target Performance](https://docs.oracle.com/iaas/Content/File/Tasks/managingmounttargets.htm#performance).
        """
        return pulumi.get(self, "requested_throughput")

    @requested_throughput.setter
    def requested_throughput(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "requested_throughput", value)


@pulumi.input_type
class _MountTargetState:
    def __init__(__self__, *,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 export_set_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 hostname_label: Optional[pulumi.Input[str]] = None,
                 idmap_type: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 is_lock_override: Optional[pulumi.Input[bool]] = None,
                 kerberos: Optional[pulumi.Input['MountTargetKerberosArgs']] = None,
                 ldap_idmap: Optional[pulumi.Input['MountTargetLdapIdmapArgs']] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 locks: Optional[pulumi.Input[Sequence[pulumi.Input['MountTargetLockArgs']]]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 observed_throughput: Optional[pulumi.Input[str]] = None,
                 private_ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 requested_throughput: Optional[pulumi.Input[str]] = None,
                 reserved_storage_capacity: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 time_billing_cycle_end: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering MountTarget resources.
        :param pulumi.Input[str] availability_domain: The availability domain in which to create the mount target.  Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to create the mount target.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My mount target`
        :param pulumi.Input[str] export_set_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated export set. Controls what file systems will be exported through Network File System (NFS) protocol on this mount target.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] hostname_label: The hostname for the mount target's IP address, used for DNS resolution. The value is the hostname portion of the private IP address's fully qualified domain name (FQDN). For example, `files-1` in the FQDN `files-1.subnet123.vcn1.oraclevcn.com`. Must be unique across all VNICs in the subnet and comply with [RFC 952](https://tools.ietf.org/html/rfc952) and [RFC 1123](https://tools.ietf.org/html/rfc1123).
               
               Note: This attribute value is stored in the [PrivateIp](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/PrivateIp/) resource, not in the `mountTarget` resource. To update the `hostnameLabel`, use `GetMountTarget` to obtain the [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the mount target's private IPs (`privateIpIds`). Then, you can use [UpdatePrivateIp](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/PrivateIp/UpdatePrivateIp) to update the `hostnameLabel` value.
               
               For more information, see [DNS in Your Virtual Cloud Network](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/dns.htm).
               
               Example: `files-1`
        :param pulumi.Input[str] idmap_type: (Updatable) The method used to map a Unix UID to secondary groups, if any.
        :param pulumi.Input[str] ip_address: A private IP address of your choice. Must be an available IP address within the subnet's CIDR. If you don't specify a value, Oracle automatically assigns a private IP address from the subnet.  Example: `10.0.3.3`
        :param pulumi.Input[bool] is_lock_override: (Updatable) Whether to override locks (if any exist).
        :param pulumi.Input['MountTargetKerberosArgs'] kerberos: (Updatable) Kerberos details needed to create configuration.
        :param pulumi.Input['MountTargetLdapIdmapArgs'] ldap_idmap: (Updatable) Mount target details about the LDAP ID mapping configuration.
        :param pulumi.Input[str] lifecycle_details: Additional information about the current 'lifecycleState'.
        :param pulumi.Input[Sequence[pulumi.Input['MountTargetLockArgs']]] locks: Locks associated with this resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) A list of Network Security Group [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with this mount target. A maximum of 5 is allowed. Setting this to an empty array after the list is created removes the mount target from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm).
        :param pulumi.Input[str] observed_throughput: Current billed throughput for mount target in Gbps. This corresponds to shape of mount target. Available shapes and corresponding throughput are listed at [Mount Target Performance](https://docs.oracle.com/iaas/Content/File/Tasks/managingmounttargets.htm#performance).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] private_ip_ids: The OCIDs of the private IP addresses associated with this mount target.
        :param pulumi.Input[str] requested_throughput: (Updatable) Throughput for mount target in Gbps. Currently only 1 Gbps of requestedThroughput is supported during create MountTarget. Available shapes and corresponding throughput are listed at [Mount Target Performance](https://docs.oracle.com/iaas/Content/File/Tasks/managingmounttargets.htm#performance).
        :param pulumi.Input[str] reserved_storage_capacity: * Reserved capacity (GB) associated with this mount target. Reserved capacity depends on observedThroughput value of mount target. Value is listed at [Mount Target Performance](https://docs.oracle.com/iaas/Content/File/Tasks/managingmounttargets.htm#performance).
        :param pulumi.Input[str] state: The current state of the mount target.
        :param pulumi.Input[str] subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet in which to create the mount target. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] system_tags: System tags for this resource. System tags are applied to resources by internal Oracle Cloud Infrastructure services.
        :param pulumi.Input[str] time_billing_cycle_end: The date and time the mount target current billing cycle will end, expressed in  [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format. Once a cycle ends, it is updated  automatically to next timestamp which is after 30 days.  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[str] time_created: The date and time the mount target was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if export_set_id is not None:
            pulumi.set(__self__, "export_set_id", export_set_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if hostname_label is not None:
            pulumi.set(__self__, "hostname_label", hostname_label)
        if idmap_type is not None:
            pulumi.set(__self__, "idmap_type", idmap_type)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if is_lock_override is not None:
            pulumi.set(__self__, "is_lock_override", is_lock_override)
        if kerberos is not None:
            pulumi.set(__self__, "kerberos", kerberos)
        if ldap_idmap is not None:
            pulumi.set(__self__, "ldap_idmap", ldap_idmap)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if locks is not None:
            pulumi.set(__self__, "locks", locks)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)
        if observed_throughput is not None:
            pulumi.set(__self__, "observed_throughput", observed_throughput)
        if private_ip_ids is not None:
            pulumi.set(__self__, "private_ip_ids", private_ip_ids)
        if requested_throughput is not None:
            pulumi.set(__self__, "requested_throughput", requested_throughput)
        if reserved_storage_capacity is not None:
            pulumi.set(__self__, "reserved_storage_capacity", reserved_storage_capacity)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_billing_cycle_end is not None:
            pulumi.set(__self__, "time_billing_cycle_end", time_billing_cycle_end)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The availability domain in which to create the mount target.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to create the mount target.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My mount target`
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="exportSetId")
    def export_set_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated export set. Controls what file systems will be exported through Network File System (NFS) protocol on this mount target.
        """
        return pulumi.get(self, "export_set_id")

    @export_set_id.setter
    def export_set_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "export_set_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="hostnameLabel")
    def hostname_label(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname for the mount target's IP address, used for DNS resolution. The value is the hostname portion of the private IP address's fully qualified domain name (FQDN). For example, `files-1` in the FQDN `files-1.subnet123.vcn1.oraclevcn.com`. Must be unique across all VNICs in the subnet and comply with [RFC 952](https://tools.ietf.org/html/rfc952) and [RFC 1123](https://tools.ietf.org/html/rfc1123).

        Note: This attribute value is stored in the [PrivateIp](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/PrivateIp/) resource, not in the `mountTarget` resource. To update the `hostnameLabel`, use `GetMountTarget` to obtain the [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the mount target's private IPs (`privateIpIds`). Then, you can use [UpdatePrivateIp](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/PrivateIp/UpdatePrivateIp) to update the `hostnameLabel` value.

        For more information, see [DNS in Your Virtual Cloud Network](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/dns.htm).

        Example: `files-1`
        """
        return pulumi.get(self, "hostname_label")

    @hostname_label.setter
    def hostname_label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname_label", value)

    @property
    @pulumi.getter(name="idmapType")
    def idmap_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The method used to map a Unix UID to secondary groups, if any.
        """
        return pulumi.get(self, "idmap_type")

    @idmap_type.setter
    def idmap_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idmap_type", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        A private IP address of your choice. Must be an available IP address within the subnet's CIDR. If you don't specify a value, Oracle automatically assigns a private IP address from the subnet.  Example: `10.0.3.3`
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="isLockOverride")
    def is_lock_override(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) Whether to override locks (if any exist).
        """
        return pulumi.get(self, "is_lock_override")

    @is_lock_override.setter
    def is_lock_override(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_lock_override", value)

    @property
    @pulumi.getter
    def kerberos(self) -> Optional[pulumi.Input['MountTargetKerberosArgs']]:
        """
        (Updatable) Kerberos details needed to create configuration.
        """
        return pulumi.get(self, "kerberos")

    @kerberos.setter
    def kerberos(self, value: Optional[pulumi.Input['MountTargetKerberosArgs']]):
        pulumi.set(self, "kerberos", value)

    @property
    @pulumi.getter(name="ldapIdmap")
    def ldap_idmap(self) -> Optional[pulumi.Input['MountTargetLdapIdmapArgs']]:
        """
        (Updatable) Mount target details about the LDAP ID mapping configuration.
        """
        return pulumi.get(self, "ldap_idmap")

    @ldap_idmap.setter
    def ldap_idmap(self, value: Optional[pulumi.Input['MountTargetLdapIdmapArgs']]):
        pulumi.set(self, "ldap_idmap", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Additional information about the current 'lifecycleState'.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter
    def locks(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MountTargetLockArgs']]]]:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @locks.setter
    def locks(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MountTargetLockArgs']]]]):
        pulumi.set(self, "locks", value)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        (Updatable) A list of Network Security Group [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with this mount target. A maximum of 5 is allowed. Setting this to an empty array after the list is created removes the mount target from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm).
        """
        return pulumi.get(self, "nsg_ids")

    @nsg_ids.setter
    def nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "nsg_ids", value)

    @property
    @pulumi.getter(name="observedThroughput")
    def observed_throughput(self) -> Optional[pulumi.Input[str]]:
        """
        Current billed throughput for mount target in Gbps. This corresponds to shape of mount target. Available shapes and corresponding throughput are listed at [Mount Target Performance](https://docs.oracle.com/iaas/Content/File/Tasks/managingmounttargets.htm#performance).
        """
        return pulumi.get(self, "observed_throughput")

    @observed_throughput.setter
    def observed_throughput(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "observed_throughput", value)

    @property
    @pulumi.getter(name="privateIpIds")
    def private_ip_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The OCIDs of the private IP addresses associated with this mount target.
        """
        return pulumi.get(self, "private_ip_ids")

    @private_ip_ids.setter
    def private_ip_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "private_ip_ids", value)

    @property
    @pulumi.getter(name="requestedThroughput")
    def requested_throughput(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Throughput for mount target in Gbps. Currently only 1 Gbps of requestedThroughput is supported during create MountTarget. Available shapes and corresponding throughput are listed at [Mount Target Performance](https://docs.oracle.com/iaas/Content/File/Tasks/managingmounttargets.htm#performance).
        """
        return pulumi.get(self, "requested_throughput")

    @requested_throughput.setter
    def requested_throughput(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "requested_throughput", value)

    @property
    @pulumi.getter(name="reservedStorageCapacity")
    def reserved_storage_capacity(self) -> Optional[pulumi.Input[str]]:
        """
        * Reserved capacity (GB) associated with this mount target. Reserved capacity depends on observedThroughput value of mount target. Value is listed at [Mount Target Performance](https://docs.oracle.com/iaas/Content/File/Tasks/managingmounttargets.htm#performance).
        """
        return pulumi.get(self, "reserved_storage_capacity")

    @reserved_storage_capacity.setter
    def reserved_storage_capacity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reserved_storage_capacity", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the mount target.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet in which to create the mount target. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        System tags for this resource. System tags are applied to resources by internal Oracle Cloud Infrastructure services.
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeBillingCycleEnd")
    def time_billing_cycle_end(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the mount target current billing cycle will end, expressed in  [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format. Once a cycle ends, it is updated  automatically to next timestamp which is after 30 days.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_billing_cycle_end")

    @time_billing_cycle_end.setter
    def time_billing_cycle_end(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_billing_cycle_end", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the mount target was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)


class MountTarget(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 hostname_label: Optional[pulumi.Input[str]] = None,
                 idmap_type: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 is_lock_override: Optional[pulumi.Input[bool]] = None,
                 kerberos: Optional[pulumi.Input[Union['MountTargetKerberosArgs', 'MountTargetKerberosArgsDict']]] = None,
                 ldap_idmap: Optional[pulumi.Input[Union['MountTargetLdapIdmapArgs', 'MountTargetLdapIdmapArgsDict']]] = None,
                 locks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MountTargetLockArgs', 'MountTargetLockArgsDict']]]]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 requested_throughput: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Mount Target resource in Oracle Cloud Infrastructure File Storage service.

        Creates a new mount target in the specified compartment and
        subnet. You can associate a file system with a mount
        target only when they exist in the same availability domain. Instances
        can connect to mount targets in another availablity domain, but
        you might see higher latency than with instances in the same
        availability domain as the mount target.

        Mount targets have one or more private IP addresses that you can
        provide as the host portion of remote target parameters in
        client mount commands. These private IP addresses are listed
        in the privateIpIds property of the mount target and are highly available. Mount
        targets also consume additional IP addresses in their subnet.
        Do not use /30 or smaller subnets for mount target creation because they
        do not have sufficient available IP addresses.
        Allow at least three IP addresses for each mount target.

        For information about access control and compartments, see
        [Overview of the IAM
        Service](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/overview.htm).

        For information about availability domains, see [Regions and
        Availability Domains](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/regions.htm).
        To get a list of availability domains, use the
        `ListAvailabilityDomains` operation in the Identity and Access
        Management Service API.

        All Oracle Cloud Infrastructure Services resources, including
        mount targets, get an Oracle-assigned, unique ID called an
        Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)).
        When you create a resource, you can find its OCID in the response.
        You can also retrieve a resource's OCID by using a List API operation on that resource
        type, or by viewing the resource in the Console.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_mount_target = oci.file_storage.MountTarget("test_mount_target",
            availability_domain=mount_target_availability_domain,
            compartment_id=compartment_id,
            subnet_id=test_subnet["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=mount_target_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            hostname_label=mount_target_hostname_label,
            idmap_type=mount_target_idmap_type,
            ip_address=mount_target_ip_address,
            is_lock_override=mount_target_is_lock_override,
            kerberos={
                "kerberos_realm": mount_target_kerberos_kerberos_realm,
                "backup_key_tab_secret_version": mount_target_kerberos_backup_key_tab_secret_version,
                "current_key_tab_secret_version": mount_target_kerberos_current_key_tab_secret_version,
                "is_kerberos_enabled": mount_target_kerberos_is_kerberos_enabled,
                "key_tab_secret_id": test_secret["id"],
            },
            ldap_idmap={
                "cache_lifetime_seconds": mount_target_ldap_idmap_cache_lifetime_seconds,
                "cache_refresh_interval_seconds": mount_target_ldap_idmap_cache_refresh_interval_seconds,
                "group_search_base": mount_target_ldap_idmap_group_search_base,
                "negative_cache_lifetime_seconds": mount_target_ldap_idmap_negative_cache_lifetime_seconds,
                "outbound_connector1id": test_outbound_connector1["id"],
                "outbound_connector2id": test_outbound_connector2["id"],
                "schema_type": mount_target_ldap_idmap_schema_type,
                "user_search_base": mount_target_ldap_idmap_user_search_base,
            },
            locks=[{
                "type": mount_target_locks_type,
                "message": mount_target_locks_message,
                "related_resource_id": test_resource["id"],
                "time_created": mount_target_locks_time_created,
            }],
            nsg_ids=mount_target_nsg_ids,
            requested_throughput=mount_target_requested_throughput)
        ```

        ## Import

        MountTargets can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:FileStorage/mountTarget:MountTarget test_mount_target "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_domain: The availability domain in which to create the mount target.  Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to create the mount target.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My mount target`
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] hostname_label: The hostname for the mount target's IP address, used for DNS resolution. The value is the hostname portion of the private IP address's fully qualified domain name (FQDN). For example, `files-1` in the FQDN `files-1.subnet123.vcn1.oraclevcn.com`. Must be unique across all VNICs in the subnet and comply with [RFC 952](https://tools.ietf.org/html/rfc952) and [RFC 1123](https://tools.ietf.org/html/rfc1123).
               
               Note: This attribute value is stored in the [PrivateIp](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/PrivateIp/) resource, not in the `mountTarget` resource. To update the `hostnameLabel`, use `GetMountTarget` to obtain the [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the mount target's private IPs (`privateIpIds`). Then, you can use [UpdatePrivateIp](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/PrivateIp/UpdatePrivateIp) to update the `hostnameLabel` value.
               
               For more information, see [DNS in Your Virtual Cloud Network](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/dns.htm).
               
               Example: `files-1`
        :param pulumi.Input[str] idmap_type: (Updatable) The method used to map a Unix UID to secondary groups, if any.
        :param pulumi.Input[str] ip_address: A private IP address of your choice. Must be an available IP address within the subnet's CIDR. If you don't specify a value, Oracle automatically assigns a private IP address from the subnet.  Example: `10.0.3.3`
        :param pulumi.Input[bool] is_lock_override: (Updatable) Whether to override locks (if any exist).
        :param pulumi.Input[Union['MountTargetKerberosArgs', 'MountTargetKerberosArgsDict']] kerberos: (Updatable) Kerberos details needed to create configuration.
        :param pulumi.Input[Union['MountTargetLdapIdmapArgs', 'MountTargetLdapIdmapArgsDict']] ldap_idmap: (Updatable) Mount target details about the LDAP ID mapping configuration.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MountTargetLockArgs', 'MountTargetLockArgsDict']]]] locks: Locks associated with this resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) A list of Network Security Group [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with this mount target. A maximum of 5 is allowed. Setting this to an empty array after the list is created removes the mount target from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm).
        :param pulumi.Input[str] requested_throughput: (Updatable) Throughput for mount target in Gbps. Currently only 1 Gbps of requestedThroughput is supported during create MountTarget. Available shapes and corresponding throughput are listed at [Mount Target Performance](https://docs.oracle.com/iaas/Content/File/Tasks/managingmounttargets.htm#performance).
        :param pulumi.Input[str] subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet in which to create the mount target. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: MountTargetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Mount Target resource in Oracle Cloud Infrastructure File Storage service.

        Creates a new mount target in the specified compartment and
        subnet. You can associate a file system with a mount
        target only when they exist in the same availability domain. Instances
        can connect to mount targets in another availablity domain, but
        you might see higher latency than with instances in the same
        availability domain as the mount target.

        Mount targets have one or more private IP addresses that you can
        provide as the host portion of remote target parameters in
        client mount commands. These private IP addresses are listed
        in the privateIpIds property of the mount target and are highly available. Mount
        targets also consume additional IP addresses in their subnet.
        Do not use /30 or smaller subnets for mount target creation because they
        do not have sufficient available IP addresses.
        Allow at least three IP addresses for each mount target.

        For information about access control and compartments, see
        [Overview of the IAM
        Service](https://docs.cloud.oracle.com/iaas/Content/Identity/Concepts/overview.htm).

        For information about availability domains, see [Regions and
        Availability Domains](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/regions.htm).
        To get a list of availability domains, use the
        `ListAvailabilityDomains` operation in the Identity and Access
        Management Service API.

        All Oracle Cloud Infrastructure Services resources, including
        mount targets, get an Oracle-assigned, unique ID called an
        Oracle Cloud Identifier ([OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm)).
        When you create a resource, you can find its OCID in the response.
        You can also retrieve a resource's OCID by using a List API operation on that resource
        type, or by viewing the resource in the Console.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_mount_target = oci.file_storage.MountTarget("test_mount_target",
            availability_domain=mount_target_availability_domain,
            compartment_id=compartment_id,
            subnet_id=test_subnet["id"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            display_name=mount_target_display_name,
            freeform_tags={
                "Department": "Finance",
            },
            hostname_label=mount_target_hostname_label,
            idmap_type=mount_target_idmap_type,
            ip_address=mount_target_ip_address,
            is_lock_override=mount_target_is_lock_override,
            kerberos={
                "kerberos_realm": mount_target_kerberos_kerberos_realm,
                "backup_key_tab_secret_version": mount_target_kerberos_backup_key_tab_secret_version,
                "current_key_tab_secret_version": mount_target_kerberos_current_key_tab_secret_version,
                "is_kerberos_enabled": mount_target_kerberos_is_kerberos_enabled,
                "key_tab_secret_id": test_secret["id"],
            },
            ldap_idmap={
                "cache_lifetime_seconds": mount_target_ldap_idmap_cache_lifetime_seconds,
                "cache_refresh_interval_seconds": mount_target_ldap_idmap_cache_refresh_interval_seconds,
                "group_search_base": mount_target_ldap_idmap_group_search_base,
                "negative_cache_lifetime_seconds": mount_target_ldap_idmap_negative_cache_lifetime_seconds,
                "outbound_connector1id": test_outbound_connector1["id"],
                "outbound_connector2id": test_outbound_connector2["id"],
                "schema_type": mount_target_ldap_idmap_schema_type,
                "user_search_base": mount_target_ldap_idmap_user_search_base,
            },
            locks=[{
                "type": mount_target_locks_type,
                "message": mount_target_locks_message,
                "related_resource_id": test_resource["id"],
                "time_created": mount_target_locks_time_created,
            }],
            nsg_ids=mount_target_nsg_ids,
            requested_throughput=mount_target_requested_throughput)
        ```

        ## Import

        MountTargets can be imported using the `id`, e.g.

        ```sh
        $ pulumi import oci:FileStorage/mountTarget:MountTarget test_mount_target "id"
        ```

        :param str resource_name: The name of the resource.
        :param MountTargetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(MountTargetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 hostname_label: Optional[pulumi.Input[str]] = None,
                 idmap_type: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 is_lock_override: Optional[pulumi.Input[bool]] = None,
                 kerberos: Optional[pulumi.Input[Union['MountTargetKerberosArgs', 'MountTargetKerberosArgsDict']]] = None,
                 ldap_idmap: Optional[pulumi.Input[Union['MountTargetLdapIdmapArgs', 'MountTargetLdapIdmapArgsDict']]] = None,
                 locks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MountTargetLockArgs', 'MountTargetLockArgsDict']]]]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 requested_throughput: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = MountTargetArgs.__new__(MountTargetArgs)

            if availability_domain is None and not opts.urn:
                raise TypeError("Missing required property 'availability_domain'")
            __props__.__dict__["availability_domain"] = availability_domain
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["hostname_label"] = hostname_label
            __props__.__dict__["idmap_type"] = idmap_type
            __props__.__dict__["ip_address"] = ip_address
            __props__.__dict__["is_lock_override"] = is_lock_override
            __props__.__dict__["kerberos"] = kerberos
            __props__.__dict__["ldap_idmap"] = ldap_idmap
            __props__.__dict__["locks"] = locks
            __props__.__dict__["nsg_ids"] = nsg_ids
            __props__.__dict__["requested_throughput"] = requested_throughput
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["export_set_id"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["observed_throughput"] = None
            __props__.__dict__["private_ip_ids"] = None
            __props__.__dict__["reserved_storage_capacity"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_billing_cycle_end"] = None
            __props__.__dict__["time_created"] = None
        super(MountTarget, __self__).__init__(
            'oci:FileStorage/mountTarget:MountTarget',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            availability_domain: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            export_set_id: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            hostname_label: Optional[pulumi.Input[str]] = None,
            idmap_type: Optional[pulumi.Input[str]] = None,
            ip_address: Optional[pulumi.Input[str]] = None,
            is_lock_override: Optional[pulumi.Input[bool]] = None,
            kerberos: Optional[pulumi.Input[Union['MountTargetKerberosArgs', 'MountTargetKerberosArgsDict']]] = None,
            ldap_idmap: Optional[pulumi.Input[Union['MountTargetLdapIdmapArgs', 'MountTargetLdapIdmapArgsDict']]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            locks: Optional[pulumi.Input[Sequence[pulumi.Input[Union['MountTargetLockArgs', 'MountTargetLockArgsDict']]]]] = None,
            nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            observed_throughput: Optional[pulumi.Input[str]] = None,
            private_ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            requested_throughput: Optional[pulumi.Input[str]] = None,
            reserved_storage_capacity: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            time_billing_cycle_end: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None) -> 'MountTarget':
        """
        Get an existing MountTarget resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_domain: The availability domain in which to create the mount target.  Example: `Uocm:PHX-AD-1`
        :param pulumi.Input[str] compartment_id: (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to create the mount target.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My mount target`
        :param pulumi.Input[str] export_set_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated export set. Controls what file systems will be exported through Network File System (NFS) protocol on this mount target.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] hostname_label: The hostname for the mount target's IP address, used for DNS resolution. The value is the hostname portion of the private IP address's fully qualified domain name (FQDN). For example, `files-1` in the FQDN `files-1.subnet123.vcn1.oraclevcn.com`. Must be unique across all VNICs in the subnet and comply with [RFC 952](https://tools.ietf.org/html/rfc952) and [RFC 1123](https://tools.ietf.org/html/rfc1123).
               
               Note: This attribute value is stored in the [PrivateIp](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/PrivateIp/) resource, not in the `mountTarget` resource. To update the `hostnameLabel`, use `GetMountTarget` to obtain the [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the mount target's private IPs (`privateIpIds`). Then, you can use [UpdatePrivateIp](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/PrivateIp/UpdatePrivateIp) to update the `hostnameLabel` value.
               
               For more information, see [DNS in Your Virtual Cloud Network](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/dns.htm).
               
               Example: `files-1`
        :param pulumi.Input[str] idmap_type: (Updatable) The method used to map a Unix UID to secondary groups, if any.
        :param pulumi.Input[str] ip_address: A private IP address of your choice. Must be an available IP address within the subnet's CIDR. If you don't specify a value, Oracle automatically assigns a private IP address from the subnet.  Example: `10.0.3.3`
        :param pulumi.Input[bool] is_lock_override: (Updatable) Whether to override locks (if any exist).
        :param pulumi.Input[Union['MountTargetKerberosArgs', 'MountTargetKerberosArgsDict']] kerberos: (Updatable) Kerberos details needed to create configuration.
        :param pulumi.Input[Union['MountTargetLdapIdmapArgs', 'MountTargetLdapIdmapArgsDict']] ldap_idmap: (Updatable) Mount target details about the LDAP ID mapping configuration.
        :param pulumi.Input[str] lifecycle_details: Additional information about the current 'lifecycleState'.
        :param pulumi.Input[Sequence[pulumi.Input[Union['MountTargetLockArgs', 'MountTargetLockArgsDict']]]] locks: Locks associated with this resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: (Updatable) A list of Network Security Group [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with this mount target. A maximum of 5 is allowed. Setting this to an empty array after the list is created removes the mount target from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm).
        :param pulumi.Input[str] observed_throughput: Current billed throughput for mount target in Gbps. This corresponds to shape of mount target. Available shapes and corresponding throughput are listed at [Mount Target Performance](https://docs.oracle.com/iaas/Content/File/Tasks/managingmounttargets.htm#performance).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] private_ip_ids: The OCIDs of the private IP addresses associated with this mount target.
        :param pulumi.Input[str] requested_throughput: (Updatable) Throughput for mount target in Gbps. Currently only 1 Gbps of requestedThroughput is supported during create MountTarget. Available shapes and corresponding throughput are listed at [Mount Target Performance](https://docs.oracle.com/iaas/Content/File/Tasks/managingmounttargets.htm#performance).
        :param pulumi.Input[str] reserved_storage_capacity: * Reserved capacity (GB) associated with this mount target. Reserved capacity depends on observedThroughput value of mount target. Value is listed at [Mount Target Performance](https://docs.oracle.com/iaas/Content/File/Tasks/managingmounttargets.htm#performance).
        :param pulumi.Input[str] state: The current state of the mount target.
        :param pulumi.Input[str] subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet in which to create the mount target. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] system_tags: System tags for this resource. System tags are applied to resources by internal Oracle Cloud Infrastructure services.
        :param pulumi.Input[str] time_billing_cycle_end: The date and time the mount target current billing cycle will end, expressed in  [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format. Once a cycle ends, it is updated  automatically to next timestamp which is after 30 days.  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[str] time_created: The date and time the mount target was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _MountTargetState.__new__(_MountTargetState)

        __props__.__dict__["availability_domain"] = availability_domain
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["export_set_id"] = export_set_id
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["hostname_label"] = hostname_label
        __props__.__dict__["idmap_type"] = idmap_type
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["is_lock_override"] = is_lock_override
        __props__.__dict__["kerberos"] = kerberos
        __props__.__dict__["ldap_idmap"] = ldap_idmap
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["locks"] = locks
        __props__.__dict__["nsg_ids"] = nsg_ids
        __props__.__dict__["observed_throughput"] = observed_throughput
        __props__.__dict__["private_ip_ids"] = private_ip_ids
        __props__.__dict__["requested_throughput"] = requested_throughput
        __props__.__dict__["reserved_storage_capacity"] = reserved_storage_capacity
        __props__.__dict__["state"] = state
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_billing_cycle_end"] = time_billing_cycle_end
        __props__.__dict__["time_created"] = time_created
        return MountTarget(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Output[str]:
        """
        The availability domain in which to create the mount target.  Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to create the mount target.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.  Example: `My mount target`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="exportSetId")
    def export_set_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated export set. Controls what file systems will be exported through Network File System (NFS) protocol on this mount target.
        """
        return pulumi.get(self, "export_set_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="hostnameLabel")
    def hostname_label(self) -> pulumi.Output[str]:
        """
        The hostname for the mount target's IP address, used for DNS resolution. The value is the hostname portion of the private IP address's fully qualified domain name (FQDN). For example, `files-1` in the FQDN `files-1.subnet123.vcn1.oraclevcn.com`. Must be unique across all VNICs in the subnet and comply with [RFC 952](https://tools.ietf.org/html/rfc952) and [RFC 1123](https://tools.ietf.org/html/rfc1123).

        Note: This attribute value is stored in the [PrivateIp](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/PrivateIp/) resource, not in the `mountTarget` resource. To update the `hostnameLabel`, use `GetMountTarget` to obtain the [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the mount target's private IPs (`privateIpIds`). Then, you can use [UpdatePrivateIp](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/PrivateIp/UpdatePrivateIp) to update the `hostnameLabel` value.

        For more information, see [DNS in Your Virtual Cloud Network](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/dns.htm).

        Example: `files-1`
        """
        return pulumi.get(self, "hostname_label")

    @property
    @pulumi.getter(name="idmapType")
    def idmap_type(self) -> pulumi.Output[str]:
        """
        (Updatable) The method used to map a Unix UID to secondary groups, if any.
        """
        return pulumi.get(self, "idmap_type")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[str]:
        """
        A private IP address of your choice. Must be an available IP address within the subnet's CIDR. If you don't specify a value, Oracle automatically assigns a private IP address from the subnet.  Example: `10.0.3.3`
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="isLockOverride")
    def is_lock_override(self) -> pulumi.Output[bool]:
        """
        (Updatable) Whether to override locks (if any exist).
        """
        return pulumi.get(self, "is_lock_override")

    @property
    @pulumi.getter
    def kerberos(self) -> pulumi.Output[Optional['outputs.MountTargetKerberos']]:
        """
        (Updatable) Kerberos details needed to create configuration.
        """
        return pulumi.get(self, "kerberos")

    @property
    @pulumi.getter(name="ldapIdmap")
    def ldap_idmap(self) -> pulumi.Output[Optional['outputs.MountTargetLdapIdmap']]:
        """
        (Updatable) Mount target details about the LDAP ID mapping configuration.
        """
        return pulumi.get(self, "ldap_idmap")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Additional information about the current 'lifecycleState'.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def locks(self) -> pulumi.Output[Sequence['outputs.MountTargetLock']]:
        """
        Locks associated with this resource.
        """
        return pulumi.get(self, "locks")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        (Updatable) A list of Network Security Group [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) associated with this mount target. A maximum of 5 is allowed. Setting this to an empty array after the list is created removes the mount target from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm).
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="observedThroughput")
    def observed_throughput(self) -> pulumi.Output[str]:
        """
        Current billed throughput for mount target in Gbps. This corresponds to shape of mount target. Available shapes and corresponding throughput are listed at [Mount Target Performance](https://docs.oracle.com/iaas/Content/File/Tasks/managingmounttargets.htm#performance).
        """
        return pulumi.get(self, "observed_throughput")

    @property
    @pulumi.getter(name="privateIpIds")
    def private_ip_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The OCIDs of the private IP addresses associated with this mount target.
        """
        return pulumi.get(self, "private_ip_ids")

    @property
    @pulumi.getter(name="requestedThroughput")
    def requested_throughput(self) -> pulumi.Output[str]:
        """
        (Updatable) Throughput for mount target in Gbps. Currently only 1 Gbps of requestedThroughput is supported during create MountTarget. Available shapes and corresponding throughput are listed at [Mount Target Performance](https://docs.oracle.com/iaas/Content/File/Tasks/managingmounttargets.htm#performance).
        """
        return pulumi.get(self, "requested_throughput")

    @property
    @pulumi.getter(name="reservedStorageCapacity")
    def reserved_storage_capacity(self) -> pulumi.Output[str]:
        """
        * Reserved capacity (GB) associated with this mount target. Reserved capacity depends on observedThroughput value of mount target. Value is listed at [Mount Target Performance](https://docs.oracle.com/iaas/Content/File/Tasks/managingmounttargets.htm#performance).
        """
        return pulumi.get(self, "reserved_storage_capacity")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the mount target.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet in which to create the mount target. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, str]]:
        """
        System tags for this resource. System tags are applied to resources by internal Oracle Cloud Infrastructure services.
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeBillingCycleEnd")
    def time_billing_cycle_end(self) -> pulumi.Output[str]:
        """
        The date and time the mount target current billing cycle will end, expressed in  [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format. Once a cycle ends, it is updated  automatically to next timestamp which is after 30 days.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_billing_cycle_end")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the mount target was created, expressed in [RFC 3339](https://tools.ietf.org/rfc/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

