# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetDomainGovernanceResult',
    'AwaitableGetDomainGovernanceResult',
    'get_domain_governance',
    'get_domain_governance_output',
]

@pulumi.output_type
class GetDomainGovernanceResult:
    """
    A collection of values returned by getDomainGovernance.
    """
    def __init__(__self__, defined_tags=None, domain_governance_id=None, domain_id=None, freeform_tags=None, id=None, is_governance_enabled=None, ons_subscription_id=None, ons_topic_id=None, owner_id=None, state=None, subscription_email=None, system_tags=None, time_created=None, time_updated=None):
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if domain_governance_id and not isinstance(domain_governance_id, str):
            raise TypeError("Expected argument 'domain_governance_id' to be a str")
        pulumi.set(__self__, "domain_governance_id", domain_governance_id)
        if domain_id and not isinstance(domain_id, str):
            raise TypeError("Expected argument 'domain_id' to be a str")
        pulumi.set(__self__, "domain_id", domain_id)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_governance_enabled and not isinstance(is_governance_enabled, bool):
            raise TypeError("Expected argument 'is_governance_enabled' to be a bool")
        pulumi.set(__self__, "is_governance_enabled", is_governance_enabled)
        if ons_subscription_id and not isinstance(ons_subscription_id, str):
            raise TypeError("Expected argument 'ons_subscription_id' to be a str")
        pulumi.set(__self__, "ons_subscription_id", ons_subscription_id)
        if ons_topic_id and not isinstance(ons_topic_id, str):
            raise TypeError("Expected argument 'ons_topic_id' to be a str")
        pulumi.set(__self__, "ons_topic_id", ons_topic_id)
        if owner_id and not isinstance(owner_id, str):
            raise TypeError("Expected argument 'owner_id' to be a str")
        pulumi.set(__self__, "owner_id", owner_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if subscription_email and not isinstance(subscription_email, str):
            raise TypeError("Expected argument 'subscription_email' to be a str")
        pulumi.set(__self__, "subscription_email", subscription_email)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="domainGovernanceId")
    def domain_governance_id(self) -> str:
        return pulumi.get(self, "domain_governance_id")

    @property
    @pulumi.getter(name="domainId")
    def domain_id(self) -> str:
        """
        The OCID of the domain associated with this domain governance entity.
        """
        return pulumi.get(self, "domain_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isGovernanceEnabled")
    def is_governance_enabled(self) -> bool:
        """
        Indicates whether governance is enabled for this domain.
        """
        return pulumi.get(self, "is_governance_enabled")

    @property
    @pulumi.getter(name="onsSubscriptionId")
    def ons_subscription_id(self) -> str:
        """
        The ONS subscription associated with this domain governance entity.
        """
        return pulumi.get(self, "ons_subscription_id")

    @property
    @pulumi.getter(name="onsTopicId")
    def ons_topic_id(self) -> str:
        """
        The ONS topic associated with this domain governance entity.
        """
        return pulumi.get(self, "ons_topic_id")

    @property
    @pulumi.getter(name="ownerId")
    def owner_id(self) -> str:
        """
        The OCID of the tenancy that owns this domain governance entity.
        """
        return pulumi.get(self, "owner_id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        Lifecycle state of the domain governance entity.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subscriptionEmail")
    def subscription_email(self) -> str:
        """
        Email address to be used to notify the user, and that the ONS subscription will be created with.
        """
        return pulumi.get(self, "subscription_email")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        Date-time when this domain governance was created. An RFC 3339-formatted date and time string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        Date-time when this domain governance was last updated. An RFC 3339-formatted date and time string.
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetDomainGovernanceResult(GetDomainGovernanceResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDomainGovernanceResult(
            defined_tags=self.defined_tags,
            domain_governance_id=self.domain_governance_id,
            domain_id=self.domain_id,
            freeform_tags=self.freeform_tags,
            id=self.id,
            is_governance_enabled=self.is_governance_enabled,
            ons_subscription_id=self.ons_subscription_id,
            ons_topic_id=self.ons_topic_id,
            owner_id=self.owner_id,
            state=self.state,
            subscription_email=self.subscription_email,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_domain_governance(domain_governance_id: Optional[str] = None,
                          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDomainGovernanceResult:
    """
    This data source provides details about a specific Domain Governance resource in Oracle Cloud Infrastructure Tenantmanagercontrolplane service.

    Gets information about the domain governance entity.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_domain_governance = oci.Tenantmanagercontrolplane.get_domain_governance(domain_governance_id=test_domain_governance_oci_tenantmanagercontrolplane_domain_governance["id"])
    ```


    :param str domain_governance_id: The domain governance OCID.
    """
    __args__ = dict()
    __args__['domainGovernanceId'] = domain_governance_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Tenantmanagercontrolplane/getDomainGovernance:getDomainGovernance', __args__, opts=opts, typ=GetDomainGovernanceResult).value

    return AwaitableGetDomainGovernanceResult(
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        domain_governance_id=pulumi.get(__ret__, 'domain_governance_id'),
        domain_id=pulumi.get(__ret__, 'domain_id'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        is_governance_enabled=pulumi.get(__ret__, 'is_governance_enabled'),
        ons_subscription_id=pulumi.get(__ret__, 'ons_subscription_id'),
        ons_topic_id=pulumi.get(__ret__, 'ons_topic_id'),
        owner_id=pulumi.get(__ret__, 'owner_id'),
        state=pulumi.get(__ret__, 'state'),
        subscription_email=pulumi.get(__ret__, 'subscription_email'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_domain_governance_output(domain_governance_id: Optional[pulumi.Input[str]] = None,
                                 opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDomainGovernanceResult]:
    """
    This data source provides details about a specific Domain Governance resource in Oracle Cloud Infrastructure Tenantmanagercontrolplane service.

    Gets information about the domain governance entity.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_domain_governance = oci.Tenantmanagercontrolplane.get_domain_governance(domain_governance_id=test_domain_governance_oci_tenantmanagercontrolplane_domain_governance["id"])
    ```


    :param str domain_governance_id: The domain governance OCID.
    """
    __args__ = dict()
    __args__['domainGovernanceId'] = domain_governance_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Tenantmanagercontrolplane/getDomainGovernance:getDomainGovernance', __args__, opts=opts, typ=GetDomainGovernanceResult)
    return __ret__.apply(lambda __response__: GetDomainGovernanceResult(
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        domain_governance_id=pulumi.get(__response__, 'domain_governance_id'),
        domain_id=pulumi.get(__response__, 'domain_id'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        is_governance_enabled=pulumi.get(__response__, 'is_governance_enabled'),
        ons_subscription_id=pulumi.get(__response__, 'ons_subscription_id'),
        ons_topic_id=pulumi.get(__response__, 'ons_topic_id'),
        owner_id=pulumi.get(__response__, 'owner_id'),
        state=pulumi.get(__response__, 'state'),
        subscription_email=pulumi.get(__response__, 'subscription_email'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
