# generated by datamodel-codegen:
#   filename:  tests/testCase.json
#   timestamp: 2023-02-27T16:11:02+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import BaseModel, Extra, Field

from ..type import basic, entityHistory, entityReference
from . import basic as basic_1


class TestCaseParameterValue(BaseModel):
    name: Optional[str] = Field(
        None,
        description='name of the parameter. Must match the parameter names in testCaseParameterDefinition',
    )
    value: Optional[str] = Field(
        None,
        description='value to be passed for the Parameters. These are input from Users. We capture this in in string and convert during the runtime.',
    )


class TestCase(BaseModel):
    class Config:
        extra = Extra.forbid

    id: Optional[basic.Uuid] = Field(
        None, description='Unique identifier of this table instance.'
    )
    name: basic.EntityName = Field(
        ..., description='Name that identifies this test case.'
    )
    displayName: Optional[str] = Field(
        None, description='Display Name that identifies this test.'
    )
    fullyQualifiedName: Optional[basic.FullyQualifiedEntityName] = Field(
        None, description='FullyQualifiedName same as `name`.'
    )
    description: Optional[basic.Markdown] = Field(
        None, description='Description of the testcase.'
    )
    testDefinition: entityReference.EntityReference
    entityLink: basic.EntityLink
    entityFQN: Optional[str] = None
    testSuite: entityReference.EntityReference
    parameterValues: Optional[List[TestCaseParameterValue]] = None
    testCaseResult: Optional[basic_1.TestCaseResult] = None
    version: Optional[entityHistory.EntityVersion] = Field(
        None, description='Metadata version of the entity.'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this Pipeline.'
    )
    updatedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
    )
    updatedBy: Optional[str] = Field(None, description='User who made the update.')
    href: Optional[basic.Href] = Field(
        None, description='Link to the resource corresponding to this entity.'
    )
    changeDescription: Optional[entityHistory.ChangeDescription] = Field(
        None, description='Change that lead to this version of the entity.'
    )
    deleted: Optional[bool] = Field(
        False, description='When `true` indicates the entity has been soft deleted.'
    )
