# generated by datamodel-codegen:
#   filename:  api/teams/createUser.json
#   timestamp: 2022-10-03T15:16:21+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import BaseModel, Extra, Field

from ...entity.teams import user
from ...type import basic, profile


class CreatePasswordType(Enum):
    ADMINCREATE = 'ADMINCREATE'
    USERCREATE = 'USERCREATE'


class CreateUserRequest(BaseModel):
    class Config:
        extra = Extra.forbid

    name: basic.EntityName
    description: Optional[basic.Markdown] = Field(
        None, description='Used for user biography.'
    )
    displayName: Optional[str] = Field(
        None, description="Name used for display purposes. Example 'FirstName LastName'"
    )
    email: basic.Email
    timezone: Optional[str] = Field(None, description='Timezone of the user')
    isBot: Optional[bool] = Field(
        None,
        description='When true indicates user is a bot with appropriate privileges',
    )
    botName: Optional[str] = Field(
        None,
        description='User bot name if we want to associate this bot with an specific bot',
    )
    isAdmin: Optional[bool] = Field(
        False,
        description='When true indicates user is an administrator for the system with superuser privileges',
    )
    profile: Optional[profile.Profile] = None
    teams: Optional[List[basic.Uuid]] = Field(
        None, description='Teams that the user belongs to'
    )
    roles: Optional[List[basic.Uuid]] = Field(
        None, description='Roles that the user has been assigned'
    )
    authenticationMechanism: Optional[user.AuthenticationMechanism] = Field(
        None, description='Authentication mechanism specified '
    )
    createPasswordType: Optional[CreatePasswordType] = Field(
        CreatePasswordType.USERCREATE, description='User Password Method'
    )
    password: Optional[str] = Field(None, description='Password for User')
    confirmPassword: Optional[str] = Field(
        None, description='Confirm Password for User'
    )
