# generated by datamodel-codegen:
#   filename:  entity/services/dashboardService.json
#   timestamp: 2022-10-03T15:16:21+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import BaseModel, Extra, Field

from ...type import basic, entityHistory, entityReference
from .connections.dashboard import (
    customDashboardConnection,
    lookerConnection,
    metabaseConnection,
    modeConnection,
    powerBIConnection,
    redashConnection,
    supersetConnection,
    tableauConnection,
)


class DashboardServiceType(Enum):
    Superset = 'Superset'
    Looker = 'Looker'
    Tableau = 'Tableau'
    Redash = 'Redash'
    Metabase = 'Metabase'
    PowerBI = 'PowerBI'
    Mode = 'Mode'
    CustomDashboard = 'CustomDashboard'


class DashboardConnection(BaseModel):
    class Config:
        extra = Extra.forbid

    config: Optional[
        Union[
            lookerConnection.LookerConnection,
            metabaseConnection.MetabaseConnection,
            powerBIConnection.PowerBIConnection,
            redashConnection.RedashConnection,
            supersetConnection.SupersetConnection,
            tableauConnection.TableauConnection,
            modeConnection.ModeConnection,
            customDashboardConnection.CustomDashboardConnection,
        ]
    ] = None


class DashboardService(BaseModel):
    class Config:
        extra = Extra.forbid

    id: basic.Uuid = Field(
        ..., description='Unique identifier of this dashboard service instance.'
    )
    name: basic.EntityName = Field(
        ..., description='Name that identifies this dashboard service.'
    )
    fullyQualifiedName: Optional[basic.FullyQualifiedEntityName] = Field(
        None, description='FullyQualifiedName same as `name`.'
    )
    displayName: Optional[str] = Field(
        None, description='Display Name that identifies this dashboard service.'
    )
    serviceType: DashboardServiceType = Field(
        ..., description='Type of dashboard service such as Looker or Superset...'
    )
    description: Optional[basic.Markdown] = Field(
        None, description='Description of a dashboard service instance.'
    )
    connection: Optional[DashboardConnection] = None
    pipelines: Optional[entityReference.EntityReferenceList] = Field(
        None, description='References to pipelines deployed for this dashboard service.'
    )
    owner: Optional[entityReference.EntityReference] = Field(
        None, description='Owner of this dashboard service.'
    )
    version: Optional[entityHistory.EntityVersion] = Field(
        None, description='Metadata version of the entity.'
    )
    updatedAt: Optional[basic.Timestamp] = Field(
        None,
        description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
    )
    updatedBy: Optional[str] = Field(None, description='User who made the update.')
    href: Optional[basic.Href] = Field(
        None,
        description='Link to the resource corresponding to this dashboard service.',
    )
    changeDescription: Optional[entityHistory.ChangeDescription] = Field(
        None, description='Change that lead to this version of the entity.'
    )
    deleted: Optional[bool] = Field(
        False, description='When `true` indicates the entity has been soft deleted.'
    )
