from fmot.fqir import GraphProto, TensorProto, NodeProto, registry_v1
from fmot.tracing.utils import autogen_name


def is_autogen_name(s: str):
    """
    Returns true if the string starts with the character "%", typically only
    true for autogenerated names
    """
    return s.startswith("%")


def copy_repeated_output(graph: GraphProto):
    seen = set()
    for i, x in enumerate(graph.outputs):
        if x in seen:
            new_x = TensorProto(
                name=autogen_name("x"),
                dtype=x.dtype,
                shape=x.shape,
                quanta=x.quanta,
                named_dims=x.named_dims,
            )
            copy = NodeProto(
                name=f"{x.name}-copy",
                optype=registry_v1["copy"],
                constants={},
                inputs={"x": x},
                outputs=[new_x],
            )
            graph.add_node(copy)
            graph.outputs[i] = copy
        else:
            seen.add(x)

    return graph


def rename_outputs(graph: GraphProto):
    """
    Renames outputs with autogenerated names (e.g. %x.157) based on their
    output order.

    Won't rename outputs with a deliberate name (e.g. "auto_output") that were
    provided based on the fmot.tag API
    """
    arith = graph.subgraphs["ARITH"]

    arith = copy_repeated_output(arith)

    for i, x in enumerate(arith.outputs):
        if is_autogen_name(x.name):
            x.name = f"output.{i}"

    return graph
