# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/00_utils.ipynb.

# %% auto 0
__all__ = ['flatten_list', 'deduplicate_list', 'validate_range']

# %% ../nbs/00_utils.ipynb 3
from .imports import *

# %% ../nbs/00_utils.ipynb 4
def flatten_list(input: list[list] # nested list
                ) -> list: # flattened list
    "Flattens list of lists (not recursive)"
    return [item for sublist in input for item in sublist]

# %% ../nbs/00_utils.ipynb 6
def deduplicate_list(input: list, # input list containing duplicates
                     key_func: Optional[Callable]=None # function to generate deduplication keys
                    ) -> list: # output list, deduplicated
    'deduplicates list while maintaining order'
    
    if key_func:
        od = OrderedDict()
        for item in input:
            od[key_func(item)] = item
        output = list(od.values())
    else:
        output = list(OrderedDict.fromkeys(input))
    
    return output

# %% ../nbs/00_utils.ipynb 8
def validate_range(min_val:   Union[int, float, None], # minimum range value
                   max_val:   Union[int, float, None], # maximum range value
                   min_limit: Union[int, float], # min value limit - replaces `min_val` if `min_val` is None
                   max_limit: Union[int, float]  # max value limit - replaces `max_val` if `max_val` is None
                  ) -> Tuple[Union[int, float], Union[int, float]]: # resolved [min_val, max_val] range
    
    '''
    given a range `min_val`, `max_val`, and range limits `min_limit`, `max_limit`, this 
    function verifies that `min_limit < min_val < max_val < max_limit` and returns the resolved range
    '''
    
    if (min_val is None) and (max_val is None):
        raise ValueError('one of min_val or max_val must be defined')
        
    if min_val is None:
        min_val = min_limit
        
    if max_val is None:
        max_val = max_limit
        
    if min_val > max_val:
        raise ValueError('min_val must be less than max_val')
        
    if min_val < min_limit:
        raise ValueError('min_val less than min_limit')
        
    if max_val > max_limit:
        raise ValueError('max_val greater than max_limit')
        
    return min_val, max_val
