"""File generated by TLObjects' generator. All changes will be ERASED"""
from ...tl.tlobject import TLObject
from typing import Optional, List, Union, TYPE_CHECKING
from . import account, auth, bots, channels, chatlists, contacts, help, messages, payments, phone, photos, premium, stats, stickers, storage, stories, updates, upload, users
import os
import struct
from datetime import datetime
if TYPE_CHECKING:
    from ...tl.types import Typefuture_salt



class AccessPointRule(TLObject):
    CONSTRUCTOR_ID = 0x4679b65f
    SUBCLASS_OF_ID = 0xb1aca0fd

    def __init__(self, phone_prefix_rules: str, dc_id: int, ips: List['TypeIpPort']):
        """
        Constructor for AccessPointRule: Instance of AccessPointRule.
        """
        self.phone_prefix_rules = phone_prefix_rules
        self.dc_id = dc_id
        self.ips = ips

    def to_dict(self):
        return {
            '_': 'AccessPointRule',
            'phone_prefix_rules': self.phone_prefix_rules,
            'dc_id': self.dc_id,
            'ips': [] if self.ips is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.ips]
        }

    def _bytes(self):
        return b''.join((
            b'_\xb6yF',
            self.serialize_bytes(self.phone_prefix_rules),
            struct.pack('<i', self.dc_id),
            struct.pack('<i', len(self.ips)),b''.join(x._bytes() for x in self.ips),
        ))

    @classmethod
    def from_reader(cls, reader):
        _phone_prefix_rules = reader.tgread_string()
        _dc_id = reader.read_int()
        _ips = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _ips.append(_x)

        return cls(phone_prefix_rules=_phone_prefix_rules, dc_id=_dc_id, ips=_ips)


class AccountDaysTTL(TLObject):
    CONSTRUCTOR_ID = 0xb8d0afdf
    SUBCLASS_OF_ID = 0xbaa39d88

    def __init__(self, days: int):
        """
        Constructor for AccountDaysTTL: Instance of AccountDaysTTL.
        """
        self.days = days

    def to_dict(self):
        return {
            '_': 'AccountDaysTTL',
            'days': self.days
        }

    def _bytes(self):
        return b''.join((
            b'\xdf\xaf\xd0\xb8',
            struct.pack('<i', self.days),
        ))

    @classmethod
    def from_reader(cls, reader):
        _days = reader.read_int()
        return cls(days=_days)


class AppWebViewResultUrl(TLObject):
    CONSTRUCTOR_ID = 0x3c1b4f0d
    SUBCLASS_OF_ID = 0x1c24a413

    def __init__(self, url: str):
        """
        Constructor for AppWebViewResult: Instance of AppWebViewResultUrl.
        """
        self.url = url

    def to_dict(self):
        return {
            '_': 'AppWebViewResultUrl',
            'url': self.url
        }

    def _bytes(self):
        return b''.join((
            b'\rO\x1b<',
            self.serialize_bytes(self.url),
        ))

    @classmethod
    def from_reader(cls, reader):
        _url = reader.tgread_string()
        return cls(url=_url)


class AttachMenuBot(TLObject):
    CONSTRUCTOR_ID = 0xd90d8dfe
    SUBCLASS_OF_ID = 0x9f087446

    def __init__(self, bot_id: int, short_name: str, icons: List['TypeAttachMenuBotIcon'], inactive: Optional[bool]=None, has_settings: Optional[bool]=None, request_write_access: Optional[bool]=None, show_in_attach_menu: Optional[bool]=None, show_in_side_menu: Optional[bool]=None, side_menu_disclaimer_needed: Optional[bool]=None, peer_types: Optional[List['TypeAttachMenuPeerType']]=None):
        """
        Constructor for AttachMenuBot: Instance of AttachMenuBot.
        """
        self.bot_id = bot_id
        self.short_name = short_name
        self.icons = icons
        self.inactive = inactive
        self.has_settings = has_settings
        self.request_write_access = request_write_access
        self.show_in_attach_menu = show_in_attach_menu
        self.show_in_side_menu = show_in_side_menu
        self.side_menu_disclaimer_needed = side_menu_disclaimer_needed
        self.peer_types = peer_types

    def to_dict(self):
        return {
            '_': 'AttachMenuBot',
            'bot_id': self.bot_id,
            'short_name': self.short_name,
            'icons': [] if self.icons is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.icons],
            'inactive': self.inactive,
            'has_settings': self.has_settings,
            'request_write_access': self.request_write_access,
            'show_in_attach_menu': self.show_in_attach_menu,
            'show_in_side_menu': self.show_in_side_menu,
            'side_menu_disclaimer_needed': self.side_menu_disclaimer_needed,
            'peer_types': [] if self.peer_types is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.peer_types]
        }

    def _bytes(self):
        assert ((self.show_in_attach_menu or self.show_in_attach_menu is not None) and (self.peer_types or self.peer_types is not None)) or ((self.show_in_attach_menu is None or self.show_in_attach_menu is False) and (self.peer_types is None or self.peer_types is False)), 'show_in_attach_menu, peer_types parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'\xfe\x8d\r\xd9',
            struct.pack('<I', (0 if self.inactive is None or self.inactive is False else 1) | (0 if self.has_settings is None or self.has_settings is False else 2) | (0 if self.request_write_access is None or self.request_write_access is False else 4) | (0 if self.show_in_attach_menu is None or self.show_in_attach_menu is False else 8) | (0 if self.show_in_side_menu is None or self.show_in_side_menu is False else 16) | (0 if self.side_menu_disclaimer_needed is None or self.side_menu_disclaimer_needed is False else 32) | (0 if self.peer_types is None or self.peer_types is False else 8)),
            struct.pack('<q', self.bot_id),
            self.serialize_bytes(self.short_name),
            b'' if self.peer_types is None or self.peer_types is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.peer_types)),b''.join(x._bytes() for x in self.peer_types))),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.icons)),b''.join(x._bytes() for x in self.icons),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _inactive = bool(flags & 1)
        _has_settings = bool(flags & 2)
        _request_write_access = bool(flags & 4)
        _show_in_attach_menu = bool(flags & 8)
        _show_in_side_menu = bool(flags & 16)
        _side_menu_disclaimer_needed = bool(flags & 32)
        _bot_id = reader.read_long()
        _short_name = reader.tgread_string()
        if flags & 8:
            reader.read_int()
            _peer_types = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _peer_types.append(_x)

        else:
            _peer_types = None
        reader.read_int()
        _icons = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _icons.append(_x)

        return cls(bot_id=_bot_id, short_name=_short_name, icons=_icons, inactive=_inactive, has_settings=_has_settings, request_write_access=_request_write_access, show_in_attach_menu=_show_in_attach_menu, show_in_side_menu=_show_in_side_menu, side_menu_disclaimer_needed=_side_menu_disclaimer_needed, peer_types=_peer_types)


class AttachMenuBotIcon(TLObject):
    CONSTRUCTOR_ID = 0xb2a7386b
    SUBCLASS_OF_ID = 0x80484555

    def __init__(self, name: str, icon: 'TypeDocument', colors: Optional[List['TypeAttachMenuBotIconColor']]=None):
        """
        Constructor for AttachMenuBotIcon: Instance of AttachMenuBotIcon.
        """
        self.name = name
        self.icon = icon
        self.colors = colors

    def to_dict(self):
        return {
            '_': 'AttachMenuBotIcon',
            'name': self.name,
            'icon': self.icon.to_dict() if isinstance(self.icon, TLObject) else self.icon,
            'colors': [] if self.colors is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.colors]
        }

    def _bytes(self):
        return b''.join((
            b'k8\xa7\xb2',
            struct.pack('<I', (0 if self.colors is None or self.colors is False else 1)),
            self.serialize_bytes(self.name),
            self.icon._bytes(),
            b'' if self.colors is None or self.colors is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.colors)),b''.join(x._bytes() for x in self.colors))),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _name = reader.tgread_string()
        _icon = reader.tgread_object()
        if flags & 1:
            reader.read_int()
            _colors = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _colors.append(_x)

        else:
            _colors = None
        return cls(name=_name, icon=_icon, colors=_colors)


class AttachMenuBotIconColor(TLObject):
    CONSTRUCTOR_ID = 0x4576f3f0
    SUBCLASS_OF_ID = 0xbea4cb6a

    def __init__(self, name: str, color: int):
        """
        Constructor for AttachMenuBotIconColor: Instance of AttachMenuBotIconColor.
        """
        self.name = name
        self.color = color

    def to_dict(self):
        return {
            '_': 'AttachMenuBotIconColor',
            'name': self.name,
            'color': self.color
        }

    def _bytes(self):
        return b''.join((
            b'\xf0\xf3vE',
            self.serialize_bytes(self.name),
            struct.pack('<i', self.color),
        ))

    @classmethod
    def from_reader(cls, reader):
        _name = reader.tgread_string()
        _color = reader.read_int()
        return cls(name=_name, color=_color)


class AttachMenuBots(TLObject):
    CONSTRUCTOR_ID = 0x3c4301c0
    SUBCLASS_OF_ID = 0x842e23da

    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int, bots: List['TypeAttachMenuBot'], users: List['TypeUser']):
        """
        Constructor for AttachMenuBots: Instance of either AttachMenuBotsNotModified, AttachMenuBots.
        """
        self.hash = hash
        self.bots = bots
        self.users = users

    def to_dict(self):
        return {
            '_': 'AttachMenuBots',
            'hash': self.hash,
            'bots': [] if self.bots is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.bots],
            'users': [] if self.users is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.users]
        }

    def _bytes(self):
        return b''.join((
            b'\xc0\x01C<',
            struct.pack('<q', self.hash),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.bots)),b''.join(x._bytes() for x in self.bots),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
        ))

    @classmethod
    def from_reader(cls, reader):
        _hash = reader.read_long()
        reader.read_int()
        _bots = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _bots.append(_x)

        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        return cls(hash=_hash, bots=_bots, users=_users)


class AttachMenuBotsBot(TLObject):
    CONSTRUCTOR_ID = 0x93bf667f
    SUBCLASS_OF_ID = 0xdb33883d

    def __init__(self, bot: 'TypeAttachMenuBot', users: List['TypeUser']):
        """
        Constructor for AttachMenuBotsBot: Instance of AttachMenuBotsBot.
        """
        self.bot = bot
        self.users = users

    def to_dict(self):
        return {
            '_': 'AttachMenuBotsBot',
            'bot': self.bot.to_dict() if isinstance(self.bot, TLObject) else self.bot,
            'users': [] if self.users is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.users]
        }

    def _bytes(self):
        return b''.join((
            b'\x7ff\xbf\x93',
            self.bot._bytes(),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
        ))

    @classmethod
    def from_reader(cls, reader):
        _bot = reader.tgread_object()
        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        return cls(bot=_bot, users=_users)


class AttachMenuBotsNotModified(TLObject):
    CONSTRUCTOR_ID = 0xf1d88a5c
    SUBCLASS_OF_ID = 0x842e23da

    def to_dict(self):
        return {
            '_': 'AttachMenuBotsNotModified'
        }

    def _bytes(self):
        return b''.join((
            b'\\\x8a\xd8\xf1',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class AttachMenuPeerTypeBotPM(TLObject):
    CONSTRUCTOR_ID = 0xc32bfa1a
    SUBCLASS_OF_ID = 0xd1d886d0

    def to_dict(self):
        return {
            '_': 'AttachMenuPeerTypeBotPM'
        }

    def _bytes(self):
        return b''.join((
            b'\x1a\xfa+\xc3',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class AttachMenuPeerTypeBroadcast(TLObject):
    CONSTRUCTOR_ID = 0x7bfbdefc
    SUBCLASS_OF_ID = 0xd1d886d0

    def to_dict(self):
        return {
            '_': 'AttachMenuPeerTypeBroadcast'
        }

    def _bytes(self):
        return b''.join((
            b'\xfc\xde\xfb{',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class AttachMenuPeerTypeChat(TLObject):
    CONSTRUCTOR_ID = 0x509113f
    SUBCLASS_OF_ID = 0xd1d886d0

    def to_dict(self):
        return {
            '_': 'AttachMenuPeerTypeChat'
        }

    def _bytes(self):
        return b''.join((
            b'?\x11\t\x05',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class AttachMenuPeerTypePM(TLObject):
    CONSTRUCTOR_ID = 0xf146d31f
    SUBCLASS_OF_ID = 0xd1d886d0

    def to_dict(self):
        return {
            '_': 'AttachMenuPeerTypePM'
        }

    def _bytes(self):
        return b''.join((
            b'\x1f\xd3F\xf1',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class AttachMenuPeerTypeSameBotPM(TLObject):
    CONSTRUCTOR_ID = 0x7d6be90e
    SUBCLASS_OF_ID = 0xd1d886d0

    def to_dict(self):
        return {
            '_': 'AttachMenuPeerTypeSameBotPM'
        }

    def _bytes(self):
        return b''.join((
            b'\x0e\xe9k}',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class Authorization(TLObject):
    CONSTRUCTOR_ID = 0xad01d61d
    SUBCLASS_OF_ID = 0xc913c01a

    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int, device_model: str, platform: str, system_version: str, api_id: int, app_name: str, app_version: str, date_created: Optional[datetime], date_active: Optional[datetime], ip: str, country: str, region: str, current: Optional[bool]=None, official_app: Optional[bool]=None, password_pending: Optional[bool]=None, encrypted_requests_disabled: Optional[bool]=None, call_requests_disabled: Optional[bool]=None, unconfirmed: Optional[bool]=None):
        """
        Constructor for Authorization: Instance of Authorization.
        """
        self.hash = hash
        self.device_model = device_model
        self.platform = platform
        self.system_version = system_version
        self.api_id = api_id
        self.app_name = app_name
        self.app_version = app_version
        self.date_created = date_created
        self.date_active = date_active
        self.ip = ip
        self.country = country
        self.region = region
        self.current = current
        self.official_app = official_app
        self.password_pending = password_pending
        self.encrypted_requests_disabled = encrypted_requests_disabled
        self.call_requests_disabled = call_requests_disabled
        self.unconfirmed = unconfirmed

    def to_dict(self):
        return {
            '_': 'Authorization',
            'hash': self.hash,
            'device_model': self.device_model,
            'platform': self.platform,
            'system_version': self.system_version,
            'api_id': self.api_id,
            'app_name': self.app_name,
            'app_version': self.app_version,
            'date_created': self.date_created,
            'date_active': self.date_active,
            'ip': self.ip,
            'country': self.country,
            'region': self.region,
            'current': self.current,
            'official_app': self.official_app,
            'password_pending': self.password_pending,
            'encrypted_requests_disabled': self.encrypted_requests_disabled,
            'call_requests_disabled': self.call_requests_disabled,
            'unconfirmed': self.unconfirmed
        }

    def _bytes(self):
        return b''.join((
            b'\x1d\xd6\x01\xad',
            struct.pack('<I', (0 if self.current is None or self.current is False else 1) | (0 if self.official_app is None or self.official_app is False else 2) | (0 if self.password_pending is None or self.password_pending is False else 4) | (0 if self.encrypted_requests_disabled is None or self.encrypted_requests_disabled is False else 8) | (0 if self.call_requests_disabled is None or self.call_requests_disabled is False else 16) | (0 if self.unconfirmed is None or self.unconfirmed is False else 32)),
            struct.pack('<q', self.hash),
            self.serialize_bytes(self.device_model),
            self.serialize_bytes(self.platform),
            self.serialize_bytes(self.system_version),
            struct.pack('<i', self.api_id),
            self.serialize_bytes(self.app_name),
            self.serialize_bytes(self.app_version),
            self.serialize_datetime(self.date_created),
            self.serialize_datetime(self.date_active),
            self.serialize_bytes(self.ip),
            self.serialize_bytes(self.country),
            self.serialize_bytes(self.region),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _current = bool(flags & 1)
        _official_app = bool(flags & 2)
        _password_pending = bool(flags & 4)
        _encrypted_requests_disabled = bool(flags & 8)
        _call_requests_disabled = bool(flags & 16)
        _unconfirmed = bool(flags & 32)
        _hash = reader.read_long()
        _device_model = reader.tgread_string()
        _platform = reader.tgread_string()
        _system_version = reader.tgread_string()
        _api_id = reader.read_int()
        _app_name = reader.tgread_string()
        _app_version = reader.tgread_string()
        _date_created = reader.tgread_date()
        _date_active = reader.tgread_date()
        _ip = reader.tgread_string()
        _country = reader.tgread_string()
        _region = reader.tgread_string()
        return cls(hash=_hash, device_model=_device_model, platform=_platform, system_version=_system_version, api_id=_api_id, app_name=_app_name, app_version=_app_version, date_created=_date_created, date_active=_date_active, ip=_ip, country=_country, region=_region, current=_current, official_app=_official_app, password_pending=_password_pending, encrypted_requests_disabled=_encrypted_requests_disabled, call_requests_disabled=_call_requests_disabled, unconfirmed=_unconfirmed)


class AutoDownloadSettings(TLObject):
    CONSTRUCTOR_ID = 0xbaa57628
    SUBCLASS_OF_ID = 0x512819c7

    def __init__(self, photo_size_max: int, video_size_max: int, file_size_max: int, video_upload_maxbitrate: int, small_queue_active_operations_max: int, large_queue_active_operations_max: int, disabled: Optional[bool]=None, video_preload_large: Optional[bool]=None, audio_preload_next: Optional[bool]=None, phonecalls_less_data: Optional[bool]=None, stories_preload: Optional[bool]=None):
        """
        Constructor for AutoDownloadSettings: Instance of AutoDownloadSettings.
        """
        self.photo_size_max = photo_size_max
        self.video_size_max = video_size_max
        self.file_size_max = file_size_max
        self.video_upload_maxbitrate = video_upload_maxbitrate
        self.small_queue_active_operations_max = small_queue_active_operations_max
        self.large_queue_active_operations_max = large_queue_active_operations_max
        self.disabled = disabled
        self.video_preload_large = video_preload_large
        self.audio_preload_next = audio_preload_next
        self.phonecalls_less_data = phonecalls_less_data
        self.stories_preload = stories_preload

    def to_dict(self):
        return {
            '_': 'AutoDownloadSettings',
            'photo_size_max': self.photo_size_max,
            'video_size_max': self.video_size_max,
            'file_size_max': self.file_size_max,
            'video_upload_maxbitrate': self.video_upload_maxbitrate,
            'small_queue_active_operations_max': self.small_queue_active_operations_max,
            'large_queue_active_operations_max': self.large_queue_active_operations_max,
            'disabled': self.disabled,
            'video_preload_large': self.video_preload_large,
            'audio_preload_next': self.audio_preload_next,
            'phonecalls_less_data': self.phonecalls_less_data,
            'stories_preload': self.stories_preload
        }

    def _bytes(self):
        return b''.join((
            b'(v\xa5\xba',
            struct.pack('<I', (0 if self.disabled is None or self.disabled is False else 1) | (0 if self.video_preload_large is None or self.video_preload_large is False else 2) | (0 if self.audio_preload_next is None or self.audio_preload_next is False else 4) | (0 if self.phonecalls_less_data is None or self.phonecalls_less_data is False else 8) | (0 if self.stories_preload is None or self.stories_preload is False else 16)),
            struct.pack('<i', self.photo_size_max),
            struct.pack('<q', self.video_size_max),
            struct.pack('<q', self.file_size_max),
            struct.pack('<i', self.video_upload_maxbitrate),
            struct.pack('<i', self.small_queue_active_operations_max),
            struct.pack('<i', self.large_queue_active_operations_max),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _disabled = bool(flags & 1)
        _video_preload_large = bool(flags & 2)
        _audio_preload_next = bool(flags & 4)
        _phonecalls_less_data = bool(flags & 8)
        _stories_preload = bool(flags & 16)
        _photo_size_max = reader.read_int()
        _video_size_max = reader.read_long()
        _file_size_max = reader.read_long()
        _video_upload_maxbitrate = reader.read_int()
        _small_queue_active_operations_max = reader.read_int()
        _large_queue_active_operations_max = reader.read_int()
        return cls(photo_size_max=_photo_size_max, video_size_max=_video_size_max, file_size_max=_file_size_max, video_upload_maxbitrate=_video_upload_maxbitrate, small_queue_active_operations_max=_small_queue_active_operations_max, large_queue_active_operations_max=_large_queue_active_operations_max, disabled=_disabled, video_preload_large=_video_preload_large, audio_preload_next=_audio_preload_next, phonecalls_less_data=_phonecalls_less_data, stories_preload=_stories_preload)


class AutoSaveException(TLObject):
    CONSTRUCTOR_ID = 0x81602d47
    SUBCLASS_OF_ID = 0xdd868129

    def __init__(self, peer: 'TypePeer', settings: 'TypeAutoSaveSettings'):
        """
        Constructor for AutoSaveException: Instance of AutoSaveException.
        """
        self.peer = peer
        self.settings = settings

    def to_dict(self):
        return {
            '_': 'AutoSaveException',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'settings': self.settings.to_dict() if isinstance(self.settings, TLObject) else self.settings
        }

    def _bytes(self):
        return b''.join((
            b'G-`\x81',
            self.peer._bytes(),
            self.settings._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _settings = reader.tgread_object()
        return cls(peer=_peer, settings=_settings)


class AutoSaveSettings(TLObject):
    CONSTRUCTOR_ID = 0xc84834ce
    SUBCLASS_OF_ID = 0xcd3b96e6

    def __init__(self, photos: Optional[bool]=None, videos: Optional[bool]=None, video_max_size: Optional[int]=None):
        """
        Constructor for AutoSaveSettings: Instance of AutoSaveSettings.
        """
        self.photos = photos
        self.videos = videos
        self.video_max_size = video_max_size

    def to_dict(self):
        return {
            '_': 'AutoSaveSettings',
            'photos': self.photos,
            'videos': self.videos,
            'video_max_size': self.video_max_size
        }

    def _bytes(self):
        return b''.join((
            b'\xce4H\xc8',
            struct.pack('<I', (0 if self.photos is None or self.photos is False else 1) | (0 if self.videos is None or self.videos is False else 2) | (0 if self.video_max_size is None or self.video_max_size is False else 4)),
            b'' if self.video_max_size is None or self.video_max_size is False else (struct.pack('<q', self.video_max_size)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _photos = bool(flags & 1)
        _videos = bool(flags & 2)
        if flags & 4:
            _video_max_size = reader.read_long()
        else:
            _video_max_size = None
        return cls(photos=_photos, videos=_videos, video_max_size=_video_max_size)


class AvailableReaction(TLObject):
    CONSTRUCTOR_ID = 0xc077ec01
    SUBCLASS_OF_ID = 0x8c1c9d73

    def __init__(self, reaction: str, title: str, static_icon: 'TypeDocument', appear_animation: 'TypeDocument', select_animation: 'TypeDocument', activate_animation: 'TypeDocument', effect_animation: 'TypeDocument', inactive: Optional[bool]=None, premium: Optional[bool]=None, around_animation: Optional['TypeDocument']=None, center_icon: Optional['TypeDocument']=None):
        """
        Constructor for AvailableReaction: Instance of AvailableReaction.
        """
        self.reaction = reaction
        self.title = title
        self.static_icon = static_icon
        self.appear_animation = appear_animation
        self.select_animation = select_animation
        self.activate_animation = activate_animation
        self.effect_animation = effect_animation
        self.inactive = inactive
        self.premium = premium
        self.around_animation = around_animation
        self.center_icon = center_icon

    def to_dict(self):
        return {
            '_': 'AvailableReaction',
            'reaction': self.reaction,
            'title': self.title,
            'static_icon': self.static_icon.to_dict() if isinstance(self.static_icon, TLObject) else self.static_icon,
            'appear_animation': self.appear_animation.to_dict() if isinstance(self.appear_animation, TLObject) else self.appear_animation,
            'select_animation': self.select_animation.to_dict() if isinstance(self.select_animation, TLObject) else self.select_animation,
            'activate_animation': self.activate_animation.to_dict() if isinstance(self.activate_animation, TLObject) else self.activate_animation,
            'effect_animation': self.effect_animation.to_dict() if isinstance(self.effect_animation, TLObject) else self.effect_animation,
            'inactive': self.inactive,
            'premium': self.premium,
            'around_animation': self.around_animation.to_dict() if isinstance(self.around_animation, TLObject) else self.around_animation,
            'center_icon': self.center_icon.to_dict() if isinstance(self.center_icon, TLObject) else self.center_icon
        }

    def _bytes(self):
        assert ((self.around_animation or self.around_animation is not None) and (self.center_icon or self.center_icon is not None)) or ((self.around_animation is None or self.around_animation is False) and (self.center_icon is None or self.center_icon is False)), 'around_animation, center_icon parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'\x01\xecw\xc0',
            struct.pack('<I', (0 if self.inactive is None or self.inactive is False else 1) | (0 if self.premium is None or self.premium is False else 4) | (0 if self.around_animation is None or self.around_animation is False else 2) | (0 if self.center_icon is None or self.center_icon is False else 2)),
            self.serialize_bytes(self.reaction),
            self.serialize_bytes(self.title),
            self.static_icon._bytes(),
            self.appear_animation._bytes(),
            self.select_animation._bytes(),
            self.activate_animation._bytes(),
            self.effect_animation._bytes(),
            b'' if self.around_animation is None or self.around_animation is False else (self.around_animation._bytes()),
            b'' if self.center_icon is None or self.center_icon is False else (self.center_icon._bytes()),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _inactive = bool(flags & 1)
        _premium = bool(flags & 4)
        _reaction = reader.tgread_string()
        _title = reader.tgread_string()
        _static_icon = reader.tgread_object()
        _appear_animation = reader.tgread_object()
        _select_animation = reader.tgread_object()
        _activate_animation = reader.tgread_object()
        _effect_animation = reader.tgread_object()
        if flags & 2:
            _around_animation = reader.tgread_object()
        else:
            _around_animation = None
        if flags & 2:
            _center_icon = reader.tgread_object()
        else:
            _center_icon = None
        return cls(reaction=_reaction, title=_title, static_icon=_static_icon, appear_animation=_appear_animation, select_animation=_select_animation, activate_animation=_activate_animation, effect_animation=_effect_animation, inactive=_inactive, premium=_premium, around_animation=_around_animation, center_icon=_center_icon)


class BadMsgNotification(TLObject):
    CONSTRUCTOR_ID = 0xa7eff811
    SUBCLASS_OF_ID = 0xcebaa157

    def __init__(self, bad_msg_id: int, bad_msg_seqno: int, error_code: int):
        """
        Constructor for BadMsgNotification: Instance of either BadMsgNotification, BadServerSalt.
        """
        self.bad_msg_id = bad_msg_id
        self.bad_msg_seqno = bad_msg_seqno
        self.error_code = error_code

    def to_dict(self):
        return {
            '_': 'BadMsgNotification',
            'bad_msg_id': self.bad_msg_id,
            'bad_msg_seqno': self.bad_msg_seqno,
            'error_code': self.error_code
        }

    def _bytes(self):
        return b''.join((
            b'\x11\xf8\xef\xa7',
            struct.pack('<q', self.bad_msg_id),
            struct.pack('<i', self.bad_msg_seqno),
            struct.pack('<i', self.error_code),
        ))

    @classmethod
    def from_reader(cls, reader):
        _bad_msg_id = reader.read_long()
        _bad_msg_seqno = reader.read_int()
        _error_code = reader.read_int()
        return cls(bad_msg_id=_bad_msg_id, bad_msg_seqno=_bad_msg_seqno, error_code=_error_code)


class BadServerSalt(TLObject):
    CONSTRUCTOR_ID = 0xedab447b
    SUBCLASS_OF_ID = 0xcebaa157

    def __init__(self, bad_msg_id: int, bad_msg_seqno: int, error_code: int, new_server_salt: int):
        """
        Constructor for BadMsgNotification: Instance of either BadMsgNotification, BadServerSalt.
        """
        self.bad_msg_id = bad_msg_id
        self.bad_msg_seqno = bad_msg_seqno
        self.error_code = error_code
        self.new_server_salt = new_server_salt

    def to_dict(self):
        return {
            '_': 'BadServerSalt',
            'bad_msg_id': self.bad_msg_id,
            'bad_msg_seqno': self.bad_msg_seqno,
            'error_code': self.error_code,
            'new_server_salt': self.new_server_salt
        }

    def _bytes(self):
        return b''.join((
            b'{D\xab\xed',
            struct.pack('<q', self.bad_msg_id),
            struct.pack('<i', self.bad_msg_seqno),
            struct.pack('<i', self.error_code),
            struct.pack('<q', self.new_server_salt),
        ))

    @classmethod
    def from_reader(cls, reader):
        _bad_msg_id = reader.read_long()
        _bad_msg_seqno = reader.read_int()
        _error_code = reader.read_int()
        _new_server_salt = reader.read_long()
        return cls(bad_msg_id=_bad_msg_id, bad_msg_seqno=_bad_msg_seqno, error_code=_error_code, new_server_salt=_new_server_salt)


class BankCardOpenUrl(TLObject):
    CONSTRUCTOR_ID = 0xf568028a
    SUBCLASS_OF_ID = 0xf2e2460e

    def __init__(self, url: str, name: str):
        """
        Constructor for BankCardOpenUrl: Instance of BankCardOpenUrl.
        """
        self.url = url
        self.name = name

    def to_dict(self):
        return {
            '_': 'BankCardOpenUrl',
            'url': self.url,
            'name': self.name
        }

    def _bytes(self):
        return b''.join((
            b'\x8a\x02h\xf5',
            self.serialize_bytes(self.url),
            self.serialize_bytes(self.name),
        ))

    @classmethod
    def from_reader(cls, reader):
        _url = reader.tgread_string()
        _name = reader.tgread_string()
        return cls(url=_url, name=_name)


class BaseThemeArctic(TLObject):
    CONSTRUCTOR_ID = 0x5b11125a
    SUBCLASS_OF_ID = 0x1f03f444

    def to_dict(self):
        return {
            '_': 'BaseThemeArctic'
        }

    def _bytes(self):
        return b''.join((
            b'Z\x12\x11[',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class BaseThemeClassic(TLObject):
    CONSTRUCTOR_ID = 0xc3a12462
    SUBCLASS_OF_ID = 0x1f03f444

    def to_dict(self):
        return {
            '_': 'BaseThemeClassic'
        }

    def _bytes(self):
        return b''.join((
            b'b$\xa1\xc3',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class BaseThemeDay(TLObject):
    CONSTRUCTOR_ID = 0xfbd81688
    SUBCLASS_OF_ID = 0x1f03f444

    def to_dict(self):
        return {
            '_': 'BaseThemeDay'
        }

    def _bytes(self):
        return b''.join((
            b'\x88\x16\xd8\xfb',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class BaseThemeNight(TLObject):
    CONSTRUCTOR_ID = 0xb7b31ea8
    SUBCLASS_OF_ID = 0x1f03f444

    def to_dict(self):
        return {
            '_': 'BaseThemeNight'
        }

    def _bytes(self):
        return b''.join((
            b'\xa8\x1e\xb3\xb7',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class BaseThemeTinted(TLObject):
    CONSTRUCTOR_ID = 0x6d5f77ee
    SUBCLASS_OF_ID = 0x1f03f444

    def to_dict(self):
        return {
            '_': 'BaseThemeTinted'
        }

    def _bytes(self):
        return b''.join((
            b'\xeew_m',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class BindAuthKeyInner(TLObject):
    CONSTRUCTOR_ID = 0x75a3f765
    SUBCLASS_OF_ID = 0x2f099171

    def __init__(self, nonce: int, temp_auth_key_id: int, perm_auth_key_id: int, temp_session_id: int, expires_at: Optional[datetime]):
        """
        Constructor for BindAuthKeyInner: Instance of BindAuthKeyInner.
        """
        self.nonce = nonce
        self.temp_auth_key_id = temp_auth_key_id
        self.perm_auth_key_id = perm_auth_key_id
        self.temp_session_id = temp_session_id
        self.expires_at = expires_at

    def to_dict(self):
        return {
            '_': 'BindAuthKeyInner',
            'nonce': self.nonce,
            'temp_auth_key_id': self.temp_auth_key_id,
            'perm_auth_key_id': self.perm_auth_key_id,
            'temp_session_id': self.temp_session_id,
            'expires_at': self.expires_at
        }

    def _bytes(self):
        return b''.join((
            b'e\xf7\xa3u',
            struct.pack('<q', self.nonce),
            struct.pack('<q', self.temp_auth_key_id),
            struct.pack('<q', self.perm_auth_key_id),
            struct.pack('<q', self.temp_session_id),
            self.serialize_datetime(self.expires_at),
        ))

    @classmethod
    def from_reader(cls, reader):
        _nonce = reader.read_long()
        _temp_auth_key_id = reader.read_long()
        _perm_auth_key_id = reader.read_long()
        _temp_session_id = reader.read_long()
        _expires_at = reader.tgread_date()
        return cls(nonce=_nonce, temp_auth_key_id=_temp_auth_key_id, perm_auth_key_id=_perm_auth_key_id, temp_session_id=_temp_session_id, expires_at=_expires_at)


class Boost(TLObject):
    CONSTRUCTOR_ID = 0x2a1c8c71
    SUBCLASS_OF_ID = 0x97a5086c

    # noinspection PyShadowingBuiltins
    def __init__(self, id: str, date: Optional[datetime], expires: Optional[datetime], gift: Optional[bool]=None, giveaway: Optional[bool]=None, unclaimed: Optional[bool]=None, user_id: Optional[int]=None, giveaway_msg_id: Optional[int]=None, used_gift_slug: Optional[str]=None, multiplier: Optional[int]=None):
        """
        Constructor for Boost: Instance of Boost.
        """
        self.id = id
        self.date = date
        self.expires = expires
        self.gift = gift
        self.giveaway = giveaway
        self.unclaimed = unclaimed
        self.user_id = user_id
        self.giveaway_msg_id = giveaway_msg_id
        self.used_gift_slug = used_gift_slug
        self.multiplier = multiplier

    def to_dict(self):
        return {
            '_': 'Boost',
            'id': self.id,
            'date': self.date,
            'expires': self.expires,
            'gift': self.gift,
            'giveaway': self.giveaway,
            'unclaimed': self.unclaimed,
            'user_id': self.user_id,
            'giveaway_msg_id': self.giveaway_msg_id,
            'used_gift_slug': self.used_gift_slug,
            'multiplier': self.multiplier
        }

    def _bytes(self):
        assert ((self.giveaway or self.giveaway is not None) and (self.giveaway_msg_id or self.giveaway_msg_id is not None)) or ((self.giveaway is None or self.giveaway is False) and (self.giveaway_msg_id is None or self.giveaway_msg_id is False)), 'giveaway, giveaway_msg_id parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'q\x8c\x1c*',
            struct.pack('<I', (0 if self.gift is None or self.gift is False else 2) | (0 if self.giveaway is None or self.giveaway is False else 4) | (0 if self.unclaimed is None or self.unclaimed is False else 8) | (0 if self.user_id is None or self.user_id is False else 1) | (0 if self.giveaway_msg_id is None or self.giveaway_msg_id is False else 4) | (0 if self.used_gift_slug is None or self.used_gift_slug is False else 16) | (0 if self.multiplier is None or self.multiplier is False else 32)),
            self.serialize_bytes(self.id),
            b'' if self.user_id is None or self.user_id is False else (struct.pack('<q', self.user_id)),
            b'' if self.giveaway_msg_id is None or self.giveaway_msg_id is False else (struct.pack('<i', self.giveaway_msg_id)),
            self.serialize_datetime(self.date),
            self.serialize_datetime(self.expires),
            b'' if self.used_gift_slug is None or self.used_gift_slug is False else (self.serialize_bytes(self.used_gift_slug)),
            b'' if self.multiplier is None or self.multiplier is False else (struct.pack('<i', self.multiplier)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _gift = bool(flags & 2)
        _giveaway = bool(flags & 4)
        _unclaimed = bool(flags & 8)
        _id = reader.tgread_string()
        if flags & 1:
            _user_id = reader.read_long()
        else:
            _user_id = None
        if flags & 4:
            _giveaway_msg_id = reader.read_int()
        else:
            _giveaway_msg_id = None
        _date = reader.tgread_date()
        _expires = reader.tgread_date()
        if flags & 16:
            _used_gift_slug = reader.tgread_string()
        else:
            _used_gift_slug = None
        if flags & 32:
            _multiplier = reader.read_int()
        else:
            _multiplier = None
        return cls(id=_id, date=_date, expires=_expires, gift=_gift, giveaway=_giveaway, unclaimed=_unclaimed, user_id=_user_id, giveaway_msg_id=_giveaway_msg_id, used_gift_slug=_used_gift_slug, multiplier=_multiplier)


class BotApp(TLObject):
    CONSTRUCTOR_ID = 0x95fcd1d6
    SUBCLASS_OF_ID = 0x20f32ae

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, short_name: str, title: str, description: str, photo: 'TypePhoto', hash: int, document: Optional['TypeDocument']=None):
        """
        Constructor for BotApp: Instance of either BotAppNotModified, BotApp.
        """
        self.id = id
        self.access_hash = access_hash
        self.short_name = short_name
        self.title = title
        self.description = description
        self.photo = photo
        self.hash = hash
        self.document = document

    def to_dict(self):
        return {
            '_': 'BotApp',
            'id': self.id,
            'access_hash': self.access_hash,
            'short_name': self.short_name,
            'title': self.title,
            'description': self.description,
            'photo': self.photo.to_dict() if isinstance(self.photo, TLObject) else self.photo,
            'hash': self.hash,
            'document': self.document.to_dict() if isinstance(self.document, TLObject) else self.document
        }

    def _bytes(self):
        return b''.join((
            b'\xd6\xd1\xfc\x95',
            struct.pack('<I', (0 if self.document is None or self.document is False else 1)),
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            self.serialize_bytes(self.short_name),
            self.serialize_bytes(self.title),
            self.serialize_bytes(self.description),
            self.photo._bytes(),
            b'' if self.document is None or self.document is False else (self.document._bytes()),
            struct.pack('<q', self.hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _id = reader.read_long()
        _access_hash = reader.read_long()
        _short_name = reader.tgread_string()
        _title = reader.tgread_string()
        _description = reader.tgread_string()
        _photo = reader.tgread_object()
        if flags & 1:
            _document = reader.tgread_object()
        else:
            _document = None
        _hash = reader.read_long()
        return cls(id=_id, access_hash=_access_hash, short_name=_short_name, title=_title, description=_description, photo=_photo, hash=_hash, document=_document)


class BotAppNotModified(TLObject):
    CONSTRUCTOR_ID = 0x5da674b7
    SUBCLASS_OF_ID = 0x20f32ae

    def to_dict(self):
        return {
            '_': 'BotAppNotModified'
        }

    def _bytes(self):
        return b''.join((
            b'\xb7t\xa6]',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class BotCommand(TLObject):
    CONSTRUCTOR_ID = 0xc27ac8c7
    SUBCLASS_OF_ID = 0xe1e62c2

    def __init__(self, command: str, description: str):
        """
        Constructor for BotCommand: Instance of BotCommand.
        """
        self.command = command
        self.description = description

    def to_dict(self):
        return {
            '_': 'BotCommand',
            'command': self.command,
            'description': self.description
        }

    def _bytes(self):
        return b''.join((
            b'\xc7\xc8z\xc2',
            self.serialize_bytes(self.command),
            self.serialize_bytes(self.description),
        ))

    @classmethod
    def from_reader(cls, reader):
        _command = reader.tgread_string()
        _description = reader.tgread_string()
        return cls(command=_command, description=_description)


class BotCommandScopeChatAdmins(TLObject):
    CONSTRUCTOR_ID = 0xb9aa606a
    SUBCLASS_OF_ID = 0x4baf5d10

    def to_dict(self):
        return {
            '_': 'BotCommandScopeChatAdmins'
        }

    def _bytes(self):
        return b''.join((
            b'j`\xaa\xb9',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class BotCommandScopeChats(TLObject):
    CONSTRUCTOR_ID = 0x6fe1a881
    SUBCLASS_OF_ID = 0x4baf5d10

    def to_dict(self):
        return {
            '_': 'BotCommandScopeChats'
        }

    def _bytes(self):
        return b''.join((
            b'\x81\xa8\xe1o',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class BotCommandScopeDefault(TLObject):
    CONSTRUCTOR_ID = 0x2f6cb2ab
    SUBCLASS_OF_ID = 0x4baf5d10

    def to_dict(self):
        return {
            '_': 'BotCommandScopeDefault'
        }

    def _bytes(self):
        return b''.join((
            b'\xab\xb2l/',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class BotCommandScopePeer(TLObject):
    CONSTRUCTOR_ID = 0xdb9d897d
    SUBCLASS_OF_ID = 0x4baf5d10

    def __init__(self, peer: 'TypeInputPeer'):
        """
        Constructor for BotCommandScope: Instance of either BotCommandScopeDefault, BotCommandScopeUsers, BotCommandScopeChats, BotCommandScopeChatAdmins, BotCommandScopePeer, BotCommandScopePeerAdmins, BotCommandScopePeerUser.
        """
        self.peer = peer

    def to_dict(self):
        return {
            '_': 'BotCommandScopePeer',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer
        }

    def _bytes(self):
        return b''.join((
            b'}\x89\x9d\xdb',
            self.peer._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        return cls(peer=_peer)


class BotCommandScopePeerAdmins(TLObject):
    CONSTRUCTOR_ID = 0x3fd863d1
    SUBCLASS_OF_ID = 0x4baf5d10

    def __init__(self, peer: 'TypeInputPeer'):
        """
        Constructor for BotCommandScope: Instance of either BotCommandScopeDefault, BotCommandScopeUsers, BotCommandScopeChats, BotCommandScopeChatAdmins, BotCommandScopePeer, BotCommandScopePeerAdmins, BotCommandScopePeerUser.
        """
        self.peer = peer

    def to_dict(self):
        return {
            '_': 'BotCommandScopePeerAdmins',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer
        }

    def _bytes(self):
        return b''.join((
            b'\xd1c\xd8?',
            self.peer._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        return cls(peer=_peer)


class BotCommandScopePeerUser(TLObject):
    CONSTRUCTOR_ID = 0xa1321f3
    SUBCLASS_OF_ID = 0x4baf5d10

    def __init__(self, peer: 'TypeInputPeer', user_id: 'TypeInputUser'):
        """
        Constructor for BotCommandScope: Instance of either BotCommandScopeDefault, BotCommandScopeUsers, BotCommandScopeChats, BotCommandScopeChatAdmins, BotCommandScopePeer, BotCommandScopePeerAdmins, BotCommandScopePeerUser.
        """
        self.peer = peer
        self.user_id = user_id

    def to_dict(self):
        return {
            '_': 'BotCommandScopePeerUser',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'user_id': self.user_id.to_dict() if isinstance(self.user_id, TLObject) else self.user_id
        }

    def _bytes(self):
        return b''.join((
            b'\xf3!\x13\n',
            self.peer._bytes(),
            self.user_id._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _user_id = reader.tgread_object()
        return cls(peer=_peer, user_id=_user_id)


class BotCommandScopeUsers(TLObject):
    CONSTRUCTOR_ID = 0x3c4f04d8
    SUBCLASS_OF_ID = 0x4baf5d10

    def to_dict(self):
        return {
            '_': 'BotCommandScopeUsers'
        }

    def _bytes(self):
        return b''.join((
            b'\xd8\x04O<',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class BotInfo(TLObject):
    CONSTRUCTOR_ID = 0x8f300b57
    SUBCLASS_OF_ID = 0xf1f701db

    def __init__(self, user_id: Optional[int]=None, description: Optional[str]=None, description_photo: Optional['TypePhoto']=None, description_document: Optional['TypeDocument']=None, commands: Optional[List['TypeBotCommand']]=None, menu_button: Optional['TypeBotMenuButton']=None):
        """
        Constructor for BotInfo: Instance of BotInfo.
        """
        self.user_id = user_id
        self.description = description
        self.description_photo = description_photo
        self.description_document = description_document
        self.commands = commands
        self.menu_button = menu_button

    def to_dict(self):
        return {
            '_': 'BotInfo',
            'user_id': self.user_id,
            'description': self.description,
            'description_photo': self.description_photo.to_dict() if isinstance(self.description_photo, TLObject) else self.description_photo,
            'description_document': self.description_document.to_dict() if isinstance(self.description_document, TLObject) else self.description_document,
            'commands': [] if self.commands is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.commands],
            'menu_button': self.menu_button.to_dict() if isinstance(self.menu_button, TLObject) else self.menu_button
        }

    def _bytes(self):
        return b''.join((
            b'W\x0b0\x8f',
            struct.pack('<I', (0 if self.user_id is None or self.user_id is False else 1) | (0 if self.description is None or self.description is False else 2) | (0 if self.description_photo is None or self.description_photo is False else 16) | (0 if self.description_document is None or self.description_document is False else 32) | (0 if self.commands is None or self.commands is False else 4) | (0 if self.menu_button is None or self.menu_button is False else 8)),
            b'' if self.user_id is None or self.user_id is False else (struct.pack('<q', self.user_id)),
            b'' if self.description is None or self.description is False else (self.serialize_bytes(self.description)),
            b'' if self.description_photo is None or self.description_photo is False else (self.description_photo._bytes()),
            b'' if self.description_document is None or self.description_document is False else (self.description_document._bytes()),
            b'' if self.commands is None or self.commands is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.commands)),b''.join(x._bytes() for x in self.commands))),
            b'' if self.menu_button is None or self.menu_button is False else (self.menu_button._bytes()),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 1:
            _user_id = reader.read_long()
        else:
            _user_id = None
        if flags & 2:
            _description = reader.tgread_string()
        else:
            _description = None
        if flags & 16:
            _description_photo = reader.tgread_object()
        else:
            _description_photo = None
        if flags & 32:
            _description_document = reader.tgread_object()
        else:
            _description_document = None
        if flags & 4:
            reader.read_int()
            _commands = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _commands.append(_x)

        else:
            _commands = None
        if flags & 8:
            _menu_button = reader.tgread_object()
        else:
            _menu_button = None
        return cls(user_id=_user_id, description=_description, description_photo=_description_photo, description_document=_description_document, commands=_commands, menu_button=_menu_button)


class BotInlineMediaResult(TLObject):
    CONSTRUCTOR_ID = 0x17db940b
    SUBCLASS_OF_ID = 0x3832b3d5

    # noinspection PyShadowingBuiltins
    def __init__(self, id: str, type: str, send_message: 'TypeBotInlineMessage', photo: Optional['TypePhoto']=None, document: Optional['TypeDocument']=None, title: Optional[str]=None, description: Optional[str]=None):
        """
        Constructor for BotInlineResult: Instance of either BotInlineResult, BotInlineMediaResult.
        """
        self.id = id
        self.type = type
        self.send_message = send_message
        self.photo = photo
        self.document = document
        self.title = title
        self.description = description

    def to_dict(self):
        return {
            '_': 'BotInlineMediaResult',
            'id': self.id,
            'type': self.type,
            'send_message': self.send_message.to_dict() if isinstance(self.send_message, TLObject) else self.send_message,
            'photo': self.photo.to_dict() if isinstance(self.photo, TLObject) else self.photo,
            'document': self.document.to_dict() if isinstance(self.document, TLObject) else self.document,
            'title': self.title,
            'description': self.description
        }

    def _bytes(self):
        return b''.join((
            b'\x0b\x94\xdb\x17',
            struct.pack('<I', (0 if self.photo is None or self.photo is False else 1) | (0 if self.document is None or self.document is False else 2) | (0 if self.title is None or self.title is False else 4) | (0 if self.description is None or self.description is False else 8)),
            self.serialize_bytes(self.id),
            self.serialize_bytes(self.type),
            b'' if self.photo is None or self.photo is False else (self.photo._bytes()),
            b'' if self.document is None or self.document is False else (self.document._bytes()),
            b'' if self.title is None or self.title is False else (self.serialize_bytes(self.title)),
            b'' if self.description is None or self.description is False else (self.serialize_bytes(self.description)),
            self.send_message._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _id = reader.tgread_string()
        _type = reader.tgread_string()
        if flags & 1:
            _photo = reader.tgread_object()
        else:
            _photo = None
        if flags & 2:
            _document = reader.tgread_object()
        else:
            _document = None
        if flags & 4:
            _title = reader.tgread_string()
        else:
            _title = None
        if flags & 8:
            _description = reader.tgread_string()
        else:
            _description = None
        _send_message = reader.tgread_object()
        return cls(id=_id, type=_type, send_message=_send_message, photo=_photo, document=_document, title=_title, description=_description)


class BotInlineMessageMediaAuto(TLObject):
    CONSTRUCTOR_ID = 0x764cf810
    SUBCLASS_OF_ID = 0xc4910f88

    def __init__(self, message: str, invert_media: Optional[bool]=None, entities: Optional[List['TypeMessageEntity']]=None, reply_markup: Optional['TypeReplyMarkup']=None):
        """
        Constructor for BotInlineMessage: Instance of either BotInlineMessageMediaAuto, BotInlineMessageText, BotInlineMessageMediaGeo, BotInlineMessageMediaVenue, BotInlineMessageMediaContact, BotInlineMessageMediaInvoice, BotInlineMessageMediaWebPage.
        """
        self.message = message
        self.invert_media = invert_media
        self.entities = entities
        self.reply_markup = reply_markup

    def to_dict(self):
        return {
            '_': 'BotInlineMessageMediaAuto',
            'message': self.message,
            'invert_media': self.invert_media,
            'entities': [] if self.entities is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.entities],
            'reply_markup': self.reply_markup.to_dict() if isinstance(self.reply_markup, TLObject) else self.reply_markup
        }

    def _bytes(self):
        return b''.join((
            b'\x10\xf8Lv',
            struct.pack('<I', (0 if self.invert_media is None or self.invert_media is False else 8) | (0 if self.entities is None or self.entities is False else 2) | (0 if self.reply_markup is None or self.reply_markup is False else 4)),
            self.serialize_bytes(self.message),
            b'' if self.entities is None or self.entities is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.entities)),b''.join(x._bytes() for x in self.entities))),
            b'' if self.reply_markup is None or self.reply_markup is False else (self.reply_markup._bytes()),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _invert_media = bool(flags & 8)
        _message = reader.tgread_string()
        if flags & 2:
            reader.read_int()
            _entities = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _entities.append(_x)

        else:
            _entities = None
        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        return cls(message=_message, invert_media=_invert_media, entities=_entities, reply_markup=_reply_markup)


class BotInlineMessageMediaContact(TLObject):
    CONSTRUCTOR_ID = 0x18d1cdc2
    SUBCLASS_OF_ID = 0xc4910f88

    def __init__(self, phone_number: str, first_name: str, last_name: str, vcard: str, reply_markup: Optional['TypeReplyMarkup']=None):
        """
        Constructor for BotInlineMessage: Instance of either BotInlineMessageMediaAuto, BotInlineMessageText, BotInlineMessageMediaGeo, BotInlineMessageMediaVenue, BotInlineMessageMediaContact, BotInlineMessageMediaInvoice, BotInlineMessageMediaWebPage.
        """
        self.phone_number = phone_number
        self.first_name = first_name
        self.last_name = last_name
        self.vcard = vcard
        self.reply_markup = reply_markup

    def to_dict(self):
        return {
            '_': 'BotInlineMessageMediaContact',
            'phone_number': self.phone_number,
            'first_name': self.first_name,
            'last_name': self.last_name,
            'vcard': self.vcard,
            'reply_markup': self.reply_markup.to_dict() if isinstance(self.reply_markup, TLObject) else self.reply_markup
        }

    def _bytes(self):
        return b''.join((
            b'\xc2\xcd\xd1\x18',
            struct.pack('<I', (0 if self.reply_markup is None or self.reply_markup is False else 4)),
            self.serialize_bytes(self.phone_number),
            self.serialize_bytes(self.first_name),
            self.serialize_bytes(self.last_name),
            self.serialize_bytes(self.vcard),
            b'' if self.reply_markup is None or self.reply_markup is False else (self.reply_markup._bytes()),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _phone_number = reader.tgread_string()
        _first_name = reader.tgread_string()
        _last_name = reader.tgread_string()
        _vcard = reader.tgread_string()
        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        return cls(phone_number=_phone_number, first_name=_first_name, last_name=_last_name, vcard=_vcard, reply_markup=_reply_markup)


class BotInlineMessageMediaGeo(TLObject):
    CONSTRUCTOR_ID = 0x51846fd
    SUBCLASS_OF_ID = 0xc4910f88

    def __init__(self, geo: 'TypeGeoPoint', heading: Optional[int]=None, period: Optional[int]=None, proximity_notification_radius: Optional[int]=None, reply_markup: Optional['TypeReplyMarkup']=None):
        """
        Constructor for BotInlineMessage: Instance of either BotInlineMessageMediaAuto, BotInlineMessageText, BotInlineMessageMediaGeo, BotInlineMessageMediaVenue, BotInlineMessageMediaContact, BotInlineMessageMediaInvoice, BotInlineMessageMediaWebPage.
        """
        self.geo = geo
        self.heading = heading
        self.period = period
        self.proximity_notification_radius = proximity_notification_radius
        self.reply_markup = reply_markup

    def to_dict(self):
        return {
            '_': 'BotInlineMessageMediaGeo',
            'geo': self.geo.to_dict() if isinstance(self.geo, TLObject) else self.geo,
            'heading': self.heading,
            'period': self.period,
            'proximity_notification_radius': self.proximity_notification_radius,
            'reply_markup': self.reply_markup.to_dict() if isinstance(self.reply_markup, TLObject) else self.reply_markup
        }

    def _bytes(self):
        return b''.join((
            b'\xfdF\x18\x05',
            struct.pack('<I', (0 if self.heading is None or self.heading is False else 1) | (0 if self.period is None or self.period is False else 2) | (0 if self.proximity_notification_radius is None or self.proximity_notification_radius is False else 8) | (0 if self.reply_markup is None or self.reply_markup is False else 4)),
            self.geo._bytes(),
            b'' if self.heading is None or self.heading is False else (struct.pack('<i', self.heading)),
            b'' if self.period is None or self.period is False else (struct.pack('<i', self.period)),
            b'' if self.proximity_notification_radius is None or self.proximity_notification_radius is False else (struct.pack('<i', self.proximity_notification_radius)),
            b'' if self.reply_markup is None or self.reply_markup is False else (self.reply_markup._bytes()),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _geo = reader.tgread_object()
        if flags & 1:
            _heading = reader.read_int()
        else:
            _heading = None
        if flags & 2:
            _period = reader.read_int()
        else:
            _period = None
        if flags & 8:
            _proximity_notification_radius = reader.read_int()
        else:
            _proximity_notification_radius = None
        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        return cls(geo=_geo, heading=_heading, period=_period, proximity_notification_radius=_proximity_notification_radius, reply_markup=_reply_markup)


class BotInlineMessageMediaInvoice(TLObject):
    CONSTRUCTOR_ID = 0x354a9b09
    SUBCLASS_OF_ID = 0xc4910f88

    def __init__(self, title: str, description: str, currency: str, total_amount: int, shipping_address_requested: Optional[bool]=None, test: Optional[bool]=None, photo: Optional['TypeWebDocument']=None, reply_markup: Optional['TypeReplyMarkup']=None):
        """
        Constructor for BotInlineMessage: Instance of either BotInlineMessageMediaAuto, BotInlineMessageText, BotInlineMessageMediaGeo, BotInlineMessageMediaVenue, BotInlineMessageMediaContact, BotInlineMessageMediaInvoice, BotInlineMessageMediaWebPage.
        """
        self.title = title
        self.description = description
        self.currency = currency
        self.total_amount = total_amount
        self.shipping_address_requested = shipping_address_requested
        self.test = test
        self.photo = photo
        self.reply_markup = reply_markup

    def to_dict(self):
        return {
            '_': 'BotInlineMessageMediaInvoice',
            'title': self.title,
            'description': self.description,
            'currency': self.currency,
            'total_amount': self.total_amount,
            'shipping_address_requested': self.shipping_address_requested,
            'test': self.test,
            'photo': self.photo.to_dict() if isinstance(self.photo, TLObject) else self.photo,
            'reply_markup': self.reply_markup.to_dict() if isinstance(self.reply_markup, TLObject) else self.reply_markup
        }

    def _bytes(self):
        return b''.join((
            b'\t\x9bJ5',
            struct.pack('<I', (0 if self.shipping_address_requested is None or self.shipping_address_requested is False else 2) | (0 if self.test is None or self.test is False else 8) | (0 if self.photo is None or self.photo is False else 1) | (0 if self.reply_markup is None or self.reply_markup is False else 4)),
            self.serialize_bytes(self.title),
            self.serialize_bytes(self.description),
            b'' if self.photo is None or self.photo is False else (self.photo._bytes()),
            self.serialize_bytes(self.currency),
            struct.pack('<q', self.total_amount),
            b'' if self.reply_markup is None or self.reply_markup is False else (self.reply_markup._bytes()),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _shipping_address_requested = bool(flags & 2)
        _test = bool(flags & 8)
        _title = reader.tgread_string()
        _description = reader.tgread_string()
        if flags & 1:
            _photo = reader.tgread_object()
        else:
            _photo = None
        _currency = reader.tgread_string()
        _total_amount = reader.read_long()
        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        return cls(title=_title, description=_description, currency=_currency, total_amount=_total_amount, shipping_address_requested=_shipping_address_requested, test=_test, photo=_photo, reply_markup=_reply_markup)


class BotInlineMessageMediaVenue(TLObject):
    CONSTRUCTOR_ID = 0x8a86659c
    SUBCLASS_OF_ID = 0xc4910f88

    def __init__(self, geo: 'TypeGeoPoint', title: str, address: str, provider: str, venue_id: str, venue_type: str, reply_markup: Optional['TypeReplyMarkup']=None):
        """
        Constructor for BotInlineMessage: Instance of either BotInlineMessageMediaAuto, BotInlineMessageText, BotInlineMessageMediaGeo, BotInlineMessageMediaVenue, BotInlineMessageMediaContact, BotInlineMessageMediaInvoice, BotInlineMessageMediaWebPage.
        """
        self.geo = geo
        self.title = title
        self.address = address
        self.provider = provider
        self.venue_id = venue_id
        self.venue_type = venue_type
        self.reply_markup = reply_markup

    def to_dict(self):
        return {
            '_': 'BotInlineMessageMediaVenue',
            'geo': self.geo.to_dict() if isinstance(self.geo, TLObject) else self.geo,
            'title': self.title,
            'address': self.address,
            'provider': self.provider,
            'venue_id': self.venue_id,
            'venue_type': self.venue_type,
            'reply_markup': self.reply_markup.to_dict() if isinstance(self.reply_markup, TLObject) else self.reply_markup
        }

    def _bytes(self):
        return b''.join((
            b'\x9ce\x86\x8a',
            struct.pack('<I', (0 if self.reply_markup is None or self.reply_markup is False else 4)),
            self.geo._bytes(),
            self.serialize_bytes(self.title),
            self.serialize_bytes(self.address),
            self.serialize_bytes(self.provider),
            self.serialize_bytes(self.venue_id),
            self.serialize_bytes(self.venue_type),
            b'' if self.reply_markup is None or self.reply_markup is False else (self.reply_markup._bytes()),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _geo = reader.tgread_object()
        _title = reader.tgread_string()
        _address = reader.tgread_string()
        _provider = reader.tgread_string()
        _venue_id = reader.tgread_string()
        _venue_type = reader.tgread_string()
        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        return cls(geo=_geo, title=_title, address=_address, provider=_provider, venue_id=_venue_id, venue_type=_venue_type, reply_markup=_reply_markup)


class BotInlineMessageMediaWebPage(TLObject):
    CONSTRUCTOR_ID = 0x809ad9a6
    SUBCLASS_OF_ID = 0xc4910f88

    def __init__(self, message: str, url: str, invert_media: Optional[bool]=None, force_large_media: Optional[bool]=None, force_small_media: Optional[bool]=None, manual: Optional[bool]=None, safe: Optional[bool]=None, entities: Optional[List['TypeMessageEntity']]=None, reply_markup: Optional['TypeReplyMarkup']=None):
        """
        Constructor for BotInlineMessage: Instance of either BotInlineMessageMediaAuto, BotInlineMessageText, BotInlineMessageMediaGeo, BotInlineMessageMediaVenue, BotInlineMessageMediaContact, BotInlineMessageMediaInvoice, BotInlineMessageMediaWebPage.
        """
        self.message = message
        self.url = url
        self.invert_media = invert_media
        self.force_large_media = force_large_media
        self.force_small_media = force_small_media
        self.manual = manual
        self.safe = safe
        self.entities = entities
        self.reply_markup = reply_markup

    def to_dict(self):
        return {
            '_': 'BotInlineMessageMediaWebPage',
            'message': self.message,
            'url': self.url,
            'invert_media': self.invert_media,
            'force_large_media': self.force_large_media,
            'force_small_media': self.force_small_media,
            'manual': self.manual,
            'safe': self.safe,
            'entities': [] if self.entities is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.entities],
            'reply_markup': self.reply_markup.to_dict() if isinstance(self.reply_markup, TLObject) else self.reply_markup
        }

    def _bytes(self):
        return b''.join((
            b'\xa6\xd9\x9a\x80',
            struct.pack('<I', (0 if self.invert_media is None or self.invert_media is False else 8) | (0 if self.force_large_media is None or self.force_large_media is False else 16) | (0 if self.force_small_media is None or self.force_small_media is False else 32) | (0 if self.manual is None or self.manual is False else 128) | (0 if self.safe is None or self.safe is False else 256) | (0 if self.entities is None or self.entities is False else 2) | (0 if self.reply_markup is None or self.reply_markup is False else 4)),
            self.serialize_bytes(self.message),
            b'' if self.entities is None or self.entities is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.entities)),b''.join(x._bytes() for x in self.entities))),
            self.serialize_bytes(self.url),
            b'' if self.reply_markup is None or self.reply_markup is False else (self.reply_markup._bytes()),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _invert_media = bool(flags & 8)
        _force_large_media = bool(flags & 16)
        _force_small_media = bool(flags & 32)
        _manual = bool(flags & 128)
        _safe = bool(flags & 256)
        _message = reader.tgread_string()
        if flags & 2:
            reader.read_int()
            _entities = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _entities.append(_x)

        else:
            _entities = None
        _url = reader.tgread_string()
        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        return cls(message=_message, url=_url, invert_media=_invert_media, force_large_media=_force_large_media, force_small_media=_force_small_media, manual=_manual, safe=_safe, entities=_entities, reply_markup=_reply_markup)


class BotInlineMessageText(TLObject):
    CONSTRUCTOR_ID = 0x8c7f65e2
    SUBCLASS_OF_ID = 0xc4910f88

    def __init__(self, message: str, no_webpage: Optional[bool]=None, invert_media: Optional[bool]=None, entities: Optional[List['TypeMessageEntity']]=None, reply_markup: Optional['TypeReplyMarkup']=None):
        """
        Constructor for BotInlineMessage: Instance of either BotInlineMessageMediaAuto, BotInlineMessageText, BotInlineMessageMediaGeo, BotInlineMessageMediaVenue, BotInlineMessageMediaContact, BotInlineMessageMediaInvoice, BotInlineMessageMediaWebPage.
        """
        self.message = message
        self.no_webpage = no_webpage
        self.invert_media = invert_media
        self.entities = entities
        self.reply_markup = reply_markup

    def to_dict(self):
        return {
            '_': 'BotInlineMessageText',
            'message': self.message,
            'no_webpage': self.no_webpage,
            'invert_media': self.invert_media,
            'entities': [] if self.entities is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.entities],
            'reply_markup': self.reply_markup.to_dict() if isinstance(self.reply_markup, TLObject) else self.reply_markup
        }

    def _bytes(self):
        return b''.join((
            b'\xe2e\x7f\x8c',
            struct.pack('<I', (0 if self.no_webpage is None or self.no_webpage is False else 1) | (0 if self.invert_media is None or self.invert_media is False else 8) | (0 if self.entities is None or self.entities is False else 2) | (0 if self.reply_markup is None or self.reply_markup is False else 4)),
            self.serialize_bytes(self.message),
            b'' if self.entities is None or self.entities is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.entities)),b''.join(x._bytes() for x in self.entities))),
            b'' if self.reply_markup is None or self.reply_markup is False else (self.reply_markup._bytes()),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _no_webpage = bool(flags & 1)
        _invert_media = bool(flags & 8)
        _message = reader.tgread_string()
        if flags & 2:
            reader.read_int()
            _entities = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _entities.append(_x)

        else:
            _entities = None
        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        return cls(message=_message, no_webpage=_no_webpage, invert_media=_invert_media, entities=_entities, reply_markup=_reply_markup)


class BotInlineResult(TLObject):
    CONSTRUCTOR_ID = 0x11965f3a
    SUBCLASS_OF_ID = 0x3832b3d5

    # noinspection PyShadowingBuiltins
    def __init__(self, id: str, type: str, send_message: 'TypeBotInlineMessage', title: Optional[str]=None, description: Optional[str]=None, url: Optional[str]=None, thumb: Optional['TypeWebDocument']=None, content: Optional['TypeWebDocument']=None):
        """
        Constructor for BotInlineResult: Instance of either BotInlineResult, BotInlineMediaResult.
        """
        self.id = id
        self.type = type
        self.send_message = send_message
        self.title = title
        self.description = description
        self.url = url
        self.thumb = thumb
        self.content = content

    def to_dict(self):
        return {
            '_': 'BotInlineResult',
            'id': self.id,
            'type': self.type,
            'send_message': self.send_message.to_dict() if isinstance(self.send_message, TLObject) else self.send_message,
            'title': self.title,
            'description': self.description,
            'url': self.url,
            'thumb': self.thumb.to_dict() if isinstance(self.thumb, TLObject) else self.thumb,
            'content': self.content.to_dict() if isinstance(self.content, TLObject) else self.content
        }

    def _bytes(self):
        return b''.join((
            b':_\x96\x11',
            struct.pack('<I', (0 if self.title is None or self.title is False else 2) | (0 if self.description is None or self.description is False else 4) | (0 if self.url is None or self.url is False else 8) | (0 if self.thumb is None or self.thumb is False else 16) | (0 if self.content is None or self.content is False else 32)),
            self.serialize_bytes(self.id),
            self.serialize_bytes(self.type),
            b'' if self.title is None or self.title is False else (self.serialize_bytes(self.title)),
            b'' if self.description is None or self.description is False else (self.serialize_bytes(self.description)),
            b'' if self.url is None or self.url is False else (self.serialize_bytes(self.url)),
            b'' if self.thumb is None or self.thumb is False else (self.thumb._bytes()),
            b'' if self.content is None or self.content is False else (self.content._bytes()),
            self.send_message._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _id = reader.tgread_string()
        _type = reader.tgread_string()
        if flags & 2:
            _title = reader.tgread_string()
        else:
            _title = None
        if flags & 4:
            _description = reader.tgread_string()
        else:
            _description = None
        if flags & 8:
            _url = reader.tgread_string()
        else:
            _url = None
        if flags & 16:
            _thumb = reader.tgread_object()
        else:
            _thumb = None
        if flags & 32:
            _content = reader.tgread_object()
        else:
            _content = None
        _send_message = reader.tgread_object()
        return cls(id=_id, type=_type, send_message=_send_message, title=_title, description=_description, url=_url, thumb=_thumb, content=_content)


class BotMenuButton(TLObject):
    CONSTRUCTOR_ID = 0xc7b57ce6
    SUBCLASS_OF_ID = 0x4c71bd3c

    def __init__(self, text: str, url: str):
        """
        Constructor for BotMenuButton: Instance of either BotMenuButtonDefault, BotMenuButtonCommands, BotMenuButton.
        """
        self.text = text
        self.url = url

    def to_dict(self):
        return {
            '_': 'BotMenuButton',
            'text': self.text,
            'url': self.url
        }

    def _bytes(self):
        return b''.join((
            b'\xe6|\xb5\xc7',
            self.serialize_bytes(self.text),
            self.serialize_bytes(self.url),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_string()
        _url = reader.tgread_string()
        return cls(text=_text, url=_url)


class BotMenuButtonCommands(TLObject):
    CONSTRUCTOR_ID = 0x4258c205
    SUBCLASS_OF_ID = 0x4c71bd3c

    def to_dict(self):
        return {
            '_': 'BotMenuButtonCommands'
        }

    def _bytes(self):
        return b''.join((
            b'\x05\xc2XB',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class BotMenuButtonDefault(TLObject):
    CONSTRUCTOR_ID = 0x7533a588
    SUBCLASS_OF_ID = 0x4c71bd3c

    def to_dict(self):
        return {
            '_': 'BotMenuButtonDefault'
        }

    def _bytes(self):
        return b''.join((
            b'\x88\xa53u',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class CdnConfig(TLObject):
    CONSTRUCTOR_ID = 0x5725e40a
    SUBCLASS_OF_ID = 0xecda397c

    def __init__(self, public_keys: List['TypeCdnPublicKey']):
        """
        Constructor for CdnConfig: Instance of CdnConfig.
        """
        self.public_keys = public_keys

    def to_dict(self):
        return {
            '_': 'CdnConfig',
            'public_keys': [] if self.public_keys is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.public_keys]
        }

    def _bytes(self):
        return b''.join((
            b'\n\xe4%W',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.public_keys)),b''.join(x._bytes() for x in self.public_keys),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _public_keys = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _public_keys.append(_x)

        return cls(public_keys=_public_keys)


class CdnPublicKey(TLObject):
    CONSTRUCTOR_ID = 0xc982eaba
    SUBCLASS_OF_ID = 0x16db47f3

    def __init__(self, dc_id: int, public_key: str):
        """
        Constructor for CdnPublicKey: Instance of CdnPublicKey.
        """
        self.dc_id = dc_id
        self.public_key = public_key

    def to_dict(self):
        return {
            '_': 'CdnPublicKey',
            'dc_id': self.dc_id,
            'public_key': self.public_key
        }

    def _bytes(self):
        return b''.join((
            b'\xba\xea\x82\xc9',
            struct.pack('<i', self.dc_id),
            self.serialize_bytes(self.public_key),
        ))

    @classmethod
    def from_reader(cls, reader):
        _dc_id = reader.read_int()
        _public_key = reader.tgread_string()
        return cls(dc_id=_dc_id, public_key=_public_key)


class Channel(TLObject):
    CONSTRUCTOR_ID = 0x1981ea7e
    SUBCLASS_OF_ID = 0xc5af5d94

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, title: str, photo: 'TypeChatPhoto', date: Optional[datetime], creator: Optional[bool]=None, left: Optional[bool]=None, broadcast: Optional[bool]=None, verified: Optional[bool]=None, megagroup: Optional[bool]=None, restricted: Optional[bool]=None, signatures: Optional[bool]=None, min: Optional[bool]=None, scam: Optional[bool]=None, has_link: Optional[bool]=None, has_geo: Optional[bool]=None, slowmode_enabled: Optional[bool]=None, call_active: Optional[bool]=None, call_not_empty: Optional[bool]=None, fake: Optional[bool]=None, gigagroup: Optional[bool]=None, noforwards: Optional[bool]=None, join_to_send: Optional[bool]=None, join_request: Optional[bool]=None, forum: Optional[bool]=None, stories_hidden: Optional[bool]=None, stories_hidden_min: Optional[bool]=None, stories_unavailable: Optional[bool]=None, access_hash: Optional[int]=None, username: Optional[str]=None, restriction_reason: Optional[List['TypeRestrictionReason']]=None, admin_rights: Optional['TypeChatAdminRights']=None, banned_rights: Optional['TypeChatBannedRights']=None, default_banned_rights: Optional['TypeChatBannedRights']=None, participants_count: Optional[int]=None, usernames: Optional[List['TypeUsername']]=None, stories_max_id: Optional[int]=None, color: Optional[int]=None, background_emoji_id: Optional[int]=None):
        """
        Constructor for Chat: Instance of either ChatEmpty, Chat, ChatForbidden, Channel, ChannelForbidden.
        """
        self.id = id
        self.title = title
        self.photo = photo
        self.date = date
        self.creator = creator
        self.left = left
        self.broadcast = broadcast
        self.verified = verified
        self.megagroup = megagroup
        self.restricted = restricted
        self.signatures = signatures
        self.min = min
        self.scam = scam
        self.has_link = has_link
        self.has_geo = has_geo
        self.slowmode_enabled = slowmode_enabled
        self.call_active = call_active
        self.call_not_empty = call_not_empty
        self.fake = fake
        self.gigagroup = gigagroup
        self.noforwards = noforwards
        self.join_to_send = join_to_send
        self.join_request = join_request
        self.forum = forum
        self.stories_hidden = stories_hidden
        self.stories_hidden_min = stories_hidden_min
        self.stories_unavailable = stories_unavailable
        self.access_hash = access_hash
        self.username = username
        self.restriction_reason = restriction_reason
        self.admin_rights = admin_rights
        self.banned_rights = banned_rights
        self.default_banned_rights = default_banned_rights
        self.participants_count = participants_count
        self.usernames = usernames
        self.stories_max_id = stories_max_id
        self.color = color
        self.background_emoji_id = background_emoji_id

    def to_dict(self):
        return {
            '_': 'Channel',
            'id': self.id,
            'title': self.title,
            'photo': self.photo.to_dict() if isinstance(self.photo, TLObject) else self.photo,
            'date': self.date,
            'creator': self.creator,
            'left': self.left,
            'broadcast': self.broadcast,
            'verified': self.verified,
            'megagroup': self.megagroup,
            'restricted': self.restricted,
            'signatures': self.signatures,
            'min': self.min,
            'scam': self.scam,
            'has_link': self.has_link,
            'has_geo': self.has_geo,
            'slowmode_enabled': self.slowmode_enabled,
            'call_active': self.call_active,
            'call_not_empty': self.call_not_empty,
            'fake': self.fake,
            'gigagroup': self.gigagroup,
            'noforwards': self.noforwards,
            'join_to_send': self.join_to_send,
            'join_request': self.join_request,
            'forum': self.forum,
            'stories_hidden': self.stories_hidden,
            'stories_hidden_min': self.stories_hidden_min,
            'stories_unavailable': self.stories_unavailable,
            'access_hash': self.access_hash,
            'username': self.username,
            'restriction_reason': [] if self.restriction_reason is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.restriction_reason],
            'admin_rights': self.admin_rights.to_dict() if isinstance(self.admin_rights, TLObject) else self.admin_rights,
            'banned_rights': self.banned_rights.to_dict() if isinstance(self.banned_rights, TLObject) else self.banned_rights,
            'default_banned_rights': self.default_banned_rights.to_dict() if isinstance(self.default_banned_rights, TLObject) else self.default_banned_rights,
            'participants_count': self.participants_count,
            'usernames': [] if self.usernames is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.usernames],
            'stories_max_id': self.stories_max_id,
            'color': self.color,
            'background_emoji_id': self.background_emoji_id
        }

    def _bytes(self):
        assert ((self.restricted or self.restricted is not None) and (self.restriction_reason or self.restriction_reason is not None)) or ((self.restricted is None or self.restricted is False) and (self.restriction_reason is None or self.restriction_reason is False)), 'restricted, restriction_reason parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'~\xea\x81\x19',
            struct.pack('<I', (0 if self.creator is None or self.creator is False else 1) | (0 if self.left is None or self.left is False else 4) | (0 if self.broadcast is None or self.broadcast is False else 32) | (0 if self.verified is None or self.verified is False else 128) | (0 if self.megagroup is None or self.megagroup is False else 256) | (0 if self.restricted is None or self.restricted is False else 512) | (0 if self.signatures is None or self.signatures is False else 2048) | (0 if self.min is None or self.min is False else 4096) | (0 if self.scam is None or self.scam is False else 524288) | (0 if self.has_link is None or self.has_link is False else 1048576) | (0 if self.has_geo is None or self.has_geo is False else 2097152) | (0 if self.slowmode_enabled is None or self.slowmode_enabled is False else 4194304) | (0 if self.call_active is None or self.call_active is False else 8388608) | (0 if self.call_not_empty is None or self.call_not_empty is False else 16777216) | (0 if self.fake is None or self.fake is False else 33554432) | (0 if self.gigagroup is None or self.gigagroup is False else 67108864) | (0 if self.noforwards is None or self.noforwards is False else 134217728) | (0 if self.join_to_send is None or self.join_to_send is False else 268435456) | (0 if self.join_request is None or self.join_request is False else 536870912) | (0 if self.forum is None or self.forum is False else 1073741824) | (0 if self.access_hash is None or self.access_hash is False else 8192) | (0 if self.username is None or self.username is False else 64) | (0 if self.restriction_reason is None or self.restriction_reason is False else 512) | (0 if self.admin_rights is None or self.admin_rights is False else 16384) | (0 if self.banned_rights is None or self.banned_rights is False else 32768) | (0 if self.default_banned_rights is None or self.default_banned_rights is False else 262144) | (0 if self.participants_count is None or self.participants_count is False else 131072)),
            struct.pack('<I', (0 if self.stories_hidden is None or self.stories_hidden is False else 2) | (0 if self.stories_hidden_min is None or self.stories_hidden_min is False else 4) | (0 if self.stories_unavailable is None or self.stories_unavailable is False else 8) | (0 if self.usernames is None or self.usernames is False else 1) | (0 if self.stories_max_id is None or self.stories_max_id is False else 16) | (0 if self.color is None or self.color is False else 64) | (0 if self.background_emoji_id is None or self.background_emoji_id is False else 32)),
            struct.pack('<q', self.id),
            b'' if self.access_hash is None or self.access_hash is False else (struct.pack('<q', self.access_hash)),
            self.serialize_bytes(self.title),
            b'' if self.username is None or self.username is False else (self.serialize_bytes(self.username)),
            self.photo._bytes(),
            self.serialize_datetime(self.date),
            b'' if self.restriction_reason is None or self.restriction_reason is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.restriction_reason)),b''.join(x._bytes() for x in self.restriction_reason))),
            b'' if self.admin_rights is None or self.admin_rights is False else (self.admin_rights._bytes()),
            b'' if self.banned_rights is None or self.banned_rights is False else (self.banned_rights._bytes()),
            b'' if self.default_banned_rights is None or self.default_banned_rights is False else (self.default_banned_rights._bytes()),
            b'' if self.participants_count is None or self.participants_count is False else (struct.pack('<i', self.participants_count)),
            b'' if self.usernames is None or self.usernames is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.usernames)),b''.join(x._bytes() for x in self.usernames))),
            b'' if self.stories_max_id is None or self.stories_max_id is False else (struct.pack('<i', self.stories_max_id)),
            b'' if self.color is None or self.color is False else (struct.pack('<i', self.color)),
            b'' if self.background_emoji_id is None or self.background_emoji_id is False else (struct.pack('<q', self.background_emoji_id)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _creator = bool(flags & 1)
        _left = bool(flags & 4)
        _broadcast = bool(flags & 32)
        _verified = bool(flags & 128)
        _megagroup = bool(flags & 256)
        _restricted = bool(flags & 512)
        _signatures = bool(flags & 2048)
        _min = bool(flags & 4096)
        _scam = bool(flags & 524288)
        _has_link = bool(flags & 1048576)
        _has_geo = bool(flags & 2097152)
        _slowmode_enabled = bool(flags & 4194304)
        _call_active = bool(flags & 8388608)
        _call_not_empty = bool(flags & 16777216)
        _fake = bool(flags & 33554432)
        _gigagroup = bool(flags & 67108864)
        _noforwards = bool(flags & 134217728)
        _join_to_send = bool(flags & 268435456)
        _join_request = bool(flags & 536870912)
        _forum = bool(flags & 1073741824)
        flags2 = reader.read_int()

        _stories_hidden = bool(flags2 & 2)
        _stories_hidden_min = bool(flags2 & 4)
        _stories_unavailable = bool(flags2 & 8)
        _id = reader.read_long()
        if flags & 8192:
            _access_hash = reader.read_long()
        else:
            _access_hash = None
        _title = reader.tgread_string()
        if flags & 64:
            _username = reader.tgread_string()
        else:
            _username = None
        _photo = reader.tgread_object()
        _date = reader.tgread_date()
        if flags & 512:
            reader.read_int()
            _restriction_reason = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _restriction_reason.append(_x)

        else:
            _restriction_reason = None
        if flags & 16384:
            _admin_rights = reader.tgread_object()
        else:
            _admin_rights = None
        if flags & 32768:
            _banned_rights = reader.tgread_object()
        else:
            _banned_rights = None
        if flags & 262144:
            _default_banned_rights = reader.tgread_object()
        else:
            _default_banned_rights = None
        if flags & 131072:
            _participants_count = reader.read_int()
        else:
            _participants_count = None
        if flags2 & 1:
            reader.read_int()
            _usernames = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _usernames.append(_x)

        else:
            _usernames = None
        if flags2 & 16:
            _stories_max_id = reader.read_int()
        else:
            _stories_max_id = None
        if flags2 & 64:
            _color = reader.read_int()
        else:
            _color = None
        if flags2 & 32:
            _background_emoji_id = reader.read_long()
        else:
            _background_emoji_id = None
        return cls(id=_id, title=_title, photo=_photo, date=_date, creator=_creator, left=_left, broadcast=_broadcast, verified=_verified, megagroup=_megagroup, restricted=_restricted, signatures=_signatures, min=_min, scam=_scam, has_link=_has_link, has_geo=_has_geo, slowmode_enabled=_slowmode_enabled, call_active=_call_active, call_not_empty=_call_not_empty, fake=_fake, gigagroup=_gigagroup, noforwards=_noforwards, join_to_send=_join_to_send, join_request=_join_request, forum=_forum, stories_hidden=_stories_hidden, stories_hidden_min=_stories_hidden_min, stories_unavailable=_stories_unavailable, access_hash=_access_hash, username=_username, restriction_reason=_restriction_reason, admin_rights=_admin_rights, banned_rights=_banned_rights, default_banned_rights=_default_banned_rights, participants_count=_participants_count, usernames=_usernames, stories_max_id=_stories_max_id, color=_color, background_emoji_id=_background_emoji_id)


class ChannelAdminLogEvent(TLObject):
    CONSTRUCTOR_ID = 0x1fad68cd
    SUBCLASS_OF_ID = 0x408f0999

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, date: Optional[datetime], user_id: int, action: 'TypeChannelAdminLogEventAction'):
        """
        Constructor for ChannelAdminLogEvent: Instance of ChannelAdminLogEvent.
        """
        self.id = id
        self.date = date
        self.user_id = user_id
        self.action = action

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEvent',
            'id': self.id,
            'date': self.date,
            'user_id': self.user_id,
            'action': self.action.to_dict() if isinstance(self.action, TLObject) else self.action
        }

    def _bytes(self):
        return b''.join((
            b'\xcdh\xad\x1f',
            struct.pack('<q', self.id),
            self.serialize_datetime(self.date),
            struct.pack('<q', self.user_id),
            self.action._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _date = reader.tgread_date()
        _user_id = reader.read_long()
        _action = reader.tgread_object()
        return cls(id=_id, date=_date, user_id=_user_id, action=_action)


class ChannelAdminLogEventActionChangeAbout(TLObject):
    CONSTRUCTOR_ID = 0x55188a2e
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, prev_value: str, new_value: str):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions, ChannelAdminLogEventActionChangeUsernames, ChannelAdminLogEventActionToggleForum, ChannelAdminLogEventActionCreateTopic, ChannelAdminLogEventActionEditTopic, ChannelAdminLogEventActionDeleteTopic, ChannelAdminLogEventActionPinTopic, ChannelAdminLogEventActionToggleAntiSpam, ChannelAdminLogEventActionChangeColor, ChannelAdminLogEventActionChangeBackgroundEmoji.
        """
        self.prev_value = prev_value
        self.new_value = new_value

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionChangeAbout',
            'prev_value': self.prev_value,
            'new_value': self.new_value
        }

    def _bytes(self):
        return b''.join((
            b'.\x8a\x18U',
            self.serialize_bytes(self.prev_value),
            self.serialize_bytes(self.new_value),
        ))

    @classmethod
    def from_reader(cls, reader):
        _prev_value = reader.tgread_string()
        _new_value = reader.tgread_string()
        return cls(prev_value=_prev_value, new_value=_new_value)


class ChannelAdminLogEventActionChangeAvailableReactions(TLObject):
    CONSTRUCTOR_ID = 0xbe4e0ef8
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, prev_value: 'TypeChatReactions', new_value: 'TypeChatReactions'):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions, ChannelAdminLogEventActionChangeUsernames, ChannelAdminLogEventActionToggleForum, ChannelAdminLogEventActionCreateTopic, ChannelAdminLogEventActionEditTopic, ChannelAdminLogEventActionDeleteTopic, ChannelAdminLogEventActionPinTopic, ChannelAdminLogEventActionToggleAntiSpam, ChannelAdminLogEventActionChangeColor, ChannelAdminLogEventActionChangeBackgroundEmoji.
        """
        self.prev_value = prev_value
        self.new_value = new_value

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionChangeAvailableReactions',
            'prev_value': self.prev_value.to_dict() if isinstance(self.prev_value, TLObject) else self.prev_value,
            'new_value': self.new_value.to_dict() if isinstance(self.new_value, TLObject) else self.new_value
        }

    def _bytes(self):
        return b''.join((
            b'\xf8\x0eN\xbe',
            self.prev_value._bytes(),
            self.new_value._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _prev_value = reader.tgread_object()
        _new_value = reader.tgread_object()
        return cls(prev_value=_prev_value, new_value=_new_value)


class ChannelAdminLogEventActionChangeBackgroundEmoji(TLObject):
    CONSTRUCTOR_ID = 0x445fc434
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, prev_value: int, new_value: int):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions, ChannelAdminLogEventActionChangeUsernames, ChannelAdminLogEventActionToggleForum, ChannelAdminLogEventActionCreateTopic, ChannelAdminLogEventActionEditTopic, ChannelAdminLogEventActionDeleteTopic, ChannelAdminLogEventActionPinTopic, ChannelAdminLogEventActionToggleAntiSpam, ChannelAdminLogEventActionChangeColor, ChannelAdminLogEventActionChangeBackgroundEmoji.
        """
        self.prev_value = prev_value
        self.new_value = new_value

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionChangeBackgroundEmoji',
            'prev_value': self.prev_value,
            'new_value': self.new_value
        }

    def _bytes(self):
        return b''.join((
            b'4\xc4_D',
            struct.pack('<q', self.prev_value),
            struct.pack('<q', self.new_value),
        ))

    @classmethod
    def from_reader(cls, reader):
        _prev_value = reader.read_long()
        _new_value = reader.read_long()
        return cls(prev_value=_prev_value, new_value=_new_value)


class ChannelAdminLogEventActionChangeColor(TLObject):
    CONSTRUCTOR_ID = 0x3c2b247b
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, prev_value: int, new_value: int):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions, ChannelAdminLogEventActionChangeUsernames, ChannelAdminLogEventActionToggleForum, ChannelAdminLogEventActionCreateTopic, ChannelAdminLogEventActionEditTopic, ChannelAdminLogEventActionDeleteTopic, ChannelAdminLogEventActionPinTopic, ChannelAdminLogEventActionToggleAntiSpam, ChannelAdminLogEventActionChangeColor, ChannelAdminLogEventActionChangeBackgroundEmoji.
        """
        self.prev_value = prev_value
        self.new_value = new_value

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionChangeColor',
            'prev_value': self.prev_value,
            'new_value': self.new_value
        }

    def _bytes(self):
        return b''.join((
            b'{$+<',
            struct.pack('<i', self.prev_value),
            struct.pack('<i', self.new_value),
        ))

    @classmethod
    def from_reader(cls, reader):
        _prev_value = reader.read_int()
        _new_value = reader.read_int()
        return cls(prev_value=_prev_value, new_value=_new_value)


class ChannelAdminLogEventActionChangeHistoryTTL(TLObject):
    CONSTRUCTOR_ID = 0x6e941a38
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, prev_value: int, new_value: int):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions, ChannelAdminLogEventActionChangeUsernames, ChannelAdminLogEventActionToggleForum, ChannelAdminLogEventActionCreateTopic, ChannelAdminLogEventActionEditTopic, ChannelAdminLogEventActionDeleteTopic, ChannelAdminLogEventActionPinTopic, ChannelAdminLogEventActionToggleAntiSpam, ChannelAdminLogEventActionChangeColor, ChannelAdminLogEventActionChangeBackgroundEmoji.
        """
        self.prev_value = prev_value
        self.new_value = new_value

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionChangeHistoryTTL',
            'prev_value': self.prev_value,
            'new_value': self.new_value
        }

    def _bytes(self):
        return b''.join((
            b'8\x1a\x94n',
            struct.pack('<i', self.prev_value),
            struct.pack('<i', self.new_value),
        ))

    @classmethod
    def from_reader(cls, reader):
        _prev_value = reader.read_int()
        _new_value = reader.read_int()
        return cls(prev_value=_prev_value, new_value=_new_value)


class ChannelAdminLogEventActionChangeLinkedChat(TLObject):
    CONSTRUCTOR_ID = 0x50c7ac8
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, prev_value: int, new_value: int):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions, ChannelAdminLogEventActionChangeUsernames, ChannelAdminLogEventActionToggleForum, ChannelAdminLogEventActionCreateTopic, ChannelAdminLogEventActionEditTopic, ChannelAdminLogEventActionDeleteTopic, ChannelAdminLogEventActionPinTopic, ChannelAdminLogEventActionToggleAntiSpam, ChannelAdminLogEventActionChangeColor, ChannelAdminLogEventActionChangeBackgroundEmoji.
        """
        self.prev_value = prev_value
        self.new_value = new_value

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionChangeLinkedChat',
            'prev_value': self.prev_value,
            'new_value': self.new_value
        }

    def _bytes(self):
        return b''.join((
            b'\xc8z\x0c\x05',
            struct.pack('<q', self.prev_value),
            struct.pack('<q', self.new_value),
        ))

    @classmethod
    def from_reader(cls, reader):
        _prev_value = reader.read_long()
        _new_value = reader.read_long()
        return cls(prev_value=_prev_value, new_value=_new_value)


class ChannelAdminLogEventActionChangeLocation(TLObject):
    CONSTRUCTOR_ID = 0xe6b76ae
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, prev_value: 'TypeChannelLocation', new_value: 'TypeChannelLocation'):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions, ChannelAdminLogEventActionChangeUsernames, ChannelAdminLogEventActionToggleForum, ChannelAdminLogEventActionCreateTopic, ChannelAdminLogEventActionEditTopic, ChannelAdminLogEventActionDeleteTopic, ChannelAdminLogEventActionPinTopic, ChannelAdminLogEventActionToggleAntiSpam, ChannelAdminLogEventActionChangeColor, ChannelAdminLogEventActionChangeBackgroundEmoji.
        """
        self.prev_value = prev_value
        self.new_value = new_value

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionChangeLocation',
            'prev_value': self.prev_value.to_dict() if isinstance(self.prev_value, TLObject) else self.prev_value,
            'new_value': self.new_value.to_dict() if isinstance(self.new_value, TLObject) else self.new_value
        }

    def _bytes(self):
        return b''.join((
            b'\xaevk\x0e',
            self.prev_value._bytes(),
            self.new_value._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _prev_value = reader.tgread_object()
        _new_value = reader.tgread_object()
        return cls(prev_value=_prev_value, new_value=_new_value)


class ChannelAdminLogEventActionChangePhoto(TLObject):
    CONSTRUCTOR_ID = 0x434bd2af
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, prev_photo: 'TypePhoto', new_photo: 'TypePhoto'):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions, ChannelAdminLogEventActionChangeUsernames, ChannelAdminLogEventActionToggleForum, ChannelAdminLogEventActionCreateTopic, ChannelAdminLogEventActionEditTopic, ChannelAdminLogEventActionDeleteTopic, ChannelAdminLogEventActionPinTopic, ChannelAdminLogEventActionToggleAntiSpam, ChannelAdminLogEventActionChangeColor, ChannelAdminLogEventActionChangeBackgroundEmoji.
        """
        self.prev_photo = prev_photo
        self.new_photo = new_photo

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionChangePhoto',
            'prev_photo': self.prev_photo.to_dict() if isinstance(self.prev_photo, TLObject) else self.prev_photo,
            'new_photo': self.new_photo.to_dict() if isinstance(self.new_photo, TLObject) else self.new_photo
        }

    def _bytes(self):
        return b''.join((
            b'\xaf\xd2KC',
            self.prev_photo._bytes(),
            self.new_photo._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _prev_photo = reader.tgread_object()
        _new_photo = reader.tgread_object()
        return cls(prev_photo=_prev_photo, new_photo=_new_photo)


class ChannelAdminLogEventActionChangeStickerSet(TLObject):
    CONSTRUCTOR_ID = 0xb1c3caa7
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, prev_stickerset: 'TypeInputStickerSet', new_stickerset: 'TypeInputStickerSet'):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions, ChannelAdminLogEventActionChangeUsernames, ChannelAdminLogEventActionToggleForum, ChannelAdminLogEventActionCreateTopic, ChannelAdminLogEventActionEditTopic, ChannelAdminLogEventActionDeleteTopic, ChannelAdminLogEventActionPinTopic, ChannelAdminLogEventActionToggleAntiSpam, ChannelAdminLogEventActionChangeColor, ChannelAdminLogEventActionChangeBackgroundEmoji.
        """
        self.prev_stickerset = prev_stickerset
        self.new_stickerset = new_stickerset

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionChangeStickerSet',
            'prev_stickerset': self.prev_stickerset.to_dict() if isinstance(self.prev_stickerset, TLObject) else self.prev_stickerset,
            'new_stickerset': self.new_stickerset.to_dict() if isinstance(self.new_stickerset, TLObject) else self.new_stickerset
        }

    def _bytes(self):
        return b''.join((
            b'\xa7\xca\xc3\xb1',
            self.prev_stickerset._bytes(),
            self.new_stickerset._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _prev_stickerset = reader.tgread_object()
        _new_stickerset = reader.tgread_object()
        return cls(prev_stickerset=_prev_stickerset, new_stickerset=_new_stickerset)


class ChannelAdminLogEventActionChangeTitle(TLObject):
    CONSTRUCTOR_ID = 0xe6dfb825
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, prev_value: str, new_value: str):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions, ChannelAdminLogEventActionChangeUsernames, ChannelAdminLogEventActionToggleForum, ChannelAdminLogEventActionCreateTopic, ChannelAdminLogEventActionEditTopic, ChannelAdminLogEventActionDeleteTopic, ChannelAdminLogEventActionPinTopic, ChannelAdminLogEventActionToggleAntiSpam, ChannelAdminLogEventActionChangeColor, ChannelAdminLogEventActionChangeBackgroundEmoji.
        """
        self.prev_value = prev_value
        self.new_value = new_value

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionChangeTitle',
            'prev_value': self.prev_value,
            'new_value': self.new_value
        }

    def _bytes(self):
        return b''.join((
            b'%\xb8\xdf\xe6',
            self.serialize_bytes(self.prev_value),
            self.serialize_bytes(self.new_value),
        ))

    @classmethod
    def from_reader(cls, reader):
        _prev_value = reader.tgread_string()
        _new_value = reader.tgread_string()
        return cls(prev_value=_prev_value, new_value=_new_value)


class ChannelAdminLogEventActionChangeUsername(TLObject):
    CONSTRUCTOR_ID = 0x6a4afc38
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, prev_value: str, new_value: str):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions, ChannelAdminLogEventActionChangeUsernames, ChannelAdminLogEventActionToggleForum, ChannelAdminLogEventActionCreateTopic, ChannelAdminLogEventActionEditTopic, ChannelAdminLogEventActionDeleteTopic, ChannelAdminLogEventActionPinTopic, ChannelAdminLogEventActionToggleAntiSpam, ChannelAdminLogEventActionChangeColor, ChannelAdminLogEventActionChangeBackgroundEmoji.
        """
        self.prev_value = prev_value
        self.new_value = new_value

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionChangeUsername',
            'prev_value': self.prev_value,
            'new_value': self.new_value
        }

    def _bytes(self):
        return b''.join((
            b'8\xfcJj',
            self.serialize_bytes(self.prev_value),
            self.serialize_bytes(self.new_value),
        ))

    @classmethod
    def from_reader(cls, reader):
        _prev_value = reader.tgread_string()
        _new_value = reader.tgread_string()
        return cls(prev_value=_prev_value, new_value=_new_value)


class ChannelAdminLogEventActionChangeUsernames(TLObject):
    CONSTRUCTOR_ID = 0xf04fb3a9
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, prev_value: List[str], new_value: List[str]):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions, ChannelAdminLogEventActionChangeUsernames, ChannelAdminLogEventActionToggleForum, ChannelAdminLogEventActionCreateTopic, ChannelAdminLogEventActionEditTopic, ChannelAdminLogEventActionDeleteTopic, ChannelAdminLogEventActionPinTopic, ChannelAdminLogEventActionToggleAntiSpam, ChannelAdminLogEventActionChangeColor, ChannelAdminLogEventActionChangeBackgroundEmoji.
        """
        self.prev_value = prev_value
        self.new_value = new_value

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionChangeUsernames',
            'prev_value': [] if self.prev_value is None else self.prev_value[:],
            'new_value': [] if self.new_value is None else self.new_value[:]
        }

    def _bytes(self):
        return b''.join((
            b'\xa9\xb3O\xf0',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.prev_value)),b''.join(self.serialize_bytes(x) for x in self.prev_value),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.new_value)),b''.join(self.serialize_bytes(x) for x in self.new_value),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _prev_value = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_string()
            _prev_value.append(_x)

        reader.read_int()
        _new_value = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_string()
            _new_value.append(_x)

        return cls(prev_value=_prev_value, new_value=_new_value)


class ChannelAdminLogEventActionCreateTopic(TLObject):
    CONSTRUCTOR_ID = 0x58707d28
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, topic: 'TypeForumTopic'):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions, ChannelAdminLogEventActionChangeUsernames, ChannelAdminLogEventActionToggleForum, ChannelAdminLogEventActionCreateTopic, ChannelAdminLogEventActionEditTopic, ChannelAdminLogEventActionDeleteTopic, ChannelAdminLogEventActionPinTopic, ChannelAdminLogEventActionToggleAntiSpam, ChannelAdminLogEventActionChangeColor, ChannelAdminLogEventActionChangeBackgroundEmoji.
        """
        self.topic = topic

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionCreateTopic',
            'topic': self.topic.to_dict() if isinstance(self.topic, TLObject) else self.topic
        }

    def _bytes(self):
        return b''.join((
            b'(}pX',
            self.topic._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _topic = reader.tgread_object()
        return cls(topic=_topic)


class ChannelAdminLogEventActionDefaultBannedRights(TLObject):
    CONSTRUCTOR_ID = 0x2df5fc0a
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, prev_banned_rights: 'TypeChatBannedRights', new_banned_rights: 'TypeChatBannedRights'):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions, ChannelAdminLogEventActionChangeUsernames, ChannelAdminLogEventActionToggleForum, ChannelAdminLogEventActionCreateTopic, ChannelAdminLogEventActionEditTopic, ChannelAdminLogEventActionDeleteTopic, ChannelAdminLogEventActionPinTopic, ChannelAdminLogEventActionToggleAntiSpam, ChannelAdminLogEventActionChangeColor, ChannelAdminLogEventActionChangeBackgroundEmoji.
        """
        self.prev_banned_rights = prev_banned_rights
        self.new_banned_rights = new_banned_rights

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionDefaultBannedRights',
            'prev_banned_rights': self.prev_banned_rights.to_dict() if isinstance(self.prev_banned_rights, TLObject) else self.prev_banned_rights,
            'new_banned_rights': self.new_banned_rights.to_dict() if isinstance(self.new_banned_rights, TLObject) else self.new_banned_rights
        }

    def _bytes(self):
        return b''.join((
            b'\n\xfc\xf5-',
            self.prev_banned_rights._bytes(),
            self.new_banned_rights._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _prev_banned_rights = reader.tgread_object()
        _new_banned_rights = reader.tgread_object()
        return cls(prev_banned_rights=_prev_banned_rights, new_banned_rights=_new_banned_rights)


class ChannelAdminLogEventActionDeleteMessage(TLObject):
    CONSTRUCTOR_ID = 0x42e047bb
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, message: 'TypeMessage'):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions, ChannelAdminLogEventActionChangeUsernames, ChannelAdminLogEventActionToggleForum, ChannelAdminLogEventActionCreateTopic, ChannelAdminLogEventActionEditTopic, ChannelAdminLogEventActionDeleteTopic, ChannelAdminLogEventActionPinTopic, ChannelAdminLogEventActionToggleAntiSpam, ChannelAdminLogEventActionChangeColor, ChannelAdminLogEventActionChangeBackgroundEmoji.
        """
        self.message = message

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionDeleteMessage',
            'message': self.message.to_dict() if isinstance(self.message, TLObject) else self.message
        }

    def _bytes(self):
        return b''.join((
            b'\xbbG\xe0B',
            self.message._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _message = reader.tgread_object()
        return cls(message=_message)


class ChannelAdminLogEventActionDeleteTopic(TLObject):
    CONSTRUCTOR_ID = 0xae168909
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, topic: 'TypeForumTopic'):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions, ChannelAdminLogEventActionChangeUsernames, ChannelAdminLogEventActionToggleForum, ChannelAdminLogEventActionCreateTopic, ChannelAdminLogEventActionEditTopic, ChannelAdminLogEventActionDeleteTopic, ChannelAdminLogEventActionPinTopic, ChannelAdminLogEventActionToggleAntiSpam, ChannelAdminLogEventActionChangeColor, ChannelAdminLogEventActionChangeBackgroundEmoji.
        """
        self.topic = topic

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionDeleteTopic',
            'topic': self.topic.to_dict() if isinstance(self.topic, TLObject) else self.topic
        }

    def _bytes(self):
        return b''.join((
            b'\t\x89\x16\xae',
            self.topic._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _topic = reader.tgread_object()
        return cls(topic=_topic)


class ChannelAdminLogEventActionDiscardGroupCall(TLObject):
    CONSTRUCTOR_ID = 0xdb9f9140
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, call: 'TypeInputGroupCall'):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions, ChannelAdminLogEventActionChangeUsernames, ChannelAdminLogEventActionToggleForum, ChannelAdminLogEventActionCreateTopic, ChannelAdminLogEventActionEditTopic, ChannelAdminLogEventActionDeleteTopic, ChannelAdminLogEventActionPinTopic, ChannelAdminLogEventActionToggleAntiSpam, ChannelAdminLogEventActionChangeColor, ChannelAdminLogEventActionChangeBackgroundEmoji.
        """
        self.call = call

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionDiscardGroupCall',
            'call': self.call.to_dict() if isinstance(self.call, TLObject) else self.call
        }

    def _bytes(self):
        return b''.join((
            b'@\x91\x9f\xdb',
            self.call._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _call = reader.tgread_object()
        return cls(call=_call)


class ChannelAdminLogEventActionEditMessage(TLObject):
    CONSTRUCTOR_ID = 0x709b2405
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, prev_message: 'TypeMessage', new_message: 'TypeMessage'):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions, ChannelAdminLogEventActionChangeUsernames, ChannelAdminLogEventActionToggleForum, ChannelAdminLogEventActionCreateTopic, ChannelAdminLogEventActionEditTopic, ChannelAdminLogEventActionDeleteTopic, ChannelAdminLogEventActionPinTopic, ChannelAdminLogEventActionToggleAntiSpam, ChannelAdminLogEventActionChangeColor, ChannelAdminLogEventActionChangeBackgroundEmoji.
        """
        self.prev_message = prev_message
        self.new_message = new_message

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionEditMessage',
            'prev_message': self.prev_message.to_dict() if isinstance(self.prev_message, TLObject) else self.prev_message,
            'new_message': self.new_message.to_dict() if isinstance(self.new_message, TLObject) else self.new_message
        }

    def _bytes(self):
        return b''.join((
            b'\x05$\x9bp',
            self.prev_message._bytes(),
            self.new_message._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _prev_message = reader.tgread_object()
        _new_message = reader.tgread_object()
        return cls(prev_message=_prev_message, new_message=_new_message)


class ChannelAdminLogEventActionEditTopic(TLObject):
    CONSTRUCTOR_ID = 0xf06fe208
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, prev_topic: 'TypeForumTopic', new_topic: 'TypeForumTopic'):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions, ChannelAdminLogEventActionChangeUsernames, ChannelAdminLogEventActionToggleForum, ChannelAdminLogEventActionCreateTopic, ChannelAdminLogEventActionEditTopic, ChannelAdminLogEventActionDeleteTopic, ChannelAdminLogEventActionPinTopic, ChannelAdminLogEventActionToggleAntiSpam, ChannelAdminLogEventActionChangeColor, ChannelAdminLogEventActionChangeBackgroundEmoji.
        """
        self.prev_topic = prev_topic
        self.new_topic = new_topic

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionEditTopic',
            'prev_topic': self.prev_topic.to_dict() if isinstance(self.prev_topic, TLObject) else self.prev_topic,
            'new_topic': self.new_topic.to_dict() if isinstance(self.new_topic, TLObject) else self.new_topic
        }

    def _bytes(self):
        return b''.join((
            b'\x08\xe2o\xf0',
            self.prev_topic._bytes(),
            self.new_topic._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _prev_topic = reader.tgread_object()
        _new_topic = reader.tgread_object()
        return cls(prev_topic=_prev_topic, new_topic=_new_topic)


class ChannelAdminLogEventActionExportedInviteDelete(TLObject):
    CONSTRUCTOR_ID = 0x5a50fca4
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, invite: 'TypeExportedChatInvite'):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions, ChannelAdminLogEventActionChangeUsernames, ChannelAdminLogEventActionToggleForum, ChannelAdminLogEventActionCreateTopic, ChannelAdminLogEventActionEditTopic, ChannelAdminLogEventActionDeleteTopic, ChannelAdminLogEventActionPinTopic, ChannelAdminLogEventActionToggleAntiSpam, ChannelAdminLogEventActionChangeColor, ChannelAdminLogEventActionChangeBackgroundEmoji.
        """
        self.invite = invite

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionExportedInviteDelete',
            'invite': self.invite.to_dict() if isinstance(self.invite, TLObject) else self.invite
        }

    def _bytes(self):
        return b''.join((
            b'\xa4\xfcPZ',
            self.invite._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _invite = reader.tgread_object()
        return cls(invite=_invite)


class ChannelAdminLogEventActionExportedInviteEdit(TLObject):
    CONSTRUCTOR_ID = 0xe90ebb59
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, prev_invite: 'TypeExportedChatInvite', new_invite: 'TypeExportedChatInvite'):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions, ChannelAdminLogEventActionChangeUsernames, ChannelAdminLogEventActionToggleForum, ChannelAdminLogEventActionCreateTopic, ChannelAdminLogEventActionEditTopic, ChannelAdminLogEventActionDeleteTopic, ChannelAdminLogEventActionPinTopic, ChannelAdminLogEventActionToggleAntiSpam, ChannelAdminLogEventActionChangeColor, ChannelAdminLogEventActionChangeBackgroundEmoji.
        """
        self.prev_invite = prev_invite
        self.new_invite = new_invite

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionExportedInviteEdit',
            'prev_invite': self.prev_invite.to_dict() if isinstance(self.prev_invite, TLObject) else self.prev_invite,
            'new_invite': self.new_invite.to_dict() if isinstance(self.new_invite, TLObject) else self.new_invite
        }

    def _bytes(self):
        return b''.join((
            b'Y\xbb\x0e\xe9',
            self.prev_invite._bytes(),
            self.new_invite._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _prev_invite = reader.tgread_object()
        _new_invite = reader.tgread_object()
        return cls(prev_invite=_prev_invite, new_invite=_new_invite)


class ChannelAdminLogEventActionExportedInviteRevoke(TLObject):
    CONSTRUCTOR_ID = 0x410a134e
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, invite: 'TypeExportedChatInvite'):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions, ChannelAdminLogEventActionChangeUsernames, ChannelAdminLogEventActionToggleForum, ChannelAdminLogEventActionCreateTopic, ChannelAdminLogEventActionEditTopic, ChannelAdminLogEventActionDeleteTopic, ChannelAdminLogEventActionPinTopic, ChannelAdminLogEventActionToggleAntiSpam, ChannelAdminLogEventActionChangeColor, ChannelAdminLogEventActionChangeBackgroundEmoji.
        """
        self.invite = invite

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionExportedInviteRevoke',
            'invite': self.invite.to_dict() if isinstance(self.invite, TLObject) else self.invite
        }

    def _bytes(self):
        return b''.join((
            b'N\x13\nA',
            self.invite._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _invite = reader.tgread_object()
        return cls(invite=_invite)


class ChannelAdminLogEventActionParticipantInvite(TLObject):
    CONSTRUCTOR_ID = 0xe31c34d8
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, participant: 'TypeChannelParticipant'):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions, ChannelAdminLogEventActionChangeUsernames, ChannelAdminLogEventActionToggleForum, ChannelAdminLogEventActionCreateTopic, ChannelAdminLogEventActionEditTopic, ChannelAdminLogEventActionDeleteTopic, ChannelAdminLogEventActionPinTopic, ChannelAdminLogEventActionToggleAntiSpam, ChannelAdminLogEventActionChangeColor, ChannelAdminLogEventActionChangeBackgroundEmoji.
        """
        self.participant = participant

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionParticipantInvite',
            'participant': self.participant.to_dict() if isinstance(self.participant, TLObject) else self.participant
        }

    def _bytes(self):
        return b''.join((
            b'\xd84\x1c\xe3',
            self.participant._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _participant = reader.tgread_object()
        return cls(participant=_participant)


class ChannelAdminLogEventActionParticipantJoin(TLObject):
    CONSTRUCTOR_ID = 0x183040d3
    SUBCLASS_OF_ID = 0xb2b987f3

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionParticipantJoin'
        }

    def _bytes(self):
        return b''.join((
            b'\xd3@0\x18',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class ChannelAdminLogEventActionParticipantJoinByInvite(TLObject):
    CONSTRUCTOR_ID = 0xfe9fc158
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, invite: 'TypeExportedChatInvite', via_chatlist: Optional[bool]=None):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions, ChannelAdminLogEventActionChangeUsernames, ChannelAdminLogEventActionToggleForum, ChannelAdminLogEventActionCreateTopic, ChannelAdminLogEventActionEditTopic, ChannelAdminLogEventActionDeleteTopic, ChannelAdminLogEventActionPinTopic, ChannelAdminLogEventActionToggleAntiSpam, ChannelAdminLogEventActionChangeColor, ChannelAdminLogEventActionChangeBackgroundEmoji.
        """
        self.invite = invite
        self.via_chatlist = via_chatlist

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionParticipantJoinByInvite',
            'invite': self.invite.to_dict() if isinstance(self.invite, TLObject) else self.invite,
            'via_chatlist': self.via_chatlist
        }

    def _bytes(self):
        return b''.join((
            b'X\xc1\x9f\xfe',
            struct.pack('<I', (0 if self.via_chatlist is None or self.via_chatlist is False else 1)),
            self.invite._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _via_chatlist = bool(flags & 1)
        _invite = reader.tgread_object()
        return cls(invite=_invite, via_chatlist=_via_chatlist)


class ChannelAdminLogEventActionParticipantJoinByRequest(TLObject):
    CONSTRUCTOR_ID = 0xafb6144a
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, invite: 'TypeExportedChatInvite', approved_by: int):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions, ChannelAdminLogEventActionChangeUsernames, ChannelAdminLogEventActionToggleForum, ChannelAdminLogEventActionCreateTopic, ChannelAdminLogEventActionEditTopic, ChannelAdminLogEventActionDeleteTopic, ChannelAdminLogEventActionPinTopic, ChannelAdminLogEventActionToggleAntiSpam, ChannelAdminLogEventActionChangeColor, ChannelAdminLogEventActionChangeBackgroundEmoji.
        """
        self.invite = invite
        self.approved_by = approved_by

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionParticipantJoinByRequest',
            'invite': self.invite.to_dict() if isinstance(self.invite, TLObject) else self.invite,
            'approved_by': self.approved_by
        }

    def _bytes(self):
        return b''.join((
            b'J\x14\xb6\xaf',
            self.invite._bytes(),
            struct.pack('<q', self.approved_by),
        ))

    @classmethod
    def from_reader(cls, reader):
        _invite = reader.tgread_object()
        _approved_by = reader.read_long()
        return cls(invite=_invite, approved_by=_approved_by)


class ChannelAdminLogEventActionParticipantLeave(TLObject):
    CONSTRUCTOR_ID = 0xf89777f2
    SUBCLASS_OF_ID = 0xb2b987f3

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionParticipantLeave'
        }

    def _bytes(self):
        return b''.join((
            b'\xf2w\x97\xf8',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class ChannelAdminLogEventActionParticipantMute(TLObject):
    CONSTRUCTOR_ID = 0xf92424d2
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, participant: 'TypeGroupCallParticipant'):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions, ChannelAdminLogEventActionChangeUsernames, ChannelAdminLogEventActionToggleForum, ChannelAdminLogEventActionCreateTopic, ChannelAdminLogEventActionEditTopic, ChannelAdminLogEventActionDeleteTopic, ChannelAdminLogEventActionPinTopic, ChannelAdminLogEventActionToggleAntiSpam, ChannelAdminLogEventActionChangeColor, ChannelAdminLogEventActionChangeBackgroundEmoji.
        """
        self.participant = participant

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionParticipantMute',
            'participant': self.participant.to_dict() if isinstance(self.participant, TLObject) else self.participant
        }

    def _bytes(self):
        return b''.join((
            b'\xd2$$\xf9',
            self.participant._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _participant = reader.tgread_object()
        return cls(participant=_participant)


class ChannelAdminLogEventActionParticipantToggleAdmin(TLObject):
    CONSTRUCTOR_ID = 0xd5676710
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, prev_participant: 'TypeChannelParticipant', new_participant: 'TypeChannelParticipant'):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions, ChannelAdminLogEventActionChangeUsernames, ChannelAdminLogEventActionToggleForum, ChannelAdminLogEventActionCreateTopic, ChannelAdminLogEventActionEditTopic, ChannelAdminLogEventActionDeleteTopic, ChannelAdminLogEventActionPinTopic, ChannelAdminLogEventActionToggleAntiSpam, ChannelAdminLogEventActionChangeColor, ChannelAdminLogEventActionChangeBackgroundEmoji.
        """
        self.prev_participant = prev_participant
        self.new_participant = new_participant

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionParticipantToggleAdmin',
            'prev_participant': self.prev_participant.to_dict() if isinstance(self.prev_participant, TLObject) else self.prev_participant,
            'new_participant': self.new_participant.to_dict() if isinstance(self.new_participant, TLObject) else self.new_participant
        }

    def _bytes(self):
        return b''.join((
            b'\x10gg\xd5',
            self.prev_participant._bytes(),
            self.new_participant._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _prev_participant = reader.tgread_object()
        _new_participant = reader.tgread_object()
        return cls(prev_participant=_prev_participant, new_participant=_new_participant)


class ChannelAdminLogEventActionParticipantToggleBan(TLObject):
    CONSTRUCTOR_ID = 0xe6d83d7e
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, prev_participant: 'TypeChannelParticipant', new_participant: 'TypeChannelParticipant'):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions, ChannelAdminLogEventActionChangeUsernames, ChannelAdminLogEventActionToggleForum, ChannelAdminLogEventActionCreateTopic, ChannelAdminLogEventActionEditTopic, ChannelAdminLogEventActionDeleteTopic, ChannelAdminLogEventActionPinTopic, ChannelAdminLogEventActionToggleAntiSpam, ChannelAdminLogEventActionChangeColor, ChannelAdminLogEventActionChangeBackgroundEmoji.
        """
        self.prev_participant = prev_participant
        self.new_participant = new_participant

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionParticipantToggleBan',
            'prev_participant': self.prev_participant.to_dict() if isinstance(self.prev_participant, TLObject) else self.prev_participant,
            'new_participant': self.new_participant.to_dict() if isinstance(self.new_participant, TLObject) else self.new_participant
        }

    def _bytes(self):
        return b''.join((
            b'~=\xd8\xe6',
            self.prev_participant._bytes(),
            self.new_participant._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _prev_participant = reader.tgread_object()
        _new_participant = reader.tgread_object()
        return cls(prev_participant=_prev_participant, new_participant=_new_participant)


class ChannelAdminLogEventActionParticipantUnmute(TLObject):
    CONSTRUCTOR_ID = 0xe64429c0
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, participant: 'TypeGroupCallParticipant'):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions, ChannelAdminLogEventActionChangeUsernames, ChannelAdminLogEventActionToggleForum, ChannelAdminLogEventActionCreateTopic, ChannelAdminLogEventActionEditTopic, ChannelAdminLogEventActionDeleteTopic, ChannelAdminLogEventActionPinTopic, ChannelAdminLogEventActionToggleAntiSpam, ChannelAdminLogEventActionChangeColor, ChannelAdminLogEventActionChangeBackgroundEmoji.
        """
        self.participant = participant

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionParticipantUnmute',
            'participant': self.participant.to_dict() if isinstance(self.participant, TLObject) else self.participant
        }

    def _bytes(self):
        return b''.join((
            b'\xc0)D\xe6',
            self.participant._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _participant = reader.tgread_object()
        return cls(participant=_participant)


class ChannelAdminLogEventActionParticipantVolume(TLObject):
    CONSTRUCTOR_ID = 0x3e7f6847
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, participant: 'TypeGroupCallParticipant'):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions, ChannelAdminLogEventActionChangeUsernames, ChannelAdminLogEventActionToggleForum, ChannelAdminLogEventActionCreateTopic, ChannelAdminLogEventActionEditTopic, ChannelAdminLogEventActionDeleteTopic, ChannelAdminLogEventActionPinTopic, ChannelAdminLogEventActionToggleAntiSpam, ChannelAdminLogEventActionChangeColor, ChannelAdminLogEventActionChangeBackgroundEmoji.
        """
        self.participant = participant

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionParticipantVolume',
            'participant': self.participant.to_dict() if isinstance(self.participant, TLObject) else self.participant
        }

    def _bytes(self):
        return b''.join((
            b'Gh\x7f>',
            self.participant._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _participant = reader.tgread_object()
        return cls(participant=_participant)


class ChannelAdminLogEventActionPinTopic(TLObject):
    CONSTRUCTOR_ID = 0x5d8d353b
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, prev_topic: Optional['TypeForumTopic']=None, new_topic: Optional['TypeForumTopic']=None):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions, ChannelAdminLogEventActionChangeUsernames, ChannelAdminLogEventActionToggleForum, ChannelAdminLogEventActionCreateTopic, ChannelAdminLogEventActionEditTopic, ChannelAdminLogEventActionDeleteTopic, ChannelAdminLogEventActionPinTopic, ChannelAdminLogEventActionToggleAntiSpam, ChannelAdminLogEventActionChangeColor, ChannelAdminLogEventActionChangeBackgroundEmoji.
        """
        self.prev_topic = prev_topic
        self.new_topic = new_topic

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionPinTopic',
            'prev_topic': self.prev_topic.to_dict() if isinstance(self.prev_topic, TLObject) else self.prev_topic,
            'new_topic': self.new_topic.to_dict() if isinstance(self.new_topic, TLObject) else self.new_topic
        }

    def _bytes(self):
        return b''.join((
            b';5\x8d]',
            struct.pack('<I', (0 if self.prev_topic is None or self.prev_topic is False else 1) | (0 if self.new_topic is None or self.new_topic is False else 2)),
            b'' if self.prev_topic is None or self.prev_topic is False else (self.prev_topic._bytes()),
            b'' if self.new_topic is None or self.new_topic is False else (self.new_topic._bytes()),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 1:
            _prev_topic = reader.tgread_object()
        else:
            _prev_topic = None
        if flags & 2:
            _new_topic = reader.tgread_object()
        else:
            _new_topic = None
        return cls(prev_topic=_prev_topic, new_topic=_new_topic)


class ChannelAdminLogEventActionSendMessage(TLObject):
    CONSTRUCTOR_ID = 0x278f2868
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, message: 'TypeMessage'):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions, ChannelAdminLogEventActionChangeUsernames, ChannelAdminLogEventActionToggleForum, ChannelAdminLogEventActionCreateTopic, ChannelAdminLogEventActionEditTopic, ChannelAdminLogEventActionDeleteTopic, ChannelAdminLogEventActionPinTopic, ChannelAdminLogEventActionToggleAntiSpam, ChannelAdminLogEventActionChangeColor, ChannelAdminLogEventActionChangeBackgroundEmoji.
        """
        self.message = message

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionSendMessage',
            'message': self.message.to_dict() if isinstance(self.message, TLObject) else self.message
        }

    def _bytes(self):
        return b''.join((
            b"h(\x8f'",
            self.message._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _message = reader.tgread_object()
        return cls(message=_message)


class ChannelAdminLogEventActionStartGroupCall(TLObject):
    CONSTRUCTOR_ID = 0x23209745
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, call: 'TypeInputGroupCall'):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions, ChannelAdminLogEventActionChangeUsernames, ChannelAdminLogEventActionToggleForum, ChannelAdminLogEventActionCreateTopic, ChannelAdminLogEventActionEditTopic, ChannelAdminLogEventActionDeleteTopic, ChannelAdminLogEventActionPinTopic, ChannelAdminLogEventActionToggleAntiSpam, ChannelAdminLogEventActionChangeColor, ChannelAdminLogEventActionChangeBackgroundEmoji.
        """
        self.call = call

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionStartGroupCall',
            'call': self.call.to_dict() if isinstance(self.call, TLObject) else self.call
        }

    def _bytes(self):
        return b''.join((
            b'E\x97 #',
            self.call._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _call = reader.tgread_object()
        return cls(call=_call)


class ChannelAdminLogEventActionStopPoll(TLObject):
    CONSTRUCTOR_ID = 0x8f079643
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, message: 'TypeMessage'):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions, ChannelAdminLogEventActionChangeUsernames, ChannelAdminLogEventActionToggleForum, ChannelAdminLogEventActionCreateTopic, ChannelAdminLogEventActionEditTopic, ChannelAdminLogEventActionDeleteTopic, ChannelAdminLogEventActionPinTopic, ChannelAdminLogEventActionToggleAntiSpam, ChannelAdminLogEventActionChangeColor, ChannelAdminLogEventActionChangeBackgroundEmoji.
        """
        self.message = message

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionStopPoll',
            'message': self.message.to_dict() if isinstance(self.message, TLObject) else self.message
        }

    def _bytes(self):
        return b''.join((
            b'C\x96\x07\x8f',
            self.message._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _message = reader.tgread_object()
        return cls(message=_message)


class ChannelAdminLogEventActionToggleAntiSpam(TLObject):
    CONSTRUCTOR_ID = 0x64f36dfc
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, new_value: bool):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions, ChannelAdminLogEventActionChangeUsernames, ChannelAdminLogEventActionToggleForum, ChannelAdminLogEventActionCreateTopic, ChannelAdminLogEventActionEditTopic, ChannelAdminLogEventActionDeleteTopic, ChannelAdminLogEventActionPinTopic, ChannelAdminLogEventActionToggleAntiSpam, ChannelAdminLogEventActionChangeColor, ChannelAdminLogEventActionChangeBackgroundEmoji.
        """
        self.new_value = new_value

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionToggleAntiSpam',
            'new_value': self.new_value
        }

    def _bytes(self):
        return b''.join((
            b'\xfcm\xf3d',
            b'\xb5ur\x99' if self.new_value else b'7\x97y\xbc',
        ))

    @classmethod
    def from_reader(cls, reader):
        _new_value = reader.tgread_bool()
        return cls(new_value=_new_value)


class ChannelAdminLogEventActionToggleForum(TLObject):
    CONSTRUCTOR_ID = 0x2cc6383
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, new_value: bool):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions, ChannelAdminLogEventActionChangeUsernames, ChannelAdminLogEventActionToggleForum, ChannelAdminLogEventActionCreateTopic, ChannelAdminLogEventActionEditTopic, ChannelAdminLogEventActionDeleteTopic, ChannelAdminLogEventActionPinTopic, ChannelAdminLogEventActionToggleAntiSpam, ChannelAdminLogEventActionChangeColor, ChannelAdminLogEventActionChangeBackgroundEmoji.
        """
        self.new_value = new_value

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionToggleForum',
            'new_value': self.new_value
        }

    def _bytes(self):
        return b''.join((
            b'\x83c\xcc\x02',
            b'\xb5ur\x99' if self.new_value else b'7\x97y\xbc',
        ))

    @classmethod
    def from_reader(cls, reader):
        _new_value = reader.tgread_bool()
        return cls(new_value=_new_value)


class ChannelAdminLogEventActionToggleGroupCallSetting(TLObject):
    CONSTRUCTOR_ID = 0x56d6a247
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, join_muted: bool):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions, ChannelAdminLogEventActionChangeUsernames, ChannelAdminLogEventActionToggleForum, ChannelAdminLogEventActionCreateTopic, ChannelAdminLogEventActionEditTopic, ChannelAdminLogEventActionDeleteTopic, ChannelAdminLogEventActionPinTopic, ChannelAdminLogEventActionToggleAntiSpam, ChannelAdminLogEventActionChangeColor, ChannelAdminLogEventActionChangeBackgroundEmoji.
        """
        self.join_muted = join_muted

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionToggleGroupCallSetting',
            'join_muted': self.join_muted
        }

    def _bytes(self):
        return b''.join((
            b'G\xa2\xd6V',
            b'\xb5ur\x99' if self.join_muted else b'7\x97y\xbc',
        ))

    @classmethod
    def from_reader(cls, reader):
        _join_muted = reader.tgread_bool()
        return cls(join_muted=_join_muted)


class ChannelAdminLogEventActionToggleInvites(TLObject):
    CONSTRUCTOR_ID = 0x1b7907ae
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, new_value: bool):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions, ChannelAdminLogEventActionChangeUsernames, ChannelAdminLogEventActionToggleForum, ChannelAdminLogEventActionCreateTopic, ChannelAdminLogEventActionEditTopic, ChannelAdminLogEventActionDeleteTopic, ChannelAdminLogEventActionPinTopic, ChannelAdminLogEventActionToggleAntiSpam, ChannelAdminLogEventActionChangeColor, ChannelAdminLogEventActionChangeBackgroundEmoji.
        """
        self.new_value = new_value

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionToggleInvites',
            'new_value': self.new_value
        }

    def _bytes(self):
        return b''.join((
            b'\xae\x07y\x1b',
            b'\xb5ur\x99' if self.new_value else b'7\x97y\xbc',
        ))

    @classmethod
    def from_reader(cls, reader):
        _new_value = reader.tgread_bool()
        return cls(new_value=_new_value)


class ChannelAdminLogEventActionToggleNoForwards(TLObject):
    CONSTRUCTOR_ID = 0xcb2ac766
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, new_value: bool):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions, ChannelAdminLogEventActionChangeUsernames, ChannelAdminLogEventActionToggleForum, ChannelAdminLogEventActionCreateTopic, ChannelAdminLogEventActionEditTopic, ChannelAdminLogEventActionDeleteTopic, ChannelAdminLogEventActionPinTopic, ChannelAdminLogEventActionToggleAntiSpam, ChannelAdminLogEventActionChangeColor, ChannelAdminLogEventActionChangeBackgroundEmoji.
        """
        self.new_value = new_value

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionToggleNoForwards',
            'new_value': self.new_value
        }

    def _bytes(self):
        return b''.join((
            b'f\xc7*\xcb',
            b'\xb5ur\x99' if self.new_value else b'7\x97y\xbc',
        ))

    @classmethod
    def from_reader(cls, reader):
        _new_value = reader.tgread_bool()
        return cls(new_value=_new_value)


class ChannelAdminLogEventActionTogglePreHistoryHidden(TLObject):
    CONSTRUCTOR_ID = 0x5f5c95f1
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, new_value: bool):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions, ChannelAdminLogEventActionChangeUsernames, ChannelAdminLogEventActionToggleForum, ChannelAdminLogEventActionCreateTopic, ChannelAdminLogEventActionEditTopic, ChannelAdminLogEventActionDeleteTopic, ChannelAdminLogEventActionPinTopic, ChannelAdminLogEventActionToggleAntiSpam, ChannelAdminLogEventActionChangeColor, ChannelAdminLogEventActionChangeBackgroundEmoji.
        """
        self.new_value = new_value

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionTogglePreHistoryHidden',
            'new_value': self.new_value
        }

    def _bytes(self):
        return b''.join((
            b'\xf1\x95\\_',
            b'\xb5ur\x99' if self.new_value else b'7\x97y\xbc',
        ))

    @classmethod
    def from_reader(cls, reader):
        _new_value = reader.tgread_bool()
        return cls(new_value=_new_value)


class ChannelAdminLogEventActionToggleSignatures(TLObject):
    CONSTRUCTOR_ID = 0x26ae0971
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, new_value: bool):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions, ChannelAdminLogEventActionChangeUsernames, ChannelAdminLogEventActionToggleForum, ChannelAdminLogEventActionCreateTopic, ChannelAdminLogEventActionEditTopic, ChannelAdminLogEventActionDeleteTopic, ChannelAdminLogEventActionPinTopic, ChannelAdminLogEventActionToggleAntiSpam, ChannelAdminLogEventActionChangeColor, ChannelAdminLogEventActionChangeBackgroundEmoji.
        """
        self.new_value = new_value

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionToggleSignatures',
            'new_value': self.new_value
        }

    def _bytes(self):
        return b''.join((
            b'q\t\xae&',
            b'\xb5ur\x99' if self.new_value else b'7\x97y\xbc',
        ))

    @classmethod
    def from_reader(cls, reader):
        _new_value = reader.tgread_bool()
        return cls(new_value=_new_value)


class ChannelAdminLogEventActionToggleSlowMode(TLObject):
    CONSTRUCTOR_ID = 0x53909779
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, prev_value: int, new_value: int):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions, ChannelAdminLogEventActionChangeUsernames, ChannelAdminLogEventActionToggleForum, ChannelAdminLogEventActionCreateTopic, ChannelAdminLogEventActionEditTopic, ChannelAdminLogEventActionDeleteTopic, ChannelAdminLogEventActionPinTopic, ChannelAdminLogEventActionToggleAntiSpam, ChannelAdminLogEventActionChangeColor, ChannelAdminLogEventActionChangeBackgroundEmoji.
        """
        self.prev_value = prev_value
        self.new_value = new_value

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionToggleSlowMode',
            'prev_value': self.prev_value,
            'new_value': self.new_value
        }

    def _bytes(self):
        return b''.join((
            b'y\x97\x90S',
            struct.pack('<i', self.prev_value),
            struct.pack('<i', self.new_value),
        ))

    @classmethod
    def from_reader(cls, reader):
        _prev_value = reader.read_int()
        _new_value = reader.read_int()
        return cls(prev_value=_prev_value, new_value=_new_value)


class ChannelAdminLogEventActionUpdatePinned(TLObject):
    CONSTRUCTOR_ID = 0xe9e82c18
    SUBCLASS_OF_ID = 0xb2b987f3

    def __init__(self, message: 'TypeMessage'):
        """
        Constructor for ChannelAdminLogEventAction: Instance of either ChannelAdminLogEventActionChangeTitle, ChannelAdminLogEventActionChangeAbout, ChannelAdminLogEventActionChangeUsername, ChannelAdminLogEventActionChangePhoto, ChannelAdminLogEventActionToggleInvites, ChannelAdminLogEventActionToggleSignatures, ChannelAdminLogEventActionUpdatePinned, ChannelAdminLogEventActionEditMessage, ChannelAdminLogEventActionDeleteMessage, ChannelAdminLogEventActionParticipantJoin, ChannelAdminLogEventActionParticipantLeave, ChannelAdminLogEventActionParticipantInvite, ChannelAdminLogEventActionParticipantToggleBan, ChannelAdminLogEventActionParticipantToggleAdmin, ChannelAdminLogEventActionChangeStickerSet, ChannelAdminLogEventActionTogglePreHistoryHidden, ChannelAdminLogEventActionDefaultBannedRights, ChannelAdminLogEventActionStopPoll, ChannelAdminLogEventActionChangeLinkedChat, ChannelAdminLogEventActionChangeLocation, ChannelAdminLogEventActionToggleSlowMode, ChannelAdminLogEventActionStartGroupCall, ChannelAdminLogEventActionDiscardGroupCall, ChannelAdminLogEventActionParticipantMute, ChannelAdminLogEventActionParticipantUnmute, ChannelAdminLogEventActionToggleGroupCallSetting, ChannelAdminLogEventActionParticipantJoinByInvite, ChannelAdminLogEventActionExportedInviteDelete, ChannelAdminLogEventActionExportedInviteRevoke, ChannelAdminLogEventActionExportedInviteEdit, ChannelAdminLogEventActionParticipantVolume, ChannelAdminLogEventActionChangeHistoryTTL, ChannelAdminLogEventActionParticipantJoinByRequest, ChannelAdminLogEventActionToggleNoForwards, ChannelAdminLogEventActionSendMessage, ChannelAdminLogEventActionChangeAvailableReactions, ChannelAdminLogEventActionChangeUsernames, ChannelAdminLogEventActionToggleForum, ChannelAdminLogEventActionCreateTopic, ChannelAdminLogEventActionEditTopic, ChannelAdminLogEventActionDeleteTopic, ChannelAdminLogEventActionPinTopic, ChannelAdminLogEventActionToggleAntiSpam, ChannelAdminLogEventActionChangeColor, ChannelAdminLogEventActionChangeBackgroundEmoji.
        """
        self.message = message

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventActionUpdatePinned',
            'message': self.message.to_dict() if isinstance(self.message, TLObject) else self.message
        }

    def _bytes(self):
        return b''.join((
            b'\x18,\xe8\xe9',
            self.message._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _message = reader.tgread_object()
        return cls(message=_message)


class ChannelAdminLogEventsFilter(TLObject):
    CONSTRUCTOR_ID = 0xea107ae4
    SUBCLASS_OF_ID = 0x7cbbf319

    def __init__(self, join: Optional[bool]=None, leave: Optional[bool]=None, invite: Optional[bool]=None, ban: Optional[bool]=None, unban: Optional[bool]=None, kick: Optional[bool]=None, unkick: Optional[bool]=None, promote: Optional[bool]=None, demote: Optional[bool]=None, info: Optional[bool]=None, settings: Optional[bool]=None, pinned: Optional[bool]=None, edit: Optional[bool]=None, delete: Optional[bool]=None, group_call: Optional[bool]=None, invites: Optional[bool]=None, send: Optional[bool]=None, forums: Optional[bool]=None):
        """
        Constructor for ChannelAdminLogEventsFilter: Instance of ChannelAdminLogEventsFilter.
        """
        self.join = join
        self.leave = leave
        self.invite = invite
        self.ban = ban
        self.unban = unban
        self.kick = kick
        self.unkick = unkick
        self.promote = promote
        self.demote = demote
        self.info = info
        self.settings = settings
        self.pinned = pinned
        self.edit = edit
        self.delete = delete
        self.group_call = group_call
        self.invites = invites
        self.send = send
        self.forums = forums

    def to_dict(self):
        return {
            '_': 'ChannelAdminLogEventsFilter',
            'join': self.join,
            'leave': self.leave,
            'invite': self.invite,
            'ban': self.ban,
            'unban': self.unban,
            'kick': self.kick,
            'unkick': self.unkick,
            'promote': self.promote,
            'demote': self.demote,
            'info': self.info,
            'settings': self.settings,
            'pinned': self.pinned,
            'edit': self.edit,
            'delete': self.delete,
            'group_call': self.group_call,
            'invites': self.invites,
            'send': self.send,
            'forums': self.forums
        }

    def _bytes(self):
        return b''.join((
            b'\xe4z\x10\xea',
            struct.pack('<I', (0 if self.join is None or self.join is False else 1) | (0 if self.leave is None or self.leave is False else 2) | (0 if self.invite is None or self.invite is False else 4) | (0 if self.ban is None or self.ban is False else 8) | (0 if self.unban is None or self.unban is False else 16) | (0 if self.kick is None or self.kick is False else 32) | (0 if self.unkick is None or self.unkick is False else 64) | (0 if self.promote is None or self.promote is False else 128) | (0 if self.demote is None or self.demote is False else 256) | (0 if self.info is None or self.info is False else 512) | (0 if self.settings is None or self.settings is False else 1024) | (0 if self.pinned is None or self.pinned is False else 2048) | (0 if self.edit is None or self.edit is False else 4096) | (0 if self.delete is None or self.delete is False else 8192) | (0 if self.group_call is None or self.group_call is False else 16384) | (0 if self.invites is None or self.invites is False else 32768) | (0 if self.send is None or self.send is False else 65536) | (0 if self.forums is None or self.forums is False else 131072)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _join = bool(flags & 1)
        _leave = bool(flags & 2)
        _invite = bool(flags & 4)
        _ban = bool(flags & 8)
        _unban = bool(flags & 16)
        _kick = bool(flags & 32)
        _unkick = bool(flags & 64)
        _promote = bool(flags & 128)
        _demote = bool(flags & 256)
        _info = bool(flags & 512)
        _settings = bool(flags & 1024)
        _pinned = bool(flags & 2048)
        _edit = bool(flags & 4096)
        _delete = bool(flags & 8192)
        _group_call = bool(flags & 16384)
        _invites = bool(flags & 32768)
        _send = bool(flags & 65536)
        _forums = bool(flags & 131072)
        return cls(join=_join, leave=_leave, invite=_invite, ban=_ban, unban=_unban, kick=_kick, unkick=_unkick, promote=_promote, demote=_demote, info=_info, settings=_settings, pinned=_pinned, edit=_edit, delete=_delete, group_call=_group_call, invites=_invites, send=_send, forums=_forums)


class ChannelForbidden(TLObject):
    CONSTRUCTOR_ID = 0x17d493d5
    SUBCLASS_OF_ID = 0xc5af5d94

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, title: str, broadcast: Optional[bool]=None, megagroup: Optional[bool]=None, until_date: Optional[datetime]=None):
        """
        Constructor for Chat: Instance of either ChatEmpty, Chat, ChatForbidden, Channel, ChannelForbidden.
        """
        self.id = id
        self.access_hash = access_hash
        self.title = title
        self.broadcast = broadcast
        self.megagroup = megagroup
        self.until_date = until_date

    def to_dict(self):
        return {
            '_': 'ChannelForbidden',
            'id': self.id,
            'access_hash': self.access_hash,
            'title': self.title,
            'broadcast': self.broadcast,
            'megagroup': self.megagroup,
            'until_date': self.until_date
        }

    def _bytes(self):
        return b''.join((
            b'\xd5\x93\xd4\x17',
            struct.pack('<I', (0 if self.broadcast is None or self.broadcast is False else 32) | (0 if self.megagroup is None or self.megagroup is False else 256) | (0 if self.until_date is None or self.until_date is False else 65536)),
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            self.serialize_bytes(self.title),
            b'' if self.until_date is None or self.until_date is False else (self.serialize_datetime(self.until_date)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _broadcast = bool(flags & 32)
        _megagroup = bool(flags & 256)
        _id = reader.read_long()
        _access_hash = reader.read_long()
        _title = reader.tgread_string()
        if flags & 65536:
            _until_date = reader.tgread_date()
        else:
            _until_date = None
        return cls(id=_id, access_hash=_access_hash, title=_title, broadcast=_broadcast, megagroup=_megagroup, until_date=_until_date)


class ChannelFull(TLObject):
    CONSTRUCTOR_ID = 0x723027bd
    SUBCLASS_OF_ID = 0xd49a2697

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, about: str, read_inbox_max_id: int, read_outbox_max_id: int, unread_count: int, chat_photo: 'TypePhoto', notify_settings: 'TypePeerNotifySettings', bot_info: List['TypeBotInfo'], pts: int, can_view_participants: Optional[bool]=None, can_set_username: Optional[bool]=None, can_set_stickers: Optional[bool]=None, hidden_prehistory: Optional[bool]=None, can_set_location: Optional[bool]=None, has_scheduled: Optional[bool]=None, can_view_stats: Optional[bool]=None, blocked: Optional[bool]=None, can_delete_channel: Optional[bool]=None, antispam: Optional[bool]=None, participants_hidden: Optional[bool]=None, translations_disabled: Optional[bool]=None, stories_pinned_available: Optional[bool]=None, participants_count: Optional[int]=None, admins_count: Optional[int]=None, kicked_count: Optional[int]=None, banned_count: Optional[int]=None, online_count: Optional[int]=None, exported_invite: Optional['TypeExportedChatInvite']=None, migrated_from_chat_id: Optional[int]=None, migrated_from_max_id: Optional[int]=None, pinned_msg_id: Optional[int]=None, stickerset: Optional['TypeStickerSet']=None, available_min_id: Optional[int]=None, folder_id: Optional[int]=None, linked_chat_id: Optional[int]=None, location: Optional['TypeChannelLocation']=None, slowmode_seconds: Optional[int]=None, slowmode_next_send_date: Optional[datetime]=None, stats_dc: Optional[int]=None, call: Optional['TypeInputGroupCall']=None, ttl_period: Optional[int]=None, pending_suggestions: Optional[List[str]]=None, groupcall_default_join_as: Optional['TypePeer']=None, theme_emoticon: Optional[str]=None, requests_pending: Optional[int]=None, recent_requesters: Optional[List[int]]=None, default_send_as: Optional['TypePeer']=None, available_reactions: Optional['TypeChatReactions']=None, stories: Optional['TypePeerStories']=None):
        """
        Constructor for ChatFull: Instance of either ChatFull, ChannelFull.
        """
        self.id = id
        self.about = about
        self.read_inbox_max_id = read_inbox_max_id
        self.read_outbox_max_id = read_outbox_max_id
        self.unread_count = unread_count
        self.chat_photo = chat_photo
        self.notify_settings = notify_settings
        self.bot_info = bot_info
        self.pts = pts
        self.can_view_participants = can_view_participants
        self.can_set_username = can_set_username
        self.can_set_stickers = can_set_stickers
        self.hidden_prehistory = hidden_prehistory
        self.can_set_location = can_set_location
        self.has_scheduled = has_scheduled
        self.can_view_stats = can_view_stats
        self.blocked = blocked
        self.can_delete_channel = can_delete_channel
        self.antispam = antispam
        self.participants_hidden = participants_hidden
        self.translations_disabled = translations_disabled
        self.stories_pinned_available = stories_pinned_available
        self.participants_count = participants_count
        self.admins_count = admins_count
        self.kicked_count = kicked_count
        self.banned_count = banned_count
        self.online_count = online_count
        self.exported_invite = exported_invite
        self.migrated_from_chat_id = migrated_from_chat_id
        self.migrated_from_max_id = migrated_from_max_id
        self.pinned_msg_id = pinned_msg_id
        self.stickerset = stickerset
        self.available_min_id = available_min_id
        self.folder_id = folder_id
        self.linked_chat_id = linked_chat_id
        self.location = location
        self.slowmode_seconds = slowmode_seconds
        self.slowmode_next_send_date = slowmode_next_send_date
        self.stats_dc = stats_dc
        self.call = call
        self.ttl_period = ttl_period
        self.pending_suggestions = pending_suggestions
        self.groupcall_default_join_as = groupcall_default_join_as
        self.theme_emoticon = theme_emoticon
        self.requests_pending = requests_pending
        self.recent_requesters = recent_requesters
        self.default_send_as = default_send_as
        self.available_reactions = available_reactions
        self.stories = stories

    def to_dict(self):
        return {
            '_': 'ChannelFull',
            'id': self.id,
            'about': self.about,
            'read_inbox_max_id': self.read_inbox_max_id,
            'read_outbox_max_id': self.read_outbox_max_id,
            'unread_count': self.unread_count,
            'chat_photo': self.chat_photo.to_dict() if isinstance(self.chat_photo, TLObject) else self.chat_photo,
            'notify_settings': self.notify_settings.to_dict() if isinstance(self.notify_settings, TLObject) else self.notify_settings,
            'bot_info': [] if self.bot_info is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.bot_info],
            'pts': self.pts,
            'can_view_participants': self.can_view_participants,
            'can_set_username': self.can_set_username,
            'can_set_stickers': self.can_set_stickers,
            'hidden_prehistory': self.hidden_prehistory,
            'can_set_location': self.can_set_location,
            'has_scheduled': self.has_scheduled,
            'can_view_stats': self.can_view_stats,
            'blocked': self.blocked,
            'can_delete_channel': self.can_delete_channel,
            'antispam': self.antispam,
            'participants_hidden': self.participants_hidden,
            'translations_disabled': self.translations_disabled,
            'stories_pinned_available': self.stories_pinned_available,
            'participants_count': self.participants_count,
            'admins_count': self.admins_count,
            'kicked_count': self.kicked_count,
            'banned_count': self.banned_count,
            'online_count': self.online_count,
            'exported_invite': self.exported_invite.to_dict() if isinstance(self.exported_invite, TLObject) else self.exported_invite,
            'migrated_from_chat_id': self.migrated_from_chat_id,
            'migrated_from_max_id': self.migrated_from_max_id,
            'pinned_msg_id': self.pinned_msg_id,
            'stickerset': self.stickerset.to_dict() if isinstance(self.stickerset, TLObject) else self.stickerset,
            'available_min_id': self.available_min_id,
            'folder_id': self.folder_id,
            'linked_chat_id': self.linked_chat_id,
            'location': self.location.to_dict() if isinstance(self.location, TLObject) else self.location,
            'slowmode_seconds': self.slowmode_seconds,
            'slowmode_next_send_date': self.slowmode_next_send_date,
            'stats_dc': self.stats_dc,
            'call': self.call.to_dict() if isinstance(self.call, TLObject) else self.call,
            'ttl_period': self.ttl_period,
            'pending_suggestions': [] if self.pending_suggestions is None else self.pending_suggestions[:],
            'groupcall_default_join_as': self.groupcall_default_join_as.to_dict() if isinstance(self.groupcall_default_join_as, TLObject) else self.groupcall_default_join_as,
            'theme_emoticon': self.theme_emoticon,
            'requests_pending': self.requests_pending,
            'recent_requesters': [] if self.recent_requesters is None else self.recent_requesters[:],
            'default_send_as': self.default_send_as.to_dict() if isinstance(self.default_send_as, TLObject) else self.default_send_as,
            'available_reactions': self.available_reactions.to_dict() if isinstance(self.available_reactions, TLObject) else self.available_reactions,
            'stories': self.stories.to_dict() if isinstance(self.stories, TLObject) else self.stories
        }

    def _bytes(self):
        assert ((self.kicked_count or self.kicked_count is not None) and (self.banned_count or self.banned_count is not None)) or ((self.kicked_count is None or self.kicked_count is False) and (self.banned_count is None or self.banned_count is False)), 'kicked_count, banned_count parameters must all be False-y (like None) or all me True-y'
        assert ((self.migrated_from_chat_id or self.migrated_from_chat_id is not None) and (self.migrated_from_max_id or self.migrated_from_max_id is not None)) or ((self.migrated_from_chat_id is None or self.migrated_from_chat_id is False) and (self.migrated_from_max_id is None or self.migrated_from_max_id is False)), 'migrated_from_chat_id, migrated_from_max_id parameters must all be False-y (like None) or all me True-y'
        assert ((self.requests_pending or self.requests_pending is not None) and (self.recent_requesters or self.recent_requesters is not None)) or ((self.requests_pending is None or self.requests_pending is False) and (self.recent_requesters is None or self.recent_requesters is False)), 'requests_pending, recent_requesters parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b"\xbd'0r",
            struct.pack('<I', (0 if self.can_view_participants is None or self.can_view_participants is False else 8) | (0 if self.can_set_username is None or self.can_set_username is False else 64) | (0 if self.can_set_stickers is None or self.can_set_stickers is False else 128) | (0 if self.hidden_prehistory is None or self.hidden_prehistory is False else 1024) | (0 if self.can_set_location is None or self.can_set_location is False else 65536) | (0 if self.has_scheduled is None or self.has_scheduled is False else 524288) | (0 if self.can_view_stats is None or self.can_view_stats is False else 1048576) | (0 if self.blocked is None or self.blocked is False else 4194304) | (0 if self.participants_count is None or self.participants_count is False else 1) | (0 if self.admins_count is None or self.admins_count is False else 2) | (0 if self.kicked_count is None or self.kicked_count is False else 4) | (0 if self.banned_count is None or self.banned_count is False else 4) | (0 if self.online_count is None or self.online_count is False else 8192) | (0 if self.exported_invite is None or self.exported_invite is False else 8388608) | (0 if self.migrated_from_chat_id is None or self.migrated_from_chat_id is False else 16) | (0 if self.migrated_from_max_id is None or self.migrated_from_max_id is False else 16) | (0 if self.pinned_msg_id is None or self.pinned_msg_id is False else 32) | (0 if self.stickerset is None or self.stickerset is False else 256) | (0 if self.available_min_id is None or self.available_min_id is False else 512) | (0 if self.folder_id is None or self.folder_id is False else 2048) | (0 if self.linked_chat_id is None or self.linked_chat_id is False else 16384) | (0 if self.location is None or self.location is False else 32768) | (0 if self.slowmode_seconds is None or self.slowmode_seconds is False else 131072) | (0 if self.slowmode_next_send_date is None or self.slowmode_next_send_date is False else 262144) | (0 if self.stats_dc is None or self.stats_dc is False else 4096) | (0 if self.call is None or self.call is False else 2097152) | (0 if self.ttl_period is None or self.ttl_period is False else 16777216) | (0 if self.pending_suggestions is None or self.pending_suggestions is False else 33554432) | (0 if self.groupcall_default_join_as is None or self.groupcall_default_join_as is False else 67108864) | (0 if self.theme_emoticon is None or self.theme_emoticon is False else 134217728) | (0 if self.requests_pending is None or self.requests_pending is False else 268435456) | (0 if self.recent_requesters is None or self.recent_requesters is False else 268435456) | (0 if self.default_send_as is None or self.default_send_as is False else 536870912) | (0 if self.available_reactions is None or self.available_reactions is False else 1073741824)),
            struct.pack('<I', (0 if self.can_delete_channel is None or self.can_delete_channel is False else 1) | (0 if self.antispam is None or self.antispam is False else 2) | (0 if self.participants_hidden is None or self.participants_hidden is False else 4) | (0 if self.translations_disabled is None or self.translations_disabled is False else 8) | (0 if self.stories_pinned_available is None or self.stories_pinned_available is False else 32) | (0 if self.stories is None or self.stories is False else 16)),
            struct.pack('<q', self.id),
            self.serialize_bytes(self.about),
            b'' if self.participants_count is None or self.participants_count is False else (struct.pack('<i', self.participants_count)),
            b'' if self.admins_count is None or self.admins_count is False else (struct.pack('<i', self.admins_count)),
            b'' if self.kicked_count is None or self.kicked_count is False else (struct.pack('<i', self.kicked_count)),
            b'' if self.banned_count is None or self.banned_count is False else (struct.pack('<i', self.banned_count)),
            b'' if self.online_count is None or self.online_count is False else (struct.pack('<i', self.online_count)),
            struct.pack('<i', self.read_inbox_max_id),
            struct.pack('<i', self.read_outbox_max_id),
            struct.pack('<i', self.unread_count),
            self.chat_photo._bytes(),
            self.notify_settings._bytes(),
            b'' if self.exported_invite is None or self.exported_invite is False else (self.exported_invite._bytes()),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.bot_info)),b''.join(x._bytes() for x in self.bot_info),
            b'' if self.migrated_from_chat_id is None or self.migrated_from_chat_id is False else (struct.pack('<q', self.migrated_from_chat_id)),
            b'' if self.migrated_from_max_id is None or self.migrated_from_max_id is False else (struct.pack('<i', self.migrated_from_max_id)),
            b'' if self.pinned_msg_id is None or self.pinned_msg_id is False else (struct.pack('<i', self.pinned_msg_id)),
            b'' if self.stickerset is None or self.stickerset is False else (self.stickerset._bytes()),
            b'' if self.available_min_id is None or self.available_min_id is False else (struct.pack('<i', self.available_min_id)),
            b'' if self.folder_id is None or self.folder_id is False else (struct.pack('<i', self.folder_id)),
            b'' if self.linked_chat_id is None or self.linked_chat_id is False else (struct.pack('<q', self.linked_chat_id)),
            b'' if self.location is None or self.location is False else (self.location._bytes()),
            b'' if self.slowmode_seconds is None or self.slowmode_seconds is False else (struct.pack('<i', self.slowmode_seconds)),
            b'' if self.slowmode_next_send_date is None or self.slowmode_next_send_date is False else (self.serialize_datetime(self.slowmode_next_send_date)),
            b'' if self.stats_dc is None or self.stats_dc is False else (struct.pack('<i', self.stats_dc)),
            struct.pack('<i', self.pts),
            b'' if self.call is None or self.call is False else (self.call._bytes()),
            b'' if self.ttl_period is None or self.ttl_period is False else (struct.pack('<i', self.ttl_period)),
            b'' if self.pending_suggestions is None or self.pending_suggestions is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.pending_suggestions)),b''.join(self.serialize_bytes(x) for x in self.pending_suggestions))),
            b'' if self.groupcall_default_join_as is None or self.groupcall_default_join_as is False else (self.groupcall_default_join_as._bytes()),
            b'' if self.theme_emoticon is None or self.theme_emoticon is False else (self.serialize_bytes(self.theme_emoticon)),
            b'' if self.requests_pending is None or self.requests_pending is False else (struct.pack('<i', self.requests_pending)),
            b'' if self.recent_requesters is None or self.recent_requesters is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.recent_requesters)),b''.join(struct.pack('<q', x) for x in self.recent_requesters))),
            b'' if self.default_send_as is None or self.default_send_as is False else (self.default_send_as._bytes()),
            b'' if self.available_reactions is None or self.available_reactions is False else (self.available_reactions._bytes()),
            b'' if self.stories is None or self.stories is False else (self.stories._bytes()),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _can_view_participants = bool(flags & 8)
        _can_set_username = bool(flags & 64)
        _can_set_stickers = bool(flags & 128)
        _hidden_prehistory = bool(flags & 1024)
        _can_set_location = bool(flags & 65536)
        _has_scheduled = bool(flags & 524288)
        _can_view_stats = bool(flags & 1048576)
        _blocked = bool(flags & 4194304)
        flags2 = reader.read_int()

        _can_delete_channel = bool(flags2 & 1)
        _antispam = bool(flags2 & 2)
        _participants_hidden = bool(flags2 & 4)
        _translations_disabled = bool(flags2 & 8)
        _stories_pinned_available = bool(flags2 & 32)
        _id = reader.read_long()
        _about = reader.tgread_string()
        if flags & 1:
            _participants_count = reader.read_int()
        else:
            _participants_count = None
        if flags & 2:
            _admins_count = reader.read_int()
        else:
            _admins_count = None
        if flags & 4:
            _kicked_count = reader.read_int()
        else:
            _kicked_count = None
        if flags & 4:
            _banned_count = reader.read_int()
        else:
            _banned_count = None
        if flags & 8192:
            _online_count = reader.read_int()
        else:
            _online_count = None
        _read_inbox_max_id = reader.read_int()
        _read_outbox_max_id = reader.read_int()
        _unread_count = reader.read_int()
        _chat_photo = reader.tgread_object()
        _notify_settings = reader.tgread_object()
        if flags & 8388608:
            _exported_invite = reader.tgread_object()
        else:
            _exported_invite = None
        reader.read_int()
        _bot_info = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _bot_info.append(_x)

        if flags & 16:
            _migrated_from_chat_id = reader.read_long()
        else:
            _migrated_from_chat_id = None
        if flags & 16:
            _migrated_from_max_id = reader.read_int()
        else:
            _migrated_from_max_id = None
        if flags & 32:
            _pinned_msg_id = reader.read_int()
        else:
            _pinned_msg_id = None
        if flags & 256:
            _stickerset = reader.tgread_object()
        else:
            _stickerset = None
        if flags & 512:
            _available_min_id = reader.read_int()
        else:
            _available_min_id = None
        if flags & 2048:
            _folder_id = reader.read_int()
        else:
            _folder_id = None
        if flags & 16384:
            _linked_chat_id = reader.read_long()
        else:
            _linked_chat_id = None
        if flags & 32768:
            _location = reader.tgread_object()
        else:
            _location = None
        if flags & 131072:
            _slowmode_seconds = reader.read_int()
        else:
            _slowmode_seconds = None
        if flags & 262144:
            _slowmode_next_send_date = reader.tgread_date()
        else:
            _slowmode_next_send_date = None
        if flags & 4096:
            _stats_dc = reader.read_int()
        else:
            _stats_dc = None
        _pts = reader.read_int()
        if flags & 2097152:
            _call = reader.tgread_object()
        else:
            _call = None
        if flags & 16777216:
            _ttl_period = reader.read_int()
        else:
            _ttl_period = None
        if flags & 33554432:
            reader.read_int()
            _pending_suggestions = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_string()
                _pending_suggestions.append(_x)

        else:
            _pending_suggestions = None
        if flags & 67108864:
            _groupcall_default_join_as = reader.tgread_object()
        else:
            _groupcall_default_join_as = None
        if flags & 134217728:
            _theme_emoticon = reader.tgread_string()
        else:
            _theme_emoticon = None
        if flags & 268435456:
            _requests_pending = reader.read_int()
        else:
            _requests_pending = None
        if flags & 268435456:
            reader.read_int()
            _recent_requesters = []
            for _ in range(reader.read_int()):
                _x = reader.read_long()
                _recent_requesters.append(_x)

        else:
            _recent_requesters = None
        if flags & 536870912:
            _default_send_as = reader.tgread_object()
        else:
            _default_send_as = None
        if flags & 1073741824:
            _available_reactions = reader.tgread_object()
        else:
            _available_reactions = None
        if flags2 & 16:
            _stories = reader.tgread_object()
        else:
            _stories = None
        return cls(id=_id, about=_about, read_inbox_max_id=_read_inbox_max_id, read_outbox_max_id=_read_outbox_max_id, unread_count=_unread_count, chat_photo=_chat_photo, notify_settings=_notify_settings, bot_info=_bot_info, pts=_pts, can_view_participants=_can_view_participants, can_set_username=_can_set_username, can_set_stickers=_can_set_stickers, hidden_prehistory=_hidden_prehistory, can_set_location=_can_set_location, has_scheduled=_has_scheduled, can_view_stats=_can_view_stats, blocked=_blocked, can_delete_channel=_can_delete_channel, antispam=_antispam, participants_hidden=_participants_hidden, translations_disabled=_translations_disabled, stories_pinned_available=_stories_pinned_available, participants_count=_participants_count, admins_count=_admins_count, kicked_count=_kicked_count, banned_count=_banned_count, online_count=_online_count, exported_invite=_exported_invite, migrated_from_chat_id=_migrated_from_chat_id, migrated_from_max_id=_migrated_from_max_id, pinned_msg_id=_pinned_msg_id, stickerset=_stickerset, available_min_id=_available_min_id, folder_id=_folder_id, linked_chat_id=_linked_chat_id, location=_location, slowmode_seconds=_slowmode_seconds, slowmode_next_send_date=_slowmode_next_send_date, stats_dc=_stats_dc, call=_call, ttl_period=_ttl_period, pending_suggestions=_pending_suggestions, groupcall_default_join_as=_groupcall_default_join_as, theme_emoticon=_theme_emoticon, requests_pending=_requests_pending, recent_requesters=_recent_requesters, default_send_as=_default_send_as, available_reactions=_available_reactions, stories=_stories)


class ChannelLocation(TLObject):
    CONSTRUCTOR_ID = 0x209b82db
    SUBCLASS_OF_ID = 0xec260b7f

    def __init__(self, geo_point: 'TypeGeoPoint', address: str):
        """
        Constructor for ChannelLocation: Instance of either ChannelLocationEmpty, ChannelLocation.
        """
        self.geo_point = geo_point
        self.address = address

    def to_dict(self):
        return {
            '_': 'ChannelLocation',
            'geo_point': self.geo_point.to_dict() if isinstance(self.geo_point, TLObject) else self.geo_point,
            'address': self.address
        }

    def _bytes(self):
        return b''.join((
            b'\xdb\x82\x9b ',
            self.geo_point._bytes(),
            self.serialize_bytes(self.address),
        ))

    @classmethod
    def from_reader(cls, reader):
        _geo_point = reader.tgread_object()
        _address = reader.tgread_string()
        return cls(geo_point=_geo_point, address=_address)


class ChannelLocationEmpty(TLObject):
    CONSTRUCTOR_ID = 0xbfb5ad8b
    SUBCLASS_OF_ID = 0xec260b7f

    def to_dict(self):
        return {
            '_': 'ChannelLocationEmpty'
        }

    def _bytes(self):
        return b''.join((
            b'\x8b\xad\xb5\xbf',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class ChannelMessagesFilter(TLObject):
    CONSTRUCTOR_ID = 0xcd77d957
    SUBCLASS_OF_ID = 0x13336a56

    def __init__(self, ranges: List['TypeMessageRange'], exclude_new_messages: Optional[bool]=None):
        """
        Constructor for ChannelMessagesFilter: Instance of either ChannelMessagesFilterEmpty, ChannelMessagesFilter.
        """
        self.ranges = ranges
        self.exclude_new_messages = exclude_new_messages

    def to_dict(self):
        return {
            '_': 'ChannelMessagesFilter',
            'ranges': [] if self.ranges is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.ranges],
            'exclude_new_messages': self.exclude_new_messages
        }

    def _bytes(self):
        return b''.join((
            b'W\xd9w\xcd',
            struct.pack('<I', (0 if self.exclude_new_messages is None or self.exclude_new_messages is False else 2)),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.ranges)),b''.join(x._bytes() for x in self.ranges),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _exclude_new_messages = bool(flags & 2)
        reader.read_int()
        _ranges = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _ranges.append(_x)

        return cls(ranges=_ranges, exclude_new_messages=_exclude_new_messages)


class ChannelMessagesFilterEmpty(TLObject):
    CONSTRUCTOR_ID = 0x94d42ee7
    SUBCLASS_OF_ID = 0x13336a56

    def to_dict(self):
        return {
            '_': 'ChannelMessagesFilterEmpty'
        }

    def _bytes(self):
        return b''.join((
            b'\xe7.\xd4\x94',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class ChannelParticipant(TLObject):
    CONSTRUCTOR_ID = 0xc00c07c0
    SUBCLASS_OF_ID = 0xd9c7fc18

    def __init__(self, user_id: int, date: Optional[datetime]):
        """
        Constructor for ChannelParticipant: Instance of either ChannelParticipant, ChannelParticipantSelf, ChannelParticipantCreator, ChannelParticipantAdmin, ChannelParticipantBanned, ChannelParticipantLeft.
        """
        self.user_id = user_id
        self.date = date

    def to_dict(self):
        return {
            '_': 'ChannelParticipant',
            'user_id': self.user_id,
            'date': self.date
        }

    def _bytes(self):
        return b''.join((
            b'\xc0\x07\x0c\xc0',
            struct.pack('<q', self.user_id),
            self.serialize_datetime(self.date),
        ))

    @classmethod
    def from_reader(cls, reader):
        _user_id = reader.read_long()
        _date = reader.tgread_date()
        return cls(user_id=_user_id, date=_date)


class ChannelParticipantAdmin(TLObject):
    CONSTRUCTOR_ID = 0x34c3bb53
    SUBCLASS_OF_ID = 0xd9c7fc18

    def __init__(self, user_id: int, promoted_by: int, date: Optional[datetime], admin_rights: 'TypeChatAdminRights', can_edit: Optional[bool]=None, is_self: Optional[bool]=None, inviter_id: Optional[int]=None, rank: Optional[str]=None):
        """
        Constructor for ChannelParticipant: Instance of either ChannelParticipant, ChannelParticipantSelf, ChannelParticipantCreator, ChannelParticipantAdmin, ChannelParticipantBanned, ChannelParticipantLeft.
        """
        self.user_id = user_id
        self.promoted_by = promoted_by
        self.date = date
        self.admin_rights = admin_rights
        self.can_edit = can_edit
        self.is_self = is_self
        self.inviter_id = inviter_id
        self.rank = rank

    def to_dict(self):
        return {
            '_': 'ChannelParticipantAdmin',
            'user_id': self.user_id,
            'promoted_by': self.promoted_by,
            'date': self.date,
            'admin_rights': self.admin_rights.to_dict() if isinstance(self.admin_rights, TLObject) else self.admin_rights,
            'can_edit': self.can_edit,
            'is_self': self.is_self,
            'inviter_id': self.inviter_id,
            'rank': self.rank
        }

    def _bytes(self):
        assert ((self.is_self or self.is_self is not None) and (self.inviter_id or self.inviter_id is not None)) or ((self.is_self is None or self.is_self is False) and (self.inviter_id is None or self.inviter_id is False)), 'is_self, inviter_id parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'S\xbb\xc34',
            struct.pack('<I', (0 if self.can_edit is None or self.can_edit is False else 1) | (0 if self.is_self is None or self.is_self is False else 2) | (0 if self.inviter_id is None or self.inviter_id is False else 2) | (0 if self.rank is None or self.rank is False else 4)),
            struct.pack('<q', self.user_id),
            b'' if self.inviter_id is None or self.inviter_id is False else (struct.pack('<q', self.inviter_id)),
            struct.pack('<q', self.promoted_by),
            self.serialize_datetime(self.date),
            self.admin_rights._bytes(),
            b'' if self.rank is None or self.rank is False else (self.serialize_bytes(self.rank)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _can_edit = bool(flags & 1)
        _is_self = bool(flags & 2)
        _user_id = reader.read_long()
        if flags & 2:
            _inviter_id = reader.read_long()
        else:
            _inviter_id = None
        _promoted_by = reader.read_long()
        _date = reader.tgread_date()
        _admin_rights = reader.tgread_object()
        if flags & 4:
            _rank = reader.tgread_string()
        else:
            _rank = None
        return cls(user_id=_user_id, promoted_by=_promoted_by, date=_date, admin_rights=_admin_rights, can_edit=_can_edit, is_self=_is_self, inviter_id=_inviter_id, rank=_rank)


class ChannelParticipantBanned(TLObject):
    CONSTRUCTOR_ID = 0x6df8014e
    SUBCLASS_OF_ID = 0xd9c7fc18

    def __init__(self, peer: 'TypePeer', kicked_by: int, date: Optional[datetime], banned_rights: 'TypeChatBannedRights', left: Optional[bool]=None):
        """
        Constructor for ChannelParticipant: Instance of either ChannelParticipant, ChannelParticipantSelf, ChannelParticipantCreator, ChannelParticipantAdmin, ChannelParticipantBanned, ChannelParticipantLeft.
        """
        self.peer = peer
        self.kicked_by = kicked_by
        self.date = date
        self.banned_rights = banned_rights
        self.left = left

    def to_dict(self):
        return {
            '_': 'ChannelParticipantBanned',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'kicked_by': self.kicked_by,
            'date': self.date,
            'banned_rights': self.banned_rights.to_dict() if isinstance(self.banned_rights, TLObject) else self.banned_rights,
            'left': self.left
        }

    def _bytes(self):
        return b''.join((
            b'N\x01\xf8m',
            struct.pack('<I', (0 if self.left is None or self.left is False else 1)),
            self.peer._bytes(),
            struct.pack('<q', self.kicked_by),
            self.serialize_datetime(self.date),
            self.banned_rights._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _left = bool(flags & 1)
        _peer = reader.tgread_object()
        _kicked_by = reader.read_long()
        _date = reader.tgread_date()
        _banned_rights = reader.tgread_object()
        return cls(peer=_peer, kicked_by=_kicked_by, date=_date, banned_rights=_banned_rights, left=_left)


class ChannelParticipantCreator(TLObject):
    CONSTRUCTOR_ID = 0x2fe601d3
    SUBCLASS_OF_ID = 0xd9c7fc18

    def __init__(self, user_id: int, admin_rights: 'TypeChatAdminRights', rank: Optional[str]=None):
        """
        Constructor for ChannelParticipant: Instance of either ChannelParticipant, ChannelParticipantSelf, ChannelParticipantCreator, ChannelParticipantAdmin, ChannelParticipantBanned, ChannelParticipantLeft.
        """
        self.user_id = user_id
        self.admin_rights = admin_rights
        self.rank = rank

    def to_dict(self):
        return {
            '_': 'ChannelParticipantCreator',
            'user_id': self.user_id,
            'admin_rights': self.admin_rights.to_dict() if isinstance(self.admin_rights, TLObject) else self.admin_rights,
            'rank': self.rank
        }

    def _bytes(self):
        return b''.join((
            b'\xd3\x01\xe6/',
            struct.pack('<I', (0 if self.rank is None or self.rank is False else 1)),
            struct.pack('<q', self.user_id),
            self.admin_rights._bytes(),
            b'' if self.rank is None or self.rank is False else (self.serialize_bytes(self.rank)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _user_id = reader.read_long()
        _admin_rights = reader.tgread_object()
        if flags & 1:
            _rank = reader.tgread_string()
        else:
            _rank = None
        return cls(user_id=_user_id, admin_rights=_admin_rights, rank=_rank)


class ChannelParticipantLeft(TLObject):
    CONSTRUCTOR_ID = 0x1b03f006
    SUBCLASS_OF_ID = 0xd9c7fc18

    def __init__(self, peer: 'TypePeer'):
        """
        Constructor for ChannelParticipant: Instance of either ChannelParticipant, ChannelParticipantSelf, ChannelParticipantCreator, ChannelParticipantAdmin, ChannelParticipantBanned, ChannelParticipantLeft.
        """
        self.peer = peer

    def to_dict(self):
        return {
            '_': 'ChannelParticipantLeft',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer
        }

    def _bytes(self):
        return b''.join((
            b'\x06\xf0\x03\x1b',
            self.peer._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        return cls(peer=_peer)


class ChannelParticipantSelf(TLObject):
    CONSTRUCTOR_ID = 0x35a8bfa7
    SUBCLASS_OF_ID = 0xd9c7fc18

    def __init__(self, user_id: int, inviter_id: int, date: Optional[datetime], via_request: Optional[bool]=None):
        """
        Constructor for ChannelParticipant: Instance of either ChannelParticipant, ChannelParticipantSelf, ChannelParticipantCreator, ChannelParticipantAdmin, ChannelParticipantBanned, ChannelParticipantLeft.
        """
        self.user_id = user_id
        self.inviter_id = inviter_id
        self.date = date
        self.via_request = via_request

    def to_dict(self):
        return {
            '_': 'ChannelParticipantSelf',
            'user_id': self.user_id,
            'inviter_id': self.inviter_id,
            'date': self.date,
            'via_request': self.via_request
        }

    def _bytes(self):
        return b''.join((
            b'\xa7\xbf\xa85',
            struct.pack('<I', (0 if self.via_request is None or self.via_request is False else 1)),
            struct.pack('<q', self.user_id),
            struct.pack('<q', self.inviter_id),
            self.serialize_datetime(self.date),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _via_request = bool(flags & 1)
        _user_id = reader.read_long()
        _inviter_id = reader.read_long()
        _date = reader.tgread_date()
        return cls(user_id=_user_id, inviter_id=_inviter_id, date=_date, via_request=_via_request)


class ChannelParticipantsAdmins(TLObject):
    CONSTRUCTOR_ID = 0xb4608969
    SUBCLASS_OF_ID = 0xbf4e2753

    def to_dict(self):
        return {
            '_': 'ChannelParticipantsAdmins'
        }

    def _bytes(self):
        return b''.join((
            b'i\x89`\xb4',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class ChannelParticipantsBanned(TLObject):
    CONSTRUCTOR_ID = 0x1427a5e1
    SUBCLASS_OF_ID = 0xbf4e2753

    def __init__(self, q: str):
        """
        Constructor for ChannelParticipantsFilter: Instance of either ChannelParticipantsRecent, ChannelParticipantsAdmins, ChannelParticipantsKicked, ChannelParticipantsBots, ChannelParticipantsBanned, ChannelParticipantsSearch, ChannelParticipantsContacts, ChannelParticipantsMentions.
        """
        self.q = q

    def to_dict(self):
        return {
            '_': 'ChannelParticipantsBanned',
            'q': self.q
        }

    def _bytes(self):
        return b''.join((
            b"\xe1\xa5'\x14",
            self.serialize_bytes(self.q),
        ))

    @classmethod
    def from_reader(cls, reader):
        _q = reader.tgread_string()
        return cls(q=_q)


class ChannelParticipantsBots(TLObject):
    CONSTRUCTOR_ID = 0xb0d1865b
    SUBCLASS_OF_ID = 0xbf4e2753

    def to_dict(self):
        return {
            '_': 'ChannelParticipantsBots'
        }

    def _bytes(self):
        return b''.join((
            b'[\x86\xd1\xb0',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class ChannelParticipantsContacts(TLObject):
    CONSTRUCTOR_ID = 0xbb6ae88d
    SUBCLASS_OF_ID = 0xbf4e2753

    def __init__(self, q: str):
        """
        Constructor for ChannelParticipantsFilter: Instance of either ChannelParticipantsRecent, ChannelParticipantsAdmins, ChannelParticipantsKicked, ChannelParticipantsBots, ChannelParticipantsBanned, ChannelParticipantsSearch, ChannelParticipantsContacts, ChannelParticipantsMentions.
        """
        self.q = q

    def to_dict(self):
        return {
            '_': 'ChannelParticipantsContacts',
            'q': self.q
        }

    def _bytes(self):
        return b''.join((
            b'\x8d\xe8j\xbb',
            self.serialize_bytes(self.q),
        ))

    @classmethod
    def from_reader(cls, reader):
        _q = reader.tgread_string()
        return cls(q=_q)


class ChannelParticipantsKicked(TLObject):
    CONSTRUCTOR_ID = 0xa3b54985
    SUBCLASS_OF_ID = 0xbf4e2753

    def __init__(self, q: str):
        """
        Constructor for ChannelParticipantsFilter: Instance of either ChannelParticipantsRecent, ChannelParticipantsAdmins, ChannelParticipantsKicked, ChannelParticipantsBots, ChannelParticipantsBanned, ChannelParticipantsSearch, ChannelParticipantsContacts, ChannelParticipantsMentions.
        """
        self.q = q

    def to_dict(self):
        return {
            '_': 'ChannelParticipantsKicked',
            'q': self.q
        }

    def _bytes(self):
        return b''.join((
            b'\x85I\xb5\xa3',
            self.serialize_bytes(self.q),
        ))

    @classmethod
    def from_reader(cls, reader):
        _q = reader.tgread_string()
        return cls(q=_q)


class ChannelParticipantsMentions(TLObject):
    CONSTRUCTOR_ID = 0xe04b5ceb
    SUBCLASS_OF_ID = 0xbf4e2753

    def __init__(self, q: Optional[str]=None, top_msg_id: Optional[int]=None):
        """
        Constructor for ChannelParticipantsFilter: Instance of either ChannelParticipantsRecent, ChannelParticipantsAdmins, ChannelParticipantsKicked, ChannelParticipantsBots, ChannelParticipantsBanned, ChannelParticipantsSearch, ChannelParticipantsContacts, ChannelParticipantsMentions.
        """
        self.q = q
        self.top_msg_id = top_msg_id

    def to_dict(self):
        return {
            '_': 'ChannelParticipantsMentions',
            'q': self.q,
            'top_msg_id': self.top_msg_id
        }

    def _bytes(self):
        return b''.join((
            b'\xeb\\K\xe0',
            struct.pack('<I', (0 if self.q is None or self.q is False else 1) | (0 if self.top_msg_id is None or self.top_msg_id is False else 2)),
            b'' if self.q is None or self.q is False else (self.serialize_bytes(self.q)),
            b'' if self.top_msg_id is None or self.top_msg_id is False else (struct.pack('<i', self.top_msg_id)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 1:
            _q = reader.tgread_string()
        else:
            _q = None
        if flags & 2:
            _top_msg_id = reader.read_int()
        else:
            _top_msg_id = None
        return cls(q=_q, top_msg_id=_top_msg_id)


class ChannelParticipantsRecent(TLObject):
    CONSTRUCTOR_ID = 0xde3f3c79
    SUBCLASS_OF_ID = 0xbf4e2753

    def to_dict(self):
        return {
            '_': 'ChannelParticipantsRecent'
        }

    def _bytes(self):
        return b''.join((
            b'y<?\xde',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class ChannelParticipantsSearch(TLObject):
    CONSTRUCTOR_ID = 0x656ac4b
    SUBCLASS_OF_ID = 0xbf4e2753

    def __init__(self, q: str):
        """
        Constructor for ChannelParticipantsFilter: Instance of either ChannelParticipantsRecent, ChannelParticipantsAdmins, ChannelParticipantsKicked, ChannelParticipantsBots, ChannelParticipantsBanned, ChannelParticipantsSearch, ChannelParticipantsContacts, ChannelParticipantsMentions.
        """
        self.q = q

    def to_dict(self):
        return {
            '_': 'ChannelParticipantsSearch',
            'q': self.q
        }

    def _bytes(self):
        return b''.join((
            b'K\xacV\x06',
            self.serialize_bytes(self.q),
        ))

    @classmethod
    def from_reader(cls, reader):
        _q = reader.tgread_string()
        return cls(q=_q)


class Chat(TLObject):
    CONSTRUCTOR_ID = 0x41cbf256
    SUBCLASS_OF_ID = 0xc5af5d94

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, title: str, photo: 'TypeChatPhoto', participants_count: int, date: Optional[datetime], version: int, creator: Optional[bool]=None, left: Optional[bool]=None, deactivated: Optional[bool]=None, call_active: Optional[bool]=None, call_not_empty: Optional[bool]=None, noforwards: Optional[bool]=None, migrated_to: Optional['TypeInputChannel']=None, admin_rights: Optional['TypeChatAdminRights']=None, default_banned_rights: Optional['TypeChatBannedRights']=None):
        """
        Constructor for Chat: Instance of either ChatEmpty, Chat, ChatForbidden, Channel, ChannelForbidden.
        """
        self.id = id
        self.title = title
        self.photo = photo
        self.participants_count = participants_count
        self.date = date
        self.version = version
        self.creator = creator
        self.left = left
        self.deactivated = deactivated
        self.call_active = call_active
        self.call_not_empty = call_not_empty
        self.noforwards = noforwards
        self.migrated_to = migrated_to
        self.admin_rights = admin_rights
        self.default_banned_rights = default_banned_rights

    def to_dict(self):
        return {
            '_': 'Chat',
            'id': self.id,
            'title': self.title,
            'photo': self.photo.to_dict() if isinstance(self.photo, TLObject) else self.photo,
            'participants_count': self.participants_count,
            'date': self.date,
            'version': self.version,
            'creator': self.creator,
            'left': self.left,
            'deactivated': self.deactivated,
            'call_active': self.call_active,
            'call_not_empty': self.call_not_empty,
            'noforwards': self.noforwards,
            'migrated_to': self.migrated_to.to_dict() if isinstance(self.migrated_to, TLObject) else self.migrated_to,
            'admin_rights': self.admin_rights.to_dict() if isinstance(self.admin_rights, TLObject) else self.admin_rights,
            'default_banned_rights': self.default_banned_rights.to_dict() if isinstance(self.default_banned_rights, TLObject) else self.default_banned_rights
        }

    def _bytes(self):
        return b''.join((
            b'V\xf2\xcbA',
            struct.pack('<I', (0 if self.creator is None or self.creator is False else 1) | (0 if self.left is None or self.left is False else 4) | (0 if self.deactivated is None or self.deactivated is False else 32) | (0 if self.call_active is None or self.call_active is False else 8388608) | (0 if self.call_not_empty is None or self.call_not_empty is False else 16777216) | (0 if self.noforwards is None or self.noforwards is False else 33554432) | (0 if self.migrated_to is None or self.migrated_to is False else 64) | (0 if self.admin_rights is None or self.admin_rights is False else 16384) | (0 if self.default_banned_rights is None or self.default_banned_rights is False else 262144)),
            struct.pack('<q', self.id),
            self.serialize_bytes(self.title),
            self.photo._bytes(),
            struct.pack('<i', self.participants_count),
            self.serialize_datetime(self.date),
            struct.pack('<i', self.version),
            b'' if self.migrated_to is None or self.migrated_to is False else (self.migrated_to._bytes()),
            b'' if self.admin_rights is None or self.admin_rights is False else (self.admin_rights._bytes()),
            b'' if self.default_banned_rights is None or self.default_banned_rights is False else (self.default_banned_rights._bytes()),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _creator = bool(flags & 1)
        _left = bool(flags & 4)
        _deactivated = bool(flags & 32)
        _call_active = bool(flags & 8388608)
        _call_not_empty = bool(flags & 16777216)
        _noforwards = bool(flags & 33554432)
        _id = reader.read_long()
        _title = reader.tgread_string()
        _photo = reader.tgread_object()
        _participants_count = reader.read_int()
        _date = reader.tgread_date()
        _version = reader.read_int()
        if flags & 64:
            _migrated_to = reader.tgread_object()
        else:
            _migrated_to = None
        if flags & 16384:
            _admin_rights = reader.tgread_object()
        else:
            _admin_rights = None
        if flags & 262144:
            _default_banned_rights = reader.tgread_object()
        else:
            _default_banned_rights = None
        return cls(id=_id, title=_title, photo=_photo, participants_count=_participants_count, date=_date, version=_version, creator=_creator, left=_left, deactivated=_deactivated, call_active=_call_active, call_not_empty=_call_not_empty, noforwards=_noforwards, migrated_to=_migrated_to, admin_rights=_admin_rights, default_banned_rights=_default_banned_rights)


class ChatAdminRights(TLObject):
    CONSTRUCTOR_ID = 0x5fb224d5
    SUBCLASS_OF_ID = 0x863dc7c4

    def __init__(self, change_info: Optional[bool]=None, post_messages: Optional[bool]=None, edit_messages: Optional[bool]=None, delete_messages: Optional[bool]=None, ban_users: Optional[bool]=None, invite_users: Optional[bool]=None, pin_messages: Optional[bool]=None, add_admins: Optional[bool]=None, anonymous: Optional[bool]=None, manage_call: Optional[bool]=None, other: Optional[bool]=None, manage_topics: Optional[bool]=None, post_stories: Optional[bool]=None, edit_stories: Optional[bool]=None, delete_stories: Optional[bool]=None):
        """
        Constructor for ChatAdminRights: Instance of ChatAdminRights.
        """
        self.change_info = change_info
        self.post_messages = post_messages
        self.edit_messages = edit_messages
        self.delete_messages = delete_messages
        self.ban_users = ban_users
        self.invite_users = invite_users
        self.pin_messages = pin_messages
        self.add_admins = add_admins
        self.anonymous = anonymous
        self.manage_call = manage_call
        self.other = other
        self.manage_topics = manage_topics
        self.post_stories = post_stories
        self.edit_stories = edit_stories
        self.delete_stories = delete_stories

    def to_dict(self):
        return {
            '_': 'ChatAdminRights',
            'change_info': self.change_info,
            'post_messages': self.post_messages,
            'edit_messages': self.edit_messages,
            'delete_messages': self.delete_messages,
            'ban_users': self.ban_users,
            'invite_users': self.invite_users,
            'pin_messages': self.pin_messages,
            'add_admins': self.add_admins,
            'anonymous': self.anonymous,
            'manage_call': self.manage_call,
            'other': self.other,
            'manage_topics': self.manage_topics,
            'post_stories': self.post_stories,
            'edit_stories': self.edit_stories,
            'delete_stories': self.delete_stories
        }

    def _bytes(self):
        return b''.join((
            b'\xd5$\xb2_',
            struct.pack('<I', (0 if self.change_info is None or self.change_info is False else 1) | (0 if self.post_messages is None or self.post_messages is False else 2) | (0 if self.edit_messages is None or self.edit_messages is False else 4) | (0 if self.delete_messages is None or self.delete_messages is False else 8) | (0 if self.ban_users is None or self.ban_users is False else 16) | (0 if self.invite_users is None or self.invite_users is False else 32) | (0 if self.pin_messages is None or self.pin_messages is False else 128) | (0 if self.add_admins is None or self.add_admins is False else 512) | (0 if self.anonymous is None or self.anonymous is False else 1024) | (0 if self.manage_call is None or self.manage_call is False else 2048) | (0 if self.other is None or self.other is False else 4096) | (0 if self.manage_topics is None or self.manage_topics is False else 8192) | (0 if self.post_stories is None or self.post_stories is False else 16384) | (0 if self.edit_stories is None or self.edit_stories is False else 32768) | (0 if self.delete_stories is None or self.delete_stories is False else 65536)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _change_info = bool(flags & 1)
        _post_messages = bool(flags & 2)
        _edit_messages = bool(flags & 4)
        _delete_messages = bool(flags & 8)
        _ban_users = bool(flags & 16)
        _invite_users = bool(flags & 32)
        _pin_messages = bool(flags & 128)
        _add_admins = bool(flags & 512)
        _anonymous = bool(flags & 1024)
        _manage_call = bool(flags & 2048)
        _other = bool(flags & 4096)
        _manage_topics = bool(flags & 8192)
        _post_stories = bool(flags & 16384)
        _edit_stories = bool(flags & 32768)
        _delete_stories = bool(flags & 65536)
        return cls(change_info=_change_info, post_messages=_post_messages, edit_messages=_edit_messages, delete_messages=_delete_messages, ban_users=_ban_users, invite_users=_invite_users, pin_messages=_pin_messages, add_admins=_add_admins, anonymous=_anonymous, manage_call=_manage_call, other=_other, manage_topics=_manage_topics, post_stories=_post_stories, edit_stories=_edit_stories, delete_stories=_delete_stories)


class ChatAdminWithInvites(TLObject):
    CONSTRUCTOR_ID = 0xf2ecef23
    SUBCLASS_OF_ID = 0x5063f398

    def __init__(self, admin_id: int, invites_count: int, revoked_invites_count: int):
        """
        Constructor for ChatAdminWithInvites: Instance of ChatAdminWithInvites.
        """
        self.admin_id = admin_id
        self.invites_count = invites_count
        self.revoked_invites_count = revoked_invites_count

    def to_dict(self):
        return {
            '_': 'ChatAdminWithInvites',
            'admin_id': self.admin_id,
            'invites_count': self.invites_count,
            'revoked_invites_count': self.revoked_invites_count
        }

    def _bytes(self):
        return b''.join((
            b'#\xef\xec\xf2',
            struct.pack('<q', self.admin_id),
            struct.pack('<i', self.invites_count),
            struct.pack('<i', self.revoked_invites_count),
        ))

    @classmethod
    def from_reader(cls, reader):
        _admin_id = reader.read_long()
        _invites_count = reader.read_int()
        _revoked_invites_count = reader.read_int()
        return cls(admin_id=_admin_id, invites_count=_invites_count, revoked_invites_count=_revoked_invites_count)


class ChatBannedRights(TLObject):
    CONSTRUCTOR_ID = 0x9f120418
    SUBCLASS_OF_ID = 0x4b5445a9

    def __init__(self, until_date: Optional[datetime], view_messages: Optional[bool]=None, send_messages: Optional[bool]=None, send_media: Optional[bool]=None, send_stickers: Optional[bool]=None, send_gifs: Optional[bool]=None, send_games: Optional[bool]=None, send_inline: Optional[bool]=None, embed_links: Optional[bool]=None, send_polls: Optional[bool]=None, change_info: Optional[bool]=None, invite_users: Optional[bool]=None, pin_messages: Optional[bool]=None, manage_topics: Optional[bool]=None, send_photos: Optional[bool]=None, send_videos: Optional[bool]=None, send_roundvideos: Optional[bool]=None, send_audios: Optional[bool]=None, send_voices: Optional[bool]=None, send_docs: Optional[bool]=None, send_plain: Optional[bool]=None):
        """
        Constructor for ChatBannedRights: Instance of ChatBannedRights.
        """
        self.until_date = until_date
        self.view_messages = view_messages
        self.send_messages = send_messages
        self.send_media = send_media
        self.send_stickers = send_stickers
        self.send_gifs = send_gifs
        self.send_games = send_games
        self.send_inline = send_inline
        self.embed_links = embed_links
        self.send_polls = send_polls
        self.change_info = change_info
        self.invite_users = invite_users
        self.pin_messages = pin_messages
        self.manage_topics = manage_topics
        self.send_photos = send_photos
        self.send_videos = send_videos
        self.send_roundvideos = send_roundvideos
        self.send_audios = send_audios
        self.send_voices = send_voices
        self.send_docs = send_docs
        self.send_plain = send_plain

    def to_dict(self):
        return {
            '_': 'ChatBannedRights',
            'until_date': self.until_date,
            'view_messages': self.view_messages,
            'send_messages': self.send_messages,
            'send_media': self.send_media,
            'send_stickers': self.send_stickers,
            'send_gifs': self.send_gifs,
            'send_games': self.send_games,
            'send_inline': self.send_inline,
            'embed_links': self.embed_links,
            'send_polls': self.send_polls,
            'change_info': self.change_info,
            'invite_users': self.invite_users,
            'pin_messages': self.pin_messages,
            'manage_topics': self.manage_topics,
            'send_photos': self.send_photos,
            'send_videos': self.send_videos,
            'send_roundvideos': self.send_roundvideos,
            'send_audios': self.send_audios,
            'send_voices': self.send_voices,
            'send_docs': self.send_docs,
            'send_plain': self.send_plain
        }

    def _bytes(self):
        return b''.join((
            b'\x18\x04\x12\x9f',
            struct.pack('<I', (0 if self.view_messages is None or self.view_messages is False else 1) | (0 if self.send_messages is None or self.send_messages is False else 2) | (0 if self.send_media is None or self.send_media is False else 4) | (0 if self.send_stickers is None or self.send_stickers is False else 8) | (0 if self.send_gifs is None or self.send_gifs is False else 16) | (0 if self.send_games is None or self.send_games is False else 32) | (0 if self.send_inline is None or self.send_inline is False else 64) | (0 if self.embed_links is None or self.embed_links is False else 128) | (0 if self.send_polls is None or self.send_polls is False else 256) | (0 if self.change_info is None or self.change_info is False else 1024) | (0 if self.invite_users is None or self.invite_users is False else 32768) | (0 if self.pin_messages is None or self.pin_messages is False else 131072) | (0 if self.manage_topics is None or self.manage_topics is False else 262144) | (0 if self.send_photos is None or self.send_photos is False else 524288) | (0 if self.send_videos is None or self.send_videos is False else 1048576) | (0 if self.send_roundvideos is None or self.send_roundvideos is False else 2097152) | (0 if self.send_audios is None or self.send_audios is False else 4194304) | (0 if self.send_voices is None or self.send_voices is False else 8388608) | (0 if self.send_docs is None or self.send_docs is False else 16777216) | (0 if self.send_plain is None or self.send_plain is False else 33554432)),
            self.serialize_datetime(self.until_date),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _view_messages = bool(flags & 1)
        _send_messages = bool(flags & 2)
        _send_media = bool(flags & 4)
        _send_stickers = bool(flags & 8)
        _send_gifs = bool(flags & 16)
        _send_games = bool(flags & 32)
        _send_inline = bool(flags & 64)
        _embed_links = bool(flags & 128)
        _send_polls = bool(flags & 256)
        _change_info = bool(flags & 1024)
        _invite_users = bool(flags & 32768)
        _pin_messages = bool(flags & 131072)
        _manage_topics = bool(flags & 262144)
        _send_photos = bool(flags & 524288)
        _send_videos = bool(flags & 1048576)
        _send_roundvideos = bool(flags & 2097152)
        _send_audios = bool(flags & 4194304)
        _send_voices = bool(flags & 8388608)
        _send_docs = bool(flags & 16777216)
        _send_plain = bool(flags & 33554432)
        _until_date = reader.tgread_date()
        return cls(until_date=_until_date, view_messages=_view_messages, send_messages=_send_messages, send_media=_send_media, send_stickers=_send_stickers, send_gifs=_send_gifs, send_games=_send_games, send_inline=_send_inline, embed_links=_embed_links, send_polls=_send_polls, change_info=_change_info, invite_users=_invite_users, pin_messages=_pin_messages, manage_topics=_manage_topics, send_photos=_send_photos, send_videos=_send_videos, send_roundvideos=_send_roundvideos, send_audios=_send_audios, send_voices=_send_voices, send_docs=_send_docs, send_plain=_send_plain)


class ChatEmpty(TLObject):
    CONSTRUCTOR_ID = 0x29562865
    SUBCLASS_OF_ID = 0xc5af5d94

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int):
        """
        Constructor for Chat: Instance of either ChatEmpty, Chat, ChatForbidden, Channel, ChannelForbidden.
        """
        self.id = id

    def to_dict(self):
        return {
            '_': 'ChatEmpty',
            'id': self.id
        }

    def _bytes(self):
        return b''.join((
            b'e(V)',
            struct.pack('<q', self.id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        return cls(id=_id)


class ChatForbidden(TLObject):
    CONSTRUCTOR_ID = 0x6592a1a7
    SUBCLASS_OF_ID = 0xc5af5d94

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, title: str):
        """
        Constructor for Chat: Instance of either ChatEmpty, Chat, ChatForbidden, Channel, ChannelForbidden.
        """
        self.id = id
        self.title = title

    def to_dict(self):
        return {
            '_': 'ChatForbidden',
            'id': self.id,
            'title': self.title
        }

    def _bytes(self):
        return b''.join((
            b'\xa7\xa1\x92e',
            struct.pack('<q', self.id),
            self.serialize_bytes(self.title),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _title = reader.tgread_string()
        return cls(id=_id, title=_title)


class ChatFull(TLObject):
    CONSTRUCTOR_ID = 0xc9d31138
    SUBCLASS_OF_ID = 0xd49a2697

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, about: str, participants: 'TypeChatParticipants', notify_settings: 'TypePeerNotifySettings', can_set_username: Optional[bool]=None, has_scheduled: Optional[bool]=None, translations_disabled: Optional[bool]=None, chat_photo: Optional['TypePhoto']=None, exported_invite: Optional['TypeExportedChatInvite']=None, bot_info: Optional[List['TypeBotInfo']]=None, pinned_msg_id: Optional[int]=None, folder_id: Optional[int]=None, call: Optional['TypeInputGroupCall']=None, ttl_period: Optional[int]=None, groupcall_default_join_as: Optional['TypePeer']=None, theme_emoticon: Optional[str]=None, requests_pending: Optional[int]=None, recent_requesters: Optional[List[int]]=None, available_reactions: Optional['TypeChatReactions']=None):
        """
        Constructor for ChatFull: Instance of either ChatFull, ChannelFull.
        """
        self.id = id
        self.about = about
        self.participants = participants
        self.notify_settings = notify_settings
        self.can_set_username = can_set_username
        self.has_scheduled = has_scheduled
        self.translations_disabled = translations_disabled
        self.chat_photo = chat_photo
        self.exported_invite = exported_invite
        self.bot_info = bot_info
        self.pinned_msg_id = pinned_msg_id
        self.folder_id = folder_id
        self.call = call
        self.ttl_period = ttl_period
        self.groupcall_default_join_as = groupcall_default_join_as
        self.theme_emoticon = theme_emoticon
        self.requests_pending = requests_pending
        self.recent_requesters = recent_requesters
        self.available_reactions = available_reactions

    def to_dict(self):
        return {
            '_': 'ChatFull',
            'id': self.id,
            'about': self.about,
            'participants': self.participants.to_dict() if isinstance(self.participants, TLObject) else self.participants,
            'notify_settings': self.notify_settings.to_dict() if isinstance(self.notify_settings, TLObject) else self.notify_settings,
            'can_set_username': self.can_set_username,
            'has_scheduled': self.has_scheduled,
            'translations_disabled': self.translations_disabled,
            'chat_photo': self.chat_photo.to_dict() if isinstance(self.chat_photo, TLObject) else self.chat_photo,
            'exported_invite': self.exported_invite.to_dict() if isinstance(self.exported_invite, TLObject) else self.exported_invite,
            'bot_info': [] if self.bot_info is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.bot_info],
            'pinned_msg_id': self.pinned_msg_id,
            'folder_id': self.folder_id,
            'call': self.call.to_dict() if isinstance(self.call, TLObject) else self.call,
            'ttl_period': self.ttl_period,
            'groupcall_default_join_as': self.groupcall_default_join_as.to_dict() if isinstance(self.groupcall_default_join_as, TLObject) else self.groupcall_default_join_as,
            'theme_emoticon': self.theme_emoticon,
            'requests_pending': self.requests_pending,
            'recent_requesters': [] if self.recent_requesters is None else self.recent_requesters[:],
            'available_reactions': self.available_reactions.to_dict() if isinstance(self.available_reactions, TLObject) else self.available_reactions
        }

    def _bytes(self):
        assert ((self.requests_pending or self.requests_pending is not None) and (self.recent_requesters or self.recent_requesters is not None)) or ((self.requests_pending is None or self.requests_pending is False) and (self.recent_requesters is None or self.recent_requesters is False)), 'requests_pending, recent_requesters parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'8\x11\xd3\xc9',
            struct.pack('<I', (0 if self.can_set_username is None or self.can_set_username is False else 128) | (0 if self.has_scheduled is None or self.has_scheduled is False else 256) | (0 if self.translations_disabled is None or self.translations_disabled is False else 524288) | (0 if self.chat_photo is None or self.chat_photo is False else 4) | (0 if self.exported_invite is None or self.exported_invite is False else 8192) | (0 if self.bot_info is None or self.bot_info is False else 8) | (0 if self.pinned_msg_id is None or self.pinned_msg_id is False else 64) | (0 if self.folder_id is None or self.folder_id is False else 2048) | (0 if self.call is None or self.call is False else 4096) | (0 if self.ttl_period is None or self.ttl_period is False else 16384) | (0 if self.groupcall_default_join_as is None or self.groupcall_default_join_as is False else 32768) | (0 if self.theme_emoticon is None or self.theme_emoticon is False else 65536) | (0 if self.requests_pending is None or self.requests_pending is False else 131072) | (0 if self.recent_requesters is None or self.recent_requesters is False else 131072) | (0 if self.available_reactions is None or self.available_reactions is False else 262144)),
            struct.pack('<q', self.id),
            self.serialize_bytes(self.about),
            self.participants._bytes(),
            b'' if self.chat_photo is None or self.chat_photo is False else (self.chat_photo._bytes()),
            self.notify_settings._bytes(),
            b'' if self.exported_invite is None or self.exported_invite is False else (self.exported_invite._bytes()),
            b'' if self.bot_info is None or self.bot_info is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.bot_info)),b''.join(x._bytes() for x in self.bot_info))),
            b'' if self.pinned_msg_id is None or self.pinned_msg_id is False else (struct.pack('<i', self.pinned_msg_id)),
            b'' if self.folder_id is None or self.folder_id is False else (struct.pack('<i', self.folder_id)),
            b'' if self.call is None or self.call is False else (self.call._bytes()),
            b'' if self.ttl_period is None or self.ttl_period is False else (struct.pack('<i', self.ttl_period)),
            b'' if self.groupcall_default_join_as is None or self.groupcall_default_join_as is False else (self.groupcall_default_join_as._bytes()),
            b'' if self.theme_emoticon is None or self.theme_emoticon is False else (self.serialize_bytes(self.theme_emoticon)),
            b'' if self.requests_pending is None or self.requests_pending is False else (struct.pack('<i', self.requests_pending)),
            b'' if self.recent_requesters is None or self.recent_requesters is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.recent_requesters)),b''.join(struct.pack('<q', x) for x in self.recent_requesters))),
            b'' if self.available_reactions is None or self.available_reactions is False else (self.available_reactions._bytes()),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _can_set_username = bool(flags & 128)
        _has_scheduled = bool(flags & 256)
        _translations_disabled = bool(flags & 524288)
        _id = reader.read_long()
        _about = reader.tgread_string()
        _participants = reader.tgread_object()
        if flags & 4:
            _chat_photo = reader.tgread_object()
        else:
            _chat_photo = None
        _notify_settings = reader.tgread_object()
        if flags & 8192:
            _exported_invite = reader.tgread_object()
        else:
            _exported_invite = None
        if flags & 8:
            reader.read_int()
            _bot_info = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _bot_info.append(_x)

        else:
            _bot_info = None
        if flags & 64:
            _pinned_msg_id = reader.read_int()
        else:
            _pinned_msg_id = None
        if flags & 2048:
            _folder_id = reader.read_int()
        else:
            _folder_id = None
        if flags & 4096:
            _call = reader.tgread_object()
        else:
            _call = None
        if flags & 16384:
            _ttl_period = reader.read_int()
        else:
            _ttl_period = None
        if flags & 32768:
            _groupcall_default_join_as = reader.tgread_object()
        else:
            _groupcall_default_join_as = None
        if flags & 65536:
            _theme_emoticon = reader.tgread_string()
        else:
            _theme_emoticon = None
        if flags & 131072:
            _requests_pending = reader.read_int()
        else:
            _requests_pending = None
        if flags & 131072:
            reader.read_int()
            _recent_requesters = []
            for _ in range(reader.read_int()):
                _x = reader.read_long()
                _recent_requesters.append(_x)

        else:
            _recent_requesters = None
        if flags & 262144:
            _available_reactions = reader.tgread_object()
        else:
            _available_reactions = None
        return cls(id=_id, about=_about, participants=_participants, notify_settings=_notify_settings, can_set_username=_can_set_username, has_scheduled=_has_scheduled, translations_disabled=_translations_disabled, chat_photo=_chat_photo, exported_invite=_exported_invite, bot_info=_bot_info, pinned_msg_id=_pinned_msg_id, folder_id=_folder_id, call=_call, ttl_period=_ttl_period, groupcall_default_join_as=_groupcall_default_join_as, theme_emoticon=_theme_emoticon, requests_pending=_requests_pending, recent_requesters=_recent_requesters, available_reactions=_available_reactions)


class ChatInvite(TLObject):
    CONSTRUCTOR_ID = 0xcde0ec40
    SUBCLASS_OF_ID = 0x4561736

    def __init__(self, title: str, photo: 'TypePhoto', participants_count: int, color: int, channel: Optional[bool]=None, broadcast: Optional[bool]=None, public: Optional[bool]=None, megagroup: Optional[bool]=None, request_needed: Optional[bool]=None, verified: Optional[bool]=None, scam: Optional[bool]=None, fake: Optional[bool]=None, about: Optional[str]=None, participants: Optional[List['TypeUser']]=None):
        """
        Constructor for ChatInvite: Instance of either ChatInviteAlready, ChatInvite, ChatInvitePeek.
        """
        self.title = title
        self.photo = photo
        self.participants_count = participants_count
        self.color = color
        self.channel = channel
        self.broadcast = broadcast
        self.public = public
        self.megagroup = megagroup
        self.request_needed = request_needed
        self.verified = verified
        self.scam = scam
        self.fake = fake
        self.about = about
        self.participants = participants

    def to_dict(self):
        return {
            '_': 'ChatInvite',
            'title': self.title,
            'photo': self.photo.to_dict() if isinstance(self.photo, TLObject) else self.photo,
            'participants_count': self.participants_count,
            'color': self.color,
            'channel': self.channel,
            'broadcast': self.broadcast,
            'public': self.public,
            'megagroup': self.megagroup,
            'request_needed': self.request_needed,
            'verified': self.verified,
            'scam': self.scam,
            'fake': self.fake,
            'about': self.about,
            'participants': [] if self.participants is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.participants]
        }

    def _bytes(self):
        return b''.join((
            b'@\xec\xe0\xcd',
            struct.pack('<I', (0 if self.channel is None or self.channel is False else 1) | (0 if self.broadcast is None or self.broadcast is False else 2) | (0 if self.public is None or self.public is False else 4) | (0 if self.megagroup is None or self.megagroup is False else 8) | (0 if self.request_needed is None or self.request_needed is False else 64) | (0 if self.verified is None or self.verified is False else 128) | (0 if self.scam is None or self.scam is False else 256) | (0 if self.fake is None or self.fake is False else 512) | (0 if self.about is None or self.about is False else 32) | (0 if self.participants is None or self.participants is False else 16)),
            self.serialize_bytes(self.title),
            b'' if self.about is None or self.about is False else (self.serialize_bytes(self.about)),
            self.photo._bytes(),
            struct.pack('<i', self.participants_count),
            b'' if self.participants is None or self.participants is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.participants)),b''.join(x._bytes() for x in self.participants))),
            struct.pack('<i', self.color),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _channel = bool(flags & 1)
        _broadcast = bool(flags & 2)
        _public = bool(flags & 4)
        _megagroup = bool(flags & 8)
        _request_needed = bool(flags & 64)
        _verified = bool(flags & 128)
        _scam = bool(flags & 256)
        _fake = bool(flags & 512)
        _title = reader.tgread_string()
        if flags & 32:
            _about = reader.tgread_string()
        else:
            _about = None
        _photo = reader.tgread_object()
        _participants_count = reader.read_int()
        if flags & 16:
            reader.read_int()
            _participants = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _participants.append(_x)

        else:
            _participants = None
        _color = reader.read_int()
        return cls(title=_title, photo=_photo, participants_count=_participants_count, color=_color, channel=_channel, broadcast=_broadcast, public=_public, megagroup=_megagroup, request_needed=_request_needed, verified=_verified, scam=_scam, fake=_fake, about=_about, participants=_participants)


class ChatInviteAlready(TLObject):
    CONSTRUCTOR_ID = 0x5a686d7c
    SUBCLASS_OF_ID = 0x4561736

    def __init__(self, chat: 'TypeChat'):
        """
        Constructor for ChatInvite: Instance of either ChatInviteAlready, ChatInvite, ChatInvitePeek.
        """
        self.chat = chat

    def to_dict(self):
        return {
            '_': 'ChatInviteAlready',
            'chat': self.chat.to_dict() if isinstance(self.chat, TLObject) else self.chat
        }

    def _bytes(self):
        return b''.join((
            b'|mhZ',
            self.chat._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _chat = reader.tgread_object()
        return cls(chat=_chat)


class ChatInviteExported(TLObject):
    CONSTRUCTOR_ID = 0xab4a819
    SUBCLASS_OF_ID = 0xb4748a58

    def __init__(self, link: str, admin_id: int, date: Optional[datetime], revoked: Optional[bool]=None, permanent: Optional[bool]=None, request_needed: Optional[bool]=None, start_date: Optional[datetime]=None, expire_date: Optional[datetime]=None, usage_limit: Optional[int]=None, usage: Optional[int]=None, requested: Optional[int]=None, title: Optional[str]=None):
        """
        Constructor for ExportedChatInvite: Instance of either ChatInviteExported, ChatInvitePublicJoinRequests.
        """
        self.link = link
        self.admin_id = admin_id
        self.date = date
        self.revoked = revoked
        self.permanent = permanent
        self.request_needed = request_needed
        self.start_date = start_date
        self.expire_date = expire_date
        self.usage_limit = usage_limit
        self.usage = usage
        self.requested = requested
        self.title = title

    def to_dict(self):
        return {
            '_': 'ChatInviteExported',
            'link': self.link,
            'admin_id': self.admin_id,
            'date': self.date,
            'revoked': self.revoked,
            'permanent': self.permanent,
            'request_needed': self.request_needed,
            'start_date': self.start_date,
            'expire_date': self.expire_date,
            'usage_limit': self.usage_limit,
            'usage': self.usage,
            'requested': self.requested,
            'title': self.title
        }

    def _bytes(self):
        return b''.join((
            b'\x19\xa8\xb4\n',
            struct.pack('<I', (0 if self.revoked is None or self.revoked is False else 1) | (0 if self.permanent is None or self.permanent is False else 32) | (0 if self.request_needed is None or self.request_needed is False else 64) | (0 if self.start_date is None or self.start_date is False else 16) | (0 if self.expire_date is None or self.expire_date is False else 2) | (0 if self.usage_limit is None or self.usage_limit is False else 4) | (0 if self.usage is None or self.usage is False else 8) | (0 if self.requested is None or self.requested is False else 128) | (0 if self.title is None or self.title is False else 256)),
            self.serialize_bytes(self.link),
            struct.pack('<q', self.admin_id),
            self.serialize_datetime(self.date),
            b'' if self.start_date is None or self.start_date is False else (self.serialize_datetime(self.start_date)),
            b'' if self.expire_date is None or self.expire_date is False else (self.serialize_datetime(self.expire_date)),
            b'' if self.usage_limit is None or self.usage_limit is False else (struct.pack('<i', self.usage_limit)),
            b'' if self.usage is None or self.usage is False else (struct.pack('<i', self.usage)),
            b'' if self.requested is None or self.requested is False else (struct.pack('<i', self.requested)),
            b'' if self.title is None or self.title is False else (self.serialize_bytes(self.title)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _revoked = bool(flags & 1)
        _permanent = bool(flags & 32)
        _request_needed = bool(flags & 64)
        _link = reader.tgread_string()
        _admin_id = reader.read_long()
        _date = reader.tgread_date()
        if flags & 16:
            _start_date = reader.tgread_date()
        else:
            _start_date = None
        if flags & 2:
            _expire_date = reader.tgread_date()
        else:
            _expire_date = None
        if flags & 4:
            _usage_limit = reader.read_int()
        else:
            _usage_limit = None
        if flags & 8:
            _usage = reader.read_int()
        else:
            _usage = None
        if flags & 128:
            _requested = reader.read_int()
        else:
            _requested = None
        if flags & 256:
            _title = reader.tgread_string()
        else:
            _title = None
        return cls(link=_link, admin_id=_admin_id, date=_date, revoked=_revoked, permanent=_permanent, request_needed=_request_needed, start_date=_start_date, expire_date=_expire_date, usage_limit=_usage_limit, usage=_usage, requested=_requested, title=_title)


class ChatInviteImporter(TLObject):
    CONSTRUCTOR_ID = 0x8c5adfd9
    SUBCLASS_OF_ID = 0x5312542e

    def __init__(self, user_id: int, date: Optional[datetime], requested: Optional[bool]=None, via_chatlist: Optional[bool]=None, about: Optional[str]=None, approved_by: Optional[int]=None):
        """
        Constructor for ChatInviteImporter: Instance of ChatInviteImporter.
        """
        self.user_id = user_id
        self.date = date
        self.requested = requested
        self.via_chatlist = via_chatlist
        self.about = about
        self.approved_by = approved_by

    def to_dict(self):
        return {
            '_': 'ChatInviteImporter',
            'user_id': self.user_id,
            'date': self.date,
            'requested': self.requested,
            'via_chatlist': self.via_chatlist,
            'about': self.about,
            'approved_by': self.approved_by
        }

    def _bytes(self):
        return b''.join((
            b'\xd9\xdfZ\x8c',
            struct.pack('<I', (0 if self.requested is None or self.requested is False else 1) | (0 if self.via_chatlist is None or self.via_chatlist is False else 8) | (0 if self.about is None or self.about is False else 4) | (0 if self.approved_by is None or self.approved_by is False else 2)),
            struct.pack('<q', self.user_id),
            self.serialize_datetime(self.date),
            b'' if self.about is None or self.about is False else (self.serialize_bytes(self.about)),
            b'' if self.approved_by is None or self.approved_by is False else (struct.pack('<q', self.approved_by)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _requested = bool(flags & 1)
        _via_chatlist = bool(flags & 8)
        _user_id = reader.read_long()
        _date = reader.tgread_date()
        if flags & 4:
            _about = reader.tgread_string()
        else:
            _about = None
        if flags & 2:
            _approved_by = reader.read_long()
        else:
            _approved_by = None
        return cls(user_id=_user_id, date=_date, requested=_requested, via_chatlist=_via_chatlist, about=_about, approved_by=_approved_by)


class ChatInvitePeek(TLObject):
    CONSTRUCTOR_ID = 0x61695cb0
    SUBCLASS_OF_ID = 0x4561736

    def __init__(self, chat: 'TypeChat', expires: Optional[datetime]):
        """
        Constructor for ChatInvite: Instance of either ChatInviteAlready, ChatInvite, ChatInvitePeek.
        """
        self.chat = chat
        self.expires = expires

    def to_dict(self):
        return {
            '_': 'ChatInvitePeek',
            'chat': self.chat.to_dict() if isinstance(self.chat, TLObject) else self.chat,
            'expires': self.expires
        }

    def _bytes(self):
        return b''.join((
            b'\xb0\\ia',
            self.chat._bytes(),
            self.serialize_datetime(self.expires),
        ))

    @classmethod
    def from_reader(cls, reader):
        _chat = reader.tgread_object()
        _expires = reader.tgread_date()
        return cls(chat=_chat, expires=_expires)


class ChatInvitePublicJoinRequests(TLObject):
    CONSTRUCTOR_ID = 0xed107ab7
    SUBCLASS_OF_ID = 0xb4748a58

    def to_dict(self):
        return {
            '_': 'ChatInvitePublicJoinRequests'
        }

    def _bytes(self):
        return b''.join((
            b'\xb7z\x10\xed',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class ChatOnlines(TLObject):
    CONSTRUCTOR_ID = 0xf041e250
    SUBCLASS_OF_ID = 0x8c81903a

    def __init__(self, onlines: int):
        """
        Constructor for ChatOnlines: Instance of ChatOnlines.
        """
        self.onlines = onlines

    def to_dict(self):
        return {
            '_': 'ChatOnlines',
            'onlines': self.onlines
        }

    def _bytes(self):
        return b''.join((
            b'P\xe2A\xf0',
            struct.pack('<i', self.onlines),
        ))

    @classmethod
    def from_reader(cls, reader):
        _onlines = reader.read_int()
        return cls(onlines=_onlines)


class ChatParticipant(TLObject):
    CONSTRUCTOR_ID = 0xc02d4007
    SUBCLASS_OF_ID = 0x7d7c6f86

    def __init__(self, user_id: int, inviter_id: int, date: Optional[datetime]):
        """
        Constructor for ChatParticipant: Instance of either ChatParticipant, ChatParticipantCreator, ChatParticipantAdmin.
        """
        self.user_id = user_id
        self.inviter_id = inviter_id
        self.date = date

    def to_dict(self):
        return {
            '_': 'ChatParticipant',
            'user_id': self.user_id,
            'inviter_id': self.inviter_id,
            'date': self.date
        }

    def _bytes(self):
        return b''.join((
            b'\x07@-\xc0',
            struct.pack('<q', self.user_id),
            struct.pack('<q', self.inviter_id),
            self.serialize_datetime(self.date),
        ))

    @classmethod
    def from_reader(cls, reader):
        _user_id = reader.read_long()
        _inviter_id = reader.read_long()
        _date = reader.tgread_date()
        return cls(user_id=_user_id, inviter_id=_inviter_id, date=_date)


class ChatParticipantAdmin(TLObject):
    CONSTRUCTOR_ID = 0xa0933f5b
    SUBCLASS_OF_ID = 0x7d7c6f86

    def __init__(self, user_id: int, inviter_id: int, date: Optional[datetime]):
        """
        Constructor for ChatParticipant: Instance of either ChatParticipant, ChatParticipantCreator, ChatParticipantAdmin.
        """
        self.user_id = user_id
        self.inviter_id = inviter_id
        self.date = date

    def to_dict(self):
        return {
            '_': 'ChatParticipantAdmin',
            'user_id': self.user_id,
            'inviter_id': self.inviter_id,
            'date': self.date
        }

    def _bytes(self):
        return b''.join((
            b'[?\x93\xa0',
            struct.pack('<q', self.user_id),
            struct.pack('<q', self.inviter_id),
            self.serialize_datetime(self.date),
        ))

    @classmethod
    def from_reader(cls, reader):
        _user_id = reader.read_long()
        _inviter_id = reader.read_long()
        _date = reader.tgread_date()
        return cls(user_id=_user_id, inviter_id=_inviter_id, date=_date)


class ChatParticipantCreator(TLObject):
    CONSTRUCTOR_ID = 0xe46bcee4
    SUBCLASS_OF_ID = 0x7d7c6f86

    def __init__(self, user_id: int):
        """
        Constructor for ChatParticipant: Instance of either ChatParticipant, ChatParticipantCreator, ChatParticipantAdmin.
        """
        self.user_id = user_id

    def to_dict(self):
        return {
            '_': 'ChatParticipantCreator',
            'user_id': self.user_id
        }

    def _bytes(self):
        return b''.join((
            b'\xe4\xcek\xe4',
            struct.pack('<q', self.user_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _user_id = reader.read_long()
        return cls(user_id=_user_id)


class ChatParticipants(TLObject):
    CONSTRUCTOR_ID = 0x3cbc93f8
    SUBCLASS_OF_ID = 0x1fa89571

    def __init__(self, chat_id: int, participants: List['TypeChatParticipant'], version: int):
        """
        Constructor for ChatParticipants: Instance of either ChatParticipantsForbidden, ChatParticipants.
        """
        self.chat_id = chat_id
        self.participants = participants
        self.version = version

    def to_dict(self):
        return {
            '_': 'ChatParticipants',
            'chat_id': self.chat_id,
            'participants': [] if self.participants is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.participants],
            'version': self.version
        }

    def _bytes(self):
        return b''.join((
            b'\xf8\x93\xbc<',
            struct.pack('<q', self.chat_id),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.participants)),b''.join(x._bytes() for x in self.participants),
            struct.pack('<i', self.version),
        ))

    @classmethod
    def from_reader(cls, reader):
        _chat_id = reader.read_long()
        reader.read_int()
        _participants = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _participants.append(_x)

        _version = reader.read_int()
        return cls(chat_id=_chat_id, participants=_participants, version=_version)


class ChatParticipantsForbidden(TLObject):
    CONSTRUCTOR_ID = 0x8763d3e1
    SUBCLASS_OF_ID = 0x1fa89571

    def __init__(self, chat_id: int, self_participant: Optional['TypeChatParticipant']=None):
        """
        Constructor for ChatParticipants: Instance of either ChatParticipantsForbidden, ChatParticipants.
        """
        self.chat_id = chat_id
        self.self_participant = self_participant

    def to_dict(self):
        return {
            '_': 'ChatParticipantsForbidden',
            'chat_id': self.chat_id,
            'self_participant': self.self_participant.to_dict() if isinstance(self.self_participant, TLObject) else self.self_participant
        }

    def _bytes(self):
        return b''.join((
            b'\xe1\xd3c\x87',
            struct.pack('<I', (0 if self.self_participant is None or self.self_participant is False else 1)),
            struct.pack('<q', self.chat_id),
            b'' if self.self_participant is None or self.self_participant is False else (self.self_participant._bytes()),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _chat_id = reader.read_long()
        if flags & 1:
            _self_participant = reader.tgread_object()
        else:
            _self_participant = None
        return cls(chat_id=_chat_id, self_participant=_self_participant)


class ChatPhoto(TLObject):
    CONSTRUCTOR_ID = 0x1c6e1c11
    SUBCLASS_OF_ID = 0xac3ec4e5

    def __init__(self, photo_id: int, dc_id: int, has_video: Optional[bool]=None, stripped_thumb: Optional[bytes]=None):
        """
        Constructor for ChatPhoto: Instance of either ChatPhotoEmpty, ChatPhoto.
        """
        self.photo_id = photo_id
        self.dc_id = dc_id
        self.has_video = has_video
        self.stripped_thumb = stripped_thumb

    def to_dict(self):
        return {
            '_': 'ChatPhoto',
            'photo_id': self.photo_id,
            'dc_id': self.dc_id,
            'has_video': self.has_video,
            'stripped_thumb': self.stripped_thumb
        }

    def _bytes(self):
        return b''.join((
            b'\x11\x1cn\x1c',
            struct.pack('<I', (0 if self.has_video is None or self.has_video is False else 1) | (0 if self.stripped_thumb is None or self.stripped_thumb is False else 2)),
            struct.pack('<q', self.photo_id),
            b'' if self.stripped_thumb is None or self.stripped_thumb is False else (self.serialize_bytes(self.stripped_thumb)),
            struct.pack('<i', self.dc_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _has_video = bool(flags & 1)
        _photo_id = reader.read_long()
        if flags & 2:
            _stripped_thumb = reader.tgread_bytes()
        else:
            _stripped_thumb = None
        _dc_id = reader.read_int()
        return cls(photo_id=_photo_id, dc_id=_dc_id, has_video=_has_video, stripped_thumb=_stripped_thumb)


class ChatPhotoEmpty(TLObject):
    CONSTRUCTOR_ID = 0x37c1011c
    SUBCLASS_OF_ID = 0xac3ec4e5

    def to_dict(self):
        return {
            '_': 'ChatPhotoEmpty'
        }

    def _bytes(self):
        return b''.join((
            b'\x1c\x01\xc17',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class ChatReactionsAll(TLObject):
    CONSTRUCTOR_ID = 0x52928bca
    SUBCLASS_OF_ID = 0x131e24b5

    def __init__(self, allow_custom: Optional[bool]=None):
        """
        Constructor for ChatReactions: Instance of either ChatReactionsNone, ChatReactionsAll, ChatReactionsSome.
        """
        self.allow_custom = allow_custom

    def to_dict(self):
        return {
            '_': 'ChatReactionsAll',
            'allow_custom': self.allow_custom
        }

    def _bytes(self):
        return b''.join((
            b'\xca\x8b\x92R',
            struct.pack('<I', (0 if self.allow_custom is None or self.allow_custom is False else 1)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _allow_custom = bool(flags & 1)
        return cls(allow_custom=_allow_custom)


class ChatReactionsNone(TLObject):
    CONSTRUCTOR_ID = 0xeafc32bc
    SUBCLASS_OF_ID = 0x131e24b5

    def to_dict(self):
        return {
            '_': 'ChatReactionsNone'
        }

    def _bytes(self):
        return b''.join((
            b'\xbc2\xfc\xea',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class ChatReactionsSome(TLObject):
    CONSTRUCTOR_ID = 0x661d4037
    SUBCLASS_OF_ID = 0x131e24b5

    def __init__(self, reactions: List['TypeReaction']):
        """
        Constructor for ChatReactions: Instance of either ChatReactionsNone, ChatReactionsAll, ChatReactionsSome.
        """
        self.reactions = reactions

    def to_dict(self):
        return {
            '_': 'ChatReactionsSome',
            'reactions': [] if self.reactions is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.reactions]
        }

    def _bytes(self):
        return b''.join((
            b'7@\x1df',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.reactions)),b''.join(x._bytes() for x in self.reactions),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _reactions = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _reactions.append(_x)

        return cls(reactions=_reactions)


class ClientDHInnerData(TLObject):
    CONSTRUCTOR_ID = 0x6643b654
    SUBCLASS_OF_ID = 0xf8eeef6a

    def __init__(self, nonce: int, server_nonce: int, retry_id: int, g_b: bytes):
        """
        Constructor for Client_DH_Inner_Data: Instance of ClientDHInnerData.
        """
        self.nonce = nonce
        self.server_nonce = server_nonce
        self.retry_id = retry_id
        self.g_b = g_b

    def to_dict(self):
        return {
            '_': 'ClientDHInnerData',
            'nonce': self.nonce,
            'server_nonce': self.server_nonce,
            'retry_id': self.retry_id,
            'g_b': self.g_b
        }

    def _bytes(self):
        return b''.join((
            b'T\xb6Cf',
            self.nonce.to_bytes(16, 'little', signed=True),
            self.server_nonce.to_bytes(16, 'little', signed=True),
            struct.pack('<q', self.retry_id),
            self.serialize_bytes(self.g_b),
        ))

    @classmethod
    def from_reader(cls, reader):
        _nonce = reader.read_large_int(bits=128)
        _server_nonce = reader.read_large_int(bits=128)
        _retry_id = reader.read_long()
        _g_b = reader.tgread_bytes()
        return cls(nonce=_nonce, server_nonce=_server_nonce, retry_id=_retry_id, g_b=_g_b)


class CodeSettings(TLObject):
    CONSTRUCTOR_ID = 0xad253d78
    SUBCLASS_OF_ID = 0x48edbc8a

    def __init__(self, allow_flashcall: Optional[bool]=None, current_number: Optional[bool]=None, allow_app_hash: Optional[bool]=None, allow_missed_call: Optional[bool]=None, allow_firebase: Optional[bool]=None, logout_tokens: Optional[List[bytes]]=None, token: Optional[str]=None, app_sandbox: Optional[bool]=None):
        """
        Constructor for CodeSettings: Instance of CodeSettings.
        """
        self.allow_flashcall = allow_flashcall
        self.current_number = current_number
        self.allow_app_hash = allow_app_hash
        self.allow_missed_call = allow_missed_call
        self.allow_firebase = allow_firebase
        self.logout_tokens = logout_tokens
        self.token = token
        self.app_sandbox = app_sandbox

    def to_dict(self):
        return {
            '_': 'CodeSettings',
            'allow_flashcall': self.allow_flashcall,
            'current_number': self.current_number,
            'allow_app_hash': self.allow_app_hash,
            'allow_missed_call': self.allow_missed_call,
            'allow_firebase': self.allow_firebase,
            'logout_tokens': [] if self.logout_tokens is None else self.logout_tokens[:],
            'token': self.token,
            'app_sandbox': self.app_sandbox
        }

    def _bytes(self):
        assert ((self.token or self.token is not None) and (self.app_sandbox or self.app_sandbox is not None)) or ((self.token is None or self.token is False) and (self.app_sandbox is None or self.app_sandbox is False)), 'token, app_sandbox parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'x=%\xad',
            struct.pack('<I', (0 if self.allow_flashcall is None or self.allow_flashcall is False else 1) | (0 if self.current_number is None or self.current_number is False else 2) | (0 if self.allow_app_hash is None or self.allow_app_hash is False else 16) | (0 if self.allow_missed_call is None or self.allow_missed_call is False else 32) | (0 if self.allow_firebase is None or self.allow_firebase is False else 128) | (0 if self.logout_tokens is None or self.logout_tokens is False else 64) | (0 if self.token is None or self.token is False else 256) | (0 if self.app_sandbox is None else 256)),
            b'' if self.logout_tokens is None or self.logout_tokens is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.logout_tokens)),b''.join(self.serialize_bytes(x) for x in self.logout_tokens))),
            b'' if self.token is None or self.token is False else (self.serialize_bytes(self.token)),
            b'' if self.app_sandbox is None else (b'\xb5ur\x99' if self.app_sandbox else b'7\x97y\xbc'),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _allow_flashcall = bool(flags & 1)
        _current_number = bool(flags & 2)
        _allow_app_hash = bool(flags & 16)
        _allow_missed_call = bool(flags & 32)
        _allow_firebase = bool(flags & 128)
        if flags & 64:
            reader.read_int()
            _logout_tokens = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_bytes()
                _logout_tokens.append(_x)

        else:
            _logout_tokens = None
        if flags & 256:
            _token = reader.tgread_string()
        else:
            _token = None
        if flags & 256:
            _app_sandbox = reader.tgread_bool()
        else:
            _app_sandbox = None
        return cls(allow_flashcall=_allow_flashcall, current_number=_current_number, allow_app_hash=_allow_app_hash, allow_missed_call=_allow_missed_call, allow_firebase=_allow_firebase, logout_tokens=_logout_tokens, token=_token, app_sandbox=_app_sandbox)


class Config(TLObject):
    CONSTRUCTOR_ID = 0xcc1a241e
    SUBCLASS_OF_ID = 0xd3262a4a

    def __init__(self, date: Optional[datetime], expires: Optional[datetime], test_mode: bool, this_dc: int, dc_options: List['TypeDcOption'], dc_txt_domain_name: str, chat_size_max: int, megagroup_size_max: int, forwarded_count_max: int, online_update_period_ms: int, offline_blur_timeout_ms: int, offline_idle_timeout_ms: int, online_cloud_timeout_ms: int, notify_cloud_delay_ms: int, notify_default_delay_ms: int, push_chat_period_ms: int, push_chat_limit: int, edit_time_limit: int, revoke_time_limit: int, revoke_pm_time_limit: int, rating_e_decay: int, stickers_recent_limit: int, channels_read_media_period: int, call_receive_timeout_ms: int, call_ring_timeout_ms: int, call_connect_timeout_ms: int, call_packet_timeout_ms: int, me_url_prefix: str, caption_length_max: int, message_length_max: int, webfile_dc_id: int, default_p2p_contacts: Optional[bool]=None, preload_featured_stickers: Optional[bool]=None, revoke_pm_inbox: Optional[bool]=None, blocked_mode: Optional[bool]=None, force_try_ipv6: Optional[bool]=None, tmp_sessions: Optional[int]=None, autoupdate_url_prefix: Optional[str]=None, gif_search_username: Optional[str]=None, venue_search_username: Optional[str]=None, img_search_username: Optional[str]=None, static_maps_provider: Optional[str]=None, suggested_lang_code: Optional[str]=None, lang_pack_version: Optional[int]=None, base_lang_pack_version: Optional[int]=None, reactions_default: Optional['TypeReaction']=None, autologin_token: Optional[str]=None):
        """
        Constructor for Config: Instance of Config.
        """
        self.date = date
        self.expires = expires
        self.test_mode = test_mode
        self.this_dc = this_dc
        self.dc_options = dc_options
        self.dc_txt_domain_name = dc_txt_domain_name
        self.chat_size_max = chat_size_max
        self.megagroup_size_max = megagroup_size_max
        self.forwarded_count_max = forwarded_count_max
        self.online_update_period_ms = online_update_period_ms
        self.offline_blur_timeout_ms = offline_blur_timeout_ms
        self.offline_idle_timeout_ms = offline_idle_timeout_ms
        self.online_cloud_timeout_ms = online_cloud_timeout_ms
        self.notify_cloud_delay_ms = notify_cloud_delay_ms
        self.notify_default_delay_ms = notify_default_delay_ms
        self.push_chat_period_ms = push_chat_period_ms
        self.push_chat_limit = push_chat_limit
        self.edit_time_limit = edit_time_limit
        self.revoke_time_limit = revoke_time_limit
        self.revoke_pm_time_limit = revoke_pm_time_limit
        self.rating_e_decay = rating_e_decay
        self.stickers_recent_limit = stickers_recent_limit
        self.channels_read_media_period = channels_read_media_period
        self.call_receive_timeout_ms = call_receive_timeout_ms
        self.call_ring_timeout_ms = call_ring_timeout_ms
        self.call_connect_timeout_ms = call_connect_timeout_ms
        self.call_packet_timeout_ms = call_packet_timeout_ms
        self.me_url_prefix = me_url_prefix
        self.caption_length_max = caption_length_max
        self.message_length_max = message_length_max
        self.webfile_dc_id = webfile_dc_id
        self.default_p2p_contacts = default_p2p_contacts
        self.preload_featured_stickers = preload_featured_stickers
        self.revoke_pm_inbox = revoke_pm_inbox
        self.blocked_mode = blocked_mode
        self.force_try_ipv6 = force_try_ipv6
        self.tmp_sessions = tmp_sessions
        self.autoupdate_url_prefix = autoupdate_url_prefix
        self.gif_search_username = gif_search_username
        self.venue_search_username = venue_search_username
        self.img_search_username = img_search_username
        self.static_maps_provider = static_maps_provider
        self.suggested_lang_code = suggested_lang_code
        self.lang_pack_version = lang_pack_version
        self.base_lang_pack_version = base_lang_pack_version
        self.reactions_default = reactions_default
        self.autologin_token = autologin_token

    def to_dict(self):
        return {
            '_': 'Config',
            'date': self.date,
            'expires': self.expires,
            'test_mode': self.test_mode,
            'this_dc': self.this_dc,
            'dc_options': [] if self.dc_options is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.dc_options],
            'dc_txt_domain_name': self.dc_txt_domain_name,
            'chat_size_max': self.chat_size_max,
            'megagroup_size_max': self.megagroup_size_max,
            'forwarded_count_max': self.forwarded_count_max,
            'online_update_period_ms': self.online_update_period_ms,
            'offline_blur_timeout_ms': self.offline_blur_timeout_ms,
            'offline_idle_timeout_ms': self.offline_idle_timeout_ms,
            'online_cloud_timeout_ms': self.online_cloud_timeout_ms,
            'notify_cloud_delay_ms': self.notify_cloud_delay_ms,
            'notify_default_delay_ms': self.notify_default_delay_ms,
            'push_chat_period_ms': self.push_chat_period_ms,
            'push_chat_limit': self.push_chat_limit,
            'edit_time_limit': self.edit_time_limit,
            'revoke_time_limit': self.revoke_time_limit,
            'revoke_pm_time_limit': self.revoke_pm_time_limit,
            'rating_e_decay': self.rating_e_decay,
            'stickers_recent_limit': self.stickers_recent_limit,
            'channels_read_media_period': self.channels_read_media_period,
            'call_receive_timeout_ms': self.call_receive_timeout_ms,
            'call_ring_timeout_ms': self.call_ring_timeout_ms,
            'call_connect_timeout_ms': self.call_connect_timeout_ms,
            'call_packet_timeout_ms': self.call_packet_timeout_ms,
            'me_url_prefix': self.me_url_prefix,
            'caption_length_max': self.caption_length_max,
            'message_length_max': self.message_length_max,
            'webfile_dc_id': self.webfile_dc_id,
            'default_p2p_contacts': self.default_p2p_contacts,
            'preload_featured_stickers': self.preload_featured_stickers,
            'revoke_pm_inbox': self.revoke_pm_inbox,
            'blocked_mode': self.blocked_mode,
            'force_try_ipv6': self.force_try_ipv6,
            'tmp_sessions': self.tmp_sessions,
            'autoupdate_url_prefix': self.autoupdate_url_prefix,
            'gif_search_username': self.gif_search_username,
            'venue_search_username': self.venue_search_username,
            'img_search_username': self.img_search_username,
            'static_maps_provider': self.static_maps_provider,
            'suggested_lang_code': self.suggested_lang_code,
            'lang_pack_version': self.lang_pack_version,
            'base_lang_pack_version': self.base_lang_pack_version,
            'reactions_default': self.reactions_default.to_dict() if isinstance(self.reactions_default, TLObject) else self.reactions_default,
            'autologin_token': self.autologin_token
        }

    def _bytes(self):
        assert ((self.suggested_lang_code or self.suggested_lang_code is not None) and (self.lang_pack_version or self.lang_pack_version is not None) and (self.base_lang_pack_version or self.base_lang_pack_version is not None)) or ((self.suggested_lang_code is None or self.suggested_lang_code is False) and (self.lang_pack_version is None or self.lang_pack_version is False) and (self.base_lang_pack_version is None or self.base_lang_pack_version is False)), 'suggested_lang_code, lang_pack_version, base_lang_pack_version parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'\x1e$\x1a\xcc',
            struct.pack('<I', (0 if self.default_p2p_contacts is None or self.default_p2p_contacts is False else 8) | (0 if self.preload_featured_stickers is None or self.preload_featured_stickers is False else 16) | (0 if self.revoke_pm_inbox is None or self.revoke_pm_inbox is False else 64) | (0 if self.blocked_mode is None or self.blocked_mode is False else 256) | (0 if self.force_try_ipv6 is None or self.force_try_ipv6 is False else 16384) | (0 if self.tmp_sessions is None or self.tmp_sessions is False else 1) | (0 if self.autoupdate_url_prefix is None or self.autoupdate_url_prefix is False else 128) | (0 if self.gif_search_username is None or self.gif_search_username is False else 512) | (0 if self.venue_search_username is None or self.venue_search_username is False else 1024) | (0 if self.img_search_username is None or self.img_search_username is False else 2048) | (0 if self.static_maps_provider is None or self.static_maps_provider is False else 4096) | (0 if self.suggested_lang_code is None or self.suggested_lang_code is False else 4) | (0 if self.lang_pack_version is None or self.lang_pack_version is False else 4) | (0 if self.base_lang_pack_version is None or self.base_lang_pack_version is False else 4) | (0 if self.reactions_default is None or self.reactions_default is False else 32768) | (0 if self.autologin_token is None or self.autologin_token is False else 65536)),
            self.serialize_datetime(self.date),
            self.serialize_datetime(self.expires),
            b'\xb5ur\x99' if self.test_mode else b'7\x97y\xbc',
            struct.pack('<i', self.this_dc),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.dc_options)),b''.join(x._bytes() for x in self.dc_options),
            self.serialize_bytes(self.dc_txt_domain_name),
            struct.pack('<i', self.chat_size_max),
            struct.pack('<i', self.megagroup_size_max),
            struct.pack('<i', self.forwarded_count_max),
            struct.pack('<i', self.online_update_period_ms),
            struct.pack('<i', self.offline_blur_timeout_ms),
            struct.pack('<i', self.offline_idle_timeout_ms),
            struct.pack('<i', self.online_cloud_timeout_ms),
            struct.pack('<i', self.notify_cloud_delay_ms),
            struct.pack('<i', self.notify_default_delay_ms),
            struct.pack('<i', self.push_chat_period_ms),
            struct.pack('<i', self.push_chat_limit),
            struct.pack('<i', self.edit_time_limit),
            struct.pack('<i', self.revoke_time_limit),
            struct.pack('<i', self.revoke_pm_time_limit),
            struct.pack('<i', self.rating_e_decay),
            struct.pack('<i', self.stickers_recent_limit),
            struct.pack('<i', self.channels_read_media_period),
            b'' if self.tmp_sessions is None or self.tmp_sessions is False else (struct.pack('<i', self.tmp_sessions)),
            struct.pack('<i', self.call_receive_timeout_ms),
            struct.pack('<i', self.call_ring_timeout_ms),
            struct.pack('<i', self.call_connect_timeout_ms),
            struct.pack('<i', self.call_packet_timeout_ms),
            self.serialize_bytes(self.me_url_prefix),
            b'' if self.autoupdate_url_prefix is None or self.autoupdate_url_prefix is False else (self.serialize_bytes(self.autoupdate_url_prefix)),
            b'' if self.gif_search_username is None or self.gif_search_username is False else (self.serialize_bytes(self.gif_search_username)),
            b'' if self.venue_search_username is None or self.venue_search_username is False else (self.serialize_bytes(self.venue_search_username)),
            b'' if self.img_search_username is None or self.img_search_username is False else (self.serialize_bytes(self.img_search_username)),
            b'' if self.static_maps_provider is None or self.static_maps_provider is False else (self.serialize_bytes(self.static_maps_provider)),
            struct.pack('<i', self.caption_length_max),
            struct.pack('<i', self.message_length_max),
            struct.pack('<i', self.webfile_dc_id),
            b'' if self.suggested_lang_code is None or self.suggested_lang_code is False else (self.serialize_bytes(self.suggested_lang_code)),
            b'' if self.lang_pack_version is None or self.lang_pack_version is False else (struct.pack('<i', self.lang_pack_version)),
            b'' if self.base_lang_pack_version is None or self.base_lang_pack_version is False else (struct.pack('<i', self.base_lang_pack_version)),
            b'' if self.reactions_default is None or self.reactions_default is False else (self.reactions_default._bytes()),
            b'' if self.autologin_token is None or self.autologin_token is False else (self.serialize_bytes(self.autologin_token)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _default_p2p_contacts = bool(flags & 8)
        _preload_featured_stickers = bool(flags & 16)
        _revoke_pm_inbox = bool(flags & 64)
        _blocked_mode = bool(flags & 256)
        _force_try_ipv6 = bool(flags & 16384)
        _date = reader.tgread_date()
        _expires = reader.tgread_date()
        _test_mode = reader.tgread_bool()
        _this_dc = reader.read_int()
        reader.read_int()
        _dc_options = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _dc_options.append(_x)

        _dc_txt_domain_name = reader.tgread_string()
        _chat_size_max = reader.read_int()
        _megagroup_size_max = reader.read_int()
        _forwarded_count_max = reader.read_int()
        _online_update_period_ms = reader.read_int()
        _offline_blur_timeout_ms = reader.read_int()
        _offline_idle_timeout_ms = reader.read_int()
        _online_cloud_timeout_ms = reader.read_int()
        _notify_cloud_delay_ms = reader.read_int()
        _notify_default_delay_ms = reader.read_int()
        _push_chat_period_ms = reader.read_int()
        _push_chat_limit = reader.read_int()
        _edit_time_limit = reader.read_int()
        _revoke_time_limit = reader.read_int()
        _revoke_pm_time_limit = reader.read_int()
        _rating_e_decay = reader.read_int()
        _stickers_recent_limit = reader.read_int()
        _channels_read_media_period = reader.read_int()
        if flags & 1:
            _tmp_sessions = reader.read_int()
        else:
            _tmp_sessions = None
        _call_receive_timeout_ms = reader.read_int()
        _call_ring_timeout_ms = reader.read_int()
        _call_connect_timeout_ms = reader.read_int()
        _call_packet_timeout_ms = reader.read_int()
        _me_url_prefix = reader.tgread_string()
        if flags & 128:
            _autoupdate_url_prefix = reader.tgread_string()
        else:
            _autoupdate_url_prefix = None
        if flags & 512:
            _gif_search_username = reader.tgread_string()
        else:
            _gif_search_username = None
        if flags & 1024:
            _venue_search_username = reader.tgread_string()
        else:
            _venue_search_username = None
        if flags & 2048:
            _img_search_username = reader.tgread_string()
        else:
            _img_search_username = None
        if flags & 4096:
            _static_maps_provider = reader.tgread_string()
        else:
            _static_maps_provider = None
        _caption_length_max = reader.read_int()
        _message_length_max = reader.read_int()
        _webfile_dc_id = reader.read_int()
        if flags & 4:
            _suggested_lang_code = reader.tgread_string()
        else:
            _suggested_lang_code = None
        if flags & 4:
            _lang_pack_version = reader.read_int()
        else:
            _lang_pack_version = None
        if flags & 4:
            _base_lang_pack_version = reader.read_int()
        else:
            _base_lang_pack_version = None
        if flags & 32768:
            _reactions_default = reader.tgread_object()
        else:
            _reactions_default = None
        if flags & 65536:
            _autologin_token = reader.tgread_string()
        else:
            _autologin_token = None
        return cls(date=_date, expires=_expires, test_mode=_test_mode, this_dc=_this_dc, dc_options=_dc_options, dc_txt_domain_name=_dc_txt_domain_name, chat_size_max=_chat_size_max, megagroup_size_max=_megagroup_size_max, forwarded_count_max=_forwarded_count_max, online_update_period_ms=_online_update_period_ms, offline_blur_timeout_ms=_offline_blur_timeout_ms, offline_idle_timeout_ms=_offline_idle_timeout_ms, online_cloud_timeout_ms=_online_cloud_timeout_ms, notify_cloud_delay_ms=_notify_cloud_delay_ms, notify_default_delay_ms=_notify_default_delay_ms, push_chat_period_ms=_push_chat_period_ms, push_chat_limit=_push_chat_limit, edit_time_limit=_edit_time_limit, revoke_time_limit=_revoke_time_limit, revoke_pm_time_limit=_revoke_pm_time_limit, rating_e_decay=_rating_e_decay, stickers_recent_limit=_stickers_recent_limit, channels_read_media_period=_channels_read_media_period, call_receive_timeout_ms=_call_receive_timeout_ms, call_ring_timeout_ms=_call_ring_timeout_ms, call_connect_timeout_ms=_call_connect_timeout_ms, call_packet_timeout_ms=_call_packet_timeout_ms, me_url_prefix=_me_url_prefix, caption_length_max=_caption_length_max, message_length_max=_message_length_max, webfile_dc_id=_webfile_dc_id, default_p2p_contacts=_default_p2p_contacts, preload_featured_stickers=_preload_featured_stickers, revoke_pm_inbox=_revoke_pm_inbox, blocked_mode=_blocked_mode, force_try_ipv6=_force_try_ipv6, tmp_sessions=_tmp_sessions, autoupdate_url_prefix=_autoupdate_url_prefix, gif_search_username=_gif_search_username, venue_search_username=_venue_search_username, img_search_username=_img_search_username, static_maps_provider=_static_maps_provider, suggested_lang_code=_suggested_lang_code, lang_pack_version=_lang_pack_version, base_lang_pack_version=_base_lang_pack_version, reactions_default=_reactions_default, autologin_token=_autologin_token)


class Contact(TLObject):
    CONSTRUCTOR_ID = 0x145ade0b
    SUBCLASS_OF_ID = 0x83dfdfa4

    def __init__(self, user_id: int, mutual: bool):
        """
        Constructor for Contact: Instance of Contact.
        """
        self.user_id = user_id
        self.mutual = mutual

    def to_dict(self):
        return {
            '_': 'Contact',
            'user_id': self.user_id,
            'mutual': self.mutual
        }

    def _bytes(self):
        return b''.join((
            b'\x0b\xdeZ\x14',
            struct.pack('<q', self.user_id),
            b'\xb5ur\x99' if self.mutual else b'7\x97y\xbc',
        ))

    @classmethod
    def from_reader(cls, reader):
        _user_id = reader.read_long()
        _mutual = reader.tgread_bool()
        return cls(user_id=_user_id, mutual=_mutual)


class ContactStatus(TLObject):
    CONSTRUCTOR_ID = 0x16d9703b
    SUBCLASS_OF_ID = 0x68c0d74c

    def __init__(self, user_id: int, status: 'TypeUserStatus'):
        """
        Constructor for ContactStatus: Instance of ContactStatus.
        """
        self.user_id = user_id
        self.status = status

    def to_dict(self):
        return {
            '_': 'ContactStatus',
            'user_id': self.user_id,
            'status': self.status.to_dict() if isinstance(self.status, TLObject) else self.status
        }

    def _bytes(self):
        return b''.join((
            b';p\xd9\x16',
            struct.pack('<q', self.user_id),
            self.status._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _user_id = reader.read_long()
        _status = reader.tgread_object()
        return cls(user_id=_user_id, status=_status)


class DataJSON(TLObject):
    CONSTRUCTOR_ID = 0x7d748d04
    SUBCLASS_OF_ID = 0xad0352e8

    def __init__(self, data: str):
        """
        Constructor for DataJSON: Instance of DataJSON.
        """
        self.data = data

    def to_dict(self):
        return {
            '_': 'DataJSON',
            'data': self.data
        }

    def _bytes(self):
        return b''.join((
            b'\x04\x8dt}',
            self.serialize_bytes(self.data),
        ))

    @classmethod
    def from_reader(cls, reader):
        _data = reader.tgread_string()
        return cls(data=_data)


class DcOption(TLObject):
    CONSTRUCTOR_ID = 0x18b7a10d
    SUBCLASS_OF_ID = 0x9e43e123

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, ip_address: str, port: int, ipv6: Optional[bool]=None, media_only: Optional[bool]=None, tcpo_only: Optional[bool]=None, cdn: Optional[bool]=None, static: Optional[bool]=None, this_port_only: Optional[bool]=None, secret: Optional[bytes]=None):
        """
        Constructor for DcOption: Instance of DcOption.
        """
        self.id = id
        self.ip_address = ip_address
        self.port = port
        self.ipv6 = ipv6
        self.media_only = media_only
        self.tcpo_only = tcpo_only
        self.cdn = cdn
        self.static = static
        self.this_port_only = this_port_only
        self.secret = secret

    def to_dict(self):
        return {
            '_': 'DcOption',
            'id': self.id,
            'ip_address': self.ip_address,
            'port': self.port,
            'ipv6': self.ipv6,
            'media_only': self.media_only,
            'tcpo_only': self.tcpo_only,
            'cdn': self.cdn,
            'static': self.static,
            'this_port_only': self.this_port_only,
            'secret': self.secret
        }

    def _bytes(self):
        return b''.join((
            b'\r\xa1\xb7\x18',
            struct.pack('<I', (0 if self.ipv6 is None or self.ipv6 is False else 1) | (0 if self.media_only is None or self.media_only is False else 2) | (0 if self.tcpo_only is None or self.tcpo_only is False else 4) | (0 if self.cdn is None or self.cdn is False else 8) | (0 if self.static is None or self.static is False else 16) | (0 if self.this_port_only is None or self.this_port_only is False else 32) | (0 if self.secret is None or self.secret is False else 1024)),
            struct.pack('<i', self.id),
            self.serialize_bytes(self.ip_address),
            struct.pack('<i', self.port),
            b'' if self.secret is None or self.secret is False else (self.serialize_bytes(self.secret)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _ipv6 = bool(flags & 1)
        _media_only = bool(flags & 2)
        _tcpo_only = bool(flags & 4)
        _cdn = bool(flags & 8)
        _static = bool(flags & 16)
        _this_port_only = bool(flags & 32)
        _id = reader.read_int()
        _ip_address = reader.tgread_string()
        _port = reader.read_int()
        if flags & 1024:
            _secret = reader.tgread_bytes()
        else:
            _secret = None
        return cls(id=_id, ip_address=_ip_address, port=_port, ipv6=_ipv6, media_only=_media_only, tcpo_only=_tcpo_only, cdn=_cdn, static=_static, this_port_only=_this_port_only, secret=_secret)


class DefaultHistoryTTL(TLObject):
    CONSTRUCTOR_ID = 0x43b46b20
    SUBCLASS_OF_ID = 0xf00d3367

    def __init__(self, period: int):
        """
        Constructor for DefaultHistoryTTL: Instance of DefaultHistoryTTL.
        """
        self.period = period

    def to_dict(self):
        return {
            '_': 'DefaultHistoryTTL',
            'period': self.period
        }

    def _bytes(self):
        return b''.join((
            b' k\xb4C',
            struct.pack('<i', self.period),
        ))

    @classmethod
    def from_reader(cls, reader):
        _period = reader.read_int()
        return cls(period=_period)


class DestroyAuthKeyFail(TLObject):
    CONSTRUCTOR_ID = 0xea109b13
    SUBCLASS_OF_ID = 0x8291e68e

    def to_dict(self):
        return {
            '_': 'DestroyAuthKeyFail'
        }

    def _bytes(self):
        return b''.join((
            b'\x13\x9b\x10\xea',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class DestroyAuthKeyNone(TLObject):
    CONSTRUCTOR_ID = 0xa9f2259
    SUBCLASS_OF_ID = 0x8291e68e

    def to_dict(self):
        return {
            '_': 'DestroyAuthKeyNone'
        }

    def _bytes(self):
        return b''.join((
            b'Y"\x9f\n',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class DestroyAuthKeyOk(TLObject):
    CONSTRUCTOR_ID = 0xf660e1d4
    SUBCLASS_OF_ID = 0x8291e68e

    def to_dict(self):
        return {
            '_': 'DestroyAuthKeyOk'
        }

    def _bytes(self):
        return b''.join((
            b'\xd4\xe1`\xf6',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class DestroySessionNone(TLObject):
    CONSTRUCTOR_ID = 0x62d350c9
    SUBCLASS_OF_ID = 0xaf0ce7bd

    def __init__(self, session_id: int):
        """
        Constructor for DestroySessionRes: Instance of either DestroySessionOk, DestroySessionNone.
        """
        self.session_id = session_id

    def to_dict(self):
        return {
            '_': 'DestroySessionNone',
            'session_id': self.session_id
        }

    def _bytes(self):
        return b''.join((
            b'\xc9P\xd3b',
            struct.pack('<q', self.session_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _session_id = reader.read_long()
        return cls(session_id=_session_id)


class DestroySessionOk(TLObject):
    CONSTRUCTOR_ID = 0xe22045fc
    SUBCLASS_OF_ID = 0xaf0ce7bd

    def __init__(self, session_id: int):
        """
        Constructor for DestroySessionRes: Instance of either DestroySessionOk, DestroySessionNone.
        """
        self.session_id = session_id

    def to_dict(self):
        return {
            '_': 'DestroySessionOk',
            'session_id': self.session_id
        }

    def _bytes(self):
        return b''.join((
            b'\xfcE \xe2',
            struct.pack('<q', self.session_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _session_id = reader.read_long()
        return cls(session_id=_session_id)


class DhGenFail(TLObject):
    CONSTRUCTOR_ID = 0xa69dae02
    SUBCLASS_OF_ID = 0x55dd6cdb

    def __init__(self, nonce: int, server_nonce: int, new_nonce_hash3: int):
        """
        Constructor for Set_client_DH_params_answer: Instance of either DhGenOk, DhGenRetry, DhGenFail.
        """
        self.nonce = nonce
        self.server_nonce = server_nonce
        self.new_nonce_hash3 = new_nonce_hash3

    def to_dict(self):
        return {
            '_': 'DhGenFail',
            'nonce': self.nonce,
            'server_nonce': self.server_nonce,
            'new_nonce_hash3': self.new_nonce_hash3
        }

    def _bytes(self):
        return b''.join((
            b'\x02\xae\x9d\xa6',
            self.nonce.to_bytes(16, 'little', signed=True),
            self.server_nonce.to_bytes(16, 'little', signed=True),
            self.new_nonce_hash3.to_bytes(16, 'little', signed=True),
        ))

    @classmethod
    def from_reader(cls, reader):
        _nonce = reader.read_large_int(bits=128)
        _server_nonce = reader.read_large_int(bits=128)
        _new_nonce_hash3 = reader.read_large_int(bits=128)
        return cls(nonce=_nonce, server_nonce=_server_nonce, new_nonce_hash3=_new_nonce_hash3)


class DhGenOk(TLObject):
    CONSTRUCTOR_ID = 0x3bcbf734
    SUBCLASS_OF_ID = 0x55dd6cdb

    def __init__(self, nonce: int, server_nonce: int, new_nonce_hash1: int):
        """
        Constructor for Set_client_DH_params_answer: Instance of either DhGenOk, DhGenRetry, DhGenFail.
        """
        self.nonce = nonce
        self.server_nonce = server_nonce
        self.new_nonce_hash1 = new_nonce_hash1

    def to_dict(self):
        return {
            '_': 'DhGenOk',
            'nonce': self.nonce,
            'server_nonce': self.server_nonce,
            'new_nonce_hash1': self.new_nonce_hash1
        }

    def _bytes(self):
        return b''.join((
            b'4\xf7\xcb;',
            self.nonce.to_bytes(16, 'little', signed=True),
            self.server_nonce.to_bytes(16, 'little', signed=True),
            self.new_nonce_hash1.to_bytes(16, 'little', signed=True),
        ))

    @classmethod
    def from_reader(cls, reader):
        _nonce = reader.read_large_int(bits=128)
        _server_nonce = reader.read_large_int(bits=128)
        _new_nonce_hash1 = reader.read_large_int(bits=128)
        return cls(nonce=_nonce, server_nonce=_server_nonce, new_nonce_hash1=_new_nonce_hash1)


class DhGenRetry(TLObject):
    CONSTRUCTOR_ID = 0x46dc1fb9
    SUBCLASS_OF_ID = 0x55dd6cdb

    def __init__(self, nonce: int, server_nonce: int, new_nonce_hash2: int):
        """
        Constructor for Set_client_DH_params_answer: Instance of either DhGenOk, DhGenRetry, DhGenFail.
        """
        self.nonce = nonce
        self.server_nonce = server_nonce
        self.new_nonce_hash2 = new_nonce_hash2

    def to_dict(self):
        return {
            '_': 'DhGenRetry',
            'nonce': self.nonce,
            'server_nonce': self.server_nonce,
            'new_nonce_hash2': self.new_nonce_hash2
        }

    def _bytes(self):
        return b''.join((
            b'\xb9\x1f\xdcF',
            self.nonce.to_bytes(16, 'little', signed=True),
            self.server_nonce.to_bytes(16, 'little', signed=True),
            self.new_nonce_hash2.to_bytes(16, 'little', signed=True),
        ))

    @classmethod
    def from_reader(cls, reader):
        _nonce = reader.read_large_int(bits=128)
        _server_nonce = reader.read_large_int(bits=128)
        _new_nonce_hash2 = reader.read_large_int(bits=128)
        return cls(nonce=_nonce, server_nonce=_server_nonce, new_nonce_hash2=_new_nonce_hash2)


class Dialog(TLObject):
    CONSTRUCTOR_ID = 0xd58a08c6
    SUBCLASS_OF_ID = 0x42cddd54

    def __init__(self, peer: 'TypePeer', top_message: int, read_inbox_max_id: int, read_outbox_max_id: int, unread_count: int, unread_mentions_count: int, unread_reactions_count: int, notify_settings: 'TypePeerNotifySettings', pinned: Optional[bool]=None, unread_mark: Optional[bool]=None, pts: Optional[int]=None, draft: Optional['TypeDraftMessage']=None, folder_id: Optional[int]=None, ttl_period: Optional[int]=None):
        """
        Constructor for Dialog: Instance of either Dialog, DialogFolder.
        """
        self.peer = peer
        self.top_message = top_message
        self.read_inbox_max_id = read_inbox_max_id
        self.read_outbox_max_id = read_outbox_max_id
        self.unread_count = unread_count
        self.unread_mentions_count = unread_mentions_count
        self.unread_reactions_count = unread_reactions_count
        self.notify_settings = notify_settings
        self.pinned = pinned
        self.unread_mark = unread_mark
        self.pts = pts
        self.draft = draft
        self.folder_id = folder_id
        self.ttl_period = ttl_period

    def to_dict(self):
        return {
            '_': 'Dialog',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'top_message': self.top_message,
            'read_inbox_max_id': self.read_inbox_max_id,
            'read_outbox_max_id': self.read_outbox_max_id,
            'unread_count': self.unread_count,
            'unread_mentions_count': self.unread_mentions_count,
            'unread_reactions_count': self.unread_reactions_count,
            'notify_settings': self.notify_settings.to_dict() if isinstance(self.notify_settings, TLObject) else self.notify_settings,
            'pinned': self.pinned,
            'unread_mark': self.unread_mark,
            'pts': self.pts,
            'draft': self.draft.to_dict() if isinstance(self.draft, TLObject) else self.draft,
            'folder_id': self.folder_id,
            'ttl_period': self.ttl_period
        }

    def _bytes(self):
        return b''.join((
            b'\xc6\x08\x8a\xd5',
            struct.pack('<I', (0 if self.pinned is None or self.pinned is False else 4) | (0 if self.unread_mark is None or self.unread_mark is False else 8) | (0 if self.pts is None or self.pts is False else 1) | (0 if self.draft is None or self.draft is False else 2) | (0 if self.folder_id is None or self.folder_id is False else 16) | (0 if self.ttl_period is None or self.ttl_period is False else 32)),
            self.peer._bytes(),
            struct.pack('<i', self.top_message),
            struct.pack('<i', self.read_inbox_max_id),
            struct.pack('<i', self.read_outbox_max_id),
            struct.pack('<i', self.unread_count),
            struct.pack('<i', self.unread_mentions_count),
            struct.pack('<i', self.unread_reactions_count),
            self.notify_settings._bytes(),
            b'' if self.pts is None or self.pts is False else (struct.pack('<i', self.pts)),
            b'' if self.draft is None or self.draft is False else (self.draft._bytes()),
            b'' if self.folder_id is None or self.folder_id is False else (struct.pack('<i', self.folder_id)),
            b'' if self.ttl_period is None or self.ttl_period is False else (struct.pack('<i', self.ttl_period)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _pinned = bool(flags & 4)
        _unread_mark = bool(flags & 8)
        _peer = reader.tgread_object()
        _top_message = reader.read_int()
        _read_inbox_max_id = reader.read_int()
        _read_outbox_max_id = reader.read_int()
        _unread_count = reader.read_int()
        _unread_mentions_count = reader.read_int()
        _unread_reactions_count = reader.read_int()
        _notify_settings = reader.tgread_object()
        if flags & 1:
            _pts = reader.read_int()
        else:
            _pts = None
        if flags & 2:
            _draft = reader.tgread_object()
        else:
            _draft = None
        if flags & 16:
            _folder_id = reader.read_int()
        else:
            _folder_id = None
        if flags & 32:
            _ttl_period = reader.read_int()
        else:
            _ttl_period = None
        return cls(peer=_peer, top_message=_top_message, read_inbox_max_id=_read_inbox_max_id, read_outbox_max_id=_read_outbox_max_id, unread_count=_unread_count, unread_mentions_count=_unread_mentions_count, unread_reactions_count=_unread_reactions_count, notify_settings=_notify_settings, pinned=_pinned, unread_mark=_unread_mark, pts=_pts, draft=_draft, folder_id=_folder_id, ttl_period=_ttl_period)


class DialogFilter(TLObject):
    CONSTRUCTOR_ID = 0x7438f7e8
    SUBCLASS_OF_ID = 0x692bc457

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, title: str, pinned_peers: List['TypeInputPeer'], include_peers: List['TypeInputPeer'], exclude_peers: List['TypeInputPeer'], contacts: Optional[bool]=None, non_contacts: Optional[bool]=None, groups: Optional[bool]=None, broadcasts: Optional[bool]=None, bots: Optional[bool]=None, exclude_muted: Optional[bool]=None, exclude_read: Optional[bool]=None, exclude_archived: Optional[bool]=None, emoticon: Optional[str]=None):
        """
        Constructor for DialogFilter: Instance of either DialogFilter, DialogFilterDefault, DialogFilterChatlist.
        """
        self.id = id
        self.title = title
        self.pinned_peers = pinned_peers
        self.include_peers = include_peers
        self.exclude_peers = exclude_peers
        self.contacts = contacts
        self.non_contacts = non_contacts
        self.groups = groups
        self.broadcasts = broadcasts
        self.bots = bots
        self.exclude_muted = exclude_muted
        self.exclude_read = exclude_read
        self.exclude_archived = exclude_archived
        self.emoticon = emoticon

    def to_dict(self):
        return {
            '_': 'DialogFilter',
            'id': self.id,
            'title': self.title,
            'pinned_peers': [] if self.pinned_peers is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.pinned_peers],
            'include_peers': [] if self.include_peers is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.include_peers],
            'exclude_peers': [] if self.exclude_peers is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.exclude_peers],
            'contacts': self.contacts,
            'non_contacts': self.non_contacts,
            'groups': self.groups,
            'broadcasts': self.broadcasts,
            'bots': self.bots,
            'exclude_muted': self.exclude_muted,
            'exclude_read': self.exclude_read,
            'exclude_archived': self.exclude_archived,
            'emoticon': self.emoticon
        }

    def _bytes(self):
        return b''.join((
            b'\xe8\xf78t',
            struct.pack('<I', (0 if self.contacts is None or self.contacts is False else 1) | (0 if self.non_contacts is None or self.non_contacts is False else 2) | (0 if self.groups is None or self.groups is False else 4) | (0 if self.broadcasts is None or self.broadcasts is False else 8) | (0 if self.bots is None or self.bots is False else 16) | (0 if self.exclude_muted is None or self.exclude_muted is False else 2048) | (0 if self.exclude_read is None or self.exclude_read is False else 4096) | (0 if self.exclude_archived is None or self.exclude_archived is False else 8192) | (0 if self.emoticon is None or self.emoticon is False else 33554432)),
            struct.pack('<i', self.id),
            self.serialize_bytes(self.title),
            b'' if self.emoticon is None or self.emoticon is False else (self.serialize_bytes(self.emoticon)),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.pinned_peers)),b''.join(x._bytes() for x in self.pinned_peers),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.include_peers)),b''.join(x._bytes() for x in self.include_peers),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.exclude_peers)),b''.join(x._bytes() for x in self.exclude_peers),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _contacts = bool(flags & 1)
        _non_contacts = bool(flags & 2)
        _groups = bool(flags & 4)
        _broadcasts = bool(flags & 8)
        _bots = bool(flags & 16)
        _exclude_muted = bool(flags & 2048)
        _exclude_read = bool(flags & 4096)
        _exclude_archived = bool(flags & 8192)
        _id = reader.read_int()
        _title = reader.tgread_string()
        if flags & 33554432:
            _emoticon = reader.tgread_string()
        else:
            _emoticon = None
        reader.read_int()
        _pinned_peers = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _pinned_peers.append(_x)

        reader.read_int()
        _include_peers = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _include_peers.append(_x)

        reader.read_int()
        _exclude_peers = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _exclude_peers.append(_x)

        return cls(id=_id, title=_title, pinned_peers=_pinned_peers, include_peers=_include_peers, exclude_peers=_exclude_peers, contacts=_contacts, non_contacts=_non_contacts, groups=_groups, broadcasts=_broadcasts, bots=_bots, exclude_muted=_exclude_muted, exclude_read=_exclude_read, exclude_archived=_exclude_archived, emoticon=_emoticon)


class DialogFilterChatlist(TLObject):
    CONSTRUCTOR_ID = 0xd64a04a8
    SUBCLASS_OF_ID = 0x692bc457

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, title: str, pinned_peers: List['TypeInputPeer'], include_peers: List['TypeInputPeer'], has_my_invites: Optional[bool]=None, emoticon: Optional[str]=None):
        """
        Constructor for DialogFilter: Instance of either DialogFilter, DialogFilterDefault, DialogFilterChatlist.
        """
        self.id = id
        self.title = title
        self.pinned_peers = pinned_peers
        self.include_peers = include_peers
        self.has_my_invites = has_my_invites
        self.emoticon = emoticon

    def to_dict(self):
        return {
            '_': 'DialogFilterChatlist',
            'id': self.id,
            'title': self.title,
            'pinned_peers': [] if self.pinned_peers is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.pinned_peers],
            'include_peers': [] if self.include_peers is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.include_peers],
            'has_my_invites': self.has_my_invites,
            'emoticon': self.emoticon
        }

    def _bytes(self):
        return b''.join((
            b'\xa8\x04J\xd6',
            struct.pack('<I', (0 if self.has_my_invites is None or self.has_my_invites is False else 67108864) | (0 if self.emoticon is None or self.emoticon is False else 33554432)),
            struct.pack('<i', self.id),
            self.serialize_bytes(self.title),
            b'' if self.emoticon is None or self.emoticon is False else (self.serialize_bytes(self.emoticon)),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.pinned_peers)),b''.join(x._bytes() for x in self.pinned_peers),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.include_peers)),b''.join(x._bytes() for x in self.include_peers),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _has_my_invites = bool(flags & 67108864)
        _id = reader.read_int()
        _title = reader.tgread_string()
        if flags & 33554432:
            _emoticon = reader.tgread_string()
        else:
            _emoticon = None
        reader.read_int()
        _pinned_peers = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _pinned_peers.append(_x)

        reader.read_int()
        _include_peers = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _include_peers.append(_x)

        return cls(id=_id, title=_title, pinned_peers=_pinned_peers, include_peers=_include_peers, has_my_invites=_has_my_invites, emoticon=_emoticon)


class DialogFilterDefault(TLObject):
    CONSTRUCTOR_ID = 0x363293ae
    SUBCLASS_OF_ID = 0x692bc457

    def to_dict(self):
        return {
            '_': 'DialogFilterDefault'
        }

    def _bytes(self):
        return b''.join((
            b'\xae\x9326',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class DialogFilterSuggested(TLObject):
    CONSTRUCTOR_ID = 0x77744d4a
    SUBCLASS_OF_ID = 0x31ede086

    # noinspection PyShadowingBuiltins
    def __init__(self, filter: 'TypeDialogFilter', description: str):
        """
        Constructor for DialogFilterSuggested: Instance of DialogFilterSuggested.
        """
        self.filter = filter
        self.description = description

    def to_dict(self):
        return {
            '_': 'DialogFilterSuggested',
            'filter': self.filter.to_dict() if isinstance(self.filter, TLObject) else self.filter,
            'description': self.description
        }

    def _bytes(self):
        return b''.join((
            b'JMtw',
            self.filter._bytes(),
            self.serialize_bytes(self.description),
        ))

    @classmethod
    def from_reader(cls, reader):
        _filter = reader.tgread_object()
        _description = reader.tgread_string()
        return cls(filter=_filter, description=_description)


class DialogFolder(TLObject):
    CONSTRUCTOR_ID = 0x71bd134c
    SUBCLASS_OF_ID = 0x42cddd54

    def __init__(self, folder: 'TypeFolder', peer: 'TypePeer', top_message: int, unread_muted_peers_count: int, unread_unmuted_peers_count: int, unread_muted_messages_count: int, unread_unmuted_messages_count: int, pinned: Optional[bool]=None):
        """
        Constructor for Dialog: Instance of either Dialog, DialogFolder.
        """
        self.folder = folder
        self.peer = peer
        self.top_message = top_message
        self.unread_muted_peers_count = unread_muted_peers_count
        self.unread_unmuted_peers_count = unread_unmuted_peers_count
        self.unread_muted_messages_count = unread_muted_messages_count
        self.unread_unmuted_messages_count = unread_unmuted_messages_count
        self.pinned = pinned

    def to_dict(self):
        return {
            '_': 'DialogFolder',
            'folder': self.folder.to_dict() if isinstance(self.folder, TLObject) else self.folder,
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'top_message': self.top_message,
            'unread_muted_peers_count': self.unread_muted_peers_count,
            'unread_unmuted_peers_count': self.unread_unmuted_peers_count,
            'unread_muted_messages_count': self.unread_muted_messages_count,
            'unread_unmuted_messages_count': self.unread_unmuted_messages_count,
            'pinned': self.pinned
        }

    def _bytes(self):
        return b''.join((
            b'L\x13\xbdq',
            struct.pack('<I', (0 if self.pinned is None or self.pinned is False else 4)),
            self.folder._bytes(),
            self.peer._bytes(),
            struct.pack('<i', self.top_message),
            struct.pack('<i', self.unread_muted_peers_count),
            struct.pack('<i', self.unread_unmuted_peers_count),
            struct.pack('<i', self.unread_muted_messages_count),
            struct.pack('<i', self.unread_unmuted_messages_count),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _pinned = bool(flags & 4)
        _folder = reader.tgread_object()
        _peer = reader.tgread_object()
        _top_message = reader.read_int()
        _unread_muted_peers_count = reader.read_int()
        _unread_unmuted_peers_count = reader.read_int()
        _unread_muted_messages_count = reader.read_int()
        _unread_unmuted_messages_count = reader.read_int()
        return cls(folder=_folder, peer=_peer, top_message=_top_message, unread_muted_peers_count=_unread_muted_peers_count, unread_unmuted_peers_count=_unread_unmuted_peers_count, unread_muted_messages_count=_unread_muted_messages_count, unread_unmuted_messages_count=_unread_unmuted_messages_count, pinned=_pinned)


class DialogPeer(TLObject):
    CONSTRUCTOR_ID = 0xe56dbf05
    SUBCLASS_OF_ID = 0x256ce1ae

    def __init__(self, peer: 'TypePeer'):
        """
        Constructor for DialogPeer: Instance of either DialogPeer, DialogPeerFolder.
        """
        self.peer = peer

    def to_dict(self):
        return {
            '_': 'DialogPeer',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer
        }

    def _bytes(self):
        return b''.join((
            b'\x05\xbfm\xe5',
            self.peer._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        return cls(peer=_peer)


class DialogPeerFolder(TLObject):
    CONSTRUCTOR_ID = 0x514519e2
    SUBCLASS_OF_ID = 0x256ce1ae

    def __init__(self, folder_id: int):
        """
        Constructor for DialogPeer: Instance of either DialogPeer, DialogPeerFolder.
        """
        self.folder_id = folder_id

    def to_dict(self):
        return {
            '_': 'DialogPeerFolder',
            'folder_id': self.folder_id
        }

    def _bytes(self):
        return b''.join((
            b'\xe2\x19EQ',
            struct.pack('<i', self.folder_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _folder_id = reader.read_int()
        return cls(folder_id=_folder_id)


class Document(TLObject):
    CONSTRUCTOR_ID = 0x8fd4c4d8
    SUBCLASS_OF_ID = 0x211fe820

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, file_reference: bytes, date: Optional[datetime], mime_type: str, size: int, dc_id: int, attributes: List['TypeDocumentAttribute'], thumbs: Optional[List['TypePhotoSize']]=None, video_thumbs: Optional[List['TypeVideoSize']]=None):
        """
        Constructor for Document: Instance of either DocumentEmpty, Document.
        """
        self.id = id
        self.access_hash = access_hash
        self.file_reference = file_reference
        self.date = date
        self.mime_type = mime_type
        self.size = size
        self.dc_id = dc_id
        self.attributes = attributes
        self.thumbs = thumbs
        self.video_thumbs = video_thumbs

    def to_dict(self):
        return {
            '_': 'Document',
            'id': self.id,
            'access_hash': self.access_hash,
            'file_reference': self.file_reference,
            'date': self.date,
            'mime_type': self.mime_type,
            'size': self.size,
            'dc_id': self.dc_id,
            'attributes': [] if self.attributes is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.attributes],
            'thumbs': [] if self.thumbs is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.thumbs],
            'video_thumbs': [] if self.video_thumbs is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.video_thumbs]
        }

    def _bytes(self):
        return b''.join((
            b'\xd8\xc4\xd4\x8f',
            struct.pack('<I', (0 if self.thumbs is None or self.thumbs is False else 1) | (0 if self.video_thumbs is None or self.video_thumbs is False else 2)),
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            self.serialize_bytes(self.file_reference),
            self.serialize_datetime(self.date),
            self.serialize_bytes(self.mime_type),
            struct.pack('<q', self.size),
            b'' if self.thumbs is None or self.thumbs is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.thumbs)),b''.join(x._bytes() for x in self.thumbs))),
            b'' if self.video_thumbs is None or self.video_thumbs is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.video_thumbs)),b''.join(x._bytes() for x in self.video_thumbs))),
            struct.pack('<i', self.dc_id),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.attributes)),b''.join(x._bytes() for x in self.attributes),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _id = reader.read_long()
        _access_hash = reader.read_long()
        _file_reference = reader.tgread_bytes()
        _date = reader.tgread_date()
        _mime_type = reader.tgread_string()
        _size = reader.read_long()
        if flags & 1:
            reader.read_int()
            _thumbs = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _thumbs.append(_x)

        else:
            _thumbs = None
        if flags & 2:
            reader.read_int()
            _video_thumbs = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _video_thumbs.append(_x)

        else:
            _video_thumbs = None
        _dc_id = reader.read_int()
        reader.read_int()
        _attributes = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _attributes.append(_x)

        return cls(id=_id, access_hash=_access_hash, file_reference=_file_reference, date=_date, mime_type=_mime_type, size=_size, dc_id=_dc_id, attributes=_attributes, thumbs=_thumbs, video_thumbs=_video_thumbs)


class DocumentAttributeAnimated(TLObject):
    CONSTRUCTOR_ID = 0x11b58939
    SUBCLASS_OF_ID = 0xf729eb9b

    def to_dict(self):
        return {
            '_': 'DocumentAttributeAnimated'
        }

    def _bytes(self):
        return b''.join((
            b'9\x89\xb5\x11',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class DocumentAttributeAudio(TLObject):
    CONSTRUCTOR_ID = 0x9852f9c6
    SUBCLASS_OF_ID = 0xf729eb9b

    def __init__(self, duration: int, voice: Optional[bool]=None, title: Optional[str]=None, performer: Optional[str]=None, waveform: Optional[bytes]=None):
        """
        Constructor for DocumentAttribute: Instance of either DocumentAttributeImageSize, DocumentAttributeAnimated, DocumentAttributeSticker, DocumentAttributeVideo, DocumentAttributeAudio, DocumentAttributeFilename, DocumentAttributeHasStickers, DocumentAttributeCustomEmoji.
        """
        self.duration = duration
        self.voice = voice
        self.title = title
        self.performer = performer
        self.waveform = waveform

    def to_dict(self):
        return {
            '_': 'DocumentAttributeAudio',
            'duration': self.duration,
            'voice': self.voice,
            'title': self.title,
            'performer': self.performer,
            'waveform': self.waveform
        }

    def _bytes(self):
        return b''.join((
            b'\xc6\xf9R\x98',
            struct.pack('<I', (0 if self.voice is None or self.voice is False else 1024) | (0 if self.title is None or self.title is False else 1) | (0 if self.performer is None or self.performer is False else 2) | (0 if self.waveform is None or self.waveform is False else 4)),
            struct.pack('<i', self.duration),
            b'' if self.title is None or self.title is False else (self.serialize_bytes(self.title)),
            b'' if self.performer is None or self.performer is False else (self.serialize_bytes(self.performer)),
            b'' if self.waveform is None or self.waveform is False else (self.serialize_bytes(self.waveform)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _voice = bool(flags & 1024)
        _duration = reader.read_int()
        if flags & 1:
            _title = reader.tgread_string()
        else:
            _title = None
        if flags & 2:
            _performer = reader.tgread_string()
        else:
            _performer = None
        if flags & 4:
            _waveform = reader.tgread_bytes()
        else:
            _waveform = None
        return cls(duration=_duration, voice=_voice, title=_title, performer=_performer, waveform=_waveform)


class DocumentAttributeCustomEmoji(TLObject):
    CONSTRUCTOR_ID = 0xfd149899
    SUBCLASS_OF_ID = 0xf729eb9b

    def __init__(self, alt: str, stickerset: 'TypeInputStickerSet', free: Optional[bool]=None, text_color: Optional[bool]=None):
        """
        Constructor for DocumentAttribute: Instance of either DocumentAttributeImageSize, DocumentAttributeAnimated, DocumentAttributeSticker, DocumentAttributeVideo, DocumentAttributeAudio, DocumentAttributeFilename, DocumentAttributeHasStickers, DocumentAttributeCustomEmoji.
        """
        self.alt = alt
        self.stickerset = stickerset
        self.free = free
        self.text_color = text_color

    def to_dict(self):
        return {
            '_': 'DocumentAttributeCustomEmoji',
            'alt': self.alt,
            'stickerset': self.stickerset.to_dict() if isinstance(self.stickerset, TLObject) else self.stickerset,
            'free': self.free,
            'text_color': self.text_color
        }

    def _bytes(self):
        return b''.join((
            b'\x99\x98\x14\xfd',
            struct.pack('<I', (0 if self.free is None or self.free is False else 1) | (0 if self.text_color is None or self.text_color is False else 2)),
            self.serialize_bytes(self.alt),
            self.stickerset._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _free = bool(flags & 1)
        _text_color = bool(flags & 2)
        _alt = reader.tgread_string()
        _stickerset = reader.tgread_object()
        return cls(alt=_alt, stickerset=_stickerset, free=_free, text_color=_text_color)


class DocumentAttributeFilename(TLObject):
    CONSTRUCTOR_ID = 0x15590068
    SUBCLASS_OF_ID = 0xf729eb9b

    def __init__(self, file_name: str):
        """
        Constructor for DocumentAttribute: Instance of either DocumentAttributeImageSize, DocumentAttributeAnimated, DocumentAttributeSticker, DocumentAttributeVideo, DocumentAttributeAudio, DocumentAttributeFilename, DocumentAttributeHasStickers, DocumentAttributeCustomEmoji.
        """
        self.file_name = file_name

    def to_dict(self):
        return {
            '_': 'DocumentAttributeFilename',
            'file_name': self.file_name
        }

    def _bytes(self):
        return b''.join((
            b'h\x00Y\x15',
            self.serialize_bytes(self.file_name),
        ))

    @classmethod
    def from_reader(cls, reader):
        _file_name = reader.tgread_string()
        return cls(file_name=_file_name)


class DocumentAttributeHasStickers(TLObject):
    CONSTRUCTOR_ID = 0x9801d2f7
    SUBCLASS_OF_ID = 0xf729eb9b

    def to_dict(self):
        return {
            '_': 'DocumentAttributeHasStickers'
        }

    def _bytes(self):
        return b''.join((
            b'\xf7\xd2\x01\x98',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class DocumentAttributeImageSize(TLObject):
    CONSTRUCTOR_ID = 0x6c37c15c
    SUBCLASS_OF_ID = 0xf729eb9b

    def __init__(self, w: int, h: int):
        """
        Constructor for DocumentAttribute: Instance of either DocumentAttributeImageSize, DocumentAttributeAnimated, DocumentAttributeSticker, DocumentAttributeVideo, DocumentAttributeAudio, DocumentAttributeFilename, DocumentAttributeHasStickers, DocumentAttributeCustomEmoji.
        """
        self.w = w
        self.h = h

    def to_dict(self):
        return {
            '_': 'DocumentAttributeImageSize',
            'w': self.w,
            'h': self.h
        }

    def _bytes(self):
        return b''.join((
            b'\\\xc17l',
            struct.pack('<i', self.w),
            struct.pack('<i', self.h),
        ))

    @classmethod
    def from_reader(cls, reader):
        _w = reader.read_int()
        _h = reader.read_int()
        return cls(w=_w, h=_h)


class DocumentAttributeSticker(TLObject):
    CONSTRUCTOR_ID = 0x6319d612
    SUBCLASS_OF_ID = 0xf729eb9b

    def __init__(self, alt: str, stickerset: 'TypeInputStickerSet', mask: Optional[bool]=None, mask_coords: Optional['TypeMaskCoords']=None):
        """
        Constructor for DocumentAttribute: Instance of either DocumentAttributeImageSize, DocumentAttributeAnimated, DocumentAttributeSticker, DocumentAttributeVideo, DocumentAttributeAudio, DocumentAttributeFilename, DocumentAttributeHasStickers, DocumentAttributeCustomEmoji.
        """
        self.alt = alt
        self.stickerset = stickerset
        self.mask = mask
        self.mask_coords = mask_coords

    def to_dict(self):
        return {
            '_': 'DocumentAttributeSticker',
            'alt': self.alt,
            'stickerset': self.stickerset.to_dict() if isinstance(self.stickerset, TLObject) else self.stickerset,
            'mask': self.mask,
            'mask_coords': self.mask_coords.to_dict() if isinstance(self.mask_coords, TLObject) else self.mask_coords
        }

    def _bytes(self):
        return b''.join((
            b'\x12\xd6\x19c',
            struct.pack('<I', (0 if self.mask is None or self.mask is False else 2) | (0 if self.mask_coords is None or self.mask_coords is False else 1)),
            self.serialize_bytes(self.alt),
            self.stickerset._bytes(),
            b'' if self.mask_coords is None or self.mask_coords is False else (self.mask_coords._bytes()),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _mask = bool(flags & 2)
        _alt = reader.tgread_string()
        _stickerset = reader.tgread_object()
        if flags & 1:
            _mask_coords = reader.tgread_object()
        else:
            _mask_coords = None
        return cls(alt=_alt, stickerset=_stickerset, mask=_mask, mask_coords=_mask_coords)


class DocumentAttributeVideo(TLObject):
    CONSTRUCTOR_ID = 0xd38ff1c2
    SUBCLASS_OF_ID = 0xf729eb9b

    def __init__(self, duration: float, w: int, h: int, round_message: Optional[bool]=None, supports_streaming: Optional[bool]=None, nosound: Optional[bool]=None, preload_prefix_size: Optional[int]=None):
        """
        Constructor for DocumentAttribute: Instance of either DocumentAttributeImageSize, DocumentAttributeAnimated, DocumentAttributeSticker, DocumentAttributeVideo, DocumentAttributeAudio, DocumentAttributeFilename, DocumentAttributeHasStickers, DocumentAttributeCustomEmoji.
        """
        self.duration = duration
        self.w = w
        self.h = h
        self.round_message = round_message
        self.supports_streaming = supports_streaming
        self.nosound = nosound
        self.preload_prefix_size = preload_prefix_size

    def to_dict(self):
        return {
            '_': 'DocumentAttributeVideo',
            'duration': self.duration,
            'w': self.w,
            'h': self.h,
            'round_message': self.round_message,
            'supports_streaming': self.supports_streaming,
            'nosound': self.nosound,
            'preload_prefix_size': self.preload_prefix_size
        }

    def _bytes(self):
        return b''.join((
            b'\xc2\xf1\x8f\xd3',
            struct.pack('<I', (0 if self.round_message is None or self.round_message is False else 1) | (0 if self.supports_streaming is None or self.supports_streaming is False else 2) | (0 if self.nosound is None or self.nosound is False else 8) | (0 if self.preload_prefix_size is None or self.preload_prefix_size is False else 4)),
            struct.pack('<d', self.duration),
            struct.pack('<i', self.w),
            struct.pack('<i', self.h),
            b'' if self.preload_prefix_size is None or self.preload_prefix_size is False else (struct.pack('<i', self.preload_prefix_size)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _round_message = bool(flags & 1)
        _supports_streaming = bool(flags & 2)
        _nosound = bool(flags & 8)
        _duration = reader.read_double()
        _w = reader.read_int()
        _h = reader.read_int()
        if flags & 4:
            _preload_prefix_size = reader.read_int()
        else:
            _preload_prefix_size = None
        return cls(duration=_duration, w=_w, h=_h, round_message=_round_message, supports_streaming=_supports_streaming, nosound=_nosound, preload_prefix_size=_preload_prefix_size)


class DocumentEmpty(TLObject):
    CONSTRUCTOR_ID = 0x36f8c871
    SUBCLASS_OF_ID = 0x211fe820

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int):
        """
        Constructor for Document: Instance of either DocumentEmpty, Document.
        """
        self.id = id

    def to_dict(self):
        return {
            '_': 'DocumentEmpty',
            'id': self.id
        }

    def _bytes(self):
        return b''.join((
            b'q\xc8\xf86',
            struct.pack('<q', self.id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        return cls(id=_id)


class DraftMessage(TLObject):
    CONSTRUCTOR_ID = 0x3fccf7ef
    SUBCLASS_OF_ID = 0x33d47f45

    def __init__(self, message: str, date: Optional[datetime], no_webpage: Optional[bool]=None, invert_media: Optional[bool]=None, reply_to: Optional['TypeInputReplyTo']=None, entities: Optional[List['TypeMessageEntity']]=None, media: Optional['TypeInputMedia']=None):
        """
        Constructor for DraftMessage: Instance of either DraftMessageEmpty, DraftMessage.
        """
        self.message = message
        self.date = date
        self.no_webpage = no_webpage
        self.invert_media = invert_media
        self.reply_to = reply_to
        self.entities = entities
        self.media = media

    def to_dict(self):
        return {
            '_': 'DraftMessage',
            'message': self.message,
            'date': self.date,
            'no_webpage': self.no_webpage,
            'invert_media': self.invert_media,
            'reply_to': self.reply_to.to_dict() if isinstance(self.reply_to, TLObject) else self.reply_to,
            'entities': [] if self.entities is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.entities],
            'media': self.media.to_dict() if isinstance(self.media, TLObject) else self.media
        }

    def _bytes(self):
        return b''.join((
            b'\xef\xf7\xcc?',
            struct.pack('<I', (0 if self.no_webpage is None or self.no_webpage is False else 2) | (0 if self.invert_media is None or self.invert_media is False else 64) | (0 if self.reply_to is None or self.reply_to is False else 16) | (0 if self.entities is None or self.entities is False else 8) | (0 if self.media is None or self.media is False else 32)),
            b'' if self.reply_to is None or self.reply_to is False else (self.reply_to._bytes()),
            self.serialize_bytes(self.message),
            b'' if self.entities is None or self.entities is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.entities)),b''.join(x._bytes() for x in self.entities))),
            b'' if self.media is None or self.media is False else (self.media._bytes()),
            self.serialize_datetime(self.date),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _no_webpage = bool(flags & 2)
        _invert_media = bool(flags & 64)
        if flags & 16:
            _reply_to = reader.tgread_object()
        else:
            _reply_to = None
        _message = reader.tgread_string()
        if flags & 8:
            reader.read_int()
            _entities = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _entities.append(_x)

        else:
            _entities = None
        if flags & 32:
            _media = reader.tgread_object()
        else:
            _media = None
        _date = reader.tgread_date()
        return cls(message=_message, date=_date, no_webpage=_no_webpage, invert_media=_invert_media, reply_to=_reply_to, entities=_entities, media=_media)


class DraftMessageEmpty(TLObject):
    CONSTRUCTOR_ID = 0x1b0c841a
    SUBCLASS_OF_ID = 0x33d47f45

    def __init__(self, date: Optional[datetime]=None):
        """
        Constructor for DraftMessage: Instance of either DraftMessageEmpty, DraftMessage.
        """
        self.date = date

    def to_dict(self):
        return {
            '_': 'DraftMessageEmpty',
            'date': self.date
        }

    def _bytes(self):
        return b''.join((
            b'\x1a\x84\x0c\x1b',
            struct.pack('<I', (0 if self.date is None or self.date is False else 1)),
            b'' if self.date is None or self.date is False else (self.serialize_datetime(self.date)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 1:
            _date = reader.tgread_date()
        else:
            _date = None
        return cls(date=_date)


class EmailVerificationApple(TLObject):
    CONSTRUCTOR_ID = 0x96d074fd
    SUBCLASS_OF_ID = 0x241ee240

    def __init__(self, token: str):
        """
        Constructor for EmailVerification: Instance of either EmailVerificationCode, EmailVerificationGoogle, EmailVerificationApple.
        """
        self.token = token

    def to_dict(self):
        return {
            '_': 'EmailVerificationApple',
            'token': self.token
        }

    def _bytes(self):
        return b''.join((
            b'\xfdt\xd0\x96',
            self.serialize_bytes(self.token),
        ))

    @classmethod
    def from_reader(cls, reader):
        _token = reader.tgread_string()
        return cls(token=_token)


class EmailVerificationCode(TLObject):
    CONSTRUCTOR_ID = 0x922e55a9
    SUBCLASS_OF_ID = 0x241ee240

    def __init__(self, code: str):
        """
        Constructor for EmailVerification: Instance of either EmailVerificationCode, EmailVerificationGoogle, EmailVerificationApple.
        """
        self.code = code

    def to_dict(self):
        return {
            '_': 'EmailVerificationCode',
            'code': self.code
        }

    def _bytes(self):
        return b''.join((
            b'\xa9U.\x92',
            self.serialize_bytes(self.code),
        ))

    @classmethod
    def from_reader(cls, reader):
        _code = reader.tgread_string()
        return cls(code=_code)


class EmailVerificationGoogle(TLObject):
    CONSTRUCTOR_ID = 0xdb909ec2
    SUBCLASS_OF_ID = 0x241ee240

    def __init__(self, token: str):
        """
        Constructor for EmailVerification: Instance of either EmailVerificationCode, EmailVerificationGoogle, EmailVerificationApple.
        """
        self.token = token

    def to_dict(self):
        return {
            '_': 'EmailVerificationGoogle',
            'token': self.token
        }

    def _bytes(self):
        return b''.join((
            b'\xc2\x9e\x90\xdb',
            self.serialize_bytes(self.token),
        ))

    @classmethod
    def from_reader(cls, reader):
        _token = reader.tgread_string()
        return cls(token=_token)


class EmailVerifyPurposeLoginChange(TLObject):
    CONSTRUCTOR_ID = 0x527d22eb
    SUBCLASS_OF_ID = 0xb9686ae8

    def to_dict(self):
        return {
            '_': 'EmailVerifyPurposeLoginChange'
        }

    def _bytes(self):
        return b''.join((
            b'\xeb"}R',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class EmailVerifyPurposeLoginSetup(TLObject):
    CONSTRUCTOR_ID = 0x4345be73
    SUBCLASS_OF_ID = 0xb9686ae8

    def __init__(self, phone_number: str, phone_code_hash: str):
        """
        Constructor for EmailVerifyPurpose: Instance of either EmailVerifyPurposeLoginSetup, EmailVerifyPurposeLoginChange, EmailVerifyPurposePassport.
        """
        self.phone_number = phone_number
        self.phone_code_hash = phone_code_hash

    def to_dict(self):
        return {
            '_': 'EmailVerifyPurposeLoginSetup',
            'phone_number': self.phone_number,
            'phone_code_hash': self.phone_code_hash
        }

    def _bytes(self):
        return b''.join((
            b's\xbeEC',
            self.serialize_bytes(self.phone_number),
            self.serialize_bytes(self.phone_code_hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _phone_number = reader.tgread_string()
        _phone_code_hash = reader.tgread_string()
        return cls(phone_number=_phone_number, phone_code_hash=_phone_code_hash)


class EmailVerifyPurposePassport(TLObject):
    CONSTRUCTOR_ID = 0xbbf51685
    SUBCLASS_OF_ID = 0xb9686ae8

    def to_dict(self):
        return {
            '_': 'EmailVerifyPurposePassport'
        }

    def _bytes(self):
        return b''.join((
            b'\x85\x16\xf5\xbb',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class EmojiGroup(TLObject):
    CONSTRUCTOR_ID = 0x7a9abda9
    SUBCLASS_OF_ID = 0x55e0a193

    def __init__(self, title: str, icon_emoji_id: int, emoticons: List[str]):
        """
        Constructor for EmojiGroup: Instance of EmojiGroup.
        """
        self.title = title
        self.icon_emoji_id = icon_emoji_id
        self.emoticons = emoticons

    def to_dict(self):
        return {
            '_': 'EmojiGroup',
            'title': self.title,
            'icon_emoji_id': self.icon_emoji_id,
            'emoticons': [] if self.emoticons is None else self.emoticons[:]
        }

    def _bytes(self):
        return b''.join((
            b'\xa9\xbd\x9az',
            self.serialize_bytes(self.title),
            struct.pack('<q', self.icon_emoji_id),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.emoticons)),b''.join(self.serialize_bytes(x) for x in self.emoticons),
        ))

    @classmethod
    def from_reader(cls, reader):
        _title = reader.tgread_string()
        _icon_emoji_id = reader.read_long()
        reader.read_int()
        _emoticons = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_string()
            _emoticons.append(_x)

        return cls(title=_title, icon_emoji_id=_icon_emoji_id, emoticons=_emoticons)


class EmojiKeyword(TLObject):
    CONSTRUCTOR_ID = 0xd5b3b9f9
    SUBCLASS_OF_ID = 0x6612a53e

    def __init__(self, keyword: str, emoticons: List[str]):
        """
        Constructor for EmojiKeyword: Instance of either EmojiKeyword, EmojiKeywordDeleted.
        """
        self.keyword = keyword
        self.emoticons = emoticons

    def to_dict(self):
        return {
            '_': 'EmojiKeyword',
            'keyword': self.keyword,
            'emoticons': [] if self.emoticons is None else self.emoticons[:]
        }

    def _bytes(self):
        return b''.join((
            b'\xf9\xb9\xb3\xd5',
            self.serialize_bytes(self.keyword),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.emoticons)),b''.join(self.serialize_bytes(x) for x in self.emoticons),
        ))

    @classmethod
    def from_reader(cls, reader):
        _keyword = reader.tgread_string()
        reader.read_int()
        _emoticons = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_string()
            _emoticons.append(_x)

        return cls(keyword=_keyword, emoticons=_emoticons)


class EmojiKeywordDeleted(TLObject):
    CONSTRUCTOR_ID = 0x236df622
    SUBCLASS_OF_ID = 0x6612a53e

    def __init__(self, keyword: str, emoticons: List[str]):
        """
        Constructor for EmojiKeyword: Instance of either EmojiKeyword, EmojiKeywordDeleted.
        """
        self.keyword = keyword
        self.emoticons = emoticons

    def to_dict(self):
        return {
            '_': 'EmojiKeywordDeleted',
            'keyword': self.keyword,
            'emoticons': [] if self.emoticons is None else self.emoticons[:]
        }

    def _bytes(self):
        return b''.join((
            b'"\xf6m#',
            self.serialize_bytes(self.keyword),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.emoticons)),b''.join(self.serialize_bytes(x) for x in self.emoticons),
        ))

    @classmethod
    def from_reader(cls, reader):
        _keyword = reader.tgread_string()
        reader.read_int()
        _emoticons = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_string()
            _emoticons.append(_x)

        return cls(keyword=_keyword, emoticons=_emoticons)


class EmojiKeywordsDifference(TLObject):
    CONSTRUCTOR_ID = 0x5cc761bd
    SUBCLASS_OF_ID = 0xd279c672

    def __init__(self, lang_code: str, from_version: int, version: int, keywords: List['TypeEmojiKeyword']):
        """
        Constructor for EmojiKeywordsDifference: Instance of EmojiKeywordsDifference.
        """
        self.lang_code = lang_code
        self.from_version = from_version
        self.version = version
        self.keywords = keywords

    def to_dict(self):
        return {
            '_': 'EmojiKeywordsDifference',
            'lang_code': self.lang_code,
            'from_version': self.from_version,
            'version': self.version,
            'keywords': [] if self.keywords is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.keywords]
        }

    def _bytes(self):
        return b''.join((
            b'\xbda\xc7\\',
            self.serialize_bytes(self.lang_code),
            struct.pack('<i', self.from_version),
            struct.pack('<i', self.version),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.keywords)),b''.join(x._bytes() for x in self.keywords),
        ))

    @classmethod
    def from_reader(cls, reader):
        _lang_code = reader.tgread_string()
        _from_version = reader.read_int()
        _version = reader.read_int()
        reader.read_int()
        _keywords = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _keywords.append(_x)

        return cls(lang_code=_lang_code, from_version=_from_version, version=_version, keywords=_keywords)


class EmojiLanguage(TLObject):
    CONSTRUCTOR_ID = 0xb3fb5361
    SUBCLASS_OF_ID = 0xa48d04ee

    def __init__(self, lang_code: str):
        """
        Constructor for EmojiLanguage: Instance of EmojiLanguage.
        """
        self.lang_code = lang_code

    def to_dict(self):
        return {
            '_': 'EmojiLanguage',
            'lang_code': self.lang_code
        }

    def _bytes(self):
        return b''.join((
            b'aS\xfb\xb3',
            self.serialize_bytes(self.lang_code),
        ))

    @classmethod
    def from_reader(cls, reader):
        _lang_code = reader.tgread_string()
        return cls(lang_code=_lang_code)


class EmojiList(TLObject):
    CONSTRUCTOR_ID = 0x7a1e11d1
    SUBCLASS_OF_ID = 0xbcef6aba

    # noinspection PyShadowingBuiltins
    def __init__(self, hash: int, document_id: List[int]):
        """
        Constructor for EmojiList: Instance of either EmojiListNotModified, EmojiList.
        """
        self.hash = hash
        self.document_id = document_id

    def to_dict(self):
        return {
            '_': 'EmojiList',
            'hash': self.hash,
            'document_id': [] if self.document_id is None else self.document_id[:]
        }

    def _bytes(self):
        return b''.join((
            b'\xd1\x11\x1ez',
            struct.pack('<q', self.hash),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.document_id)),b''.join(struct.pack('<q', x) for x in self.document_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _hash = reader.read_long()
        reader.read_int()
        _document_id = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _document_id.append(_x)

        return cls(hash=_hash, document_id=_document_id)


class EmojiListNotModified(TLObject):
    CONSTRUCTOR_ID = 0x481eadfa
    SUBCLASS_OF_ID = 0xbcef6aba

    def to_dict(self):
        return {
            '_': 'EmojiListNotModified'
        }

    def _bytes(self):
        return b''.join((
            b'\xfa\xad\x1eH',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class EmojiStatus(TLObject):
    CONSTRUCTOR_ID = 0x929b619d
    SUBCLASS_OF_ID = 0xf930b138

    def __init__(self, document_id: int):
        """
        Constructor for EmojiStatus: Instance of either EmojiStatusEmpty, EmojiStatus, EmojiStatusUntil.
        """
        self.document_id = document_id

    def to_dict(self):
        return {
            '_': 'EmojiStatus',
            'document_id': self.document_id
        }

    def _bytes(self):
        return b''.join((
            b'\x9da\x9b\x92',
            struct.pack('<q', self.document_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _document_id = reader.read_long()
        return cls(document_id=_document_id)


class EmojiStatusEmpty(TLObject):
    CONSTRUCTOR_ID = 0x2de11aae
    SUBCLASS_OF_ID = 0xf930b138

    def to_dict(self):
        return {
            '_': 'EmojiStatusEmpty'
        }

    def _bytes(self):
        return b''.join((
            b'\xae\x1a\xe1-',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class EmojiStatusUntil(TLObject):
    CONSTRUCTOR_ID = 0xfa30a8c7
    SUBCLASS_OF_ID = 0xf930b138

    def __init__(self, document_id: int, until: Optional[datetime]):
        """
        Constructor for EmojiStatus: Instance of either EmojiStatusEmpty, EmojiStatus, EmojiStatusUntil.
        """
        self.document_id = document_id
        self.until = until

    def to_dict(self):
        return {
            '_': 'EmojiStatusUntil',
            'document_id': self.document_id,
            'until': self.until
        }

    def _bytes(self):
        return b''.join((
            b'\xc7\xa80\xfa',
            struct.pack('<q', self.document_id),
            self.serialize_datetime(self.until),
        ))

    @classmethod
    def from_reader(cls, reader):
        _document_id = reader.read_long()
        _until = reader.tgread_date()
        return cls(document_id=_document_id, until=_until)


class EmojiURL(TLObject):
    CONSTRUCTOR_ID = 0xa575739d
    SUBCLASS_OF_ID = 0x1fa08a19

    def __init__(self, url: str):
        """
        Constructor for EmojiURL: Instance of EmojiURL.
        """
        self.url = url

    def to_dict(self):
        return {
            '_': 'EmojiURL',
            'url': self.url
        }

    def _bytes(self):
        return b''.join((
            b'\x9dsu\xa5',
            self.serialize_bytes(self.url),
        ))

    @classmethod
    def from_reader(cls, reader):
        _url = reader.tgread_string()
        return cls(url=_url)


class EncryptedChat(TLObject):
    CONSTRUCTOR_ID = 0x61f0d4c7
    SUBCLASS_OF_ID = 0x6d28a37a

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, date: Optional[datetime], admin_id: int, participant_id: int, g_a_or_b: bytes, key_fingerprint: int):
        """
        Constructor for EncryptedChat: Instance of either EncryptedChatEmpty, EncryptedChatWaiting, EncryptedChatRequested, EncryptedChat, EncryptedChatDiscarded.
        """
        self.id = id
        self.access_hash = access_hash
        self.date = date
        self.admin_id = admin_id
        self.participant_id = participant_id
        self.g_a_or_b = g_a_or_b
        self.key_fingerprint = key_fingerprint

    def to_dict(self):
        return {
            '_': 'EncryptedChat',
            'id': self.id,
            'access_hash': self.access_hash,
            'date': self.date,
            'admin_id': self.admin_id,
            'participant_id': self.participant_id,
            'g_a_or_b': self.g_a_or_b,
            'key_fingerprint': self.key_fingerprint
        }

    def _bytes(self):
        return b''.join((
            b'\xc7\xd4\xf0a',
            struct.pack('<i', self.id),
            struct.pack('<q', self.access_hash),
            self.serialize_datetime(self.date),
            struct.pack('<q', self.admin_id),
            struct.pack('<q', self.participant_id),
            self.serialize_bytes(self.g_a_or_b),
            struct.pack('<q', self.key_fingerprint),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_int()
        _access_hash = reader.read_long()
        _date = reader.tgread_date()
        _admin_id = reader.read_long()
        _participant_id = reader.read_long()
        _g_a_or_b = reader.tgread_bytes()
        _key_fingerprint = reader.read_long()
        return cls(id=_id, access_hash=_access_hash, date=_date, admin_id=_admin_id, participant_id=_participant_id, g_a_or_b=_g_a_or_b, key_fingerprint=_key_fingerprint)


class EncryptedChatDiscarded(TLObject):
    CONSTRUCTOR_ID = 0x1e1c7c45
    SUBCLASS_OF_ID = 0x6d28a37a

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, history_deleted: Optional[bool]=None):
        """
        Constructor for EncryptedChat: Instance of either EncryptedChatEmpty, EncryptedChatWaiting, EncryptedChatRequested, EncryptedChat, EncryptedChatDiscarded.
        """
        self.id = id
        self.history_deleted = history_deleted

    def to_dict(self):
        return {
            '_': 'EncryptedChatDiscarded',
            'id': self.id,
            'history_deleted': self.history_deleted
        }

    def _bytes(self):
        return b''.join((
            b'E|\x1c\x1e',
            struct.pack('<I', (0 if self.history_deleted is None or self.history_deleted is False else 1)),
            struct.pack('<i', self.id),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _history_deleted = bool(flags & 1)
        _id = reader.read_int()
        return cls(id=_id, history_deleted=_history_deleted)


class EncryptedChatEmpty(TLObject):
    CONSTRUCTOR_ID = 0xab7ec0a0
    SUBCLASS_OF_ID = 0x6d28a37a

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int):
        """
        Constructor for EncryptedChat: Instance of either EncryptedChatEmpty, EncryptedChatWaiting, EncryptedChatRequested, EncryptedChat, EncryptedChatDiscarded.
        """
        self.id = id

    def to_dict(self):
        return {
            '_': 'EncryptedChatEmpty',
            'id': self.id
        }

    def _bytes(self):
        return b''.join((
            b'\xa0\xc0~\xab',
            struct.pack('<i', self.id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_int()
        return cls(id=_id)


class EncryptedChatRequested(TLObject):
    CONSTRUCTOR_ID = 0x48f1d94c
    SUBCLASS_OF_ID = 0x6d28a37a

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, date: Optional[datetime], admin_id: int, participant_id: int, g_a: bytes, folder_id: Optional[int]=None):
        """
        Constructor for EncryptedChat: Instance of either EncryptedChatEmpty, EncryptedChatWaiting, EncryptedChatRequested, EncryptedChat, EncryptedChatDiscarded.
        """
        self.id = id
        self.access_hash = access_hash
        self.date = date
        self.admin_id = admin_id
        self.participant_id = participant_id
        self.g_a = g_a
        self.folder_id = folder_id

    def to_dict(self):
        return {
            '_': 'EncryptedChatRequested',
            'id': self.id,
            'access_hash': self.access_hash,
            'date': self.date,
            'admin_id': self.admin_id,
            'participant_id': self.participant_id,
            'g_a': self.g_a,
            'folder_id': self.folder_id
        }

    def _bytes(self):
        return b''.join((
            b'L\xd9\xf1H',
            struct.pack('<I', (0 if self.folder_id is None or self.folder_id is False else 1)),
            b'' if self.folder_id is None or self.folder_id is False else (struct.pack('<i', self.folder_id)),
            struct.pack('<i', self.id),
            struct.pack('<q', self.access_hash),
            self.serialize_datetime(self.date),
            struct.pack('<q', self.admin_id),
            struct.pack('<q', self.participant_id),
            self.serialize_bytes(self.g_a),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 1:
            _folder_id = reader.read_int()
        else:
            _folder_id = None
        _id = reader.read_int()
        _access_hash = reader.read_long()
        _date = reader.tgread_date()
        _admin_id = reader.read_long()
        _participant_id = reader.read_long()
        _g_a = reader.tgread_bytes()
        return cls(id=_id, access_hash=_access_hash, date=_date, admin_id=_admin_id, participant_id=_participant_id, g_a=_g_a, folder_id=_folder_id)


class EncryptedChatWaiting(TLObject):
    CONSTRUCTOR_ID = 0x66b25953
    SUBCLASS_OF_ID = 0x6d28a37a

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, date: Optional[datetime], admin_id: int, participant_id: int):
        """
        Constructor for EncryptedChat: Instance of either EncryptedChatEmpty, EncryptedChatWaiting, EncryptedChatRequested, EncryptedChat, EncryptedChatDiscarded.
        """
        self.id = id
        self.access_hash = access_hash
        self.date = date
        self.admin_id = admin_id
        self.participant_id = participant_id

    def to_dict(self):
        return {
            '_': 'EncryptedChatWaiting',
            'id': self.id,
            'access_hash': self.access_hash,
            'date': self.date,
            'admin_id': self.admin_id,
            'participant_id': self.participant_id
        }

    def _bytes(self):
        return b''.join((
            b'SY\xb2f',
            struct.pack('<i', self.id),
            struct.pack('<q', self.access_hash),
            self.serialize_datetime(self.date),
            struct.pack('<q', self.admin_id),
            struct.pack('<q', self.participant_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_int()
        _access_hash = reader.read_long()
        _date = reader.tgread_date()
        _admin_id = reader.read_long()
        _participant_id = reader.read_long()
        return cls(id=_id, access_hash=_access_hash, date=_date, admin_id=_admin_id, participant_id=_participant_id)


class EncryptedFile(TLObject):
    CONSTRUCTOR_ID = 0xa8008cd8
    SUBCLASS_OF_ID = 0x842a67c0

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, size: int, dc_id: int, key_fingerprint: int):
        """
        Constructor for EncryptedFile: Instance of either EncryptedFileEmpty, EncryptedFile.
        """
        self.id = id
        self.access_hash = access_hash
        self.size = size
        self.dc_id = dc_id
        self.key_fingerprint = key_fingerprint

    def to_dict(self):
        return {
            '_': 'EncryptedFile',
            'id': self.id,
            'access_hash': self.access_hash,
            'size': self.size,
            'dc_id': self.dc_id,
            'key_fingerprint': self.key_fingerprint
        }

    def _bytes(self):
        return b''.join((
            b'\xd8\x8c\x00\xa8',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            struct.pack('<q', self.size),
            struct.pack('<i', self.dc_id),
            struct.pack('<i', self.key_fingerprint),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        _size = reader.read_long()
        _dc_id = reader.read_int()
        _key_fingerprint = reader.read_int()
        return cls(id=_id, access_hash=_access_hash, size=_size, dc_id=_dc_id, key_fingerprint=_key_fingerprint)


class EncryptedFileEmpty(TLObject):
    CONSTRUCTOR_ID = 0xc21f497e
    SUBCLASS_OF_ID = 0x842a67c0

    def to_dict(self):
        return {
            '_': 'EncryptedFileEmpty'
        }

    def _bytes(self):
        return b''.join((
            b'~I\x1f\xc2',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class EncryptedMessage(TLObject):
    CONSTRUCTOR_ID = 0xed18c118
    SUBCLASS_OF_ID = 0x239f2e51

    # noinspection PyShadowingBuiltins
    def __init__(self, chat_id: int, date: Optional[datetime], bytes: bytes, file: 'TypeEncryptedFile', random_id: int=None):
        """
        Constructor for EncryptedMessage: Instance of either EncryptedMessage, EncryptedMessageService.
        """
        self.chat_id = chat_id
        self.date = date
        self.bytes = bytes
        self.file = file
        self.random_id = random_id if random_id is not None else int.from_bytes(os.urandom(8), 'big', signed=True)

    def to_dict(self):
        return {
            '_': 'EncryptedMessage',
            'chat_id': self.chat_id,
            'date': self.date,
            'bytes': self.bytes,
            'file': self.file.to_dict() if isinstance(self.file, TLObject) else self.file,
            'random_id': self.random_id
        }

    def _bytes(self):
        return b''.join((
            b'\x18\xc1\x18\xed',
            struct.pack('<q', self.random_id),
            struct.pack('<i', self.chat_id),
            self.serialize_datetime(self.date),
            self.serialize_bytes(self.bytes),
            self.file._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _random_id = reader.read_long()
        _chat_id = reader.read_int()
        _date = reader.tgread_date()
        _bytes = reader.tgread_bytes()
        _file = reader.tgread_object()
        return cls(chat_id=_chat_id, date=_date, bytes=_bytes, file=_file, random_id=_random_id)


class EncryptedMessageService(TLObject):
    CONSTRUCTOR_ID = 0x23734b06
    SUBCLASS_OF_ID = 0x239f2e51

    # noinspection PyShadowingBuiltins
    def __init__(self, chat_id: int, date: Optional[datetime], bytes: bytes, random_id: int=None):
        """
        Constructor for EncryptedMessage: Instance of either EncryptedMessage, EncryptedMessageService.
        """
        self.chat_id = chat_id
        self.date = date
        self.bytes = bytes
        self.random_id = random_id if random_id is not None else int.from_bytes(os.urandom(8), 'big', signed=True)

    def to_dict(self):
        return {
            '_': 'EncryptedMessageService',
            'chat_id': self.chat_id,
            'date': self.date,
            'bytes': self.bytes,
            'random_id': self.random_id
        }

    def _bytes(self):
        return b''.join((
            b'\x06Ks#',
            struct.pack('<q', self.random_id),
            struct.pack('<i', self.chat_id),
            self.serialize_datetime(self.date),
            self.serialize_bytes(self.bytes),
        ))

    @classmethod
    def from_reader(cls, reader):
        _random_id = reader.read_long()
        _chat_id = reader.read_int()
        _date = reader.tgread_date()
        _bytes = reader.tgread_bytes()
        return cls(chat_id=_chat_id, date=_date, bytes=_bytes, random_id=_random_id)


class ExportedChatlistInvite(TLObject):
    CONSTRUCTOR_ID = 0xc5181ac
    SUBCLASS_OF_ID = 0x7711f8ff

    def __init__(self, title: str, url: str, peers: List['TypePeer']):
        """
        Constructor for ExportedChatlistInvite: Instance of ExportedChatlistInvite.
        """
        self.title = title
        self.url = url
        self.peers = peers

    def to_dict(self):
        return {
            '_': 'ExportedChatlistInvite',
            'title': self.title,
            'url': self.url,
            'peers': [] if self.peers is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.peers]
        }

    def _bytes(self):
        return b''.join((
            b'\xac\x81Q\x0c',
            b'\0\0\0\0',
            self.serialize_bytes(self.title),
            self.serialize_bytes(self.url),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.peers)),b''.join(x._bytes() for x in self.peers),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _title = reader.tgread_string()
        _url = reader.tgread_string()
        reader.read_int()
        _peers = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _peers.append(_x)

        return cls(title=_title, url=_url, peers=_peers)


class ExportedContactToken(TLObject):
    CONSTRUCTOR_ID = 0x41bf109b
    SUBCLASS_OF_ID = 0x86ddbed1

    def __init__(self, url: str, expires: Optional[datetime]):
        """
        Constructor for ExportedContactToken: Instance of ExportedContactToken.
        """
        self.url = url
        self.expires = expires

    def to_dict(self):
        return {
            '_': 'ExportedContactToken',
            'url': self.url,
            'expires': self.expires
        }

    def _bytes(self):
        return b''.join((
            b'\x9b\x10\xbfA',
            self.serialize_bytes(self.url),
            self.serialize_datetime(self.expires),
        ))

    @classmethod
    def from_reader(cls, reader):
        _url = reader.tgread_string()
        _expires = reader.tgread_date()
        return cls(url=_url, expires=_expires)


class ExportedMessageLink(TLObject):
    CONSTRUCTOR_ID = 0x5dab1af4
    SUBCLASS_OF_ID = 0xdee644cc

    def __init__(self, link: str, html: str):
        """
        Constructor for ExportedMessageLink: Instance of ExportedMessageLink.
        """
        self.link = link
        self.html = html

    def to_dict(self):
        return {
            '_': 'ExportedMessageLink',
            'link': self.link,
            'html': self.html
        }

    def _bytes(self):
        return b''.join((
            b'\xf4\x1a\xab]',
            self.serialize_bytes(self.link),
            self.serialize_bytes(self.html),
        ))

    @classmethod
    def from_reader(cls, reader):
        _link = reader.tgread_string()
        _html = reader.tgread_string()
        return cls(link=_link, html=_html)


class ExportedStoryLink(TLObject):
    CONSTRUCTOR_ID = 0x3fc9053b
    SUBCLASS_OF_ID = 0xfc541a6

    def __init__(self, link: str):
        """
        Constructor for ExportedStoryLink: Instance of ExportedStoryLink.
        """
        self.link = link

    def to_dict(self):
        return {
            '_': 'ExportedStoryLink',
            'link': self.link
        }

    def _bytes(self):
        return b''.join((
            b';\x05\xc9?',
            self.serialize_bytes(self.link),
        ))

    @classmethod
    def from_reader(cls, reader):
        _link = reader.tgread_string()
        return cls(link=_link)


class FileHash(TLObject):
    CONSTRUCTOR_ID = 0xf39b035c
    SUBCLASS_OF_ID = 0xead438b3

    # noinspection PyShadowingBuiltins
    def __init__(self, offset: int, limit: int, hash: bytes):
        """
        Constructor for FileHash: Instance of FileHash.
        """
        self.offset = offset
        self.limit = limit
        self.hash = hash

    def to_dict(self):
        return {
            '_': 'FileHash',
            'offset': self.offset,
            'limit': self.limit,
            'hash': self.hash
        }

    def _bytes(self):
        return b''.join((
            b'\\\x03\x9b\xf3',
            struct.pack('<q', self.offset),
            struct.pack('<i', self.limit),
            self.serialize_bytes(self.hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _offset = reader.read_long()
        _limit = reader.read_int()
        _hash = reader.tgread_bytes()
        return cls(offset=_offset, limit=_limit, hash=_hash)


class Folder(TLObject):
    CONSTRUCTOR_ID = 0xff544e65
    SUBCLASS_OF_ID = 0xeb0e0cfb

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, title: str, autofill_new_broadcasts: Optional[bool]=None, autofill_public_groups: Optional[bool]=None, autofill_new_correspondents: Optional[bool]=None, photo: Optional['TypeChatPhoto']=None):
        """
        Constructor for Folder: Instance of Folder.
        """
        self.id = id
        self.title = title
        self.autofill_new_broadcasts = autofill_new_broadcasts
        self.autofill_public_groups = autofill_public_groups
        self.autofill_new_correspondents = autofill_new_correspondents
        self.photo = photo

    def to_dict(self):
        return {
            '_': 'Folder',
            'id': self.id,
            'title': self.title,
            'autofill_new_broadcasts': self.autofill_new_broadcasts,
            'autofill_public_groups': self.autofill_public_groups,
            'autofill_new_correspondents': self.autofill_new_correspondents,
            'photo': self.photo.to_dict() if isinstance(self.photo, TLObject) else self.photo
        }

    def _bytes(self):
        return b''.join((
            b'eNT\xff',
            struct.pack('<I', (0 if self.autofill_new_broadcasts is None or self.autofill_new_broadcasts is False else 1) | (0 if self.autofill_public_groups is None or self.autofill_public_groups is False else 2) | (0 if self.autofill_new_correspondents is None or self.autofill_new_correspondents is False else 4) | (0 if self.photo is None or self.photo is False else 8)),
            struct.pack('<i', self.id),
            self.serialize_bytes(self.title),
            b'' if self.photo is None or self.photo is False else (self.photo._bytes()),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _autofill_new_broadcasts = bool(flags & 1)
        _autofill_public_groups = bool(flags & 2)
        _autofill_new_correspondents = bool(flags & 4)
        _id = reader.read_int()
        _title = reader.tgread_string()
        if flags & 8:
            _photo = reader.tgread_object()
        else:
            _photo = None
        return cls(id=_id, title=_title, autofill_new_broadcasts=_autofill_new_broadcasts, autofill_public_groups=_autofill_public_groups, autofill_new_correspondents=_autofill_new_correspondents, photo=_photo)


class FolderPeer(TLObject):
    CONSTRUCTOR_ID = 0xe9baa668
    SUBCLASS_OF_ID = 0xf3f2283b

    def __init__(self, peer: 'TypePeer', folder_id: int):
        """
        Constructor for FolderPeer: Instance of FolderPeer.
        """
        self.peer = peer
        self.folder_id = folder_id

    def to_dict(self):
        return {
            '_': 'FolderPeer',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'folder_id': self.folder_id
        }

    def _bytes(self):
        return b''.join((
            b'h\xa6\xba\xe9',
            self.peer._bytes(),
            struct.pack('<i', self.folder_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _folder_id = reader.read_int()
        return cls(peer=_peer, folder_id=_folder_id)


class ForumTopic(TLObject):
    CONSTRUCTOR_ID = 0x71701da9
    SUBCLASS_OF_ID = 0x8d182203

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, date: Optional[datetime], title: str, icon_color: int, top_message: int, read_inbox_max_id: int, read_outbox_max_id: int, unread_count: int, unread_mentions_count: int, unread_reactions_count: int, from_id: 'TypePeer', notify_settings: 'TypePeerNotifySettings', my: Optional[bool]=None, closed: Optional[bool]=None, pinned: Optional[bool]=None, short: Optional[bool]=None, hidden: Optional[bool]=None, icon_emoji_id: Optional[int]=None, draft: Optional['TypeDraftMessage']=None):
        """
        Constructor for ForumTopic: Instance of either ForumTopicDeleted, ForumTopic.
        """
        self.id = id
        self.date = date
        self.title = title
        self.icon_color = icon_color
        self.top_message = top_message
        self.read_inbox_max_id = read_inbox_max_id
        self.read_outbox_max_id = read_outbox_max_id
        self.unread_count = unread_count
        self.unread_mentions_count = unread_mentions_count
        self.unread_reactions_count = unread_reactions_count
        self.from_id = from_id
        self.notify_settings = notify_settings
        self.my = my
        self.closed = closed
        self.pinned = pinned
        self.short = short
        self.hidden = hidden
        self.icon_emoji_id = icon_emoji_id
        self.draft = draft

    def to_dict(self):
        return {
            '_': 'ForumTopic',
            'id': self.id,
            'date': self.date,
            'title': self.title,
            'icon_color': self.icon_color,
            'top_message': self.top_message,
            'read_inbox_max_id': self.read_inbox_max_id,
            'read_outbox_max_id': self.read_outbox_max_id,
            'unread_count': self.unread_count,
            'unread_mentions_count': self.unread_mentions_count,
            'unread_reactions_count': self.unread_reactions_count,
            'from_id': self.from_id.to_dict() if isinstance(self.from_id, TLObject) else self.from_id,
            'notify_settings': self.notify_settings.to_dict() if isinstance(self.notify_settings, TLObject) else self.notify_settings,
            'my': self.my,
            'closed': self.closed,
            'pinned': self.pinned,
            'short': self.short,
            'hidden': self.hidden,
            'icon_emoji_id': self.icon_emoji_id,
            'draft': self.draft.to_dict() if isinstance(self.draft, TLObject) else self.draft
        }

    def _bytes(self):
        return b''.join((
            b'\xa9\x1dpq',
            struct.pack('<I', (0 if self.my is None or self.my is False else 2) | (0 if self.closed is None or self.closed is False else 4) | (0 if self.pinned is None or self.pinned is False else 8) | (0 if self.short is None or self.short is False else 32) | (0 if self.hidden is None or self.hidden is False else 64) | (0 if self.icon_emoji_id is None or self.icon_emoji_id is False else 1) | (0 if self.draft is None or self.draft is False else 16)),
            struct.pack('<i', self.id),
            self.serialize_datetime(self.date),
            self.serialize_bytes(self.title),
            struct.pack('<i', self.icon_color),
            b'' if self.icon_emoji_id is None or self.icon_emoji_id is False else (struct.pack('<q', self.icon_emoji_id)),
            struct.pack('<i', self.top_message),
            struct.pack('<i', self.read_inbox_max_id),
            struct.pack('<i', self.read_outbox_max_id),
            struct.pack('<i', self.unread_count),
            struct.pack('<i', self.unread_mentions_count),
            struct.pack('<i', self.unread_reactions_count),
            self.from_id._bytes(),
            self.notify_settings._bytes(),
            b'' if self.draft is None or self.draft is False else (self.draft._bytes()),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _my = bool(flags & 2)
        _closed = bool(flags & 4)
        _pinned = bool(flags & 8)
        _short = bool(flags & 32)
        _hidden = bool(flags & 64)
        _id = reader.read_int()
        _date = reader.tgread_date()
        _title = reader.tgread_string()
        _icon_color = reader.read_int()
        if flags & 1:
            _icon_emoji_id = reader.read_long()
        else:
            _icon_emoji_id = None
        _top_message = reader.read_int()
        _read_inbox_max_id = reader.read_int()
        _read_outbox_max_id = reader.read_int()
        _unread_count = reader.read_int()
        _unread_mentions_count = reader.read_int()
        _unread_reactions_count = reader.read_int()
        _from_id = reader.tgread_object()
        _notify_settings = reader.tgread_object()
        if flags & 16:
            _draft = reader.tgread_object()
        else:
            _draft = None
        return cls(id=_id, date=_date, title=_title, icon_color=_icon_color, top_message=_top_message, read_inbox_max_id=_read_inbox_max_id, read_outbox_max_id=_read_outbox_max_id, unread_count=_unread_count, unread_mentions_count=_unread_mentions_count, unread_reactions_count=_unread_reactions_count, from_id=_from_id, notify_settings=_notify_settings, my=_my, closed=_closed, pinned=_pinned, short=_short, hidden=_hidden, icon_emoji_id=_icon_emoji_id, draft=_draft)


class ForumTopicDeleted(TLObject):
    CONSTRUCTOR_ID = 0x23f109b
    SUBCLASS_OF_ID = 0x8d182203

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int):
        """
        Constructor for ForumTopic: Instance of either ForumTopicDeleted, ForumTopic.
        """
        self.id = id

    def to_dict(self):
        return {
            '_': 'ForumTopicDeleted',
            'id': self.id
        }

    def _bytes(self):
        return b''.join((
            b'\x9b\x10?\x02',
            struct.pack('<i', self.id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_int()
        return cls(id=_id)


class FutureSalt(TLObject):
    CONSTRUCTOR_ID = 0x949d9dc
    SUBCLASS_OF_ID = 0x45e53dcf

    def __init__(self, valid_since: Optional[datetime], valid_until: Optional[datetime], salt: int):
        """
        Constructor for FutureSalt: Instance of FutureSalt.
        """
        self.valid_since = valid_since
        self.valid_until = valid_until
        self.salt = salt

    def to_dict(self):
        return {
            '_': 'FutureSalt',
            'valid_since': self.valid_since,
            'valid_until': self.valid_until,
            'salt': self.salt
        }

    def _bytes(self):
        return b''.join((
            b'\xdc\xd9I\t',
            self.serialize_datetime(self.valid_since),
            self.serialize_datetime(self.valid_until),
            struct.pack('<q', self.salt),
        ))

    @classmethod
    def from_reader(cls, reader):
        _valid_since = reader.tgread_date()
        _valid_until = reader.tgread_date()
        _salt = reader.read_long()
        return cls(valid_since=_valid_since, valid_until=_valid_until, salt=_salt)


class FutureSalts(TLObject):
    CONSTRUCTOR_ID = 0xae500895
    SUBCLASS_OF_ID = 0x1090f517

    def __init__(self, req_msg_id: int, now: int, salts: List['Typefuture_salt']):
        """
        Constructor for FutureSalts: Instance of FutureSalts.
        """
        self.req_msg_id = req_msg_id
        self.now = now
        self.salts = salts

    def to_dict(self):
        return {
            '_': 'FutureSalts',
            'req_msg_id': self.req_msg_id,
            'now': self.now,
            'salts': [] if self.salts is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.salts]
        }

    def _bytes(self):
        return b''.join((
            b'\x95\x08P\xae',
            struct.pack('<q', self.req_msg_id),
            struct.pack('<i', self.now),
            struct.pack('<i', len(self.salts)),b''.join(x._bytes()[4:] for x in self.salts),
        ))

    @classmethod
    def from_reader(cls, reader):
        _req_msg_id = reader.read_long()
        _now = reader.read_int()
        _salts = []
        for _ in range(reader.read_int()):
            from . import FutureSalt
            _x = FutureSalt.from_reader(reader)
            _salts.append(_x)

        return cls(req_msg_id=_req_msg_id, now=_now, salts=_salts)


class Game(TLObject):
    CONSTRUCTOR_ID = 0xbdf9653b
    SUBCLASS_OF_ID = 0x83199eb2

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, short_name: str, title: str, description: str, photo: 'TypePhoto', document: Optional['TypeDocument']=None):
        """
        Constructor for Game: Instance of Game.
        """
        self.id = id
        self.access_hash = access_hash
        self.short_name = short_name
        self.title = title
        self.description = description
        self.photo = photo
        self.document = document

    def to_dict(self):
        return {
            '_': 'Game',
            'id': self.id,
            'access_hash': self.access_hash,
            'short_name': self.short_name,
            'title': self.title,
            'description': self.description,
            'photo': self.photo.to_dict() if isinstance(self.photo, TLObject) else self.photo,
            'document': self.document.to_dict() if isinstance(self.document, TLObject) else self.document
        }

    def _bytes(self):
        return b''.join((
            b';e\xf9\xbd',
            struct.pack('<I', (0 if self.document is None or self.document is False else 1)),
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            self.serialize_bytes(self.short_name),
            self.serialize_bytes(self.title),
            self.serialize_bytes(self.description),
            self.photo._bytes(),
            b'' if self.document is None or self.document is False else (self.document._bytes()),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _id = reader.read_long()
        _access_hash = reader.read_long()
        _short_name = reader.tgread_string()
        _title = reader.tgread_string()
        _description = reader.tgread_string()
        _photo = reader.tgread_object()
        if flags & 1:
            _document = reader.tgread_object()
        else:
            _document = None
        return cls(id=_id, access_hash=_access_hash, short_name=_short_name, title=_title, description=_description, photo=_photo, document=_document)


class GeoPoint(TLObject):
    CONSTRUCTOR_ID = 0xb2a2f663
    SUBCLASS_OF_ID = 0xd610e16d

    def __init__(self, long: float, lat: float, access_hash: int, accuracy_radius: Optional[int]=None):
        """
        Constructor for GeoPoint: Instance of either GeoPointEmpty, GeoPoint.
        """
        self.long = long
        self.lat = lat
        self.access_hash = access_hash
        self.accuracy_radius = accuracy_radius

    def to_dict(self):
        return {
            '_': 'GeoPoint',
            'long': self.long,
            'lat': self.lat,
            'access_hash': self.access_hash,
            'accuracy_radius': self.accuracy_radius
        }

    def _bytes(self):
        return b''.join((
            b'c\xf6\xa2\xb2',
            struct.pack('<I', (0 if self.accuracy_radius is None or self.accuracy_radius is False else 1)),
            struct.pack('<d', self.long),
            struct.pack('<d', self.lat),
            struct.pack('<q', self.access_hash),
            b'' if self.accuracy_radius is None or self.accuracy_radius is False else (struct.pack('<i', self.accuracy_radius)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _long = reader.read_double()
        _lat = reader.read_double()
        _access_hash = reader.read_long()
        if flags & 1:
            _accuracy_radius = reader.read_int()
        else:
            _accuracy_radius = None
        return cls(long=_long, lat=_lat, access_hash=_access_hash, accuracy_radius=_accuracy_radius)


class GeoPointEmpty(TLObject):
    CONSTRUCTOR_ID = 0x1117dd5f
    SUBCLASS_OF_ID = 0xd610e16d

    def to_dict(self):
        return {
            '_': 'GeoPointEmpty'
        }

    def _bytes(self):
        return b''.join((
            b'_\xdd\x17\x11',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class GlobalPrivacySettings(TLObject):
    CONSTRUCTOR_ID = 0x734c4ccb
    SUBCLASS_OF_ID = 0xc90e5770

    def __init__(self, archive_and_mute_new_noncontact_peers: Optional[bool]=None, keep_archived_unmuted: Optional[bool]=None, keep_archived_folders: Optional[bool]=None):
        """
        Constructor for GlobalPrivacySettings: Instance of GlobalPrivacySettings.
        """
        self.archive_and_mute_new_noncontact_peers = archive_and_mute_new_noncontact_peers
        self.keep_archived_unmuted = keep_archived_unmuted
        self.keep_archived_folders = keep_archived_folders

    def to_dict(self):
        return {
            '_': 'GlobalPrivacySettings',
            'archive_and_mute_new_noncontact_peers': self.archive_and_mute_new_noncontact_peers,
            'keep_archived_unmuted': self.keep_archived_unmuted,
            'keep_archived_folders': self.keep_archived_folders
        }

    def _bytes(self):
        return b''.join((
            b'\xcbLLs',
            struct.pack('<I', (0 if self.archive_and_mute_new_noncontact_peers is None or self.archive_and_mute_new_noncontact_peers is False else 1) | (0 if self.keep_archived_unmuted is None or self.keep_archived_unmuted is False else 2) | (0 if self.keep_archived_folders is None or self.keep_archived_folders is False else 4)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _archive_and_mute_new_noncontact_peers = bool(flags & 1)
        _keep_archived_unmuted = bool(flags & 2)
        _keep_archived_folders = bool(flags & 4)
        return cls(archive_and_mute_new_noncontact_peers=_archive_and_mute_new_noncontact_peers, keep_archived_unmuted=_keep_archived_unmuted, keep_archived_folders=_keep_archived_folders)


class GroupCall(TLObject):
    CONSTRUCTOR_ID = 0xd597650c
    SUBCLASS_OF_ID = 0x20b4f320

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, participants_count: int, unmuted_video_limit: int, version: int, join_muted: Optional[bool]=None, can_change_join_muted: Optional[bool]=None, join_date_asc: Optional[bool]=None, schedule_start_subscribed: Optional[bool]=None, can_start_video: Optional[bool]=None, record_video_active: Optional[bool]=None, rtmp_stream: Optional[bool]=None, listeners_hidden: Optional[bool]=None, title: Optional[str]=None, stream_dc_id: Optional[int]=None, record_start_date: Optional[datetime]=None, schedule_date: Optional[datetime]=None, unmuted_video_count: Optional[int]=None):
        """
        Constructor for GroupCall: Instance of either GroupCallDiscarded, GroupCall.
        """
        self.id = id
        self.access_hash = access_hash
        self.participants_count = participants_count
        self.unmuted_video_limit = unmuted_video_limit
        self.version = version
        self.join_muted = join_muted
        self.can_change_join_muted = can_change_join_muted
        self.join_date_asc = join_date_asc
        self.schedule_start_subscribed = schedule_start_subscribed
        self.can_start_video = can_start_video
        self.record_video_active = record_video_active
        self.rtmp_stream = rtmp_stream
        self.listeners_hidden = listeners_hidden
        self.title = title
        self.stream_dc_id = stream_dc_id
        self.record_start_date = record_start_date
        self.schedule_date = schedule_date
        self.unmuted_video_count = unmuted_video_count

    def to_dict(self):
        return {
            '_': 'GroupCall',
            'id': self.id,
            'access_hash': self.access_hash,
            'participants_count': self.participants_count,
            'unmuted_video_limit': self.unmuted_video_limit,
            'version': self.version,
            'join_muted': self.join_muted,
            'can_change_join_muted': self.can_change_join_muted,
            'join_date_asc': self.join_date_asc,
            'schedule_start_subscribed': self.schedule_start_subscribed,
            'can_start_video': self.can_start_video,
            'record_video_active': self.record_video_active,
            'rtmp_stream': self.rtmp_stream,
            'listeners_hidden': self.listeners_hidden,
            'title': self.title,
            'stream_dc_id': self.stream_dc_id,
            'record_start_date': self.record_start_date,
            'schedule_date': self.schedule_date,
            'unmuted_video_count': self.unmuted_video_count
        }

    def _bytes(self):
        return b''.join((
            b'\x0ce\x97\xd5',
            struct.pack('<I', (0 if self.join_muted is None or self.join_muted is False else 2) | (0 if self.can_change_join_muted is None or self.can_change_join_muted is False else 4) | (0 if self.join_date_asc is None or self.join_date_asc is False else 64) | (0 if self.schedule_start_subscribed is None or self.schedule_start_subscribed is False else 256) | (0 if self.can_start_video is None or self.can_start_video is False else 512) | (0 if self.record_video_active is None or self.record_video_active is False else 2048) | (0 if self.rtmp_stream is None or self.rtmp_stream is False else 4096) | (0 if self.listeners_hidden is None or self.listeners_hidden is False else 8192) | (0 if self.title is None or self.title is False else 8) | (0 if self.stream_dc_id is None or self.stream_dc_id is False else 16) | (0 if self.record_start_date is None or self.record_start_date is False else 32) | (0 if self.schedule_date is None or self.schedule_date is False else 128) | (0 if self.unmuted_video_count is None or self.unmuted_video_count is False else 1024)),
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            struct.pack('<i', self.participants_count),
            b'' if self.title is None or self.title is False else (self.serialize_bytes(self.title)),
            b'' if self.stream_dc_id is None or self.stream_dc_id is False else (struct.pack('<i', self.stream_dc_id)),
            b'' if self.record_start_date is None or self.record_start_date is False else (self.serialize_datetime(self.record_start_date)),
            b'' if self.schedule_date is None or self.schedule_date is False else (self.serialize_datetime(self.schedule_date)),
            b'' if self.unmuted_video_count is None or self.unmuted_video_count is False else (struct.pack('<i', self.unmuted_video_count)),
            struct.pack('<i', self.unmuted_video_limit),
            struct.pack('<i', self.version),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _join_muted = bool(flags & 2)
        _can_change_join_muted = bool(flags & 4)
        _join_date_asc = bool(flags & 64)
        _schedule_start_subscribed = bool(flags & 256)
        _can_start_video = bool(flags & 512)
        _record_video_active = bool(flags & 2048)
        _rtmp_stream = bool(flags & 4096)
        _listeners_hidden = bool(flags & 8192)
        _id = reader.read_long()
        _access_hash = reader.read_long()
        _participants_count = reader.read_int()
        if flags & 8:
            _title = reader.tgread_string()
        else:
            _title = None
        if flags & 16:
            _stream_dc_id = reader.read_int()
        else:
            _stream_dc_id = None
        if flags & 32:
            _record_start_date = reader.tgread_date()
        else:
            _record_start_date = None
        if flags & 128:
            _schedule_date = reader.tgread_date()
        else:
            _schedule_date = None
        if flags & 1024:
            _unmuted_video_count = reader.read_int()
        else:
            _unmuted_video_count = None
        _unmuted_video_limit = reader.read_int()
        _version = reader.read_int()
        return cls(id=_id, access_hash=_access_hash, participants_count=_participants_count, unmuted_video_limit=_unmuted_video_limit, version=_version, join_muted=_join_muted, can_change_join_muted=_can_change_join_muted, join_date_asc=_join_date_asc, schedule_start_subscribed=_schedule_start_subscribed, can_start_video=_can_start_video, record_video_active=_record_video_active, rtmp_stream=_rtmp_stream, listeners_hidden=_listeners_hidden, title=_title, stream_dc_id=_stream_dc_id, record_start_date=_record_start_date, schedule_date=_schedule_date, unmuted_video_count=_unmuted_video_count)


class GroupCallDiscarded(TLObject):
    CONSTRUCTOR_ID = 0x7780bcb4
    SUBCLASS_OF_ID = 0x20b4f320

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, duration: int):
        """
        Constructor for GroupCall: Instance of either GroupCallDiscarded, GroupCall.
        """
        self.id = id
        self.access_hash = access_hash
        self.duration = duration

    def to_dict(self):
        return {
            '_': 'GroupCallDiscarded',
            'id': self.id,
            'access_hash': self.access_hash,
            'duration': self.duration
        }

    def _bytes(self):
        return b''.join((
            b'\xb4\xbc\x80w',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            struct.pack('<i', self.duration),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        _duration = reader.read_int()
        return cls(id=_id, access_hash=_access_hash, duration=_duration)


class GroupCallParticipant(TLObject):
    CONSTRUCTOR_ID = 0xeba636fe
    SUBCLASS_OF_ID = 0xc01aaf4c

    # noinspection PyShadowingBuiltins
    def __init__(self, peer: 'TypePeer', date: Optional[datetime], source: int, muted: Optional[bool]=None, left: Optional[bool]=None, can_self_unmute: Optional[bool]=None, just_joined: Optional[bool]=None, versioned: Optional[bool]=None, min: Optional[bool]=None, muted_by_you: Optional[bool]=None, volume_by_admin: Optional[bool]=None, is_self: Optional[bool]=None, video_joined: Optional[bool]=None, active_date: Optional[datetime]=None, volume: Optional[int]=None, about: Optional[str]=None, raise_hand_rating: Optional[int]=None, video: Optional['TypeGroupCallParticipantVideo']=None, presentation: Optional['TypeGroupCallParticipantVideo']=None):
        """
        Constructor for GroupCallParticipant: Instance of GroupCallParticipant.
        """
        self.peer = peer
        self.date = date
        self.source = source
        self.muted = muted
        self.left = left
        self.can_self_unmute = can_self_unmute
        self.just_joined = just_joined
        self.versioned = versioned
        self.min = min
        self.muted_by_you = muted_by_you
        self.volume_by_admin = volume_by_admin
        self.is_self = is_self
        self.video_joined = video_joined
        self.active_date = active_date
        self.volume = volume
        self.about = about
        self.raise_hand_rating = raise_hand_rating
        self.video = video
        self.presentation = presentation

    def to_dict(self):
        return {
            '_': 'GroupCallParticipant',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'date': self.date,
            'source': self.source,
            'muted': self.muted,
            'left': self.left,
            'can_self_unmute': self.can_self_unmute,
            'just_joined': self.just_joined,
            'versioned': self.versioned,
            'min': self.min,
            'muted_by_you': self.muted_by_you,
            'volume_by_admin': self.volume_by_admin,
            'is_self': self.is_self,
            'video_joined': self.video_joined,
            'active_date': self.active_date,
            'volume': self.volume,
            'about': self.about,
            'raise_hand_rating': self.raise_hand_rating,
            'video': self.video.to_dict() if isinstance(self.video, TLObject) else self.video,
            'presentation': self.presentation.to_dict() if isinstance(self.presentation, TLObject) else self.presentation
        }

    def _bytes(self):
        return b''.join((
            b'\xfe6\xa6\xeb',
            struct.pack('<I', (0 if self.muted is None or self.muted is False else 1) | (0 if self.left is None or self.left is False else 2) | (0 if self.can_self_unmute is None or self.can_self_unmute is False else 4) | (0 if self.just_joined is None or self.just_joined is False else 16) | (0 if self.versioned is None or self.versioned is False else 32) | (0 if self.min is None or self.min is False else 256) | (0 if self.muted_by_you is None or self.muted_by_you is False else 512) | (0 if self.volume_by_admin is None or self.volume_by_admin is False else 1024) | (0 if self.is_self is None or self.is_self is False else 4096) | (0 if self.video_joined is None or self.video_joined is False else 32768) | (0 if self.active_date is None or self.active_date is False else 8) | (0 if self.volume is None or self.volume is False else 128) | (0 if self.about is None or self.about is False else 2048) | (0 if self.raise_hand_rating is None or self.raise_hand_rating is False else 8192) | (0 if self.video is None or self.video is False else 64) | (0 if self.presentation is None or self.presentation is False else 16384)),
            self.peer._bytes(),
            self.serialize_datetime(self.date),
            b'' if self.active_date is None or self.active_date is False else (self.serialize_datetime(self.active_date)),
            struct.pack('<i', self.source),
            b'' if self.volume is None or self.volume is False else (struct.pack('<i', self.volume)),
            b'' if self.about is None or self.about is False else (self.serialize_bytes(self.about)),
            b'' if self.raise_hand_rating is None or self.raise_hand_rating is False else (struct.pack('<q', self.raise_hand_rating)),
            b'' if self.video is None or self.video is False else (self.video._bytes()),
            b'' if self.presentation is None or self.presentation is False else (self.presentation._bytes()),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _muted = bool(flags & 1)
        _left = bool(flags & 2)
        _can_self_unmute = bool(flags & 4)
        _just_joined = bool(flags & 16)
        _versioned = bool(flags & 32)
        _min = bool(flags & 256)
        _muted_by_you = bool(flags & 512)
        _volume_by_admin = bool(flags & 1024)
        _is_self = bool(flags & 4096)
        _video_joined = bool(flags & 32768)
        _peer = reader.tgread_object()
        _date = reader.tgread_date()
        if flags & 8:
            _active_date = reader.tgread_date()
        else:
            _active_date = None
        _source = reader.read_int()
        if flags & 128:
            _volume = reader.read_int()
        else:
            _volume = None
        if flags & 2048:
            _about = reader.tgread_string()
        else:
            _about = None
        if flags & 8192:
            _raise_hand_rating = reader.read_long()
        else:
            _raise_hand_rating = None
        if flags & 64:
            _video = reader.tgread_object()
        else:
            _video = None
        if flags & 16384:
            _presentation = reader.tgread_object()
        else:
            _presentation = None
        return cls(peer=_peer, date=_date, source=_source, muted=_muted, left=_left, can_self_unmute=_can_self_unmute, just_joined=_just_joined, versioned=_versioned, min=_min, muted_by_you=_muted_by_you, volume_by_admin=_volume_by_admin, is_self=_is_self, video_joined=_video_joined, active_date=_active_date, volume=_volume, about=_about, raise_hand_rating=_raise_hand_rating, video=_video, presentation=_presentation)


class GroupCallParticipantVideo(TLObject):
    CONSTRUCTOR_ID = 0x67753ac8
    SUBCLASS_OF_ID = 0xef46b8db

    def __init__(self, endpoint: str, source_groups: List['TypeGroupCallParticipantVideoSourceGroup'], paused: Optional[bool]=None, audio_source: Optional[int]=None):
        """
        Constructor for GroupCallParticipantVideo: Instance of GroupCallParticipantVideo.
        """
        self.endpoint = endpoint
        self.source_groups = source_groups
        self.paused = paused
        self.audio_source = audio_source

    def to_dict(self):
        return {
            '_': 'GroupCallParticipantVideo',
            'endpoint': self.endpoint,
            'source_groups': [] if self.source_groups is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.source_groups],
            'paused': self.paused,
            'audio_source': self.audio_source
        }

    def _bytes(self):
        return b''.join((
            b'\xc8:ug',
            struct.pack('<I', (0 if self.paused is None or self.paused is False else 1) | (0 if self.audio_source is None or self.audio_source is False else 2)),
            self.serialize_bytes(self.endpoint),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.source_groups)),b''.join(x._bytes() for x in self.source_groups),
            b'' if self.audio_source is None or self.audio_source is False else (struct.pack('<i', self.audio_source)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _paused = bool(flags & 1)
        _endpoint = reader.tgread_string()
        reader.read_int()
        _source_groups = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _source_groups.append(_x)

        if flags & 2:
            _audio_source = reader.read_int()
        else:
            _audio_source = None
        return cls(endpoint=_endpoint, source_groups=_source_groups, paused=_paused, audio_source=_audio_source)


class GroupCallParticipantVideoSourceGroup(TLObject):
    CONSTRUCTOR_ID = 0xdcb118b7
    SUBCLASS_OF_ID = 0x3015f87c

    def __init__(self, semantics: str, sources: List[int]):
        """
        Constructor for GroupCallParticipantVideoSourceGroup: Instance of GroupCallParticipantVideoSourceGroup.
        """
        self.semantics = semantics
        self.sources = sources

    def to_dict(self):
        return {
            '_': 'GroupCallParticipantVideoSourceGroup',
            'semantics': self.semantics,
            'sources': [] if self.sources is None else self.sources[:]
        }

    def _bytes(self):
        return b''.join((
            b'\xb7\x18\xb1\xdc',
            self.serialize_bytes(self.semantics),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.sources)),b''.join(struct.pack('<i', x) for x in self.sources),
        ))

    @classmethod
    def from_reader(cls, reader):
        _semantics = reader.tgread_string()
        reader.read_int()
        _sources = []
        for _ in range(reader.read_int()):
            _x = reader.read_int()
            _sources.append(_x)

        return cls(semantics=_semantics, sources=_sources)


class GroupCallStreamChannel(TLObject):
    CONSTRUCTOR_ID = 0x80eb48af
    SUBCLASS_OF_ID = 0xdd44b258

    def __init__(self, channel: int, scale: int, last_timestamp_ms: int):
        """
        Constructor for GroupCallStreamChannel: Instance of GroupCallStreamChannel.
        """
        self.channel = channel
        self.scale = scale
        self.last_timestamp_ms = last_timestamp_ms

    def to_dict(self):
        return {
            '_': 'GroupCallStreamChannel',
            'channel': self.channel,
            'scale': self.scale,
            'last_timestamp_ms': self.last_timestamp_ms
        }

    def _bytes(self):
        return b''.join((
            b'\xafH\xeb\x80',
            struct.pack('<i', self.channel),
            struct.pack('<i', self.scale),
            struct.pack('<q', self.last_timestamp_ms),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel = reader.read_int()
        _scale = reader.read_int()
        _last_timestamp_ms = reader.read_long()
        return cls(channel=_channel, scale=_scale, last_timestamp_ms=_last_timestamp_ms)


class HighScore(TLObject):
    CONSTRUCTOR_ID = 0x73a379eb
    SUBCLASS_OF_ID = 0xd32b1e35

    def __init__(self, pos: int, user_id: int, score: int):
        """
        Constructor for HighScore: Instance of HighScore.
        """
        self.pos = pos
        self.user_id = user_id
        self.score = score

    def to_dict(self):
        return {
            '_': 'HighScore',
            'pos': self.pos,
            'user_id': self.user_id,
            'score': self.score
        }

    def _bytes(self):
        return b''.join((
            b'\xeby\xa3s',
            struct.pack('<i', self.pos),
            struct.pack('<q', self.user_id),
            struct.pack('<i', self.score),
        ))

    @classmethod
    def from_reader(cls, reader):
        _pos = reader.read_int()
        _user_id = reader.read_long()
        _score = reader.read_int()
        return cls(pos=_pos, user_id=_user_id, score=_score)


class HttpWait(TLObject):
    CONSTRUCTOR_ID = 0x9299359f
    SUBCLASS_OF_ID = 0x1284aed6

    def __init__(self, max_delay: int, wait_after: int, max_wait: int):
        """
        Constructor for HttpWait: Instance of HttpWait.
        """
        self.max_delay = max_delay
        self.wait_after = wait_after
        self.max_wait = max_wait

    def to_dict(self):
        return {
            '_': 'HttpWait',
            'max_delay': self.max_delay,
            'wait_after': self.wait_after,
            'max_wait': self.max_wait
        }

    def _bytes(self):
        return b''.join((
            b'\x9f5\x99\x92',
            struct.pack('<i', self.max_delay),
            struct.pack('<i', self.wait_after),
            struct.pack('<i', self.max_wait),
        ))

    @classmethod
    def from_reader(cls, reader):
        _max_delay = reader.read_int()
        _wait_after = reader.read_int()
        _max_wait = reader.read_int()
        return cls(max_delay=_max_delay, wait_after=_wait_after, max_wait=_max_wait)


class ImportedContact(TLObject):
    CONSTRUCTOR_ID = 0xc13e3c50
    SUBCLASS_OF_ID = 0xb545bbda

    def __init__(self, user_id: int, client_id: int):
        """
        Constructor for ImportedContact: Instance of ImportedContact.
        """
        self.user_id = user_id
        self.client_id = client_id

    def to_dict(self):
        return {
            '_': 'ImportedContact',
            'user_id': self.user_id,
            'client_id': self.client_id
        }

    def _bytes(self):
        return b''.join((
            b'P<>\xc1',
            struct.pack('<q', self.user_id),
            struct.pack('<q', self.client_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _user_id = reader.read_long()
        _client_id = reader.read_long()
        return cls(user_id=_user_id, client_id=_client_id)


class InlineBotSwitchPM(TLObject):
    CONSTRUCTOR_ID = 0x3c20629f
    SUBCLASS_OF_ID = 0x82b1f73b

    def __init__(self, text: str, start_param: str):
        """
        Constructor for InlineBotSwitchPM: Instance of InlineBotSwitchPM.
        """
        self.text = text
        self.start_param = start_param

    def to_dict(self):
        return {
            '_': 'InlineBotSwitchPM',
            'text': self.text,
            'start_param': self.start_param
        }

    def _bytes(self):
        return b''.join((
            b'\x9fb <',
            self.serialize_bytes(self.text),
            self.serialize_bytes(self.start_param),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_string()
        _start_param = reader.tgread_string()
        return cls(text=_text, start_param=_start_param)


class InlineBotWebView(TLObject):
    CONSTRUCTOR_ID = 0xb57295d5
    SUBCLASS_OF_ID = 0x6ce015ea

    def __init__(self, text: str, url: str):
        """
        Constructor for InlineBotWebView: Instance of InlineBotWebView.
        """
        self.text = text
        self.url = url

    def to_dict(self):
        return {
            '_': 'InlineBotWebView',
            'text': self.text,
            'url': self.url
        }

    def _bytes(self):
        return b''.join((
            b'\xd5\x95r\xb5',
            self.serialize_bytes(self.text),
            self.serialize_bytes(self.url),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_string()
        _url = reader.tgread_string()
        return cls(text=_text, url=_url)


class InlineQueryPeerTypeBotPM(TLObject):
    CONSTRUCTOR_ID = 0xe3b2d0c
    SUBCLASS_OF_ID = 0xafb0fa1f

    def to_dict(self):
        return {
            '_': 'InlineQueryPeerTypeBotPM'
        }

    def _bytes(self):
        return b''.join((
            b'\x0c-;\x0e',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InlineQueryPeerTypeBroadcast(TLObject):
    CONSTRUCTOR_ID = 0x6334ee9a
    SUBCLASS_OF_ID = 0xafb0fa1f

    def to_dict(self):
        return {
            '_': 'InlineQueryPeerTypeBroadcast'
        }

    def _bytes(self):
        return b''.join((
            b'\x9a\xee4c',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InlineQueryPeerTypeChat(TLObject):
    CONSTRUCTOR_ID = 0xd766c50a
    SUBCLASS_OF_ID = 0xafb0fa1f

    def to_dict(self):
        return {
            '_': 'InlineQueryPeerTypeChat'
        }

    def _bytes(self):
        return b''.join((
            b'\n\xc5f\xd7',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InlineQueryPeerTypeMegagroup(TLObject):
    CONSTRUCTOR_ID = 0x5ec4be43
    SUBCLASS_OF_ID = 0xafb0fa1f

    def to_dict(self):
        return {
            '_': 'InlineQueryPeerTypeMegagroup'
        }

    def _bytes(self):
        return b''.join((
            b'C\xbe\xc4^',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InlineQueryPeerTypePM(TLObject):
    CONSTRUCTOR_ID = 0x833c0fac
    SUBCLASS_OF_ID = 0xafb0fa1f

    def to_dict(self):
        return {
            '_': 'InlineQueryPeerTypePM'
        }

    def _bytes(self):
        return b''.join((
            b'\xac\x0f<\x83',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InlineQueryPeerTypeSameBotPM(TLObject):
    CONSTRUCTOR_ID = 0x3081ed9d
    SUBCLASS_OF_ID = 0xafb0fa1f

    def to_dict(self):
        return {
            '_': 'InlineQueryPeerTypeSameBotPM'
        }

    def _bytes(self):
        return b''.join((
            b'\x9d\xed\x810',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputAppEvent(TLObject):
    CONSTRUCTOR_ID = 0x1d1b1245
    SUBCLASS_OF_ID = 0x89322106

    # noinspection PyShadowingBuiltins
    def __init__(self, time: float, type: str, peer: int, data: 'TypeJSONValue'):
        """
        Constructor for InputAppEvent: Instance of InputAppEvent.
        """
        self.time = time
        self.type = type
        self.peer = peer
        self.data = data

    def to_dict(self):
        return {
            '_': 'InputAppEvent',
            'time': self.time,
            'type': self.type,
            'peer': self.peer,
            'data': self.data.to_dict() if isinstance(self.data, TLObject) else self.data
        }

    def _bytes(self):
        return b''.join((
            b'E\x12\x1b\x1d',
            struct.pack('<d', self.time),
            self.serialize_bytes(self.type),
            struct.pack('<q', self.peer),
            self.data._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _time = reader.read_double()
        _type = reader.tgread_string()
        _peer = reader.read_long()
        _data = reader.tgread_object()
        return cls(time=_time, type=_type, peer=_peer, data=_data)


class InputBotAppID(TLObject):
    CONSTRUCTOR_ID = 0xa920bd7a
    SUBCLASS_OF_ID = 0xb6559951

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int):
        """
        Constructor for InputBotApp: Instance of either InputBotAppID, InputBotAppShortName.
        """
        self.id = id
        self.access_hash = access_hash

    def to_dict(self):
        return {
            '_': 'InputBotAppID',
            'id': self.id,
            'access_hash': self.access_hash
        }

    def _bytes(self):
        return b''.join((
            b'z\xbd \xa9',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        return cls(id=_id, access_hash=_access_hash)


class InputBotAppShortName(TLObject):
    CONSTRUCTOR_ID = 0x908c0407
    SUBCLASS_OF_ID = 0xb6559951

    def __init__(self, bot_id: 'TypeInputUser', short_name: str):
        """
        Constructor for InputBotApp: Instance of either InputBotAppID, InputBotAppShortName.
        """
        self.bot_id = bot_id
        self.short_name = short_name

    def to_dict(self):
        return {
            '_': 'InputBotAppShortName',
            'bot_id': self.bot_id.to_dict() if isinstance(self.bot_id, TLObject) else self.bot_id,
            'short_name': self.short_name
        }

    def _bytes(self):
        return b''.join((
            b'\x07\x04\x8c\x90',
            self.bot_id._bytes(),
            self.serialize_bytes(self.short_name),
        ))

    @classmethod
    def from_reader(cls, reader):
        _bot_id = reader.tgread_object()
        _short_name = reader.tgread_string()
        return cls(bot_id=_bot_id, short_name=_short_name)


class InputBotInlineMessageGame(TLObject):
    CONSTRUCTOR_ID = 0x4b425864
    SUBCLASS_OF_ID = 0x53fb4010

    def __init__(self, reply_markup: Optional['TypeReplyMarkup']=None):
        """
        Constructor for InputBotInlineMessage: Instance of either InputBotInlineMessageMediaAuto, InputBotInlineMessageText, InputBotInlineMessageMediaGeo, InputBotInlineMessageMediaVenue, InputBotInlineMessageMediaContact, InputBotInlineMessageGame, InputBotInlineMessageMediaInvoice, InputBotInlineMessageMediaWebPage.
        """
        self.reply_markup = reply_markup

    def to_dict(self):
        return {
            '_': 'InputBotInlineMessageGame',
            'reply_markup': self.reply_markup.to_dict() if isinstance(self.reply_markup, TLObject) else self.reply_markup
        }

    def _bytes(self):
        return b''.join((
            b'dXBK',
            struct.pack('<I', (0 if self.reply_markup is None or self.reply_markup is False else 4)),
            b'' if self.reply_markup is None or self.reply_markup is False else (self.reply_markup._bytes()),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        return cls(reply_markup=_reply_markup)


class InputBotInlineMessageID(TLObject):
    CONSTRUCTOR_ID = 0x890c3d89
    SUBCLASS_OF_ID = 0x2dcd6300

    # noinspection PyShadowingBuiltins
    def __init__(self, dc_id: int, id: int, access_hash: int):
        """
        Constructor for InputBotInlineMessageID: Instance of either InputBotInlineMessageID, InputBotInlineMessageID64.
        """
        self.dc_id = dc_id
        self.id = id
        self.access_hash = access_hash

    def to_dict(self):
        return {
            '_': 'InputBotInlineMessageID',
            'dc_id': self.dc_id,
            'id': self.id,
            'access_hash': self.access_hash
        }

    def _bytes(self):
        return b''.join((
            b'\x89=\x0c\x89',
            struct.pack('<i', self.dc_id),
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _dc_id = reader.read_int()
        _id = reader.read_long()
        _access_hash = reader.read_long()
        return cls(dc_id=_dc_id, id=_id, access_hash=_access_hash)


class InputBotInlineMessageID64(TLObject):
    CONSTRUCTOR_ID = 0xb6d915d7
    SUBCLASS_OF_ID = 0x2dcd6300

    # noinspection PyShadowingBuiltins
    def __init__(self, dc_id: int, owner_id: int, id: int, access_hash: int):
        """
        Constructor for InputBotInlineMessageID: Instance of either InputBotInlineMessageID, InputBotInlineMessageID64.
        """
        self.dc_id = dc_id
        self.owner_id = owner_id
        self.id = id
        self.access_hash = access_hash

    def to_dict(self):
        return {
            '_': 'InputBotInlineMessageID64',
            'dc_id': self.dc_id,
            'owner_id': self.owner_id,
            'id': self.id,
            'access_hash': self.access_hash
        }

    def _bytes(self):
        return b''.join((
            b'\xd7\x15\xd9\xb6',
            struct.pack('<i', self.dc_id),
            struct.pack('<q', self.owner_id),
            struct.pack('<i', self.id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _dc_id = reader.read_int()
        _owner_id = reader.read_long()
        _id = reader.read_int()
        _access_hash = reader.read_long()
        return cls(dc_id=_dc_id, owner_id=_owner_id, id=_id, access_hash=_access_hash)


class InputBotInlineMessageMediaAuto(TLObject):
    CONSTRUCTOR_ID = 0x3380c786
    SUBCLASS_OF_ID = 0x53fb4010

    def __init__(self, message: str, invert_media: Optional[bool]=None, entities: Optional[List['TypeMessageEntity']]=None, reply_markup: Optional['TypeReplyMarkup']=None):
        """
        Constructor for InputBotInlineMessage: Instance of either InputBotInlineMessageMediaAuto, InputBotInlineMessageText, InputBotInlineMessageMediaGeo, InputBotInlineMessageMediaVenue, InputBotInlineMessageMediaContact, InputBotInlineMessageGame, InputBotInlineMessageMediaInvoice, InputBotInlineMessageMediaWebPage.
        """
        self.message = message
        self.invert_media = invert_media
        self.entities = entities
        self.reply_markup = reply_markup

    def to_dict(self):
        return {
            '_': 'InputBotInlineMessageMediaAuto',
            'message': self.message,
            'invert_media': self.invert_media,
            'entities': [] if self.entities is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.entities],
            'reply_markup': self.reply_markup.to_dict() if isinstance(self.reply_markup, TLObject) else self.reply_markup
        }

    def _bytes(self):
        return b''.join((
            b'\x86\xc7\x803',
            struct.pack('<I', (0 if self.invert_media is None or self.invert_media is False else 8) | (0 if self.entities is None or self.entities is False else 2) | (0 if self.reply_markup is None or self.reply_markup is False else 4)),
            self.serialize_bytes(self.message),
            b'' if self.entities is None or self.entities is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.entities)),b''.join(x._bytes() for x in self.entities))),
            b'' if self.reply_markup is None or self.reply_markup is False else (self.reply_markup._bytes()),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _invert_media = bool(flags & 8)
        _message = reader.tgread_string()
        if flags & 2:
            reader.read_int()
            _entities = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _entities.append(_x)

        else:
            _entities = None
        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        return cls(message=_message, invert_media=_invert_media, entities=_entities, reply_markup=_reply_markup)


class InputBotInlineMessageMediaContact(TLObject):
    CONSTRUCTOR_ID = 0xa6edbffd
    SUBCLASS_OF_ID = 0x53fb4010

    def __init__(self, phone_number: str, first_name: str, last_name: str, vcard: str, reply_markup: Optional['TypeReplyMarkup']=None):
        """
        Constructor for InputBotInlineMessage: Instance of either InputBotInlineMessageMediaAuto, InputBotInlineMessageText, InputBotInlineMessageMediaGeo, InputBotInlineMessageMediaVenue, InputBotInlineMessageMediaContact, InputBotInlineMessageGame, InputBotInlineMessageMediaInvoice, InputBotInlineMessageMediaWebPage.
        """
        self.phone_number = phone_number
        self.first_name = first_name
        self.last_name = last_name
        self.vcard = vcard
        self.reply_markup = reply_markup

    def to_dict(self):
        return {
            '_': 'InputBotInlineMessageMediaContact',
            'phone_number': self.phone_number,
            'first_name': self.first_name,
            'last_name': self.last_name,
            'vcard': self.vcard,
            'reply_markup': self.reply_markup.to_dict() if isinstance(self.reply_markup, TLObject) else self.reply_markup
        }

    def _bytes(self):
        return b''.join((
            b'\xfd\xbf\xed\xa6',
            struct.pack('<I', (0 if self.reply_markup is None or self.reply_markup is False else 4)),
            self.serialize_bytes(self.phone_number),
            self.serialize_bytes(self.first_name),
            self.serialize_bytes(self.last_name),
            self.serialize_bytes(self.vcard),
            b'' if self.reply_markup is None or self.reply_markup is False else (self.reply_markup._bytes()),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _phone_number = reader.tgread_string()
        _first_name = reader.tgread_string()
        _last_name = reader.tgread_string()
        _vcard = reader.tgread_string()
        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        return cls(phone_number=_phone_number, first_name=_first_name, last_name=_last_name, vcard=_vcard, reply_markup=_reply_markup)


class InputBotInlineMessageMediaGeo(TLObject):
    CONSTRUCTOR_ID = 0x96929a85
    SUBCLASS_OF_ID = 0x53fb4010

    def __init__(self, geo_point: 'TypeInputGeoPoint', heading: Optional[int]=None, period: Optional[int]=None, proximity_notification_radius: Optional[int]=None, reply_markup: Optional['TypeReplyMarkup']=None):
        """
        Constructor for InputBotInlineMessage: Instance of either InputBotInlineMessageMediaAuto, InputBotInlineMessageText, InputBotInlineMessageMediaGeo, InputBotInlineMessageMediaVenue, InputBotInlineMessageMediaContact, InputBotInlineMessageGame, InputBotInlineMessageMediaInvoice, InputBotInlineMessageMediaWebPage.
        """
        self.geo_point = geo_point
        self.heading = heading
        self.period = period
        self.proximity_notification_radius = proximity_notification_radius
        self.reply_markup = reply_markup

    def to_dict(self):
        return {
            '_': 'InputBotInlineMessageMediaGeo',
            'geo_point': self.geo_point.to_dict() if isinstance(self.geo_point, TLObject) else self.geo_point,
            'heading': self.heading,
            'period': self.period,
            'proximity_notification_radius': self.proximity_notification_radius,
            'reply_markup': self.reply_markup.to_dict() if isinstance(self.reply_markup, TLObject) else self.reply_markup
        }

    def _bytes(self):
        return b''.join((
            b'\x85\x9a\x92\x96',
            struct.pack('<I', (0 if self.heading is None or self.heading is False else 1) | (0 if self.period is None or self.period is False else 2) | (0 if self.proximity_notification_radius is None or self.proximity_notification_radius is False else 8) | (0 if self.reply_markup is None or self.reply_markup is False else 4)),
            self.geo_point._bytes(),
            b'' if self.heading is None or self.heading is False else (struct.pack('<i', self.heading)),
            b'' if self.period is None or self.period is False else (struct.pack('<i', self.period)),
            b'' if self.proximity_notification_radius is None or self.proximity_notification_radius is False else (struct.pack('<i', self.proximity_notification_radius)),
            b'' if self.reply_markup is None or self.reply_markup is False else (self.reply_markup._bytes()),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _geo_point = reader.tgread_object()
        if flags & 1:
            _heading = reader.read_int()
        else:
            _heading = None
        if flags & 2:
            _period = reader.read_int()
        else:
            _period = None
        if flags & 8:
            _proximity_notification_radius = reader.read_int()
        else:
            _proximity_notification_radius = None
        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        return cls(geo_point=_geo_point, heading=_heading, period=_period, proximity_notification_radius=_proximity_notification_radius, reply_markup=_reply_markup)


class InputBotInlineMessageMediaInvoice(TLObject):
    CONSTRUCTOR_ID = 0xd7e78225
    SUBCLASS_OF_ID = 0x53fb4010

    def __init__(self, title: str, description: str, invoice: 'TypeInvoice', payload: bytes, provider: str, provider_data: 'TypeDataJSON', photo: Optional['TypeInputWebDocument']=None, reply_markup: Optional['TypeReplyMarkup']=None):
        """
        Constructor for InputBotInlineMessage: Instance of either InputBotInlineMessageMediaAuto, InputBotInlineMessageText, InputBotInlineMessageMediaGeo, InputBotInlineMessageMediaVenue, InputBotInlineMessageMediaContact, InputBotInlineMessageGame, InputBotInlineMessageMediaInvoice, InputBotInlineMessageMediaWebPage.
        """
        self.title = title
        self.description = description
        self.invoice = invoice
        self.payload = payload
        self.provider = provider
        self.provider_data = provider_data
        self.photo = photo
        self.reply_markup = reply_markup

    def to_dict(self):
        return {
            '_': 'InputBotInlineMessageMediaInvoice',
            'title': self.title,
            'description': self.description,
            'invoice': self.invoice.to_dict() if isinstance(self.invoice, TLObject) else self.invoice,
            'payload': self.payload,
            'provider': self.provider,
            'provider_data': self.provider_data.to_dict() if isinstance(self.provider_data, TLObject) else self.provider_data,
            'photo': self.photo.to_dict() if isinstance(self.photo, TLObject) else self.photo,
            'reply_markup': self.reply_markup.to_dict() if isinstance(self.reply_markup, TLObject) else self.reply_markup
        }

    def _bytes(self):
        return b''.join((
            b'%\x82\xe7\xd7',
            struct.pack('<I', (0 if self.photo is None or self.photo is False else 1) | (0 if self.reply_markup is None or self.reply_markup is False else 4)),
            self.serialize_bytes(self.title),
            self.serialize_bytes(self.description),
            b'' if self.photo is None or self.photo is False else (self.photo._bytes()),
            self.invoice._bytes(),
            self.serialize_bytes(self.payload),
            self.serialize_bytes(self.provider),
            self.provider_data._bytes(),
            b'' if self.reply_markup is None or self.reply_markup is False else (self.reply_markup._bytes()),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _title = reader.tgread_string()
        _description = reader.tgread_string()
        if flags & 1:
            _photo = reader.tgread_object()
        else:
            _photo = None
        _invoice = reader.tgread_object()
        _payload = reader.tgread_bytes()
        _provider = reader.tgread_string()
        _provider_data = reader.tgread_object()
        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        return cls(title=_title, description=_description, invoice=_invoice, payload=_payload, provider=_provider, provider_data=_provider_data, photo=_photo, reply_markup=_reply_markup)


class InputBotInlineMessageMediaVenue(TLObject):
    CONSTRUCTOR_ID = 0x417bbf11
    SUBCLASS_OF_ID = 0x53fb4010

    def __init__(self, geo_point: 'TypeInputGeoPoint', title: str, address: str, provider: str, venue_id: str, venue_type: str, reply_markup: Optional['TypeReplyMarkup']=None):
        """
        Constructor for InputBotInlineMessage: Instance of either InputBotInlineMessageMediaAuto, InputBotInlineMessageText, InputBotInlineMessageMediaGeo, InputBotInlineMessageMediaVenue, InputBotInlineMessageMediaContact, InputBotInlineMessageGame, InputBotInlineMessageMediaInvoice, InputBotInlineMessageMediaWebPage.
        """
        self.geo_point = geo_point
        self.title = title
        self.address = address
        self.provider = provider
        self.venue_id = venue_id
        self.venue_type = venue_type
        self.reply_markup = reply_markup

    def to_dict(self):
        return {
            '_': 'InputBotInlineMessageMediaVenue',
            'geo_point': self.geo_point.to_dict() if isinstance(self.geo_point, TLObject) else self.geo_point,
            'title': self.title,
            'address': self.address,
            'provider': self.provider,
            'venue_id': self.venue_id,
            'venue_type': self.venue_type,
            'reply_markup': self.reply_markup.to_dict() if isinstance(self.reply_markup, TLObject) else self.reply_markup
        }

    def _bytes(self):
        return b''.join((
            b'\x11\xbf{A',
            struct.pack('<I', (0 if self.reply_markup is None or self.reply_markup is False else 4)),
            self.geo_point._bytes(),
            self.serialize_bytes(self.title),
            self.serialize_bytes(self.address),
            self.serialize_bytes(self.provider),
            self.serialize_bytes(self.venue_id),
            self.serialize_bytes(self.venue_type),
            b'' if self.reply_markup is None or self.reply_markup is False else (self.reply_markup._bytes()),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _geo_point = reader.tgread_object()
        _title = reader.tgread_string()
        _address = reader.tgread_string()
        _provider = reader.tgread_string()
        _venue_id = reader.tgread_string()
        _venue_type = reader.tgread_string()
        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        return cls(geo_point=_geo_point, title=_title, address=_address, provider=_provider, venue_id=_venue_id, venue_type=_venue_type, reply_markup=_reply_markup)


class InputBotInlineMessageMediaWebPage(TLObject):
    CONSTRUCTOR_ID = 0xbddcc510
    SUBCLASS_OF_ID = 0x53fb4010

    def __init__(self, message: str, url: str, invert_media: Optional[bool]=None, force_large_media: Optional[bool]=None, force_small_media: Optional[bool]=None, optional: Optional[bool]=None, entities: Optional[List['TypeMessageEntity']]=None, reply_markup: Optional['TypeReplyMarkup']=None):
        """
        Constructor for InputBotInlineMessage: Instance of either InputBotInlineMessageMediaAuto, InputBotInlineMessageText, InputBotInlineMessageMediaGeo, InputBotInlineMessageMediaVenue, InputBotInlineMessageMediaContact, InputBotInlineMessageGame, InputBotInlineMessageMediaInvoice, InputBotInlineMessageMediaWebPage.
        """
        self.message = message
        self.url = url
        self.invert_media = invert_media
        self.force_large_media = force_large_media
        self.force_small_media = force_small_media
        self.optional = optional
        self.entities = entities
        self.reply_markup = reply_markup

    def to_dict(self):
        return {
            '_': 'InputBotInlineMessageMediaWebPage',
            'message': self.message,
            'url': self.url,
            'invert_media': self.invert_media,
            'force_large_media': self.force_large_media,
            'force_small_media': self.force_small_media,
            'optional': self.optional,
            'entities': [] if self.entities is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.entities],
            'reply_markup': self.reply_markup.to_dict() if isinstance(self.reply_markup, TLObject) else self.reply_markup
        }

    def _bytes(self):
        return b''.join((
            b'\x10\xc5\xdc\xbd',
            struct.pack('<I', (0 if self.invert_media is None or self.invert_media is False else 8) | (0 if self.force_large_media is None or self.force_large_media is False else 16) | (0 if self.force_small_media is None or self.force_small_media is False else 32) | (0 if self.optional is None or self.optional is False else 64) | (0 if self.entities is None or self.entities is False else 2) | (0 if self.reply_markup is None or self.reply_markup is False else 4)),
            self.serialize_bytes(self.message),
            b'' if self.entities is None or self.entities is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.entities)),b''.join(x._bytes() for x in self.entities))),
            self.serialize_bytes(self.url),
            b'' if self.reply_markup is None or self.reply_markup is False else (self.reply_markup._bytes()),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _invert_media = bool(flags & 8)
        _force_large_media = bool(flags & 16)
        _force_small_media = bool(flags & 32)
        _optional = bool(flags & 64)
        _message = reader.tgread_string()
        if flags & 2:
            reader.read_int()
            _entities = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _entities.append(_x)

        else:
            _entities = None
        _url = reader.tgread_string()
        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        return cls(message=_message, url=_url, invert_media=_invert_media, force_large_media=_force_large_media, force_small_media=_force_small_media, optional=_optional, entities=_entities, reply_markup=_reply_markup)


class InputBotInlineMessageText(TLObject):
    CONSTRUCTOR_ID = 0x3dcd7a87
    SUBCLASS_OF_ID = 0x53fb4010

    def __init__(self, message: str, no_webpage: Optional[bool]=None, invert_media: Optional[bool]=None, entities: Optional[List['TypeMessageEntity']]=None, reply_markup: Optional['TypeReplyMarkup']=None):
        """
        Constructor for InputBotInlineMessage: Instance of either InputBotInlineMessageMediaAuto, InputBotInlineMessageText, InputBotInlineMessageMediaGeo, InputBotInlineMessageMediaVenue, InputBotInlineMessageMediaContact, InputBotInlineMessageGame, InputBotInlineMessageMediaInvoice, InputBotInlineMessageMediaWebPage.
        """
        self.message = message
        self.no_webpage = no_webpage
        self.invert_media = invert_media
        self.entities = entities
        self.reply_markup = reply_markup

    def to_dict(self):
        return {
            '_': 'InputBotInlineMessageText',
            'message': self.message,
            'no_webpage': self.no_webpage,
            'invert_media': self.invert_media,
            'entities': [] if self.entities is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.entities],
            'reply_markup': self.reply_markup.to_dict() if isinstance(self.reply_markup, TLObject) else self.reply_markup
        }

    def _bytes(self):
        return b''.join((
            b'\x87z\xcd=',
            struct.pack('<I', (0 if self.no_webpage is None or self.no_webpage is False else 1) | (0 if self.invert_media is None or self.invert_media is False else 8) | (0 if self.entities is None or self.entities is False else 2) | (0 if self.reply_markup is None or self.reply_markup is False else 4)),
            self.serialize_bytes(self.message),
            b'' if self.entities is None or self.entities is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.entities)),b''.join(x._bytes() for x in self.entities))),
            b'' if self.reply_markup is None or self.reply_markup is False else (self.reply_markup._bytes()),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _no_webpage = bool(flags & 1)
        _invert_media = bool(flags & 8)
        _message = reader.tgread_string()
        if flags & 2:
            reader.read_int()
            _entities = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _entities.append(_x)

        else:
            _entities = None
        if flags & 4:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        return cls(message=_message, no_webpage=_no_webpage, invert_media=_invert_media, entities=_entities, reply_markup=_reply_markup)


class InputBotInlineResult(TLObject):
    CONSTRUCTOR_ID = 0x88bf9319
    SUBCLASS_OF_ID = 0x80a4a3de

    # noinspection PyShadowingBuiltins
    def __init__(self, id: str, type: str, send_message: 'TypeInputBotInlineMessage', title: Optional[str]=None, description: Optional[str]=None, url: Optional[str]=None, thumb: Optional['TypeInputWebDocument']=None, content: Optional['TypeInputWebDocument']=None):
        """
        Constructor for InputBotInlineResult: Instance of either InputBotInlineResult, InputBotInlineResultPhoto, InputBotInlineResultDocument, InputBotInlineResultGame.
        """
        self.id = id
        self.type = type
        self.send_message = send_message
        self.title = title
        self.description = description
        self.url = url
        self.thumb = thumb
        self.content = content

    def to_dict(self):
        return {
            '_': 'InputBotInlineResult',
            'id': self.id,
            'type': self.type,
            'send_message': self.send_message.to_dict() if isinstance(self.send_message, TLObject) else self.send_message,
            'title': self.title,
            'description': self.description,
            'url': self.url,
            'thumb': self.thumb.to_dict() if isinstance(self.thumb, TLObject) else self.thumb,
            'content': self.content.to_dict() if isinstance(self.content, TLObject) else self.content
        }

    def _bytes(self):
        return b''.join((
            b'\x19\x93\xbf\x88',
            struct.pack('<I', (0 if self.title is None or self.title is False else 2) | (0 if self.description is None or self.description is False else 4) | (0 if self.url is None or self.url is False else 8) | (0 if self.thumb is None or self.thumb is False else 16) | (0 if self.content is None or self.content is False else 32)),
            self.serialize_bytes(self.id),
            self.serialize_bytes(self.type),
            b'' if self.title is None or self.title is False else (self.serialize_bytes(self.title)),
            b'' if self.description is None or self.description is False else (self.serialize_bytes(self.description)),
            b'' if self.url is None or self.url is False else (self.serialize_bytes(self.url)),
            b'' if self.thumb is None or self.thumb is False else (self.thumb._bytes()),
            b'' if self.content is None or self.content is False else (self.content._bytes()),
            self.send_message._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _id = reader.tgread_string()
        _type = reader.tgread_string()
        if flags & 2:
            _title = reader.tgread_string()
        else:
            _title = None
        if flags & 4:
            _description = reader.tgread_string()
        else:
            _description = None
        if flags & 8:
            _url = reader.tgread_string()
        else:
            _url = None
        if flags & 16:
            _thumb = reader.tgread_object()
        else:
            _thumb = None
        if flags & 32:
            _content = reader.tgread_object()
        else:
            _content = None
        _send_message = reader.tgread_object()
        return cls(id=_id, type=_type, send_message=_send_message, title=_title, description=_description, url=_url, thumb=_thumb, content=_content)


class InputBotInlineResultDocument(TLObject):
    CONSTRUCTOR_ID = 0xfff8fdc4
    SUBCLASS_OF_ID = 0x80a4a3de

    # noinspection PyShadowingBuiltins
    def __init__(self, id: str, type: str, document: 'TypeInputDocument', send_message: 'TypeInputBotInlineMessage', title: Optional[str]=None, description: Optional[str]=None):
        """
        Constructor for InputBotInlineResult: Instance of either InputBotInlineResult, InputBotInlineResultPhoto, InputBotInlineResultDocument, InputBotInlineResultGame.
        """
        self.id = id
        self.type = type
        self.document = document
        self.send_message = send_message
        self.title = title
        self.description = description

    def to_dict(self):
        return {
            '_': 'InputBotInlineResultDocument',
            'id': self.id,
            'type': self.type,
            'document': self.document.to_dict() if isinstance(self.document, TLObject) else self.document,
            'send_message': self.send_message.to_dict() if isinstance(self.send_message, TLObject) else self.send_message,
            'title': self.title,
            'description': self.description
        }

    def _bytes(self):
        return b''.join((
            b'\xc4\xfd\xf8\xff',
            struct.pack('<I', (0 if self.title is None or self.title is False else 2) | (0 if self.description is None or self.description is False else 4)),
            self.serialize_bytes(self.id),
            self.serialize_bytes(self.type),
            b'' if self.title is None or self.title is False else (self.serialize_bytes(self.title)),
            b'' if self.description is None or self.description is False else (self.serialize_bytes(self.description)),
            self.document._bytes(),
            self.send_message._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _id = reader.tgread_string()
        _type = reader.tgread_string()
        if flags & 2:
            _title = reader.tgread_string()
        else:
            _title = None
        if flags & 4:
            _description = reader.tgread_string()
        else:
            _description = None
        _document = reader.tgread_object()
        _send_message = reader.tgread_object()
        return cls(id=_id, type=_type, document=_document, send_message=_send_message, title=_title, description=_description)


class InputBotInlineResultGame(TLObject):
    CONSTRUCTOR_ID = 0x4fa417f2
    SUBCLASS_OF_ID = 0x80a4a3de

    # noinspection PyShadowingBuiltins
    def __init__(self, id: str, short_name: str, send_message: 'TypeInputBotInlineMessage'):
        """
        Constructor for InputBotInlineResult: Instance of either InputBotInlineResult, InputBotInlineResultPhoto, InputBotInlineResultDocument, InputBotInlineResultGame.
        """
        self.id = id
        self.short_name = short_name
        self.send_message = send_message

    def to_dict(self):
        return {
            '_': 'InputBotInlineResultGame',
            'id': self.id,
            'short_name': self.short_name,
            'send_message': self.send_message.to_dict() if isinstance(self.send_message, TLObject) else self.send_message
        }

    def _bytes(self):
        return b''.join((
            b'\xf2\x17\xa4O',
            self.serialize_bytes(self.id),
            self.serialize_bytes(self.short_name),
            self.send_message._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.tgread_string()
        _short_name = reader.tgread_string()
        _send_message = reader.tgread_object()
        return cls(id=_id, short_name=_short_name, send_message=_send_message)


class InputBotInlineResultPhoto(TLObject):
    CONSTRUCTOR_ID = 0xa8d864a7
    SUBCLASS_OF_ID = 0x80a4a3de

    # noinspection PyShadowingBuiltins
    def __init__(self, id: str, type: str, photo: 'TypeInputPhoto', send_message: 'TypeInputBotInlineMessage'):
        """
        Constructor for InputBotInlineResult: Instance of either InputBotInlineResult, InputBotInlineResultPhoto, InputBotInlineResultDocument, InputBotInlineResultGame.
        """
        self.id = id
        self.type = type
        self.photo = photo
        self.send_message = send_message

    def to_dict(self):
        return {
            '_': 'InputBotInlineResultPhoto',
            'id': self.id,
            'type': self.type,
            'photo': self.photo.to_dict() if isinstance(self.photo, TLObject) else self.photo,
            'send_message': self.send_message.to_dict() if isinstance(self.send_message, TLObject) else self.send_message
        }

    def _bytes(self):
        return b''.join((
            b'\xa7d\xd8\xa8',
            self.serialize_bytes(self.id),
            self.serialize_bytes(self.type),
            self.photo._bytes(),
            self.send_message._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.tgread_string()
        _type = reader.tgread_string()
        _photo = reader.tgread_object()
        _send_message = reader.tgread_object()
        return cls(id=_id, type=_type, photo=_photo, send_message=_send_message)


class InputChannel(TLObject):
    CONSTRUCTOR_ID = 0xf35aec28
    SUBCLASS_OF_ID = 0x40f202fd

    def __init__(self, channel_id: int, access_hash: int):
        """
        Constructor for InputChannel: Instance of either InputChannelEmpty, InputChannel, InputChannelFromMessage.
        """
        self.channel_id = channel_id
        self.access_hash = access_hash

    def to_dict(self):
        return {
            '_': 'InputChannel',
            'channel_id': self.channel_id,
            'access_hash': self.access_hash
        }

    def _bytes(self):
        return b''.join((
            b'(\xecZ\xf3',
            struct.pack('<q', self.channel_id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel_id = reader.read_long()
        _access_hash = reader.read_long()
        return cls(channel_id=_channel_id, access_hash=_access_hash)


class InputChannelEmpty(TLObject):
    CONSTRUCTOR_ID = 0xee8c1e86
    SUBCLASS_OF_ID = 0x40f202fd

    def to_dict(self):
        return {
            '_': 'InputChannelEmpty'
        }

    def _bytes(self):
        return b''.join((
            b'\x86\x1e\x8c\xee',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputChannelFromMessage(TLObject):
    CONSTRUCTOR_ID = 0x5b934f9d
    SUBCLASS_OF_ID = 0x40f202fd

    def __init__(self, peer: 'TypeInputPeer', msg_id: int, channel_id: int):
        """
        Constructor for InputChannel: Instance of either InputChannelEmpty, InputChannel, InputChannelFromMessage.
        """
        self.peer = peer
        self.msg_id = msg_id
        self.channel_id = channel_id

    def to_dict(self):
        return {
            '_': 'InputChannelFromMessage',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'msg_id': self.msg_id,
            'channel_id': self.channel_id
        }

    def _bytes(self):
        return b''.join((
            b'\x9dO\x93[',
            self.peer._bytes(),
            struct.pack('<i', self.msg_id),
            struct.pack('<q', self.channel_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _msg_id = reader.read_int()
        _channel_id = reader.read_long()
        return cls(peer=_peer, msg_id=_msg_id, channel_id=_channel_id)


class InputChatPhoto(TLObject):
    CONSTRUCTOR_ID = 0x8953ad37
    SUBCLASS_OF_ID = 0xd4eb2d74

    # noinspection PyShadowingBuiltins
    def __init__(self, id: 'TypeInputPhoto'):
        """
        Constructor for InputChatPhoto: Instance of either InputChatPhotoEmpty, InputChatUploadedPhoto, InputChatPhoto.
        """
        self.id = id

    def to_dict(self):
        return {
            '_': 'InputChatPhoto',
            'id': self.id.to_dict() if isinstance(self.id, TLObject) else self.id
        }

    def _bytes(self):
        return b''.join((
            b'7\xadS\x89',
            self.id._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.tgread_object()
        return cls(id=_id)


class InputChatPhotoEmpty(TLObject):
    CONSTRUCTOR_ID = 0x1ca48f57
    SUBCLASS_OF_ID = 0xd4eb2d74

    def to_dict(self):
        return {
            '_': 'InputChatPhotoEmpty'
        }

    def _bytes(self):
        return b''.join((
            b'W\x8f\xa4\x1c',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputChatUploadedPhoto(TLObject):
    CONSTRUCTOR_ID = 0xbdcdaec0
    SUBCLASS_OF_ID = 0xd4eb2d74

    def __init__(self, file: Optional['TypeInputFile']=None, video: Optional['TypeInputFile']=None, video_start_ts: Optional[float]=None, video_emoji_markup: Optional['TypeVideoSize']=None):
        """
        Constructor for InputChatPhoto: Instance of either InputChatPhotoEmpty, InputChatUploadedPhoto, InputChatPhoto.
        """
        self.file = file
        self.video = video
        self.video_start_ts = video_start_ts
        self.video_emoji_markup = video_emoji_markup

    def to_dict(self):
        return {
            '_': 'InputChatUploadedPhoto',
            'file': self.file.to_dict() if isinstance(self.file, TLObject) else self.file,
            'video': self.video.to_dict() if isinstance(self.video, TLObject) else self.video,
            'video_start_ts': self.video_start_ts,
            'video_emoji_markup': self.video_emoji_markup.to_dict() if isinstance(self.video_emoji_markup, TLObject) else self.video_emoji_markup
        }

    def _bytes(self):
        return b''.join((
            b'\xc0\xae\xcd\xbd',
            struct.pack('<I', (0 if self.file is None or self.file is False else 1) | (0 if self.video is None or self.video is False else 2) | (0 if self.video_start_ts is None or self.video_start_ts is False else 4) | (0 if self.video_emoji_markup is None or self.video_emoji_markup is False else 8)),
            b'' if self.file is None or self.file is False else (self.file._bytes()),
            b'' if self.video is None or self.video is False else (self.video._bytes()),
            b'' if self.video_start_ts is None or self.video_start_ts is False else (struct.pack('<d', self.video_start_ts)),
            b'' if self.video_emoji_markup is None or self.video_emoji_markup is False else (self.video_emoji_markup._bytes()),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 1:
            _file = reader.tgread_object()
        else:
            _file = None
        if flags & 2:
            _video = reader.tgread_object()
        else:
            _video = None
        if flags & 4:
            _video_start_ts = reader.read_double()
        else:
            _video_start_ts = None
        if flags & 8:
            _video_emoji_markup = reader.tgread_object()
        else:
            _video_emoji_markup = None
        return cls(file=_file, video=_video, video_start_ts=_video_start_ts, video_emoji_markup=_video_emoji_markup)


class InputChatlistDialogFilter(TLObject):
    CONSTRUCTOR_ID = 0xf3e0da33
    SUBCLASS_OF_ID = 0x23f9659

    def __init__(self, filter_id: int):
        """
        Constructor for InputChatlist: Instance of InputChatlistDialogFilter.
        """
        self.filter_id = filter_id

    def to_dict(self):
        return {
            '_': 'InputChatlistDialogFilter',
            'filter_id': self.filter_id
        }

    def _bytes(self):
        return b''.join((
            b'3\xda\xe0\xf3',
            struct.pack('<i', self.filter_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _filter_id = reader.read_int()
        return cls(filter_id=_filter_id)


class InputCheckPasswordEmpty(TLObject):
    CONSTRUCTOR_ID = 0x9880f658
    SUBCLASS_OF_ID = 0xd41af560

    def to_dict(self):
        return {
            '_': 'InputCheckPasswordEmpty'
        }

    def _bytes(self):
        return b''.join((
            b'X\xf6\x80\x98',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputCheckPasswordSRP(TLObject):
    CONSTRUCTOR_ID = 0xd27ff082
    SUBCLASS_OF_ID = 0xd41af560

    def __init__(self, srp_id: int, A: bytes, M1: bytes):
        """
        Constructor for InputCheckPasswordSRP: Instance of either InputCheckPasswordEmpty, InputCheckPasswordSRP.
        """
        self.srp_id = srp_id
        self.A = A
        self.M1 = M1

    def to_dict(self):
        return {
            '_': 'InputCheckPasswordSRP',
            'srp_id': self.srp_id,
            'A': self.A,
            'M1': self.M1
        }

    def _bytes(self):
        return b''.join((
            b'\x82\xf0\x7f\xd2',
            struct.pack('<q', self.srp_id),
            self.serialize_bytes(self.A),
            self.serialize_bytes(self.M1),
        ))

    @classmethod
    def from_reader(cls, reader):
        _srp_id = reader.read_long()
        _A = reader.tgread_bytes()
        _M1 = reader.tgread_bytes()
        return cls(srp_id=_srp_id, A=_A, M1=_M1)


class InputClientProxy(TLObject):
    CONSTRUCTOR_ID = 0x75588b3f
    SUBCLASS_OF_ID = 0x91a4346

    def __init__(self, address: str, port: int):
        """
        Constructor for InputClientProxy: Instance of InputClientProxy.
        """
        self.address = address
        self.port = port

    def to_dict(self):
        return {
            '_': 'InputClientProxy',
            'address': self.address,
            'port': self.port
        }

    def _bytes(self):
        return b''.join((
            b'?\x8bXu',
            self.serialize_bytes(self.address),
            struct.pack('<i', self.port),
        ))

    @classmethod
    def from_reader(cls, reader):
        _address = reader.tgread_string()
        _port = reader.read_int()
        return cls(address=_address, port=_port)


class InputDialogPeer(TLObject):
    CONSTRUCTOR_ID = 0xfcaafeb7
    SUBCLASS_OF_ID = 0xa21c9795

    def __init__(self, peer: 'TypeInputPeer'):
        """
        Constructor for InputDialogPeer: Instance of either InputDialogPeer, InputDialogPeerFolder.
        """
        self.peer = peer

    def to_dict(self):
        return {
            '_': 'InputDialogPeer',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer
        }

    def _bytes(self):
        return b''.join((
            b'\xb7\xfe\xaa\xfc',
            self.peer._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        return cls(peer=_peer)


class InputDialogPeerFolder(TLObject):
    CONSTRUCTOR_ID = 0x64600527
    SUBCLASS_OF_ID = 0xa21c9795

    def __init__(self, folder_id: int):
        """
        Constructor for InputDialogPeer: Instance of either InputDialogPeer, InputDialogPeerFolder.
        """
        self.folder_id = folder_id

    def to_dict(self):
        return {
            '_': 'InputDialogPeerFolder',
            'folder_id': self.folder_id
        }

    def _bytes(self):
        return b''.join((
            b"'\x05`d",
            struct.pack('<i', self.folder_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _folder_id = reader.read_int()
        return cls(folder_id=_folder_id)


class InputDocument(TLObject):
    CONSTRUCTOR_ID = 0x1abfb575
    SUBCLASS_OF_ID = 0xf33fdb68

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, file_reference: bytes):
        """
        Constructor for InputDocument: Instance of either InputDocumentEmpty, InputDocument.
        """
        self.id = id
        self.access_hash = access_hash
        self.file_reference = file_reference

    def to_dict(self):
        return {
            '_': 'InputDocument',
            'id': self.id,
            'access_hash': self.access_hash,
            'file_reference': self.file_reference
        }

    def _bytes(self):
        return b''.join((
            b'u\xb5\xbf\x1a',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            self.serialize_bytes(self.file_reference),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        _file_reference = reader.tgread_bytes()
        return cls(id=_id, access_hash=_access_hash, file_reference=_file_reference)


class InputDocumentEmpty(TLObject):
    CONSTRUCTOR_ID = 0x72f0eaae
    SUBCLASS_OF_ID = 0xf33fdb68

    def to_dict(self):
        return {
            '_': 'InputDocumentEmpty'
        }

    def _bytes(self):
        return b''.join((
            b'\xae\xea\xf0r',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputDocumentFileLocation(TLObject):
    CONSTRUCTOR_ID = 0xbad07584
    SUBCLASS_OF_ID = 0x1523d462

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, file_reference: bytes, thumb_size: str):
        """
        Constructor for InputFileLocation: Instance of either InputFileLocation, InputEncryptedFileLocation, InputDocumentFileLocation, InputSecureFileLocation, InputTakeoutFileLocation, InputPhotoFileLocation, InputPhotoLegacyFileLocation, InputPeerPhotoFileLocation, InputStickerSetThumb, InputGroupCallStream.
        """
        self.id = id
        self.access_hash = access_hash
        self.file_reference = file_reference
        self.thumb_size = thumb_size

    def to_dict(self):
        return {
            '_': 'InputDocumentFileLocation',
            'id': self.id,
            'access_hash': self.access_hash,
            'file_reference': self.file_reference,
            'thumb_size': self.thumb_size
        }

    def _bytes(self):
        return b''.join((
            b'\x84u\xd0\xba',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            self.serialize_bytes(self.file_reference),
            self.serialize_bytes(self.thumb_size),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        _file_reference = reader.tgread_bytes()
        _thumb_size = reader.tgread_string()
        return cls(id=_id, access_hash=_access_hash, file_reference=_file_reference, thumb_size=_thumb_size)


class InputEncryptedChat(TLObject):
    CONSTRUCTOR_ID = 0xf141b5e1
    SUBCLASS_OF_ID = 0x6c7606c0

    def __init__(self, chat_id: int, access_hash: int):
        """
        Constructor for InputEncryptedChat: Instance of InputEncryptedChat.
        """
        self.chat_id = chat_id
        self.access_hash = access_hash

    def to_dict(self):
        return {
            '_': 'InputEncryptedChat',
            'chat_id': self.chat_id,
            'access_hash': self.access_hash
        }

    def _bytes(self):
        return b''.join((
            b'\xe1\xb5A\xf1',
            struct.pack('<i', self.chat_id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _chat_id = reader.read_int()
        _access_hash = reader.read_long()
        return cls(chat_id=_chat_id, access_hash=_access_hash)


class InputEncryptedFile(TLObject):
    CONSTRUCTOR_ID = 0x5a17b5e5
    SUBCLASS_OF_ID = 0x8574c27a

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int):
        """
        Constructor for InputEncryptedFile: Instance of either InputEncryptedFileEmpty, InputEncryptedFileUploaded, InputEncryptedFile, InputEncryptedFileBigUploaded.
        """
        self.id = id
        self.access_hash = access_hash

    def to_dict(self):
        return {
            '_': 'InputEncryptedFile',
            'id': self.id,
            'access_hash': self.access_hash
        }

    def _bytes(self):
        return b''.join((
            b'\xe5\xb5\x17Z',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        return cls(id=_id, access_hash=_access_hash)


class InputEncryptedFileBigUploaded(TLObject):
    CONSTRUCTOR_ID = 0x2dc173c8
    SUBCLASS_OF_ID = 0x8574c27a

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, parts: int, key_fingerprint: int):
        """
        Constructor for InputEncryptedFile: Instance of either InputEncryptedFileEmpty, InputEncryptedFileUploaded, InputEncryptedFile, InputEncryptedFileBigUploaded.
        """
        self.id = id
        self.parts = parts
        self.key_fingerprint = key_fingerprint

    def to_dict(self):
        return {
            '_': 'InputEncryptedFileBigUploaded',
            'id': self.id,
            'parts': self.parts,
            'key_fingerprint': self.key_fingerprint
        }

    def _bytes(self):
        return b''.join((
            b'\xc8s\xc1-',
            struct.pack('<q', self.id),
            struct.pack('<i', self.parts),
            struct.pack('<i', self.key_fingerprint),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _parts = reader.read_int()
        _key_fingerprint = reader.read_int()
        return cls(id=_id, parts=_parts, key_fingerprint=_key_fingerprint)


class InputEncryptedFileEmpty(TLObject):
    CONSTRUCTOR_ID = 0x1837c364
    SUBCLASS_OF_ID = 0x8574c27a

    def to_dict(self):
        return {
            '_': 'InputEncryptedFileEmpty'
        }

    def _bytes(self):
        return b''.join((
            b'd\xc37\x18',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputEncryptedFileLocation(TLObject):
    CONSTRUCTOR_ID = 0xf5235d55
    SUBCLASS_OF_ID = 0x1523d462

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int):
        """
        Constructor for InputFileLocation: Instance of either InputFileLocation, InputEncryptedFileLocation, InputDocumentFileLocation, InputSecureFileLocation, InputTakeoutFileLocation, InputPhotoFileLocation, InputPhotoLegacyFileLocation, InputPeerPhotoFileLocation, InputStickerSetThumb, InputGroupCallStream.
        """
        self.id = id
        self.access_hash = access_hash

    def to_dict(self):
        return {
            '_': 'InputEncryptedFileLocation',
            'id': self.id,
            'access_hash': self.access_hash
        }

    def _bytes(self):
        return b''.join((
            b'U]#\xf5',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        return cls(id=_id, access_hash=_access_hash)


class InputEncryptedFileUploaded(TLObject):
    CONSTRUCTOR_ID = 0x64bd0306
    SUBCLASS_OF_ID = 0x8574c27a

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, parts: int, md5_checksum: str, key_fingerprint: int):
        """
        Constructor for InputEncryptedFile: Instance of either InputEncryptedFileEmpty, InputEncryptedFileUploaded, InputEncryptedFile, InputEncryptedFileBigUploaded.
        """
        self.id = id
        self.parts = parts
        self.md5_checksum = md5_checksum
        self.key_fingerprint = key_fingerprint

    def to_dict(self):
        return {
            '_': 'InputEncryptedFileUploaded',
            'id': self.id,
            'parts': self.parts,
            'md5_checksum': self.md5_checksum,
            'key_fingerprint': self.key_fingerprint
        }

    def _bytes(self):
        return b''.join((
            b'\x06\x03\xbdd',
            struct.pack('<q', self.id),
            struct.pack('<i', self.parts),
            self.serialize_bytes(self.md5_checksum),
            struct.pack('<i', self.key_fingerprint),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _parts = reader.read_int()
        _md5_checksum = reader.tgread_string()
        _key_fingerprint = reader.read_int()
        return cls(id=_id, parts=_parts, md5_checksum=_md5_checksum, key_fingerprint=_key_fingerprint)


class InputFile(TLObject):
    CONSTRUCTOR_ID = 0xf52ff27f
    SUBCLASS_OF_ID = 0xe7655f1f

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, parts: int, name: str, md5_checksum: str):
        """
        Constructor for InputFile: Instance of either InputFile, InputFileBig.
        """
        self.id = id
        self.parts = parts
        self.name = name
        self.md5_checksum = md5_checksum

    def to_dict(self):
        return {
            '_': 'InputFile',
            'id': self.id,
            'parts': self.parts,
            'name': self.name,
            'md5_checksum': self.md5_checksum
        }

    def _bytes(self):
        return b''.join((
            b'\x7f\xf2/\xf5',
            struct.pack('<q', self.id),
            struct.pack('<i', self.parts),
            self.serialize_bytes(self.name),
            self.serialize_bytes(self.md5_checksum),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _parts = reader.read_int()
        _name = reader.tgread_string()
        _md5_checksum = reader.tgread_string()
        return cls(id=_id, parts=_parts, name=_name, md5_checksum=_md5_checksum)


class InputFileBig(TLObject):
    CONSTRUCTOR_ID = 0xfa4f0bb5
    SUBCLASS_OF_ID = 0xe7655f1f

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, parts: int, name: str):
        """
        Constructor for InputFile: Instance of either InputFile, InputFileBig.
        """
        self.id = id
        self.parts = parts
        self.name = name

    def to_dict(self):
        return {
            '_': 'InputFileBig',
            'id': self.id,
            'parts': self.parts,
            'name': self.name
        }

    def _bytes(self):
        return b''.join((
            b'\xb5\x0bO\xfa',
            struct.pack('<q', self.id),
            struct.pack('<i', self.parts),
            self.serialize_bytes(self.name),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _parts = reader.read_int()
        _name = reader.tgread_string()
        return cls(id=_id, parts=_parts, name=_name)


class InputFileLocation(TLObject):
    CONSTRUCTOR_ID = 0xdfdaabe1
    SUBCLASS_OF_ID = 0x1523d462

    def __init__(self, volume_id: int, local_id: int, secret: int, file_reference: bytes):
        """
        Constructor for InputFileLocation: Instance of either InputFileLocation, InputEncryptedFileLocation, InputDocumentFileLocation, InputSecureFileLocation, InputTakeoutFileLocation, InputPhotoFileLocation, InputPhotoLegacyFileLocation, InputPeerPhotoFileLocation, InputStickerSetThumb, InputGroupCallStream.
        """
        self.volume_id = volume_id
        self.local_id = local_id
        self.secret = secret
        self.file_reference = file_reference

    def to_dict(self):
        return {
            '_': 'InputFileLocation',
            'volume_id': self.volume_id,
            'local_id': self.local_id,
            'secret': self.secret,
            'file_reference': self.file_reference
        }

    def _bytes(self):
        return b''.join((
            b'\xe1\xab\xda\xdf',
            struct.pack('<q', self.volume_id),
            struct.pack('<i', self.local_id),
            struct.pack('<q', self.secret),
            self.serialize_bytes(self.file_reference),
        ))

    @classmethod
    def from_reader(cls, reader):
        _volume_id = reader.read_long()
        _local_id = reader.read_int()
        _secret = reader.read_long()
        _file_reference = reader.tgread_bytes()
        return cls(volume_id=_volume_id, local_id=_local_id, secret=_secret, file_reference=_file_reference)


class InputFolderPeer(TLObject):
    CONSTRUCTOR_ID = 0xfbd2c296
    SUBCLASS_OF_ID = 0x74825e00

    def __init__(self, peer: 'TypeInputPeer', folder_id: int):
        """
        Constructor for InputFolderPeer: Instance of InputFolderPeer.
        """
        self.peer = peer
        self.folder_id = folder_id

    def to_dict(self):
        return {
            '_': 'InputFolderPeer',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'folder_id': self.folder_id
        }

    def _bytes(self):
        return b''.join((
            b'\x96\xc2\xd2\xfb',
            self.peer._bytes(),
            struct.pack('<i', self.folder_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _folder_id = reader.read_int()
        return cls(peer=_peer, folder_id=_folder_id)


class InputGameID(TLObject):
    CONSTRUCTOR_ID = 0x32c3e77
    SUBCLASS_OF_ID = 0x48d15883

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int):
        """
        Constructor for InputGame: Instance of either InputGameID, InputGameShortName.
        """
        self.id = id
        self.access_hash = access_hash

    def to_dict(self):
        return {
            '_': 'InputGameID',
            'id': self.id,
            'access_hash': self.access_hash
        }

    def _bytes(self):
        return b''.join((
            b'w>,\x03',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        return cls(id=_id, access_hash=_access_hash)


class InputGameShortName(TLObject):
    CONSTRUCTOR_ID = 0xc331e80a
    SUBCLASS_OF_ID = 0x48d15883

    def __init__(self, bot_id: 'TypeInputUser', short_name: str):
        """
        Constructor for InputGame: Instance of either InputGameID, InputGameShortName.
        """
        self.bot_id = bot_id
        self.short_name = short_name

    def to_dict(self):
        return {
            '_': 'InputGameShortName',
            'bot_id': self.bot_id.to_dict() if isinstance(self.bot_id, TLObject) else self.bot_id,
            'short_name': self.short_name
        }

    def _bytes(self):
        return b''.join((
            b'\n\xe81\xc3',
            self.bot_id._bytes(),
            self.serialize_bytes(self.short_name),
        ))

    @classmethod
    def from_reader(cls, reader):
        _bot_id = reader.tgread_object()
        _short_name = reader.tgread_string()
        return cls(bot_id=_bot_id, short_name=_short_name)


class InputGeoPoint(TLObject):
    CONSTRUCTOR_ID = 0x48222faf
    SUBCLASS_OF_ID = 0x430d225

    def __init__(self, lat: float, long: float, accuracy_radius: Optional[int]=None):
        """
        Constructor for InputGeoPoint: Instance of either InputGeoPointEmpty, InputGeoPoint.
        """
        self.lat = lat
        self.long = long
        self.accuracy_radius = accuracy_radius

    def to_dict(self):
        return {
            '_': 'InputGeoPoint',
            'lat': self.lat,
            'long': self.long,
            'accuracy_radius': self.accuracy_radius
        }

    def _bytes(self):
        return b''.join((
            b'\xaf/"H',
            struct.pack('<I', (0 if self.accuracy_radius is None or self.accuracy_radius is False else 1)),
            struct.pack('<d', self.lat),
            struct.pack('<d', self.long),
            b'' if self.accuracy_radius is None or self.accuracy_radius is False else (struct.pack('<i', self.accuracy_radius)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _lat = reader.read_double()
        _long = reader.read_double()
        if flags & 1:
            _accuracy_radius = reader.read_int()
        else:
            _accuracy_radius = None
        return cls(lat=_lat, long=_long, accuracy_radius=_accuracy_radius)


class InputGeoPointEmpty(TLObject):
    CONSTRUCTOR_ID = 0xe4c123d6
    SUBCLASS_OF_ID = 0x430d225

    def to_dict(self):
        return {
            '_': 'InputGeoPointEmpty'
        }

    def _bytes(self):
        return b''.join((
            b'\xd6#\xc1\xe4',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputGroupCall(TLObject):
    CONSTRUCTOR_ID = 0xd8aa840f
    SUBCLASS_OF_ID = 0x58611ab1

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int):
        """
        Constructor for InputGroupCall: Instance of InputGroupCall.
        """
        self.id = id
        self.access_hash = access_hash

    def to_dict(self):
        return {
            '_': 'InputGroupCall',
            'id': self.id,
            'access_hash': self.access_hash
        }

    def _bytes(self):
        return b''.join((
            b'\x0f\x84\xaa\xd8',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        return cls(id=_id, access_hash=_access_hash)


class InputGroupCallStream(TLObject):
    CONSTRUCTOR_ID = 0x598a92a
    SUBCLASS_OF_ID = 0x1523d462

    def __init__(self, call: 'TypeInputGroupCall', time_ms: int, scale: int, video_channel: Optional[int]=None, video_quality: Optional[int]=None):
        """
        Constructor for InputFileLocation: Instance of either InputFileLocation, InputEncryptedFileLocation, InputDocumentFileLocation, InputSecureFileLocation, InputTakeoutFileLocation, InputPhotoFileLocation, InputPhotoLegacyFileLocation, InputPeerPhotoFileLocation, InputStickerSetThumb, InputGroupCallStream.
        """
        self.call = call
        self.time_ms = time_ms
        self.scale = scale
        self.video_channel = video_channel
        self.video_quality = video_quality

    def to_dict(self):
        return {
            '_': 'InputGroupCallStream',
            'call': self.call.to_dict() if isinstance(self.call, TLObject) else self.call,
            'time_ms': self.time_ms,
            'scale': self.scale,
            'video_channel': self.video_channel,
            'video_quality': self.video_quality
        }

    def _bytes(self):
        assert ((self.video_channel or self.video_channel is not None) and (self.video_quality or self.video_quality is not None)) or ((self.video_channel is None or self.video_channel is False) and (self.video_quality is None or self.video_quality is False)), 'video_channel, video_quality parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'*\xa9\x98\x05',
            struct.pack('<I', (0 if self.video_channel is None or self.video_channel is False else 1) | (0 if self.video_quality is None or self.video_quality is False else 1)),
            self.call._bytes(),
            struct.pack('<q', self.time_ms),
            struct.pack('<i', self.scale),
            b'' if self.video_channel is None or self.video_channel is False else (struct.pack('<i', self.video_channel)),
            b'' if self.video_quality is None or self.video_quality is False else (struct.pack('<i', self.video_quality)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _call = reader.tgread_object()
        _time_ms = reader.read_long()
        _scale = reader.read_int()
        if flags & 1:
            _video_channel = reader.read_int()
        else:
            _video_channel = None
        if flags & 1:
            _video_quality = reader.read_int()
        else:
            _video_quality = None
        return cls(call=_call, time_ms=_time_ms, scale=_scale, video_channel=_video_channel, video_quality=_video_quality)


class InputInvoiceMessage(TLObject):
    CONSTRUCTOR_ID = 0xc5b56859
    SUBCLASS_OF_ID = 0x726e9bfe

    def __init__(self, peer: 'TypeInputPeer', msg_id: int):
        """
        Constructor for InputInvoice: Instance of either InputInvoiceMessage, InputInvoiceSlug, InputInvoicePremiumGiftCode.
        """
        self.peer = peer
        self.msg_id = msg_id

    def to_dict(self):
        return {
            '_': 'InputInvoiceMessage',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'msg_id': self.msg_id
        }

    def _bytes(self):
        return b''.join((
            b'Yh\xb5\xc5',
            self.peer._bytes(),
            struct.pack('<i', self.msg_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _msg_id = reader.read_int()
        return cls(peer=_peer, msg_id=_msg_id)


class InputInvoicePremiumGiftCode(TLObject):
    CONSTRUCTOR_ID = 0x98986c0d
    SUBCLASS_OF_ID = 0x726e9bfe

    def __init__(self, purpose: 'TypeInputStorePaymentPurpose', option: 'TypePremiumGiftCodeOption'):
        """
        Constructor for InputInvoice: Instance of either InputInvoiceMessage, InputInvoiceSlug, InputInvoicePremiumGiftCode.
        """
        self.purpose = purpose
        self.option = option

    def to_dict(self):
        return {
            '_': 'InputInvoicePremiumGiftCode',
            'purpose': self.purpose.to_dict() if isinstance(self.purpose, TLObject) else self.purpose,
            'option': self.option.to_dict() if isinstance(self.option, TLObject) else self.option
        }

    def _bytes(self):
        return b''.join((
            b'\rl\x98\x98',
            self.purpose._bytes(),
            self.option._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _purpose = reader.tgread_object()
        _option = reader.tgread_object()
        return cls(purpose=_purpose, option=_option)


class InputInvoiceSlug(TLObject):
    CONSTRUCTOR_ID = 0xc326caef
    SUBCLASS_OF_ID = 0x726e9bfe

    def __init__(self, slug: str):
        """
        Constructor for InputInvoice: Instance of either InputInvoiceMessage, InputInvoiceSlug, InputInvoicePremiumGiftCode.
        """
        self.slug = slug

    def to_dict(self):
        return {
            '_': 'InputInvoiceSlug',
            'slug': self.slug
        }

    def _bytes(self):
        return b''.join((
            b'\xef\xca&\xc3',
            self.serialize_bytes(self.slug),
        ))

    @classmethod
    def from_reader(cls, reader):
        _slug = reader.tgread_string()
        return cls(slug=_slug)


class InputKeyboardButtonUrlAuth(TLObject):
    CONSTRUCTOR_ID = 0xd02e7fd4
    SUBCLASS_OF_ID = 0xbad74a3

    def __init__(self, text: str, url: str, bot: 'TypeInputUser', request_write_access: Optional[bool]=None, fwd_text: Optional[str]=None):
        """
        Constructor for KeyboardButton: Instance of either KeyboardButton, KeyboardButtonUrl, KeyboardButtonCallback, KeyboardButtonRequestPhone, KeyboardButtonRequestGeoLocation, KeyboardButtonSwitchInline, KeyboardButtonGame, KeyboardButtonBuy, KeyboardButtonUrlAuth, InputKeyboardButtonUrlAuth, KeyboardButtonRequestPoll, InputKeyboardButtonUserProfile, KeyboardButtonUserProfile, KeyboardButtonWebView, KeyboardButtonSimpleWebView, KeyboardButtonRequestPeer.
        """
        self.text = text
        self.url = url
        self.bot = bot
        self.request_write_access = request_write_access
        self.fwd_text = fwd_text

    def to_dict(self):
        return {
            '_': 'InputKeyboardButtonUrlAuth',
            'text': self.text,
            'url': self.url,
            'bot': self.bot.to_dict() if isinstance(self.bot, TLObject) else self.bot,
            'request_write_access': self.request_write_access,
            'fwd_text': self.fwd_text
        }

    def _bytes(self):
        return b''.join((
            b'\xd4\x7f.\xd0',
            struct.pack('<I', (0 if self.request_write_access is None or self.request_write_access is False else 1) | (0 if self.fwd_text is None or self.fwd_text is False else 2)),
            self.serialize_bytes(self.text),
            b'' if self.fwd_text is None or self.fwd_text is False else (self.serialize_bytes(self.fwd_text)),
            self.serialize_bytes(self.url),
            self.bot._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _request_write_access = bool(flags & 1)
        _text = reader.tgread_string()
        if flags & 2:
            _fwd_text = reader.tgread_string()
        else:
            _fwd_text = None
        _url = reader.tgread_string()
        _bot = reader.tgread_object()
        return cls(text=_text, url=_url, bot=_bot, request_write_access=_request_write_access, fwd_text=_fwd_text)


class InputKeyboardButtonUserProfile(TLObject):
    CONSTRUCTOR_ID = 0xe988037b
    SUBCLASS_OF_ID = 0xbad74a3

    def __init__(self, text: str, user_id: 'TypeInputUser'):
        """
        Constructor for KeyboardButton: Instance of either KeyboardButton, KeyboardButtonUrl, KeyboardButtonCallback, KeyboardButtonRequestPhone, KeyboardButtonRequestGeoLocation, KeyboardButtonSwitchInline, KeyboardButtonGame, KeyboardButtonBuy, KeyboardButtonUrlAuth, InputKeyboardButtonUrlAuth, KeyboardButtonRequestPoll, InputKeyboardButtonUserProfile, KeyboardButtonUserProfile, KeyboardButtonWebView, KeyboardButtonSimpleWebView, KeyboardButtonRequestPeer.
        """
        self.text = text
        self.user_id = user_id

    def to_dict(self):
        return {
            '_': 'InputKeyboardButtonUserProfile',
            'text': self.text,
            'user_id': self.user_id.to_dict() if isinstance(self.user_id, TLObject) else self.user_id
        }

    def _bytes(self):
        return b''.join((
            b'{\x03\x88\xe9',
            self.serialize_bytes(self.text),
            self.user_id._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_string()
        _user_id = reader.tgread_object()
        return cls(text=_text, user_id=_user_id)


class InputMediaAreaVenue(TLObject):
    CONSTRUCTOR_ID = 0xb282217f
    SUBCLASS_OF_ID = 0xf36d7bf2

    def __init__(self, coordinates: 'TypeMediaAreaCoordinates', query_id: int, result_id: str):
        """
        Constructor for MediaArea: Instance of either MediaAreaVenue, InputMediaAreaVenue, MediaAreaGeoPoint, MediaAreaSuggestedReaction.
        """
        self.coordinates = coordinates
        self.query_id = query_id
        self.result_id = result_id

    def to_dict(self):
        return {
            '_': 'InputMediaAreaVenue',
            'coordinates': self.coordinates.to_dict() if isinstance(self.coordinates, TLObject) else self.coordinates,
            'query_id': self.query_id,
            'result_id': self.result_id
        }

    def _bytes(self):
        return b''.join((
            b'\x7f!\x82\xb2',
            self.coordinates._bytes(),
            struct.pack('<q', self.query_id),
            self.serialize_bytes(self.result_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _coordinates = reader.tgread_object()
        _query_id = reader.read_long()
        _result_id = reader.tgread_string()
        return cls(coordinates=_coordinates, query_id=_query_id, result_id=_result_id)


class InputMediaContact(TLObject):
    CONSTRUCTOR_ID = 0xf8ab7dfb
    SUBCLASS_OF_ID = 0xfaf846f4

    def __init__(self, phone_number: str, first_name: str, last_name: str, vcard: str):
        """
        Constructor for InputMedia: Instance of either InputMediaEmpty, InputMediaUploadedPhoto, InputMediaPhoto, InputMediaGeoPoint, InputMediaContact, InputMediaUploadedDocument, InputMediaDocument, InputMediaVenue, InputMediaPhotoExternal, InputMediaDocumentExternal, InputMediaGame, InputMediaInvoice, InputMediaGeoLive, InputMediaPoll, InputMediaDice, InputMediaStory, InputMediaWebPage.
        """
        self.phone_number = phone_number
        self.first_name = first_name
        self.last_name = last_name
        self.vcard = vcard

    def to_dict(self):
        return {
            '_': 'InputMediaContact',
            'phone_number': self.phone_number,
            'first_name': self.first_name,
            'last_name': self.last_name,
            'vcard': self.vcard
        }

    def _bytes(self):
        return b''.join((
            b'\xfb}\xab\xf8',
            self.serialize_bytes(self.phone_number),
            self.serialize_bytes(self.first_name),
            self.serialize_bytes(self.last_name),
            self.serialize_bytes(self.vcard),
        ))

    @classmethod
    def from_reader(cls, reader):
        _phone_number = reader.tgread_string()
        _first_name = reader.tgread_string()
        _last_name = reader.tgread_string()
        _vcard = reader.tgread_string()
        return cls(phone_number=_phone_number, first_name=_first_name, last_name=_last_name, vcard=_vcard)


class InputMediaDice(TLObject):
    CONSTRUCTOR_ID = 0xe66fbf7b
    SUBCLASS_OF_ID = 0xfaf846f4

    def __init__(self, emoticon: str):
        """
        Constructor for InputMedia: Instance of either InputMediaEmpty, InputMediaUploadedPhoto, InputMediaPhoto, InputMediaGeoPoint, InputMediaContact, InputMediaUploadedDocument, InputMediaDocument, InputMediaVenue, InputMediaPhotoExternal, InputMediaDocumentExternal, InputMediaGame, InputMediaInvoice, InputMediaGeoLive, InputMediaPoll, InputMediaDice, InputMediaStory, InputMediaWebPage.
        """
        self.emoticon = emoticon

    def to_dict(self):
        return {
            '_': 'InputMediaDice',
            'emoticon': self.emoticon
        }

    def _bytes(self):
        return b''.join((
            b'{\xbfo\xe6',
            self.serialize_bytes(self.emoticon),
        ))

    @classmethod
    def from_reader(cls, reader):
        _emoticon = reader.tgread_string()
        return cls(emoticon=_emoticon)


class InputMediaDocument(TLObject):
    CONSTRUCTOR_ID = 0x33473058
    SUBCLASS_OF_ID = 0xfaf846f4

    # noinspection PyShadowingBuiltins
    def __init__(self, id: 'TypeInputDocument', spoiler: Optional[bool]=None, ttl_seconds: Optional[int]=None, query: Optional[str]=None):
        """
        Constructor for InputMedia: Instance of either InputMediaEmpty, InputMediaUploadedPhoto, InputMediaPhoto, InputMediaGeoPoint, InputMediaContact, InputMediaUploadedDocument, InputMediaDocument, InputMediaVenue, InputMediaPhotoExternal, InputMediaDocumentExternal, InputMediaGame, InputMediaInvoice, InputMediaGeoLive, InputMediaPoll, InputMediaDice, InputMediaStory, InputMediaWebPage.
        """
        self.id = id
        self.spoiler = spoiler
        self.ttl_seconds = ttl_seconds
        self.query = query

    def to_dict(self):
        return {
            '_': 'InputMediaDocument',
            'id': self.id.to_dict() if isinstance(self.id, TLObject) else self.id,
            'spoiler': self.spoiler,
            'ttl_seconds': self.ttl_seconds,
            'query': self.query
        }

    def _bytes(self):
        return b''.join((
            b'X0G3',
            struct.pack('<I', (0 if self.spoiler is None or self.spoiler is False else 4) | (0 if self.ttl_seconds is None or self.ttl_seconds is False else 1) | (0 if self.query is None or self.query is False else 2)),
            self.id._bytes(),
            b'' if self.ttl_seconds is None or self.ttl_seconds is False else (struct.pack('<i', self.ttl_seconds)),
            b'' if self.query is None or self.query is False else (self.serialize_bytes(self.query)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _spoiler = bool(flags & 4)
        _id = reader.tgread_object()
        if flags & 1:
            _ttl_seconds = reader.read_int()
        else:
            _ttl_seconds = None
        if flags & 2:
            _query = reader.tgread_string()
        else:
            _query = None
        return cls(id=_id, spoiler=_spoiler, ttl_seconds=_ttl_seconds, query=_query)


class InputMediaDocumentExternal(TLObject):
    CONSTRUCTOR_ID = 0xfb52dc99
    SUBCLASS_OF_ID = 0xfaf846f4

    def __init__(self, url: str, spoiler: Optional[bool]=None, ttl_seconds: Optional[int]=None):
        """
        Constructor for InputMedia: Instance of either InputMediaEmpty, InputMediaUploadedPhoto, InputMediaPhoto, InputMediaGeoPoint, InputMediaContact, InputMediaUploadedDocument, InputMediaDocument, InputMediaVenue, InputMediaPhotoExternal, InputMediaDocumentExternal, InputMediaGame, InputMediaInvoice, InputMediaGeoLive, InputMediaPoll, InputMediaDice, InputMediaStory, InputMediaWebPage.
        """
        self.url = url
        self.spoiler = spoiler
        self.ttl_seconds = ttl_seconds

    def to_dict(self):
        return {
            '_': 'InputMediaDocumentExternal',
            'url': self.url,
            'spoiler': self.spoiler,
            'ttl_seconds': self.ttl_seconds
        }

    def _bytes(self):
        return b''.join((
            b'\x99\xdcR\xfb',
            struct.pack('<I', (0 if self.spoiler is None or self.spoiler is False else 2) | (0 if self.ttl_seconds is None or self.ttl_seconds is False else 1)),
            self.serialize_bytes(self.url),
            b'' if self.ttl_seconds is None or self.ttl_seconds is False else (struct.pack('<i', self.ttl_seconds)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _spoiler = bool(flags & 2)
        _url = reader.tgread_string()
        if flags & 1:
            _ttl_seconds = reader.read_int()
        else:
            _ttl_seconds = None
        return cls(url=_url, spoiler=_spoiler, ttl_seconds=_ttl_seconds)


class InputMediaEmpty(TLObject):
    CONSTRUCTOR_ID = 0x9664f57f
    SUBCLASS_OF_ID = 0xfaf846f4

    def to_dict(self):
        return {
            '_': 'InputMediaEmpty'
        }

    def _bytes(self):
        return b''.join((
            b'\x7f\xf5d\x96',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputMediaGame(TLObject):
    CONSTRUCTOR_ID = 0xd33f43f3
    SUBCLASS_OF_ID = 0xfaf846f4

    # noinspection PyShadowingBuiltins
    def __init__(self, id: 'TypeInputGame'):
        """
        Constructor for InputMedia: Instance of either InputMediaEmpty, InputMediaUploadedPhoto, InputMediaPhoto, InputMediaGeoPoint, InputMediaContact, InputMediaUploadedDocument, InputMediaDocument, InputMediaVenue, InputMediaPhotoExternal, InputMediaDocumentExternal, InputMediaGame, InputMediaInvoice, InputMediaGeoLive, InputMediaPoll, InputMediaDice, InputMediaStory, InputMediaWebPage.
        """
        self.id = id

    def to_dict(self):
        return {
            '_': 'InputMediaGame',
            'id': self.id.to_dict() if isinstance(self.id, TLObject) else self.id
        }

    def _bytes(self):
        return b''.join((
            b'\xf3C?\xd3',
            self.id._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.tgread_object()
        return cls(id=_id)


class InputMediaGeoLive(TLObject):
    CONSTRUCTOR_ID = 0x971fa843
    SUBCLASS_OF_ID = 0xfaf846f4

    def __init__(self, geo_point: 'TypeInputGeoPoint', stopped: Optional[bool]=None, heading: Optional[int]=None, period: Optional[int]=None, proximity_notification_radius: Optional[int]=None):
        """
        Constructor for InputMedia: Instance of either InputMediaEmpty, InputMediaUploadedPhoto, InputMediaPhoto, InputMediaGeoPoint, InputMediaContact, InputMediaUploadedDocument, InputMediaDocument, InputMediaVenue, InputMediaPhotoExternal, InputMediaDocumentExternal, InputMediaGame, InputMediaInvoice, InputMediaGeoLive, InputMediaPoll, InputMediaDice, InputMediaStory, InputMediaWebPage.
        """
        self.geo_point = geo_point
        self.stopped = stopped
        self.heading = heading
        self.period = period
        self.proximity_notification_radius = proximity_notification_radius

    def to_dict(self):
        return {
            '_': 'InputMediaGeoLive',
            'geo_point': self.geo_point.to_dict() if isinstance(self.geo_point, TLObject) else self.geo_point,
            'stopped': self.stopped,
            'heading': self.heading,
            'period': self.period,
            'proximity_notification_radius': self.proximity_notification_radius
        }

    def _bytes(self):
        return b''.join((
            b'C\xa8\x1f\x97',
            struct.pack('<I', (0 if self.stopped is None or self.stopped is False else 1) | (0 if self.heading is None or self.heading is False else 4) | (0 if self.period is None or self.period is False else 2) | (0 if self.proximity_notification_radius is None or self.proximity_notification_radius is False else 8)),
            self.geo_point._bytes(),
            b'' if self.heading is None or self.heading is False else (struct.pack('<i', self.heading)),
            b'' if self.period is None or self.period is False else (struct.pack('<i', self.period)),
            b'' if self.proximity_notification_radius is None or self.proximity_notification_radius is False else (struct.pack('<i', self.proximity_notification_radius)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _stopped = bool(flags & 1)
        _geo_point = reader.tgread_object()
        if flags & 4:
            _heading = reader.read_int()
        else:
            _heading = None
        if flags & 2:
            _period = reader.read_int()
        else:
            _period = None
        if flags & 8:
            _proximity_notification_radius = reader.read_int()
        else:
            _proximity_notification_radius = None
        return cls(geo_point=_geo_point, stopped=_stopped, heading=_heading, period=_period, proximity_notification_radius=_proximity_notification_radius)


class InputMediaGeoPoint(TLObject):
    CONSTRUCTOR_ID = 0xf9c44144
    SUBCLASS_OF_ID = 0xfaf846f4

    def __init__(self, geo_point: 'TypeInputGeoPoint'):
        """
        Constructor for InputMedia: Instance of either InputMediaEmpty, InputMediaUploadedPhoto, InputMediaPhoto, InputMediaGeoPoint, InputMediaContact, InputMediaUploadedDocument, InputMediaDocument, InputMediaVenue, InputMediaPhotoExternal, InputMediaDocumentExternal, InputMediaGame, InputMediaInvoice, InputMediaGeoLive, InputMediaPoll, InputMediaDice, InputMediaStory, InputMediaWebPage.
        """
        self.geo_point = geo_point

    def to_dict(self):
        return {
            '_': 'InputMediaGeoPoint',
            'geo_point': self.geo_point.to_dict() if isinstance(self.geo_point, TLObject) else self.geo_point
        }

    def _bytes(self):
        return b''.join((
            b'DA\xc4\xf9',
            self.geo_point._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _geo_point = reader.tgread_object()
        return cls(geo_point=_geo_point)


class InputMediaInvoice(TLObject):
    CONSTRUCTOR_ID = 0x8eb5a6d5
    SUBCLASS_OF_ID = 0xfaf846f4

    def __init__(self, title: str, description: str, invoice: 'TypeInvoice', payload: bytes, provider: str, provider_data: 'TypeDataJSON', photo: Optional['TypeInputWebDocument']=None, start_param: Optional[str]=None, extended_media: Optional['TypeInputMedia']=None):
        """
        Constructor for InputMedia: Instance of either InputMediaEmpty, InputMediaUploadedPhoto, InputMediaPhoto, InputMediaGeoPoint, InputMediaContact, InputMediaUploadedDocument, InputMediaDocument, InputMediaVenue, InputMediaPhotoExternal, InputMediaDocumentExternal, InputMediaGame, InputMediaInvoice, InputMediaGeoLive, InputMediaPoll, InputMediaDice, InputMediaStory, InputMediaWebPage.
        """
        self.title = title
        self.description = description
        self.invoice = invoice
        self.payload = payload
        self.provider = provider
        self.provider_data = provider_data
        self.photo = photo
        self.start_param = start_param
        self.extended_media = extended_media

    def to_dict(self):
        return {
            '_': 'InputMediaInvoice',
            'title': self.title,
            'description': self.description,
            'invoice': self.invoice.to_dict() if isinstance(self.invoice, TLObject) else self.invoice,
            'payload': self.payload,
            'provider': self.provider,
            'provider_data': self.provider_data.to_dict() if isinstance(self.provider_data, TLObject) else self.provider_data,
            'photo': self.photo.to_dict() if isinstance(self.photo, TLObject) else self.photo,
            'start_param': self.start_param,
            'extended_media': self.extended_media.to_dict() if isinstance(self.extended_media, TLObject) else self.extended_media
        }

    def _bytes(self):
        return b''.join((
            b'\xd5\xa6\xb5\x8e',
            struct.pack('<I', (0 if self.photo is None or self.photo is False else 1) | (0 if self.start_param is None or self.start_param is False else 2) | (0 if self.extended_media is None or self.extended_media is False else 4)),
            self.serialize_bytes(self.title),
            self.serialize_bytes(self.description),
            b'' if self.photo is None or self.photo is False else (self.photo._bytes()),
            self.invoice._bytes(),
            self.serialize_bytes(self.payload),
            self.serialize_bytes(self.provider),
            self.provider_data._bytes(),
            b'' if self.start_param is None or self.start_param is False else (self.serialize_bytes(self.start_param)),
            b'' if self.extended_media is None or self.extended_media is False else (self.extended_media._bytes()),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _title = reader.tgread_string()
        _description = reader.tgread_string()
        if flags & 1:
            _photo = reader.tgread_object()
        else:
            _photo = None
        _invoice = reader.tgread_object()
        _payload = reader.tgread_bytes()
        _provider = reader.tgread_string()
        _provider_data = reader.tgread_object()
        if flags & 2:
            _start_param = reader.tgread_string()
        else:
            _start_param = None
        if flags & 4:
            _extended_media = reader.tgread_object()
        else:
            _extended_media = None
        return cls(title=_title, description=_description, invoice=_invoice, payload=_payload, provider=_provider, provider_data=_provider_data, photo=_photo, start_param=_start_param, extended_media=_extended_media)


class InputMediaPhoto(TLObject):
    CONSTRUCTOR_ID = 0xb3ba0635
    SUBCLASS_OF_ID = 0xfaf846f4

    # noinspection PyShadowingBuiltins
    def __init__(self, id: 'TypeInputPhoto', spoiler: Optional[bool]=None, ttl_seconds: Optional[int]=None):
        """
        Constructor for InputMedia: Instance of either InputMediaEmpty, InputMediaUploadedPhoto, InputMediaPhoto, InputMediaGeoPoint, InputMediaContact, InputMediaUploadedDocument, InputMediaDocument, InputMediaVenue, InputMediaPhotoExternal, InputMediaDocumentExternal, InputMediaGame, InputMediaInvoice, InputMediaGeoLive, InputMediaPoll, InputMediaDice, InputMediaStory, InputMediaWebPage.
        """
        self.id = id
        self.spoiler = spoiler
        self.ttl_seconds = ttl_seconds

    def to_dict(self):
        return {
            '_': 'InputMediaPhoto',
            'id': self.id.to_dict() if isinstance(self.id, TLObject) else self.id,
            'spoiler': self.spoiler,
            'ttl_seconds': self.ttl_seconds
        }

    def _bytes(self):
        return b''.join((
            b'5\x06\xba\xb3',
            struct.pack('<I', (0 if self.spoiler is None or self.spoiler is False else 2) | (0 if self.ttl_seconds is None or self.ttl_seconds is False else 1)),
            self.id._bytes(),
            b'' if self.ttl_seconds is None or self.ttl_seconds is False else (struct.pack('<i', self.ttl_seconds)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _spoiler = bool(flags & 2)
        _id = reader.tgread_object()
        if flags & 1:
            _ttl_seconds = reader.read_int()
        else:
            _ttl_seconds = None
        return cls(id=_id, spoiler=_spoiler, ttl_seconds=_ttl_seconds)


class InputMediaPhotoExternal(TLObject):
    CONSTRUCTOR_ID = 0xe5bbfe1a
    SUBCLASS_OF_ID = 0xfaf846f4

    def __init__(self, url: str, spoiler: Optional[bool]=None, ttl_seconds: Optional[int]=None):
        """
        Constructor for InputMedia: Instance of either InputMediaEmpty, InputMediaUploadedPhoto, InputMediaPhoto, InputMediaGeoPoint, InputMediaContact, InputMediaUploadedDocument, InputMediaDocument, InputMediaVenue, InputMediaPhotoExternal, InputMediaDocumentExternal, InputMediaGame, InputMediaInvoice, InputMediaGeoLive, InputMediaPoll, InputMediaDice, InputMediaStory, InputMediaWebPage.
        """
        self.url = url
        self.spoiler = spoiler
        self.ttl_seconds = ttl_seconds

    def to_dict(self):
        return {
            '_': 'InputMediaPhotoExternal',
            'url': self.url,
            'spoiler': self.spoiler,
            'ttl_seconds': self.ttl_seconds
        }

    def _bytes(self):
        return b''.join((
            b'\x1a\xfe\xbb\xe5',
            struct.pack('<I', (0 if self.spoiler is None or self.spoiler is False else 2) | (0 if self.ttl_seconds is None or self.ttl_seconds is False else 1)),
            self.serialize_bytes(self.url),
            b'' if self.ttl_seconds is None or self.ttl_seconds is False else (struct.pack('<i', self.ttl_seconds)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _spoiler = bool(flags & 2)
        _url = reader.tgread_string()
        if flags & 1:
            _ttl_seconds = reader.read_int()
        else:
            _ttl_seconds = None
        return cls(url=_url, spoiler=_spoiler, ttl_seconds=_ttl_seconds)


class InputMediaPoll(TLObject):
    CONSTRUCTOR_ID = 0xf94e5f1
    SUBCLASS_OF_ID = 0xfaf846f4

    def __init__(self, poll: 'TypePoll', correct_answers: Optional[List[bytes]]=None, solution: Optional[str]=None, solution_entities: Optional[List['TypeMessageEntity']]=None):
        """
        Constructor for InputMedia: Instance of either InputMediaEmpty, InputMediaUploadedPhoto, InputMediaPhoto, InputMediaGeoPoint, InputMediaContact, InputMediaUploadedDocument, InputMediaDocument, InputMediaVenue, InputMediaPhotoExternal, InputMediaDocumentExternal, InputMediaGame, InputMediaInvoice, InputMediaGeoLive, InputMediaPoll, InputMediaDice, InputMediaStory, InputMediaWebPage.
        """
        self.poll = poll
        self.correct_answers = correct_answers
        self.solution = solution
        self.solution_entities = solution_entities

    def to_dict(self):
        return {
            '_': 'InputMediaPoll',
            'poll': self.poll.to_dict() if isinstance(self.poll, TLObject) else self.poll,
            'correct_answers': [] if self.correct_answers is None else self.correct_answers[:],
            'solution': self.solution,
            'solution_entities': [] if self.solution_entities is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.solution_entities]
        }

    def _bytes(self):
        assert ((self.solution or self.solution is not None) and (self.solution_entities or self.solution_entities is not None)) or ((self.solution is None or self.solution is False) and (self.solution_entities is None or self.solution_entities is False)), 'solution, solution_entities parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'\xf1\xe5\x94\x0f',
            struct.pack('<I', (0 if self.correct_answers is None or self.correct_answers is False else 1) | (0 if self.solution is None or self.solution is False else 2) | (0 if self.solution_entities is None or self.solution_entities is False else 2)),
            self.poll._bytes(),
            b'' if self.correct_answers is None or self.correct_answers is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.correct_answers)),b''.join(self.serialize_bytes(x) for x in self.correct_answers))),
            b'' if self.solution is None or self.solution is False else (self.serialize_bytes(self.solution)),
            b'' if self.solution_entities is None or self.solution_entities is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.solution_entities)),b''.join(x._bytes() for x in self.solution_entities))),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _poll = reader.tgread_object()
        if flags & 1:
            reader.read_int()
            _correct_answers = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_bytes()
                _correct_answers.append(_x)

        else:
            _correct_answers = None
        if flags & 2:
            _solution = reader.tgread_string()
        else:
            _solution = None
        if flags & 2:
            reader.read_int()
            _solution_entities = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _solution_entities.append(_x)

        else:
            _solution_entities = None
        return cls(poll=_poll, correct_answers=_correct_answers, solution=_solution, solution_entities=_solution_entities)


class InputMediaStory(TLObject):
    CONSTRUCTOR_ID = 0x89fdd778
    SUBCLASS_OF_ID = 0xfaf846f4

    # noinspection PyShadowingBuiltins
    def __init__(self, peer: 'TypeInputPeer', id: int):
        """
        Constructor for InputMedia: Instance of either InputMediaEmpty, InputMediaUploadedPhoto, InputMediaPhoto, InputMediaGeoPoint, InputMediaContact, InputMediaUploadedDocument, InputMediaDocument, InputMediaVenue, InputMediaPhotoExternal, InputMediaDocumentExternal, InputMediaGame, InputMediaInvoice, InputMediaGeoLive, InputMediaPoll, InputMediaDice, InputMediaStory, InputMediaWebPage.
        """
        self.peer = peer
        self.id = id

    def to_dict(self):
        return {
            '_': 'InputMediaStory',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'id': self.id
        }

    def _bytes(self):
        return b''.join((
            b'x\xd7\xfd\x89',
            self.peer._bytes(),
            struct.pack('<i', self.id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _id = reader.read_int()
        return cls(peer=_peer, id=_id)


class InputMediaUploadedDocument(TLObject):
    CONSTRUCTOR_ID = 0x5b38c6c1
    SUBCLASS_OF_ID = 0xfaf846f4

    def __init__(self, file: 'TypeInputFile', mime_type: str, attributes: List['TypeDocumentAttribute'], nosound_video: Optional[bool]=None, force_file: Optional[bool]=None, spoiler: Optional[bool]=None, thumb: Optional['TypeInputFile']=None, stickers: Optional[List['TypeInputDocument']]=None, ttl_seconds: Optional[int]=None):
        """
        Constructor for InputMedia: Instance of either InputMediaEmpty, InputMediaUploadedPhoto, InputMediaPhoto, InputMediaGeoPoint, InputMediaContact, InputMediaUploadedDocument, InputMediaDocument, InputMediaVenue, InputMediaPhotoExternal, InputMediaDocumentExternal, InputMediaGame, InputMediaInvoice, InputMediaGeoLive, InputMediaPoll, InputMediaDice, InputMediaStory, InputMediaWebPage.
        """
        self.file = file
        self.mime_type = mime_type
        self.attributes = attributes
        self.nosound_video = nosound_video
        self.force_file = force_file
        self.spoiler = spoiler
        self.thumb = thumb
        self.stickers = stickers
        self.ttl_seconds = ttl_seconds

    def to_dict(self):
        return {
            '_': 'InputMediaUploadedDocument',
            'file': self.file.to_dict() if isinstance(self.file, TLObject) else self.file,
            'mime_type': self.mime_type,
            'attributes': [] if self.attributes is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.attributes],
            'nosound_video': self.nosound_video,
            'force_file': self.force_file,
            'spoiler': self.spoiler,
            'thumb': self.thumb.to_dict() if isinstance(self.thumb, TLObject) else self.thumb,
            'stickers': [] if self.stickers is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.stickers],
            'ttl_seconds': self.ttl_seconds
        }

    def _bytes(self):
        return b''.join((
            b'\xc1\xc68[',
            struct.pack('<I', (0 if self.nosound_video is None or self.nosound_video is False else 8) | (0 if self.force_file is None or self.force_file is False else 16) | (0 if self.spoiler is None or self.spoiler is False else 32) | (0 if self.thumb is None or self.thumb is False else 4) | (0 if self.stickers is None or self.stickers is False else 1) | (0 if self.ttl_seconds is None or self.ttl_seconds is False else 2)),
            self.file._bytes(),
            b'' if self.thumb is None or self.thumb is False else (self.thumb._bytes()),
            self.serialize_bytes(self.mime_type),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.attributes)),b''.join(x._bytes() for x in self.attributes),
            b'' if self.stickers is None or self.stickers is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.stickers)),b''.join(x._bytes() for x in self.stickers))),
            b'' if self.ttl_seconds is None or self.ttl_seconds is False else (struct.pack('<i', self.ttl_seconds)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _nosound_video = bool(flags & 8)
        _force_file = bool(flags & 16)
        _spoiler = bool(flags & 32)
        _file = reader.tgread_object()
        if flags & 4:
            _thumb = reader.tgread_object()
        else:
            _thumb = None
        _mime_type = reader.tgread_string()
        reader.read_int()
        _attributes = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _attributes.append(_x)

        if flags & 1:
            reader.read_int()
            _stickers = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _stickers.append(_x)

        else:
            _stickers = None
        if flags & 2:
            _ttl_seconds = reader.read_int()
        else:
            _ttl_seconds = None
        return cls(file=_file, mime_type=_mime_type, attributes=_attributes, nosound_video=_nosound_video, force_file=_force_file, spoiler=_spoiler, thumb=_thumb, stickers=_stickers, ttl_seconds=_ttl_seconds)


class InputMediaUploadedPhoto(TLObject):
    CONSTRUCTOR_ID = 0x1e287d04
    SUBCLASS_OF_ID = 0xfaf846f4

    def __init__(self, file: 'TypeInputFile', spoiler: Optional[bool]=None, stickers: Optional[List['TypeInputDocument']]=None, ttl_seconds: Optional[int]=None):
        """
        Constructor for InputMedia: Instance of either InputMediaEmpty, InputMediaUploadedPhoto, InputMediaPhoto, InputMediaGeoPoint, InputMediaContact, InputMediaUploadedDocument, InputMediaDocument, InputMediaVenue, InputMediaPhotoExternal, InputMediaDocumentExternal, InputMediaGame, InputMediaInvoice, InputMediaGeoLive, InputMediaPoll, InputMediaDice, InputMediaStory, InputMediaWebPage.
        """
        self.file = file
        self.spoiler = spoiler
        self.stickers = stickers
        self.ttl_seconds = ttl_seconds

    def to_dict(self):
        return {
            '_': 'InputMediaUploadedPhoto',
            'file': self.file.to_dict() if isinstance(self.file, TLObject) else self.file,
            'spoiler': self.spoiler,
            'stickers': [] if self.stickers is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.stickers],
            'ttl_seconds': self.ttl_seconds
        }

    def _bytes(self):
        return b''.join((
            b'\x04}(\x1e',
            struct.pack('<I', (0 if self.spoiler is None or self.spoiler is False else 4) | (0 if self.stickers is None or self.stickers is False else 1) | (0 if self.ttl_seconds is None or self.ttl_seconds is False else 2)),
            self.file._bytes(),
            b'' if self.stickers is None or self.stickers is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.stickers)),b''.join(x._bytes() for x in self.stickers))),
            b'' if self.ttl_seconds is None or self.ttl_seconds is False else (struct.pack('<i', self.ttl_seconds)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _spoiler = bool(flags & 4)
        _file = reader.tgread_object()
        if flags & 1:
            reader.read_int()
            _stickers = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _stickers.append(_x)

        else:
            _stickers = None
        if flags & 2:
            _ttl_seconds = reader.read_int()
        else:
            _ttl_seconds = None
        return cls(file=_file, spoiler=_spoiler, stickers=_stickers, ttl_seconds=_ttl_seconds)


class InputMediaVenue(TLObject):
    CONSTRUCTOR_ID = 0xc13d1c11
    SUBCLASS_OF_ID = 0xfaf846f4

    def __init__(self, geo_point: 'TypeInputGeoPoint', title: str, address: str, provider: str, venue_id: str, venue_type: str):
        """
        Constructor for InputMedia: Instance of either InputMediaEmpty, InputMediaUploadedPhoto, InputMediaPhoto, InputMediaGeoPoint, InputMediaContact, InputMediaUploadedDocument, InputMediaDocument, InputMediaVenue, InputMediaPhotoExternal, InputMediaDocumentExternal, InputMediaGame, InputMediaInvoice, InputMediaGeoLive, InputMediaPoll, InputMediaDice, InputMediaStory, InputMediaWebPage.
        """
        self.geo_point = geo_point
        self.title = title
        self.address = address
        self.provider = provider
        self.venue_id = venue_id
        self.venue_type = venue_type

    def to_dict(self):
        return {
            '_': 'InputMediaVenue',
            'geo_point': self.geo_point.to_dict() if isinstance(self.geo_point, TLObject) else self.geo_point,
            'title': self.title,
            'address': self.address,
            'provider': self.provider,
            'venue_id': self.venue_id,
            'venue_type': self.venue_type
        }

    def _bytes(self):
        return b''.join((
            b'\x11\x1c=\xc1',
            self.geo_point._bytes(),
            self.serialize_bytes(self.title),
            self.serialize_bytes(self.address),
            self.serialize_bytes(self.provider),
            self.serialize_bytes(self.venue_id),
            self.serialize_bytes(self.venue_type),
        ))

    @classmethod
    def from_reader(cls, reader):
        _geo_point = reader.tgread_object()
        _title = reader.tgread_string()
        _address = reader.tgread_string()
        _provider = reader.tgread_string()
        _venue_id = reader.tgread_string()
        _venue_type = reader.tgread_string()
        return cls(geo_point=_geo_point, title=_title, address=_address, provider=_provider, venue_id=_venue_id, venue_type=_venue_type)


class InputMediaWebPage(TLObject):
    CONSTRUCTOR_ID = 0xc21b8849
    SUBCLASS_OF_ID = 0xfaf846f4

    def __init__(self, url: str, force_large_media: Optional[bool]=None, force_small_media: Optional[bool]=None, optional: Optional[bool]=None):
        """
        Constructor for InputMedia: Instance of either InputMediaEmpty, InputMediaUploadedPhoto, InputMediaPhoto, InputMediaGeoPoint, InputMediaContact, InputMediaUploadedDocument, InputMediaDocument, InputMediaVenue, InputMediaPhotoExternal, InputMediaDocumentExternal, InputMediaGame, InputMediaInvoice, InputMediaGeoLive, InputMediaPoll, InputMediaDice, InputMediaStory, InputMediaWebPage.
        """
        self.url = url
        self.force_large_media = force_large_media
        self.force_small_media = force_small_media
        self.optional = optional

    def to_dict(self):
        return {
            '_': 'InputMediaWebPage',
            'url': self.url,
            'force_large_media': self.force_large_media,
            'force_small_media': self.force_small_media,
            'optional': self.optional
        }

    def _bytes(self):
        return b''.join((
            b'I\x88\x1b\xc2',
            struct.pack('<I', (0 if self.force_large_media is None or self.force_large_media is False else 1) | (0 if self.force_small_media is None or self.force_small_media is False else 2) | (0 if self.optional is None or self.optional is False else 4)),
            self.serialize_bytes(self.url),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _force_large_media = bool(flags & 1)
        _force_small_media = bool(flags & 2)
        _optional = bool(flags & 4)
        _url = reader.tgread_string()
        return cls(url=_url, force_large_media=_force_large_media, force_small_media=_force_small_media, optional=_optional)


class InputMessageCallbackQuery(TLObject):
    CONSTRUCTOR_ID = 0xacfa1a7e
    SUBCLASS_OF_ID = 0x54b6bcc5

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, query_id: int):
        """
        Constructor for InputMessage: Instance of either InputMessageID, InputMessageReplyTo, InputMessagePinned, InputMessageCallbackQuery.
        """
        self.id = id
        self.query_id = query_id

    def to_dict(self):
        return {
            '_': 'InputMessageCallbackQuery',
            'id': self.id,
            'query_id': self.query_id
        }

    def _bytes(self):
        return b''.join((
            b'~\x1a\xfa\xac',
            struct.pack('<i', self.id),
            struct.pack('<q', self.query_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_int()
        _query_id = reader.read_long()
        return cls(id=_id, query_id=_query_id)


class InputMessageEntityMentionName(TLObject):
    CONSTRUCTOR_ID = 0x208e68c9
    SUBCLASS_OF_ID = 0xcf6419dc

    def __init__(self, offset: int, length: int, user_id: 'TypeInputUser'):
        """
        Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBankCard, MessageEntitySpoiler, MessageEntityCustomEmoji, MessageEntityBlockquote.
        """
        self.offset = offset
        self.length = length
        self.user_id = user_id

    def to_dict(self):
        return {
            '_': 'InputMessageEntityMentionName',
            'offset': self.offset,
            'length': self.length,
            'user_id': self.user_id.to_dict() if isinstance(self.user_id, TLObject) else self.user_id
        }

    def _bytes(self):
        return b''.join((
            b'\xc9h\x8e ',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
            self.user_id._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        _user_id = reader.tgread_object()
        return cls(offset=_offset, length=_length, user_id=_user_id)


class InputMessageID(TLObject):
    CONSTRUCTOR_ID = 0xa676a322
    SUBCLASS_OF_ID = 0x54b6bcc5

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int):
        """
        Constructor for InputMessage: Instance of either InputMessageID, InputMessageReplyTo, InputMessagePinned, InputMessageCallbackQuery.
        """
        self.id = id

    def to_dict(self):
        return {
            '_': 'InputMessageID',
            'id': self.id
        }

    def _bytes(self):
        return b''.join((
            b'"\xa3v\xa6',
            struct.pack('<i', self.id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_int()
        return cls(id=_id)


class InputMessagePinned(TLObject):
    CONSTRUCTOR_ID = 0x86872538
    SUBCLASS_OF_ID = 0x54b6bcc5

    def to_dict(self):
        return {
            '_': 'InputMessagePinned'
        }

    def _bytes(self):
        return b''.join((
            b'8%\x87\x86',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputMessageReplyTo(TLObject):
    CONSTRUCTOR_ID = 0xbad88395
    SUBCLASS_OF_ID = 0x54b6bcc5

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int):
        """
        Constructor for InputMessage: Instance of either InputMessageID, InputMessageReplyTo, InputMessagePinned, InputMessageCallbackQuery.
        """
        self.id = id

    def to_dict(self):
        return {
            '_': 'InputMessageReplyTo',
            'id': self.id
        }

    def _bytes(self):
        return b''.join((
            b'\x95\x83\xd8\xba',
            struct.pack('<i', self.id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_int()
        return cls(id=_id)


class InputMessagesFilterChatPhotos(TLObject):
    CONSTRUCTOR_ID = 0x3a20ecb8
    SUBCLASS_OF_ID = 0x8a36ec14

    def to_dict(self):
        return {
            '_': 'InputMessagesFilterChatPhotos'
        }

    def _bytes(self):
        return b''.join((
            b'\xb8\xec :',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputMessagesFilterContacts(TLObject):
    CONSTRUCTOR_ID = 0xe062db83
    SUBCLASS_OF_ID = 0x8a36ec14

    def to_dict(self):
        return {
            '_': 'InputMessagesFilterContacts'
        }

    def _bytes(self):
        return b''.join((
            b'\x83\xdbb\xe0',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputMessagesFilterDocument(TLObject):
    CONSTRUCTOR_ID = 0x9eddf188
    SUBCLASS_OF_ID = 0x8a36ec14

    def to_dict(self):
        return {
            '_': 'InputMessagesFilterDocument'
        }

    def _bytes(self):
        return b''.join((
            b'\x88\xf1\xdd\x9e',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputMessagesFilterEmpty(TLObject):
    CONSTRUCTOR_ID = 0x57e2f66c
    SUBCLASS_OF_ID = 0x8a36ec14

    def to_dict(self):
        return {
            '_': 'InputMessagesFilterEmpty'
        }

    def _bytes(self):
        return b''.join((
            b'l\xf6\xe2W',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputMessagesFilterGeo(TLObject):
    CONSTRUCTOR_ID = 0xe7026d0d
    SUBCLASS_OF_ID = 0x8a36ec14

    def to_dict(self):
        return {
            '_': 'InputMessagesFilterGeo'
        }

    def _bytes(self):
        return b''.join((
            b'\rm\x02\xe7',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputMessagesFilterGif(TLObject):
    CONSTRUCTOR_ID = 0xffc86587
    SUBCLASS_OF_ID = 0x8a36ec14

    def to_dict(self):
        return {
            '_': 'InputMessagesFilterGif'
        }

    def _bytes(self):
        return b''.join((
            b'\x87e\xc8\xff',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputMessagesFilterMusic(TLObject):
    CONSTRUCTOR_ID = 0x3751b49e
    SUBCLASS_OF_ID = 0x8a36ec14

    def to_dict(self):
        return {
            '_': 'InputMessagesFilterMusic'
        }

    def _bytes(self):
        return b''.join((
            b'\x9e\xb4Q7',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputMessagesFilterMyMentions(TLObject):
    CONSTRUCTOR_ID = 0xc1f8e69a
    SUBCLASS_OF_ID = 0x8a36ec14

    def to_dict(self):
        return {
            '_': 'InputMessagesFilterMyMentions'
        }

    def _bytes(self):
        return b''.join((
            b'\x9a\xe6\xf8\xc1',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputMessagesFilterPhoneCalls(TLObject):
    CONSTRUCTOR_ID = 0x80c99768
    SUBCLASS_OF_ID = 0x8a36ec14

    def __init__(self, missed: Optional[bool]=None):
        """
        Constructor for MessagesFilter: Instance of either InputMessagesFilterEmpty, InputMessagesFilterPhotos, InputMessagesFilterVideo, InputMessagesFilterPhotoVideo, InputMessagesFilterDocument, InputMessagesFilterUrl, InputMessagesFilterGif, InputMessagesFilterVoice, InputMessagesFilterMusic, InputMessagesFilterChatPhotos, InputMessagesFilterPhoneCalls, InputMessagesFilterRoundVoice, InputMessagesFilterRoundVideo, InputMessagesFilterMyMentions, InputMessagesFilterGeo, InputMessagesFilterContacts, InputMessagesFilterPinned.
        """
        self.missed = missed

    def to_dict(self):
        return {
            '_': 'InputMessagesFilterPhoneCalls',
            'missed': self.missed
        }

    def _bytes(self):
        return b''.join((
            b'h\x97\xc9\x80',
            struct.pack('<I', (0 if self.missed is None or self.missed is False else 1)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _missed = bool(flags & 1)
        return cls(missed=_missed)


class InputMessagesFilterPhotoVideo(TLObject):
    CONSTRUCTOR_ID = 0x56e9f0e4
    SUBCLASS_OF_ID = 0x8a36ec14

    def to_dict(self):
        return {
            '_': 'InputMessagesFilterPhotoVideo'
        }

    def _bytes(self):
        return b''.join((
            b'\xe4\xf0\xe9V',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputMessagesFilterPhotos(TLObject):
    CONSTRUCTOR_ID = 0x9609a51c
    SUBCLASS_OF_ID = 0x8a36ec14

    def to_dict(self):
        return {
            '_': 'InputMessagesFilterPhotos'
        }

    def _bytes(self):
        return b''.join((
            b'\x1c\xa5\t\x96',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputMessagesFilterPinned(TLObject):
    CONSTRUCTOR_ID = 0x1bb00451
    SUBCLASS_OF_ID = 0x8a36ec14

    def to_dict(self):
        return {
            '_': 'InputMessagesFilterPinned'
        }

    def _bytes(self):
        return b''.join((
            b'Q\x04\xb0\x1b',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputMessagesFilterRoundVideo(TLObject):
    CONSTRUCTOR_ID = 0xb549da53
    SUBCLASS_OF_ID = 0x8a36ec14

    def to_dict(self):
        return {
            '_': 'InputMessagesFilterRoundVideo'
        }

    def _bytes(self):
        return b''.join((
            b'S\xdaI\xb5',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputMessagesFilterRoundVoice(TLObject):
    CONSTRUCTOR_ID = 0x7a7c17a4
    SUBCLASS_OF_ID = 0x8a36ec14

    def to_dict(self):
        return {
            '_': 'InputMessagesFilterRoundVoice'
        }

    def _bytes(self):
        return b''.join((
            b'\xa4\x17|z',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputMessagesFilterUrl(TLObject):
    CONSTRUCTOR_ID = 0x7ef0dd87
    SUBCLASS_OF_ID = 0x8a36ec14

    def to_dict(self):
        return {
            '_': 'InputMessagesFilterUrl'
        }

    def _bytes(self):
        return b''.join((
            b'\x87\xdd\xf0~',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputMessagesFilterVideo(TLObject):
    CONSTRUCTOR_ID = 0x9fc00e65
    SUBCLASS_OF_ID = 0x8a36ec14

    def to_dict(self):
        return {
            '_': 'InputMessagesFilterVideo'
        }

    def _bytes(self):
        return b''.join((
            b'e\x0e\xc0\x9f',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputMessagesFilterVoice(TLObject):
    CONSTRUCTOR_ID = 0x50f5c392
    SUBCLASS_OF_ID = 0x8a36ec14

    def to_dict(self):
        return {
            '_': 'InputMessagesFilterVoice'
        }

    def _bytes(self):
        return b''.join((
            b'\x92\xc3\xf5P',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputNotifyBroadcasts(TLObject):
    CONSTRUCTOR_ID = 0xb1db7c7e
    SUBCLASS_OF_ID = 0x58981615

    def to_dict(self):
        return {
            '_': 'InputNotifyBroadcasts'
        }

    def _bytes(self):
        return b''.join((
            b'~|\xdb\xb1',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputNotifyChats(TLObject):
    CONSTRUCTOR_ID = 0x4a95e84e
    SUBCLASS_OF_ID = 0x58981615

    def to_dict(self):
        return {
            '_': 'InputNotifyChats'
        }

    def _bytes(self):
        return b''.join((
            b'N\xe8\x95J',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputNotifyForumTopic(TLObject):
    CONSTRUCTOR_ID = 0x5c467992
    SUBCLASS_OF_ID = 0x58981615

    def __init__(self, peer: 'TypeInputPeer', top_msg_id: int):
        """
        Constructor for InputNotifyPeer: Instance of either InputNotifyPeer, InputNotifyUsers, InputNotifyChats, InputNotifyBroadcasts, InputNotifyForumTopic.
        """
        self.peer = peer
        self.top_msg_id = top_msg_id

    def to_dict(self):
        return {
            '_': 'InputNotifyForumTopic',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'top_msg_id': self.top_msg_id
        }

    def _bytes(self):
        return b''.join((
            b'\x92yF\\',
            self.peer._bytes(),
            struct.pack('<i', self.top_msg_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _top_msg_id = reader.read_int()
        return cls(peer=_peer, top_msg_id=_top_msg_id)


class InputNotifyPeer(TLObject):
    CONSTRUCTOR_ID = 0xb8bc5b0c
    SUBCLASS_OF_ID = 0x58981615

    def __init__(self, peer: 'TypeInputPeer'):
        """
        Constructor for InputNotifyPeer: Instance of either InputNotifyPeer, InputNotifyUsers, InputNotifyChats, InputNotifyBroadcasts, InputNotifyForumTopic.
        """
        self.peer = peer

    def to_dict(self):
        return {
            '_': 'InputNotifyPeer',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer
        }

    def _bytes(self):
        return b''.join((
            b'\x0c[\xbc\xb8',
            self.peer._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        return cls(peer=_peer)


class InputNotifyUsers(TLObject):
    CONSTRUCTOR_ID = 0x193b4417
    SUBCLASS_OF_ID = 0x58981615

    def to_dict(self):
        return {
            '_': 'InputNotifyUsers'
        }

    def _bytes(self):
        return b''.join((
            b'\x17D;\x19',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputPaymentCredentials(TLObject):
    CONSTRUCTOR_ID = 0x3417d728
    SUBCLASS_OF_ID = 0x2899a53d

    def __init__(self, data: 'TypeDataJSON', save: Optional[bool]=None):
        """
        Constructor for InputPaymentCredentials: Instance of either InputPaymentCredentialsSaved, InputPaymentCredentials, InputPaymentCredentialsApplePay, InputPaymentCredentialsGooglePay.
        """
        self.data = data
        self.save = save

    def to_dict(self):
        return {
            '_': 'InputPaymentCredentials',
            'data': self.data.to_dict() if isinstance(self.data, TLObject) else self.data,
            'save': self.save
        }

    def _bytes(self):
        return b''.join((
            b'(\xd7\x174',
            struct.pack('<I', (0 if self.save is None or self.save is False else 1)),
            self.data._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _save = bool(flags & 1)
        _data = reader.tgread_object()
        return cls(data=_data, save=_save)


class InputPaymentCredentialsApplePay(TLObject):
    CONSTRUCTOR_ID = 0xaa1c39f
    SUBCLASS_OF_ID = 0x2899a53d

    def __init__(self, payment_data: 'TypeDataJSON'):
        """
        Constructor for InputPaymentCredentials: Instance of either InputPaymentCredentialsSaved, InputPaymentCredentials, InputPaymentCredentialsApplePay, InputPaymentCredentialsGooglePay.
        """
        self.payment_data = payment_data

    def to_dict(self):
        return {
            '_': 'InputPaymentCredentialsApplePay',
            'payment_data': self.payment_data.to_dict() if isinstance(self.payment_data, TLObject) else self.payment_data
        }

    def _bytes(self):
        return b''.join((
            b'\x9f\xc3\xa1\n',
            self.payment_data._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _payment_data = reader.tgread_object()
        return cls(payment_data=_payment_data)


class InputPaymentCredentialsGooglePay(TLObject):
    CONSTRUCTOR_ID = 0x8ac32801
    SUBCLASS_OF_ID = 0x2899a53d

    def __init__(self, payment_token: 'TypeDataJSON'):
        """
        Constructor for InputPaymentCredentials: Instance of either InputPaymentCredentialsSaved, InputPaymentCredentials, InputPaymentCredentialsApplePay, InputPaymentCredentialsGooglePay.
        """
        self.payment_token = payment_token

    def to_dict(self):
        return {
            '_': 'InputPaymentCredentialsGooglePay',
            'payment_token': self.payment_token.to_dict() if isinstance(self.payment_token, TLObject) else self.payment_token
        }

    def _bytes(self):
        return b''.join((
            b'\x01(\xc3\x8a',
            self.payment_token._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _payment_token = reader.tgread_object()
        return cls(payment_token=_payment_token)


class InputPaymentCredentialsSaved(TLObject):
    CONSTRUCTOR_ID = 0xc10eb2cf
    SUBCLASS_OF_ID = 0x2899a53d

    # noinspection PyShadowingBuiltins
    def __init__(self, id: str, tmp_password: bytes):
        """
        Constructor for InputPaymentCredentials: Instance of either InputPaymentCredentialsSaved, InputPaymentCredentials, InputPaymentCredentialsApplePay, InputPaymentCredentialsGooglePay.
        """
        self.id = id
        self.tmp_password = tmp_password

    def to_dict(self):
        return {
            '_': 'InputPaymentCredentialsSaved',
            'id': self.id,
            'tmp_password': self.tmp_password
        }

    def _bytes(self):
        return b''.join((
            b'\xcf\xb2\x0e\xc1',
            self.serialize_bytes(self.id),
            self.serialize_bytes(self.tmp_password),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.tgread_string()
        _tmp_password = reader.tgread_bytes()
        return cls(id=_id, tmp_password=_tmp_password)


class InputPeerChannel(TLObject):
    CONSTRUCTOR_ID = 0x27bcbbfc
    SUBCLASS_OF_ID = 0xc91c90b6

    def __init__(self, channel_id: int, access_hash: int):
        """
        Constructor for InputPeer: Instance of either InputPeerEmpty, InputPeerSelf, InputPeerChat, InputPeerUser, InputPeerChannel, InputPeerUserFromMessage, InputPeerChannelFromMessage.
        """
        self.channel_id = channel_id
        self.access_hash = access_hash

    def to_dict(self):
        return {
            '_': 'InputPeerChannel',
            'channel_id': self.channel_id,
            'access_hash': self.access_hash
        }

    def _bytes(self):
        return b''.join((
            b"\xfc\xbb\xbc'",
            struct.pack('<q', self.channel_id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel_id = reader.read_long()
        _access_hash = reader.read_long()
        return cls(channel_id=_channel_id, access_hash=_access_hash)


class InputPeerChannelFromMessage(TLObject):
    CONSTRUCTOR_ID = 0xbd2a0840
    SUBCLASS_OF_ID = 0xc91c90b6

    def __init__(self, peer: 'TypeInputPeer', msg_id: int, channel_id: int):
        """
        Constructor for InputPeer: Instance of either InputPeerEmpty, InputPeerSelf, InputPeerChat, InputPeerUser, InputPeerChannel, InputPeerUserFromMessage, InputPeerChannelFromMessage.
        """
        self.peer = peer
        self.msg_id = msg_id
        self.channel_id = channel_id

    def to_dict(self):
        return {
            '_': 'InputPeerChannelFromMessage',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'msg_id': self.msg_id,
            'channel_id': self.channel_id
        }

    def _bytes(self):
        return b''.join((
            b'@\x08*\xbd',
            self.peer._bytes(),
            struct.pack('<i', self.msg_id),
            struct.pack('<q', self.channel_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _msg_id = reader.read_int()
        _channel_id = reader.read_long()
        return cls(peer=_peer, msg_id=_msg_id, channel_id=_channel_id)


class InputPeerChat(TLObject):
    CONSTRUCTOR_ID = 0x35a95cb9
    SUBCLASS_OF_ID = 0xc91c90b6

    def __init__(self, chat_id: int):
        """
        Constructor for InputPeer: Instance of either InputPeerEmpty, InputPeerSelf, InputPeerChat, InputPeerUser, InputPeerChannel, InputPeerUserFromMessage, InputPeerChannelFromMessage.
        """
        self.chat_id = chat_id

    def to_dict(self):
        return {
            '_': 'InputPeerChat',
            'chat_id': self.chat_id
        }

    def _bytes(self):
        return b''.join((
            b'\xb9\\\xa95',
            struct.pack('<q', self.chat_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _chat_id = reader.read_long()
        return cls(chat_id=_chat_id)


class InputPeerEmpty(TLObject):
    CONSTRUCTOR_ID = 0x7f3b18ea
    SUBCLASS_OF_ID = 0xc91c90b6

    def to_dict(self):
        return {
            '_': 'InputPeerEmpty'
        }

    def _bytes(self):
        return b''.join((
            b'\xea\x18;\x7f',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputPeerNotifySettings(TLObject):
    CONSTRUCTOR_ID = 0xcacb6ae2
    SUBCLASS_OF_ID = 0x90db0b0d

    def __init__(self, show_previews: Optional[bool]=None, silent: Optional[bool]=None, mute_until: Optional[datetime]=None, sound: Optional['TypeNotificationSound']=None, stories_muted: Optional[bool]=None, stories_hide_sender: Optional[bool]=None, stories_sound: Optional['TypeNotificationSound']=None):
        """
        Constructor for InputPeerNotifySettings: Instance of InputPeerNotifySettings.
        """
        self.show_previews = show_previews
        self.silent = silent
        self.mute_until = mute_until
        self.sound = sound
        self.stories_muted = stories_muted
        self.stories_hide_sender = stories_hide_sender
        self.stories_sound = stories_sound

    def to_dict(self):
        return {
            '_': 'InputPeerNotifySettings',
            'show_previews': self.show_previews,
            'silent': self.silent,
            'mute_until': self.mute_until,
            'sound': self.sound.to_dict() if isinstance(self.sound, TLObject) else self.sound,
            'stories_muted': self.stories_muted,
            'stories_hide_sender': self.stories_hide_sender,
            'stories_sound': self.stories_sound.to_dict() if isinstance(self.stories_sound, TLObject) else self.stories_sound
        }

    def _bytes(self):
        return b''.join((
            b'\xe2j\xcb\xca',
            struct.pack('<I', (0 if self.show_previews is None else 1) | (0 if self.silent is None else 2) | (0 if self.mute_until is None or self.mute_until is False else 4) | (0 if self.sound is None or self.sound is False else 8) | (0 if self.stories_muted is None else 64) | (0 if self.stories_hide_sender is None else 128) | (0 if self.stories_sound is None or self.stories_sound is False else 256)),
            b'' if self.show_previews is None else (b'\xb5ur\x99' if self.show_previews else b'7\x97y\xbc'),
            b'' if self.silent is None else (b'\xb5ur\x99' if self.silent else b'7\x97y\xbc'),
            b'' if self.mute_until is None or self.mute_until is False else (self.serialize_datetime(self.mute_until)),
            b'' if self.sound is None or self.sound is False else (self.sound._bytes()),
            b'' if self.stories_muted is None else (b'\xb5ur\x99' if self.stories_muted else b'7\x97y\xbc'),
            b'' if self.stories_hide_sender is None else (b'\xb5ur\x99' if self.stories_hide_sender else b'7\x97y\xbc'),
            b'' if self.stories_sound is None or self.stories_sound is False else (self.stories_sound._bytes()),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 1:
            _show_previews = reader.tgread_bool()
        else:
            _show_previews = None
        if flags & 2:
            _silent = reader.tgread_bool()
        else:
            _silent = None
        if flags & 4:
            _mute_until = reader.tgread_date()
        else:
            _mute_until = None
        if flags & 8:
            _sound = reader.tgread_object()
        else:
            _sound = None
        if flags & 64:
            _stories_muted = reader.tgread_bool()
        else:
            _stories_muted = None
        if flags & 128:
            _stories_hide_sender = reader.tgread_bool()
        else:
            _stories_hide_sender = None
        if flags & 256:
            _stories_sound = reader.tgread_object()
        else:
            _stories_sound = None
        return cls(show_previews=_show_previews, silent=_silent, mute_until=_mute_until, sound=_sound, stories_muted=_stories_muted, stories_hide_sender=_stories_hide_sender, stories_sound=_stories_sound)


class InputPeerPhotoFileLocation(TLObject):
    CONSTRUCTOR_ID = 0x37257e99
    SUBCLASS_OF_ID = 0x1523d462

    def __init__(self, peer: 'TypeInputPeer', photo_id: int, big: Optional[bool]=None):
        """
        Constructor for InputFileLocation: Instance of either InputFileLocation, InputEncryptedFileLocation, InputDocumentFileLocation, InputSecureFileLocation, InputTakeoutFileLocation, InputPhotoFileLocation, InputPhotoLegacyFileLocation, InputPeerPhotoFileLocation, InputStickerSetThumb, InputGroupCallStream.
        """
        self.peer = peer
        self.photo_id = photo_id
        self.big = big

    def to_dict(self):
        return {
            '_': 'InputPeerPhotoFileLocation',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'photo_id': self.photo_id,
            'big': self.big
        }

    def _bytes(self):
        return b''.join((
            b'\x99~%7',
            struct.pack('<I', (0 if self.big is None or self.big is False else 1)),
            self.peer._bytes(),
            struct.pack('<q', self.photo_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _big = bool(flags & 1)
        _peer = reader.tgread_object()
        _photo_id = reader.read_long()
        return cls(peer=_peer, photo_id=_photo_id, big=_big)


class InputPeerSelf(TLObject):
    CONSTRUCTOR_ID = 0x7da07ec9
    SUBCLASS_OF_ID = 0xc91c90b6

    def to_dict(self):
        return {
            '_': 'InputPeerSelf'
        }

    def _bytes(self):
        return b''.join((
            b'\xc9~\xa0}',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputPeerUser(TLObject):
    CONSTRUCTOR_ID = 0xdde8a54c
    SUBCLASS_OF_ID = 0xc91c90b6

    def __init__(self, user_id: int, access_hash: int):
        """
        Constructor for InputPeer: Instance of either InputPeerEmpty, InputPeerSelf, InputPeerChat, InputPeerUser, InputPeerChannel, InputPeerUserFromMessage, InputPeerChannelFromMessage.
        """
        self.user_id = user_id
        self.access_hash = access_hash

    def to_dict(self):
        return {
            '_': 'InputPeerUser',
            'user_id': self.user_id,
            'access_hash': self.access_hash
        }

    def _bytes(self):
        return b''.join((
            b'L\xa5\xe8\xdd',
            struct.pack('<q', self.user_id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _user_id = reader.read_long()
        _access_hash = reader.read_long()
        return cls(user_id=_user_id, access_hash=_access_hash)


class InputPeerUserFromMessage(TLObject):
    CONSTRUCTOR_ID = 0xa87b0a1c
    SUBCLASS_OF_ID = 0xc91c90b6

    def __init__(self, peer: 'TypeInputPeer', msg_id: int, user_id: int):
        """
        Constructor for InputPeer: Instance of either InputPeerEmpty, InputPeerSelf, InputPeerChat, InputPeerUser, InputPeerChannel, InputPeerUserFromMessage, InputPeerChannelFromMessage.
        """
        self.peer = peer
        self.msg_id = msg_id
        self.user_id = user_id

    def to_dict(self):
        return {
            '_': 'InputPeerUserFromMessage',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'msg_id': self.msg_id,
            'user_id': self.user_id
        }

    def _bytes(self):
        return b''.join((
            b'\x1c\n{\xa8',
            self.peer._bytes(),
            struct.pack('<i', self.msg_id),
            struct.pack('<q', self.user_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _msg_id = reader.read_int()
        _user_id = reader.read_long()
        return cls(peer=_peer, msg_id=_msg_id, user_id=_user_id)


class InputPhoneCall(TLObject):
    CONSTRUCTOR_ID = 0x1e36fded
    SUBCLASS_OF_ID = 0xbcaaf240

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int):
        """
        Constructor for InputPhoneCall: Instance of InputPhoneCall.
        """
        self.id = id
        self.access_hash = access_hash

    def to_dict(self):
        return {
            '_': 'InputPhoneCall',
            'id': self.id,
            'access_hash': self.access_hash
        }

    def _bytes(self):
        return b''.join((
            b'\xed\xfd6\x1e',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        return cls(id=_id, access_hash=_access_hash)


class InputPhoneContact(TLObject):
    CONSTRUCTOR_ID = 0xf392b7f4
    SUBCLASS_OF_ID = 0xae696a82

    def __init__(self, client_id: int, phone: str, first_name: str, last_name: str):
        """
        Constructor for InputContact: Instance of InputPhoneContact.
        """
        self.client_id = client_id
        self.phone = phone
        self.first_name = first_name
        self.last_name = last_name

    def to_dict(self):
        return {
            '_': 'InputPhoneContact',
            'client_id': self.client_id,
            'phone': self.phone,
            'first_name': self.first_name,
            'last_name': self.last_name
        }

    def _bytes(self):
        return b''.join((
            b'\xf4\xb7\x92\xf3',
            struct.pack('<q', self.client_id),
            self.serialize_bytes(self.phone),
            self.serialize_bytes(self.first_name),
            self.serialize_bytes(self.last_name),
        ))

    @classmethod
    def from_reader(cls, reader):
        _client_id = reader.read_long()
        _phone = reader.tgread_string()
        _first_name = reader.tgread_string()
        _last_name = reader.tgread_string()
        return cls(client_id=_client_id, phone=_phone, first_name=_first_name, last_name=_last_name)


class InputPhoto(TLObject):
    CONSTRUCTOR_ID = 0x3bb3b94a
    SUBCLASS_OF_ID = 0x846363e0

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, file_reference: bytes):
        """
        Constructor for InputPhoto: Instance of either InputPhotoEmpty, InputPhoto.
        """
        self.id = id
        self.access_hash = access_hash
        self.file_reference = file_reference

    def to_dict(self):
        return {
            '_': 'InputPhoto',
            'id': self.id,
            'access_hash': self.access_hash,
            'file_reference': self.file_reference
        }

    def _bytes(self):
        return b''.join((
            b'J\xb9\xb3;',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            self.serialize_bytes(self.file_reference),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        _file_reference = reader.tgread_bytes()
        return cls(id=_id, access_hash=_access_hash, file_reference=_file_reference)


class InputPhotoEmpty(TLObject):
    CONSTRUCTOR_ID = 0x1cd7bf0d
    SUBCLASS_OF_ID = 0x846363e0

    def to_dict(self):
        return {
            '_': 'InputPhotoEmpty'
        }

    def _bytes(self):
        return b''.join((
            b'\r\xbf\xd7\x1c',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputPhotoFileLocation(TLObject):
    CONSTRUCTOR_ID = 0x40181ffe
    SUBCLASS_OF_ID = 0x1523d462

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, file_reference: bytes, thumb_size: str):
        """
        Constructor for InputFileLocation: Instance of either InputFileLocation, InputEncryptedFileLocation, InputDocumentFileLocation, InputSecureFileLocation, InputTakeoutFileLocation, InputPhotoFileLocation, InputPhotoLegacyFileLocation, InputPeerPhotoFileLocation, InputStickerSetThumb, InputGroupCallStream.
        """
        self.id = id
        self.access_hash = access_hash
        self.file_reference = file_reference
        self.thumb_size = thumb_size

    def to_dict(self):
        return {
            '_': 'InputPhotoFileLocation',
            'id': self.id,
            'access_hash': self.access_hash,
            'file_reference': self.file_reference,
            'thumb_size': self.thumb_size
        }

    def _bytes(self):
        return b''.join((
            b'\xfe\x1f\x18@',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            self.serialize_bytes(self.file_reference),
            self.serialize_bytes(self.thumb_size),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        _file_reference = reader.tgread_bytes()
        _thumb_size = reader.tgread_string()
        return cls(id=_id, access_hash=_access_hash, file_reference=_file_reference, thumb_size=_thumb_size)


class InputPhotoLegacyFileLocation(TLObject):
    CONSTRUCTOR_ID = 0xd83466f3
    SUBCLASS_OF_ID = 0x1523d462

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int, file_reference: bytes, volume_id: int, local_id: int, secret: int):
        """
        Constructor for InputFileLocation: Instance of either InputFileLocation, InputEncryptedFileLocation, InputDocumentFileLocation, InputSecureFileLocation, InputTakeoutFileLocation, InputPhotoFileLocation, InputPhotoLegacyFileLocation, InputPeerPhotoFileLocation, InputStickerSetThumb, InputGroupCallStream.
        """
        self.id = id
        self.access_hash = access_hash
        self.file_reference = file_reference
        self.volume_id = volume_id
        self.local_id = local_id
        self.secret = secret

    def to_dict(self):
        return {
            '_': 'InputPhotoLegacyFileLocation',
            'id': self.id,
            'access_hash': self.access_hash,
            'file_reference': self.file_reference,
            'volume_id': self.volume_id,
            'local_id': self.local_id,
            'secret': self.secret
        }

    def _bytes(self):
        return b''.join((
            b'\xf3f4\xd8',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
            self.serialize_bytes(self.file_reference),
            struct.pack('<q', self.volume_id),
            struct.pack('<i', self.local_id),
            struct.pack('<q', self.secret),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        _file_reference = reader.tgread_bytes()
        _volume_id = reader.read_long()
        _local_id = reader.read_int()
        _secret = reader.read_long()
        return cls(id=_id, access_hash=_access_hash, file_reference=_file_reference, volume_id=_volume_id, local_id=_local_id, secret=_secret)


class InputPrivacyKeyAbout(TLObject):
    CONSTRUCTOR_ID = 0x3823cc40
    SUBCLASS_OF_ID = 0x53627f8

    def to_dict(self):
        return {
            '_': 'InputPrivacyKeyAbout'
        }

    def _bytes(self):
        return b''.join((
            b'@\xcc#8',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputPrivacyKeyAddedByPhone(TLObject):
    CONSTRUCTOR_ID = 0xd1219bdd
    SUBCLASS_OF_ID = 0x53627f8

    def to_dict(self):
        return {
            '_': 'InputPrivacyKeyAddedByPhone'
        }

    def _bytes(self):
        return b''.join((
            b'\xdd\x9b!\xd1',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputPrivacyKeyChatInvite(TLObject):
    CONSTRUCTOR_ID = 0xbdfb0426
    SUBCLASS_OF_ID = 0x53627f8

    def to_dict(self):
        return {
            '_': 'InputPrivacyKeyChatInvite'
        }

    def _bytes(self):
        return b''.join((
            b'&\x04\xfb\xbd',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputPrivacyKeyForwards(TLObject):
    CONSTRUCTOR_ID = 0xa4dd4c08
    SUBCLASS_OF_ID = 0x53627f8

    def to_dict(self):
        return {
            '_': 'InputPrivacyKeyForwards'
        }

    def _bytes(self):
        return b''.join((
            b'\x08L\xdd\xa4',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputPrivacyKeyPhoneCall(TLObject):
    CONSTRUCTOR_ID = 0xfabadc5f
    SUBCLASS_OF_ID = 0x53627f8

    def to_dict(self):
        return {
            '_': 'InputPrivacyKeyPhoneCall'
        }

    def _bytes(self):
        return b''.join((
            b'_\xdc\xba\xfa',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputPrivacyKeyPhoneNumber(TLObject):
    CONSTRUCTOR_ID = 0x352dafa
    SUBCLASS_OF_ID = 0x53627f8

    def to_dict(self):
        return {
            '_': 'InputPrivacyKeyPhoneNumber'
        }

    def _bytes(self):
        return b''.join((
            b'\xfa\xdaR\x03',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputPrivacyKeyPhoneP2P(TLObject):
    CONSTRUCTOR_ID = 0xdb9e70d2
    SUBCLASS_OF_ID = 0x53627f8

    def to_dict(self):
        return {
            '_': 'InputPrivacyKeyPhoneP2P'
        }

    def _bytes(self):
        return b''.join((
            b'\xd2p\x9e\xdb',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputPrivacyKeyProfilePhoto(TLObject):
    CONSTRUCTOR_ID = 0x5719bacc
    SUBCLASS_OF_ID = 0x53627f8

    def to_dict(self):
        return {
            '_': 'InputPrivacyKeyProfilePhoto'
        }

    def _bytes(self):
        return b''.join((
            b'\xcc\xba\x19W',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputPrivacyKeyStatusTimestamp(TLObject):
    CONSTRUCTOR_ID = 0x4f96cb18
    SUBCLASS_OF_ID = 0x53627f8

    def to_dict(self):
        return {
            '_': 'InputPrivacyKeyStatusTimestamp'
        }

    def _bytes(self):
        return b''.join((
            b'\x18\xcb\x96O',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputPrivacyKeyVoiceMessages(TLObject):
    CONSTRUCTOR_ID = 0xaee69d68
    SUBCLASS_OF_ID = 0x53627f8

    def to_dict(self):
        return {
            '_': 'InputPrivacyKeyVoiceMessages'
        }

    def _bytes(self):
        return b''.join((
            b'h\x9d\xe6\xae',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputPrivacyValueAllowAll(TLObject):
    CONSTRUCTOR_ID = 0x184b35ce
    SUBCLASS_OF_ID = 0x5a3b6b22

    def to_dict(self):
        return {
            '_': 'InputPrivacyValueAllowAll'
        }

    def _bytes(self):
        return b''.join((
            b'\xce5K\x18',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputPrivacyValueAllowChatParticipants(TLObject):
    CONSTRUCTOR_ID = 0x840649cf
    SUBCLASS_OF_ID = 0x5a3b6b22

    def __init__(self, chats: List[int]):
        """
        Constructor for InputPrivacyRule: Instance of either InputPrivacyValueAllowContacts, InputPrivacyValueAllowAll, InputPrivacyValueAllowUsers, InputPrivacyValueDisallowContacts, InputPrivacyValueDisallowAll, InputPrivacyValueDisallowUsers, InputPrivacyValueAllowChatParticipants, InputPrivacyValueDisallowChatParticipants, InputPrivacyValueAllowCloseFriends.
        """
        self.chats = chats

    def to_dict(self):
        return {
            '_': 'InputPrivacyValueAllowChatParticipants',
            'chats': [] if self.chats is None else self.chats[:]
        }

    def _bytes(self):
        return b''.join((
            b'\xcfI\x06\x84',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.chats)),b''.join(struct.pack('<q', x) for x in self.chats),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _chats = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _chats.append(_x)

        return cls(chats=_chats)


class InputPrivacyValueAllowCloseFriends(TLObject):
    CONSTRUCTOR_ID = 0x2f453e49
    SUBCLASS_OF_ID = 0x5a3b6b22

    def to_dict(self):
        return {
            '_': 'InputPrivacyValueAllowCloseFriends'
        }

    def _bytes(self):
        return b''.join((
            b'I>E/',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputPrivacyValueAllowContacts(TLObject):
    CONSTRUCTOR_ID = 0xd09e07b
    SUBCLASS_OF_ID = 0x5a3b6b22

    def to_dict(self):
        return {
            '_': 'InputPrivacyValueAllowContacts'
        }

    def _bytes(self):
        return b''.join((
            b'{\xe0\t\r',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputPrivacyValueAllowUsers(TLObject):
    CONSTRUCTOR_ID = 0x131cc67f
    SUBCLASS_OF_ID = 0x5a3b6b22

    def __init__(self, users: List['TypeInputUser']):
        """
        Constructor for InputPrivacyRule: Instance of either InputPrivacyValueAllowContacts, InputPrivacyValueAllowAll, InputPrivacyValueAllowUsers, InputPrivacyValueDisallowContacts, InputPrivacyValueDisallowAll, InputPrivacyValueDisallowUsers, InputPrivacyValueAllowChatParticipants, InputPrivacyValueDisallowChatParticipants, InputPrivacyValueAllowCloseFriends.
        """
        self.users = users

    def to_dict(self):
        return {
            '_': 'InputPrivacyValueAllowUsers',
            'users': [] if self.users is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.users]
        }

    def _bytes(self):
        return b''.join((
            b'\x7f\xc6\x1c\x13',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        return cls(users=_users)


class InputPrivacyValueDisallowAll(TLObject):
    CONSTRUCTOR_ID = 0xd66b66c9
    SUBCLASS_OF_ID = 0x5a3b6b22

    def to_dict(self):
        return {
            '_': 'InputPrivacyValueDisallowAll'
        }

    def _bytes(self):
        return b''.join((
            b'\xc9fk\xd6',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputPrivacyValueDisallowChatParticipants(TLObject):
    CONSTRUCTOR_ID = 0xe94f0f86
    SUBCLASS_OF_ID = 0x5a3b6b22

    def __init__(self, chats: List[int]):
        """
        Constructor for InputPrivacyRule: Instance of either InputPrivacyValueAllowContacts, InputPrivacyValueAllowAll, InputPrivacyValueAllowUsers, InputPrivacyValueDisallowContacts, InputPrivacyValueDisallowAll, InputPrivacyValueDisallowUsers, InputPrivacyValueAllowChatParticipants, InputPrivacyValueDisallowChatParticipants, InputPrivacyValueAllowCloseFriends.
        """
        self.chats = chats

    def to_dict(self):
        return {
            '_': 'InputPrivacyValueDisallowChatParticipants',
            'chats': [] if self.chats is None else self.chats[:]
        }

    def _bytes(self):
        return b''.join((
            b'\x86\x0fO\xe9',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.chats)),b''.join(struct.pack('<q', x) for x in self.chats),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _chats = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _chats.append(_x)

        return cls(chats=_chats)


class InputPrivacyValueDisallowContacts(TLObject):
    CONSTRUCTOR_ID = 0xba52007
    SUBCLASS_OF_ID = 0x5a3b6b22

    def to_dict(self):
        return {
            '_': 'InputPrivacyValueDisallowContacts'
        }

    def _bytes(self):
        return b''.join((
            b'\x07 \xa5\x0b',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputPrivacyValueDisallowUsers(TLObject):
    CONSTRUCTOR_ID = 0x90110467
    SUBCLASS_OF_ID = 0x5a3b6b22

    def __init__(self, users: List['TypeInputUser']):
        """
        Constructor for InputPrivacyRule: Instance of either InputPrivacyValueAllowContacts, InputPrivacyValueAllowAll, InputPrivacyValueAllowUsers, InputPrivacyValueDisallowContacts, InputPrivacyValueDisallowAll, InputPrivacyValueDisallowUsers, InputPrivacyValueAllowChatParticipants, InputPrivacyValueDisallowChatParticipants, InputPrivacyValueAllowCloseFriends.
        """
        self.users = users

    def to_dict(self):
        return {
            '_': 'InputPrivacyValueDisallowUsers',
            'users': [] if self.users is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.users]
        }

    def _bytes(self):
        return b''.join((
            b'g\x04\x11\x90',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        return cls(users=_users)


class InputReplyToMessage(TLObject):
    CONSTRUCTOR_ID = 0x73ec805
    SUBCLASS_OF_ID = 0x8c71131d

    def __init__(self, reply_to_msg_id: int, top_msg_id: Optional[int]=None, reply_to_peer_id: Optional['TypeInputPeer']=None, quote_text: Optional[str]=None, quote_entities: Optional[List['TypeMessageEntity']]=None):
        """
        Constructor for InputReplyTo: Instance of either InputReplyToMessage, InputReplyToStory.
        """
        self.reply_to_msg_id = reply_to_msg_id
        self.top_msg_id = top_msg_id
        self.reply_to_peer_id = reply_to_peer_id
        self.quote_text = quote_text
        self.quote_entities = quote_entities

    def to_dict(self):
        return {
            '_': 'InputReplyToMessage',
            'reply_to_msg_id': self.reply_to_msg_id,
            'top_msg_id': self.top_msg_id,
            'reply_to_peer_id': self.reply_to_peer_id.to_dict() if isinstance(self.reply_to_peer_id, TLObject) else self.reply_to_peer_id,
            'quote_text': self.quote_text,
            'quote_entities': [] if self.quote_entities is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.quote_entities]
        }

    def _bytes(self):
        return b''.join((
            b'\x05\xc8>\x07',
            struct.pack('<I', (0 if self.top_msg_id is None or self.top_msg_id is False else 1) | (0 if self.reply_to_peer_id is None or self.reply_to_peer_id is False else 2) | (0 if self.quote_text is None or self.quote_text is False else 4) | (0 if self.quote_entities is None or self.quote_entities is False else 8)),
            struct.pack('<i', self.reply_to_msg_id),
            b'' if self.top_msg_id is None or self.top_msg_id is False else (struct.pack('<i', self.top_msg_id)),
            b'' if self.reply_to_peer_id is None or self.reply_to_peer_id is False else (self.reply_to_peer_id._bytes()),
            b'' if self.quote_text is None or self.quote_text is False else (self.serialize_bytes(self.quote_text)),
            b'' if self.quote_entities is None or self.quote_entities is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.quote_entities)),b''.join(x._bytes() for x in self.quote_entities))),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _reply_to_msg_id = reader.read_int()
        if flags & 1:
            _top_msg_id = reader.read_int()
        else:
            _top_msg_id = None
        if flags & 2:
            _reply_to_peer_id = reader.tgread_object()
        else:
            _reply_to_peer_id = None
        if flags & 4:
            _quote_text = reader.tgread_string()
        else:
            _quote_text = None
        if flags & 8:
            reader.read_int()
            _quote_entities = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _quote_entities.append(_x)

        else:
            _quote_entities = None
        return cls(reply_to_msg_id=_reply_to_msg_id, top_msg_id=_top_msg_id, reply_to_peer_id=_reply_to_peer_id, quote_text=_quote_text, quote_entities=_quote_entities)


class InputReplyToStory(TLObject):
    CONSTRUCTOR_ID = 0x15b0f283
    SUBCLASS_OF_ID = 0x8c71131d

    def __init__(self, user_id: 'TypeInputUser', story_id: int):
        """
        Constructor for InputReplyTo: Instance of either InputReplyToMessage, InputReplyToStory.
        """
        self.user_id = user_id
        self.story_id = story_id

    def to_dict(self):
        return {
            '_': 'InputReplyToStory',
            'user_id': self.user_id.to_dict() if isinstance(self.user_id, TLObject) else self.user_id,
            'story_id': self.story_id
        }

    def _bytes(self):
        return b''.join((
            b'\x83\xf2\xb0\x15',
            self.user_id._bytes(),
            struct.pack('<i', self.story_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _user_id = reader.tgread_object()
        _story_id = reader.read_int()
        return cls(user_id=_user_id, story_id=_story_id)


class InputReportReasonChildAbuse(TLObject):
    CONSTRUCTOR_ID = 0xadf44ee3
    SUBCLASS_OF_ID = 0x8401bd27

    def to_dict(self):
        return {
            '_': 'InputReportReasonChildAbuse'
        }

    def _bytes(self):
        return b''.join((
            b'\xe3N\xf4\xad',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputReportReasonCopyright(TLObject):
    CONSTRUCTOR_ID = 0x9b89f93a
    SUBCLASS_OF_ID = 0x8401bd27

    def to_dict(self):
        return {
            '_': 'InputReportReasonCopyright'
        }

    def _bytes(self):
        return b''.join((
            b':\xf9\x89\x9b',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputReportReasonFake(TLObject):
    CONSTRUCTOR_ID = 0xf5ddd6e7
    SUBCLASS_OF_ID = 0x8401bd27

    def to_dict(self):
        return {
            '_': 'InputReportReasonFake'
        }

    def _bytes(self):
        return b''.join((
            b'\xe7\xd6\xdd\xf5',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputReportReasonGeoIrrelevant(TLObject):
    CONSTRUCTOR_ID = 0xdbd4feed
    SUBCLASS_OF_ID = 0x8401bd27

    def to_dict(self):
        return {
            '_': 'InputReportReasonGeoIrrelevant'
        }

    def _bytes(self):
        return b''.join((
            b'\xed\xfe\xd4\xdb',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputReportReasonIllegalDrugs(TLObject):
    CONSTRUCTOR_ID = 0xa8eb2be
    SUBCLASS_OF_ID = 0x8401bd27

    def to_dict(self):
        return {
            '_': 'InputReportReasonIllegalDrugs'
        }

    def _bytes(self):
        return b''.join((
            b'\xbe\xb2\x8e\n',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputReportReasonOther(TLObject):
    CONSTRUCTOR_ID = 0xc1e4a2b1
    SUBCLASS_OF_ID = 0x8401bd27

    def to_dict(self):
        return {
            '_': 'InputReportReasonOther'
        }

    def _bytes(self):
        return b''.join((
            b'\xb1\xa2\xe4\xc1',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputReportReasonPersonalDetails(TLObject):
    CONSTRUCTOR_ID = 0x9ec7863d
    SUBCLASS_OF_ID = 0x8401bd27

    def to_dict(self):
        return {
            '_': 'InputReportReasonPersonalDetails'
        }

    def _bytes(self):
        return b''.join((
            b'=\x86\xc7\x9e',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputReportReasonPornography(TLObject):
    CONSTRUCTOR_ID = 0x2e59d922
    SUBCLASS_OF_ID = 0x8401bd27

    def to_dict(self):
        return {
            '_': 'InputReportReasonPornography'
        }

    def _bytes(self):
        return b''.join((
            b'"\xd9Y.',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputReportReasonSpam(TLObject):
    CONSTRUCTOR_ID = 0x58dbcab8
    SUBCLASS_OF_ID = 0x8401bd27

    def to_dict(self):
        return {
            '_': 'InputReportReasonSpam'
        }

    def _bytes(self):
        return b''.join((
            b'\xb8\xca\xdbX',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputReportReasonViolence(TLObject):
    CONSTRUCTOR_ID = 0x1e22c78d
    SUBCLASS_OF_ID = 0x8401bd27

    def to_dict(self):
        return {
            '_': 'InputReportReasonViolence'
        }

    def _bytes(self):
        return b''.join((
            b'\x8d\xc7"\x1e',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputSecureFile(TLObject):
    CONSTRUCTOR_ID = 0x5367e5be
    SUBCLASS_OF_ID = 0xdac8adfc

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int):
        """
        Constructor for InputSecureFile: Instance of either InputSecureFileUploaded, InputSecureFile.
        """
        self.id = id
        self.access_hash = access_hash

    def to_dict(self):
        return {
            '_': 'InputSecureFile',
            'id': self.id,
            'access_hash': self.access_hash
        }

    def _bytes(self):
        return b''.join((
            b'\xbe\xe5gS',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        return cls(id=_id, access_hash=_access_hash)


class InputSecureFileLocation(TLObject):
    CONSTRUCTOR_ID = 0xcbc7ee28
    SUBCLASS_OF_ID = 0x1523d462

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int):
        """
        Constructor for InputFileLocation: Instance of either InputFileLocation, InputEncryptedFileLocation, InputDocumentFileLocation, InputSecureFileLocation, InputTakeoutFileLocation, InputPhotoFileLocation, InputPhotoLegacyFileLocation, InputPeerPhotoFileLocation, InputStickerSetThumb, InputGroupCallStream.
        """
        self.id = id
        self.access_hash = access_hash

    def to_dict(self):
        return {
            '_': 'InputSecureFileLocation',
            'id': self.id,
            'access_hash': self.access_hash
        }

    def _bytes(self):
        return b''.join((
            b'(\xee\xc7\xcb',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        return cls(id=_id, access_hash=_access_hash)


class InputSecureFileUploaded(TLObject):
    CONSTRUCTOR_ID = 0x3334b0f0
    SUBCLASS_OF_ID = 0xdac8adfc

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, parts: int, md5_checksum: str, file_hash: bytes, secret: bytes):
        """
        Constructor for InputSecureFile: Instance of either InputSecureFileUploaded, InputSecureFile.
        """
        self.id = id
        self.parts = parts
        self.md5_checksum = md5_checksum
        self.file_hash = file_hash
        self.secret = secret

    def to_dict(self):
        return {
            '_': 'InputSecureFileUploaded',
            'id': self.id,
            'parts': self.parts,
            'md5_checksum': self.md5_checksum,
            'file_hash': self.file_hash,
            'secret': self.secret
        }

    def _bytes(self):
        return b''.join((
            b'\xf0\xb043',
            struct.pack('<q', self.id),
            struct.pack('<i', self.parts),
            self.serialize_bytes(self.md5_checksum),
            self.serialize_bytes(self.file_hash),
            self.serialize_bytes(self.secret),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _parts = reader.read_int()
        _md5_checksum = reader.tgread_string()
        _file_hash = reader.tgread_bytes()
        _secret = reader.tgread_bytes()
        return cls(id=_id, parts=_parts, md5_checksum=_md5_checksum, file_hash=_file_hash, secret=_secret)


class InputSecureValue(TLObject):
    CONSTRUCTOR_ID = 0xdb21d0a7
    SUBCLASS_OF_ID = 0xb49da1fc

    # noinspection PyShadowingBuiltins
    def __init__(self, type: 'TypeSecureValueType', data: Optional['TypeSecureData']=None, front_side: Optional['TypeInputSecureFile']=None, reverse_side: Optional['TypeInputSecureFile']=None, selfie: Optional['TypeInputSecureFile']=None, translation: Optional[List['TypeInputSecureFile']]=None, files: Optional[List['TypeInputSecureFile']]=None, plain_data: Optional['TypeSecurePlainData']=None):
        """
        Constructor for InputSecureValue: Instance of InputSecureValue.
        """
        self.type = type
        self.data = data
        self.front_side = front_side
        self.reverse_side = reverse_side
        self.selfie = selfie
        self.translation = translation
        self.files = files
        self.plain_data = plain_data

    def to_dict(self):
        return {
            '_': 'InputSecureValue',
            'type': self.type.to_dict() if isinstance(self.type, TLObject) else self.type,
            'data': self.data.to_dict() if isinstance(self.data, TLObject) else self.data,
            'front_side': self.front_side.to_dict() if isinstance(self.front_side, TLObject) else self.front_side,
            'reverse_side': self.reverse_side.to_dict() if isinstance(self.reverse_side, TLObject) else self.reverse_side,
            'selfie': self.selfie.to_dict() if isinstance(self.selfie, TLObject) else self.selfie,
            'translation': [] if self.translation is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.translation],
            'files': [] if self.files is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.files],
            'plain_data': self.plain_data.to_dict() if isinstance(self.plain_data, TLObject) else self.plain_data
        }

    def _bytes(self):
        return b''.join((
            b'\xa7\xd0!\xdb',
            struct.pack('<I', (0 if self.data is None or self.data is False else 1) | (0 if self.front_side is None or self.front_side is False else 2) | (0 if self.reverse_side is None or self.reverse_side is False else 4) | (0 if self.selfie is None or self.selfie is False else 8) | (0 if self.translation is None or self.translation is False else 64) | (0 if self.files is None or self.files is False else 16) | (0 if self.plain_data is None or self.plain_data is False else 32)),
            self.type._bytes(),
            b'' if self.data is None or self.data is False else (self.data._bytes()),
            b'' if self.front_side is None or self.front_side is False else (self.front_side._bytes()),
            b'' if self.reverse_side is None or self.reverse_side is False else (self.reverse_side._bytes()),
            b'' if self.selfie is None or self.selfie is False else (self.selfie._bytes()),
            b'' if self.translation is None or self.translation is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.translation)),b''.join(x._bytes() for x in self.translation))),
            b'' if self.files is None or self.files is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.files)),b''.join(x._bytes() for x in self.files))),
            b'' if self.plain_data is None or self.plain_data is False else (self.plain_data._bytes()),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _type = reader.tgread_object()
        if flags & 1:
            _data = reader.tgread_object()
        else:
            _data = None
        if flags & 2:
            _front_side = reader.tgread_object()
        else:
            _front_side = None
        if flags & 4:
            _reverse_side = reader.tgread_object()
        else:
            _reverse_side = None
        if flags & 8:
            _selfie = reader.tgread_object()
        else:
            _selfie = None
        if flags & 64:
            reader.read_int()
            _translation = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _translation.append(_x)

        else:
            _translation = None
        if flags & 16:
            reader.read_int()
            _files = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _files.append(_x)

        else:
            _files = None
        if flags & 32:
            _plain_data = reader.tgread_object()
        else:
            _plain_data = None
        return cls(type=_type, data=_data, front_side=_front_side, reverse_side=_reverse_side, selfie=_selfie, translation=_translation, files=_files, plain_data=_plain_data)


class InputSingleMedia(TLObject):
    CONSTRUCTOR_ID = 0x1cc6e91f
    SUBCLASS_OF_ID = 0x21ca8ed8

    def __init__(self, media: 'TypeInputMedia', message: str, random_id: int=None, entities: Optional[List['TypeMessageEntity']]=None):
        """
        Constructor for InputSingleMedia: Instance of InputSingleMedia.
        """
        self.media = media
        self.message = message
        self.random_id = random_id if random_id is not None else int.from_bytes(os.urandom(8), 'big', signed=True)
        self.entities = entities

    def to_dict(self):
        return {
            '_': 'InputSingleMedia',
            'media': self.media.to_dict() if isinstance(self.media, TLObject) else self.media,
            'message': self.message,
            'random_id': self.random_id,
            'entities': [] if self.entities is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.entities]
        }

    def _bytes(self):
        return b''.join((
            b'\x1f\xe9\xc6\x1c',
            struct.pack('<I', (0 if self.entities is None or self.entities is False else 1)),
            self.media._bytes(),
            struct.pack('<q', self.random_id),
            self.serialize_bytes(self.message),
            b'' if self.entities is None or self.entities is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.entities)),b''.join(x._bytes() for x in self.entities))),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _media = reader.tgread_object()
        _random_id = reader.read_long()
        _message = reader.tgread_string()
        if flags & 1:
            reader.read_int()
            _entities = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _entities.append(_x)

        else:
            _entities = None
        return cls(media=_media, message=_message, random_id=_random_id, entities=_entities)


class InputStickerSetAnimatedEmoji(TLObject):
    CONSTRUCTOR_ID = 0x28703c8
    SUBCLASS_OF_ID = 0x3da389aa

    def to_dict(self):
        return {
            '_': 'InputStickerSetAnimatedEmoji'
        }

    def _bytes(self):
        return b''.join((
            b'\xc8\x03\x87\x02',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputStickerSetAnimatedEmojiAnimations(TLObject):
    CONSTRUCTOR_ID = 0xcde3739
    SUBCLASS_OF_ID = 0x3da389aa

    def to_dict(self):
        return {
            '_': 'InputStickerSetAnimatedEmojiAnimations'
        }

    def _bytes(self):
        return b''.join((
            b'97\xde\x0c',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputStickerSetDice(TLObject):
    CONSTRUCTOR_ID = 0xe67f520e
    SUBCLASS_OF_ID = 0x3da389aa

    def __init__(self, emoticon: str):
        """
        Constructor for InputStickerSet: Instance of either InputStickerSetEmpty, InputStickerSetID, InputStickerSetShortName, InputStickerSetAnimatedEmoji, InputStickerSetDice, InputStickerSetAnimatedEmojiAnimations, InputStickerSetPremiumGifts, InputStickerSetEmojiGenericAnimations, InputStickerSetEmojiDefaultStatuses, InputStickerSetEmojiDefaultTopicIcons.
        """
        self.emoticon = emoticon

    def to_dict(self):
        return {
            '_': 'InputStickerSetDice',
            'emoticon': self.emoticon
        }

    def _bytes(self):
        return b''.join((
            b'\x0eR\x7f\xe6',
            self.serialize_bytes(self.emoticon),
        ))

    @classmethod
    def from_reader(cls, reader):
        _emoticon = reader.tgread_string()
        return cls(emoticon=_emoticon)


class InputStickerSetEmojiDefaultStatuses(TLObject):
    CONSTRUCTOR_ID = 0x29d0f5ee
    SUBCLASS_OF_ID = 0x3da389aa

    def to_dict(self):
        return {
            '_': 'InputStickerSetEmojiDefaultStatuses'
        }

    def _bytes(self):
        return b''.join((
            b'\xee\xf5\xd0)',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputStickerSetEmojiDefaultTopicIcons(TLObject):
    CONSTRUCTOR_ID = 0x44c1f8e9
    SUBCLASS_OF_ID = 0x3da389aa

    def to_dict(self):
        return {
            '_': 'InputStickerSetEmojiDefaultTopicIcons'
        }

    def _bytes(self):
        return b''.join((
            b'\xe9\xf8\xc1D',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputStickerSetEmojiGenericAnimations(TLObject):
    CONSTRUCTOR_ID = 0x4c4d4ce
    SUBCLASS_OF_ID = 0x3da389aa

    def to_dict(self):
        return {
            '_': 'InputStickerSetEmojiGenericAnimations'
        }

    def _bytes(self):
        return b''.join((
            b'\xce\xd4\xc4\x04',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputStickerSetEmpty(TLObject):
    CONSTRUCTOR_ID = 0xffb62b95
    SUBCLASS_OF_ID = 0x3da389aa

    def to_dict(self):
        return {
            '_': 'InputStickerSetEmpty'
        }

    def _bytes(self):
        return b''.join((
            b'\x95+\xb6\xff',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputStickerSetID(TLObject):
    CONSTRUCTOR_ID = 0x9de7a269
    SUBCLASS_OF_ID = 0x3da389aa

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int):
        """
        Constructor for InputStickerSet: Instance of either InputStickerSetEmpty, InputStickerSetID, InputStickerSetShortName, InputStickerSetAnimatedEmoji, InputStickerSetDice, InputStickerSetAnimatedEmojiAnimations, InputStickerSetPremiumGifts, InputStickerSetEmojiGenericAnimations, InputStickerSetEmojiDefaultStatuses, InputStickerSetEmojiDefaultTopicIcons.
        """
        self.id = id
        self.access_hash = access_hash

    def to_dict(self):
        return {
            '_': 'InputStickerSetID',
            'id': self.id,
            'access_hash': self.access_hash
        }

    def _bytes(self):
        return b''.join((
            b'i\xa2\xe7\x9d',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        return cls(id=_id, access_hash=_access_hash)


class InputStickerSetItem(TLObject):
    CONSTRUCTOR_ID = 0x32da9e9c
    SUBCLASS_OF_ID = 0xae59f075

    def __init__(self, document: 'TypeInputDocument', emoji: str, mask_coords: Optional['TypeMaskCoords']=None, keywords: Optional[str]=None):
        """
        Constructor for InputStickerSetItem: Instance of InputStickerSetItem.
        """
        self.document = document
        self.emoji = emoji
        self.mask_coords = mask_coords
        self.keywords = keywords

    def to_dict(self):
        return {
            '_': 'InputStickerSetItem',
            'document': self.document.to_dict() if isinstance(self.document, TLObject) else self.document,
            'emoji': self.emoji,
            'mask_coords': self.mask_coords.to_dict() if isinstance(self.mask_coords, TLObject) else self.mask_coords,
            'keywords': self.keywords
        }

    def _bytes(self):
        return b''.join((
            b'\x9c\x9e\xda2',
            struct.pack('<I', (0 if self.mask_coords is None or self.mask_coords is False else 1) | (0 if self.keywords is None or self.keywords is False else 2)),
            self.document._bytes(),
            self.serialize_bytes(self.emoji),
            b'' if self.mask_coords is None or self.mask_coords is False else (self.mask_coords._bytes()),
            b'' if self.keywords is None or self.keywords is False else (self.serialize_bytes(self.keywords)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _document = reader.tgread_object()
        _emoji = reader.tgread_string()
        if flags & 1:
            _mask_coords = reader.tgread_object()
        else:
            _mask_coords = None
        if flags & 2:
            _keywords = reader.tgread_string()
        else:
            _keywords = None
        return cls(document=_document, emoji=_emoji, mask_coords=_mask_coords, keywords=_keywords)


class InputStickerSetPremiumGifts(TLObject):
    CONSTRUCTOR_ID = 0xc88b3b02
    SUBCLASS_OF_ID = 0x3da389aa

    def to_dict(self):
        return {
            '_': 'InputStickerSetPremiumGifts'
        }

    def _bytes(self):
        return b''.join((
            b'\x02;\x8b\xc8',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputStickerSetShortName(TLObject):
    CONSTRUCTOR_ID = 0x861cc8a0
    SUBCLASS_OF_ID = 0x3da389aa

    def __init__(self, short_name: str):
        """
        Constructor for InputStickerSet: Instance of either InputStickerSetEmpty, InputStickerSetID, InputStickerSetShortName, InputStickerSetAnimatedEmoji, InputStickerSetDice, InputStickerSetAnimatedEmojiAnimations, InputStickerSetPremiumGifts, InputStickerSetEmojiGenericAnimations, InputStickerSetEmojiDefaultStatuses, InputStickerSetEmojiDefaultTopicIcons.
        """
        self.short_name = short_name

    def to_dict(self):
        return {
            '_': 'InputStickerSetShortName',
            'short_name': self.short_name
        }

    def _bytes(self):
        return b''.join((
            b'\xa0\xc8\x1c\x86',
            self.serialize_bytes(self.short_name),
        ))

    @classmethod
    def from_reader(cls, reader):
        _short_name = reader.tgread_string()
        return cls(short_name=_short_name)


class InputStickerSetThumb(TLObject):
    CONSTRUCTOR_ID = 0x9d84f3db
    SUBCLASS_OF_ID = 0x1523d462

    def __init__(self, stickerset: 'TypeInputStickerSet', thumb_version: int):
        """
        Constructor for InputFileLocation: Instance of either InputFileLocation, InputEncryptedFileLocation, InputDocumentFileLocation, InputSecureFileLocation, InputTakeoutFileLocation, InputPhotoFileLocation, InputPhotoLegacyFileLocation, InputPeerPhotoFileLocation, InputStickerSetThumb, InputGroupCallStream.
        """
        self.stickerset = stickerset
        self.thumb_version = thumb_version

    def to_dict(self):
        return {
            '_': 'InputStickerSetThumb',
            'stickerset': self.stickerset.to_dict() if isinstance(self.stickerset, TLObject) else self.stickerset,
            'thumb_version': self.thumb_version
        }

    def _bytes(self):
        return b''.join((
            b'\xdb\xf3\x84\x9d',
            self.stickerset._bytes(),
            struct.pack('<i', self.thumb_version),
        ))

    @classmethod
    def from_reader(cls, reader):
        _stickerset = reader.tgread_object()
        _thumb_version = reader.read_int()
        return cls(stickerset=_stickerset, thumb_version=_thumb_version)


class InputStickeredMediaDocument(TLObject):
    CONSTRUCTOR_ID = 0x438865b
    SUBCLASS_OF_ID = 0x5146d99e

    # noinspection PyShadowingBuiltins
    def __init__(self, id: 'TypeInputDocument'):
        """
        Constructor for InputStickeredMedia: Instance of either InputStickeredMediaPhoto, InputStickeredMediaDocument.
        """
        self.id = id

    def to_dict(self):
        return {
            '_': 'InputStickeredMediaDocument',
            'id': self.id.to_dict() if isinstance(self.id, TLObject) else self.id
        }

    def _bytes(self):
        return b''.join((
            b'[\x868\x04',
            self.id._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.tgread_object()
        return cls(id=_id)


class InputStickeredMediaPhoto(TLObject):
    CONSTRUCTOR_ID = 0x4a992157
    SUBCLASS_OF_ID = 0x5146d99e

    # noinspection PyShadowingBuiltins
    def __init__(self, id: 'TypeInputPhoto'):
        """
        Constructor for InputStickeredMedia: Instance of either InputStickeredMediaPhoto, InputStickeredMediaDocument.
        """
        self.id = id

    def to_dict(self):
        return {
            '_': 'InputStickeredMediaPhoto',
            'id': self.id.to_dict() if isinstance(self.id, TLObject) else self.id
        }

    def _bytes(self):
        return b''.join((
            b'W!\x99J',
            self.id._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.tgread_object()
        return cls(id=_id)


class InputStorePaymentGiftPremium(TLObject):
    CONSTRUCTOR_ID = 0x616f7fe8
    SUBCLASS_OF_ID = 0xe7a4174d

    def __init__(self, user_id: 'TypeInputUser', currency: str, amount: int):
        """
        Constructor for InputStorePaymentPurpose: Instance of either InputStorePaymentPremiumSubscription, InputStorePaymentGiftPremium, InputStorePaymentPremiumGiftCode, InputStorePaymentPremiumGiveaway.
        """
        self.user_id = user_id
        self.currency = currency
        self.amount = amount

    def to_dict(self):
        return {
            '_': 'InputStorePaymentGiftPremium',
            'user_id': self.user_id.to_dict() if isinstance(self.user_id, TLObject) else self.user_id,
            'currency': self.currency,
            'amount': self.amount
        }

    def _bytes(self):
        return b''.join((
            b'\xe8\x7foa',
            self.user_id._bytes(),
            self.serialize_bytes(self.currency),
            struct.pack('<q', self.amount),
        ))

    @classmethod
    def from_reader(cls, reader):
        _user_id = reader.tgread_object()
        _currency = reader.tgread_string()
        _amount = reader.read_long()
        return cls(user_id=_user_id, currency=_currency, amount=_amount)


class InputStorePaymentPremiumGiftCode(TLObject):
    CONSTRUCTOR_ID = 0xa3805f3f
    SUBCLASS_OF_ID = 0xe7a4174d

    def __init__(self, users: List['TypeInputUser'], currency: str, amount: int, boost_peer: Optional['TypeInputPeer']=None):
        """
        Constructor for InputStorePaymentPurpose: Instance of either InputStorePaymentPremiumSubscription, InputStorePaymentGiftPremium, InputStorePaymentPremiumGiftCode, InputStorePaymentPremiumGiveaway.
        """
        self.users = users
        self.currency = currency
        self.amount = amount
        self.boost_peer = boost_peer

    def to_dict(self):
        return {
            '_': 'InputStorePaymentPremiumGiftCode',
            'users': [] if self.users is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.users],
            'currency': self.currency,
            'amount': self.amount,
            'boost_peer': self.boost_peer.to_dict() if isinstance(self.boost_peer, TLObject) else self.boost_peer
        }

    def _bytes(self):
        return b''.join((
            b'?_\x80\xa3',
            struct.pack('<I', (0 if self.boost_peer is None or self.boost_peer is False else 1)),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(x._bytes() for x in self.users),
            b'' if self.boost_peer is None or self.boost_peer is False else (self.boost_peer._bytes()),
            self.serialize_bytes(self.currency),
            struct.pack('<q', self.amount),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _users.append(_x)

        if flags & 1:
            _boost_peer = reader.tgread_object()
        else:
            _boost_peer = None
        _currency = reader.tgread_string()
        _amount = reader.read_long()
        return cls(users=_users, currency=_currency, amount=_amount, boost_peer=_boost_peer)


class InputStorePaymentPremiumGiveaway(TLObject):
    CONSTRUCTOR_ID = 0x7c9375e6
    SUBCLASS_OF_ID = 0xe7a4174d

    def __init__(self, boost_peer: 'TypeInputPeer', until_date: Optional[datetime], currency: str, amount: int, only_new_subscribers: Optional[bool]=None, additional_peers: Optional[List['TypeInputPeer']]=None, countries_iso2: Optional[List[str]]=None, random_id: int=None):
        """
        Constructor for InputStorePaymentPurpose: Instance of either InputStorePaymentPremiumSubscription, InputStorePaymentGiftPremium, InputStorePaymentPremiumGiftCode, InputStorePaymentPremiumGiveaway.
        """
        self.boost_peer = boost_peer
        self.until_date = until_date
        self.currency = currency
        self.amount = amount
        self.only_new_subscribers = only_new_subscribers
        self.additional_peers = additional_peers
        self.countries_iso2 = countries_iso2
        self.random_id = random_id if random_id is not None else int.from_bytes(os.urandom(8), 'big', signed=True)

    def to_dict(self):
        return {
            '_': 'InputStorePaymentPremiumGiveaway',
            'boost_peer': self.boost_peer.to_dict() if isinstance(self.boost_peer, TLObject) else self.boost_peer,
            'until_date': self.until_date,
            'currency': self.currency,
            'amount': self.amount,
            'only_new_subscribers': self.only_new_subscribers,
            'additional_peers': [] if self.additional_peers is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.additional_peers],
            'countries_iso2': [] if self.countries_iso2 is None else self.countries_iso2[:],
            'random_id': self.random_id
        }

    def _bytes(self):
        return b''.join((
            b'\xe6u\x93|',
            struct.pack('<I', (0 if self.only_new_subscribers is None or self.only_new_subscribers is False else 1) | (0 if self.additional_peers is None or self.additional_peers is False else 2) | (0 if self.countries_iso2 is None or self.countries_iso2 is False else 4)),
            self.boost_peer._bytes(),
            b'' if self.additional_peers is None or self.additional_peers is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.additional_peers)),b''.join(x._bytes() for x in self.additional_peers))),
            b'' if self.countries_iso2 is None or self.countries_iso2 is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.countries_iso2)),b''.join(self.serialize_bytes(x) for x in self.countries_iso2))),
            struct.pack('<q', self.random_id),
            self.serialize_datetime(self.until_date),
            self.serialize_bytes(self.currency),
            struct.pack('<q', self.amount),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _only_new_subscribers = bool(flags & 1)
        _boost_peer = reader.tgread_object()
        if flags & 2:
            reader.read_int()
            _additional_peers = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _additional_peers.append(_x)

        else:
            _additional_peers = None
        if flags & 4:
            reader.read_int()
            _countries_iso2 = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_string()
                _countries_iso2.append(_x)

        else:
            _countries_iso2 = None
        _random_id = reader.read_long()
        _until_date = reader.tgread_date()
        _currency = reader.tgread_string()
        _amount = reader.read_long()
        return cls(boost_peer=_boost_peer, until_date=_until_date, currency=_currency, amount=_amount, only_new_subscribers=_only_new_subscribers, additional_peers=_additional_peers, countries_iso2=_countries_iso2, random_id=_random_id)


class InputStorePaymentPremiumSubscription(TLObject):
    CONSTRUCTOR_ID = 0xa6751e66
    SUBCLASS_OF_ID = 0xe7a4174d

    def __init__(self, restore: Optional[bool]=None, upgrade: Optional[bool]=None):
        """
        Constructor for InputStorePaymentPurpose: Instance of either InputStorePaymentPremiumSubscription, InputStorePaymentGiftPremium, InputStorePaymentPremiumGiftCode, InputStorePaymentPremiumGiveaway.
        """
        self.restore = restore
        self.upgrade = upgrade

    def to_dict(self):
        return {
            '_': 'InputStorePaymentPremiumSubscription',
            'restore': self.restore,
            'upgrade': self.upgrade
        }

    def _bytes(self):
        return b''.join((
            b'f\x1eu\xa6',
            struct.pack('<I', (0 if self.restore is None or self.restore is False else 1) | (0 if self.upgrade is None or self.upgrade is False else 2)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _restore = bool(flags & 1)
        _upgrade = bool(flags & 2)
        return cls(restore=_restore, upgrade=_upgrade)


class InputTakeoutFileLocation(TLObject):
    CONSTRUCTOR_ID = 0x29be5899
    SUBCLASS_OF_ID = 0x1523d462

    def to_dict(self):
        return {
            '_': 'InputTakeoutFileLocation'
        }

    def _bytes(self):
        return b''.join((
            b'\x99X\xbe)',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputTheme(TLObject):
    CONSTRUCTOR_ID = 0x3c5693e9
    SUBCLASS_OF_ID = 0x7a100f0

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int):
        """
        Constructor for InputTheme: Instance of either InputTheme, InputThemeSlug.
        """
        self.id = id
        self.access_hash = access_hash

    def to_dict(self):
        return {
            '_': 'InputTheme',
            'id': self.id,
            'access_hash': self.access_hash
        }

    def _bytes(self):
        return b''.join((
            b'\xe9\x93V<',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        return cls(id=_id, access_hash=_access_hash)


class InputThemeSettings(TLObject):
    CONSTRUCTOR_ID = 0x8fde504f
    SUBCLASS_OF_ID = 0x8338c882

    def __init__(self, base_theme: 'TypeBaseTheme', accent_color: int, message_colors_animated: Optional[bool]=None, outbox_accent_color: Optional[int]=None, message_colors: Optional[List[int]]=None, wallpaper: Optional['TypeInputWallPaper']=None, wallpaper_settings: Optional['TypeWallPaperSettings']=None):
        """
        Constructor for InputThemeSettings: Instance of InputThemeSettings.
        """
        self.base_theme = base_theme
        self.accent_color = accent_color
        self.message_colors_animated = message_colors_animated
        self.outbox_accent_color = outbox_accent_color
        self.message_colors = message_colors
        self.wallpaper = wallpaper
        self.wallpaper_settings = wallpaper_settings

    def to_dict(self):
        return {
            '_': 'InputThemeSettings',
            'base_theme': self.base_theme.to_dict() if isinstance(self.base_theme, TLObject) else self.base_theme,
            'accent_color': self.accent_color,
            'message_colors_animated': self.message_colors_animated,
            'outbox_accent_color': self.outbox_accent_color,
            'message_colors': [] if self.message_colors is None else self.message_colors[:],
            'wallpaper': self.wallpaper.to_dict() if isinstance(self.wallpaper, TLObject) else self.wallpaper,
            'wallpaper_settings': self.wallpaper_settings.to_dict() if isinstance(self.wallpaper_settings, TLObject) else self.wallpaper_settings
        }

    def _bytes(self):
        assert ((self.wallpaper or self.wallpaper is not None) and (self.wallpaper_settings or self.wallpaper_settings is not None)) or ((self.wallpaper is None or self.wallpaper is False) and (self.wallpaper_settings is None or self.wallpaper_settings is False)), 'wallpaper, wallpaper_settings parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'OP\xde\x8f',
            struct.pack('<I', (0 if self.message_colors_animated is None or self.message_colors_animated is False else 4) | (0 if self.outbox_accent_color is None or self.outbox_accent_color is False else 8) | (0 if self.message_colors is None or self.message_colors is False else 1) | (0 if self.wallpaper is None or self.wallpaper is False else 2) | (0 if self.wallpaper_settings is None or self.wallpaper_settings is False else 2)),
            self.base_theme._bytes(),
            struct.pack('<i', self.accent_color),
            b'' if self.outbox_accent_color is None or self.outbox_accent_color is False else (struct.pack('<i', self.outbox_accent_color)),
            b'' if self.message_colors is None or self.message_colors is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.message_colors)),b''.join(struct.pack('<i', x) for x in self.message_colors))),
            b'' if self.wallpaper is None or self.wallpaper is False else (self.wallpaper._bytes()),
            b'' if self.wallpaper_settings is None or self.wallpaper_settings is False else (self.wallpaper_settings._bytes()),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _message_colors_animated = bool(flags & 4)
        _base_theme = reader.tgread_object()
        _accent_color = reader.read_int()
        if flags & 8:
            _outbox_accent_color = reader.read_int()
        else:
            _outbox_accent_color = None
        if flags & 1:
            reader.read_int()
            _message_colors = []
            for _ in range(reader.read_int()):
                _x = reader.read_int()
                _message_colors.append(_x)

        else:
            _message_colors = None
        if flags & 2:
            _wallpaper = reader.tgread_object()
        else:
            _wallpaper = None
        if flags & 2:
            _wallpaper_settings = reader.tgread_object()
        else:
            _wallpaper_settings = None
        return cls(base_theme=_base_theme, accent_color=_accent_color, message_colors_animated=_message_colors_animated, outbox_accent_color=_outbox_accent_color, message_colors=_message_colors, wallpaper=_wallpaper, wallpaper_settings=_wallpaper_settings)


class InputThemeSlug(TLObject):
    CONSTRUCTOR_ID = 0xf5890df1
    SUBCLASS_OF_ID = 0x7a100f0

    def __init__(self, slug: str):
        """
        Constructor for InputTheme: Instance of either InputTheme, InputThemeSlug.
        """
        self.slug = slug

    def to_dict(self):
        return {
            '_': 'InputThemeSlug',
            'slug': self.slug
        }

    def _bytes(self):
        return b''.join((
            b'\xf1\r\x89\xf5',
            self.serialize_bytes(self.slug),
        ))

    @classmethod
    def from_reader(cls, reader):
        _slug = reader.tgread_string()
        return cls(slug=_slug)


class InputUser(TLObject):
    CONSTRUCTOR_ID = 0xf21158c6
    SUBCLASS_OF_ID = 0xe669bf46

    def __init__(self, user_id: int, access_hash: int):
        """
        Constructor for InputUser: Instance of either InputUserEmpty, InputUserSelf, InputUser, InputUserFromMessage.
        """
        self.user_id = user_id
        self.access_hash = access_hash

    def to_dict(self):
        return {
            '_': 'InputUser',
            'user_id': self.user_id,
            'access_hash': self.access_hash
        }

    def _bytes(self):
        return b''.join((
            b'\xc6X\x11\xf2',
            struct.pack('<q', self.user_id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _user_id = reader.read_long()
        _access_hash = reader.read_long()
        return cls(user_id=_user_id, access_hash=_access_hash)


class InputUserEmpty(TLObject):
    CONSTRUCTOR_ID = 0xb98886cf
    SUBCLASS_OF_ID = 0xe669bf46

    def to_dict(self):
        return {
            '_': 'InputUserEmpty'
        }

    def _bytes(self):
        return b''.join((
            b'\xcf\x86\x88\xb9',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputUserFromMessage(TLObject):
    CONSTRUCTOR_ID = 0x1da448e2
    SUBCLASS_OF_ID = 0xe669bf46

    def __init__(self, peer: 'TypeInputPeer', msg_id: int, user_id: int):
        """
        Constructor for InputUser: Instance of either InputUserEmpty, InputUserSelf, InputUser, InputUserFromMessage.
        """
        self.peer = peer
        self.msg_id = msg_id
        self.user_id = user_id

    def to_dict(self):
        return {
            '_': 'InputUserFromMessage',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'msg_id': self.msg_id,
            'user_id': self.user_id
        }

    def _bytes(self):
        return b''.join((
            b'\xe2H\xa4\x1d',
            self.peer._bytes(),
            struct.pack('<i', self.msg_id),
            struct.pack('<q', self.user_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _msg_id = reader.read_int()
        _user_id = reader.read_long()
        return cls(peer=_peer, msg_id=_msg_id, user_id=_user_id)


class InputUserSelf(TLObject):
    CONSTRUCTOR_ID = 0xf7c1b13f
    SUBCLASS_OF_ID = 0xe669bf46

    def to_dict(self):
        return {
            '_': 'InputUserSelf'
        }

    def _bytes(self):
        return b''.join((
            b'?\xb1\xc1\xf7',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class InputWallPaper(TLObject):
    CONSTRUCTOR_ID = 0xe630b979
    SUBCLASS_OF_ID = 0xee77201a

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, access_hash: int):
        """
        Constructor for InputWallPaper: Instance of either InputWallPaper, InputWallPaperSlug, InputWallPaperNoFile.
        """
        self.id = id
        self.access_hash = access_hash

    def to_dict(self):
        return {
            '_': 'InputWallPaper',
            'id': self.id,
            'access_hash': self.access_hash
        }

    def _bytes(self):
        return b''.join((
            b'y\xb90\xe6',
            struct.pack('<q', self.id),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        _access_hash = reader.read_long()
        return cls(id=_id, access_hash=_access_hash)


class InputWallPaperNoFile(TLObject):
    CONSTRUCTOR_ID = 0x967a462e
    SUBCLASS_OF_ID = 0xee77201a

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int):
        """
        Constructor for InputWallPaper: Instance of either InputWallPaper, InputWallPaperSlug, InputWallPaperNoFile.
        """
        self.id = id

    def to_dict(self):
        return {
            '_': 'InputWallPaperNoFile',
            'id': self.id
        }

    def _bytes(self):
        return b''.join((
            b'.Fz\x96',
            struct.pack('<q', self.id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        return cls(id=_id)


class InputWallPaperSlug(TLObject):
    CONSTRUCTOR_ID = 0x72091c80
    SUBCLASS_OF_ID = 0xee77201a

    def __init__(self, slug: str):
        """
        Constructor for InputWallPaper: Instance of either InputWallPaper, InputWallPaperSlug, InputWallPaperNoFile.
        """
        self.slug = slug

    def to_dict(self):
        return {
            '_': 'InputWallPaperSlug',
            'slug': self.slug
        }

    def _bytes(self):
        return b''.join((
            b'\x80\x1c\tr',
            self.serialize_bytes(self.slug),
        ))

    @classmethod
    def from_reader(cls, reader):
        _slug = reader.tgread_string()
        return cls(slug=_slug)


class InputWebDocument(TLObject):
    CONSTRUCTOR_ID = 0x9bed434d
    SUBCLASS_OF_ID = 0x8ae8b146

    def __init__(self, url: str, size: int, mime_type: str, attributes: List['TypeDocumentAttribute']):
        """
        Constructor for InputWebDocument: Instance of InputWebDocument.
        """
        self.url = url
        self.size = size
        self.mime_type = mime_type
        self.attributes = attributes

    def to_dict(self):
        return {
            '_': 'InputWebDocument',
            'url': self.url,
            'size': self.size,
            'mime_type': self.mime_type,
            'attributes': [] if self.attributes is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.attributes]
        }

    def _bytes(self):
        return b''.join((
            b'MC\xed\x9b',
            self.serialize_bytes(self.url),
            struct.pack('<i', self.size),
            self.serialize_bytes(self.mime_type),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.attributes)),b''.join(x._bytes() for x in self.attributes),
        ))

    @classmethod
    def from_reader(cls, reader):
        _url = reader.tgread_string()
        _size = reader.read_int()
        _mime_type = reader.tgread_string()
        reader.read_int()
        _attributes = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _attributes.append(_x)

        return cls(url=_url, size=_size, mime_type=_mime_type, attributes=_attributes)


class InputWebFileAudioAlbumThumbLocation(TLObject):
    CONSTRUCTOR_ID = 0xf46fe924
    SUBCLASS_OF_ID = 0xf72ed8d9

    def __init__(self, small: Optional[bool]=None, document: Optional['TypeInputDocument']=None, title: Optional[str]=None, performer: Optional[str]=None):
        """
        Constructor for InputWebFileLocation: Instance of either InputWebFileLocation, InputWebFileGeoPointLocation, InputWebFileAudioAlbumThumbLocation.
        """
        self.small = small
        self.document = document
        self.title = title
        self.performer = performer

    def to_dict(self):
        return {
            '_': 'InputWebFileAudioAlbumThumbLocation',
            'small': self.small,
            'document': self.document.to_dict() if isinstance(self.document, TLObject) else self.document,
            'title': self.title,
            'performer': self.performer
        }

    def _bytes(self):
        assert ((self.title or self.title is not None) and (self.performer or self.performer is not None)) or ((self.title is None or self.title is False) and (self.performer is None or self.performer is False)), 'title, performer parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'$\xe9o\xf4',
            struct.pack('<I', (0 if self.small is None or self.small is False else 4) | (0 if self.document is None or self.document is False else 1) | (0 if self.title is None or self.title is False else 2) | (0 if self.performer is None or self.performer is False else 2)),
            b'' if self.document is None or self.document is False else (self.document._bytes()),
            b'' if self.title is None or self.title is False else (self.serialize_bytes(self.title)),
            b'' if self.performer is None or self.performer is False else (self.serialize_bytes(self.performer)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _small = bool(flags & 4)
        if flags & 1:
            _document = reader.tgread_object()
        else:
            _document = None
        if flags & 2:
            _title = reader.tgread_string()
        else:
            _title = None
        if flags & 2:
            _performer = reader.tgread_string()
        else:
            _performer = None
        return cls(small=_small, document=_document, title=_title, performer=_performer)


class InputWebFileGeoPointLocation(TLObject):
    CONSTRUCTOR_ID = 0x9f2221c9
    SUBCLASS_OF_ID = 0xf72ed8d9

    def __init__(self, geo_point: 'TypeInputGeoPoint', access_hash: int, w: int, h: int, zoom: int, scale: int):
        """
        Constructor for InputWebFileLocation: Instance of either InputWebFileLocation, InputWebFileGeoPointLocation, InputWebFileAudioAlbumThumbLocation.
        """
        self.geo_point = geo_point
        self.access_hash = access_hash
        self.w = w
        self.h = h
        self.zoom = zoom
        self.scale = scale

    def to_dict(self):
        return {
            '_': 'InputWebFileGeoPointLocation',
            'geo_point': self.geo_point.to_dict() if isinstance(self.geo_point, TLObject) else self.geo_point,
            'access_hash': self.access_hash,
            'w': self.w,
            'h': self.h,
            'zoom': self.zoom,
            'scale': self.scale
        }

    def _bytes(self):
        return b''.join((
            b'\xc9!"\x9f',
            self.geo_point._bytes(),
            struct.pack('<q', self.access_hash),
            struct.pack('<i', self.w),
            struct.pack('<i', self.h),
            struct.pack('<i', self.zoom),
            struct.pack('<i', self.scale),
        ))

    @classmethod
    def from_reader(cls, reader):
        _geo_point = reader.tgread_object()
        _access_hash = reader.read_long()
        _w = reader.read_int()
        _h = reader.read_int()
        _zoom = reader.read_int()
        _scale = reader.read_int()
        return cls(geo_point=_geo_point, access_hash=_access_hash, w=_w, h=_h, zoom=_zoom, scale=_scale)


class InputWebFileLocation(TLObject):
    CONSTRUCTOR_ID = 0xc239d686
    SUBCLASS_OF_ID = 0xf72ed8d9

    def __init__(self, url: str, access_hash: int):
        """
        Constructor for InputWebFileLocation: Instance of either InputWebFileLocation, InputWebFileGeoPointLocation, InputWebFileAudioAlbumThumbLocation.
        """
        self.url = url
        self.access_hash = access_hash

    def to_dict(self):
        return {
            '_': 'InputWebFileLocation',
            'url': self.url,
            'access_hash': self.access_hash
        }

    def _bytes(self):
        return b''.join((
            b'\x86\xd69\xc2',
            self.serialize_bytes(self.url),
            struct.pack('<q', self.access_hash),
        ))

    @classmethod
    def from_reader(cls, reader):
        _url = reader.tgread_string()
        _access_hash = reader.read_long()
        return cls(url=_url, access_hash=_access_hash)


class Invoice(TLObject):
    CONSTRUCTOR_ID = 0x5db95a15
    SUBCLASS_OF_ID = 0x5fd82ed8

    def __init__(self, currency: str, prices: List['TypeLabeledPrice'], test: Optional[bool]=None, name_requested: Optional[bool]=None, phone_requested: Optional[bool]=None, email_requested: Optional[bool]=None, shipping_address_requested: Optional[bool]=None, flexible: Optional[bool]=None, phone_to_provider: Optional[bool]=None, email_to_provider: Optional[bool]=None, recurring: Optional[bool]=None, max_tip_amount: Optional[int]=None, suggested_tip_amounts: Optional[List[int]]=None, terms_url: Optional[str]=None):
        """
        Constructor for Invoice: Instance of Invoice.
        """
        self.currency = currency
        self.prices = prices
        self.test = test
        self.name_requested = name_requested
        self.phone_requested = phone_requested
        self.email_requested = email_requested
        self.shipping_address_requested = shipping_address_requested
        self.flexible = flexible
        self.phone_to_provider = phone_to_provider
        self.email_to_provider = email_to_provider
        self.recurring = recurring
        self.max_tip_amount = max_tip_amount
        self.suggested_tip_amounts = suggested_tip_amounts
        self.terms_url = terms_url

    def to_dict(self):
        return {
            '_': 'Invoice',
            'currency': self.currency,
            'prices': [] if self.prices is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.prices],
            'test': self.test,
            'name_requested': self.name_requested,
            'phone_requested': self.phone_requested,
            'email_requested': self.email_requested,
            'shipping_address_requested': self.shipping_address_requested,
            'flexible': self.flexible,
            'phone_to_provider': self.phone_to_provider,
            'email_to_provider': self.email_to_provider,
            'recurring': self.recurring,
            'max_tip_amount': self.max_tip_amount,
            'suggested_tip_amounts': [] if self.suggested_tip_amounts is None else self.suggested_tip_amounts[:],
            'terms_url': self.terms_url
        }

    def _bytes(self):
        assert ((self.max_tip_amount or self.max_tip_amount is not None) and (self.suggested_tip_amounts or self.suggested_tip_amounts is not None)) or ((self.max_tip_amount is None or self.max_tip_amount is False) and (self.suggested_tip_amounts is None or self.suggested_tip_amounts is False)), 'max_tip_amount, suggested_tip_amounts parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'\x15Z\xb9]',
            struct.pack('<I', (0 if self.test is None or self.test is False else 1) | (0 if self.name_requested is None or self.name_requested is False else 2) | (0 if self.phone_requested is None or self.phone_requested is False else 4) | (0 if self.email_requested is None or self.email_requested is False else 8) | (0 if self.shipping_address_requested is None or self.shipping_address_requested is False else 16) | (0 if self.flexible is None or self.flexible is False else 32) | (0 if self.phone_to_provider is None or self.phone_to_provider is False else 64) | (0 if self.email_to_provider is None or self.email_to_provider is False else 128) | (0 if self.recurring is None or self.recurring is False else 512) | (0 if self.max_tip_amount is None or self.max_tip_amount is False else 256) | (0 if self.suggested_tip_amounts is None or self.suggested_tip_amounts is False else 256) | (0 if self.terms_url is None or self.terms_url is False else 1024)),
            self.serialize_bytes(self.currency),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.prices)),b''.join(x._bytes() for x in self.prices),
            b'' if self.max_tip_amount is None or self.max_tip_amount is False else (struct.pack('<q', self.max_tip_amount)),
            b'' if self.suggested_tip_amounts is None or self.suggested_tip_amounts is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.suggested_tip_amounts)),b''.join(struct.pack('<q', x) for x in self.suggested_tip_amounts))),
            b'' if self.terms_url is None or self.terms_url is False else (self.serialize_bytes(self.terms_url)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _test = bool(flags & 1)
        _name_requested = bool(flags & 2)
        _phone_requested = bool(flags & 4)
        _email_requested = bool(flags & 8)
        _shipping_address_requested = bool(flags & 16)
        _flexible = bool(flags & 32)
        _phone_to_provider = bool(flags & 64)
        _email_to_provider = bool(flags & 128)
        _recurring = bool(flags & 512)
        _currency = reader.tgread_string()
        reader.read_int()
        _prices = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _prices.append(_x)

        if flags & 256:
            _max_tip_amount = reader.read_long()
        else:
            _max_tip_amount = None
        if flags & 256:
            reader.read_int()
            _suggested_tip_amounts = []
            for _ in range(reader.read_int()):
                _x = reader.read_long()
                _suggested_tip_amounts.append(_x)

        else:
            _suggested_tip_amounts = None
        if flags & 1024:
            _terms_url = reader.tgread_string()
        else:
            _terms_url = None
        return cls(currency=_currency, prices=_prices, test=_test, name_requested=_name_requested, phone_requested=_phone_requested, email_requested=_email_requested, shipping_address_requested=_shipping_address_requested, flexible=_flexible, phone_to_provider=_phone_to_provider, email_to_provider=_email_to_provider, recurring=_recurring, max_tip_amount=_max_tip_amount, suggested_tip_amounts=_suggested_tip_amounts, terms_url=_terms_url)


class IpPort(TLObject):
    CONSTRUCTOR_ID = 0xd433ad73
    SUBCLASS_OF_ID = 0xa2a03726

    def __init__(self, ipv4: int, port: int):
        """
        Constructor for IpPort: Instance of either IpPort, IpPortSecret.
        """
        self.ipv4 = ipv4
        self.port = port

    def to_dict(self):
        return {
            '_': 'IpPort',
            'ipv4': self.ipv4,
            'port': self.port
        }

    def _bytes(self):
        return b''.join((
            b's\xad3\xd4',
            struct.pack('<i', self.ipv4),
            struct.pack('<i', self.port),
        ))

    @classmethod
    def from_reader(cls, reader):
        _ipv4 = reader.read_int()
        _port = reader.read_int()
        return cls(ipv4=_ipv4, port=_port)


class IpPortSecret(TLObject):
    CONSTRUCTOR_ID = 0x37982646
    SUBCLASS_OF_ID = 0xa2a03726

    def __init__(self, ipv4: int, port: int, secret: bytes):
        """
        Constructor for IpPort: Instance of either IpPort, IpPortSecret.
        """
        self.ipv4 = ipv4
        self.port = port
        self.secret = secret

    def to_dict(self):
        return {
            '_': 'IpPortSecret',
            'ipv4': self.ipv4,
            'port': self.port,
            'secret': self.secret
        }

    def _bytes(self):
        return b''.join((
            b'F&\x987',
            struct.pack('<i', self.ipv4),
            struct.pack('<i', self.port),
            self.serialize_bytes(self.secret),
        ))

    @classmethod
    def from_reader(cls, reader):
        _ipv4 = reader.read_int()
        _port = reader.read_int()
        _secret = reader.tgread_bytes()
        return cls(ipv4=_ipv4, port=_port, secret=_secret)


class JsonArray(TLObject):
    CONSTRUCTOR_ID = 0xf7444763
    SUBCLASS_OF_ID = 0xeb9987b3

    def __init__(self, value: List['TypeJSONValue']):
        """
        Constructor for JSONValue: Instance of either JsonNull, JsonBool, JsonNumber, JsonString, JsonArray, JsonObject.
        """
        self.value = value

    def to_dict(self):
        return {
            '_': 'JsonArray',
            'value': [] if self.value is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.value]
        }

    def _bytes(self):
        return b''.join((
            b'cGD\xf7',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.value)),b''.join(x._bytes() for x in self.value),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _value = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _value.append(_x)

        return cls(value=_value)


class JsonBool(TLObject):
    CONSTRUCTOR_ID = 0xc7345e6a
    SUBCLASS_OF_ID = 0xeb9987b3

    def __init__(self, value: bool):
        """
        Constructor for JSONValue: Instance of either JsonNull, JsonBool, JsonNumber, JsonString, JsonArray, JsonObject.
        """
        self.value = value

    def to_dict(self):
        return {
            '_': 'JsonBool',
            'value': self.value
        }

    def _bytes(self):
        return b''.join((
            b'j^4\xc7',
            b'\xb5ur\x99' if self.value else b'7\x97y\xbc',
        ))

    @classmethod
    def from_reader(cls, reader):
        _value = reader.tgread_bool()
        return cls(value=_value)


class JsonNull(TLObject):
    CONSTRUCTOR_ID = 0x3f6d7b68
    SUBCLASS_OF_ID = 0xeb9987b3

    def to_dict(self):
        return {
            '_': 'JsonNull'
        }

    def _bytes(self):
        return b''.join((
            b'h{m?',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class JsonNumber(TLObject):
    CONSTRUCTOR_ID = 0x2be0dfa4
    SUBCLASS_OF_ID = 0xeb9987b3

    def __init__(self, value: float):
        """
        Constructor for JSONValue: Instance of either JsonNull, JsonBool, JsonNumber, JsonString, JsonArray, JsonObject.
        """
        self.value = value

    def to_dict(self):
        return {
            '_': 'JsonNumber',
            'value': self.value
        }

    def _bytes(self):
        return b''.join((
            b'\xa4\xdf\xe0+',
            struct.pack('<d', self.value),
        ))

    @classmethod
    def from_reader(cls, reader):
        _value = reader.read_double()
        return cls(value=_value)


class JsonObject(TLObject):
    CONSTRUCTOR_ID = 0x99c1d49d
    SUBCLASS_OF_ID = 0xeb9987b3

    def __init__(self, value: List['TypeJSONObjectValue']):
        """
        Constructor for JSONValue: Instance of either JsonNull, JsonBool, JsonNumber, JsonString, JsonArray, JsonObject.
        """
        self.value = value

    def to_dict(self):
        return {
            '_': 'JsonObject',
            'value': [] if self.value is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.value]
        }

    def _bytes(self):
        return b''.join((
            b'\x9d\xd4\xc1\x99',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.value)),b''.join(x._bytes() for x in self.value),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _value = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _value.append(_x)

        return cls(value=_value)


class JsonObjectValue(TLObject):
    CONSTRUCTOR_ID = 0xc0de1bd9
    SUBCLASS_OF_ID = 0x937fceb9

    def __init__(self, key: str, value: 'TypeJSONValue'):
        """
        Constructor for JSONObjectValue: Instance of JsonObjectValue.
        """
        self.key = key
        self.value = value

    def to_dict(self):
        return {
            '_': 'JsonObjectValue',
            'key': self.key,
            'value': self.value.to_dict() if isinstance(self.value, TLObject) else self.value
        }

    def _bytes(self):
        return b''.join((
            b'\xd9\x1b\xde\xc0',
            self.serialize_bytes(self.key),
            self.value._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _key = reader.tgread_string()
        _value = reader.tgread_object()
        return cls(key=_key, value=_value)


class JsonString(TLObject):
    CONSTRUCTOR_ID = 0xb71e767a
    SUBCLASS_OF_ID = 0xeb9987b3

    def __init__(self, value: str):
        """
        Constructor for JSONValue: Instance of either JsonNull, JsonBool, JsonNumber, JsonString, JsonArray, JsonObject.
        """
        self.value = value

    def to_dict(self):
        return {
            '_': 'JsonString',
            'value': self.value
        }

    def _bytes(self):
        return b''.join((
            b'zv\x1e\xb7',
            self.serialize_bytes(self.value),
        ))

    @classmethod
    def from_reader(cls, reader):
        _value = reader.tgread_string()
        return cls(value=_value)


class KeyboardButton(TLObject):
    CONSTRUCTOR_ID = 0xa2fa4880
    SUBCLASS_OF_ID = 0xbad74a3

    def __init__(self, text: str):
        """
        Constructor for KeyboardButton: Instance of either KeyboardButton, KeyboardButtonUrl, KeyboardButtonCallback, KeyboardButtonRequestPhone, KeyboardButtonRequestGeoLocation, KeyboardButtonSwitchInline, KeyboardButtonGame, KeyboardButtonBuy, KeyboardButtonUrlAuth, InputKeyboardButtonUrlAuth, KeyboardButtonRequestPoll, InputKeyboardButtonUserProfile, KeyboardButtonUserProfile, KeyboardButtonWebView, KeyboardButtonSimpleWebView, KeyboardButtonRequestPeer.
        """
        self.text = text

    def to_dict(self):
        return {
            '_': 'KeyboardButton',
            'text': self.text
        }

    def _bytes(self):
        return b''.join((
            b'\x80H\xfa\xa2',
            self.serialize_bytes(self.text),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_string()
        return cls(text=_text)


class KeyboardButtonBuy(TLObject):
    CONSTRUCTOR_ID = 0xafd93fbb
    SUBCLASS_OF_ID = 0xbad74a3

    def __init__(self, text: str):
        """
        Constructor for KeyboardButton: Instance of either KeyboardButton, KeyboardButtonUrl, KeyboardButtonCallback, KeyboardButtonRequestPhone, KeyboardButtonRequestGeoLocation, KeyboardButtonSwitchInline, KeyboardButtonGame, KeyboardButtonBuy, KeyboardButtonUrlAuth, InputKeyboardButtonUrlAuth, KeyboardButtonRequestPoll, InputKeyboardButtonUserProfile, KeyboardButtonUserProfile, KeyboardButtonWebView, KeyboardButtonSimpleWebView, KeyboardButtonRequestPeer.
        """
        self.text = text

    def to_dict(self):
        return {
            '_': 'KeyboardButtonBuy',
            'text': self.text
        }

    def _bytes(self):
        return b''.join((
            b'\xbb?\xd9\xaf',
            self.serialize_bytes(self.text),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_string()
        return cls(text=_text)


class KeyboardButtonCallback(TLObject):
    CONSTRUCTOR_ID = 0x35bbdb6b
    SUBCLASS_OF_ID = 0xbad74a3

    def __init__(self, text: str, data: bytes, requires_password: Optional[bool]=None):
        """
        Constructor for KeyboardButton: Instance of either KeyboardButton, KeyboardButtonUrl, KeyboardButtonCallback, KeyboardButtonRequestPhone, KeyboardButtonRequestGeoLocation, KeyboardButtonSwitchInline, KeyboardButtonGame, KeyboardButtonBuy, KeyboardButtonUrlAuth, InputKeyboardButtonUrlAuth, KeyboardButtonRequestPoll, InputKeyboardButtonUserProfile, KeyboardButtonUserProfile, KeyboardButtonWebView, KeyboardButtonSimpleWebView, KeyboardButtonRequestPeer.
        """
        self.text = text
        self.data = data
        self.requires_password = requires_password

    def to_dict(self):
        return {
            '_': 'KeyboardButtonCallback',
            'text': self.text,
            'data': self.data,
            'requires_password': self.requires_password
        }

    def _bytes(self):
        return b''.join((
            b'k\xdb\xbb5',
            struct.pack('<I', (0 if self.requires_password is None or self.requires_password is False else 1)),
            self.serialize_bytes(self.text),
            self.serialize_bytes(self.data),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _requires_password = bool(flags & 1)
        _text = reader.tgread_string()
        _data = reader.tgread_bytes()
        return cls(text=_text, data=_data, requires_password=_requires_password)


class KeyboardButtonGame(TLObject):
    CONSTRUCTOR_ID = 0x50f41ccf
    SUBCLASS_OF_ID = 0xbad74a3

    def __init__(self, text: str):
        """
        Constructor for KeyboardButton: Instance of either KeyboardButton, KeyboardButtonUrl, KeyboardButtonCallback, KeyboardButtonRequestPhone, KeyboardButtonRequestGeoLocation, KeyboardButtonSwitchInline, KeyboardButtonGame, KeyboardButtonBuy, KeyboardButtonUrlAuth, InputKeyboardButtonUrlAuth, KeyboardButtonRequestPoll, InputKeyboardButtonUserProfile, KeyboardButtonUserProfile, KeyboardButtonWebView, KeyboardButtonSimpleWebView, KeyboardButtonRequestPeer.
        """
        self.text = text

    def to_dict(self):
        return {
            '_': 'KeyboardButtonGame',
            'text': self.text
        }

    def _bytes(self):
        return b''.join((
            b'\xcf\x1c\xf4P',
            self.serialize_bytes(self.text),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_string()
        return cls(text=_text)


class KeyboardButtonRequestGeoLocation(TLObject):
    CONSTRUCTOR_ID = 0xfc796b3f
    SUBCLASS_OF_ID = 0xbad74a3

    def __init__(self, text: str):
        """
        Constructor for KeyboardButton: Instance of either KeyboardButton, KeyboardButtonUrl, KeyboardButtonCallback, KeyboardButtonRequestPhone, KeyboardButtonRequestGeoLocation, KeyboardButtonSwitchInline, KeyboardButtonGame, KeyboardButtonBuy, KeyboardButtonUrlAuth, InputKeyboardButtonUrlAuth, KeyboardButtonRequestPoll, InputKeyboardButtonUserProfile, KeyboardButtonUserProfile, KeyboardButtonWebView, KeyboardButtonSimpleWebView, KeyboardButtonRequestPeer.
        """
        self.text = text

    def to_dict(self):
        return {
            '_': 'KeyboardButtonRequestGeoLocation',
            'text': self.text
        }

    def _bytes(self):
        return b''.join((
            b'?ky\xfc',
            self.serialize_bytes(self.text),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_string()
        return cls(text=_text)


class KeyboardButtonRequestPeer(TLObject):
    CONSTRUCTOR_ID = 0xd0b468c
    SUBCLASS_OF_ID = 0xbad74a3

    def __init__(self, text: str, button_id: int, peer_type: 'TypeRequestPeerType'):
        """
        Constructor for KeyboardButton: Instance of either KeyboardButton, KeyboardButtonUrl, KeyboardButtonCallback, KeyboardButtonRequestPhone, KeyboardButtonRequestGeoLocation, KeyboardButtonSwitchInline, KeyboardButtonGame, KeyboardButtonBuy, KeyboardButtonUrlAuth, InputKeyboardButtonUrlAuth, KeyboardButtonRequestPoll, InputKeyboardButtonUserProfile, KeyboardButtonUserProfile, KeyboardButtonWebView, KeyboardButtonSimpleWebView, KeyboardButtonRequestPeer.
        """
        self.text = text
        self.button_id = button_id
        self.peer_type = peer_type

    def to_dict(self):
        return {
            '_': 'KeyboardButtonRequestPeer',
            'text': self.text,
            'button_id': self.button_id,
            'peer_type': self.peer_type.to_dict() if isinstance(self.peer_type, TLObject) else self.peer_type
        }

    def _bytes(self):
        return b''.join((
            b'\x8cF\x0b\r',
            self.serialize_bytes(self.text),
            struct.pack('<i', self.button_id),
            self.peer_type._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_string()
        _button_id = reader.read_int()
        _peer_type = reader.tgread_object()
        return cls(text=_text, button_id=_button_id, peer_type=_peer_type)


class KeyboardButtonRequestPhone(TLObject):
    CONSTRUCTOR_ID = 0xb16a6c29
    SUBCLASS_OF_ID = 0xbad74a3

    def __init__(self, text: str):
        """
        Constructor for KeyboardButton: Instance of either KeyboardButton, KeyboardButtonUrl, KeyboardButtonCallback, KeyboardButtonRequestPhone, KeyboardButtonRequestGeoLocation, KeyboardButtonSwitchInline, KeyboardButtonGame, KeyboardButtonBuy, KeyboardButtonUrlAuth, InputKeyboardButtonUrlAuth, KeyboardButtonRequestPoll, InputKeyboardButtonUserProfile, KeyboardButtonUserProfile, KeyboardButtonWebView, KeyboardButtonSimpleWebView, KeyboardButtonRequestPeer.
        """
        self.text = text

    def to_dict(self):
        return {
            '_': 'KeyboardButtonRequestPhone',
            'text': self.text
        }

    def _bytes(self):
        return b''.join((
            b')lj\xb1',
            self.serialize_bytes(self.text),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_string()
        return cls(text=_text)


class KeyboardButtonRequestPoll(TLObject):
    CONSTRUCTOR_ID = 0xbbc7515d
    SUBCLASS_OF_ID = 0xbad74a3

    def __init__(self, text: str, quiz: Optional[bool]=None):
        """
        Constructor for KeyboardButton: Instance of either KeyboardButton, KeyboardButtonUrl, KeyboardButtonCallback, KeyboardButtonRequestPhone, KeyboardButtonRequestGeoLocation, KeyboardButtonSwitchInline, KeyboardButtonGame, KeyboardButtonBuy, KeyboardButtonUrlAuth, InputKeyboardButtonUrlAuth, KeyboardButtonRequestPoll, InputKeyboardButtonUserProfile, KeyboardButtonUserProfile, KeyboardButtonWebView, KeyboardButtonSimpleWebView, KeyboardButtonRequestPeer.
        """
        self.text = text
        self.quiz = quiz

    def to_dict(self):
        return {
            '_': 'KeyboardButtonRequestPoll',
            'text': self.text,
            'quiz': self.quiz
        }

    def _bytes(self):
        return b''.join((
            b']Q\xc7\xbb',
            struct.pack('<I', (0 if self.quiz is None else 1)),
            b'' if self.quiz is None else (b'\xb5ur\x99' if self.quiz else b'7\x97y\xbc'),
            self.serialize_bytes(self.text),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 1:
            _quiz = reader.tgread_bool()
        else:
            _quiz = None
        _text = reader.tgread_string()
        return cls(text=_text, quiz=_quiz)


class KeyboardButtonRow(TLObject):
    CONSTRUCTOR_ID = 0x77608b83
    SUBCLASS_OF_ID = 0x847730ae

    def __init__(self, buttons: List['TypeKeyboardButton']):
        """
        Constructor for KeyboardButtonRow: Instance of KeyboardButtonRow.
        """
        self.buttons = buttons

    def to_dict(self):
        return {
            '_': 'KeyboardButtonRow',
            'buttons': [] if self.buttons is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.buttons]
        }

    def _bytes(self):
        return b''.join((
            b'\x83\x8b`w',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.buttons)),b''.join(x._bytes() for x in self.buttons),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _buttons = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _buttons.append(_x)

        return cls(buttons=_buttons)


class KeyboardButtonSimpleWebView(TLObject):
    CONSTRUCTOR_ID = 0xa0c0505c
    SUBCLASS_OF_ID = 0xbad74a3

    def __init__(self, text: str, url: str):
        """
        Constructor for KeyboardButton: Instance of either KeyboardButton, KeyboardButtonUrl, KeyboardButtonCallback, KeyboardButtonRequestPhone, KeyboardButtonRequestGeoLocation, KeyboardButtonSwitchInline, KeyboardButtonGame, KeyboardButtonBuy, KeyboardButtonUrlAuth, InputKeyboardButtonUrlAuth, KeyboardButtonRequestPoll, InputKeyboardButtonUserProfile, KeyboardButtonUserProfile, KeyboardButtonWebView, KeyboardButtonSimpleWebView, KeyboardButtonRequestPeer.
        """
        self.text = text
        self.url = url

    def to_dict(self):
        return {
            '_': 'KeyboardButtonSimpleWebView',
            'text': self.text,
            'url': self.url
        }

    def _bytes(self):
        return b''.join((
            b'\\P\xc0\xa0',
            self.serialize_bytes(self.text),
            self.serialize_bytes(self.url),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_string()
        _url = reader.tgread_string()
        return cls(text=_text, url=_url)


class KeyboardButtonSwitchInline(TLObject):
    CONSTRUCTOR_ID = 0x93b9fbb5
    SUBCLASS_OF_ID = 0xbad74a3

    def __init__(self, text: str, query: str, same_peer: Optional[bool]=None, peer_types: Optional[List['TypeInlineQueryPeerType']]=None):
        """
        Constructor for KeyboardButton: Instance of either KeyboardButton, KeyboardButtonUrl, KeyboardButtonCallback, KeyboardButtonRequestPhone, KeyboardButtonRequestGeoLocation, KeyboardButtonSwitchInline, KeyboardButtonGame, KeyboardButtonBuy, KeyboardButtonUrlAuth, InputKeyboardButtonUrlAuth, KeyboardButtonRequestPoll, InputKeyboardButtonUserProfile, KeyboardButtonUserProfile, KeyboardButtonWebView, KeyboardButtonSimpleWebView, KeyboardButtonRequestPeer.
        """
        self.text = text
        self.query = query
        self.same_peer = same_peer
        self.peer_types = peer_types

    def to_dict(self):
        return {
            '_': 'KeyboardButtonSwitchInline',
            'text': self.text,
            'query': self.query,
            'same_peer': self.same_peer,
            'peer_types': [] if self.peer_types is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.peer_types]
        }

    def _bytes(self):
        return b''.join((
            b'\xb5\xfb\xb9\x93',
            struct.pack('<I', (0 if self.same_peer is None or self.same_peer is False else 1) | (0 if self.peer_types is None or self.peer_types is False else 2)),
            self.serialize_bytes(self.text),
            self.serialize_bytes(self.query),
            b'' if self.peer_types is None or self.peer_types is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.peer_types)),b''.join(x._bytes() for x in self.peer_types))),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _same_peer = bool(flags & 1)
        _text = reader.tgread_string()
        _query = reader.tgread_string()
        if flags & 2:
            reader.read_int()
            _peer_types = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _peer_types.append(_x)

        else:
            _peer_types = None
        return cls(text=_text, query=_query, same_peer=_same_peer, peer_types=_peer_types)


class KeyboardButtonUrl(TLObject):
    CONSTRUCTOR_ID = 0x258aff05
    SUBCLASS_OF_ID = 0xbad74a3

    def __init__(self, text: str, url: str):
        """
        Constructor for KeyboardButton: Instance of either KeyboardButton, KeyboardButtonUrl, KeyboardButtonCallback, KeyboardButtonRequestPhone, KeyboardButtonRequestGeoLocation, KeyboardButtonSwitchInline, KeyboardButtonGame, KeyboardButtonBuy, KeyboardButtonUrlAuth, InputKeyboardButtonUrlAuth, KeyboardButtonRequestPoll, InputKeyboardButtonUserProfile, KeyboardButtonUserProfile, KeyboardButtonWebView, KeyboardButtonSimpleWebView, KeyboardButtonRequestPeer.
        """
        self.text = text
        self.url = url

    def to_dict(self):
        return {
            '_': 'KeyboardButtonUrl',
            'text': self.text,
            'url': self.url
        }

    def _bytes(self):
        return b''.join((
            b'\x05\xff\x8a%',
            self.serialize_bytes(self.text),
            self.serialize_bytes(self.url),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_string()
        _url = reader.tgread_string()
        return cls(text=_text, url=_url)


class KeyboardButtonUrlAuth(TLObject):
    CONSTRUCTOR_ID = 0x10b78d29
    SUBCLASS_OF_ID = 0xbad74a3

    def __init__(self, text: str, url: str, button_id: int, fwd_text: Optional[str]=None):
        """
        Constructor for KeyboardButton: Instance of either KeyboardButton, KeyboardButtonUrl, KeyboardButtonCallback, KeyboardButtonRequestPhone, KeyboardButtonRequestGeoLocation, KeyboardButtonSwitchInline, KeyboardButtonGame, KeyboardButtonBuy, KeyboardButtonUrlAuth, InputKeyboardButtonUrlAuth, KeyboardButtonRequestPoll, InputKeyboardButtonUserProfile, KeyboardButtonUserProfile, KeyboardButtonWebView, KeyboardButtonSimpleWebView, KeyboardButtonRequestPeer.
        """
        self.text = text
        self.url = url
        self.button_id = button_id
        self.fwd_text = fwd_text

    def to_dict(self):
        return {
            '_': 'KeyboardButtonUrlAuth',
            'text': self.text,
            'url': self.url,
            'button_id': self.button_id,
            'fwd_text': self.fwd_text
        }

    def _bytes(self):
        return b''.join((
            b')\x8d\xb7\x10',
            struct.pack('<I', (0 if self.fwd_text is None or self.fwd_text is False else 1)),
            self.serialize_bytes(self.text),
            b'' if self.fwd_text is None or self.fwd_text is False else (self.serialize_bytes(self.fwd_text)),
            self.serialize_bytes(self.url),
            struct.pack('<i', self.button_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _text = reader.tgread_string()
        if flags & 1:
            _fwd_text = reader.tgread_string()
        else:
            _fwd_text = None
        _url = reader.tgread_string()
        _button_id = reader.read_int()
        return cls(text=_text, url=_url, button_id=_button_id, fwd_text=_fwd_text)


class KeyboardButtonUserProfile(TLObject):
    CONSTRUCTOR_ID = 0x308660c1
    SUBCLASS_OF_ID = 0xbad74a3

    def __init__(self, text: str, user_id: int):
        """
        Constructor for KeyboardButton: Instance of either KeyboardButton, KeyboardButtonUrl, KeyboardButtonCallback, KeyboardButtonRequestPhone, KeyboardButtonRequestGeoLocation, KeyboardButtonSwitchInline, KeyboardButtonGame, KeyboardButtonBuy, KeyboardButtonUrlAuth, InputKeyboardButtonUrlAuth, KeyboardButtonRequestPoll, InputKeyboardButtonUserProfile, KeyboardButtonUserProfile, KeyboardButtonWebView, KeyboardButtonSimpleWebView, KeyboardButtonRequestPeer.
        """
        self.text = text
        self.user_id = user_id

    def to_dict(self):
        return {
            '_': 'KeyboardButtonUserProfile',
            'text': self.text,
            'user_id': self.user_id
        }

    def _bytes(self):
        return b''.join((
            b'\xc1`\x860',
            self.serialize_bytes(self.text),
            struct.pack('<q', self.user_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_string()
        _user_id = reader.read_long()
        return cls(text=_text, user_id=_user_id)


class KeyboardButtonWebView(TLObject):
    CONSTRUCTOR_ID = 0x13767230
    SUBCLASS_OF_ID = 0xbad74a3

    def __init__(self, text: str, url: str):
        """
        Constructor for KeyboardButton: Instance of either KeyboardButton, KeyboardButtonUrl, KeyboardButtonCallback, KeyboardButtonRequestPhone, KeyboardButtonRequestGeoLocation, KeyboardButtonSwitchInline, KeyboardButtonGame, KeyboardButtonBuy, KeyboardButtonUrlAuth, InputKeyboardButtonUrlAuth, KeyboardButtonRequestPoll, InputKeyboardButtonUserProfile, KeyboardButtonUserProfile, KeyboardButtonWebView, KeyboardButtonSimpleWebView, KeyboardButtonRequestPeer.
        """
        self.text = text
        self.url = url

    def to_dict(self):
        return {
            '_': 'KeyboardButtonWebView',
            'text': self.text,
            'url': self.url
        }

    def _bytes(self):
        return b''.join((
            b'0rv\x13',
            self.serialize_bytes(self.text),
            self.serialize_bytes(self.url),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_string()
        _url = reader.tgread_string()
        return cls(text=_text, url=_url)


class LabeledPrice(TLObject):
    CONSTRUCTOR_ID = 0xcb296bf8
    SUBCLASS_OF_ID = 0x1c84047a

    def __init__(self, label: str, amount: int):
        """
        Constructor for LabeledPrice: Instance of LabeledPrice.
        """
        self.label = label
        self.amount = amount

    def to_dict(self):
        return {
            '_': 'LabeledPrice',
            'label': self.label,
            'amount': self.amount
        }

    def _bytes(self):
        return b''.join((
            b'\xf8k)\xcb',
            self.serialize_bytes(self.label),
            struct.pack('<q', self.amount),
        ))

    @classmethod
    def from_reader(cls, reader):
        _label = reader.tgread_string()
        _amount = reader.read_long()
        return cls(label=_label, amount=_amount)


class LangPackDifference(TLObject):
    CONSTRUCTOR_ID = 0xf385c1f6
    SUBCLASS_OF_ID = 0x52662d55

    def __init__(self, lang_code: str, from_version: int, version: int, strings: List['TypeLangPackString']):
        """
        Constructor for LangPackDifference: Instance of LangPackDifference.
        """
        self.lang_code = lang_code
        self.from_version = from_version
        self.version = version
        self.strings = strings

    def to_dict(self):
        return {
            '_': 'LangPackDifference',
            'lang_code': self.lang_code,
            'from_version': self.from_version,
            'version': self.version,
            'strings': [] if self.strings is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.strings]
        }

    def _bytes(self):
        return b''.join((
            b'\xf6\xc1\x85\xf3',
            self.serialize_bytes(self.lang_code),
            struct.pack('<i', self.from_version),
            struct.pack('<i', self.version),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.strings)),b''.join(x._bytes() for x in self.strings),
        ))

    @classmethod
    def from_reader(cls, reader):
        _lang_code = reader.tgread_string()
        _from_version = reader.read_int()
        _version = reader.read_int()
        reader.read_int()
        _strings = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _strings.append(_x)

        return cls(lang_code=_lang_code, from_version=_from_version, version=_version, strings=_strings)


class LangPackLanguage(TLObject):
    CONSTRUCTOR_ID = 0xeeca5ce3
    SUBCLASS_OF_ID = 0xabac89b7

    def __init__(self, name: str, native_name: str, lang_code: str, plural_code: str, strings_count: int, translated_count: int, translations_url: str, official: Optional[bool]=None, rtl: Optional[bool]=None, beta: Optional[bool]=None, base_lang_code: Optional[str]=None):
        """
        Constructor for LangPackLanguage: Instance of LangPackLanguage.
        """
        self.name = name
        self.native_name = native_name
        self.lang_code = lang_code
        self.plural_code = plural_code
        self.strings_count = strings_count
        self.translated_count = translated_count
        self.translations_url = translations_url
        self.official = official
        self.rtl = rtl
        self.beta = beta
        self.base_lang_code = base_lang_code

    def to_dict(self):
        return {
            '_': 'LangPackLanguage',
            'name': self.name,
            'native_name': self.native_name,
            'lang_code': self.lang_code,
            'plural_code': self.plural_code,
            'strings_count': self.strings_count,
            'translated_count': self.translated_count,
            'translations_url': self.translations_url,
            'official': self.official,
            'rtl': self.rtl,
            'beta': self.beta,
            'base_lang_code': self.base_lang_code
        }

    def _bytes(self):
        return b''.join((
            b'\xe3\\\xca\xee',
            struct.pack('<I', (0 if self.official is None or self.official is False else 1) | (0 if self.rtl is None or self.rtl is False else 4) | (0 if self.beta is None or self.beta is False else 8) | (0 if self.base_lang_code is None or self.base_lang_code is False else 2)),
            self.serialize_bytes(self.name),
            self.serialize_bytes(self.native_name),
            self.serialize_bytes(self.lang_code),
            b'' if self.base_lang_code is None or self.base_lang_code is False else (self.serialize_bytes(self.base_lang_code)),
            self.serialize_bytes(self.plural_code),
            struct.pack('<i', self.strings_count),
            struct.pack('<i', self.translated_count),
            self.serialize_bytes(self.translations_url),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _official = bool(flags & 1)
        _rtl = bool(flags & 4)
        _beta = bool(flags & 8)
        _name = reader.tgread_string()
        _native_name = reader.tgread_string()
        _lang_code = reader.tgread_string()
        if flags & 2:
            _base_lang_code = reader.tgread_string()
        else:
            _base_lang_code = None
        _plural_code = reader.tgread_string()
        _strings_count = reader.read_int()
        _translated_count = reader.read_int()
        _translations_url = reader.tgread_string()
        return cls(name=_name, native_name=_native_name, lang_code=_lang_code, plural_code=_plural_code, strings_count=_strings_count, translated_count=_translated_count, translations_url=_translations_url, official=_official, rtl=_rtl, beta=_beta, base_lang_code=_base_lang_code)


class LangPackString(TLObject):
    CONSTRUCTOR_ID = 0xcad181f6
    SUBCLASS_OF_ID = 0xdc179ab9

    def __init__(self, key: str, value: str):
        """
        Constructor for LangPackString: Instance of either LangPackString, LangPackStringPluralized, LangPackStringDeleted.
        """
        self.key = key
        self.value = value

    def to_dict(self):
        return {
            '_': 'LangPackString',
            'key': self.key,
            'value': self.value
        }

    def _bytes(self):
        return b''.join((
            b'\xf6\x81\xd1\xca',
            self.serialize_bytes(self.key),
            self.serialize_bytes(self.value),
        ))

    @classmethod
    def from_reader(cls, reader):
        _key = reader.tgread_string()
        _value = reader.tgread_string()
        return cls(key=_key, value=_value)


class LangPackStringDeleted(TLObject):
    CONSTRUCTOR_ID = 0x2979eeb2
    SUBCLASS_OF_ID = 0xdc179ab9

    def __init__(self, key: str):
        """
        Constructor for LangPackString: Instance of either LangPackString, LangPackStringPluralized, LangPackStringDeleted.
        """
        self.key = key

    def to_dict(self):
        return {
            '_': 'LangPackStringDeleted',
            'key': self.key
        }

    def _bytes(self):
        return b''.join((
            b'\xb2\xeey)',
            self.serialize_bytes(self.key),
        ))

    @classmethod
    def from_reader(cls, reader):
        _key = reader.tgread_string()
        return cls(key=_key)


class LangPackStringPluralized(TLObject):
    CONSTRUCTOR_ID = 0x6c47ac9f
    SUBCLASS_OF_ID = 0xdc179ab9

    def __init__(self, key: str, other_value: str, zero_value: Optional[str]=None, one_value: Optional[str]=None, two_value: Optional[str]=None, few_value: Optional[str]=None, many_value: Optional[str]=None):
        """
        Constructor for LangPackString: Instance of either LangPackString, LangPackStringPluralized, LangPackStringDeleted.
        """
        self.key = key
        self.other_value = other_value
        self.zero_value = zero_value
        self.one_value = one_value
        self.two_value = two_value
        self.few_value = few_value
        self.many_value = many_value

    def to_dict(self):
        return {
            '_': 'LangPackStringPluralized',
            'key': self.key,
            'other_value': self.other_value,
            'zero_value': self.zero_value,
            'one_value': self.one_value,
            'two_value': self.two_value,
            'few_value': self.few_value,
            'many_value': self.many_value
        }

    def _bytes(self):
        return b''.join((
            b'\x9f\xacGl',
            struct.pack('<I', (0 if self.zero_value is None or self.zero_value is False else 1) | (0 if self.one_value is None or self.one_value is False else 2) | (0 if self.two_value is None or self.two_value is False else 4) | (0 if self.few_value is None or self.few_value is False else 8) | (0 if self.many_value is None or self.many_value is False else 16)),
            self.serialize_bytes(self.key),
            b'' if self.zero_value is None or self.zero_value is False else (self.serialize_bytes(self.zero_value)),
            b'' if self.one_value is None or self.one_value is False else (self.serialize_bytes(self.one_value)),
            b'' if self.two_value is None or self.two_value is False else (self.serialize_bytes(self.two_value)),
            b'' if self.few_value is None or self.few_value is False else (self.serialize_bytes(self.few_value)),
            b'' if self.many_value is None or self.many_value is False else (self.serialize_bytes(self.many_value)),
            self.serialize_bytes(self.other_value),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _key = reader.tgread_string()
        if flags & 1:
            _zero_value = reader.tgread_string()
        else:
            _zero_value = None
        if flags & 2:
            _one_value = reader.tgread_string()
        else:
            _one_value = None
        if flags & 4:
            _two_value = reader.tgread_string()
        else:
            _two_value = None
        if flags & 8:
            _few_value = reader.tgread_string()
        else:
            _few_value = None
        if flags & 16:
            _many_value = reader.tgread_string()
        else:
            _many_value = None
        _other_value = reader.tgread_string()
        return cls(key=_key, other_value=_other_value, zero_value=_zero_value, one_value=_one_value, two_value=_two_value, few_value=_few_value, many_value=_many_value)


class MaskCoords(TLObject):
    CONSTRUCTOR_ID = 0xaed6dbb2
    SUBCLASS_OF_ID = 0x6bbb2fd

    def __init__(self, n: int, x: float, y: float, zoom: float):
        """
        Constructor for MaskCoords: Instance of MaskCoords.
        """
        self.n = n
        self.x = x
        self.y = y
        self.zoom = zoom

    def to_dict(self):
        return {
            '_': 'MaskCoords',
            'n': self.n,
            'x': self.x,
            'y': self.y,
            'zoom': self.zoom
        }

    def _bytes(self):
        return b''.join((
            b'\xb2\xdb\xd6\xae',
            struct.pack('<i', self.n),
            struct.pack('<d', self.x),
            struct.pack('<d', self.y),
            struct.pack('<d', self.zoom),
        ))

    @classmethod
    def from_reader(cls, reader):
        _n = reader.read_int()
        _x = reader.read_double()
        _y = reader.read_double()
        _zoom = reader.read_double()
        return cls(n=_n, x=_x, y=_y, zoom=_zoom)


class MediaAreaCoordinates(TLObject):
    CONSTRUCTOR_ID = 0x3d1ea4e
    SUBCLASS_OF_ID = 0x1d448c39

    def __init__(self, x: float, y: float, w: float, h: float, rotation: float):
        """
        Constructor for MediaAreaCoordinates: Instance of MediaAreaCoordinates.
        """
        self.x = x
        self.y = y
        self.w = w
        self.h = h
        self.rotation = rotation

    def to_dict(self):
        return {
            '_': 'MediaAreaCoordinates',
            'x': self.x,
            'y': self.y,
            'w': self.w,
            'h': self.h,
            'rotation': self.rotation
        }

    def _bytes(self):
        return b''.join((
            b'N\xea\xd1\x03',
            struct.pack('<d', self.x),
            struct.pack('<d', self.y),
            struct.pack('<d', self.w),
            struct.pack('<d', self.h),
            struct.pack('<d', self.rotation),
        ))

    @classmethod
    def from_reader(cls, reader):
        _x = reader.read_double()
        _y = reader.read_double()
        _w = reader.read_double()
        _h = reader.read_double()
        _rotation = reader.read_double()
        return cls(x=_x, y=_y, w=_w, h=_h, rotation=_rotation)


class MediaAreaGeoPoint(TLObject):
    CONSTRUCTOR_ID = 0xdf8b3b22
    SUBCLASS_OF_ID = 0xf36d7bf2

    def __init__(self, coordinates: 'TypeMediaAreaCoordinates', geo: 'TypeGeoPoint'):
        """
        Constructor for MediaArea: Instance of either MediaAreaVenue, InputMediaAreaVenue, MediaAreaGeoPoint, MediaAreaSuggestedReaction.
        """
        self.coordinates = coordinates
        self.geo = geo

    def to_dict(self):
        return {
            '_': 'MediaAreaGeoPoint',
            'coordinates': self.coordinates.to_dict() if isinstance(self.coordinates, TLObject) else self.coordinates,
            'geo': self.geo.to_dict() if isinstance(self.geo, TLObject) else self.geo
        }

    def _bytes(self):
        return b''.join((
            b'";\x8b\xdf',
            self.coordinates._bytes(),
            self.geo._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _coordinates = reader.tgread_object()
        _geo = reader.tgread_object()
        return cls(coordinates=_coordinates, geo=_geo)


class MediaAreaSuggestedReaction(TLObject):
    CONSTRUCTOR_ID = 0x14455871
    SUBCLASS_OF_ID = 0xf36d7bf2

    def __init__(self, coordinates: 'TypeMediaAreaCoordinates', reaction: 'TypeReaction', dark: Optional[bool]=None, flipped: Optional[bool]=None):
        """
        Constructor for MediaArea: Instance of either MediaAreaVenue, InputMediaAreaVenue, MediaAreaGeoPoint, MediaAreaSuggestedReaction.
        """
        self.coordinates = coordinates
        self.reaction = reaction
        self.dark = dark
        self.flipped = flipped

    def to_dict(self):
        return {
            '_': 'MediaAreaSuggestedReaction',
            'coordinates': self.coordinates.to_dict() if isinstance(self.coordinates, TLObject) else self.coordinates,
            'reaction': self.reaction.to_dict() if isinstance(self.reaction, TLObject) else self.reaction,
            'dark': self.dark,
            'flipped': self.flipped
        }

    def _bytes(self):
        return b''.join((
            b'qXE\x14',
            struct.pack('<I', (0 if self.dark is None or self.dark is False else 1) | (0 if self.flipped is None or self.flipped is False else 2)),
            self.coordinates._bytes(),
            self.reaction._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _dark = bool(flags & 1)
        _flipped = bool(flags & 2)
        _coordinates = reader.tgread_object()
        _reaction = reader.tgread_object()
        return cls(coordinates=_coordinates, reaction=_reaction, dark=_dark, flipped=_flipped)


class MediaAreaVenue(TLObject):
    CONSTRUCTOR_ID = 0xbe82db9c
    SUBCLASS_OF_ID = 0xf36d7bf2

    def __init__(self, coordinates: 'TypeMediaAreaCoordinates', geo: 'TypeGeoPoint', title: str, address: str, provider: str, venue_id: str, venue_type: str):
        """
        Constructor for MediaArea: Instance of either MediaAreaVenue, InputMediaAreaVenue, MediaAreaGeoPoint, MediaAreaSuggestedReaction.
        """
        self.coordinates = coordinates
        self.geo = geo
        self.title = title
        self.address = address
        self.provider = provider
        self.venue_id = venue_id
        self.venue_type = venue_type

    def to_dict(self):
        return {
            '_': 'MediaAreaVenue',
            'coordinates': self.coordinates.to_dict() if isinstance(self.coordinates, TLObject) else self.coordinates,
            'geo': self.geo.to_dict() if isinstance(self.geo, TLObject) else self.geo,
            'title': self.title,
            'address': self.address,
            'provider': self.provider,
            'venue_id': self.venue_id,
            'venue_type': self.venue_type
        }

    def _bytes(self):
        return b''.join((
            b'\x9c\xdb\x82\xbe',
            self.coordinates._bytes(),
            self.geo._bytes(),
            self.serialize_bytes(self.title),
            self.serialize_bytes(self.address),
            self.serialize_bytes(self.provider),
            self.serialize_bytes(self.venue_id),
            self.serialize_bytes(self.venue_type),
        ))

    @classmethod
    def from_reader(cls, reader):
        _coordinates = reader.tgread_object()
        _geo = reader.tgread_object()
        _title = reader.tgread_string()
        _address = reader.tgread_string()
        _provider = reader.tgread_string()
        _venue_id = reader.tgread_string()
        _venue_type = reader.tgread_string()
        return cls(coordinates=_coordinates, geo=_geo, title=_title, address=_address, provider=_provider, venue_id=_venue_id, venue_type=_venue_type)


class Message(TLObject):
    CONSTRUCTOR_ID = 0x38116ee0
    SUBCLASS_OF_ID = 0x790009e3

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, peer_id: 'TypePeer', date: Optional[datetime], message: str, out: Optional[bool]=None, mentioned: Optional[bool]=None, media_unread: Optional[bool]=None, silent: Optional[bool]=None, post: Optional[bool]=None, from_scheduled: Optional[bool]=None, legacy: Optional[bool]=None, edit_hide: Optional[bool]=None, pinned: Optional[bool]=None, noforwards: Optional[bool]=None, invert_media: Optional[bool]=None, from_id: Optional['TypePeer']=None, fwd_from: Optional['TypeMessageFwdHeader']=None, via_bot_id: Optional[int]=None, reply_to: Optional['TypeMessageReplyHeader']=None, media: Optional['TypeMessageMedia']=None, reply_markup: Optional['TypeReplyMarkup']=None, entities: Optional[List['TypeMessageEntity']]=None, views: Optional[int]=None, forwards: Optional[int]=None, replies: Optional['TypeMessageReplies']=None, edit_date: Optional[datetime]=None, post_author: Optional[str]=None, grouped_id: Optional[int]=None, reactions: Optional['TypeMessageReactions']=None, restriction_reason: Optional[List['TypeRestrictionReason']]=None, ttl_period: Optional[int]=None):
        """
        Constructor for Message: Instance of either MessageEmpty, Message, MessageService.
        """
        self.id = id
        self.peer_id = peer_id
        self.date = date
        self.message = message
        self.out = out
        self.mentioned = mentioned
        self.media_unread = media_unread
        self.silent = silent
        self.post = post
        self.from_scheduled = from_scheduled
        self.legacy = legacy
        self.edit_hide = edit_hide
        self.pinned = pinned
        self.noforwards = noforwards
        self.invert_media = invert_media
        self.from_id = from_id
        self.fwd_from = fwd_from
        self.via_bot_id = via_bot_id
        self.reply_to = reply_to
        self.media = media
        self.reply_markup = reply_markup
        self.entities = entities
        self.views = views
        self.forwards = forwards
        self.replies = replies
        self.edit_date = edit_date
        self.post_author = post_author
        self.grouped_id = grouped_id
        self.reactions = reactions
        self.restriction_reason = restriction_reason
        self.ttl_period = ttl_period

    def to_dict(self):
        return {
            '_': 'Message',
            'id': self.id,
            'peer_id': self.peer_id.to_dict() if isinstance(self.peer_id, TLObject) else self.peer_id,
            'date': self.date,
            'message': self.message,
            'out': self.out,
            'mentioned': self.mentioned,
            'media_unread': self.media_unread,
            'silent': self.silent,
            'post': self.post,
            'from_scheduled': self.from_scheduled,
            'legacy': self.legacy,
            'edit_hide': self.edit_hide,
            'pinned': self.pinned,
            'noforwards': self.noforwards,
            'invert_media': self.invert_media,
            'from_id': self.from_id.to_dict() if isinstance(self.from_id, TLObject) else self.from_id,
            'fwd_from': self.fwd_from.to_dict() if isinstance(self.fwd_from, TLObject) else self.fwd_from,
            'via_bot_id': self.via_bot_id,
            'reply_to': self.reply_to.to_dict() if isinstance(self.reply_to, TLObject) else self.reply_to,
            'media': self.media.to_dict() if isinstance(self.media, TLObject) else self.media,
            'reply_markup': self.reply_markup.to_dict() if isinstance(self.reply_markup, TLObject) else self.reply_markup,
            'entities': [] if self.entities is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.entities],
            'views': self.views,
            'forwards': self.forwards,
            'replies': self.replies.to_dict() if isinstance(self.replies, TLObject) else self.replies,
            'edit_date': self.edit_date,
            'post_author': self.post_author,
            'grouped_id': self.grouped_id,
            'reactions': self.reactions.to_dict() if isinstance(self.reactions, TLObject) else self.reactions,
            'restriction_reason': [] if self.restriction_reason is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.restriction_reason],
            'ttl_period': self.ttl_period
        }

    def _bytes(self):
        assert ((self.views or self.views is not None) and (self.forwards or self.forwards is not None)) or ((self.views is None or self.views is False) and (self.forwards is None or self.forwards is False)), 'views, forwards parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'\xe0n\x118',
            struct.pack('<I', (0 if self.out is None or self.out is False else 2) | (0 if self.mentioned is None or self.mentioned is False else 16) | (0 if self.media_unread is None or self.media_unread is False else 32) | (0 if self.silent is None or self.silent is False else 8192) | (0 if self.post is None or self.post is False else 16384) | (0 if self.from_scheduled is None or self.from_scheduled is False else 262144) | (0 if self.legacy is None or self.legacy is False else 524288) | (0 if self.edit_hide is None or self.edit_hide is False else 2097152) | (0 if self.pinned is None or self.pinned is False else 16777216) | (0 if self.noforwards is None or self.noforwards is False else 67108864) | (0 if self.invert_media is None or self.invert_media is False else 134217728) | (0 if self.from_id is None or self.from_id is False else 256) | (0 if self.fwd_from is None or self.fwd_from is False else 4) | (0 if self.via_bot_id is None or self.via_bot_id is False else 2048) | (0 if self.reply_to is None or self.reply_to is False else 8) | (0 if self.media is None or self.media is False else 512) | (0 if self.reply_markup is None or self.reply_markup is False else 64) | (0 if self.entities is None or self.entities is False else 128) | (0 if self.views is None or self.views is False else 1024) | (0 if self.forwards is None or self.forwards is False else 1024) | (0 if self.replies is None or self.replies is False else 8388608) | (0 if self.edit_date is None or self.edit_date is False else 32768) | (0 if self.post_author is None or self.post_author is False else 65536) | (0 if self.grouped_id is None or self.grouped_id is False else 131072) | (0 if self.reactions is None or self.reactions is False else 1048576) | (0 if self.restriction_reason is None or self.restriction_reason is False else 4194304) | (0 if self.ttl_period is None or self.ttl_period is False else 33554432)),
            struct.pack('<i', self.id),
            b'' if self.from_id is None or self.from_id is False else (self.from_id._bytes()),
            self.peer_id._bytes(),
            b'' if self.fwd_from is None or self.fwd_from is False else (self.fwd_from._bytes()),
            b'' if self.via_bot_id is None or self.via_bot_id is False else (struct.pack('<q', self.via_bot_id)),
            b'' if self.reply_to is None or self.reply_to is False else (self.reply_to._bytes()),
            self.serialize_datetime(self.date),
            self.serialize_bytes(self.message),
            b'' if self.media is None or self.media is False else (self.media._bytes()),
            b'' if self.reply_markup is None or self.reply_markup is False else (self.reply_markup._bytes()),
            b'' if self.entities is None or self.entities is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.entities)),b''.join(x._bytes() for x in self.entities))),
            b'' if self.views is None or self.views is False else (struct.pack('<i', self.views)),
            b'' if self.forwards is None or self.forwards is False else (struct.pack('<i', self.forwards)),
            b'' if self.replies is None or self.replies is False else (self.replies._bytes()),
            b'' if self.edit_date is None or self.edit_date is False else (self.serialize_datetime(self.edit_date)),
            b'' if self.post_author is None or self.post_author is False else (self.serialize_bytes(self.post_author)),
            b'' if self.grouped_id is None or self.grouped_id is False else (struct.pack('<q', self.grouped_id)),
            b'' if self.reactions is None or self.reactions is False else (self.reactions._bytes()),
            b'' if self.restriction_reason is None or self.restriction_reason is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.restriction_reason)),b''.join(x._bytes() for x in self.restriction_reason))),
            b'' if self.ttl_period is None or self.ttl_period is False else (struct.pack('<i', self.ttl_period)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _out = bool(flags & 2)
        _mentioned = bool(flags & 16)
        _media_unread = bool(flags & 32)
        _silent = bool(flags & 8192)
        _post = bool(flags & 16384)
        _from_scheduled = bool(flags & 262144)
        _legacy = bool(flags & 524288)
        _edit_hide = bool(flags & 2097152)
        _pinned = bool(flags & 16777216)
        _noforwards = bool(flags & 67108864)
        _invert_media = bool(flags & 134217728)
        _id = reader.read_int()
        if flags & 256:
            _from_id = reader.tgread_object()
        else:
            _from_id = None
        _peer_id = reader.tgread_object()
        if flags & 4:
            _fwd_from = reader.tgread_object()
        else:
            _fwd_from = None
        if flags & 2048:
            _via_bot_id = reader.read_long()
        else:
            _via_bot_id = None
        if flags & 8:
            _reply_to = reader.tgread_object()
        else:
            _reply_to = None
        _date = reader.tgread_date()
        _message = reader.tgread_string()
        if flags & 512:
            _media = reader.tgread_object()
        else:
            _media = None
        if flags & 64:
            _reply_markup = reader.tgread_object()
        else:
            _reply_markup = None
        if flags & 128:
            reader.read_int()
            _entities = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _entities.append(_x)

        else:
            _entities = None
        if flags & 1024:
            _views = reader.read_int()
        else:
            _views = None
        if flags & 1024:
            _forwards = reader.read_int()
        else:
            _forwards = None
        if flags & 8388608:
            _replies = reader.tgread_object()
        else:
            _replies = None
        if flags & 32768:
            _edit_date = reader.tgread_date()
        else:
            _edit_date = None
        if flags & 65536:
            _post_author = reader.tgread_string()
        else:
            _post_author = None
        if flags & 131072:
            _grouped_id = reader.read_long()
        else:
            _grouped_id = None
        if flags & 1048576:
            _reactions = reader.tgread_object()
        else:
            _reactions = None
        if flags & 4194304:
            reader.read_int()
            _restriction_reason = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _restriction_reason.append(_x)

        else:
            _restriction_reason = None
        if flags & 33554432:
            _ttl_period = reader.read_int()
        else:
            _ttl_period = None
        return cls(id=_id, peer_id=_peer_id, date=_date, message=_message, out=_out, mentioned=_mentioned, media_unread=_media_unread, silent=_silent, post=_post, from_scheduled=_from_scheduled, legacy=_legacy, edit_hide=_edit_hide, pinned=_pinned, noforwards=_noforwards, invert_media=_invert_media, from_id=_from_id, fwd_from=_fwd_from, via_bot_id=_via_bot_id, reply_to=_reply_to, media=_media, reply_markup=_reply_markup, entities=_entities, views=_views, forwards=_forwards, replies=_replies, edit_date=_edit_date, post_author=_post_author, grouped_id=_grouped_id, reactions=_reactions, restriction_reason=_restriction_reason, ttl_period=_ttl_period)


class MessageActionBotAllowed(TLObject):
    CONSTRUCTOR_ID = 0xc516d679
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, attach_menu: Optional[bool]=None, from_request: Optional[bool]=None, domain: Optional[str]=None, app: Optional['TypeBotApp']=None):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest, MessageActionWebViewDataSentMe, MessageActionWebViewDataSent, MessageActionGiftPremium, MessageActionTopicCreate, MessageActionTopicEdit, MessageActionSuggestProfilePhoto, MessageActionRequestedPeer, MessageActionSetChatWallPaper, MessageActionSetSameChatWallPaper, MessageActionGiftCode, MessageActionGiveawayLaunch.
        """
        self.attach_menu = attach_menu
        self.from_request = from_request
        self.domain = domain
        self.app = app

    def to_dict(self):
        return {
            '_': 'MessageActionBotAllowed',
            'attach_menu': self.attach_menu,
            'from_request': self.from_request,
            'domain': self.domain,
            'app': self.app.to_dict() if isinstance(self.app, TLObject) else self.app
        }

    def _bytes(self):
        return b''.join((
            b'y\xd6\x16\xc5',
            struct.pack('<I', (0 if self.attach_menu is None or self.attach_menu is False else 2) | (0 if self.from_request is None or self.from_request is False else 8) | (0 if self.domain is None or self.domain is False else 1) | (0 if self.app is None or self.app is False else 4)),
            b'' if self.domain is None or self.domain is False else (self.serialize_bytes(self.domain)),
            b'' if self.app is None or self.app is False else (self.app._bytes()),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _attach_menu = bool(flags & 2)
        _from_request = bool(flags & 8)
        if flags & 1:
            _domain = reader.tgread_string()
        else:
            _domain = None
        if flags & 4:
            _app = reader.tgread_object()
        else:
            _app = None
        return cls(attach_menu=_attach_menu, from_request=_from_request, domain=_domain, app=_app)


class MessageActionChannelCreate(TLObject):
    CONSTRUCTOR_ID = 0x95d2ac92
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, title: str):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest, MessageActionWebViewDataSentMe, MessageActionWebViewDataSent, MessageActionGiftPremium, MessageActionTopicCreate, MessageActionTopicEdit, MessageActionSuggestProfilePhoto, MessageActionRequestedPeer, MessageActionSetChatWallPaper, MessageActionSetSameChatWallPaper, MessageActionGiftCode, MessageActionGiveawayLaunch.
        """
        self.title = title

    def to_dict(self):
        return {
            '_': 'MessageActionChannelCreate',
            'title': self.title
        }

    def _bytes(self):
        return b''.join((
            b'\x92\xac\xd2\x95',
            self.serialize_bytes(self.title),
        ))

    @classmethod
    def from_reader(cls, reader):
        _title = reader.tgread_string()
        return cls(title=_title)


class MessageActionChannelMigrateFrom(TLObject):
    CONSTRUCTOR_ID = 0xea3948e9
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, title: str, chat_id: int):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest, MessageActionWebViewDataSentMe, MessageActionWebViewDataSent, MessageActionGiftPremium, MessageActionTopicCreate, MessageActionTopicEdit, MessageActionSuggestProfilePhoto, MessageActionRequestedPeer, MessageActionSetChatWallPaper, MessageActionSetSameChatWallPaper, MessageActionGiftCode, MessageActionGiveawayLaunch.
        """
        self.title = title
        self.chat_id = chat_id

    def to_dict(self):
        return {
            '_': 'MessageActionChannelMigrateFrom',
            'title': self.title,
            'chat_id': self.chat_id
        }

    def _bytes(self):
        return b''.join((
            b'\xe9H9\xea',
            self.serialize_bytes(self.title),
            struct.pack('<q', self.chat_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _title = reader.tgread_string()
        _chat_id = reader.read_long()
        return cls(title=_title, chat_id=_chat_id)


class MessageActionChatAddUser(TLObject):
    CONSTRUCTOR_ID = 0x15cefd00
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, users: List[int]):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest, MessageActionWebViewDataSentMe, MessageActionWebViewDataSent, MessageActionGiftPremium, MessageActionTopicCreate, MessageActionTopicEdit, MessageActionSuggestProfilePhoto, MessageActionRequestedPeer, MessageActionSetChatWallPaper, MessageActionSetSameChatWallPaper, MessageActionGiftCode, MessageActionGiveawayLaunch.
        """
        self.users = users

    def to_dict(self):
        return {
            '_': 'MessageActionChatAddUser',
            'users': [] if self.users is None else self.users[:]
        }

    def _bytes(self):
        return b''.join((
            b'\x00\xfd\xce\x15',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(struct.pack('<q', x) for x in self.users),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _users.append(_x)

        return cls(users=_users)


class MessageActionChatCreate(TLObject):
    CONSTRUCTOR_ID = 0xbd47cbad
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, title: str, users: List[int]):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest, MessageActionWebViewDataSentMe, MessageActionWebViewDataSent, MessageActionGiftPremium, MessageActionTopicCreate, MessageActionTopicEdit, MessageActionSuggestProfilePhoto, MessageActionRequestedPeer, MessageActionSetChatWallPaper, MessageActionSetSameChatWallPaper, MessageActionGiftCode, MessageActionGiveawayLaunch.
        """
        self.title = title
        self.users = users

    def to_dict(self):
        return {
            '_': 'MessageActionChatCreate',
            'title': self.title,
            'users': [] if self.users is None else self.users[:]
        }

    def _bytes(self):
        return b''.join((
            b'\xad\xcbG\xbd',
            self.serialize_bytes(self.title),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(struct.pack('<q', x) for x in self.users),
        ))

    @classmethod
    def from_reader(cls, reader):
        _title = reader.tgread_string()
        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _users.append(_x)

        return cls(title=_title, users=_users)


class MessageActionChatDeletePhoto(TLObject):
    CONSTRUCTOR_ID = 0x95e3fbef
    SUBCLASS_OF_ID = 0x8680d126

    def to_dict(self):
        return {
            '_': 'MessageActionChatDeletePhoto'
        }

    def _bytes(self):
        return b''.join((
            b'\xef\xfb\xe3\x95',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class MessageActionChatDeleteUser(TLObject):
    CONSTRUCTOR_ID = 0xa43f30cc
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, user_id: int):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest, MessageActionWebViewDataSentMe, MessageActionWebViewDataSent, MessageActionGiftPremium, MessageActionTopicCreate, MessageActionTopicEdit, MessageActionSuggestProfilePhoto, MessageActionRequestedPeer, MessageActionSetChatWallPaper, MessageActionSetSameChatWallPaper, MessageActionGiftCode, MessageActionGiveawayLaunch.
        """
        self.user_id = user_id

    def to_dict(self):
        return {
            '_': 'MessageActionChatDeleteUser',
            'user_id': self.user_id
        }

    def _bytes(self):
        return b''.join((
            b'\xcc0?\xa4',
            struct.pack('<q', self.user_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _user_id = reader.read_long()
        return cls(user_id=_user_id)


class MessageActionChatEditPhoto(TLObject):
    CONSTRUCTOR_ID = 0x7fcb13a8
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, photo: 'TypePhoto'):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest, MessageActionWebViewDataSentMe, MessageActionWebViewDataSent, MessageActionGiftPremium, MessageActionTopicCreate, MessageActionTopicEdit, MessageActionSuggestProfilePhoto, MessageActionRequestedPeer, MessageActionSetChatWallPaper, MessageActionSetSameChatWallPaper, MessageActionGiftCode, MessageActionGiveawayLaunch.
        """
        self.photo = photo

    def to_dict(self):
        return {
            '_': 'MessageActionChatEditPhoto',
            'photo': self.photo.to_dict() if isinstance(self.photo, TLObject) else self.photo
        }

    def _bytes(self):
        return b''.join((
            b'\xa8\x13\xcb\x7f',
            self.photo._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _photo = reader.tgread_object()
        return cls(photo=_photo)


class MessageActionChatEditTitle(TLObject):
    CONSTRUCTOR_ID = 0xb5a1ce5a
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, title: str):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest, MessageActionWebViewDataSentMe, MessageActionWebViewDataSent, MessageActionGiftPremium, MessageActionTopicCreate, MessageActionTopicEdit, MessageActionSuggestProfilePhoto, MessageActionRequestedPeer, MessageActionSetChatWallPaper, MessageActionSetSameChatWallPaper, MessageActionGiftCode, MessageActionGiveawayLaunch.
        """
        self.title = title

    def to_dict(self):
        return {
            '_': 'MessageActionChatEditTitle',
            'title': self.title
        }

    def _bytes(self):
        return b''.join((
            b'Z\xce\xa1\xb5',
            self.serialize_bytes(self.title),
        ))

    @classmethod
    def from_reader(cls, reader):
        _title = reader.tgread_string()
        return cls(title=_title)


class MessageActionChatJoinedByLink(TLObject):
    CONSTRUCTOR_ID = 0x31224c3
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, inviter_id: int):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest, MessageActionWebViewDataSentMe, MessageActionWebViewDataSent, MessageActionGiftPremium, MessageActionTopicCreate, MessageActionTopicEdit, MessageActionSuggestProfilePhoto, MessageActionRequestedPeer, MessageActionSetChatWallPaper, MessageActionSetSameChatWallPaper, MessageActionGiftCode, MessageActionGiveawayLaunch.
        """
        self.inviter_id = inviter_id

    def to_dict(self):
        return {
            '_': 'MessageActionChatJoinedByLink',
            'inviter_id': self.inviter_id
        }

    def _bytes(self):
        return b''.join((
            b'\xc3$\x12\x03',
            struct.pack('<q', self.inviter_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _inviter_id = reader.read_long()
        return cls(inviter_id=_inviter_id)


class MessageActionChatJoinedByRequest(TLObject):
    CONSTRUCTOR_ID = 0xebbca3cb
    SUBCLASS_OF_ID = 0x8680d126

    def to_dict(self):
        return {
            '_': 'MessageActionChatJoinedByRequest'
        }

    def _bytes(self):
        return b''.join((
            b'\xcb\xa3\xbc\xeb',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class MessageActionChatMigrateTo(TLObject):
    CONSTRUCTOR_ID = 0xe1037f92
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, channel_id: int):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest, MessageActionWebViewDataSentMe, MessageActionWebViewDataSent, MessageActionGiftPremium, MessageActionTopicCreate, MessageActionTopicEdit, MessageActionSuggestProfilePhoto, MessageActionRequestedPeer, MessageActionSetChatWallPaper, MessageActionSetSameChatWallPaper, MessageActionGiftCode, MessageActionGiveawayLaunch.
        """
        self.channel_id = channel_id

    def to_dict(self):
        return {
            '_': 'MessageActionChatMigrateTo',
            'channel_id': self.channel_id
        }

    def _bytes(self):
        return b''.join((
            b'\x92\x7f\x03\xe1',
            struct.pack('<q', self.channel_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel_id = reader.read_long()
        return cls(channel_id=_channel_id)


class MessageActionContactSignUp(TLObject):
    CONSTRUCTOR_ID = 0xf3f25f76
    SUBCLASS_OF_ID = 0x8680d126

    def to_dict(self):
        return {
            '_': 'MessageActionContactSignUp'
        }

    def _bytes(self):
        return b''.join((
            b'v_\xf2\xf3',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class MessageActionCustomAction(TLObject):
    CONSTRUCTOR_ID = 0xfae69f56
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, message: str):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest, MessageActionWebViewDataSentMe, MessageActionWebViewDataSent, MessageActionGiftPremium, MessageActionTopicCreate, MessageActionTopicEdit, MessageActionSuggestProfilePhoto, MessageActionRequestedPeer, MessageActionSetChatWallPaper, MessageActionSetSameChatWallPaper, MessageActionGiftCode, MessageActionGiveawayLaunch.
        """
        self.message = message

    def to_dict(self):
        return {
            '_': 'MessageActionCustomAction',
            'message': self.message
        }

    def _bytes(self):
        return b''.join((
            b'V\x9f\xe6\xfa',
            self.serialize_bytes(self.message),
        ))

    @classmethod
    def from_reader(cls, reader):
        _message = reader.tgread_string()
        return cls(message=_message)


class MessageActionEmpty(TLObject):
    CONSTRUCTOR_ID = 0xb6aef7b0
    SUBCLASS_OF_ID = 0x8680d126

    def to_dict(self):
        return {
            '_': 'MessageActionEmpty'
        }

    def _bytes(self):
        return b''.join((
            b'\xb0\xf7\xae\xb6',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class MessageActionGameScore(TLObject):
    CONSTRUCTOR_ID = 0x92a72876
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, game_id: int, score: int):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest, MessageActionWebViewDataSentMe, MessageActionWebViewDataSent, MessageActionGiftPremium, MessageActionTopicCreate, MessageActionTopicEdit, MessageActionSuggestProfilePhoto, MessageActionRequestedPeer, MessageActionSetChatWallPaper, MessageActionSetSameChatWallPaper, MessageActionGiftCode, MessageActionGiveawayLaunch.
        """
        self.game_id = game_id
        self.score = score

    def to_dict(self):
        return {
            '_': 'MessageActionGameScore',
            'game_id': self.game_id,
            'score': self.score
        }

    def _bytes(self):
        return b''.join((
            b'v(\xa7\x92',
            struct.pack('<q', self.game_id),
            struct.pack('<i', self.score),
        ))

    @classmethod
    def from_reader(cls, reader):
        _game_id = reader.read_long()
        _score = reader.read_int()
        return cls(game_id=_game_id, score=_score)


class MessageActionGeoProximityReached(TLObject):
    CONSTRUCTOR_ID = 0x98e0d697
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, from_id: 'TypePeer', to_id: 'TypePeer', distance: int):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest, MessageActionWebViewDataSentMe, MessageActionWebViewDataSent, MessageActionGiftPremium, MessageActionTopicCreate, MessageActionTopicEdit, MessageActionSuggestProfilePhoto, MessageActionRequestedPeer, MessageActionSetChatWallPaper, MessageActionSetSameChatWallPaper, MessageActionGiftCode, MessageActionGiveawayLaunch.
        """
        self.from_id = from_id
        self.to_id = to_id
        self.distance = distance

    def to_dict(self):
        return {
            '_': 'MessageActionGeoProximityReached',
            'from_id': self.from_id.to_dict() if isinstance(self.from_id, TLObject) else self.from_id,
            'to_id': self.to_id.to_dict() if isinstance(self.to_id, TLObject) else self.to_id,
            'distance': self.distance
        }

    def _bytes(self):
        return b''.join((
            b'\x97\xd6\xe0\x98',
            self.from_id._bytes(),
            self.to_id._bytes(),
            struct.pack('<i', self.distance),
        ))

    @classmethod
    def from_reader(cls, reader):
        _from_id = reader.tgread_object()
        _to_id = reader.tgread_object()
        _distance = reader.read_int()
        return cls(from_id=_from_id, to_id=_to_id, distance=_distance)


class MessageActionGiftCode(TLObject):
    CONSTRUCTOR_ID = 0xd2cfdb0e
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, months: int, slug: str, via_giveaway: Optional[bool]=None, unclaimed: Optional[bool]=None, boost_peer: Optional['TypePeer']=None):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest, MessageActionWebViewDataSentMe, MessageActionWebViewDataSent, MessageActionGiftPremium, MessageActionTopicCreate, MessageActionTopicEdit, MessageActionSuggestProfilePhoto, MessageActionRequestedPeer, MessageActionSetChatWallPaper, MessageActionSetSameChatWallPaper, MessageActionGiftCode, MessageActionGiveawayLaunch.
        """
        self.months = months
        self.slug = slug
        self.via_giveaway = via_giveaway
        self.unclaimed = unclaimed
        self.boost_peer = boost_peer

    def to_dict(self):
        return {
            '_': 'MessageActionGiftCode',
            'months': self.months,
            'slug': self.slug,
            'via_giveaway': self.via_giveaway,
            'unclaimed': self.unclaimed,
            'boost_peer': self.boost_peer.to_dict() if isinstance(self.boost_peer, TLObject) else self.boost_peer
        }

    def _bytes(self):
        return b''.join((
            b'\x0e\xdb\xcf\xd2',
            struct.pack('<I', (0 if self.via_giveaway is None or self.via_giveaway is False else 1) | (0 if self.unclaimed is None or self.unclaimed is False else 4) | (0 if self.boost_peer is None or self.boost_peer is False else 2)),
            b'' if self.boost_peer is None or self.boost_peer is False else (self.boost_peer._bytes()),
            struct.pack('<i', self.months),
            self.serialize_bytes(self.slug),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _via_giveaway = bool(flags & 1)
        _unclaimed = bool(flags & 4)
        if flags & 2:
            _boost_peer = reader.tgread_object()
        else:
            _boost_peer = None
        _months = reader.read_int()
        _slug = reader.tgread_string()
        return cls(months=_months, slug=_slug, via_giveaway=_via_giveaway, unclaimed=_unclaimed, boost_peer=_boost_peer)


class MessageActionGiftPremium(TLObject):
    CONSTRUCTOR_ID = 0xc83d6aec
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, currency: str, amount: int, months: int, crypto_currency: Optional[str]=None, crypto_amount: Optional[int]=None):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest, MessageActionWebViewDataSentMe, MessageActionWebViewDataSent, MessageActionGiftPremium, MessageActionTopicCreate, MessageActionTopicEdit, MessageActionSuggestProfilePhoto, MessageActionRequestedPeer, MessageActionSetChatWallPaper, MessageActionSetSameChatWallPaper, MessageActionGiftCode, MessageActionGiveawayLaunch.
        """
        self.currency = currency
        self.amount = amount
        self.months = months
        self.crypto_currency = crypto_currency
        self.crypto_amount = crypto_amount

    def to_dict(self):
        return {
            '_': 'MessageActionGiftPremium',
            'currency': self.currency,
            'amount': self.amount,
            'months': self.months,
            'crypto_currency': self.crypto_currency,
            'crypto_amount': self.crypto_amount
        }

    def _bytes(self):
        assert ((self.crypto_currency or self.crypto_currency is not None) and (self.crypto_amount or self.crypto_amount is not None)) or ((self.crypto_currency is None or self.crypto_currency is False) and (self.crypto_amount is None or self.crypto_amount is False)), 'crypto_currency, crypto_amount parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'\xecj=\xc8',
            struct.pack('<I', (0 if self.crypto_currency is None or self.crypto_currency is False else 1) | (0 if self.crypto_amount is None or self.crypto_amount is False else 1)),
            self.serialize_bytes(self.currency),
            struct.pack('<q', self.amount),
            struct.pack('<i', self.months),
            b'' if self.crypto_currency is None or self.crypto_currency is False else (self.serialize_bytes(self.crypto_currency)),
            b'' if self.crypto_amount is None or self.crypto_amount is False else (struct.pack('<q', self.crypto_amount)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _currency = reader.tgread_string()
        _amount = reader.read_long()
        _months = reader.read_int()
        if flags & 1:
            _crypto_currency = reader.tgread_string()
        else:
            _crypto_currency = None
        if flags & 1:
            _crypto_amount = reader.read_long()
        else:
            _crypto_amount = None
        return cls(currency=_currency, amount=_amount, months=_months, crypto_currency=_crypto_currency, crypto_amount=_crypto_amount)


class MessageActionGiveawayLaunch(TLObject):
    CONSTRUCTOR_ID = 0x332ba9ed
    SUBCLASS_OF_ID = 0x8680d126

    def to_dict(self):
        return {
            '_': 'MessageActionGiveawayLaunch'
        }

    def _bytes(self):
        return b''.join((
            b'\xed\xa9+3',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class MessageActionGroupCall(TLObject):
    CONSTRUCTOR_ID = 0x7a0d7f42
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, call: 'TypeInputGroupCall', duration: Optional[int]=None):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest, MessageActionWebViewDataSentMe, MessageActionWebViewDataSent, MessageActionGiftPremium, MessageActionTopicCreate, MessageActionTopicEdit, MessageActionSuggestProfilePhoto, MessageActionRequestedPeer, MessageActionSetChatWallPaper, MessageActionSetSameChatWallPaper, MessageActionGiftCode, MessageActionGiveawayLaunch.
        """
        self.call = call
        self.duration = duration

    def to_dict(self):
        return {
            '_': 'MessageActionGroupCall',
            'call': self.call.to_dict() if isinstance(self.call, TLObject) else self.call,
            'duration': self.duration
        }

    def _bytes(self):
        return b''.join((
            b'B\x7f\rz',
            struct.pack('<I', (0 if self.duration is None or self.duration is False else 1)),
            self.call._bytes(),
            b'' if self.duration is None or self.duration is False else (struct.pack('<i', self.duration)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _call = reader.tgread_object()
        if flags & 1:
            _duration = reader.read_int()
        else:
            _duration = None
        return cls(call=_call, duration=_duration)


class MessageActionGroupCallScheduled(TLObject):
    CONSTRUCTOR_ID = 0xb3a07661
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, call: 'TypeInputGroupCall', schedule_date: Optional[datetime]):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest, MessageActionWebViewDataSentMe, MessageActionWebViewDataSent, MessageActionGiftPremium, MessageActionTopicCreate, MessageActionTopicEdit, MessageActionSuggestProfilePhoto, MessageActionRequestedPeer, MessageActionSetChatWallPaper, MessageActionSetSameChatWallPaper, MessageActionGiftCode, MessageActionGiveawayLaunch.
        """
        self.call = call
        self.schedule_date = schedule_date

    def to_dict(self):
        return {
            '_': 'MessageActionGroupCallScheduled',
            'call': self.call.to_dict() if isinstance(self.call, TLObject) else self.call,
            'schedule_date': self.schedule_date
        }

    def _bytes(self):
        return b''.join((
            b'av\xa0\xb3',
            self.call._bytes(),
            self.serialize_datetime(self.schedule_date),
        ))

    @classmethod
    def from_reader(cls, reader):
        _call = reader.tgread_object()
        _schedule_date = reader.tgread_date()
        return cls(call=_call, schedule_date=_schedule_date)


class MessageActionHistoryClear(TLObject):
    CONSTRUCTOR_ID = 0x9fbab604
    SUBCLASS_OF_ID = 0x8680d126

    def to_dict(self):
        return {
            '_': 'MessageActionHistoryClear'
        }

    def _bytes(self):
        return b''.join((
            b'\x04\xb6\xba\x9f',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class MessageActionInviteToGroupCall(TLObject):
    CONSTRUCTOR_ID = 0x502f92f7
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, call: 'TypeInputGroupCall', users: List[int]):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest, MessageActionWebViewDataSentMe, MessageActionWebViewDataSent, MessageActionGiftPremium, MessageActionTopicCreate, MessageActionTopicEdit, MessageActionSuggestProfilePhoto, MessageActionRequestedPeer, MessageActionSetChatWallPaper, MessageActionSetSameChatWallPaper, MessageActionGiftCode, MessageActionGiveawayLaunch.
        """
        self.call = call
        self.users = users

    def to_dict(self):
        return {
            '_': 'MessageActionInviteToGroupCall',
            'call': self.call.to_dict() if isinstance(self.call, TLObject) else self.call,
            'users': [] if self.users is None else self.users[:]
        }

    def _bytes(self):
        return b''.join((
            b'\xf7\x92/P',
            self.call._bytes(),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.users)),b''.join(struct.pack('<q', x) for x in self.users),
        ))

    @classmethod
    def from_reader(cls, reader):
        _call = reader.tgread_object()
        reader.read_int()
        _users = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _users.append(_x)

        return cls(call=_call, users=_users)


class MessageActionPaymentSent(TLObject):
    CONSTRUCTOR_ID = 0x96163f56
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, currency: str, total_amount: int, recurring_init: Optional[bool]=None, recurring_used: Optional[bool]=None, invoice_slug: Optional[str]=None):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest, MessageActionWebViewDataSentMe, MessageActionWebViewDataSent, MessageActionGiftPremium, MessageActionTopicCreate, MessageActionTopicEdit, MessageActionSuggestProfilePhoto, MessageActionRequestedPeer, MessageActionSetChatWallPaper, MessageActionSetSameChatWallPaper, MessageActionGiftCode, MessageActionGiveawayLaunch.
        """
        self.currency = currency
        self.total_amount = total_amount
        self.recurring_init = recurring_init
        self.recurring_used = recurring_used
        self.invoice_slug = invoice_slug

    def to_dict(self):
        return {
            '_': 'MessageActionPaymentSent',
            'currency': self.currency,
            'total_amount': self.total_amount,
            'recurring_init': self.recurring_init,
            'recurring_used': self.recurring_used,
            'invoice_slug': self.invoice_slug
        }

    def _bytes(self):
        return b''.join((
            b'V?\x16\x96',
            struct.pack('<I', (0 if self.recurring_init is None or self.recurring_init is False else 4) | (0 if self.recurring_used is None or self.recurring_used is False else 8) | (0 if self.invoice_slug is None or self.invoice_slug is False else 1)),
            self.serialize_bytes(self.currency),
            struct.pack('<q', self.total_amount),
            b'' if self.invoice_slug is None or self.invoice_slug is False else (self.serialize_bytes(self.invoice_slug)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _recurring_init = bool(flags & 4)
        _recurring_used = bool(flags & 8)
        _currency = reader.tgread_string()
        _total_amount = reader.read_long()
        if flags & 1:
            _invoice_slug = reader.tgread_string()
        else:
            _invoice_slug = None
        return cls(currency=_currency, total_amount=_total_amount, recurring_init=_recurring_init, recurring_used=_recurring_used, invoice_slug=_invoice_slug)


class MessageActionPaymentSentMe(TLObject):
    CONSTRUCTOR_ID = 0x8f31b327
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, currency: str, total_amount: int, payload: bytes, charge: 'TypePaymentCharge', recurring_init: Optional[bool]=None, recurring_used: Optional[bool]=None, info: Optional['TypePaymentRequestedInfo']=None, shipping_option_id: Optional[str]=None):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest, MessageActionWebViewDataSentMe, MessageActionWebViewDataSent, MessageActionGiftPremium, MessageActionTopicCreate, MessageActionTopicEdit, MessageActionSuggestProfilePhoto, MessageActionRequestedPeer, MessageActionSetChatWallPaper, MessageActionSetSameChatWallPaper, MessageActionGiftCode, MessageActionGiveawayLaunch.
        """
        self.currency = currency
        self.total_amount = total_amount
        self.payload = payload
        self.charge = charge
        self.recurring_init = recurring_init
        self.recurring_used = recurring_used
        self.info = info
        self.shipping_option_id = shipping_option_id

    def to_dict(self):
        return {
            '_': 'MessageActionPaymentSentMe',
            'currency': self.currency,
            'total_amount': self.total_amount,
            'payload': self.payload,
            'charge': self.charge.to_dict() if isinstance(self.charge, TLObject) else self.charge,
            'recurring_init': self.recurring_init,
            'recurring_used': self.recurring_used,
            'info': self.info.to_dict() if isinstance(self.info, TLObject) else self.info,
            'shipping_option_id': self.shipping_option_id
        }

    def _bytes(self):
        return b''.join((
            b"'\xb31\x8f",
            struct.pack('<I', (0 if self.recurring_init is None or self.recurring_init is False else 4) | (0 if self.recurring_used is None or self.recurring_used is False else 8) | (0 if self.info is None or self.info is False else 1) | (0 if self.shipping_option_id is None or self.shipping_option_id is False else 2)),
            self.serialize_bytes(self.currency),
            struct.pack('<q', self.total_amount),
            self.serialize_bytes(self.payload),
            b'' if self.info is None or self.info is False else (self.info._bytes()),
            b'' if self.shipping_option_id is None or self.shipping_option_id is False else (self.serialize_bytes(self.shipping_option_id)),
            self.charge._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _recurring_init = bool(flags & 4)
        _recurring_used = bool(flags & 8)
        _currency = reader.tgread_string()
        _total_amount = reader.read_long()
        _payload = reader.tgread_bytes()
        if flags & 1:
            _info = reader.tgread_object()
        else:
            _info = None
        if flags & 2:
            _shipping_option_id = reader.tgread_string()
        else:
            _shipping_option_id = None
        _charge = reader.tgread_object()
        return cls(currency=_currency, total_amount=_total_amount, payload=_payload, charge=_charge, recurring_init=_recurring_init, recurring_used=_recurring_used, info=_info, shipping_option_id=_shipping_option_id)


class MessageActionPhoneCall(TLObject):
    CONSTRUCTOR_ID = 0x80e11a7f
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, call_id: int, video: Optional[bool]=None, reason: Optional['TypePhoneCallDiscardReason']=None, duration: Optional[int]=None):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest, MessageActionWebViewDataSentMe, MessageActionWebViewDataSent, MessageActionGiftPremium, MessageActionTopicCreate, MessageActionTopicEdit, MessageActionSuggestProfilePhoto, MessageActionRequestedPeer, MessageActionSetChatWallPaper, MessageActionSetSameChatWallPaper, MessageActionGiftCode, MessageActionGiveawayLaunch.
        """
        self.call_id = call_id
        self.video = video
        self.reason = reason
        self.duration = duration

    def to_dict(self):
        return {
            '_': 'MessageActionPhoneCall',
            'call_id': self.call_id,
            'video': self.video,
            'reason': self.reason.to_dict() if isinstance(self.reason, TLObject) else self.reason,
            'duration': self.duration
        }

    def _bytes(self):
        return b''.join((
            b'\x7f\x1a\xe1\x80',
            struct.pack('<I', (0 if self.video is None or self.video is False else 4) | (0 if self.reason is None or self.reason is False else 1) | (0 if self.duration is None or self.duration is False else 2)),
            struct.pack('<q', self.call_id),
            b'' if self.reason is None or self.reason is False else (self.reason._bytes()),
            b'' if self.duration is None or self.duration is False else (struct.pack('<i', self.duration)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _video = bool(flags & 4)
        _call_id = reader.read_long()
        if flags & 1:
            _reason = reader.tgread_object()
        else:
            _reason = None
        if flags & 2:
            _duration = reader.read_int()
        else:
            _duration = None
        return cls(call_id=_call_id, video=_video, reason=_reason, duration=_duration)


class MessageActionPinMessage(TLObject):
    CONSTRUCTOR_ID = 0x94bd38ed
    SUBCLASS_OF_ID = 0x8680d126

    def to_dict(self):
        return {
            '_': 'MessageActionPinMessage'
        }

    def _bytes(self):
        return b''.join((
            b'\xed8\xbd\x94',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class MessageActionRequestedPeer(TLObject):
    CONSTRUCTOR_ID = 0xfe77345d
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, button_id: int, peer: 'TypePeer'):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest, MessageActionWebViewDataSentMe, MessageActionWebViewDataSent, MessageActionGiftPremium, MessageActionTopicCreate, MessageActionTopicEdit, MessageActionSuggestProfilePhoto, MessageActionRequestedPeer, MessageActionSetChatWallPaper, MessageActionSetSameChatWallPaper, MessageActionGiftCode, MessageActionGiveawayLaunch.
        """
        self.button_id = button_id
        self.peer = peer

    def to_dict(self):
        return {
            '_': 'MessageActionRequestedPeer',
            'button_id': self.button_id,
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer
        }

    def _bytes(self):
        return b''.join((
            b']4w\xfe',
            struct.pack('<i', self.button_id),
            self.peer._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _button_id = reader.read_int()
        _peer = reader.tgread_object()
        return cls(button_id=_button_id, peer=_peer)


class MessageActionScreenshotTaken(TLObject):
    CONSTRUCTOR_ID = 0x4792929b
    SUBCLASS_OF_ID = 0x8680d126

    def to_dict(self):
        return {
            '_': 'MessageActionScreenshotTaken'
        }

    def _bytes(self):
        return b''.join((
            b'\x9b\x92\x92G',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class MessageActionSecureValuesSent(TLObject):
    CONSTRUCTOR_ID = 0xd95c6154
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, types: List['TypeSecureValueType']):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest, MessageActionWebViewDataSentMe, MessageActionWebViewDataSent, MessageActionGiftPremium, MessageActionTopicCreate, MessageActionTopicEdit, MessageActionSuggestProfilePhoto, MessageActionRequestedPeer, MessageActionSetChatWallPaper, MessageActionSetSameChatWallPaper, MessageActionGiftCode, MessageActionGiveawayLaunch.
        """
        self.types = types

    def to_dict(self):
        return {
            '_': 'MessageActionSecureValuesSent',
            'types': [] if self.types is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.types]
        }

    def _bytes(self):
        return b''.join((
            b'Ta\\\xd9',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.types)),b''.join(x._bytes() for x in self.types),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _types = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _types.append(_x)

        return cls(types=_types)


class MessageActionSecureValuesSentMe(TLObject):
    CONSTRUCTOR_ID = 0x1b287353
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, values: List['TypeSecureValue'], credentials: 'TypeSecureCredentialsEncrypted'):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest, MessageActionWebViewDataSentMe, MessageActionWebViewDataSent, MessageActionGiftPremium, MessageActionTopicCreate, MessageActionTopicEdit, MessageActionSuggestProfilePhoto, MessageActionRequestedPeer, MessageActionSetChatWallPaper, MessageActionSetSameChatWallPaper, MessageActionGiftCode, MessageActionGiveawayLaunch.
        """
        self.values = values
        self.credentials = credentials

    def to_dict(self):
        return {
            '_': 'MessageActionSecureValuesSentMe',
            'values': [] if self.values is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.values],
            'credentials': self.credentials.to_dict() if isinstance(self.credentials, TLObject) else self.credentials
        }

    def _bytes(self):
        return b''.join((
            b'Ss(\x1b',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.values)),b''.join(x._bytes() for x in self.values),
            self.credentials._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _values = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _values.append(_x)

        _credentials = reader.tgread_object()
        return cls(values=_values, credentials=_credentials)


class MessageActionSetChatTheme(TLObject):
    CONSTRUCTOR_ID = 0xaa786345
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, emoticon: str):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest, MessageActionWebViewDataSentMe, MessageActionWebViewDataSent, MessageActionGiftPremium, MessageActionTopicCreate, MessageActionTopicEdit, MessageActionSuggestProfilePhoto, MessageActionRequestedPeer, MessageActionSetChatWallPaper, MessageActionSetSameChatWallPaper, MessageActionGiftCode, MessageActionGiveawayLaunch.
        """
        self.emoticon = emoticon

    def to_dict(self):
        return {
            '_': 'MessageActionSetChatTheme',
            'emoticon': self.emoticon
        }

    def _bytes(self):
        return b''.join((
            b'Ecx\xaa',
            self.serialize_bytes(self.emoticon),
        ))

    @classmethod
    def from_reader(cls, reader):
        _emoticon = reader.tgread_string()
        return cls(emoticon=_emoticon)


class MessageActionSetChatWallPaper(TLObject):
    CONSTRUCTOR_ID = 0xbc44a927
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, wallpaper: 'TypeWallPaper'):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest, MessageActionWebViewDataSentMe, MessageActionWebViewDataSent, MessageActionGiftPremium, MessageActionTopicCreate, MessageActionTopicEdit, MessageActionSuggestProfilePhoto, MessageActionRequestedPeer, MessageActionSetChatWallPaper, MessageActionSetSameChatWallPaper, MessageActionGiftCode, MessageActionGiveawayLaunch.
        """
        self.wallpaper = wallpaper

    def to_dict(self):
        return {
            '_': 'MessageActionSetChatWallPaper',
            'wallpaper': self.wallpaper.to_dict() if isinstance(self.wallpaper, TLObject) else self.wallpaper
        }

    def _bytes(self):
        return b''.join((
            b"'\xa9D\xbc",
            self.wallpaper._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _wallpaper = reader.tgread_object()
        return cls(wallpaper=_wallpaper)


class MessageActionSetMessagesTTL(TLObject):
    CONSTRUCTOR_ID = 0x3c134d7b
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, period: int, auto_setting_from: Optional[int]=None):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest, MessageActionWebViewDataSentMe, MessageActionWebViewDataSent, MessageActionGiftPremium, MessageActionTopicCreate, MessageActionTopicEdit, MessageActionSuggestProfilePhoto, MessageActionRequestedPeer, MessageActionSetChatWallPaper, MessageActionSetSameChatWallPaper, MessageActionGiftCode, MessageActionGiveawayLaunch.
        """
        self.period = period
        self.auto_setting_from = auto_setting_from

    def to_dict(self):
        return {
            '_': 'MessageActionSetMessagesTTL',
            'period': self.period,
            'auto_setting_from': self.auto_setting_from
        }

    def _bytes(self):
        return b''.join((
            b'{M\x13<',
            struct.pack('<I', (0 if self.auto_setting_from is None or self.auto_setting_from is False else 1)),
            struct.pack('<i', self.period),
            b'' if self.auto_setting_from is None or self.auto_setting_from is False else (struct.pack('<q', self.auto_setting_from)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _period = reader.read_int()
        if flags & 1:
            _auto_setting_from = reader.read_long()
        else:
            _auto_setting_from = None
        return cls(period=_period, auto_setting_from=_auto_setting_from)


class MessageActionSetSameChatWallPaper(TLObject):
    CONSTRUCTOR_ID = 0xc0787d6d
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, wallpaper: 'TypeWallPaper'):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest, MessageActionWebViewDataSentMe, MessageActionWebViewDataSent, MessageActionGiftPremium, MessageActionTopicCreate, MessageActionTopicEdit, MessageActionSuggestProfilePhoto, MessageActionRequestedPeer, MessageActionSetChatWallPaper, MessageActionSetSameChatWallPaper, MessageActionGiftCode, MessageActionGiveawayLaunch.
        """
        self.wallpaper = wallpaper

    def to_dict(self):
        return {
            '_': 'MessageActionSetSameChatWallPaper',
            'wallpaper': self.wallpaper.to_dict() if isinstance(self.wallpaper, TLObject) else self.wallpaper
        }

    def _bytes(self):
        return b''.join((
            b'm}x\xc0',
            self.wallpaper._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _wallpaper = reader.tgread_object()
        return cls(wallpaper=_wallpaper)


class MessageActionSuggestProfilePhoto(TLObject):
    CONSTRUCTOR_ID = 0x57de635e
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, photo: 'TypePhoto'):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest, MessageActionWebViewDataSentMe, MessageActionWebViewDataSent, MessageActionGiftPremium, MessageActionTopicCreate, MessageActionTopicEdit, MessageActionSuggestProfilePhoto, MessageActionRequestedPeer, MessageActionSetChatWallPaper, MessageActionSetSameChatWallPaper, MessageActionGiftCode, MessageActionGiveawayLaunch.
        """
        self.photo = photo

    def to_dict(self):
        return {
            '_': 'MessageActionSuggestProfilePhoto',
            'photo': self.photo.to_dict() if isinstance(self.photo, TLObject) else self.photo
        }

    def _bytes(self):
        return b''.join((
            b'^c\xdeW',
            self.photo._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _photo = reader.tgread_object()
        return cls(photo=_photo)


class MessageActionTopicCreate(TLObject):
    CONSTRUCTOR_ID = 0xd999256
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, title: str, icon_color: int, icon_emoji_id: Optional[int]=None):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest, MessageActionWebViewDataSentMe, MessageActionWebViewDataSent, MessageActionGiftPremium, MessageActionTopicCreate, MessageActionTopicEdit, MessageActionSuggestProfilePhoto, MessageActionRequestedPeer, MessageActionSetChatWallPaper, MessageActionSetSameChatWallPaper, MessageActionGiftCode, MessageActionGiveawayLaunch.
        """
        self.title = title
        self.icon_color = icon_color
        self.icon_emoji_id = icon_emoji_id

    def to_dict(self):
        return {
            '_': 'MessageActionTopicCreate',
            'title': self.title,
            'icon_color': self.icon_color,
            'icon_emoji_id': self.icon_emoji_id
        }

    def _bytes(self):
        return b''.join((
            b'V\x92\x99\r',
            struct.pack('<I', (0 if self.icon_emoji_id is None or self.icon_emoji_id is False else 1)),
            self.serialize_bytes(self.title),
            struct.pack('<i', self.icon_color),
            b'' if self.icon_emoji_id is None or self.icon_emoji_id is False else (struct.pack('<q', self.icon_emoji_id)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _title = reader.tgread_string()
        _icon_color = reader.read_int()
        if flags & 1:
            _icon_emoji_id = reader.read_long()
        else:
            _icon_emoji_id = None
        return cls(title=_title, icon_color=_icon_color, icon_emoji_id=_icon_emoji_id)


class MessageActionTopicEdit(TLObject):
    CONSTRUCTOR_ID = 0xc0944820
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, title: Optional[str]=None, icon_emoji_id: Optional[int]=None, closed: Optional[bool]=None, hidden: Optional[bool]=None):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest, MessageActionWebViewDataSentMe, MessageActionWebViewDataSent, MessageActionGiftPremium, MessageActionTopicCreate, MessageActionTopicEdit, MessageActionSuggestProfilePhoto, MessageActionRequestedPeer, MessageActionSetChatWallPaper, MessageActionSetSameChatWallPaper, MessageActionGiftCode, MessageActionGiveawayLaunch.
        """
        self.title = title
        self.icon_emoji_id = icon_emoji_id
        self.closed = closed
        self.hidden = hidden

    def to_dict(self):
        return {
            '_': 'MessageActionTopicEdit',
            'title': self.title,
            'icon_emoji_id': self.icon_emoji_id,
            'closed': self.closed,
            'hidden': self.hidden
        }

    def _bytes(self):
        return b''.join((
            b' H\x94\xc0',
            struct.pack('<I', (0 if self.title is None or self.title is False else 1) | (0 if self.icon_emoji_id is None or self.icon_emoji_id is False else 2) | (0 if self.closed is None else 4) | (0 if self.hidden is None else 8)),
            b'' if self.title is None or self.title is False else (self.serialize_bytes(self.title)),
            b'' if self.icon_emoji_id is None or self.icon_emoji_id is False else (struct.pack('<q', self.icon_emoji_id)),
            b'' if self.closed is None else (b'\xb5ur\x99' if self.closed else b'7\x97y\xbc'),
            b'' if self.hidden is None else (b'\xb5ur\x99' if self.hidden else b'7\x97y\xbc'),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 1:
            _title = reader.tgread_string()
        else:
            _title = None
        if flags & 2:
            _icon_emoji_id = reader.read_long()
        else:
            _icon_emoji_id = None
        if flags & 4:
            _closed = reader.tgread_bool()
        else:
            _closed = None
        if flags & 8:
            _hidden = reader.tgread_bool()
        else:
            _hidden = None
        return cls(title=_title, icon_emoji_id=_icon_emoji_id, closed=_closed, hidden=_hidden)


class MessageActionWebViewDataSent(TLObject):
    CONSTRUCTOR_ID = 0xb4c38cb5
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, text: str):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest, MessageActionWebViewDataSentMe, MessageActionWebViewDataSent, MessageActionGiftPremium, MessageActionTopicCreate, MessageActionTopicEdit, MessageActionSuggestProfilePhoto, MessageActionRequestedPeer, MessageActionSetChatWallPaper, MessageActionSetSameChatWallPaper, MessageActionGiftCode, MessageActionGiveawayLaunch.
        """
        self.text = text

    def to_dict(self):
        return {
            '_': 'MessageActionWebViewDataSent',
            'text': self.text
        }

    def _bytes(self):
        return b''.join((
            b'\xb5\x8c\xc3\xb4',
            self.serialize_bytes(self.text),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_string()
        return cls(text=_text)


class MessageActionWebViewDataSentMe(TLObject):
    CONSTRUCTOR_ID = 0x47dd8079
    SUBCLASS_OF_ID = 0x8680d126

    def __init__(self, text: str, data: str):
        """
        Constructor for MessageAction: Instance of either MessageActionEmpty, MessageActionChatCreate, MessageActionChatEditTitle, MessageActionChatEditPhoto, MessageActionChatDeletePhoto, MessageActionChatAddUser, MessageActionChatDeleteUser, MessageActionChatJoinedByLink, MessageActionChannelCreate, MessageActionChatMigrateTo, MessageActionChannelMigrateFrom, MessageActionPinMessage, MessageActionHistoryClear, MessageActionGameScore, MessageActionPaymentSentMe, MessageActionPaymentSent, MessageActionPhoneCall, MessageActionScreenshotTaken, MessageActionCustomAction, MessageActionBotAllowed, MessageActionSecureValuesSentMe, MessageActionSecureValuesSent, MessageActionContactSignUp, MessageActionGeoProximityReached, MessageActionGroupCall, MessageActionInviteToGroupCall, MessageActionSetMessagesTTL, MessageActionGroupCallScheduled, MessageActionSetChatTheme, MessageActionChatJoinedByRequest, MessageActionWebViewDataSentMe, MessageActionWebViewDataSent, MessageActionGiftPremium, MessageActionTopicCreate, MessageActionTopicEdit, MessageActionSuggestProfilePhoto, MessageActionRequestedPeer, MessageActionSetChatWallPaper, MessageActionSetSameChatWallPaper, MessageActionGiftCode, MessageActionGiveawayLaunch.
        """
        self.text = text
        self.data = data

    def to_dict(self):
        return {
            '_': 'MessageActionWebViewDataSentMe',
            'text': self.text,
            'data': self.data
        }

    def _bytes(self):
        return b''.join((
            b'y\x80\xddG',
            self.serialize_bytes(self.text),
            self.serialize_bytes(self.data),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_string()
        _data = reader.tgread_string()
        return cls(text=_text, data=_data)


class MessageEmpty(TLObject):
    CONSTRUCTOR_ID = 0x90a6ca84
    SUBCLASS_OF_ID = 0x790009e3

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, peer_id: Optional['TypePeer']=None):
        """
        Constructor for Message: Instance of either MessageEmpty, Message, MessageService.
        """
        self.id = id
        self.peer_id = peer_id

    def to_dict(self):
        return {
            '_': 'MessageEmpty',
            'id': self.id,
            'peer_id': self.peer_id.to_dict() if isinstance(self.peer_id, TLObject) else self.peer_id
        }

    def _bytes(self):
        return b''.join((
            b'\x84\xca\xa6\x90',
            struct.pack('<I', (0 if self.peer_id is None or self.peer_id is False else 1)),
            struct.pack('<i', self.id),
            b'' if self.peer_id is None or self.peer_id is False else (self.peer_id._bytes()),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _id = reader.read_int()
        if flags & 1:
            _peer_id = reader.tgread_object()
        else:
            _peer_id = None
        return cls(id=_id, peer_id=_peer_id)


class MessageEntityBankCard(TLObject):
    CONSTRUCTOR_ID = 0x761e6af4
    SUBCLASS_OF_ID = 0xcf6419dc

    def __init__(self, offset: int, length: int):
        """
        Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBankCard, MessageEntitySpoiler, MessageEntityCustomEmoji, MessageEntityBlockquote.
        """
        self.offset = offset
        self.length = length

    def to_dict(self):
        return {
            '_': 'MessageEntityBankCard',
            'offset': self.offset,
            'length': self.length
        }

    def _bytes(self):
        return b''.join((
            b'\xf4j\x1ev',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


class MessageEntityBlockquote(TLObject):
    CONSTRUCTOR_ID = 0x20df5d0
    SUBCLASS_OF_ID = 0xcf6419dc

    def __init__(self, offset: int, length: int):
        """
        Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBankCard, MessageEntitySpoiler, MessageEntityCustomEmoji, MessageEntityBlockquote.
        """
        self.offset = offset
        self.length = length

    def to_dict(self):
        return {
            '_': 'MessageEntityBlockquote',
            'offset': self.offset,
            'length': self.length
        }

    def _bytes(self):
        return b''.join((
            b'\xd0\xf5\r\x02',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


class MessageEntityBold(TLObject):
    CONSTRUCTOR_ID = 0xbd610bc9
    SUBCLASS_OF_ID = 0xcf6419dc

    def __init__(self, offset: int, length: int):
        """
        Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBankCard, MessageEntitySpoiler, MessageEntityCustomEmoji, MessageEntityBlockquote.
        """
        self.offset = offset
        self.length = length

    def to_dict(self):
        return {
            '_': 'MessageEntityBold',
            'offset': self.offset,
            'length': self.length
        }

    def _bytes(self):
        return b''.join((
            b'\xc9\x0ba\xbd',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


class MessageEntityBotCommand(TLObject):
    CONSTRUCTOR_ID = 0x6cef8ac7
    SUBCLASS_OF_ID = 0xcf6419dc

    def __init__(self, offset: int, length: int):
        """
        Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBankCard, MessageEntitySpoiler, MessageEntityCustomEmoji, MessageEntityBlockquote.
        """
        self.offset = offset
        self.length = length

    def to_dict(self):
        return {
            '_': 'MessageEntityBotCommand',
            'offset': self.offset,
            'length': self.length
        }

    def _bytes(self):
        return b''.join((
            b'\xc7\x8a\xefl',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


class MessageEntityCashtag(TLObject):
    CONSTRUCTOR_ID = 0x4c4e743f
    SUBCLASS_OF_ID = 0xcf6419dc

    def __init__(self, offset: int, length: int):
        """
        Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBankCard, MessageEntitySpoiler, MessageEntityCustomEmoji, MessageEntityBlockquote.
        """
        self.offset = offset
        self.length = length

    def to_dict(self):
        return {
            '_': 'MessageEntityCashtag',
            'offset': self.offset,
            'length': self.length
        }

    def _bytes(self):
        return b''.join((
            b'?tNL',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


class MessageEntityCode(TLObject):
    CONSTRUCTOR_ID = 0x28a20571
    SUBCLASS_OF_ID = 0xcf6419dc

    def __init__(self, offset: int, length: int):
        """
        Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBankCard, MessageEntitySpoiler, MessageEntityCustomEmoji, MessageEntityBlockquote.
        """
        self.offset = offset
        self.length = length

    def to_dict(self):
        return {
            '_': 'MessageEntityCode',
            'offset': self.offset,
            'length': self.length
        }

    def _bytes(self):
        return b''.join((
            b'q\x05\xa2(',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


class MessageEntityCustomEmoji(TLObject):
    CONSTRUCTOR_ID = 0xc8cf05f8
    SUBCLASS_OF_ID = 0xcf6419dc

    def __init__(self, offset: int, length: int, document_id: int):
        """
        Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBankCard, MessageEntitySpoiler, MessageEntityCustomEmoji, MessageEntityBlockquote.
        """
        self.offset = offset
        self.length = length
        self.document_id = document_id

    def to_dict(self):
        return {
            '_': 'MessageEntityCustomEmoji',
            'offset': self.offset,
            'length': self.length,
            'document_id': self.document_id
        }

    def _bytes(self):
        return b''.join((
            b'\xf8\x05\xcf\xc8',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
            struct.pack('<q', self.document_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        _document_id = reader.read_long()
        return cls(offset=_offset, length=_length, document_id=_document_id)


class MessageEntityEmail(TLObject):
    CONSTRUCTOR_ID = 0x64e475c2
    SUBCLASS_OF_ID = 0xcf6419dc

    def __init__(self, offset: int, length: int):
        """
        Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBankCard, MessageEntitySpoiler, MessageEntityCustomEmoji, MessageEntityBlockquote.
        """
        self.offset = offset
        self.length = length

    def to_dict(self):
        return {
            '_': 'MessageEntityEmail',
            'offset': self.offset,
            'length': self.length
        }

    def _bytes(self):
        return b''.join((
            b'\xc2u\xe4d',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


class MessageEntityHashtag(TLObject):
    CONSTRUCTOR_ID = 0x6f635b0d
    SUBCLASS_OF_ID = 0xcf6419dc

    def __init__(self, offset: int, length: int):
        """
        Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBankCard, MessageEntitySpoiler, MessageEntityCustomEmoji, MessageEntityBlockquote.
        """
        self.offset = offset
        self.length = length

    def to_dict(self):
        return {
            '_': 'MessageEntityHashtag',
            'offset': self.offset,
            'length': self.length
        }

    def _bytes(self):
        return b''.join((
            b'\r[co',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


class MessageEntityItalic(TLObject):
    CONSTRUCTOR_ID = 0x826f8b60
    SUBCLASS_OF_ID = 0xcf6419dc

    def __init__(self, offset: int, length: int):
        """
        Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBankCard, MessageEntitySpoiler, MessageEntityCustomEmoji, MessageEntityBlockquote.
        """
        self.offset = offset
        self.length = length

    def to_dict(self):
        return {
            '_': 'MessageEntityItalic',
            'offset': self.offset,
            'length': self.length
        }

    def _bytes(self):
        return b''.join((
            b'`\x8bo\x82',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


class MessageEntityMention(TLObject):
    CONSTRUCTOR_ID = 0xfa04579d
    SUBCLASS_OF_ID = 0xcf6419dc

    def __init__(self, offset: int, length: int):
        """
        Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBankCard, MessageEntitySpoiler, MessageEntityCustomEmoji, MessageEntityBlockquote.
        """
        self.offset = offset
        self.length = length

    def to_dict(self):
        return {
            '_': 'MessageEntityMention',
            'offset': self.offset,
            'length': self.length
        }

    def _bytes(self):
        return b''.join((
            b'\x9dW\x04\xfa',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


class MessageEntityMentionName(TLObject):
    CONSTRUCTOR_ID = 0xdc7b1140
    SUBCLASS_OF_ID = 0xcf6419dc

    def __init__(self, offset: int, length: int, user_id: int):
        """
        Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBankCard, MessageEntitySpoiler, MessageEntityCustomEmoji, MessageEntityBlockquote.
        """
        self.offset = offset
        self.length = length
        self.user_id = user_id

    def to_dict(self):
        return {
            '_': 'MessageEntityMentionName',
            'offset': self.offset,
            'length': self.length,
            'user_id': self.user_id
        }

    def _bytes(self):
        return b''.join((
            b'@\x11{\xdc',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
            struct.pack('<q', self.user_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        _user_id = reader.read_long()
        return cls(offset=_offset, length=_length, user_id=_user_id)


class MessageEntityPhone(TLObject):
    CONSTRUCTOR_ID = 0x9b69e34b
    SUBCLASS_OF_ID = 0xcf6419dc

    def __init__(self, offset: int, length: int):
        """
        Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBankCard, MessageEntitySpoiler, MessageEntityCustomEmoji, MessageEntityBlockquote.
        """
        self.offset = offset
        self.length = length

    def to_dict(self):
        return {
            '_': 'MessageEntityPhone',
            'offset': self.offset,
            'length': self.length
        }

    def _bytes(self):
        return b''.join((
            b'K\xe3i\x9b',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


class MessageEntityPre(TLObject):
    CONSTRUCTOR_ID = 0x73924be0
    SUBCLASS_OF_ID = 0xcf6419dc

    def __init__(self, offset: int, length: int, language: str):
        """
        Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBankCard, MessageEntitySpoiler, MessageEntityCustomEmoji, MessageEntityBlockquote.
        """
        self.offset = offset
        self.length = length
        self.language = language

    def to_dict(self):
        return {
            '_': 'MessageEntityPre',
            'offset': self.offset,
            'length': self.length,
            'language': self.language
        }

    def _bytes(self):
        return b''.join((
            b'\xe0K\x92s',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
            self.serialize_bytes(self.language),
        ))

    @classmethod
    def from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        _language = reader.tgread_string()
        return cls(offset=_offset, length=_length, language=_language)


class MessageEntitySpoiler(TLObject):
    CONSTRUCTOR_ID = 0x32ca960f
    SUBCLASS_OF_ID = 0xcf6419dc

    def __init__(self, offset: int, length: int):
        """
        Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBankCard, MessageEntitySpoiler, MessageEntityCustomEmoji, MessageEntityBlockquote.
        """
        self.offset = offset
        self.length = length

    def to_dict(self):
        return {
            '_': 'MessageEntitySpoiler',
            'offset': self.offset,
            'length': self.length
        }

    def _bytes(self):
        return b''.join((
            b'\x0f\x96\xca2',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


class MessageEntityStrike(TLObject):
    CONSTRUCTOR_ID = 0xbf0693d4
    SUBCLASS_OF_ID = 0xcf6419dc

    def __init__(self, offset: int, length: int):
        """
        Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBankCard, MessageEntitySpoiler, MessageEntityCustomEmoji, MessageEntityBlockquote.
        """
        self.offset = offset
        self.length = length

    def to_dict(self):
        return {
            '_': 'MessageEntityStrike',
            'offset': self.offset,
            'length': self.length
        }

    def _bytes(self):
        return b''.join((
            b'\xd4\x93\x06\xbf',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


class MessageEntityTextUrl(TLObject):
    CONSTRUCTOR_ID = 0x76a6d327
    SUBCLASS_OF_ID = 0xcf6419dc

    def __init__(self, offset: int, length: int, url: str):
        """
        Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBankCard, MessageEntitySpoiler, MessageEntityCustomEmoji, MessageEntityBlockquote.
        """
        self.offset = offset
        self.length = length
        self.url = url

    def to_dict(self):
        return {
            '_': 'MessageEntityTextUrl',
            'offset': self.offset,
            'length': self.length,
            'url': self.url
        }

    def _bytes(self):
        return b''.join((
            b"'\xd3\xa6v",
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
            self.serialize_bytes(self.url),
        ))

    @classmethod
    def from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        _url = reader.tgread_string()
        return cls(offset=_offset, length=_length, url=_url)


class MessageEntityUnderline(TLObject):
    CONSTRUCTOR_ID = 0x9c4e7e8b
    SUBCLASS_OF_ID = 0xcf6419dc

    def __init__(self, offset: int, length: int):
        """
        Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBankCard, MessageEntitySpoiler, MessageEntityCustomEmoji, MessageEntityBlockquote.
        """
        self.offset = offset
        self.length = length

    def to_dict(self):
        return {
            '_': 'MessageEntityUnderline',
            'offset': self.offset,
            'length': self.length
        }

    def _bytes(self):
        return b''.join((
            b'\x8b~N\x9c',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


class MessageEntityUnknown(TLObject):
    CONSTRUCTOR_ID = 0xbb92ba95
    SUBCLASS_OF_ID = 0xcf6419dc

    def __init__(self, offset: int, length: int):
        """
        Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBankCard, MessageEntitySpoiler, MessageEntityCustomEmoji, MessageEntityBlockquote.
        """
        self.offset = offset
        self.length = length

    def to_dict(self):
        return {
            '_': 'MessageEntityUnknown',
            'offset': self.offset,
            'length': self.length
        }

    def _bytes(self):
        return b''.join((
            b'\x95\xba\x92\xbb',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


class MessageEntityUrl(TLObject):
    CONSTRUCTOR_ID = 0x6ed02538
    SUBCLASS_OF_ID = 0xcf6419dc

    def __init__(self, offset: int, length: int):
        """
        Constructor for MessageEntity: Instance of either MessageEntityUnknown, MessageEntityMention, MessageEntityHashtag, MessageEntityBotCommand, MessageEntityUrl, MessageEntityEmail, MessageEntityBold, MessageEntityItalic, MessageEntityCode, MessageEntityPre, MessageEntityTextUrl, MessageEntityMentionName, InputMessageEntityMentionName, MessageEntityPhone, MessageEntityCashtag, MessageEntityUnderline, MessageEntityStrike, MessageEntityBankCard, MessageEntitySpoiler, MessageEntityCustomEmoji, MessageEntityBlockquote.
        """
        self.offset = offset
        self.length = length

    def to_dict(self):
        return {
            '_': 'MessageEntityUrl',
            'offset': self.offset,
            'length': self.length
        }

    def _bytes(self):
        return b''.join((
            b'8%\xd0n',
            struct.pack('<i', self.offset),
            struct.pack('<i', self.length),
        ))

    @classmethod
    def from_reader(cls, reader):
        _offset = reader.read_int()
        _length = reader.read_int()
        return cls(offset=_offset, length=_length)


class MessageExtendedMedia(TLObject):
    CONSTRUCTOR_ID = 0xee479c64
    SUBCLASS_OF_ID = 0x9727d95d

    def __init__(self, media: 'TypeMessageMedia'):
        """
        Constructor for MessageExtendedMedia: Instance of either MessageExtendedMediaPreview, MessageExtendedMedia.
        """
        self.media = media

    def to_dict(self):
        return {
            '_': 'MessageExtendedMedia',
            'media': self.media.to_dict() if isinstance(self.media, TLObject) else self.media
        }

    def _bytes(self):
        return b''.join((
            b'd\x9cG\xee',
            self.media._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _media = reader.tgread_object()
        return cls(media=_media)


class MessageExtendedMediaPreview(TLObject):
    CONSTRUCTOR_ID = 0xad628cc8
    SUBCLASS_OF_ID = 0x9727d95d

    def __init__(self, w: Optional[int]=None, h: Optional[int]=None, thumb: Optional['TypePhotoSize']=None, video_duration: Optional[int]=None):
        """
        Constructor for MessageExtendedMedia: Instance of either MessageExtendedMediaPreview, MessageExtendedMedia.
        """
        self.w = w
        self.h = h
        self.thumb = thumb
        self.video_duration = video_duration

    def to_dict(self):
        return {
            '_': 'MessageExtendedMediaPreview',
            'w': self.w,
            'h': self.h,
            'thumb': self.thumb.to_dict() if isinstance(self.thumb, TLObject) else self.thumb,
            'video_duration': self.video_duration
        }

    def _bytes(self):
        assert ((self.w or self.w is not None) and (self.h or self.h is not None)) or ((self.w is None or self.w is False) and (self.h is None or self.h is False)), 'w, h parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'\xc8\x8cb\xad',
            struct.pack('<I', (0 if self.w is None or self.w is False else 1) | (0 if self.h is None or self.h is False else 1) | (0 if self.thumb is None or self.thumb is False else 2) | (0 if self.video_duration is None or self.video_duration is False else 4)),
            b'' if self.w is None or self.w is False else (struct.pack('<i', self.w)),
            b'' if self.h is None or self.h is False else (struct.pack('<i', self.h)),
            b'' if self.thumb is None or self.thumb is False else (self.thumb._bytes()),
            b'' if self.video_duration is None or self.video_duration is False else (struct.pack('<i', self.video_duration)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 1:
            _w = reader.read_int()
        else:
            _w = None
        if flags & 1:
            _h = reader.read_int()
        else:
            _h = None
        if flags & 2:
            _thumb = reader.tgread_object()
        else:
            _thumb = None
        if flags & 4:
            _video_duration = reader.read_int()
        else:
            _video_duration = None
        return cls(w=_w, h=_h, thumb=_thumb, video_duration=_video_duration)


class MessageFwdHeader(TLObject):
    CONSTRUCTOR_ID = 0x5f777dce
    SUBCLASS_OF_ID = 0x7a286804

    def __init__(self, date: Optional[datetime], imported: Optional[bool]=None, from_id: Optional['TypePeer']=None, from_name: Optional[str]=None, channel_post: Optional[int]=None, post_author: Optional[str]=None, saved_from_peer: Optional['TypePeer']=None, saved_from_msg_id: Optional[int]=None, psa_type: Optional[str]=None):
        """
        Constructor for MessageFwdHeader: Instance of MessageFwdHeader.
        """
        self.date = date
        self.imported = imported
        self.from_id = from_id
        self.from_name = from_name
        self.channel_post = channel_post
        self.post_author = post_author
        self.saved_from_peer = saved_from_peer
        self.saved_from_msg_id = saved_from_msg_id
        self.psa_type = psa_type

    def to_dict(self):
        return {
            '_': 'MessageFwdHeader',
            'date': self.date,
            'imported': self.imported,
            'from_id': self.from_id.to_dict() if isinstance(self.from_id, TLObject) else self.from_id,
            'from_name': self.from_name,
            'channel_post': self.channel_post,
            'post_author': self.post_author,
            'saved_from_peer': self.saved_from_peer.to_dict() if isinstance(self.saved_from_peer, TLObject) else self.saved_from_peer,
            'saved_from_msg_id': self.saved_from_msg_id,
            'psa_type': self.psa_type
        }

    def _bytes(self):
        assert ((self.saved_from_peer or self.saved_from_peer is not None) and (self.saved_from_msg_id or self.saved_from_msg_id is not None)) or ((self.saved_from_peer is None or self.saved_from_peer is False) and (self.saved_from_msg_id is None or self.saved_from_msg_id is False)), 'saved_from_peer, saved_from_msg_id parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'\xce}w_',
            struct.pack('<I', (0 if self.imported is None or self.imported is False else 128) | (0 if self.from_id is None or self.from_id is False else 1) | (0 if self.from_name is None or self.from_name is False else 32) | (0 if self.channel_post is None or self.channel_post is False else 4) | (0 if self.post_author is None or self.post_author is False else 8) | (0 if self.saved_from_peer is None or self.saved_from_peer is False else 16) | (0 if self.saved_from_msg_id is None or self.saved_from_msg_id is False else 16) | (0 if self.psa_type is None or self.psa_type is False else 64)),
            b'' if self.from_id is None or self.from_id is False else (self.from_id._bytes()),
            b'' if self.from_name is None or self.from_name is False else (self.serialize_bytes(self.from_name)),
            self.serialize_datetime(self.date),
            b'' if self.channel_post is None or self.channel_post is False else (struct.pack('<i', self.channel_post)),
            b'' if self.post_author is None or self.post_author is False else (self.serialize_bytes(self.post_author)),
            b'' if self.saved_from_peer is None or self.saved_from_peer is False else (self.saved_from_peer._bytes()),
            b'' if self.saved_from_msg_id is None or self.saved_from_msg_id is False else (struct.pack('<i', self.saved_from_msg_id)),
            b'' if self.psa_type is None or self.psa_type is False else (self.serialize_bytes(self.psa_type)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _imported = bool(flags & 128)
        if flags & 1:
            _from_id = reader.tgread_object()
        else:
            _from_id = None
        if flags & 32:
            _from_name = reader.tgread_string()
        else:
            _from_name = None
        _date = reader.tgread_date()
        if flags & 4:
            _channel_post = reader.read_int()
        else:
            _channel_post = None
        if flags & 8:
            _post_author = reader.tgread_string()
        else:
            _post_author = None
        if flags & 16:
            _saved_from_peer = reader.tgread_object()
        else:
            _saved_from_peer = None
        if flags & 16:
            _saved_from_msg_id = reader.read_int()
        else:
            _saved_from_msg_id = None
        if flags & 64:
            _psa_type = reader.tgread_string()
        else:
            _psa_type = None
        return cls(date=_date, imported=_imported, from_id=_from_id, from_name=_from_name, channel_post=_channel_post, post_author=_post_author, saved_from_peer=_saved_from_peer, saved_from_msg_id=_saved_from_msg_id, psa_type=_psa_type)


class MessageInteractionCounters(TLObject):
    CONSTRUCTOR_ID = 0xad4fc9bd
    SUBCLASS_OF_ID = 0x2638b720

    def __init__(self, msg_id: int, views: int, forwards: int):
        """
        Constructor for MessageInteractionCounters: Instance of MessageInteractionCounters.
        """
        self.msg_id = msg_id
        self.views = views
        self.forwards = forwards

    def to_dict(self):
        return {
            '_': 'MessageInteractionCounters',
            'msg_id': self.msg_id,
            'views': self.views,
            'forwards': self.forwards
        }

    def _bytes(self):
        return b''.join((
            b'\xbd\xc9O\xad',
            struct.pack('<i', self.msg_id),
            struct.pack('<i', self.views),
            struct.pack('<i', self.forwards),
        ))

    @classmethod
    def from_reader(cls, reader):
        _msg_id = reader.read_int()
        _views = reader.read_int()
        _forwards = reader.read_int()
        return cls(msg_id=_msg_id, views=_views, forwards=_forwards)


class MessageMediaContact(TLObject):
    CONSTRUCTOR_ID = 0x70322949
    SUBCLASS_OF_ID = 0x476cbe32

    def __init__(self, phone_number: str, first_name: str, last_name: str, vcard: str, user_id: int):
        """
        Constructor for MessageMedia: Instance of either MessageMediaEmpty, MessageMediaPhoto, MessageMediaGeo, MessageMediaContact, MessageMediaUnsupported, MessageMediaDocument, MessageMediaWebPage, MessageMediaVenue, MessageMediaGame, MessageMediaInvoice, MessageMediaGeoLive, MessageMediaPoll, MessageMediaDice, MessageMediaStory, MessageMediaGiveaway.
        """
        self.phone_number = phone_number
        self.first_name = first_name
        self.last_name = last_name
        self.vcard = vcard
        self.user_id = user_id

    def to_dict(self):
        return {
            '_': 'MessageMediaContact',
            'phone_number': self.phone_number,
            'first_name': self.first_name,
            'last_name': self.last_name,
            'vcard': self.vcard,
            'user_id': self.user_id
        }

    def _bytes(self):
        return b''.join((
            b'I)2p',
            self.serialize_bytes(self.phone_number),
            self.serialize_bytes(self.first_name),
            self.serialize_bytes(self.last_name),
            self.serialize_bytes(self.vcard),
            struct.pack('<q', self.user_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _phone_number = reader.tgread_string()
        _first_name = reader.tgread_string()
        _last_name = reader.tgread_string()
        _vcard = reader.tgread_string()
        _user_id = reader.read_long()
        return cls(phone_number=_phone_number, first_name=_first_name, last_name=_last_name, vcard=_vcard, user_id=_user_id)


class MessageMediaDice(TLObject):
    CONSTRUCTOR_ID = 0x3f7ee58b
    SUBCLASS_OF_ID = 0x476cbe32

    def __init__(self, value: int, emoticon: str):
        """
        Constructor for MessageMedia: Instance of either MessageMediaEmpty, MessageMediaPhoto, MessageMediaGeo, MessageMediaContact, MessageMediaUnsupported, MessageMediaDocument, MessageMediaWebPage, MessageMediaVenue, MessageMediaGame, MessageMediaInvoice, MessageMediaGeoLive, MessageMediaPoll, MessageMediaDice, MessageMediaStory, MessageMediaGiveaway.
        """
        self.value = value
        self.emoticon = emoticon

    def to_dict(self):
        return {
            '_': 'MessageMediaDice',
            'value': self.value,
            'emoticon': self.emoticon
        }

    def _bytes(self):
        return b''.join((
            b'\x8b\xe5~?',
            struct.pack('<i', self.value),
            self.serialize_bytes(self.emoticon),
        ))

    @classmethod
    def from_reader(cls, reader):
        _value = reader.read_int()
        _emoticon = reader.tgread_string()
        return cls(value=_value, emoticon=_emoticon)


class MessageMediaDocument(TLObject):
    CONSTRUCTOR_ID = 0x4cf4d72d
    SUBCLASS_OF_ID = 0x476cbe32

    def __init__(self, nopremium: Optional[bool]=None, spoiler: Optional[bool]=None, document: Optional['TypeDocument']=None, alt_document: Optional['TypeDocument']=None, ttl_seconds: Optional[int]=None):
        """
        Constructor for MessageMedia: Instance of either MessageMediaEmpty, MessageMediaPhoto, MessageMediaGeo, MessageMediaContact, MessageMediaUnsupported, MessageMediaDocument, MessageMediaWebPage, MessageMediaVenue, MessageMediaGame, MessageMediaInvoice, MessageMediaGeoLive, MessageMediaPoll, MessageMediaDice, MessageMediaStory, MessageMediaGiveaway.
        """
        self.nopremium = nopremium
        self.spoiler = spoiler
        self.document = document
        self.alt_document = alt_document
        self.ttl_seconds = ttl_seconds

    def to_dict(self):
        return {
            '_': 'MessageMediaDocument',
            'nopremium': self.nopremium,
            'spoiler': self.spoiler,
            'document': self.document.to_dict() if isinstance(self.document, TLObject) else self.document,
            'alt_document': self.alt_document.to_dict() if isinstance(self.alt_document, TLObject) else self.alt_document,
            'ttl_seconds': self.ttl_seconds
        }

    def _bytes(self):
        return b''.join((
            b'-\xd7\xf4L',
            struct.pack('<I', (0 if self.nopremium is None or self.nopremium is False else 8) | (0 if self.spoiler is None or self.spoiler is False else 16) | (0 if self.document is None or self.document is False else 1) | (0 if self.alt_document is None or self.alt_document is False else 32) | (0 if self.ttl_seconds is None or self.ttl_seconds is False else 4)),
            b'' if self.document is None or self.document is False else (self.document._bytes()),
            b'' if self.alt_document is None or self.alt_document is False else (self.alt_document._bytes()),
            b'' if self.ttl_seconds is None or self.ttl_seconds is False else (struct.pack('<i', self.ttl_seconds)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _nopremium = bool(flags & 8)
        _spoiler = bool(flags & 16)
        if flags & 1:
            _document = reader.tgread_object()
        else:
            _document = None
        if flags & 32:
            _alt_document = reader.tgread_object()
        else:
            _alt_document = None
        if flags & 4:
            _ttl_seconds = reader.read_int()
        else:
            _ttl_seconds = None
        return cls(nopremium=_nopremium, spoiler=_spoiler, document=_document, alt_document=_alt_document, ttl_seconds=_ttl_seconds)


class MessageMediaEmpty(TLObject):
    CONSTRUCTOR_ID = 0x3ded6320
    SUBCLASS_OF_ID = 0x476cbe32

    def to_dict(self):
        return {
            '_': 'MessageMediaEmpty'
        }

    def _bytes(self):
        return b''.join((
            b' c\xed=',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class MessageMediaGame(TLObject):
    CONSTRUCTOR_ID = 0xfdb19008
    SUBCLASS_OF_ID = 0x476cbe32

    def __init__(self, game: 'TypeGame'):
        """
        Constructor for MessageMedia: Instance of either MessageMediaEmpty, MessageMediaPhoto, MessageMediaGeo, MessageMediaContact, MessageMediaUnsupported, MessageMediaDocument, MessageMediaWebPage, MessageMediaVenue, MessageMediaGame, MessageMediaInvoice, MessageMediaGeoLive, MessageMediaPoll, MessageMediaDice, MessageMediaStory, MessageMediaGiveaway.
        """
        self.game = game

    def to_dict(self):
        return {
            '_': 'MessageMediaGame',
            'game': self.game.to_dict() if isinstance(self.game, TLObject) else self.game
        }

    def _bytes(self):
        return b''.join((
            b'\x08\x90\xb1\xfd',
            self.game._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _game = reader.tgread_object()
        return cls(game=_game)


class MessageMediaGeo(TLObject):
    CONSTRUCTOR_ID = 0x56e0d474
    SUBCLASS_OF_ID = 0x476cbe32

    def __init__(self, geo: 'TypeGeoPoint'):
        """
        Constructor for MessageMedia: Instance of either MessageMediaEmpty, MessageMediaPhoto, MessageMediaGeo, MessageMediaContact, MessageMediaUnsupported, MessageMediaDocument, MessageMediaWebPage, MessageMediaVenue, MessageMediaGame, MessageMediaInvoice, MessageMediaGeoLive, MessageMediaPoll, MessageMediaDice, MessageMediaStory, MessageMediaGiveaway.
        """
        self.geo = geo

    def to_dict(self):
        return {
            '_': 'MessageMediaGeo',
            'geo': self.geo.to_dict() if isinstance(self.geo, TLObject) else self.geo
        }

    def _bytes(self):
        return b''.join((
            b't\xd4\xe0V',
            self.geo._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _geo = reader.tgread_object()
        return cls(geo=_geo)


class MessageMediaGeoLive(TLObject):
    CONSTRUCTOR_ID = 0xb940c666
    SUBCLASS_OF_ID = 0x476cbe32

    def __init__(self, geo: 'TypeGeoPoint', period: int, heading: Optional[int]=None, proximity_notification_radius: Optional[int]=None):
        """
        Constructor for MessageMedia: Instance of either MessageMediaEmpty, MessageMediaPhoto, MessageMediaGeo, MessageMediaContact, MessageMediaUnsupported, MessageMediaDocument, MessageMediaWebPage, MessageMediaVenue, MessageMediaGame, MessageMediaInvoice, MessageMediaGeoLive, MessageMediaPoll, MessageMediaDice, MessageMediaStory, MessageMediaGiveaway.
        """
        self.geo = geo
        self.period = period
        self.heading = heading
        self.proximity_notification_radius = proximity_notification_radius

    def to_dict(self):
        return {
            '_': 'MessageMediaGeoLive',
            'geo': self.geo.to_dict() if isinstance(self.geo, TLObject) else self.geo,
            'period': self.period,
            'heading': self.heading,
            'proximity_notification_radius': self.proximity_notification_radius
        }

    def _bytes(self):
        return b''.join((
            b'f\xc6@\xb9',
            struct.pack('<I', (0 if self.heading is None or self.heading is False else 1) | (0 if self.proximity_notification_radius is None or self.proximity_notification_radius is False else 2)),
            self.geo._bytes(),
            b'' if self.heading is None or self.heading is False else (struct.pack('<i', self.heading)),
            struct.pack('<i', self.period),
            b'' if self.proximity_notification_radius is None or self.proximity_notification_radius is False else (struct.pack('<i', self.proximity_notification_radius)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _geo = reader.tgread_object()
        if flags & 1:
            _heading = reader.read_int()
        else:
            _heading = None
        _period = reader.read_int()
        if flags & 2:
            _proximity_notification_radius = reader.read_int()
        else:
            _proximity_notification_radius = None
        return cls(geo=_geo, period=_period, heading=_heading, proximity_notification_radius=_proximity_notification_radius)


class MessageMediaGiveaway(TLObject):
    CONSTRUCTOR_ID = 0x58260664
    SUBCLASS_OF_ID = 0x476cbe32

    def __init__(self, channels: List[int], quantity: int, months: int, until_date: Optional[datetime], only_new_subscribers: Optional[bool]=None, countries_iso2: Optional[List[str]]=None):
        """
        Constructor for MessageMedia: Instance of either MessageMediaEmpty, MessageMediaPhoto, MessageMediaGeo, MessageMediaContact, MessageMediaUnsupported, MessageMediaDocument, MessageMediaWebPage, MessageMediaVenue, MessageMediaGame, MessageMediaInvoice, MessageMediaGeoLive, MessageMediaPoll, MessageMediaDice, MessageMediaStory, MessageMediaGiveaway.
        """
        self.channels = channels
        self.quantity = quantity
        self.months = months
        self.until_date = until_date
        self.only_new_subscribers = only_new_subscribers
        self.countries_iso2 = countries_iso2

    def to_dict(self):
        return {
            '_': 'MessageMediaGiveaway',
            'channels': [] if self.channels is None else self.channels[:],
            'quantity': self.quantity,
            'months': self.months,
            'until_date': self.until_date,
            'only_new_subscribers': self.only_new_subscribers,
            'countries_iso2': [] if self.countries_iso2 is None else self.countries_iso2[:]
        }

    def _bytes(self):
        return b''.join((
            b'd\x06&X',
            struct.pack('<I', (0 if self.only_new_subscribers is None or self.only_new_subscribers is False else 1) | (0 if self.countries_iso2 is None or self.countries_iso2 is False else 2)),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.channels)),b''.join(struct.pack('<q', x) for x in self.channels),
            b'' if self.countries_iso2 is None or self.countries_iso2 is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.countries_iso2)),b''.join(self.serialize_bytes(x) for x in self.countries_iso2))),
            struct.pack('<i', self.quantity),
            struct.pack('<i', self.months),
            self.serialize_datetime(self.until_date),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _only_new_subscribers = bool(flags & 1)
        reader.read_int()
        _channels = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _channels.append(_x)

        if flags & 2:
            reader.read_int()
            _countries_iso2 = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_string()
                _countries_iso2.append(_x)

        else:
            _countries_iso2 = None
        _quantity = reader.read_int()
        _months = reader.read_int()
        _until_date = reader.tgread_date()
        return cls(channels=_channels, quantity=_quantity, months=_months, until_date=_until_date, only_new_subscribers=_only_new_subscribers, countries_iso2=_countries_iso2)


class MessageMediaInvoice(TLObject):
    CONSTRUCTOR_ID = 0xf6a548d3
    SUBCLASS_OF_ID = 0x476cbe32

    def __init__(self, title: str, description: str, currency: str, total_amount: int, start_param: str, shipping_address_requested: Optional[bool]=None, test: Optional[bool]=None, photo: Optional['TypeWebDocument']=None, receipt_msg_id: Optional[int]=None, extended_media: Optional['TypeMessageExtendedMedia']=None):
        """
        Constructor for MessageMedia: Instance of either MessageMediaEmpty, MessageMediaPhoto, MessageMediaGeo, MessageMediaContact, MessageMediaUnsupported, MessageMediaDocument, MessageMediaWebPage, MessageMediaVenue, MessageMediaGame, MessageMediaInvoice, MessageMediaGeoLive, MessageMediaPoll, MessageMediaDice, MessageMediaStory, MessageMediaGiveaway.
        """
        self.title = title
        self.description = description
        self.currency = currency
        self.total_amount = total_amount
        self.start_param = start_param
        self.shipping_address_requested = shipping_address_requested
        self.test = test
        self.photo = photo
        self.receipt_msg_id = receipt_msg_id
        self.extended_media = extended_media

    def to_dict(self):
        return {
            '_': 'MessageMediaInvoice',
            'title': self.title,
            'description': self.description,
            'currency': self.currency,
            'total_amount': self.total_amount,
            'start_param': self.start_param,
            'shipping_address_requested': self.shipping_address_requested,
            'test': self.test,
            'photo': self.photo.to_dict() if isinstance(self.photo, TLObject) else self.photo,
            'receipt_msg_id': self.receipt_msg_id,
            'extended_media': self.extended_media.to_dict() if isinstance(self.extended_media, TLObject) else self.extended_media
        }

    def _bytes(self):
        return b''.join((
            b'\xd3H\xa5\xf6',
            struct.pack('<I', (0 if self.shipping_address_requested is None or self.shipping_address_requested is False else 2) | (0 if self.test is None or self.test is False else 8) | (0 if self.photo is None or self.photo is False else 1) | (0 if self.receipt_msg_id is None or self.receipt_msg_id is False else 4) | (0 if self.extended_media is None or self.extended_media is False else 16)),
            self.serialize_bytes(self.title),
            self.serialize_bytes(self.description),
            b'' if self.photo is None or self.photo is False else (self.photo._bytes()),
            b'' if self.receipt_msg_id is None or self.receipt_msg_id is False else (struct.pack('<i', self.receipt_msg_id)),
            self.serialize_bytes(self.currency),
            struct.pack('<q', self.total_amount),
            self.serialize_bytes(self.start_param),
            b'' if self.extended_media is None or self.extended_media is False else (self.extended_media._bytes()),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _shipping_address_requested = bool(flags & 2)
        _test = bool(flags & 8)
        _title = reader.tgread_string()
        _description = reader.tgread_string()
        if flags & 1:
            _photo = reader.tgread_object()
        else:
            _photo = None
        if flags & 4:
            _receipt_msg_id = reader.read_int()
        else:
            _receipt_msg_id = None
        _currency = reader.tgread_string()
        _total_amount = reader.read_long()
        _start_param = reader.tgread_string()
        if flags & 16:
            _extended_media = reader.tgread_object()
        else:
            _extended_media = None
        return cls(title=_title, description=_description, currency=_currency, total_amount=_total_amount, start_param=_start_param, shipping_address_requested=_shipping_address_requested, test=_test, photo=_photo, receipt_msg_id=_receipt_msg_id, extended_media=_extended_media)


class MessageMediaPhoto(TLObject):
    CONSTRUCTOR_ID = 0x695150d7
    SUBCLASS_OF_ID = 0x476cbe32

    def __init__(self, spoiler: Optional[bool]=None, photo: Optional['TypePhoto']=None, ttl_seconds: Optional[int]=None):
        """
        Constructor for MessageMedia: Instance of either MessageMediaEmpty, MessageMediaPhoto, MessageMediaGeo, MessageMediaContact, MessageMediaUnsupported, MessageMediaDocument, MessageMediaWebPage, MessageMediaVenue, MessageMediaGame, MessageMediaInvoice, MessageMediaGeoLive, MessageMediaPoll, MessageMediaDice, MessageMediaStory, MessageMediaGiveaway.
        """
        self.spoiler = spoiler
        self.photo = photo
        self.ttl_seconds = ttl_seconds

    def to_dict(self):
        return {
            '_': 'MessageMediaPhoto',
            'spoiler': self.spoiler,
            'photo': self.photo.to_dict() if isinstance(self.photo, TLObject) else self.photo,
            'ttl_seconds': self.ttl_seconds
        }

    def _bytes(self):
        return b''.join((
            b'\xd7PQi',
            struct.pack('<I', (0 if self.spoiler is None or self.spoiler is False else 8) | (0 if self.photo is None or self.photo is False else 1) | (0 if self.ttl_seconds is None or self.ttl_seconds is False else 4)),
            b'' if self.photo is None or self.photo is False else (self.photo._bytes()),
            b'' if self.ttl_seconds is None or self.ttl_seconds is False else (struct.pack('<i', self.ttl_seconds)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _spoiler = bool(flags & 8)
        if flags & 1:
            _photo = reader.tgread_object()
        else:
            _photo = None
        if flags & 4:
            _ttl_seconds = reader.read_int()
        else:
            _ttl_seconds = None
        return cls(spoiler=_spoiler, photo=_photo, ttl_seconds=_ttl_seconds)


class MessageMediaPoll(TLObject):
    CONSTRUCTOR_ID = 0x4bd6e798
    SUBCLASS_OF_ID = 0x476cbe32

    def __init__(self, poll: 'TypePoll', results: 'TypePollResults'):
        """
        Constructor for MessageMedia: Instance of either MessageMediaEmpty, MessageMediaPhoto, MessageMediaGeo, MessageMediaContact, MessageMediaUnsupported, MessageMediaDocument, MessageMediaWebPage, MessageMediaVenue, MessageMediaGame, MessageMediaInvoice, MessageMediaGeoLive, MessageMediaPoll, MessageMediaDice, MessageMediaStory, MessageMediaGiveaway.
        """
        self.poll = poll
        self.results = results

    def to_dict(self):
        return {
            '_': 'MessageMediaPoll',
            'poll': self.poll.to_dict() if isinstance(self.poll, TLObject) else self.poll,
            'results': self.results.to_dict() if isinstance(self.results, TLObject) else self.results
        }

    def _bytes(self):
        return b''.join((
            b'\x98\xe7\xd6K',
            self.poll._bytes(),
            self.results._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _poll = reader.tgread_object()
        _results = reader.tgread_object()
        return cls(poll=_poll, results=_results)


class MessageMediaStory(TLObject):
    CONSTRUCTOR_ID = 0x68cb6283
    SUBCLASS_OF_ID = 0x476cbe32

    # noinspection PyShadowingBuiltins
    def __init__(self, peer: 'TypePeer', id: int, via_mention: Optional[bool]=None, story: Optional['TypeStoryItem']=None):
        """
        Constructor for MessageMedia: Instance of either MessageMediaEmpty, MessageMediaPhoto, MessageMediaGeo, MessageMediaContact, MessageMediaUnsupported, MessageMediaDocument, MessageMediaWebPage, MessageMediaVenue, MessageMediaGame, MessageMediaInvoice, MessageMediaGeoLive, MessageMediaPoll, MessageMediaDice, MessageMediaStory, MessageMediaGiveaway.
        """
        self.peer = peer
        self.id = id
        self.via_mention = via_mention
        self.story = story

    def to_dict(self):
        return {
            '_': 'MessageMediaStory',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'id': self.id,
            'via_mention': self.via_mention,
            'story': self.story.to_dict() if isinstance(self.story, TLObject) else self.story
        }

    def _bytes(self):
        return b''.join((
            b'\x83b\xcbh',
            struct.pack('<I', (0 if self.via_mention is None or self.via_mention is False else 2) | (0 if self.story is None or self.story is False else 1)),
            self.peer._bytes(),
            struct.pack('<i', self.id),
            b'' if self.story is None or self.story is False else (self.story._bytes()),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _via_mention = bool(flags & 2)
        _peer = reader.tgread_object()
        _id = reader.read_int()
        if flags & 1:
            _story = reader.tgread_object()
        else:
            _story = None
        return cls(peer=_peer, id=_id, via_mention=_via_mention, story=_story)


class MessageMediaUnsupported(TLObject):
    CONSTRUCTOR_ID = 0x9f84f49e
    SUBCLASS_OF_ID = 0x476cbe32

    def to_dict(self):
        return {
            '_': 'MessageMediaUnsupported'
        }

    def _bytes(self):
        return b''.join((
            b'\x9e\xf4\x84\x9f',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class MessageMediaVenue(TLObject):
    CONSTRUCTOR_ID = 0x2ec0533f
    SUBCLASS_OF_ID = 0x476cbe32

    def __init__(self, geo: 'TypeGeoPoint', title: str, address: str, provider: str, venue_id: str, venue_type: str):
        """
        Constructor for MessageMedia: Instance of either MessageMediaEmpty, MessageMediaPhoto, MessageMediaGeo, MessageMediaContact, MessageMediaUnsupported, MessageMediaDocument, MessageMediaWebPage, MessageMediaVenue, MessageMediaGame, MessageMediaInvoice, MessageMediaGeoLive, MessageMediaPoll, MessageMediaDice, MessageMediaStory, MessageMediaGiveaway.
        """
        self.geo = geo
        self.title = title
        self.address = address
        self.provider = provider
        self.venue_id = venue_id
        self.venue_type = venue_type

    def to_dict(self):
        return {
            '_': 'MessageMediaVenue',
            'geo': self.geo.to_dict() if isinstance(self.geo, TLObject) else self.geo,
            'title': self.title,
            'address': self.address,
            'provider': self.provider,
            'venue_id': self.venue_id,
            'venue_type': self.venue_type
        }

    def _bytes(self):
        return b''.join((
            b'?S\xc0.',
            self.geo._bytes(),
            self.serialize_bytes(self.title),
            self.serialize_bytes(self.address),
            self.serialize_bytes(self.provider),
            self.serialize_bytes(self.venue_id),
            self.serialize_bytes(self.venue_type),
        ))

    @classmethod
    def from_reader(cls, reader):
        _geo = reader.tgread_object()
        _title = reader.tgread_string()
        _address = reader.tgread_string()
        _provider = reader.tgread_string()
        _venue_id = reader.tgread_string()
        _venue_type = reader.tgread_string()
        return cls(geo=_geo, title=_title, address=_address, provider=_provider, venue_id=_venue_id, venue_type=_venue_type)


class MessageMediaWebPage(TLObject):
    CONSTRUCTOR_ID = 0xddf10c3b
    SUBCLASS_OF_ID = 0x476cbe32

    def __init__(self, webpage: 'TypeWebPage', force_large_media: Optional[bool]=None, force_small_media: Optional[bool]=None, manual: Optional[bool]=None, safe: Optional[bool]=None):
        """
        Constructor for MessageMedia: Instance of either MessageMediaEmpty, MessageMediaPhoto, MessageMediaGeo, MessageMediaContact, MessageMediaUnsupported, MessageMediaDocument, MessageMediaWebPage, MessageMediaVenue, MessageMediaGame, MessageMediaInvoice, MessageMediaGeoLive, MessageMediaPoll, MessageMediaDice, MessageMediaStory, MessageMediaGiveaway.
        """
        self.webpage = webpage
        self.force_large_media = force_large_media
        self.force_small_media = force_small_media
        self.manual = manual
        self.safe = safe

    def to_dict(self):
        return {
            '_': 'MessageMediaWebPage',
            'webpage': self.webpage.to_dict() if isinstance(self.webpage, TLObject) else self.webpage,
            'force_large_media': self.force_large_media,
            'force_small_media': self.force_small_media,
            'manual': self.manual,
            'safe': self.safe
        }

    def _bytes(self):
        return b''.join((
            b';\x0c\xf1\xdd',
            struct.pack('<I', (0 if self.force_large_media is None or self.force_large_media is False else 1) | (0 if self.force_small_media is None or self.force_small_media is False else 2) | (0 if self.manual is None or self.manual is False else 8) | (0 if self.safe is None or self.safe is False else 16)),
            self.webpage._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _force_large_media = bool(flags & 1)
        _force_small_media = bool(flags & 2)
        _manual = bool(flags & 8)
        _safe = bool(flags & 16)
        _webpage = reader.tgread_object()
        return cls(webpage=_webpage, force_large_media=_force_large_media, force_small_media=_force_small_media, manual=_manual, safe=_safe)


class MessagePeerReaction(TLObject):
    CONSTRUCTOR_ID = 0x8c79b63c
    SUBCLASS_OF_ID = 0xaf73a2a5

    def __init__(self, peer_id: 'TypePeer', date: Optional[datetime], reaction: 'TypeReaction', big: Optional[bool]=None, unread: Optional[bool]=None, my: Optional[bool]=None):
        """
        Constructor for MessagePeerReaction: Instance of MessagePeerReaction.
        """
        self.peer_id = peer_id
        self.date = date
        self.reaction = reaction
        self.big = big
        self.unread = unread
        self.my = my

    def to_dict(self):
        return {
            '_': 'MessagePeerReaction',
            'peer_id': self.peer_id.to_dict() if isinstance(self.peer_id, TLObject) else self.peer_id,
            'date': self.date,
            'reaction': self.reaction.to_dict() if isinstance(self.reaction, TLObject) else self.reaction,
            'big': self.big,
            'unread': self.unread,
            'my': self.my
        }

    def _bytes(self):
        return b''.join((
            b'<\xb6y\x8c',
            struct.pack('<I', (0 if self.big is None or self.big is False else 1) | (0 if self.unread is None or self.unread is False else 2) | (0 if self.my is None or self.my is False else 4)),
            self.peer_id._bytes(),
            self.serialize_datetime(self.date),
            self.reaction._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _big = bool(flags & 1)
        _unread = bool(flags & 2)
        _my = bool(flags & 4)
        _peer_id = reader.tgread_object()
        _date = reader.tgread_date()
        _reaction = reader.tgread_object()
        return cls(peer_id=_peer_id, date=_date, reaction=_reaction, big=_big, unread=_unread, my=_my)


class MessagePeerVote(TLObject):
    CONSTRUCTOR_ID = 0xb6cc2d5c
    SUBCLASS_OF_ID = 0x85c27202

    def __init__(self, peer: 'TypePeer', option: bytes, date: Optional[datetime]):
        """
        Constructor for MessagePeerVote: Instance of either MessagePeerVote, MessagePeerVoteInputOption, MessagePeerVoteMultiple.
        """
        self.peer = peer
        self.option = option
        self.date = date

    def to_dict(self):
        return {
            '_': 'MessagePeerVote',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'option': self.option,
            'date': self.date
        }

    def _bytes(self):
        return b''.join((
            b'\\-\xcc\xb6',
            self.peer._bytes(),
            self.serialize_bytes(self.option),
            self.serialize_datetime(self.date),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _option = reader.tgread_bytes()
        _date = reader.tgread_date()
        return cls(peer=_peer, option=_option, date=_date)


class MessagePeerVoteInputOption(TLObject):
    CONSTRUCTOR_ID = 0x74cda504
    SUBCLASS_OF_ID = 0x85c27202

    def __init__(self, peer: 'TypePeer', date: Optional[datetime]):
        """
        Constructor for MessagePeerVote: Instance of either MessagePeerVote, MessagePeerVoteInputOption, MessagePeerVoteMultiple.
        """
        self.peer = peer
        self.date = date

    def to_dict(self):
        return {
            '_': 'MessagePeerVoteInputOption',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'date': self.date
        }

    def _bytes(self):
        return b''.join((
            b'\x04\xa5\xcdt',
            self.peer._bytes(),
            self.serialize_datetime(self.date),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _date = reader.tgread_date()
        return cls(peer=_peer, date=_date)


class MessagePeerVoteMultiple(TLObject):
    CONSTRUCTOR_ID = 0x4628f6e6
    SUBCLASS_OF_ID = 0x85c27202

    def __init__(self, peer: 'TypePeer', options: List[bytes], date: Optional[datetime]):
        """
        Constructor for MessagePeerVote: Instance of either MessagePeerVote, MessagePeerVoteInputOption, MessagePeerVoteMultiple.
        """
        self.peer = peer
        self.options = options
        self.date = date

    def to_dict(self):
        return {
            '_': 'MessagePeerVoteMultiple',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'options': [] if self.options is None else self.options[:],
            'date': self.date
        }

    def _bytes(self):
        return b''.join((
            b'\xe6\xf6(F',
            self.peer._bytes(),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.options)),b''.join(self.serialize_bytes(x) for x in self.options),
            self.serialize_datetime(self.date),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        reader.read_int()
        _options = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_bytes()
            _options.append(_x)

        _date = reader.tgread_date()
        return cls(peer=_peer, options=_options, date=_date)


class MessageRange(TLObject):
    CONSTRUCTOR_ID = 0xae30253
    SUBCLASS_OF_ID = 0xbec74577

    def __init__(self, min_id: int, max_id: int):
        """
        Constructor for MessageRange: Instance of MessageRange.
        """
        self.min_id = min_id
        self.max_id = max_id

    def to_dict(self):
        return {
            '_': 'MessageRange',
            'min_id': self.min_id,
            'max_id': self.max_id
        }

    def _bytes(self):
        return b''.join((
            b'S\x02\xe3\n',
            struct.pack('<i', self.min_id),
            struct.pack('<i', self.max_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _min_id = reader.read_int()
        _max_id = reader.read_int()
        return cls(min_id=_min_id, max_id=_max_id)


class MessageReactions(TLObject):
    CONSTRUCTOR_ID = 0x4f2b9479
    SUBCLASS_OF_ID = 0x8a5b071c

    # noinspection PyShadowingBuiltins
    def __init__(self, results: List['TypeReactionCount'], min: Optional[bool]=None, can_see_list: Optional[bool]=None, recent_reactions: Optional[List['TypeMessagePeerReaction']]=None):
        """
        Constructor for MessageReactions: Instance of MessageReactions.
        """
        self.results = results
        self.min = min
        self.can_see_list = can_see_list
        self.recent_reactions = recent_reactions

    def to_dict(self):
        return {
            '_': 'MessageReactions',
            'results': [] if self.results is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.results],
            'min': self.min,
            'can_see_list': self.can_see_list,
            'recent_reactions': [] if self.recent_reactions is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.recent_reactions]
        }

    def _bytes(self):
        return b''.join((
            b'y\x94+O',
            struct.pack('<I', (0 if self.min is None or self.min is False else 1) | (0 if self.can_see_list is None or self.can_see_list is False else 4) | (0 if self.recent_reactions is None or self.recent_reactions is False else 2)),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.results)),b''.join(x._bytes() for x in self.results),
            b'' if self.recent_reactions is None or self.recent_reactions is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.recent_reactions)),b''.join(x._bytes() for x in self.recent_reactions))),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _min = bool(flags & 1)
        _can_see_list = bool(flags & 4)
        reader.read_int()
        _results = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _results.append(_x)

        if flags & 2:
            reader.read_int()
            _recent_reactions = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _recent_reactions.append(_x)

        else:
            _recent_reactions = None
        return cls(results=_results, min=_min, can_see_list=_can_see_list, recent_reactions=_recent_reactions)


class MessageReplies(TLObject):
    CONSTRUCTOR_ID = 0x83d60fc2
    SUBCLASS_OF_ID = 0x6ccd5ce2

    def __init__(self, replies: int, replies_pts: int, comments: Optional[bool]=None, recent_repliers: Optional[List['TypePeer']]=None, channel_id: Optional[int]=None, max_id: Optional[int]=None, read_max_id: Optional[int]=None):
        """
        Constructor for MessageReplies: Instance of MessageReplies.
        """
        self.replies = replies
        self.replies_pts = replies_pts
        self.comments = comments
        self.recent_repliers = recent_repliers
        self.channel_id = channel_id
        self.max_id = max_id
        self.read_max_id = read_max_id

    def to_dict(self):
        return {
            '_': 'MessageReplies',
            'replies': self.replies,
            'replies_pts': self.replies_pts,
            'comments': self.comments,
            'recent_repliers': [] if self.recent_repliers is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.recent_repliers],
            'channel_id': self.channel_id,
            'max_id': self.max_id,
            'read_max_id': self.read_max_id
        }

    def _bytes(self):
        assert ((self.comments or self.comments is not None) and (self.channel_id or self.channel_id is not None)) or ((self.comments is None or self.comments is False) and (self.channel_id is None or self.channel_id is False)), 'comments, channel_id parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'\xc2\x0f\xd6\x83',
            struct.pack('<I', (0 if self.comments is None or self.comments is False else 1) | (0 if self.recent_repliers is None or self.recent_repliers is False else 2) | (0 if self.channel_id is None or self.channel_id is False else 1) | (0 if self.max_id is None or self.max_id is False else 4) | (0 if self.read_max_id is None or self.read_max_id is False else 8)),
            struct.pack('<i', self.replies),
            struct.pack('<i', self.replies_pts),
            b'' if self.recent_repliers is None or self.recent_repliers is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.recent_repliers)),b''.join(x._bytes() for x in self.recent_repliers))),
            b'' if self.channel_id is None or self.channel_id is False else (struct.pack('<q', self.channel_id)),
            b'' if self.max_id is None or self.max_id is False else (struct.pack('<i', self.max_id)),
            b'' if self.read_max_id is None or self.read_max_id is False else (struct.pack('<i', self.read_max_id)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _comments = bool(flags & 1)
        _replies = reader.read_int()
        _replies_pts = reader.read_int()
        if flags & 2:
            reader.read_int()
            _recent_repliers = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _recent_repliers.append(_x)

        else:
            _recent_repliers = None
        if flags & 1:
            _channel_id = reader.read_long()
        else:
            _channel_id = None
        if flags & 4:
            _max_id = reader.read_int()
        else:
            _max_id = None
        if flags & 8:
            _read_max_id = reader.read_int()
        else:
            _read_max_id = None
        return cls(replies=_replies, replies_pts=_replies_pts, comments=_comments, recent_repliers=_recent_repliers, channel_id=_channel_id, max_id=_max_id, read_max_id=_read_max_id)


class MessageReplyHeader(TLObject):
    CONSTRUCTOR_ID = 0x6eebcabd
    SUBCLASS_OF_ID = 0x5b4d9167

    def __init__(self, reply_to_scheduled: Optional[bool]=None, forum_topic: Optional[bool]=None, quote: Optional[bool]=None, reply_to_msg_id: Optional[int]=None, reply_to_peer_id: Optional['TypePeer']=None, reply_from: Optional['TypeMessageFwdHeader']=None, reply_media: Optional['TypeMessageMedia']=None, reply_to_top_id: Optional[int]=None, quote_text: Optional[str]=None, quote_entities: Optional[List['TypeMessageEntity']]=None):
        """
        Constructor for MessageReplyHeader: Instance of either MessageReplyHeader, MessageReplyStoryHeader.
        """
        self.reply_to_scheduled = reply_to_scheduled
        self.forum_topic = forum_topic
        self.quote = quote
        self.reply_to_msg_id = reply_to_msg_id
        self.reply_to_peer_id = reply_to_peer_id
        self.reply_from = reply_from
        self.reply_media = reply_media
        self.reply_to_top_id = reply_to_top_id
        self.quote_text = quote_text
        self.quote_entities = quote_entities

    def to_dict(self):
        return {
            '_': 'MessageReplyHeader',
            'reply_to_scheduled': self.reply_to_scheduled,
            'forum_topic': self.forum_topic,
            'quote': self.quote,
            'reply_to_msg_id': self.reply_to_msg_id,
            'reply_to_peer_id': self.reply_to_peer_id.to_dict() if isinstance(self.reply_to_peer_id, TLObject) else self.reply_to_peer_id,
            'reply_from': self.reply_from.to_dict() if isinstance(self.reply_from, TLObject) else self.reply_from,
            'reply_media': self.reply_media.to_dict() if isinstance(self.reply_media, TLObject) else self.reply_media,
            'reply_to_top_id': self.reply_to_top_id,
            'quote_text': self.quote_text,
            'quote_entities': [] if self.quote_entities is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.quote_entities]
        }

    def _bytes(self):
        return b''.join((
            b'\xbd\xca\xebn',
            struct.pack('<I', (0 if self.reply_to_scheduled is None or self.reply_to_scheduled is False else 4) | (0 if self.forum_topic is None or self.forum_topic is False else 8) | (0 if self.quote is None or self.quote is False else 512) | (0 if self.reply_to_msg_id is None or self.reply_to_msg_id is False else 16) | (0 if self.reply_to_peer_id is None or self.reply_to_peer_id is False else 1) | (0 if self.reply_from is None or self.reply_from is False else 32) | (0 if self.reply_media is None or self.reply_media is False else 256) | (0 if self.reply_to_top_id is None or self.reply_to_top_id is False else 2) | (0 if self.quote_text is None or self.quote_text is False else 64) | (0 if self.quote_entities is None or self.quote_entities is False else 128)),
            b'' if self.reply_to_msg_id is None or self.reply_to_msg_id is False else (struct.pack('<i', self.reply_to_msg_id)),
            b'' if self.reply_to_peer_id is None or self.reply_to_peer_id is False else (self.reply_to_peer_id._bytes()),
            b'' if self.reply_from is None or self.reply_from is False else (self.reply_from._bytes()),
            b'' if self.reply_media is None or self.reply_media is False else (self.reply_media._bytes()),
            b'' if self.reply_to_top_id is None or self.reply_to_top_id is False else (struct.pack('<i', self.reply_to_top_id)),
            b'' if self.quote_text is None or self.quote_text is False else (self.serialize_bytes(self.quote_text)),
            b'' if self.quote_entities is None or self.quote_entities is False else b''.join((b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.quote_entities)),b''.join(x._bytes() for x in self.quote_entities))),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _reply_to_scheduled = bool(flags & 4)
        _forum_topic = bool(flags & 8)
        _quote = bool(flags & 512)
        if flags & 16:
            _reply_to_msg_id = reader.read_int()
        else:
            _reply_to_msg_id = None
        if flags & 1:
            _reply_to_peer_id = reader.tgread_object()
        else:
            _reply_to_peer_id = None
        if flags & 32:
            _reply_from = reader.tgread_object()
        else:
            _reply_from = None
        if flags & 256:
            _reply_media = reader.tgread_object()
        else:
            _reply_media = None
        if flags & 2:
            _reply_to_top_id = reader.read_int()
        else:
            _reply_to_top_id = None
        if flags & 64:
            _quote_text = reader.tgread_string()
        else:
            _quote_text = None
        if flags & 128:
            reader.read_int()
            _quote_entities = []
            for _ in range(reader.read_int()):
                _x = reader.tgread_object()
                _quote_entities.append(_x)

        else:
            _quote_entities = None
        return cls(reply_to_scheduled=_reply_to_scheduled, forum_topic=_forum_topic, quote=_quote, reply_to_msg_id=_reply_to_msg_id, reply_to_peer_id=_reply_to_peer_id, reply_from=_reply_from, reply_media=_reply_media, reply_to_top_id=_reply_to_top_id, quote_text=_quote_text, quote_entities=_quote_entities)


class MessageReplyStoryHeader(TLObject):
    CONSTRUCTOR_ID = 0x9c98bfc1
    SUBCLASS_OF_ID = 0x5b4d9167

    def __init__(self, user_id: int, story_id: int):
        """
        Constructor for MessageReplyHeader: Instance of either MessageReplyHeader, MessageReplyStoryHeader.
        """
        self.user_id = user_id
        self.story_id = story_id

    def to_dict(self):
        return {
            '_': 'MessageReplyStoryHeader',
            'user_id': self.user_id,
            'story_id': self.story_id
        }

    def _bytes(self):
        return b''.join((
            b'\xc1\xbf\x98\x9c',
            struct.pack('<q', self.user_id),
            struct.pack('<i', self.story_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _user_id = reader.read_long()
        _story_id = reader.read_int()
        return cls(user_id=_user_id, story_id=_story_id)


class MessageService(TLObject):
    CONSTRUCTOR_ID = 0x2b085862
    SUBCLASS_OF_ID = 0x790009e3

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int, peer_id: 'TypePeer', date: Optional[datetime], action: 'TypeMessageAction', out: Optional[bool]=None, mentioned: Optional[bool]=None, media_unread: Optional[bool]=None, silent: Optional[bool]=None, post: Optional[bool]=None, legacy: Optional[bool]=None, from_id: Optional['TypePeer']=None, reply_to: Optional['TypeMessageReplyHeader']=None, ttl_period: Optional[int]=None):
        """
        Constructor for Message: Instance of either MessageEmpty, Message, MessageService.
        """
        self.id = id
        self.peer_id = peer_id
        self.date = date
        self.action = action
        self.out = out
        self.mentioned = mentioned
        self.media_unread = media_unread
        self.silent = silent
        self.post = post
        self.legacy = legacy
        self.from_id = from_id
        self.reply_to = reply_to
        self.ttl_period = ttl_period

    def to_dict(self):
        return {
            '_': 'MessageService',
            'id': self.id,
            'peer_id': self.peer_id.to_dict() if isinstance(self.peer_id, TLObject) else self.peer_id,
            'date': self.date,
            'action': self.action.to_dict() if isinstance(self.action, TLObject) else self.action,
            'out': self.out,
            'mentioned': self.mentioned,
            'media_unread': self.media_unread,
            'silent': self.silent,
            'post': self.post,
            'legacy': self.legacy,
            'from_id': self.from_id.to_dict() if isinstance(self.from_id, TLObject) else self.from_id,
            'reply_to': self.reply_to.to_dict() if isinstance(self.reply_to, TLObject) else self.reply_to,
            'ttl_period': self.ttl_period
        }

    def _bytes(self):
        return b''.join((
            b'bX\x08+',
            struct.pack('<I', (0 if self.out is None or self.out is False else 2) | (0 if self.mentioned is None or self.mentioned is False else 16) | (0 if self.media_unread is None or self.media_unread is False else 32) | (0 if self.silent is None or self.silent is False else 8192) | (0 if self.post is None or self.post is False else 16384) | (0 if self.legacy is None or self.legacy is False else 524288) | (0 if self.from_id is None or self.from_id is False else 256) | (0 if self.reply_to is None or self.reply_to is False else 8) | (0 if self.ttl_period is None or self.ttl_period is False else 33554432)),
            struct.pack('<i', self.id),
            b'' if self.from_id is None or self.from_id is False else (self.from_id._bytes()),
            self.peer_id._bytes(),
            b'' if self.reply_to is None or self.reply_to is False else (self.reply_to._bytes()),
            self.serialize_datetime(self.date),
            self.action._bytes(),
            b'' if self.ttl_period is None or self.ttl_period is False else (struct.pack('<i', self.ttl_period)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _out = bool(flags & 2)
        _mentioned = bool(flags & 16)
        _media_unread = bool(flags & 32)
        _silent = bool(flags & 8192)
        _post = bool(flags & 16384)
        _legacy = bool(flags & 524288)
        _id = reader.read_int()
        if flags & 256:
            _from_id = reader.tgread_object()
        else:
            _from_id = None
        _peer_id = reader.tgread_object()
        if flags & 8:
            _reply_to = reader.tgread_object()
        else:
            _reply_to = None
        _date = reader.tgread_date()
        _action = reader.tgread_object()
        if flags & 33554432:
            _ttl_period = reader.read_int()
        else:
            _ttl_period = None
        return cls(id=_id, peer_id=_peer_id, date=_date, action=_action, out=_out, mentioned=_mentioned, media_unread=_media_unread, silent=_silent, post=_post, legacy=_legacy, from_id=_from_id, reply_to=_reply_to, ttl_period=_ttl_period)


class MessageViews(TLObject):
    CONSTRUCTOR_ID = 0x455b853d
    SUBCLASS_OF_ID = 0x3cb083b9

    def __init__(self, views: Optional[int]=None, forwards: Optional[int]=None, replies: Optional['TypeMessageReplies']=None):
        """
        Constructor for MessageViews: Instance of MessageViews.
        """
        self.views = views
        self.forwards = forwards
        self.replies = replies

    def to_dict(self):
        return {
            '_': 'MessageViews',
            'views': self.views,
            'forwards': self.forwards,
            'replies': self.replies.to_dict() if isinstance(self.replies, TLObject) else self.replies
        }

    def _bytes(self):
        return b''.join((
            b'=\x85[E',
            struct.pack('<I', (0 if self.views is None or self.views is False else 1) | (0 if self.forwards is None or self.forwards is False else 2) | (0 if self.replies is None or self.replies is False else 4)),
            b'' if self.views is None or self.views is False else (struct.pack('<i', self.views)),
            b'' if self.forwards is None or self.forwards is False else (struct.pack('<i', self.forwards)),
            b'' if self.replies is None or self.replies is False else (self.replies._bytes()),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 1:
            _views = reader.read_int()
        else:
            _views = None
        if flags & 2:
            _forwards = reader.read_int()
        else:
            _forwards = None
        if flags & 4:
            _replies = reader.tgread_object()
        else:
            _replies = None
        return cls(views=_views, forwards=_forwards, replies=_replies)


class MsgDetailedInfo(TLObject):
    CONSTRUCTOR_ID = 0x276d3ec6
    SUBCLASS_OF_ID = 0x5f32d5ee

    # noinspection PyShadowingBuiltins
    def __init__(self, msg_id: int, answer_msg_id: int, bytes: int, status: int):
        """
        Constructor for MsgDetailedInfo: Instance of either MsgDetailedInfo, MsgNewDetailedInfo.
        """
        self.msg_id = msg_id
        self.answer_msg_id = answer_msg_id
        self.bytes = bytes
        self.status = status

    def to_dict(self):
        return {
            '_': 'MsgDetailedInfo',
            'msg_id': self.msg_id,
            'answer_msg_id': self.answer_msg_id,
            'bytes': self.bytes,
            'status': self.status
        }

    def _bytes(self):
        return b''.join((
            b"\xc6>m'",
            struct.pack('<q', self.msg_id),
            struct.pack('<q', self.answer_msg_id),
            struct.pack('<i', self.bytes),
            struct.pack('<i', self.status),
        ))

    @classmethod
    def from_reader(cls, reader):
        _msg_id = reader.read_long()
        _answer_msg_id = reader.read_long()
        _bytes = reader.read_int()
        _status = reader.read_int()
        return cls(msg_id=_msg_id, answer_msg_id=_answer_msg_id, bytes=_bytes, status=_status)


class MsgNewDetailedInfo(TLObject):
    CONSTRUCTOR_ID = 0x809db6df
    SUBCLASS_OF_ID = 0x5f32d5ee

    # noinspection PyShadowingBuiltins
    def __init__(self, answer_msg_id: int, bytes: int, status: int):
        """
        Constructor for MsgDetailedInfo: Instance of either MsgDetailedInfo, MsgNewDetailedInfo.
        """
        self.answer_msg_id = answer_msg_id
        self.bytes = bytes
        self.status = status

    def to_dict(self):
        return {
            '_': 'MsgNewDetailedInfo',
            'answer_msg_id': self.answer_msg_id,
            'bytes': self.bytes,
            'status': self.status
        }

    def _bytes(self):
        return b''.join((
            b'\xdf\xb6\x9d\x80',
            struct.pack('<q', self.answer_msg_id),
            struct.pack('<i', self.bytes),
            struct.pack('<i', self.status),
        ))

    @classmethod
    def from_reader(cls, reader):
        _answer_msg_id = reader.read_long()
        _bytes = reader.read_int()
        _status = reader.read_int()
        return cls(answer_msg_id=_answer_msg_id, bytes=_bytes, status=_status)


class MsgResendReq(TLObject):
    CONSTRUCTOR_ID = 0x7d861a08
    SUBCLASS_OF_ID = 0x2024514

    def __init__(self, msg_ids: List[int]):
        """
        Constructor for MsgResendReq: Instance of MsgResendReq.
        """
        self.msg_ids = msg_ids

    def to_dict(self):
        return {
            '_': 'MsgResendReq',
            'msg_ids': [] if self.msg_ids is None else self.msg_ids[:]
        }

    def _bytes(self):
        return b''.join((
            b'\x08\x1a\x86}',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.msg_ids)),b''.join(struct.pack('<q', x) for x in self.msg_ids),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _msg_ids = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _msg_ids.append(_x)

        return cls(msg_ids=_msg_ids)


class MsgsAck(TLObject):
    CONSTRUCTOR_ID = 0x62d6b459
    SUBCLASS_OF_ID = 0x827677c4

    def __init__(self, msg_ids: List[int]):
        """
        Constructor for MsgsAck: Instance of MsgsAck.
        """
        self.msg_ids = msg_ids

    def to_dict(self):
        return {
            '_': 'MsgsAck',
            'msg_ids': [] if self.msg_ids is None else self.msg_ids[:]
        }

    def _bytes(self):
        return b''.join((
            b'Y\xb4\xd6b',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.msg_ids)),b''.join(struct.pack('<q', x) for x in self.msg_ids),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _msg_ids = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _msg_ids.append(_x)

        return cls(msg_ids=_msg_ids)


class MsgsAllInfo(TLObject):
    CONSTRUCTOR_ID = 0x8cc0d131
    SUBCLASS_OF_ID = 0xfa8fcb54

    def __init__(self, msg_ids: List[int], info: str):
        """
        Constructor for MsgsAllInfo: Instance of MsgsAllInfo.
        """
        self.msg_ids = msg_ids
        self.info = info

    def to_dict(self):
        return {
            '_': 'MsgsAllInfo',
            'msg_ids': [] if self.msg_ids is None else self.msg_ids[:],
            'info': self.info
        }

    def _bytes(self):
        return b''.join((
            b'1\xd1\xc0\x8c',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.msg_ids)),b''.join(struct.pack('<q', x) for x in self.msg_ids),
            self.serialize_bytes(self.info),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _msg_ids = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _msg_ids.append(_x)

        _info = reader.tgread_string()
        return cls(msg_ids=_msg_ids, info=_info)


class MsgsStateInfo(TLObject):
    CONSTRUCTOR_ID = 0x4deb57d
    SUBCLASS_OF_ID = 0x70a0a64

    def __init__(self, req_msg_id: int, info: str):
        """
        Constructor for MsgsStateInfo: Instance of MsgsStateInfo.
        """
        self.req_msg_id = req_msg_id
        self.info = info

    def to_dict(self):
        return {
            '_': 'MsgsStateInfo',
            'req_msg_id': self.req_msg_id,
            'info': self.info
        }

    def _bytes(self):
        return b''.join((
            b'}\xb5\xde\x04',
            struct.pack('<q', self.req_msg_id),
            self.serialize_bytes(self.info),
        ))

    @classmethod
    def from_reader(cls, reader):
        _req_msg_id = reader.read_long()
        _info = reader.tgread_string()
        return cls(req_msg_id=_req_msg_id, info=_info)


class MsgsStateReq(TLObject):
    CONSTRUCTOR_ID = 0xda69fb52
    SUBCLASS_OF_ID = 0x18f01dd0

    def __init__(self, msg_ids: List[int]):
        """
        Constructor for MsgsStateReq: Instance of MsgsStateReq.
        """
        self.msg_ids = msg_ids

    def to_dict(self):
        return {
            '_': 'MsgsStateReq',
            'msg_ids': [] if self.msg_ids is None else self.msg_ids[:]
        }

    def _bytes(self):
        return b''.join((
            b'R\xfbi\xda',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.msg_ids)),b''.join(struct.pack('<q', x) for x in self.msg_ids),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _msg_ids = []
        for _ in range(reader.read_int()):
            _x = reader.read_long()
            _msg_ids.append(_x)

        return cls(msg_ids=_msg_ids)


class MyBoost(TLObject):
    CONSTRUCTOR_ID = 0xc448415c
    SUBCLASS_OF_ID = 0xc51a68bf

    def __init__(self, slot: int, date: Optional[datetime], expires: Optional[datetime], peer: Optional['TypePeer']=None, cooldown_until_date: Optional[datetime]=None):
        """
        Constructor for MyBoost: Instance of MyBoost.
        """
        self.slot = slot
        self.date = date
        self.expires = expires
        self.peer = peer
        self.cooldown_until_date = cooldown_until_date

    def to_dict(self):
        return {
            '_': 'MyBoost',
            'slot': self.slot,
            'date': self.date,
            'expires': self.expires,
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'cooldown_until_date': self.cooldown_until_date
        }

    def _bytes(self):
        return b''.join((
            b'\\AH\xc4',
            struct.pack('<I', (0 if self.peer is None or self.peer is False else 1) | (0 if self.cooldown_until_date is None or self.cooldown_until_date is False else 2)),
            struct.pack('<i', self.slot),
            b'' if self.peer is None or self.peer is False else (self.peer._bytes()),
            self.serialize_datetime(self.date),
            self.serialize_datetime(self.expires),
            b'' if self.cooldown_until_date is None or self.cooldown_until_date is False else (self.serialize_datetime(self.cooldown_until_date)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _slot = reader.read_int()
        if flags & 1:
            _peer = reader.tgread_object()
        else:
            _peer = None
        _date = reader.tgread_date()
        _expires = reader.tgread_date()
        if flags & 2:
            _cooldown_until_date = reader.tgread_date()
        else:
            _cooldown_until_date = None
        return cls(slot=_slot, date=_date, expires=_expires, peer=_peer, cooldown_until_date=_cooldown_until_date)


class NearestDc(TLObject):
    CONSTRUCTOR_ID = 0x8e1a1775
    SUBCLASS_OF_ID = 0x3877045f

    def __init__(self, country: str, this_dc: int, nearest_dc: int):
        """
        Constructor for NearestDc: Instance of NearestDc.
        """
        self.country = country
        self.this_dc = this_dc
        self.nearest_dc = nearest_dc

    def to_dict(self):
        return {
            '_': 'NearestDc',
            'country': self.country,
            'this_dc': self.this_dc,
            'nearest_dc': self.nearest_dc
        }

    def _bytes(self):
        return b''.join((
            b'u\x17\x1a\x8e',
            self.serialize_bytes(self.country),
            struct.pack('<i', self.this_dc),
            struct.pack('<i', self.nearest_dc),
        ))

    @classmethod
    def from_reader(cls, reader):
        _country = reader.tgread_string()
        _this_dc = reader.read_int()
        _nearest_dc = reader.read_int()
        return cls(country=_country, this_dc=_this_dc, nearest_dc=_nearest_dc)


class NewSessionCreated(TLObject):
    CONSTRUCTOR_ID = 0x9ec20908
    SUBCLASS_OF_ID = 0x510d3031

    def __init__(self, first_msg_id: int, unique_id: int, server_salt: int):
        """
        Constructor for NewSession: Instance of NewSessionCreated.
        """
        self.first_msg_id = first_msg_id
        self.unique_id = unique_id
        self.server_salt = server_salt

    def to_dict(self):
        return {
            '_': 'NewSessionCreated',
            'first_msg_id': self.first_msg_id,
            'unique_id': self.unique_id,
            'server_salt': self.server_salt
        }

    def _bytes(self):
        return b''.join((
            b'\x08\t\xc2\x9e',
            struct.pack('<q', self.first_msg_id),
            struct.pack('<q', self.unique_id),
            struct.pack('<q', self.server_salt),
        ))

    @classmethod
    def from_reader(cls, reader):
        _first_msg_id = reader.read_long()
        _unique_id = reader.read_long()
        _server_salt = reader.read_long()
        return cls(first_msg_id=_first_msg_id, unique_id=_unique_id, server_salt=_server_salt)


class NotificationSoundDefault(TLObject):
    CONSTRUCTOR_ID = 0x97e8bebe
    SUBCLASS_OF_ID = 0xf2f5e55b

    def to_dict(self):
        return {
            '_': 'NotificationSoundDefault'
        }

    def _bytes(self):
        return b''.join((
            b'\xbe\xbe\xe8\x97',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class NotificationSoundLocal(TLObject):
    CONSTRUCTOR_ID = 0x830b9ae4
    SUBCLASS_OF_ID = 0xf2f5e55b

    def __init__(self, title: str, data: str):
        """
        Constructor for NotificationSound: Instance of either NotificationSoundDefault, NotificationSoundNone, NotificationSoundLocal, NotificationSoundRingtone.
        """
        self.title = title
        self.data = data

    def to_dict(self):
        return {
            '_': 'NotificationSoundLocal',
            'title': self.title,
            'data': self.data
        }

    def _bytes(self):
        return b''.join((
            b'\xe4\x9a\x0b\x83',
            self.serialize_bytes(self.title),
            self.serialize_bytes(self.data),
        ))

    @classmethod
    def from_reader(cls, reader):
        _title = reader.tgread_string()
        _data = reader.tgread_string()
        return cls(title=_title, data=_data)


class NotificationSoundNone(TLObject):
    CONSTRUCTOR_ID = 0x6f0c34df
    SUBCLASS_OF_ID = 0xf2f5e55b

    def to_dict(self):
        return {
            '_': 'NotificationSoundNone'
        }

    def _bytes(self):
        return b''.join((
            b'\xdf4\x0co',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class NotificationSoundRingtone(TLObject):
    CONSTRUCTOR_ID = 0xff6c8049
    SUBCLASS_OF_ID = 0xf2f5e55b

    # noinspection PyShadowingBuiltins
    def __init__(self, id: int):
        """
        Constructor for NotificationSound: Instance of either NotificationSoundDefault, NotificationSoundNone, NotificationSoundLocal, NotificationSoundRingtone.
        """
        self.id = id

    def to_dict(self):
        return {
            '_': 'NotificationSoundRingtone',
            'id': self.id
        }

    def _bytes(self):
        return b''.join((
            b'I\x80l\xff',
            struct.pack('<q', self.id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.read_long()
        return cls(id=_id)


class NotifyBroadcasts(TLObject):
    CONSTRUCTOR_ID = 0xd612e8ef
    SUBCLASS_OF_ID = 0xdfe8602e

    def to_dict(self):
        return {
            '_': 'NotifyBroadcasts'
        }

    def _bytes(self):
        return b''.join((
            b'\xef\xe8\x12\xd6',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class NotifyChats(TLObject):
    CONSTRUCTOR_ID = 0xc007cec3
    SUBCLASS_OF_ID = 0xdfe8602e

    def to_dict(self):
        return {
            '_': 'NotifyChats'
        }

    def _bytes(self):
        return b''.join((
            b'\xc3\xce\x07\xc0',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class NotifyForumTopic(TLObject):
    CONSTRUCTOR_ID = 0x226e6308
    SUBCLASS_OF_ID = 0xdfe8602e

    def __init__(self, peer: 'TypePeer', top_msg_id: int):
        """
        Constructor for NotifyPeer: Instance of either NotifyPeer, NotifyUsers, NotifyChats, NotifyBroadcasts, NotifyForumTopic.
        """
        self.peer = peer
        self.top_msg_id = top_msg_id

    def to_dict(self):
        return {
            '_': 'NotifyForumTopic',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'top_msg_id': self.top_msg_id
        }

    def _bytes(self):
        return b''.join((
            b'\x08cn"',
            self.peer._bytes(),
            struct.pack('<i', self.top_msg_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _top_msg_id = reader.read_int()
        return cls(peer=_peer, top_msg_id=_top_msg_id)


class NotifyPeer(TLObject):
    CONSTRUCTOR_ID = 0x9fd40bd8
    SUBCLASS_OF_ID = 0xdfe8602e

    def __init__(self, peer: 'TypePeer'):
        """
        Constructor for NotifyPeer: Instance of either NotifyPeer, NotifyUsers, NotifyChats, NotifyBroadcasts, NotifyForumTopic.
        """
        self.peer = peer

    def to_dict(self):
        return {
            '_': 'NotifyPeer',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer
        }

    def _bytes(self):
        return b''.join((
            b'\xd8\x0b\xd4\x9f',
            self.peer._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        return cls(peer=_peer)


class NotifyUsers(TLObject):
    CONSTRUCTOR_ID = 0xb4c83b4c
    SUBCLASS_OF_ID = 0xdfe8602e

    def to_dict(self):
        return {
            '_': 'NotifyUsers'
        }

    def _bytes(self):
        return b''.join((
            b'L;\xc8\xb4',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class PQInnerData(TLObject):
    CONSTRUCTOR_ID = 0x83c95aec
    SUBCLASS_OF_ID = 0x41701377

    def __init__(self, pq: bytes, p: bytes, q: bytes, nonce: int, server_nonce: int, new_nonce: int):
        """
        Constructor for P_Q_inner_data: Instance of either PQInnerData, PQInnerDataDc, PQInnerDataTemp, PQInnerDataTempDc.
        """
        self.pq = pq
        self.p = p
        self.q = q
        self.nonce = nonce
        self.server_nonce = server_nonce
        self.new_nonce = new_nonce

    def to_dict(self):
        return {
            '_': 'PQInnerData',
            'pq': self.pq,
            'p': self.p,
            'q': self.q,
            'nonce': self.nonce,
            'server_nonce': self.server_nonce,
            'new_nonce': self.new_nonce
        }

    def _bytes(self):
        return b''.join((
            b'\xecZ\xc9\x83',
            self.serialize_bytes(self.pq),
            self.serialize_bytes(self.p),
            self.serialize_bytes(self.q),
            self.nonce.to_bytes(16, 'little', signed=True),
            self.server_nonce.to_bytes(16, 'little', signed=True),
            self.new_nonce.to_bytes(32, 'little', signed=True),
        ))

    @classmethod
    def from_reader(cls, reader):
        _pq = reader.tgread_bytes()
        _p = reader.tgread_bytes()
        _q = reader.tgread_bytes()
        _nonce = reader.read_large_int(bits=128)
        _server_nonce = reader.read_large_int(bits=128)
        _new_nonce = reader.read_large_int(bits=256)
        return cls(pq=_pq, p=_p, q=_q, nonce=_nonce, server_nonce=_server_nonce, new_nonce=_new_nonce)


class PQInnerDataDc(TLObject):
    CONSTRUCTOR_ID = 0xa9f55f95
    SUBCLASS_OF_ID = 0x41701377

    def __init__(self, pq: bytes, p: bytes, q: bytes, nonce: int, server_nonce: int, new_nonce: int, dc: int):
        """
        Constructor for P_Q_inner_data: Instance of either PQInnerData, PQInnerDataDc, PQInnerDataTemp, PQInnerDataTempDc.
        """
        self.pq = pq
        self.p = p
        self.q = q
        self.nonce = nonce
        self.server_nonce = server_nonce
        self.new_nonce = new_nonce
        self.dc = dc

    def to_dict(self):
        return {
            '_': 'PQInnerDataDc',
            'pq': self.pq,
            'p': self.p,
            'q': self.q,
            'nonce': self.nonce,
            'server_nonce': self.server_nonce,
            'new_nonce': self.new_nonce,
            'dc': self.dc
        }

    def _bytes(self):
        return b''.join((
            b'\x95_\xf5\xa9',
            self.serialize_bytes(self.pq),
            self.serialize_bytes(self.p),
            self.serialize_bytes(self.q),
            self.nonce.to_bytes(16, 'little', signed=True),
            self.server_nonce.to_bytes(16, 'little', signed=True),
            self.new_nonce.to_bytes(32, 'little', signed=True),
            struct.pack('<i', self.dc),
        ))

    @classmethod
    def from_reader(cls, reader):
        _pq = reader.tgread_bytes()
        _p = reader.tgread_bytes()
        _q = reader.tgread_bytes()
        _nonce = reader.read_large_int(bits=128)
        _server_nonce = reader.read_large_int(bits=128)
        _new_nonce = reader.read_large_int(bits=256)
        _dc = reader.read_int()
        return cls(pq=_pq, p=_p, q=_q, nonce=_nonce, server_nonce=_server_nonce, new_nonce=_new_nonce, dc=_dc)


class PQInnerDataTemp(TLObject):
    CONSTRUCTOR_ID = 0x3c6a84d4
    SUBCLASS_OF_ID = 0x41701377

    def __init__(self, pq: bytes, p: bytes, q: bytes, nonce: int, server_nonce: int, new_nonce: int, expires_in: int):
        """
        Constructor for P_Q_inner_data: Instance of either PQInnerData, PQInnerDataDc, PQInnerDataTemp, PQInnerDataTempDc.
        """
        self.pq = pq
        self.p = p
        self.q = q
        self.nonce = nonce
        self.server_nonce = server_nonce
        self.new_nonce = new_nonce
        self.expires_in = expires_in

    def to_dict(self):
        return {
            '_': 'PQInnerDataTemp',
            'pq': self.pq,
            'p': self.p,
            'q': self.q,
            'nonce': self.nonce,
            'server_nonce': self.server_nonce,
            'new_nonce': self.new_nonce,
            'expires_in': self.expires_in
        }

    def _bytes(self):
        return b''.join((
            b'\xd4\x84j<',
            self.serialize_bytes(self.pq),
            self.serialize_bytes(self.p),
            self.serialize_bytes(self.q),
            self.nonce.to_bytes(16, 'little', signed=True),
            self.server_nonce.to_bytes(16, 'little', signed=True),
            self.new_nonce.to_bytes(32, 'little', signed=True),
            struct.pack('<i', self.expires_in),
        ))

    @classmethod
    def from_reader(cls, reader):
        _pq = reader.tgread_bytes()
        _p = reader.tgread_bytes()
        _q = reader.tgread_bytes()
        _nonce = reader.read_large_int(bits=128)
        _server_nonce = reader.read_large_int(bits=128)
        _new_nonce = reader.read_large_int(bits=256)
        _expires_in = reader.read_int()
        return cls(pq=_pq, p=_p, q=_q, nonce=_nonce, server_nonce=_server_nonce, new_nonce=_new_nonce, expires_in=_expires_in)


class PQInnerDataTempDc(TLObject):
    CONSTRUCTOR_ID = 0x56fddf88
    SUBCLASS_OF_ID = 0x41701377

    def __init__(self, pq: bytes, p: bytes, q: bytes, nonce: int, server_nonce: int, new_nonce: int, dc: int, expires_in: int):
        """
        Constructor for P_Q_inner_data: Instance of either PQInnerData, PQInnerDataDc, PQInnerDataTemp, PQInnerDataTempDc.
        """
        self.pq = pq
        self.p = p
        self.q = q
        self.nonce = nonce
        self.server_nonce = server_nonce
        self.new_nonce = new_nonce
        self.dc = dc
        self.expires_in = expires_in

    def to_dict(self):
        return {
            '_': 'PQInnerDataTempDc',
            'pq': self.pq,
            'p': self.p,
            'q': self.q,
            'nonce': self.nonce,
            'server_nonce': self.server_nonce,
            'new_nonce': self.new_nonce,
            'dc': self.dc,
            'expires_in': self.expires_in
        }

    def _bytes(self):
        return b''.join((
            b'\x88\xdf\xfdV',
            self.serialize_bytes(self.pq),
            self.serialize_bytes(self.p),
            self.serialize_bytes(self.q),
            self.nonce.to_bytes(16, 'little', signed=True),
            self.server_nonce.to_bytes(16, 'little', signed=True),
            self.new_nonce.to_bytes(32, 'little', signed=True),
            struct.pack('<i', self.dc),
            struct.pack('<i', self.expires_in),
        ))

    @classmethod
    def from_reader(cls, reader):
        _pq = reader.tgread_bytes()
        _p = reader.tgread_bytes()
        _q = reader.tgread_bytes()
        _nonce = reader.read_large_int(bits=128)
        _server_nonce = reader.read_large_int(bits=128)
        _new_nonce = reader.read_large_int(bits=256)
        _dc = reader.read_int()
        _expires_in = reader.read_int()
        return cls(pq=_pq, p=_p, q=_q, nonce=_nonce, server_nonce=_server_nonce, new_nonce=_new_nonce, dc=_dc, expires_in=_expires_in)


class Page(TLObject):
    CONSTRUCTOR_ID = 0x98657f0d
    SUBCLASS_OF_ID = 0xb438191e

    def __init__(self, url: str, blocks: List['TypePageBlock'], photos: List['TypePhoto'], documents: List['TypeDocument'], part: Optional[bool]=None, rtl: Optional[bool]=None, v2: Optional[bool]=None, views: Optional[int]=None):
        """
        Constructor for Page: Instance of Page.
        """
        self.url = url
        self.blocks = blocks
        self.photos = photos
        self.documents = documents
        self.part = part
        self.rtl = rtl
        self.v2 = v2
        self.views = views

    def to_dict(self):
        return {
            '_': 'Page',
            'url': self.url,
            'blocks': [] if self.blocks is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.blocks],
            'photos': [] if self.photos is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.photos],
            'documents': [] if self.documents is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.documents],
            'part': self.part,
            'rtl': self.rtl,
            'v2': self.v2,
            'views': self.views
        }

    def _bytes(self):
        return b''.join((
            b'\r\x7fe\x98',
            struct.pack('<I', (0 if self.part is None or self.part is False else 1) | (0 if self.rtl is None or self.rtl is False else 2) | (0 if self.v2 is None or self.v2 is False else 4) | (0 if self.views is None or self.views is False else 8)),
            self.serialize_bytes(self.url),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.blocks)),b''.join(x._bytes() for x in self.blocks),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.photos)),b''.join(x._bytes() for x in self.photos),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.documents)),b''.join(x._bytes() for x in self.documents),
            b'' if self.views is None or self.views is False else (struct.pack('<i', self.views)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _part = bool(flags & 1)
        _rtl = bool(flags & 2)
        _v2 = bool(flags & 4)
        _url = reader.tgread_string()
        reader.read_int()
        _blocks = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _blocks.append(_x)

        reader.read_int()
        _photos = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _photos.append(_x)

        reader.read_int()
        _documents = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _documents.append(_x)

        if flags & 8:
            _views = reader.read_int()
        else:
            _views = None
        return cls(url=_url, blocks=_blocks, photos=_photos, documents=_documents, part=_part, rtl=_rtl, v2=_v2, views=_views)


class PageBlockAnchor(TLObject):
    CONSTRUCTOR_ID = 0xce0d37b0
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, name: str):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.name = name

    def to_dict(self):
        return {
            '_': 'PageBlockAnchor',
            'name': self.name
        }

    def _bytes(self):
        return b''.join((
            b'\xb07\r\xce',
            self.serialize_bytes(self.name),
        ))

    @classmethod
    def from_reader(cls, reader):
        _name = reader.tgread_string()
        return cls(name=_name)


class PageBlockAudio(TLObject):
    CONSTRUCTOR_ID = 0x804361ea
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, audio_id: int, caption: 'TypePageCaption'):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.audio_id = audio_id
        self.caption = caption

    def to_dict(self):
        return {
            '_': 'PageBlockAudio',
            'audio_id': self.audio_id,
            'caption': self.caption.to_dict() if isinstance(self.caption, TLObject) else self.caption
        }

    def _bytes(self):
        return b''.join((
            b'\xeaaC\x80',
            struct.pack('<q', self.audio_id),
            self.caption._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _audio_id = reader.read_long()
        _caption = reader.tgread_object()
        return cls(audio_id=_audio_id, caption=_caption)


class PageBlockAuthorDate(TLObject):
    CONSTRUCTOR_ID = 0xbaafe5e0
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, author: 'TypeRichText', published_date: Optional[datetime]):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.author = author
        self.published_date = published_date

    def to_dict(self):
        return {
            '_': 'PageBlockAuthorDate',
            'author': self.author.to_dict() if isinstance(self.author, TLObject) else self.author,
            'published_date': self.published_date
        }

    def _bytes(self):
        return b''.join((
            b'\xe0\xe5\xaf\xba',
            self.author._bytes(),
            self.serialize_datetime(self.published_date),
        ))

    @classmethod
    def from_reader(cls, reader):
        _author = reader.tgread_object()
        _published_date = reader.tgread_date()
        return cls(author=_author, published_date=_published_date)


class PageBlockBlockquote(TLObject):
    CONSTRUCTOR_ID = 0x263d7c26
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, text: 'TypeRichText', caption: 'TypeRichText'):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.text = text
        self.caption = caption

    def to_dict(self):
        return {
            '_': 'PageBlockBlockquote',
            'text': self.text.to_dict() if isinstance(self.text, TLObject) else self.text,
            'caption': self.caption.to_dict() if isinstance(self.caption, TLObject) else self.caption
        }

    def _bytes(self):
        return b''.join((
            b'&|=&',
            self.text._bytes(),
            self.caption._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_object()
        _caption = reader.tgread_object()
        return cls(text=_text, caption=_caption)


class PageBlockChannel(TLObject):
    CONSTRUCTOR_ID = 0xef1751b5
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, channel: 'TypeChat'):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.channel = channel

    def to_dict(self):
        return {
            '_': 'PageBlockChannel',
            'channel': self.channel.to_dict() if isinstance(self.channel, TLObject) else self.channel
        }

    def _bytes(self):
        return b''.join((
            b'\xb5Q\x17\xef',
            self.channel._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel = reader.tgread_object()
        return cls(channel=_channel)


class PageBlockCollage(TLObject):
    CONSTRUCTOR_ID = 0x65a0fa4d
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, items: List['TypePageBlock'], caption: 'TypePageCaption'):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.items = items
        self.caption = caption

    def to_dict(self):
        return {
            '_': 'PageBlockCollage',
            'items': [] if self.items is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.items],
            'caption': self.caption.to_dict() if isinstance(self.caption, TLObject) else self.caption
        }

    def _bytes(self):
        return b''.join((
            b'M\xfa\xa0e',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.items)),b''.join(x._bytes() for x in self.items),
            self.caption._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _items = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _items.append(_x)

        _caption = reader.tgread_object()
        return cls(items=_items, caption=_caption)


class PageBlockCover(TLObject):
    CONSTRUCTOR_ID = 0x39f23300
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, cover: 'TypePageBlock'):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.cover = cover

    def to_dict(self):
        return {
            '_': 'PageBlockCover',
            'cover': self.cover.to_dict() if isinstance(self.cover, TLObject) else self.cover
        }

    def _bytes(self):
        return b''.join((
            b'\x003\xf29',
            self.cover._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _cover = reader.tgread_object()
        return cls(cover=_cover)


class PageBlockDetails(TLObject):
    CONSTRUCTOR_ID = 0x76768bed
    SUBCLASS_OF_ID = 0x1aca5644

    # noinspection PyShadowingBuiltins
    def __init__(self, blocks: List['TypePageBlock'], title: 'TypeRichText', open: Optional[bool]=None):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.blocks = blocks
        self.title = title
        self.open = open

    def to_dict(self):
        return {
            '_': 'PageBlockDetails',
            'blocks': [] if self.blocks is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.blocks],
            'title': self.title.to_dict() if isinstance(self.title, TLObject) else self.title,
            'open': self.open
        }

    def _bytes(self):
        return b''.join((
            b'\xed\x8bvv',
            struct.pack('<I', (0 if self.open is None or self.open is False else 1)),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.blocks)),b''.join(x._bytes() for x in self.blocks),
            self.title._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _open = bool(flags & 1)
        reader.read_int()
        _blocks = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _blocks.append(_x)

        _title = reader.tgread_object()
        return cls(blocks=_blocks, title=_title, open=_open)


class PageBlockDivider(TLObject):
    CONSTRUCTOR_ID = 0xdb20b188
    SUBCLASS_OF_ID = 0x1aca5644

    def to_dict(self):
        return {
            '_': 'PageBlockDivider'
        }

    def _bytes(self):
        return b''.join((
            b'\x88\xb1 \xdb',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class PageBlockEmbed(TLObject):
    CONSTRUCTOR_ID = 0xa8718dc5
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, caption: 'TypePageCaption', full_width: Optional[bool]=None, allow_scrolling: Optional[bool]=None, url: Optional[str]=None, html: Optional[str]=None, poster_photo_id: Optional[int]=None, w: Optional[int]=None, h: Optional[int]=None):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.caption = caption
        self.full_width = full_width
        self.allow_scrolling = allow_scrolling
        self.url = url
        self.html = html
        self.poster_photo_id = poster_photo_id
        self.w = w
        self.h = h

    def to_dict(self):
        return {
            '_': 'PageBlockEmbed',
            'caption': self.caption.to_dict() if isinstance(self.caption, TLObject) else self.caption,
            'full_width': self.full_width,
            'allow_scrolling': self.allow_scrolling,
            'url': self.url,
            'html': self.html,
            'poster_photo_id': self.poster_photo_id,
            'w': self.w,
            'h': self.h
        }

    def _bytes(self):
        assert ((self.w or self.w is not None) and (self.h or self.h is not None)) or ((self.w is None or self.w is False) and (self.h is None or self.h is False)), 'w, h parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'\xc5\x8dq\xa8',
            struct.pack('<I', (0 if self.full_width is None or self.full_width is False else 1) | (0 if self.allow_scrolling is None or self.allow_scrolling is False else 8) | (0 if self.url is None or self.url is False else 2) | (0 if self.html is None or self.html is False else 4) | (0 if self.poster_photo_id is None or self.poster_photo_id is False else 16) | (0 if self.w is None or self.w is False else 32) | (0 if self.h is None or self.h is False else 32)),
            b'' if self.url is None or self.url is False else (self.serialize_bytes(self.url)),
            b'' if self.html is None or self.html is False else (self.serialize_bytes(self.html)),
            b'' if self.poster_photo_id is None or self.poster_photo_id is False else (struct.pack('<q', self.poster_photo_id)),
            b'' if self.w is None or self.w is False else (struct.pack('<i', self.w)),
            b'' if self.h is None or self.h is False else (struct.pack('<i', self.h)),
            self.caption._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _full_width = bool(flags & 1)
        _allow_scrolling = bool(flags & 8)
        if flags & 2:
            _url = reader.tgread_string()
        else:
            _url = None
        if flags & 4:
            _html = reader.tgread_string()
        else:
            _html = None
        if flags & 16:
            _poster_photo_id = reader.read_long()
        else:
            _poster_photo_id = None
        if flags & 32:
            _w = reader.read_int()
        else:
            _w = None
        if flags & 32:
            _h = reader.read_int()
        else:
            _h = None
        _caption = reader.tgread_object()
        return cls(caption=_caption, full_width=_full_width, allow_scrolling=_allow_scrolling, url=_url, html=_html, poster_photo_id=_poster_photo_id, w=_w, h=_h)


class PageBlockEmbedPost(TLObject):
    CONSTRUCTOR_ID = 0xf259a80b
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, url: str, webpage_id: int, author_photo_id: int, author: str, date: Optional[datetime], blocks: List['TypePageBlock'], caption: 'TypePageCaption'):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.url = url
        self.webpage_id = webpage_id
        self.author_photo_id = author_photo_id
        self.author = author
        self.date = date
        self.blocks = blocks
        self.caption = caption

    def to_dict(self):
        return {
            '_': 'PageBlockEmbedPost',
            'url': self.url,
            'webpage_id': self.webpage_id,
            'author_photo_id': self.author_photo_id,
            'author': self.author,
            'date': self.date,
            'blocks': [] if self.blocks is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.blocks],
            'caption': self.caption.to_dict() if isinstance(self.caption, TLObject) else self.caption
        }

    def _bytes(self):
        return b''.join((
            b'\x0b\xa8Y\xf2',
            self.serialize_bytes(self.url),
            struct.pack('<q', self.webpage_id),
            struct.pack('<q', self.author_photo_id),
            self.serialize_bytes(self.author),
            self.serialize_datetime(self.date),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.blocks)),b''.join(x._bytes() for x in self.blocks),
            self.caption._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _url = reader.tgread_string()
        _webpage_id = reader.read_long()
        _author_photo_id = reader.read_long()
        _author = reader.tgread_string()
        _date = reader.tgread_date()
        reader.read_int()
        _blocks = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _blocks.append(_x)

        _caption = reader.tgread_object()
        return cls(url=_url, webpage_id=_webpage_id, author_photo_id=_author_photo_id, author=_author, date=_date, blocks=_blocks, caption=_caption)


class PageBlockFooter(TLObject):
    CONSTRUCTOR_ID = 0x48870999
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, text: 'TypeRichText'):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.text = text

    def to_dict(self):
        return {
            '_': 'PageBlockFooter',
            'text': self.text.to_dict() if isinstance(self.text, TLObject) else self.text
        }

    def _bytes(self):
        return b''.join((
            b'\x99\t\x87H',
            self.text._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_object()
        return cls(text=_text)


class PageBlockHeader(TLObject):
    CONSTRUCTOR_ID = 0xbfd064ec
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, text: 'TypeRichText'):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.text = text

    def to_dict(self):
        return {
            '_': 'PageBlockHeader',
            'text': self.text.to_dict() if isinstance(self.text, TLObject) else self.text
        }

    def _bytes(self):
        return b''.join((
            b'\xecd\xd0\xbf',
            self.text._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_object()
        return cls(text=_text)


class PageBlockKicker(TLObject):
    CONSTRUCTOR_ID = 0x1e148390
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, text: 'TypeRichText'):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.text = text

    def to_dict(self):
        return {
            '_': 'PageBlockKicker',
            'text': self.text.to_dict() if isinstance(self.text, TLObject) else self.text
        }

    def _bytes(self):
        return b''.join((
            b'\x90\x83\x14\x1e',
            self.text._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_object()
        return cls(text=_text)


class PageBlockList(TLObject):
    CONSTRUCTOR_ID = 0xe4e88011
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, items: List['TypePageListItem']):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.items = items

    def to_dict(self):
        return {
            '_': 'PageBlockList',
            'items': [] if self.items is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.items]
        }

    def _bytes(self):
        return b''.join((
            b'\x11\x80\xe8\xe4',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.items)),b''.join(x._bytes() for x in self.items),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _items = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _items.append(_x)

        return cls(items=_items)


class PageBlockMap(TLObject):
    CONSTRUCTOR_ID = 0xa44f3ef6
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, geo: 'TypeGeoPoint', zoom: int, w: int, h: int, caption: 'TypePageCaption'):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.geo = geo
        self.zoom = zoom
        self.w = w
        self.h = h
        self.caption = caption

    def to_dict(self):
        return {
            '_': 'PageBlockMap',
            'geo': self.geo.to_dict() if isinstance(self.geo, TLObject) else self.geo,
            'zoom': self.zoom,
            'w': self.w,
            'h': self.h,
            'caption': self.caption.to_dict() if isinstance(self.caption, TLObject) else self.caption
        }

    def _bytes(self):
        return b''.join((
            b'\xf6>O\xa4',
            self.geo._bytes(),
            struct.pack('<i', self.zoom),
            struct.pack('<i', self.w),
            struct.pack('<i', self.h),
            self.caption._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _geo = reader.tgread_object()
        _zoom = reader.read_int()
        _w = reader.read_int()
        _h = reader.read_int()
        _caption = reader.tgread_object()
        return cls(geo=_geo, zoom=_zoom, w=_w, h=_h, caption=_caption)


class PageBlockOrderedList(TLObject):
    CONSTRUCTOR_ID = 0x9a8ae1e1
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, items: List['TypePageListOrderedItem']):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.items = items

    def to_dict(self):
        return {
            '_': 'PageBlockOrderedList',
            'items': [] if self.items is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.items]
        }

    def _bytes(self):
        return b''.join((
            b'\xe1\xe1\x8a\x9a',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.items)),b''.join(x._bytes() for x in self.items),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _items = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _items.append(_x)

        return cls(items=_items)


class PageBlockParagraph(TLObject):
    CONSTRUCTOR_ID = 0x467a0766
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, text: 'TypeRichText'):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.text = text

    def to_dict(self):
        return {
            '_': 'PageBlockParagraph',
            'text': self.text.to_dict() if isinstance(self.text, TLObject) else self.text
        }

    def _bytes(self):
        return b''.join((
            b'f\x07zF',
            self.text._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_object()
        return cls(text=_text)


class PageBlockPhoto(TLObject):
    CONSTRUCTOR_ID = 0x1759c560
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, photo_id: int, caption: 'TypePageCaption', url: Optional[str]=None, webpage_id: Optional[int]=None):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.photo_id = photo_id
        self.caption = caption
        self.url = url
        self.webpage_id = webpage_id

    def to_dict(self):
        return {
            '_': 'PageBlockPhoto',
            'photo_id': self.photo_id,
            'caption': self.caption.to_dict() if isinstance(self.caption, TLObject) else self.caption,
            'url': self.url,
            'webpage_id': self.webpage_id
        }

    def _bytes(self):
        assert ((self.url or self.url is not None) and (self.webpage_id or self.webpage_id is not None)) or ((self.url is None or self.url is False) and (self.webpage_id is None or self.webpage_id is False)), 'url, webpage_id parameters must all be False-y (like None) or all me True-y'
        return b''.join((
            b'`\xc5Y\x17',
            struct.pack('<I', (0 if self.url is None or self.url is False else 1) | (0 if self.webpage_id is None or self.webpage_id is False else 1)),
            struct.pack('<q', self.photo_id),
            self.caption._bytes(),
            b'' if self.url is None or self.url is False else (self.serialize_bytes(self.url)),
            b'' if self.webpage_id is None or self.webpage_id is False else (struct.pack('<q', self.webpage_id)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _photo_id = reader.read_long()
        _caption = reader.tgread_object()
        if flags & 1:
            _url = reader.tgread_string()
        else:
            _url = None
        if flags & 1:
            _webpage_id = reader.read_long()
        else:
            _webpage_id = None
        return cls(photo_id=_photo_id, caption=_caption, url=_url, webpage_id=_webpage_id)


class PageBlockPreformatted(TLObject):
    CONSTRUCTOR_ID = 0xc070d93e
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, text: 'TypeRichText', language: str):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.text = text
        self.language = language

    def to_dict(self):
        return {
            '_': 'PageBlockPreformatted',
            'text': self.text.to_dict() if isinstance(self.text, TLObject) else self.text,
            'language': self.language
        }

    def _bytes(self):
        return b''.join((
            b'>\xd9p\xc0',
            self.text._bytes(),
            self.serialize_bytes(self.language),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_object()
        _language = reader.tgread_string()
        return cls(text=_text, language=_language)


class PageBlockPullquote(TLObject):
    CONSTRUCTOR_ID = 0x4f4456d3
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, text: 'TypeRichText', caption: 'TypeRichText'):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.text = text
        self.caption = caption

    def to_dict(self):
        return {
            '_': 'PageBlockPullquote',
            'text': self.text.to_dict() if isinstance(self.text, TLObject) else self.text,
            'caption': self.caption.to_dict() if isinstance(self.caption, TLObject) else self.caption
        }

    def _bytes(self):
        return b''.join((
            b'\xd3VDO',
            self.text._bytes(),
            self.caption._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_object()
        _caption = reader.tgread_object()
        return cls(text=_text, caption=_caption)


class PageBlockRelatedArticles(TLObject):
    CONSTRUCTOR_ID = 0x16115a96
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, title: 'TypeRichText', articles: List['TypePageRelatedArticle']):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.title = title
        self.articles = articles

    def to_dict(self):
        return {
            '_': 'PageBlockRelatedArticles',
            'title': self.title.to_dict() if isinstance(self.title, TLObject) else self.title,
            'articles': [] if self.articles is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.articles]
        }

    def _bytes(self):
        return b''.join((
            b'\x96Z\x11\x16',
            self.title._bytes(),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.articles)),b''.join(x._bytes() for x in self.articles),
        ))

    @classmethod
    def from_reader(cls, reader):
        _title = reader.tgread_object()
        reader.read_int()
        _articles = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _articles.append(_x)

        return cls(title=_title, articles=_articles)


class PageBlockSlideshow(TLObject):
    CONSTRUCTOR_ID = 0x31f9590
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, items: List['TypePageBlock'], caption: 'TypePageCaption'):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.items = items
        self.caption = caption

    def to_dict(self):
        return {
            '_': 'PageBlockSlideshow',
            'items': [] if self.items is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.items],
            'caption': self.caption.to_dict() if isinstance(self.caption, TLObject) else self.caption
        }

    def _bytes(self):
        return b''.join((
            b'\x90\x95\x1f\x03',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.items)),b''.join(x._bytes() for x in self.items),
            self.caption._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _items = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _items.append(_x)

        _caption = reader.tgread_object()
        return cls(items=_items, caption=_caption)


class PageBlockSubheader(TLObject):
    CONSTRUCTOR_ID = 0xf12bb6e1
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, text: 'TypeRichText'):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.text = text

    def to_dict(self):
        return {
            '_': 'PageBlockSubheader',
            'text': self.text.to_dict() if isinstance(self.text, TLObject) else self.text
        }

    def _bytes(self):
        return b''.join((
            b'\xe1\xb6+\xf1',
            self.text._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_object()
        return cls(text=_text)


class PageBlockSubtitle(TLObject):
    CONSTRUCTOR_ID = 0x8ffa9a1f
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, text: 'TypeRichText'):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.text = text

    def to_dict(self):
        return {
            '_': 'PageBlockSubtitle',
            'text': self.text.to_dict() if isinstance(self.text, TLObject) else self.text
        }

    def _bytes(self):
        return b''.join((
            b'\x1f\x9a\xfa\x8f',
            self.text._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_object()
        return cls(text=_text)


class PageBlockTable(TLObject):
    CONSTRUCTOR_ID = 0xbf4dea82
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, title: 'TypeRichText', rows: List['TypePageTableRow'], bordered: Optional[bool]=None, striped: Optional[bool]=None):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.title = title
        self.rows = rows
        self.bordered = bordered
        self.striped = striped

    def to_dict(self):
        return {
            '_': 'PageBlockTable',
            'title': self.title.to_dict() if isinstance(self.title, TLObject) else self.title,
            'rows': [] if self.rows is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.rows],
            'bordered': self.bordered,
            'striped': self.striped
        }

    def _bytes(self):
        return b''.join((
            b'\x82\xeaM\xbf',
            struct.pack('<I', (0 if self.bordered is None or self.bordered is False else 1) | (0 if self.striped is None or self.striped is False else 2)),
            self.title._bytes(),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.rows)),b''.join(x._bytes() for x in self.rows),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _bordered = bool(flags & 1)
        _striped = bool(flags & 2)
        _title = reader.tgread_object()
        reader.read_int()
        _rows = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _rows.append(_x)

        return cls(title=_title, rows=_rows, bordered=_bordered, striped=_striped)


class PageBlockTitle(TLObject):
    CONSTRUCTOR_ID = 0x70abc3fd
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, text: 'TypeRichText'):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.text = text

    def to_dict(self):
        return {
            '_': 'PageBlockTitle',
            'text': self.text.to_dict() if isinstance(self.text, TLObject) else self.text
        }

    def _bytes(self):
        return b''.join((
            b'\xfd\xc3\xabp',
            self.text._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_object()
        return cls(text=_text)


class PageBlockUnsupported(TLObject):
    CONSTRUCTOR_ID = 0x13567e8a
    SUBCLASS_OF_ID = 0x1aca5644

    def to_dict(self):
        return {
            '_': 'PageBlockUnsupported'
        }

    def _bytes(self):
        return b''.join((
            b'\x8a~V\x13',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class PageBlockVideo(TLObject):
    CONSTRUCTOR_ID = 0x7c8fe7b6
    SUBCLASS_OF_ID = 0x1aca5644

    def __init__(self, video_id: int, caption: 'TypePageCaption', autoplay: Optional[bool]=None, loop: Optional[bool]=None):
        """
        Constructor for PageBlock: Instance of either PageBlockUnsupported, PageBlockTitle, PageBlockSubtitle, PageBlockAuthorDate, PageBlockHeader, PageBlockSubheader, PageBlockParagraph, PageBlockPreformatted, PageBlockFooter, PageBlockDivider, PageBlockAnchor, PageBlockList, PageBlockBlockquote, PageBlockPullquote, PageBlockPhoto, PageBlockVideo, PageBlockCover, PageBlockEmbed, PageBlockEmbedPost, PageBlockCollage, PageBlockSlideshow, PageBlockChannel, PageBlockAudio, PageBlockKicker, PageBlockTable, PageBlockOrderedList, PageBlockDetails, PageBlockRelatedArticles, PageBlockMap.
        """
        self.video_id = video_id
        self.caption = caption
        self.autoplay = autoplay
        self.loop = loop

    def to_dict(self):
        return {
            '_': 'PageBlockVideo',
            'video_id': self.video_id,
            'caption': self.caption.to_dict() if isinstance(self.caption, TLObject) else self.caption,
            'autoplay': self.autoplay,
            'loop': self.loop
        }

    def _bytes(self):
        return b''.join((
            b'\xb6\xe7\x8f|',
            struct.pack('<I', (0 if self.autoplay is None or self.autoplay is False else 1) | (0 if self.loop is None or self.loop is False else 2)),
            struct.pack('<q', self.video_id),
            self.caption._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _autoplay = bool(flags & 1)
        _loop = bool(flags & 2)
        _video_id = reader.read_long()
        _caption = reader.tgread_object()
        return cls(video_id=_video_id, caption=_caption, autoplay=_autoplay, loop=_loop)


class PageCaption(TLObject):
    CONSTRUCTOR_ID = 0x6f747657
    SUBCLASS_OF_ID = 0x29b8eeb3

    def __init__(self, text: 'TypeRichText', credit: 'TypeRichText'):
        """
        Constructor for PageCaption: Instance of PageCaption.
        """
        self.text = text
        self.credit = credit

    def to_dict(self):
        return {
            '_': 'PageCaption',
            'text': self.text.to_dict() if isinstance(self.text, TLObject) else self.text,
            'credit': self.credit.to_dict() if isinstance(self.credit, TLObject) else self.credit
        }

    def _bytes(self):
        return b''.join((
            b'Wvto',
            self.text._bytes(),
            self.credit._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_object()
        _credit = reader.tgread_object()
        return cls(text=_text, credit=_credit)


class PageListItemBlocks(TLObject):
    CONSTRUCTOR_ID = 0x25e073fc
    SUBCLASS_OF_ID = 0x8caebcb1

    def __init__(self, blocks: List['TypePageBlock']):
        """
        Constructor for PageListItem: Instance of either PageListItemText, PageListItemBlocks.
        """
        self.blocks = blocks

    def to_dict(self):
        return {
            '_': 'PageListItemBlocks',
            'blocks': [] if self.blocks is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.blocks]
        }

    def _bytes(self):
        return b''.join((
            b'\xfcs\xe0%',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.blocks)),b''.join(x._bytes() for x in self.blocks),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _blocks = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _blocks.append(_x)

        return cls(blocks=_blocks)


class PageListItemText(TLObject):
    CONSTRUCTOR_ID = 0xb92fb6cd
    SUBCLASS_OF_ID = 0x8caebcb1

    def __init__(self, text: 'TypeRichText'):
        """
        Constructor for PageListItem: Instance of either PageListItemText, PageListItemBlocks.
        """
        self.text = text

    def to_dict(self):
        return {
            '_': 'PageListItemText',
            'text': self.text.to_dict() if isinstance(self.text, TLObject) else self.text
        }

    def _bytes(self):
        return b''.join((
            b'\xcd\xb6/\xb9',
            self.text._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _text = reader.tgread_object()
        return cls(text=_text)


class PageListOrderedItemBlocks(TLObject):
    CONSTRUCTOR_ID = 0x98dd8936
    SUBCLASS_OF_ID = 0xeeda0eb8

    def __init__(self, num: str, blocks: List['TypePageBlock']):
        """
        Constructor for PageListOrderedItem: Instance of either PageListOrderedItemText, PageListOrderedItemBlocks.
        """
        self.num = num
        self.blocks = blocks

    def to_dict(self):
        return {
            '_': 'PageListOrderedItemBlocks',
            'num': self.num,
            'blocks': [] if self.blocks is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.blocks]
        }

    def _bytes(self):
        return b''.join((
            b'6\x89\xdd\x98',
            self.serialize_bytes(self.num),
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.blocks)),b''.join(x._bytes() for x in self.blocks),
        ))

    @classmethod
    def from_reader(cls, reader):
        _num = reader.tgread_string()
        reader.read_int()
        _blocks = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _blocks.append(_x)

        return cls(num=_num, blocks=_blocks)


class PageListOrderedItemText(TLObject):
    CONSTRUCTOR_ID = 0x5e068047
    SUBCLASS_OF_ID = 0xeeda0eb8

    def __init__(self, num: str, text: 'TypeRichText'):
        """
        Constructor for PageListOrderedItem: Instance of either PageListOrderedItemText, PageListOrderedItemBlocks.
        """
        self.num = num
        self.text = text

    def to_dict(self):
        return {
            '_': 'PageListOrderedItemText',
            'num': self.num,
            'text': self.text.to_dict() if isinstance(self.text, TLObject) else self.text
        }

    def _bytes(self):
        return b''.join((
            b'G\x80\x06^',
            self.serialize_bytes(self.num),
            self.text._bytes(),
        ))

    @classmethod
    def from_reader(cls, reader):
        _num = reader.tgread_string()
        _text = reader.tgread_object()
        return cls(num=_num, text=_text)


class PageRelatedArticle(TLObject):
    CONSTRUCTOR_ID = 0xb390dc08
    SUBCLASS_OF_ID = 0x36d05822

    def __init__(self, url: str, webpage_id: int, title: Optional[str]=None, description: Optional[str]=None, photo_id: Optional[int]=None, author: Optional[str]=None, published_date: Optional[datetime]=None):
        """
        Constructor for PageRelatedArticle: Instance of PageRelatedArticle.
        """
        self.url = url
        self.webpage_id = webpage_id
        self.title = title
        self.description = description
        self.photo_id = photo_id
        self.author = author
        self.published_date = published_date

    def to_dict(self):
        return {
            '_': 'PageRelatedArticle',
            'url': self.url,
            'webpage_id': self.webpage_id,
            'title': self.title,
            'description': self.description,
            'photo_id': self.photo_id,
            'author': self.author,
            'published_date': self.published_date
        }

    def _bytes(self):
        return b''.join((
            b'\x08\xdc\x90\xb3',
            struct.pack('<I', (0 if self.title is None or self.title is False else 1) | (0 if self.description is None or self.description is False else 2) | (0 if self.photo_id is None or self.photo_id is False else 4) | (0 if self.author is None or self.author is False else 8) | (0 if self.published_date is None or self.published_date is False else 16)),
            self.serialize_bytes(self.url),
            struct.pack('<q', self.webpage_id),
            b'' if self.title is None or self.title is False else (self.serialize_bytes(self.title)),
            b'' if self.description is None or self.description is False else (self.serialize_bytes(self.description)),
            b'' if self.photo_id is None or self.photo_id is False else (struct.pack('<q', self.photo_id)),
            b'' if self.author is None or self.author is False else (self.serialize_bytes(self.author)),
            b'' if self.published_date is None or self.published_date is False else (self.serialize_datetime(self.published_date)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _url = reader.tgread_string()
        _webpage_id = reader.read_long()
        if flags & 1:
            _title = reader.tgread_string()
        else:
            _title = None
        if flags & 2:
            _description = reader.tgread_string()
        else:
            _description = None
        if flags & 4:
            _photo_id = reader.read_long()
        else:
            _photo_id = None
        if flags & 8:
            _author = reader.tgread_string()
        else:
            _author = None
        if flags & 16:
            _published_date = reader.tgread_date()
        else:
            _published_date = None
        return cls(url=_url, webpage_id=_webpage_id, title=_title, description=_description, photo_id=_photo_id, author=_author, published_date=_published_date)


class PageTableCell(TLObject):
    CONSTRUCTOR_ID = 0x34566b6a
    SUBCLASS_OF_ID = 0xb0eb3054

    def __init__(self, header: Optional[bool]=None, align_center: Optional[bool]=None, align_right: Optional[bool]=None, valign_middle: Optional[bool]=None, valign_bottom: Optional[bool]=None, text: Optional['TypeRichText']=None, colspan: Optional[int]=None, rowspan: Optional[int]=None):
        """
        Constructor for PageTableCell: Instance of PageTableCell.
        """
        self.header = header
        self.align_center = align_center
        self.align_right = align_right
        self.valign_middle = valign_middle
        self.valign_bottom = valign_bottom
        self.text = text
        self.colspan = colspan
        self.rowspan = rowspan

    def to_dict(self):
        return {
            '_': 'PageTableCell',
            'header': self.header,
            'align_center': self.align_center,
            'align_right': self.align_right,
            'valign_middle': self.valign_middle,
            'valign_bottom': self.valign_bottom,
            'text': self.text.to_dict() if isinstance(self.text, TLObject) else self.text,
            'colspan': self.colspan,
            'rowspan': self.rowspan
        }

    def _bytes(self):
        return b''.join((
            b'jkV4',
            struct.pack('<I', (0 if self.header is None or self.header is False else 1) | (0 if self.align_center is None or self.align_center is False else 8) | (0 if self.align_right is None or self.align_right is False else 16) | (0 if self.valign_middle is None or self.valign_middle is False else 32) | (0 if self.valign_bottom is None or self.valign_bottom is False else 64) | (0 if self.text is None or self.text is False else 128) | (0 if self.colspan is None or self.colspan is False else 2) | (0 if self.rowspan is None or self.rowspan is False else 4)),
            b'' if self.text is None or self.text is False else (self.text._bytes()),
            b'' if self.colspan is None or self.colspan is False else (struct.pack('<i', self.colspan)),
            b'' if self.rowspan is None or self.rowspan is False else (struct.pack('<i', self.rowspan)),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        _header = bool(flags & 1)
        _align_center = bool(flags & 8)
        _align_right = bool(flags & 16)
        _valign_middle = bool(flags & 32)
        _valign_bottom = bool(flags & 64)
        if flags & 128:
            _text = reader.tgread_object()
        else:
            _text = None
        if flags & 2:
            _colspan = reader.read_int()
        else:
            _colspan = None
        if flags & 4:
            _rowspan = reader.read_int()
        else:
            _rowspan = None
        return cls(header=_header, align_center=_align_center, align_right=_align_right, valign_middle=_valign_middle, valign_bottom=_valign_bottom, text=_text, colspan=_colspan, rowspan=_rowspan)


class PageTableRow(TLObject):
    CONSTRUCTOR_ID = 0xe0c0c5e5
    SUBCLASS_OF_ID = 0x59acee11

    def __init__(self, cells: List['TypePageTableCell']):
        """
        Constructor for PageTableRow: Instance of PageTableRow.
        """
        self.cells = cells

    def to_dict(self):
        return {
            '_': 'PageTableRow',
            'cells': [] if self.cells is None else [x.to_dict() if isinstance(x, TLObject) else x for x in self.cells]
        }

    def _bytes(self):
        return b''.join((
            b'\xe5\xc5\xc0\xe0',
            b'\x15\xc4\xb5\x1c',struct.pack('<i', len(self.cells)),b''.join(x._bytes() for x in self.cells),
        ))

    @classmethod
    def from_reader(cls, reader):
        reader.read_int()
        _cells = []
        for _ in range(reader.read_int()):
            _x = reader.tgread_object()
            _cells.append(_x)

        return cls(cells=_cells)


class PasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow(TLObject):
    CONSTRUCTOR_ID = 0x3a912d4a
    SUBCLASS_OF_ID = 0x37bcf5cc

    def __init__(self, salt1: bytes, salt2: bytes, g: int, p: bytes):
        """
        Constructor for PasswordKdfAlgo: Instance of either PasswordKdfAlgoUnknown, PasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow.
        """
        self.salt1 = salt1
        self.salt2 = salt2
        self.g = g
        self.p = p

    def to_dict(self):
        return {
            '_': 'PasswordKdfAlgoSHA256SHA256PBKDF2HMACSHA512iter100000SHA256ModPow',
            'salt1': self.salt1,
            'salt2': self.salt2,
            'g': self.g,
            'p': self.p
        }

    def _bytes(self):
        return b''.join((
            b'J-\x91:',
            self.serialize_bytes(self.salt1),
            self.serialize_bytes(self.salt2),
            struct.pack('<i', self.g),
            self.serialize_bytes(self.p),
        ))

    @classmethod
    def from_reader(cls, reader):
        _salt1 = reader.tgread_bytes()
        _salt2 = reader.tgread_bytes()
        _g = reader.read_int()
        _p = reader.tgread_bytes()
        return cls(salt1=_salt1, salt2=_salt2, g=_g, p=_p)


class PasswordKdfAlgoUnknown(TLObject):
    CONSTRUCTOR_ID = 0xd45ab096
    SUBCLASS_OF_ID = 0x37bcf5cc

    def to_dict(self):
        return {
            '_': 'PasswordKdfAlgoUnknown'
        }

    def _bytes(self):
        return b''.join((
            b'\x96\xb0Z\xd4',
        ))

    @classmethod
    def from_reader(cls, reader):
        return cls()


class PaymentCharge(TLObject):
    CONSTRUCTOR_ID = 0xea02c27e
    SUBCLASS_OF_ID = 0x3cc830d9

    # noinspection PyShadowingBuiltins
    def __init__(self, id: str, provider_charge_id: str):
        """
        Constructor for PaymentCharge: Instance of PaymentCharge.
        """
        self.id = id
        self.provider_charge_id = provider_charge_id

    def to_dict(self):
        return {
            '_': 'PaymentCharge',
            'id': self.id,
            'provider_charge_id': self.provider_charge_id
        }

    def _bytes(self):
        return b''.join((
            b'~\xc2\x02\xea',
            self.serialize_bytes(self.id),
            self.serialize_bytes(self.provider_charge_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.tgread_string()
        _provider_charge_id = reader.tgread_string()
        return cls(id=_id, provider_charge_id=_provider_charge_id)


class PaymentFormMethod(TLObject):
    CONSTRUCTOR_ID = 0x88f8f21b
    SUBCLASS_OF_ID = 0x3fc1c816

    def __init__(self, url: str, title: str):
        """
        Constructor for PaymentFormMethod: Instance of PaymentFormMethod.
        """
        self.url = url
        self.title = title

    def to_dict(self):
        return {
            '_': 'PaymentFormMethod',
            'url': self.url,
            'title': self.title
        }

    def _bytes(self):
        return b''.join((
            b'\x1b\xf2\xf8\x88',
            self.serialize_bytes(self.url),
            self.serialize_bytes(self.title),
        ))

    @classmethod
    def from_reader(cls, reader):
        _url = reader.tgread_string()
        _title = reader.tgread_string()
        return cls(url=_url, title=_title)


class PaymentRequestedInfo(TLObject):
    CONSTRUCTOR_ID = 0x909c3f94
    SUBCLASS_OF_ID = 0x8db03146

    def __init__(self, name: Optional[str]=None, phone: Optional[str]=None, email: Optional[str]=None, shipping_address: Optional['TypePostAddress']=None):
        """
        Constructor for PaymentRequestedInfo: Instance of PaymentRequestedInfo.
        """
        self.name = name
        self.phone = phone
        self.email = email
        self.shipping_address = shipping_address

    def to_dict(self):
        return {
            '_': 'PaymentRequestedInfo',
            'name': self.name,
            'phone': self.phone,
            'email': self.email,
            'shipping_address': self.shipping_address.to_dict() if isinstance(self.shipping_address, TLObject) else self.shipping_address
        }

    def _bytes(self):
        return b''.join((
            b'\x94?\x9c\x90',
            struct.pack('<I', (0 if self.name is None or self.name is False else 1) | (0 if self.phone is None or self.phone is False else 2) | (0 if self.email is None or self.email is False else 4) | (0 if self.shipping_address is None or self.shipping_address is False else 8)),
            b'' if self.name is None or self.name is False else (self.serialize_bytes(self.name)),
            b'' if self.phone is None or self.phone is False else (self.serialize_bytes(self.phone)),
            b'' if self.email is None or self.email is False else (self.serialize_bytes(self.email)),
            b'' if self.shipping_address is None or self.shipping_address is False else (self.shipping_address._bytes()),
        ))

    @classmethod
    def from_reader(cls, reader):
        flags = reader.read_int()

        if flags & 1:
            _name = reader.tgread_string()
        else:
            _name = None
        if flags & 2:
            _phone = reader.tgread_string()
        else:
            _phone = None
        if flags & 4:
            _email = reader.tgread_string()
        else:
            _email = None
        if flags & 8:
            _shipping_address = reader.tgread_object()
        else:
            _shipping_address = None
        return cls(name=_name, phone=_phone, email=_email, shipping_address=_shipping_address)


class PaymentSavedCredentialsCard(TLObject):
    CONSTRUCTOR_ID = 0xcdc27a1f
    SUBCLASS_OF_ID = 0xb3627ee3

    # noinspection PyShadowingBuiltins
    def __init__(self, id: str, title: str):
        """
        Constructor for PaymentSavedCredentials: Instance of PaymentSavedCredentialsCard.
        """
        self.id = id
        self.title = title

    def to_dict(self):
        return {
            '_': 'PaymentSavedCredentialsCard',
            'id': self.id,
            'title': self.title
        }

    def _bytes(self):
        return b''.join((
            b'\x1fz\xc2\xcd',
            self.serialize_bytes(self.id),
            self.serialize_bytes(self.title),
        ))

    @classmethod
    def from_reader(cls, reader):
        _id = reader.tgread_string()
        _title = reader.tgread_string()
        return cls(id=_id, title=_title)


class PeerBlocked(TLObject):
    CONSTRUCTOR_ID = 0xe8fd8014
    SUBCLASS_OF_ID = 0x54f2fc98

    def __init__(self, peer_id: 'TypePeer', date: Optional[datetime]):
        """
        Constructor for PeerBlocked: Instance of PeerBlocked.
        """
        self.peer_id = peer_id
        self.date = date

    def to_dict(self):
        return {
            '_': 'PeerBlocked',
            'peer_id': self.peer_id.to_dict() if isinstance(self.peer_id, TLObject) else self.peer_id,
            'date': self.date
        }

    def _bytes(self):
        return b''.join((
            b'\x14\x80\xfd\xe8',
            self.peer_id._bytes(),
            self.serialize_datetime(self.date),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer_id = reader.tgread_object()
        _date = reader.tgread_date()
        return cls(peer_id=_peer_id, date=_date)


class PeerChannel(TLObject):
    CONSTRUCTOR_ID = 0xa2a5371e
    SUBCLASS_OF_ID = 0x2d45687

    def __init__(self, channel_id: int):
        """
        Constructor for Peer: Instance of either PeerUser, PeerChat, PeerChannel.
        """
        self.channel_id = channel_id

    def to_dict(self):
        return {
            '_': 'PeerChannel',
            'channel_id': self.channel_id
        }

    def _bytes(self):
        return b''.join((
            b'\x1e7\xa5\xa2',
            struct.pack('<q', self.channel_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _channel_id = reader.read_long()
        return cls(channel_id=_channel_id)


class PeerChat(TLObject):
    CONSTRUCTOR_ID = 0x36c6019a
    SUBCLASS_OF_ID = 0x2d45687

    def __init__(self, chat_id: int):
        """
        Constructor for Peer: Instance of either PeerUser, PeerChat, PeerChannel.
        """
        self.chat_id = chat_id

    def to_dict(self):
        return {
            '_': 'PeerChat',
            'chat_id': self.chat_id
        }

    def _bytes(self):
        return b''.join((
            b'\x9a\x01\xc66',
            struct.pack('<q', self.chat_id),
        ))

    @classmethod
    def from_reader(cls, reader):
        _chat_id = reader.read_long()
        return cls(chat_id=_chat_id)


class PeerLocated(TLObject):
    CONSTRUCTOR_ID = 0xca461b5d
    SUBCLASS_OF_ID = 0xfada34ac

    def __init__(self, peer: 'TypePeer', expires: Optional[datetime], distance: int):
        """
        Constructor for PeerLocated: Instance of either PeerLocated, PeerSelfLocated.
        """
        self.peer = peer
        self.expires = expires
        self.distance = distance

    def to_dict(self):
        return {
            '_': 'PeerLocated',
            'peer': self.peer.to_dict() if isinstance(self.peer, TLObject) else self.peer,
            'expires': self.expires,
            'distance': self.distance
        }

    def _bytes(self):
        return b''.join((
            b']\x1bF\xca',
            self.peer._bytes(),
            self.serialize_datetime(self.expires),
            struct.pack('<i', self.distance),
        ))

    @classmethod
    def from_reader(cls, reader):
        _peer = reader.tgread_object()
        _expires = reader.tgread_date()
        _distance = reader.read_int()
        return cls(peer=_peer, expires=_expires, distance=_distance)


class PeerNotifySettings(TLObject):
    CONSTRUCTOR_ID = 0x99622c0c
    SUBCLASS_OF_ID = 0xcf20c074

    def __init__(self, show_previews: Optional[bool]=None, silent: Optional[bool]=None, mute_until: Optional[datetime]=None, ios_sound: Optional['TypeNotificationSound']=None, android_sound: Optional['TypeNotificationSound']=None, other_sound: Optional['TypeNotificationSound']=None, stories_muted: Optional[bool]=None, stories_hide_sender: Optional[bool]=None, stories_ios_sound: Optional['TypeNotificationSound']=None, stories_android_sound: Optional['TypeNotificationSound']=None, stories_other_sound: Optional['TypeNotificationSound']=None):
        """
        Constructor for PeerNotifySettings: Instance of PeerNotifySettings.
        """
        self.show_previews = show_previews
        self.silent = silent
        self.mute_until = mute_until
        self.ios_sound = ios_sound
        self.android_sound = android_sound
        self.other_sound = other_sound
        self.stories_muted = stories_muted
        self.stories_hide_sender = stories_hide_sender
        self.stories_ios_sound = stories_ios_sound
        self.stories_android_sound = stories_android_sound
        self.stories_other_sound = stories_other_sound

    def to_dict(self):
        return {
            '_': 'PeerNotifySettings',
            'show_previews': self.show_previews,
            'silent': self.silent,
            'mute_until': self.mute_until,
            'ios_sound': self.ios_sound.to_dict() if isinstance(self.ios_sound, TLObject) else self.ios_sound,
            'android_sound': self.android_sound.to_dict() if isinstance(self.android_sound, TLObject) else self.android_sound,
            'other_sound': self.other_sound.to_dict() if isinstance(self.other_sound, TLObject) else self.other_sound,
            'stories_muted': self.stories_muted,
            'stories_hide_sender': self.stories_hide_sender,
            'stories_ios_sound': self.stories_ios_sound.to_dict() if isinstance(self.stories_ios_sound, TLObject) else self.stories_ios_sound,
            'stories_android_sound': self.stories_android_sound.to_dict() if isinstance(self.stories_android_sound, TLObject) else self.stories_android_sound,
            'stories_other_sound': self.stories_other_sound.to_dict() if isinstance(self.stories_other_sound, TLObject) else self.stories_other_sound
        }

    def _bytes(self):
        return b''.join((
            b'\x0c,b\x99',
            struct.pack('<I', (0 if self.show_previews is None else 1) | (0 if self.silent is None else 2) | (0 if self.mute_until is None or self.mute_until is False else 4) | (0 if self.ios_sound is None or self.ios_sound is False else 8) | (0 if self.android_sound is None or self.android_sound is False else 16) | (0 if self.other_sound is None or self.other_sound is False else 32) | (0 if self.stories_muted is None else 64) | (0 if self.stories_hide_sender is None else 128) | (0 if self.stories_ios_sound is None or self.stories_ios_sound is False else 256) | (0 if self.stories_android_sound is None or self.stories_android_sound is False else 512) | (0 if self.stories_other_sound is None or self.stories_other_sound is False else 1024)),
            b'' if self.show_previews is None else (b'\xb5ur\x99' if self.show_previews else b'7\x97y\xbc'),
            b'' if self.silent is None else (b'\xb5ur\x99' if self.silent else b'7\x97y\xbc'),
            b'' if self.mute_until is None or self.mute_until is False else (self.serialize_datetime(self.mute_until)),
            b'' if self.ios_sound is None or self.ios_sound is False else (self.ios_sound._bytes()),
            b'' if self.android_sound is None or self.android_sound is False else (self.android_sound._bytes()),
            b'' if self.other_sound is None or self.other_sound is False else (self.other_sound._bytes()),
            b'' if self.stories_muted is None else (b'\xb5ur\x99' if self.stories_muted else b'7\x97y\xbc'),
            b'' if self.stories_hide_sender is None else (b'\xb5ur\x99' if self.stories_hide_sender else b'7\x97y\xbc'),
            b'' if self.stories_ios_sound is None or self.stories_ios_sound is False else (self.stories_ios_sound._bytes()),
            b'' if self.stories_android_sound is None or self.stories_android_sound is False else (self.stories_android_sound._bytes()),
            b'' if self.stories_other_sound is None or self.stories_other_sound is False else (self.stories_other_sound._bytes()),
        ))

    @classmethod
    def from_reade