import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [rum](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscloudwatchrum.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Rum extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to create appMonitor metadata
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     * - iam:GetRole
     *
     * https://docs.aws.amazon.com/rum/latest/APIReference/API_CreateAppMonitor.html
     */
    toCreateAppMonitor(): this;
    /**
     * Grants permission to delete appMonitor metadata
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rum/latest/APIReference/API_DeleteAppMonitor.html
     */
    toDeleteAppMonitor(): this;
    /**
     * Grants permission to get appMonitor metadata
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rum/latest/APIReference/API_GetAppMonitor.html
     */
    toGetAppMonitor(): this;
    /**
     * Grants permission to get appMonitor data
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rum/latest/APIReference/API_GetAppMonitorData.html
     */
    toGetAppMonitorData(): this;
    /**
     * Grants permission to list appMonitors metadata
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/rum/latest/APIReference/API_ListAppMonitors.html
     */
    toListAppMonitors(): this;
    /**
     * Grants permission to list tags for resources
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/rum/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to put RUM events for appmonitor
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/rum/latest/APIReference/API_PutRumEvents.html
     */
    toPutRumEvents(): this;
    /**
     * Grants permission to tag resources
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/rum/latest/APIReference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag resources
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/rum/latest/APIReference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update appmonitor metadata
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - iam:CreateServiceLinkedRole
     * - iam:GetRole
     *
     * https://docs.aws.amazon.com/rum/latest/APIReference/API_UpdateAppMonitor.html
     */
    toUpdateAppMonitor(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type AppMonitorResource to the statement
     *
     * https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/API_AppMonitor.html
     *
     * @param name - Identifier for the name.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAppMonitorResource(name: string, account?: string, region?: string, partition?: string): this;
    /**
     * Statement provider for service [rum](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscloudwatchrum.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
