import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [compute-optimizer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscomputeoptimizer.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class ComputeOptimizer extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to delete recommendation preferences
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifResourceType()
     *
     * Dependent actions:
     * - autoscaling:DescribeAutoScalingGroups
     * - ec2:DescribeInstances
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_DeleteRecommendationPreferences.html
     */
    toDeleteRecommendationPreferences(): this;
    /**
     * Grants permission to view the status of recommendation export jobs
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_DescribeRecommendationExportJobs.html
     */
    toDescribeRecommendationExportJobs(): this;
    /**
     * Grants permission to export AutoScaling group recommendations to S3 for the provided accounts
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - autoscaling:DescribeAutoScalingGroups
     * - compute-optimizer:GetAutoScalingGroupRecommendations
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_ExportAutoScalingGroupRecommendations.html
     */
    toExportAutoScalingGroupRecommendations(): this;
    /**
     * Grants permission to export EBS volume recommendations to S3 for the provided accounts
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - compute-optimizer:GetEBSVolumeRecommendations
     * - ec2:DescribeVolumes
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_ExportEBSVolumeRecommendations.html
     */
    toExportEBSVolumeRecommendations(): this;
    /**
     * Grants permission to export EC2 instance recommendations to S3 for the provided accounts
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - compute-optimizer:GetEC2InstanceRecommendations
     * - ec2:DescribeInstances
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_ExportEC2InstanceRecommendations.html
     */
    toExportEC2InstanceRecommendations(): this;
    /**
     * Grants permission to export Lambda function recommendations to S3 for the provided accounts
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - compute-optimizer:GetLambdaFunctionRecommendations
     * - lambda:ListFunctions
     * - lambda:ListProvisionedConcurrencyConfigs
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_ExportLambdaFunctionRecommendations.html
     */
    toExportLambdaFunctionRecommendations(): this;
    /**
     * Grants permission to get recommendations for the provided AutoScaling groups
     *
     * Access Level: List
     *
     * Dependent actions:
     * - autoscaling:DescribeAutoScalingGroups
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetAutoScalingGroupRecommendations.html
     */
    toGetAutoScalingGroupRecommendations(): this;
    /**
     * Grants permission to get recommendations for the provided EBS volumes
     *
     * Access Level: List
     *
     * Dependent actions:
     * - ec2:DescribeVolumes
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetEBSVolumeRecommendations.html
     */
    toGetEBSVolumeRecommendations(): this;
    /**
     * Grants permission to get recommendations for the provided EC2 instances
     *
     * Access Level: List
     *
     * Dependent actions:
     * - ec2:DescribeInstances
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetEC2InstanceRecommendations.html
     */
    toGetEC2InstanceRecommendations(): this;
    /**
     * Grants permission to get the recommendation projected metrics of the specified instance
     *
     * Access Level: List
     *
     * Dependent actions:
     * - ec2:DescribeInstances
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetEC2RecommendationProjectedMetrics.html
     */
    toGetEC2RecommendationProjectedMetrics(): this;
    /**
     * Grants permission to get recommendation preferences that are in effect
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifResourceType()
     *
     * Dependent actions:
     * - autoscaling:DescribeAutoScalingGroups
     * - autoscaling:DescribeAutoScalingInstances
     * - ec2:DescribeInstances
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetEffectiveRecommendationPreferences.html
     */
    toGetEffectiveRecommendationPreferences(): this;
    /**
     * Grants permission to get the enrollment status for the specified account
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetEnrollmentStatus.html
     */
    toGetEnrollmentStatus(): this;
    /**
     * Grants permission to get the enrollment statuses for member accounts of the organization
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetEnrollmentStatusesForOrganization.html
     */
    toGetEnrollmentStatusesForOrganization(): this;
    /**
     * Grants permission to get recommendations for the provided Lambda functions
     *
     * Access Level: List
     *
     * Dependent actions:
     * - lambda:ListFunctions
     * - lambda:ListProvisionedConcurrencyConfigs
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetLambdaFunctionRecommendations.html
     */
    toGetLambdaFunctionRecommendations(): this;
    /**
     * Grants permission to get recommendation preferences
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifResourceType()
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetRecommendationPreferences.html
     */
    toGetRecommendationPreferences(): this;
    /**
     * Grants permission to get the recommendation summaries for the specified account(s)
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_GetRecommendationSummaries.html
     */
    toGetRecommendationSummaries(): this;
    /**
     * Grants permission to put recommendation preferences
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifResourceType()
     *
     * Dependent actions:
     * - autoscaling:DescribeAutoScalingGroups
     * - autoscaling:DescribeAutoScalingInstances
     * - ec2:DescribeInstances
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_PutRecommendationPreferences.html
     */
    toPutRecommendationPreferences(): this;
    /**
     * Grants permission to update the enrollment status
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/APIReference/API_UpdateEnrollmentStatus.html
     */
    toUpdateEnrollmentStatus(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Filters access by the resource type
     *
     * https://docs.aws.amazon.com/compute-optimizer/latest/ug/security-iam.html
     *
     * Applies to actions:
     * - .toDeleteRecommendationPreferences()
     * - .toGetEffectiveRecommendationPreferences()
     * - .toGetRecommendationPreferences()
     * - .toPutRecommendationPreferences()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifResourceType(value: string | string[], operator?: Operator | string): this;
    /**
     * Statement provider for service [compute-optimizer](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awscomputeoptimizer.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
