import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [gamelift](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazongamelift.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Gamelift extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to register player acceptance or rejection of a proposed FlexMatch match
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_AcceptMatch.html
     */
    toAcceptMatch(): this;
    /**
     * Grants permission to locate and reserve a game server to host a new game session
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_ClaimGameServer.html
     */
    toClaimGameServer(): this;
    /**
     * Grants permission to define a new alias for a fleet
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateAlias.html
     */
    toCreateAlias(): this;
    /**
     * Grants permission to create a new game build using files stored in an Amazon S3 bucket
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateBuild.html
     */
    toCreateBuild(): this;
    /**
     * Grants permission to create a new fleet of computing resources to run your game servers
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateFleet.html
     */
    toCreateFleet(): this;
    /**
     * Grants permission to specify additional locations for a fleet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateFleetLocations.html
     */
    toCreateFleetLocations(): this;
    /**
     * Grants permission to create a new game server group, set up a corresponding Auto Scaling group, and launche instances to host game servers
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateGameServerGroup.html
     */
    toCreateGameServerGroup(): this;
    /**
     * Grants permission to start a new game session on a specified fleet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateGameSession.html
     */
    toCreateGameSession(): this;
    /**
     * Grants permission to set up a new queue for processing game session placement requests
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateGameSessionQueue.html
     */
    toCreateGameSessionQueue(): this;
    /**
     * Grants permission to create a new FlexMatch matchmaker
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateMatchmakingConfiguration.html
     */
    toCreateMatchmakingConfiguration(): this;
    /**
     * Grants permission to create a new matchmaking rule set for FlexMatch
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateMatchmakingRuleSet.html
     */
    toCreateMatchmakingRuleSet(): this;
    /**
     * Grants permission to reserve an available game session slot for a player
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreatePlayerSession.html
     */
    toCreatePlayerSession(): this;
    /**
     * Grants permission to reserve available game session slots for multiple players
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreatePlayerSessions.html
     */
    toCreatePlayerSessions(): this;
    /**
     * Grants permission to create a new Realtime Servers script
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateScript.html
     */
    toCreateScript(): this;
    /**
     * Grants permission to allow GameLift to create or delete a peering connection between a GameLift fleet VPC and a VPC on another AWS account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateVpcPeeringAuthorization.html
     */
    toCreateVpcPeeringAuthorization(): this;
    /**
     * Grants permission to establish a peering connection between your GameLift fleet VPC and a VPC on another account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_CreateVpcPeeringConnection.html
     */
    toCreateVpcPeeringConnection(): this;
    /**
     * Grants permission to delete an alias
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteAlias.html
     */
    toDeleteAlias(): this;
    /**
     * Grants permission to delete a game build
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteBuild.html
     */
    toDeleteBuild(): this;
    /**
     * Grants permission to delete an empty fleet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteFleet.html
     */
    toDeleteFleet(): this;
    /**
     * Grants permission to delete locations for a fleet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteFleetLocations.html
     */
    toDeleteFleetLocations(): this;
    /**
     * Grants permission to permanently delete a game server group and terminate FleetIQ activity for the corresponding Auto Scaling group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteGameServerGroup.html
     */
    toDeleteGameServerGroup(): this;
    /**
     * Grants permission to delete an existing game session queue
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteGameSessionQueue.html
     */
    toDeleteGameSessionQueue(): this;
    /**
     * Grants permission to delete an existing FlexMatch matchmaker
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteMatchmakingConfiguration.html
     */
    toDeleteMatchmakingConfiguration(): this;
    /**
     * Grants permission to delete an existing FlexMatch matchmaking rule set
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteMatchmakingRuleSet.html
     */
    toDeleteMatchmakingRuleSet(): this;
    /**
     * Grants permission to delete a set of auto-scaling rules
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteScalingPolicy.html
     */
    toDeleteScalingPolicy(): this;
    /**
     * Grants permission to delete a Realtime Servers script
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteScript.html
     */
    toDeleteScript(): this;
    /**
     * Grants permission to cancel a VPC peering authorization
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteVpcPeeringAuthorization.html
     */
    toDeleteVpcPeeringAuthorization(): this;
    /**
     * Grants permission to remove a peering connection between VPCs
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeleteVpcPeeringConnection.html
     */
    toDeleteVpcPeeringConnection(): this;
    /**
     * Grants permission to remove a game server from a game server group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DeregisterGameServer.html
     */
    toDeregisterGameServer(): this;
    /**
     * Grants permission to retrieve properties for an alias
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeAlias.html
     */
    toDescribeAlias(): this;
    /**
     * Grants permission to retrieve properties for a game build
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeBuild.html
     */
    toDescribeBuild(): this;
    /**
     * Grants permission to retrieve the maximum allowed and current usage for EC2 instance types
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeEC2InstanceLimits.html
     */
    toDescribeEC2InstanceLimits(): this;
    /**
     * Grants permission to retrieve general properties, including status, for fleets
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetAttributes.html
     */
    toDescribeFleetAttributes(): this;
    /**
     * Grants permission to retrieve the current capacity setting for fleets
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetCapacity.html
     */
    toDescribeFleetCapacity(): this;
    /**
     * Grants permission to retrieve entries from a fleet's event log
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetEvents.html
     */
    toDescribeFleetEvents(): this;
    /**
     * Grants permission to retrieve general properties, including statuses, for a fleet's locations
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationAttributes.html
     */
    toDescribeFleetLocationAttributes(): this;
    /**
     * Grants permission to retrieve the current capacity setting for a fleet's location
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationCapacity.html
     */
    toDescribeFleetLocationCapacity(): this;
    /**
     * Grants permission to retrieve utilization statistics for fleet's location
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetLocationUtilization.html
     */
    toDescribeFleetLocationUtilization(): this;
    /**
     * Grants permission to retrieve the inbound connection permissions for a fleet
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetPortSettings.html
     */
    toDescribeFleetPortSettings(): this;
    /**
     * Grants permission to retrieve utilization statistics for fleets
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeFleetUtilization.html
     */
    toDescribeFleetUtilization(): this;
    /**
     * Grants permission to retrieve properties for a game server
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeGameServer.html
     */
    toDescribeGameServer(): this;
    /**
     * Grants permission to retrieve properties for a game server group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeGameServerGroup.html
     */
    toDescribeGameServerGroup(): this;
    /**
     * Grants permission to retrieve the status of EC2 instances in a game server group
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeGameServerInstances.html
     */
    toDescribeGameServerInstances(): this;
    /**
     * Grants permission to retrieve properties for game sessions in a fleet, including the protection policy
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeGameSessionDetails.html
     */
    toDescribeGameSessionDetails(): this;
    /**
     * Grants permission to retrieve details of a game session placement request
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeGameSessionPlacement.html
     */
    toDescribeGameSessionPlacement(): this;
    /**
     * Grants permission to retrieve properties for game session queues
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeGameSessionQueues.html
     */
    toDescribeGameSessionQueues(): this;
    /**
     * Grants permission to retrieve properties for game sessions in a fleet
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeGameSessions.html
     */
    toDescribeGameSessions(): this;
    /**
     * Grants permission to retrieve information about instances in a fleet
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeInstances.html
     */
    toDescribeInstances(): this;
    /**
     * Grants permission to retrieve details of matchmaking tickets
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeMatchmaking.html
     */
    toDescribeMatchmaking(): this;
    /**
     * Grants permission to retrieve properties for FlexMatch matchmakers
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeMatchmakingConfigurations.html
     */
    toDescribeMatchmakingConfigurations(): this;
    /**
     * Grants permission to retrieve properties for FlexMatch matchmaking rule sets
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeMatchmakingRuleSets.html
     */
    toDescribeMatchmakingRuleSets(): this;
    /**
     * Grants permission to retrieve properties for player sessions in a game session
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribePlayerSessions.html
     */
    toDescribePlayerSessions(): this;
    /**
     * Grants permission to retrieve the current runtime configuration for a fleet
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeRuntimeConfiguration.html
     */
    toDescribeRuntimeConfiguration(): this;
    /**
     * Grants permission to retrieve all scaling policies that are applied to a fleet
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeScalingPolicies.html
     */
    toDescribeScalingPolicies(): this;
    /**
     * Grants permission to retrieve properties for a Realtime Servers script
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeScript.html
     */
    toDescribeScript(): this;
    /**
     * Grants permission to retrieve valid VPC peering authorizations
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeVpcPeeringAuthorizations.html
     */
    toDescribeVpcPeeringAuthorizations(): this;
    /**
     * Grants permission to retrieve details on active or pending VPC peering connections
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_DescribeVpcPeeringConnections.html
     */
    toDescribeVpcPeeringConnections(): this;
    /**
     * Grants permission to retrieve the location of stored logs for a game session
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_GetGameSessionLogUrl.html
     */
    toGetGameSessionLogUrl(): this;
    /**
     * Grants permission to request remote access to a specified fleet instance
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_GetInstanceAccess.html
     */
    toGetInstanceAccess(): this;
    /**
     * Grants permission to retrieve all aliases that are defined in the current region
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_ListAliases.html
     */
    toListAliases(): this;
    /**
     * Grants permission to retrieve all game build in the current region
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_ListBuilds.html
     */
    toListBuilds(): this;
    /**
     * Grants permission to retrieve a list of fleet IDs for all fleets in the current region
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_ListFleets.html
     */
    toListFleets(): this;
    /**
     * Grants permission to retrieve all game server groups that are defined in the current region
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_ListGameServerGroups.html
     */
    toListGameServerGroups(): this;
    /**
     * Grants permission to retrieve all game servers that are currently running in a game server group
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_ListGameServers.html
     */
    toListGameServers(): this;
    /**
     * Grants permission to retrieve properties for all Realtime Servers scripts in the current region
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_ListScripts.html
     */
    toListScripts(): this;
    /**
     * Grants permission to retrieve tags for GameLift resources
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to create or update a fleet auto-scaling policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_PutScalingPolicy.html
     */
    toPutScalingPolicy(): this;
    /**
     * Grants permission to notify GameLift FleetIQ when a new game server is ready to host gameplay
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_RegisterGameServer.html
     */
    toRegisterGameServer(): this;
    /**
     * Grants permission to retrieve fresh upload credentials to use when uploading a new game build
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_RequestUploadCredentials.html
     */
    toRequestUploadCredentials(): this;
    /**
     * Grants permission to retrieve the fleet ID associated with an alias
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_ResolveAlias.html
     */
    toResolveAlias(): this;
    /**
     * Grants permission to reinstate suspended FleetIQ activity for a game server group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_ResumeGameServerGroup.html
     */
    toResumeGameServerGroup(): this;
    /**
     * Grants permission to retrieve game sessions that match a set of search criteria
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_SearchGameSessions.html
     */
    toSearchGameSessions(): this;
    /**
     * Grants permission to resume auto-scaling activity on a fleet after it was suspended with StopFleetActions()
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartFleetActions.html
     */
    toStartFleetActions(): this;
    /**
     * Grants permission to send a game session placement request to a game session queue
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartGameSessionPlacement.html
     */
    toStartGameSessionPlacement(): this;
    /**
     * Grants permission to request FlexMatch matchmaking to fill available player slots in an existing game session
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartMatchBackfill.html
     */
    toStartMatchBackfill(): this;
    /**
     * Grants permission to request FlexMatch matchmaking for one or a group of players and initiate game session placement
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_StartMatchmaking.html
     */
    toStartMatchmaking(): this;
    /**
     * Grants permission to suspend auto-scaling activity on a fleet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_StopFleetActions.html
     */
    toStopFleetActions(): this;
    /**
     * Grants permission to cancel a game session placement request that is in progress
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_StopGameSessionPlacement.html
     */
    toStopGameSessionPlacement(): this;
    /**
     * Grants permission to cancel a matchmaking or match backfill request that is in progress
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_StopMatchmaking.html
     */
    toStopMatchmaking(): this;
    /**
     * Grants permission to temporarily stop FleetIQ activity for a game server group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_SuspendGameServerGroup.html
     */
    toSuspendGameServerGroup(): this;
    /**
     * Grants permission to tag GameLift resources
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to untag GameLift resources
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to update the properties of an existing alias
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateAlias.html
     */
    toUpdateAlias(): this;
    /**
     * Grants permission to update an existing build's metadata
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateBuild.html
     */
    toUpdateBuild(): this;
    /**
     * Grants permission to update the general properties of an existing fleet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateFleetAttributes.html
     */
    toUpdateFleetAttributes(): this;
    /**
     * Grants permission to adjust a fleet's capacity settings
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateFleetCapacity.html
     */
    toUpdateFleetCapacity(): this;
    /**
     * Grants permission to adjust a fleet's port settings
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateFleetPortSettings.html
     */
    toUpdateFleetPortSettings(): this;
    /**
     * Grants permission to change game server properties, health status, or utilization status
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateGameServer.html
     */
    toUpdateGameServer(): this;
    /**
     * Grants permission to update properties for game server group, including allowed instance types
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateGameServerGroup.html
     */
    toUpdateGameServerGroup(): this;
    /**
     * Grants permission to update the properties of an existing game session
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateGameSession.html
     */
    toUpdateGameSession(): this;
    /**
     * Grants permission to update properties of an existing game session queue
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateGameSessionQueue.html
     */
    toUpdateGameSessionQueue(): this;
    /**
     * Grants permission to update properties of an existing FlexMatch matchmaking configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateMatchmakingConfiguration.html
     */
    toUpdateMatchmakingConfiguration(): this;
    /**
     * Grants permission to update how server processes are configured on instances in an existing fleet
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateRuntimeConfiguration.html
     */
    toUpdateRuntimeConfiguration(): this;
    /**
     * Grants permission to update the metadata and content of an existing Realtime Servers script
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_UpdateScript.html
     */
    toUpdateScript(): this;
    /**
     * Grants permission to validate the syntax of a FlexMatch matchmaking rule set
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/gamelift/latest/apireference/API_ValidateMatchmakingRuleSet.html
     */
    toValidateMatchmakingRuleSet(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type alias to the statement
     *
     * https://docs.aws.amazon.com/gamelift/latest/developerguide/API_Alias.html
     *
     * @param aliasId - Identifier for the aliasId.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAlias(aliasId: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type build to the statement
     *
     * https://docs.aws.amazon.com/gamelift/latest/developerguide/API_Build.html
     *
     * @param buildId - Identifier for the buildId.
     * @param accountId - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onBuild(buildId: string, accountId?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type script to the statement
     *
     * https://docs.aws.amazon.com/gamelift/latest/developerguide/API_Script.html
     *
     * @param scriptId - Identifier for the scriptId.
     * @param accountId - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onScript(scriptId: string, accountId?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type fleet to the statement
     *
     * https://docs.aws.amazon.com/gamelift/latest/developerguide/API_FleetAttributes.html
     *
     * @param fleetId - Identifier for the fleetId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onFleet(fleetId: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type gameSessionQueue to the statement
     *
     * https://docs.aws.amazon.com/gamelift/latest/developerguide/API_GameSessionQueue.html
     *
     * @param gameSessionQueueName - Identifier for the gameSessionQueueName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onGameSessionQueue(gameSessionQueueName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type matchmakingConfiguration to the statement
     *
     * https://docs.aws.amazon.com/gamelift/latest/developerguide/API_MatchmakingConfiguration.html
     *
     * @param matchmakingConfigurationName - Identifier for the matchmakingConfigurationName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onMatchmakingConfiguration(matchmakingConfigurationName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type matchmakingRuleSet to the statement
     *
     * https://docs.aws.amazon.com/gamelift/latest/developerguide/API_MatchmakingRuleSet.html
     *
     * @param matchmakingRuleSetName - Identifier for the matchmakingRuleSetName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onMatchmakingRuleSet(matchmakingRuleSetName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type gameServerGroup to the statement
     *
     * https://docs.aws.amazon.com/gamelift/latest/developerguide/API_GameServerGroup.html
     *
     * @param gameServerGroupName - Identifier for the gameServerGroupName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onGameServerGroup(gameServerGroupName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Statement provider for service [gamelift](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazongamelift.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
