"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.IotDeviceTester = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [iot-device-tester](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotdevicetester.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class IotDeviceTester extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [iot-device-tester](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsiotdevicetester.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'iot-device-tester';
        this.accessLevelList = {
            Read: [
                'CheckVersion',
                'DownloadTestSuite',
                'LatestIdt',
                'SupportedVersion'
            ],
            Write: [
                'SendMetrics'
            ]
        };
    }
    /**
     * Grants permission for IoT Device Tester to check if a given set of product, test suite and device tester version are compatible
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/freertos/latest/userguide/dev-tester-prereqs.html
     */
    toCheckVersion() {
        return this.to('CheckVersion');
    }
    /**
     * Grants permission for IoT Device Tester to download compatible test suite versions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/freertos/latest/userguide/dev-tester-prereqs.html
     */
    toDownloadTestSuite() {
        return this.to('DownloadTestSuite');
    }
    /**
     * Grants permission for IoT Device Tester to get information on latest version of device tester available
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/freertos/latest/userguide/dev-tester-prereqs.html
     */
    toLatestIdt() {
        return this.to('LatestIdt');
    }
    /**
     * Grants permissions for IoT Device Tester to send usage metrics on your behalf
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/freertos/latest/userguide/dev-tester-prereqs.html
     */
    toSendMetrics() {
        return this.to('SendMetrics');
    }
    /**
     * Grants permission for IoT Device Tester to get list of supported products and test suite versions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/freertos/latest/userguide/dev-tester-prereqs.html
     */
    toSupportedVersion() {
        return this.to('SupportedVersion');
    }
}
exports.IotDeviceTester = IotDeviceTester;
_a = JSII_RTTI_SYMBOL_1;
IotDeviceTester[_a] = { fqn: "cdk-iam-floyd.IotDeviceTester", version: "0.333.0" };
//# sourceMappingURL=data:application/json;base64,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