"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Lakeformation = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [lakeformation](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awslakeformation.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Lakeformation extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [lakeformation](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awslakeformation.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'lakeformation';
        this.accessLevelList = {
            Tagging: [
                'AddLFTagsToResource',
                'RemoveLFTagsFromResource'
            ],
            'Permissions management': [
                'BatchGrantPermissions',
                'BatchRevokePermissions',
                'GrantPermissions',
                'PutDataLakeSettings',
                'RevokePermissions'
            ],
            Write: [
                'CancelTransaction',
                'CommitTransaction',
                'CreateDataCellsFilter',
                'CreateLFTag',
                'DeleteDataCellsFilter',
                'DeleteLFTag',
                'DeleteObjectsOnCancel',
                'DeregisterResource',
                'ExtendTransaction',
                'GetDataAccess',
                'RegisterResource',
                'StartQueryPlanning',
                'StartTransaction',
                'UpdateLFTag',
                'UpdateResource',
                'UpdateTableObjects',
                'UpdateTableStorageOptimizer'
            ],
            Read: [
                'DescribeResource',
                'DescribeTransaction',
                'GetDataLakeSettings',
                'GetEffectivePermissionsForPath',
                'GetLFTag',
                'GetQueryState',
                'GetQueryStatistics',
                'GetResourceLFTags',
                'GetTableObjects',
                'GetWorkUnitResults',
                'GetWorkUnits',
                'ListLFTags',
                'SearchDatabasesByLFTags',
                'SearchTablesByLFTags'
            ],
            List: [
                'ListDataCellsFilter',
                'ListPermissions',
                'ListResources',
                'ListTableStorageOptimizers',
                'ListTransactions'
            ]
        };
    }
    /**
     * Grants permission to attach Lake Formation tags to catalog resources
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-AddLFTagsToResource
     */
    toAddLFTagsToResource() {
        return this.to('AddLFTagsToResource');
    }
    /**
     * Grants permission to data lake permissions to one or more principals in a batch
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-BatchGrantPermissions
     */
    toBatchGrantPermissions() {
        return this.to('BatchGrantPermissions');
    }
    /**
     * Grants permission to revoke data lake permissions from one or more principals in a batch
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-BatchRevokePermissions
     */
    toBatchRevokePermissions() {
        return this.to('BatchRevokePermissions');
    }
    /**
     * Grants permission to cancel the given transaction
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-transactions-api.html#aws-lake-formation-api-transactions-api-CancelTransaction
     */
    toCancelTransaction() {
        return this.to('CancelTransaction');
    }
    /**
     * Grants permission to commit the given transaction
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-transactions-api.html#aws-lake-formation-api-transactions-api-CommitTransaction
     */
    toCommitTransaction() {
        return this.to('CommitTransaction');
    }
    /**
     * Grants permission to create a Lake Formation data cell filter
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-data-filter.html#aws-lake-formation-api-data-filter-CreateDataCellsFilter
     */
    toCreateDataCellsFilter() {
        return this.to('CreateDataCellsFilter');
    }
    /**
     * Grants permission to create a Lake Formation tag
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-CreateLFTag
     */
    toCreateLFTag() {
        return this.to('CreateLFTag');
    }
    /**
     * Grants permission to delete a Lake Formation data cell filter
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-data-filter.html#aws-lake-formation-api-data-filter-DeleteDataCellsFilter
     */
    toDeleteDataCellsFilter() {
        return this.to('DeleteDataCellsFilter');
    }
    /**
     * Grants permission to delete a Lake Formation tag
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-DeleteLFTag
     */
    toDeleteLFTag() {
        return this.to('DeleteLFTag');
    }
    /**
     * Grants permission to delete the specified objects if the transaction is canceled
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-transactions-api.html#aws-lake-formation-api-transactions-api-DeleteObjectsOnCancel
     */
    toDeleteObjectsOnCancel() {
        return this.to('DeleteObjectsOnCancel');
    }
    /**
     * Grants permission to deregister a registered location
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-DeregisterResource
     */
    toDeregisterResource() {
        return this.to('DeregisterResource');
    }
    /**
     * Grants permission to describe a registered location
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-DescribeResource
     */
    toDescribeResource() {
        return this.to('DescribeResource');
    }
    /**
     * Grants permission to get status of the given transaction
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-transactions-api.html#aws-lake-formation-api-transactions-api-DescribeTransaction
     */
    toDescribeTransaction() {
        return this.to('DescribeTransaction');
    }
    /**
     * Grants permission to extend the timeout of the given transaction
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-transactions-api.html#aws-lake-formation-api-transactions-api-ExtendTransaction
     */
    toExtendTransaction() {
        return this.to('ExtendTransaction');
    }
    /**
     * Grants permission to virtual data lake access
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-GetDataAccess
     */
    toGetDataAccess() {
        return this.to('GetDataAccess');
    }
    /**
     * Grants permission to retrieve data lake settings such as the list of data lake administrators and database and table default permissions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-GetDataLakeSettings
     */
    toGetDataLakeSettings() {
        return this.to('GetDataLakeSettings');
    }
    /**
     * Grants permission to retrieve permissions attached to resources in the given path
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-GetEffectivePermissionsForPath
     */
    toGetEffectivePermissionsForPath() {
        return this.to('GetEffectivePermissionsForPath');
    }
    /**
     * Grants permission to retrieve a Lake Formation tag
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-GetLFTag
     */
    toGetLFTag() {
        return this.to('GetLFTag');
    }
    /**
     * Grants permission to retrieve the state of the given query
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - lakeformation:StartQueryPlanning
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-querying.html#aws-lake-formation-api-querying-GetQueryState
     */
    toGetQueryState() {
        return this.to('GetQueryState');
    }
    /**
     * Grants permission to retrieve the statistics for the given query
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - lakeformation:StartQueryPlanning
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-querying.html#aws-lake-formation-api-querying-GetQueryStatistics
     */
    toGetQueryStatistics() {
        return this.to('GetQueryStatistics');
    }
    /**
     * Grants permission to retrieve lakeformation tags on a catalog resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-GetResourceLFTags
     */
    toGetResourceLFTags() {
        return this.to('GetResourceLFTags');
    }
    /**
     * Grants permission to retrieve objects from a table
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-objects.html#aws-lake-formation-api-objects-GetTableObjects
     */
    toGetTableObjects() {
        return this.to('GetTableObjects');
    }
    /**
     * Grants permission to retrieve the results for the given work units
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - lakeformation:GetWorkUnits
     * - lakeformation:StartQueryPlanning
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-querying.html#aws-lake-formation-api-querying-GetWorkUnitResults
     */
    toGetWorkUnitResults() {
        return this.to('GetWorkUnitResults');
    }
    /**
     * Grants permission to retrieve the work units for the given query
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - lakeaformation:StartQueryPlanning
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-querying.html#aws-lake-formation-api-querying-GetWorkUnits
     */
    toGetWorkUnits() {
        return this.to('GetWorkUnits');
    }
    /**
     * Grants permission to data lake permissions to a principal
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-GrantPermissions
     */
    toGrantPermissions() {
        return this.to('GrantPermissions');
    }
    /**
     * Grants permission to list cell filters
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-data-filter.html#aws-lake-formation-api-data-filter-ListDataCellsFilter
     */
    toListDataCellsFilter() {
        return this.to('ListDataCellsFilter');
    }
    /**
     * Grants permission to list Lake Formation tags
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-ListLFTags
     */
    toListLFTags() {
        return this.to('ListLFTags');
    }
    /**
     * Grants permission to list permissions filtered by principal or resource
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-ListPermissions
     */
    toListPermissions() {
        return this.to('ListPermissions');
    }
    /**
     * Grants permission to List registered locations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-ListResources
     */
    toListResources() {
        return this.to('ListResources');
    }
    /**
     * Grants permission to list all the storage optimizers for the Governed table
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-optimizers.html#aws-lake-formation-api-optimizers-ListTableStorageOptimizers
     */
    toListTableStorageOptimizers() {
        return this.to('ListTableStorageOptimizers');
    }
    /**
     * Grants permission to list all transactions in the system
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-transactions-api.html#aws-lake-formation-api-transactions-api-ListTransactions
     */
    toListTransactions() {
        return this.to('ListTransactions');
    }
    /**
     * Grants permission to overwrite data lake settings such as the list of data lake administrators and database and table default permissions
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-PutDataLakeSettings
     */
    toPutDataLakeSettings() {
        return this.to('PutDataLakeSettings');
    }
    /**
     * Grants permission to register a new location to be managed by Lake Formation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-RegisterResource
     */
    toRegisterResource() {
        return this.to('RegisterResource');
    }
    /**
     * Grants permission to remove lakeformation tags from catalog resources
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-RemoveLFTagsFromResource
     */
    toRemoveLFTagsFromResource() {
        return this.to('RemoveLFTagsFromResource');
    }
    /**
     * Grants permission to revoke data lake permissions from a principal
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-RevokePermissions
     */
    toRevokePermissions() {
        return this.to('RevokePermissions');
    }
    /**
     * Grants permission to list catalog databases with Lake Formation tags
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-SearchDatabasesByLFTags
     */
    toSearchDatabasesByLFTags() {
        return this.to('SearchDatabasesByLFTags');
    }
    /**
     * Grants permission to list catalog tables with Lake Formation tags
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-SearchTablesByLFTags
     */
    toSearchTablesByLFTags() {
        return this.to('SearchTablesByLFTags');
    }
    /**
     * Grants permission to initiate the planning of the given query
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-querying.html#aws-lake-formation-api-querying-StartQueryPlanning
     */
    toStartQueryPlanning() {
        return this.to('StartQueryPlanning');
    }
    /**
     * Grants permission to start a new transaction
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-transactions-api.html#aws-lake-formation-api-transactions-api-StartTransaction
     */
    toStartTransaction() {
        return this.to('StartTransaction');
    }
    /**
     * Grants permission to update a Lake Formation tag
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-UpdateLFTag
     */
    toUpdateLFTag() {
        return this.to('UpdateLFTag');
    }
    /**
     * Grants permission to update a registered location
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-tagging-api.html#aws-lake-formation-api-tagging-api-UpdateResource
     */
    toUpdateResource() {
        return this.to('UpdateResource');
    }
    /**
     * Grants permission to add or delete the specified objects to or from a table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-objects.html#aws-lake-formation-api-objects-UpdateTableObjects
     */
    toUpdateTableObjects() {
        return this.to('UpdateTableObjects');
    }
    /**
     * Grants permission to update the configuration of the storage optimizer for the Governed table
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api-optimizers.html#aws-lake-formation-api-optimizers-UpdateTableStorageOptimizer
     */
    toUpdateTableStorageOptimizer() {
        return this.to('UpdateTableStorageOptimizer');
    }
}
exports.Lakeformation = Lakeformation;
_a = JSII_RTTI_SYMBOL_1;
Lakeformation[_a] = { fqn: "cdk-iam-floyd.Lakeformation", version: "0.333.0" };
//# sourceMappingURL=data:application/json;base64,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