"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LexV2 = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [lex-v2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlexv2.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class LexV2 extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [lex-v2](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonlexv2.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'lex';
        this.accessLevelList = {
            Write: [
                'BuildBotLocale',
                'CreateBot',
                'CreateBotAlias',
                'CreateBotChannel',
                'CreateBotLocale',
                'CreateBotVersion',
                'CreateCustomVocabulary',
                'CreateExport',
                'CreateIntent',
                'CreateResourcePolicy',
                'CreateSlot',
                'CreateSlotType',
                'CreateUploadUrl',
                'DeleteBot',
                'DeleteBotAlias',
                'DeleteBotChannel',
                'DeleteBotLocale',
                'DeleteBotVersion',
                'DeleteCustomVocabulary',
                'DeleteExport',
                'DeleteImport',
                'DeleteIntent',
                'DeleteResourcePolicy',
                'DeleteSession',
                'DeleteSlot',
                'DeleteSlotType',
                'DeleteUtterances',
                'PutSession',
                'RecognizeText',
                'RecognizeUtterance',
                'StartBotRecommendation',
                'StartConversation',
                'StartImport',
                'UpdateBot',
                'UpdateBotAlias',
                'UpdateBotLocale',
                'UpdateBotRecommendation',
                'UpdateCustomVocabulary',
                'UpdateExport',
                'UpdateIntent',
                'UpdateResourcePolicy',
                'UpdateSlot',
                'UpdateSlotType'
            ],
            Read: [
                'DescribeBot',
                'DescribeBotAlias',
                'DescribeBotChannel',
                'DescribeBotLocale',
                'DescribeBotRecommendation',
                'DescribeBotVersion',
                'DescribeCustomVocabulary',
                'DescribeCustomVocabularyMetadata',
                'DescribeExport',
                'DescribeImport',
                'DescribeIntent',
                'DescribeResourcePolicy',
                'DescribeSlot',
                'DescribeSlotType',
                'GetSession',
                'ListTagsForResource'
            ],
            List: [
                'ListAggregatedUtterances',
                'ListBotAliases',
                'ListBotChannels',
                'ListBotLocales',
                'ListBotRecommendations',
                'ListBotVersions',
                'ListBots',
                'ListBuiltInIntents',
                'ListBuiltInSlotTypes',
                'ListExports',
                'ListImports',
                'ListIntents',
                'ListRecommendedIntents',
                'ListSlotTypes',
                'ListSlots',
                'SearchAssociatedTranscripts'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to build an existing bot locale in a bot
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_BuildBotLocale.html
     */
    toBuildBotLocale() {
        return this.to('BuildBotLocale');
    }
    /**
     * Grants permission to create a new bot and a test bot alias pointing to the DRAFT bot version
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateBot.html
     */
    toCreateBot() {
        return this.to('CreateBot');
    }
    /**
     * Grants permission to create a new bot alias in a bot
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateBotAlias.html
     */
    toCreateBotAlias() {
        return this.to('CreateBotAlias');
    }
    /**
     * Grants permission to create a bot channel in an existing bot
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/deploying-messaging-platform.html
     */
    toCreateBotChannel() {
        return this.to('CreateBotChannel');
    }
    /**
     * Grants permission to create a new bot locale in an existing bot
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateBotLocale.html
     */
    toCreateBotLocale() {
        return this.to('CreateBotLocale');
    }
    /**
     * Grants permission to create a new version of an existing bot
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateBotVersion.html
     */
    toCreateBotVersion() {
        return this.to('CreateBotVersion');
    }
    /**
     * Grants permission to create a new custom vocabulary in an existing bot locale
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/vocab.html
     */
    toCreateCustomVocabulary() {
        return this.to('CreateCustomVocabulary');
    }
    /**
     * Grants permission to create an export for an existing resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateExport.html
     */
    toCreateExport() {
        return this.to('CreateExport');
    }
    /**
     * Grants permission to create a new intent in an existing bot locale
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateIntent.html
     */
    toCreateIntent() {
        return this.to('CreateIntent');
    }
    /**
     * Grants permission to create a new resource policy for a Lex resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateResourcePolicy.html
     */
    toCreateResourcePolicy() {
        return this.to('CreateResourcePolicy');
    }
    /**
     * Grants permission to create a new slot in an intent
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateSlot.html
     */
    toCreateSlot() {
        return this.to('CreateSlot');
    }
    /**
     * Grants permission to create a new slot type in an existing bot locale
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateSlotType.html
     */
    toCreateSlotType() {
        return this.to('CreateSlotType');
    }
    /**
     * Grants permission to create an upload url for import file
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_CreateUploadUrl.html
     */
    toCreateUploadUrl() {
        return this.to('CreateUploadUrl');
    }
    /**
     * Grants permission to delete an existing bot
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - lex:DeleteBotAlias
     * - lex:DeleteBotChannel
     * - lex:DeleteBotLocale
     * - lex:DeleteBotVersion
     * - lex:DeleteIntent
     * - lex:DeleteSlot
     * - lex:DeleteSlotType
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DeleteBot.html
     */
    toDeleteBot() {
        return this.to('DeleteBot');
    }
    /**
     * Grants permission to delete an existing bot alias in a bot
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DeleteBotAlias.html
     */
    toDeleteBotAlias() {
        return this.to('DeleteBotAlias');
    }
    /**
     * Grants permission to delete an existing bot channel
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/deploying-messaging-platform.html
     */
    toDeleteBotChannel() {
        return this.to('DeleteBotChannel');
    }
    /**
     * Grants permission to delete an existing bot locale in a bot
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - lex:DeleteIntent
     * - lex:DeleteSlot
     * - lex:DeleteSlotType
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DeleteBotLocale.html
     */
    toDeleteBotLocale() {
        return this.to('DeleteBotLocale');
    }
    /**
     * Grants permission to delete an existing bot version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DeleteBotVersion.html
     */
    toDeleteBotVersion() {
        return this.to('DeleteBotVersion');
    }
    /**
     * Grants permission to delete an existing custom vocabulary in a bot locale
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DeleteCustomVocabulary.html
     */
    toDeleteCustomVocabulary() {
        return this.to('DeleteCustomVocabulary');
    }
    /**
     * Grants permission to delete an existing export
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DeleteExport.html
     */
    toDeleteExport() {
        return this.to('DeleteExport');
    }
    /**
     * Grants permission to delete an existing import
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DeleteImport.html
     */
    toDeleteImport() {
        return this.to('DeleteImport');
    }
    /**
     * Grants permission to delete an existing intent in a bot locale
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DeleteIntent.html
     */
    toDeleteIntent() {
        return this.to('DeleteIntent');
    }
    /**
     * Grants permission to delete an existing resource policy for a Lex resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DeleteResourcePolicy.html
     */
    toDeleteResourcePolicy() {
        return this.to('DeleteResourcePolicy');
    }
    /**
     * Grants permission to delete session information for a bot alias and user ID
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_DeleteSession.html
     */
    toDeleteSession() {
        return this.to('DeleteSession');
    }
    /**
     * Grants permission to delete an existing slot in an intent
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DeleteSlot.html
     */
    toDeleteSlot() {
        return this.to('DeleteSlot');
    }
    /**
     * Grants permission to delete an existing slot type in a bot locale
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DeleteSlotType.html
     */
    toDeleteSlotType() {
        return this.to('DeleteSlotType');
    }
    /**
     * Grants permission to delete utterance data for a bot
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DeleteUtterances.html
     */
    toDeleteUtterances() {
        return this.to('DeleteUtterances');
    }
    /**
     * Grants permission to retrieve an existing bot
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeBot.html
     */
    toDescribeBot() {
        return this.to('DescribeBot');
    }
    /**
     * Grants permission to retrieve an existing bot alias
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeBotAlias.html
     */
    toDescribeBotAlias() {
        return this.to('DescribeBotAlias');
    }
    /**
     * Grants permission to retrieve an existing bot channel
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/deploying-messaging-platform.html
     */
    toDescribeBotChannel() {
        return this.to('DescribeBotChannel');
    }
    /**
     * Grants permission to retrieve an existing bot locale
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeBotLocale.html
     */
    toDescribeBotLocale() {
        return this.to('DescribeBotLocale');
    }
    /**
     * Grants permission to retrieve metadata information about a bot recommendation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeBotRecommendation.html
     */
    toDescribeBotRecommendation() {
        return this.to('DescribeBotRecommendation');
    }
    /**
     * Grants permission to retrieve an existing bot version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeBotVersion.html
     */
    toDescribeBotVersion() {
        return this.to('DescribeBotVersion');
    }
    /**
     * Grants permission to retrieve an existing custom vocabulary
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/vocab.html
     */
    toDescribeCustomVocabulary() {
        return this.to('DescribeCustomVocabulary');
    }
    /**
     * Grants permission to retrieve metadata of an existing custom vocabulary
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeCustomVocabularyMetadata.html
     */
    toDescribeCustomVocabularyMetadata() {
        return this.to('DescribeCustomVocabularyMetadata');
    }
    /**
     * Grants permission to retrieve an existing export
     *
     * Access Level: Read
     *
     * Dependent actions:
     * - lex:DescribeBot
     * - lex:DescribeBotLocale
     * - lex:DescribeIntent
     * - lex:DescribeSlot
     * - lex:DescribeSlotType
     * - lex:ListBotLocales
     * - lex:ListIntents
     * - lex:ListSlotTypes
     * - lex:ListSlots
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeExport.html
     */
    toDescribeExport() {
        return this.to('DescribeExport');
    }
    /**
     * Grants permission to retrieve an existing import
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeImport.html
     */
    toDescribeImport() {
        return this.to('DescribeImport');
    }
    /**
     * Grants permission to retrieve an existing intent
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeIntent.html
     */
    toDescribeIntent() {
        return this.to('DescribeIntent');
    }
    /**
     * Grants permission to retrieve an existing resource policy for a Lex resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeResourcePolicy.html
     */
    toDescribeResourcePolicy() {
        return this.to('DescribeResourcePolicy');
    }
    /**
     * Grants permission to retrieve an existing slot
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeSlot.html
     */
    toDescribeSlot() {
        return this.to('DescribeSlot');
    }
    /**
     * Grants permission to retrieve an existing slot type
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_DescribeSlotType.html
     */
    toDescribeSlotType() {
        return this.to('DescribeSlotType');
    }
    /**
     * Grants permission to retrieve session information for a bot alias and user ID
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_GetSession.html
     */
    toGetSession() {
        return this.to('GetSession');
    }
    /**
     * Grants permission to list utterances and statistics for a bot
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_ListAggregatedUtterances.html
     */
    toListAggregatedUtterances() {
        return this.to('ListAggregatedUtterances');
    }
    /**
     * Grants permission to list bot aliases in an bot
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_ListBotAliases.html
     */
    toListBotAliases() {
        return this.to('ListBotAliases');
    }
    /**
     * Grants permission to list bot channels
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/deploying-messaging-platform.html
     */
    toListBotChannels() {
        return this.to('ListBotChannels');
    }
    /**
     * Grants permission to list bot locales in a bot
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_ListBotLocales.html
     */
    toListBotLocales() {
        return this.to('ListBotLocales');
    }
    /**
     * Grants permission to get a list of bot recommendations that meet the specified criteria
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_ListBotRecommendations.html
     */
    toListBotRecommendations() {
        return this.to('ListBotRecommendations');
    }
    /**
     * Grants permission to list existing bot versions
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_ListBotVersions.html
     */
    toListBotVersions() {
        return this.to('ListBotVersions');
    }
    /**
     * Grants permission to list existing bots
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_ListBots.html
     */
    toListBots() {
        return this.to('ListBots');
    }
    /**
     * Grants permission to list built-in intents
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_ListBuiltInIntents.html
     */
    toListBuiltInIntents() {
        return this.to('ListBuiltInIntents');
    }
    /**
     * Grants permission to list built-in slot types
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_ListBuiltInSlotTypes.html
     */
    toListBuiltInSlotTypes() {
        return this.to('ListBuiltInSlotTypes');
    }
    /**
     * Grants permission to list existing exports
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_ListExports.html
     */
    toListExports() {
        return this.to('ListExports');
    }
    /**
     * Grants permission to list existing imports
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_ListImports.html
     */
    toListImports() {
        return this.to('ListImports');
    }
    /**
     * Grants permission to list intents in a bot
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_ListIntents.html
     */
    toListIntents() {
        return this.to('ListIntents');
    }
    /**
     * Grants permission to get a list of recommended intents provided by the bot recommendation
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_ListRecommendedIntents.html
     */
    toListRecommendedIntents() {
        return this.to('ListRecommendedIntents');
    }
    /**
     * Grants permission to list slot types in a bot
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_ListSlotTypes.html
     */
    toListSlotTypes() {
        return this.to('ListSlotTypes');
    }
    /**
     * Grants permission to list slots in an intent
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_ListSlots.html
     */
    toListSlots() {
        return this.to('ListSlots');
    }
    /**
     * Grants permission to lists tags for a Lex resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to create a new session or modify an existing session for a bot alias and user ID
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_PutSession.html
     */
    toPutSession() {
        return this.to('PutSession');
    }
    /**
     * Grants permission to send user input (text-only) to an bot alias
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_RecognizeText.html
     */
    toRecognizeText() {
        return this.to('RecognizeText');
    }
    /**
     * Grants permission to send user input (text or speech) to an bot alias
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_RecognizeUtterance.html
     */
    toRecognizeUtterance() {
        return this.to('RecognizeUtterance');
    }
    /**
     * Grants permission to search for associated transcripts that meet the specified criteria
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_SearchAssociatedTranscripts.html
     */
    toSearchAssociatedTranscripts() {
        return this.to('SearchAssociatedTranscripts');
    }
    /**
     * Grants permission to start a bot recommendation for an existing bot locale
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_StartBotRecommendation.html
     */
    toStartBotRecommendation() {
        return this.to('StartBotRecommendation');
    }
    /**
     * Grants permission to stream user input (speech/text/DTMF) to a bot alias
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_runtime_StartConversation.html
     */
    toStartConversation() {
        return this.to('StartConversation');
    }
    /**
     * Grants permission to start a new import with the uploaded import file
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * Dependent actions:
     * - lex:CreateBot
     * - lex:CreateBotLocale
     * - lex:CreateIntent
     * - lex:CreateSlot
     * - lex:CreateSlotType
     * - lex:DeleteBotLocale
     * - lex:DeleteIntent
     * - lex:DeleteSlot
     * - lex:DeleteSlotType
     * - lex:UpdateBot
     * - lex:UpdateBotLocale
     * - lex:UpdateIntent
     * - lex:UpdateSlot
     * - lex:UpdateSlotType
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_StartImport.html
     */
    toStartImport() {
        return this.to('StartImport');
    }
    /**
     * Grants permission to add or overwrite tags of a Lex resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to remove tags from a Lex resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update an existing bot
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_UpdateBot.html
     */
    toUpdateBot() {
        return this.to('UpdateBot');
    }
    /**
     * Grants permission to update an existing bot alias
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_UpdateBotAlias.html
     */
    toUpdateBotAlias() {
        return this.to('UpdateBotAlias');
    }
    /**
     * Grants permission to update an existing bot locale
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_UpdateBotLocale.html
     */
    toUpdateBotLocale() {
        return this.to('UpdateBotLocale');
    }
    /**
     * Grants permission to update an existing bot recommendation request
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_UpdateBotRecommendation.html
     */
    toUpdateBotRecommendation() {
        return this.to('UpdateBotRecommendation');
    }
    /**
     * Grants permission to update an existing custom vocabulary
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/vocab.html
     */
    toUpdateCustomVocabulary() {
        return this.to('UpdateCustomVocabulary');
    }
    /**
     * Grants permission to update an existing export
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_UpdateExport.html
     */
    toUpdateExport() {
        return this.to('UpdateExport');
    }
    /**
     * Grants permission to update an existing intent
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_UpdateIntent.html
     */
    toUpdateIntent() {
        return this.to('UpdateIntent');
    }
    /**
     * Grants permission to update an existing resource policy for a Lex resource
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_UpdateResourcePolicy.html
     */
    toUpdateResourcePolicy() {
        return this.to('UpdateResourcePolicy');
    }
    /**
     * Grants permission to update an existing slot
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_UpdateSlot.html
     */
    toUpdateSlot() {
        return this.to('UpdateSlot');
    }
    /**
     * Grants permission to update an existing slot type
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/API_UpdateSlotType.html
     */
    toUpdateSlotType() {
        return this.to('UpdateSlotType');
    }
    /**
     * Adds a resource of type bot to the statement
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/how-it-works.html
     *
     * @param botId - Identifier for the botId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onBot(botId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:lex:${region || '*'}:${account || '*'}:bot/${botId}`);
    }
    /**
     * Adds a resource of type bot alias to the statement
     *
     * https://docs.aws.amazon.com/lexv2/latest/dg/how-it-works.html
     *
     * @param botId - Identifier for the botId.
     * @param botAliasId - Identifier for the botAliasId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onBotAlias(botId, botAliasId, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:lex:${region || '*'}:${account || '*'}:bot-alias/${botId}/${botAliasId}`);
    }
}
exports.LexV2 = LexV2;
_a = JSII_RTTI_SYMBOL_1;
LexV2[_a] = { fqn: "cdk-iam-floyd.LexV2", version: "0.333.0" };
//# sourceMappingURL=data:application/json;base64,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