"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Resiliencehub = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [resiliencehub](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsresiliencehubservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Resiliencehub extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [resiliencehub](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsresiliencehubservice.html).
     *
     */
    constructor(props) {
        super(props);
        this.servicePrefix = 'resiliencehub';
        this.accessLevelList = {
            Write: [
                'AddDraftAppVersionResourceMappings',
                'CreateApp',
                'CreateRecommendationTemplate',
                'CreateResiliencyPolicy',
                'DeleteApp',
                'DeleteAppAssessment',
                'DeleteRecommendationTemplate',
                'DeleteResiliencyPolicy',
                'ImportResourcesToDraftAppVersion',
                'PublishAppVersion',
                'PutDraftAppVersionTemplate',
                'RemoveDraftAppVersionResourceMappings',
                'ResolveAppVersionResources',
                'StartAppAssessment',
                'UpdateApp',
                'UpdateResiliencyPolicy'
            ],
            Read: [
                'DescribeApp',
                'DescribeAppAssessment',
                'DescribeAppVersionResourcesResolutionStatus',
                'DescribeAppVersionTemplate',
                'DescribeDraftAppVersionResourcesImportStatus',
                'DescribeResiliencyPolicy',
                'ListTagsForResource'
            ],
            List: [
                'ListAlarmRecommendations',
                'ListAppAssessments',
                'ListAppComponentCompliances',
                'ListAppComponentRecommendations',
                'ListAppVersionResourceMappings',
                'ListAppVersionResources',
                'ListAppVersions',
                'ListApps',
                'ListRecommendationTemplates',
                'ListResiliencyPolicies',
                'ListSopRecommendations',
                'ListSuggestedResiliencyPolicies',
                'ListTestRecommendations',
                'ListUnsupportedAppVersionResources'
            ],
            Tagging: [
                'TagResource',
                'UntagResource'
            ]
        };
    }
    /**
     * Grants permission to add draft application version resource mappings
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - cloudformation:DescribeStacks
     * - cloudformation:ListStackResources
     * - resource-groups:GetGroup
     * - resource-groups:ListGroupResources
     * - servicecatalog:GetApplication
     * - servicecatalog:ListAssociatedResources
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_AddDraftAppVersionResourceMappings.html
     */
    toAddDraftAppVersionResourceMappings() {
        return this.to('AddDraftAppVersionResourceMappings');
    }
    /**
     * Grants permission to create application
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_CreateApp.html
     */
    toCreateApp() {
        return this.to('CreateApp');
    }
    /**
     * Grants permission to create recommendation template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - s3:CreateBucket
     * - s3:ListBucket
     * - s3:PutObject
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_CreateRecommendationTemplate.html
     */
    toCreateRecommendationTemplate() {
        return this.to('CreateRecommendationTemplate');
    }
    /**
     * Grants permission to create resiliency policy
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_CreateResiliencyPolicy.html
     */
    toCreateResiliencyPolicy() {
        return this.to('CreateResiliencyPolicy');
    }
    /**
     * Grants permission to batch delete application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DeleteApp.html
     */
    toDeleteApp() {
        return this.to('DeleteApp');
    }
    /**
     * Grants permission to batch delete application assessment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DeleteAppAssessment.html
     */
    toDeleteAppAssessment() {
        return this.to('DeleteAppAssessment');
    }
    /**
     * Grants permission to batch delete recommendation template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DeleteRecommendationTemplate.html
     */
    toDeleteRecommendationTemplate() {
        return this.to('DeleteRecommendationTemplate');
    }
    /**
     * Grants permission to batch delete resiliency policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DeleteResiliencyPolicy.html
     */
    toDeleteResiliencyPolicy() {
        return this.to('DeleteResiliencyPolicy');
    }
    /**
     * Grants permission to describe application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DescribeApp.html
     */
    toDescribeApp() {
        return this.to('DescribeApp');
    }
    /**
     * Grants permission to describe application assessment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DescribeAppAssessment.html
     */
    toDescribeAppAssessment() {
        return this.to('DescribeAppAssessment');
    }
    /**
     * Grants permission to describe application resolution
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DescribeAppVersionResourcesResolutionStatus.html
     */
    toDescribeAppVersionResourcesResolutionStatus() {
        return this.to('DescribeAppVersionResourcesResolutionStatus');
    }
    /**
     * Grants permission to describe application version template
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DescribeAppVersionTemplate.html
     */
    toDescribeAppVersionTemplate() {
        return this.to('DescribeAppVersionTemplate');
    }
    /**
     * Grants permission to describe draft application version resources import status
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DescribeDraftAppVersionResourcesImportStatus.html
     */
    toDescribeDraftAppVersionResourcesImportStatus() {
        return this.to('DescribeDraftAppVersionResourcesImportStatus');
    }
    /**
     * Grants permission to describe resiliency policy
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_DescribeResiliencyPolicy.html
     */
    toDescribeResiliencyPolicy() {
        return this.to('DescribeResiliencyPolicy');
    }
    /**
     * Grants permission to import resources to draft application version
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - cloudformation:DescribeStacks
     * - cloudformation:ListStackResources
     * - resource-groups:GetGroup
     * - resource-groups:ListGroupResources
     * - servicecatalog:GetApplication
     * - servicecatalog:ListAssociatedResources
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ImportResourcesToDraftAppVersion.html
     */
    toImportResourcesToDraftAppVersion() {
        return this.to('ImportResourcesToDraftAppVersion');
    }
    /**
     * Grants permission to list alarm recommendation
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListAlarmRecommendations.html
     */
    toListAlarmRecommendations() {
        return this.to('ListAlarmRecommendations');
    }
    /**
     * Grants permission to list application assessment
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListAppAssessments.html
     */
    toListAppAssessments() {
        return this.to('ListAppAssessments');
    }
    /**
     * Grants permission to list app component compliances
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListAppComponentCompliances.html
     */
    toListAppComponentCompliances() {
        return this.to('ListAppComponentCompliances');
    }
    /**
     * Grants permission to list app component recommendations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListAppComponentRecommendations.html
     */
    toListAppComponentRecommendations() {
        return this.to('ListAppComponentRecommendations');
    }
    /**
     * Grants permission to application version resource mappings
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListAppVersionResourceMappings.html
     */
    toListAppVersionResourceMappings() {
        return this.to('ListAppVersionResourceMappings');
    }
    /**
     * Grants permission to list application resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListAppVersionResources.html
     */
    toListAppVersionResources() {
        return this.to('ListAppVersionResources');
    }
    /**
     * Grants permission to list application version
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListAppVersions.html
     */
    toListAppVersions() {
        return this.to('ListAppVersions');
    }
    /**
     * Grants permission to list applications
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListApps.html
     */
    toListApps() {
        return this.to('ListApps');
    }
    /**
     * Grants permission to list recommendation templates
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListRecommendationTemplates.html
     */
    toListRecommendationTemplates() {
        return this.to('ListRecommendationTemplates');
    }
    /**
     * Grants permission to list resiliency policies
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListResiliencyPolicies.html
     */
    toListResiliencyPolicies() {
        return this.to('ListResiliencyPolicies');
    }
    /**
     * Grants permission to list SOP recommendations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListSopRecommendations.html
     */
    toListSopRecommendations() {
        return this.to('ListSopRecommendations');
    }
    /**
     * Grants permission to list suggested resiliency policies
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListSuggestedResiliencyPolicies.html
     */
    toListSuggestedResiliencyPolicies() {
        return this.to('ListSuggestedResiliencyPolicies');
    }
    /**
     * Grants permission to list tags for a resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to list test recommendations
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListTestRecommendations.html
     */
    toListTestRecommendations() {
        return this.to('ListTestRecommendations');
    }
    /**
     * Grants permission to list unsupported application version resources
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ListUnsupportedAppVersionResources.html
     */
    toListUnsupportedAppVersionResources() {
        return this.to('ListUnsupportedAppVersionResources');
    }
    /**
     * Grants permission to publish application version
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_PublishAppVersion.html
     */
    toPublishAppVersion() {
        return this.to('PublishAppVersion');
    }
    /**
     * Grants permission to put draft application version template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_PutDraftAppVersionTemplate.html
     */
    toPutDraftAppVersionTemplate() {
        return this.to('PutDraftAppVersionTemplate');
    }
    /**
     * Grants permission to remove draft application version mappings
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_RemoveDraftAppVersionResourceMappings.html
     */
    toRemoveDraftAppVersionResourceMappings() {
        return this.to('RemoveDraftAppVersionResourceMappings');
    }
    /**
     * Grants permission to resolve application version resources
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - cloudformation:DescribeStacks
     * - cloudformation:ListStackResources
     * - resource-groups:GetGroup
     * - resource-groups:ListGroupResources
     * - servicecatalog:GetApplication
     * - servicecatalog:ListAssociatedResources
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ResolveAppVersionResources.html
     */
    toResolveAppVersionResources() {
        return this.to('ResolveAppVersionResources');
    }
    /**
     * Grants permission to create application assessment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * Dependent actions:
     * - cloudformation:DescribeStacks
     * - cloudformation:ListStackResources
     * - cloudwatch:DescribeAlarms
     * - cloudwatch:GetMetricData
     * - cloudwatch:GetMetricStatistics
     * - cloudwatch:PutMetricData
     * - fis:GetExperimentTemplate
     * - fis:ListExperimentTemplates
     * - fis:ListExperiments
     * - resource-groups:GetGroup
     * - resource-groups:ListGroupResources
     * - servicecatalog:GetApplication
     * - servicecatalog:ListAssociatedResources
     * - ssm:GetParametersByPath
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_StartAppAssessment.html
     */
    toStartAppAssessment() {
        return this.to('StartAppAssessment');
    }
    /**
     * Grants permission to assign a resource tag
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_TagResource.html
     */
    toTagResource() {
        return this.to('TagResource');
    }
    /**
     * Grants permission to untag a resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_UntagResource.html
     */
    toUntagResource() {
        return this.to('UntagResource');
    }
    /**
     * Grants permission to update application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_UpdateApp.html
     */
    toUpdateApp() {
        return this.to('UpdateApp');
    }
    /**
     * Grants permission to update resiliency policy
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_UpdateResiliencyPolicy.html
     */
    toUpdateResiliencyPolicy() {
        return this.to('UpdateResiliencyPolicy');
    }
    /**
     * Adds a resource of type resiliency-policy to the statement
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_ResiliencyPolicy.html
     *
     * @param resiliencyPolicyID - Identifier for the resiliencyPolicyID.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onResiliencyPolicy(resiliencyPolicyID, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:resiliencehub:${region || '*'}:${account || '*'}:resiliency-policy/${resiliencyPolicyID}`);
    }
    /**
     * Adds a resource of type application to the statement
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_App.html
     *
     * @param appID - Identifier for the appID.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onApplication(appID, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:resiliencehub:${region || '*'}:${account || '*'}:app/${appID}`);
    }
    /**
     * Adds a resource of type app-assessment to the statement
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_AppAssessment.html
     *
     * @param appAssessmentID - Identifier for the appAssessmentID.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onAppAssessment(appAssessmentID, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:resiliencehub:${region || '*'}:${account || '*'}:app-assessment/${appAssessmentID}`);
    }
    /**
     * Adds a resource of type recommendation-template to the statement
     *
     * https://docs.aws.amazon.com/resilience-hub/latest/APIReference/API_RecommendationTemplate.html
     *
     * @param recommendationTemplateID - Identifier for the recommendationTemplateID.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onRecommendationTemplate(recommendationTemplateID, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:resiliencehub:${region || '*'}:${account || '*'}:recommendation-template/${recommendationTemplateID}`);
    }
}
exports.Resiliencehub = Resiliencehub;
_a = JSII_RTTI_SYMBOL_1;
Resiliencehub[_a] = { fqn: "cdk-iam-floyd.Resiliencehub", version: "0.333.0" };
//# sourceMappingURL=data:application/json;base64,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