import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [sustainability](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssustainability.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Sustainability extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to view the carbon footprint tool
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-permissions-ref.html
     */
    toGetCarbonFootprintSummary(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Statement provider for service [sustainability](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssustainability.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
