import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * Statement provider for service [ssm-guiconnect](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssystemsmanagerguiconnect.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class SsmGuiconnect extends PolicyStatement {
    servicePrefix: string;
    /**
     * Grants permission to terminate a GUI Connect session
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/systems-manager/latest/userguide/fleet-rdp.html
     */
    toCancelConnection(): this;
    /**
     * Grants permission to get the metadata for a GUI Connect session
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/systems-manager/latest/userguide/fleet-rdp.html
     */
    toGetConnection(): this;
    /**
     * Grants permission to start a GUI Connect session
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/systems-manager/latest/userguide/fleet-rdp.html
     */
    toStartConnection(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Statement provider for service [ssm-guiconnect](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awssystemsmanagerguiconnect.html).
     *
     */
    constructor(props?: iam.PolicyStatementProps);
}
