#! /usr/bin/env python
# -*- coding: utf-8 -*-
#
# Interpreter version: python 2.7
#
# Imports =====================================================================
from string import Template
from collections import OrderedDict


# Variables ===================================================================
COMMENT_WARNING = """#
# !!! DO NOT EDIT THIS FILE!!!
# !!! THIS IS AUTOMATICALLY GENERATED FILE !!!
# !!! SEE requests_template.py AND requests_generator.py FOR DETAILS !!!
#"""

REVIEW = OrderedDict([  #: This structure is used to construct GenerateReview
    ["nazev", "Název ePublikace"],
    ["podnazev", "Podnázev"],
    ["cast", "Část (svazek,díl)"],
    ["nazev_casti", "Název části, dílu"],
    ["isbn", "ISBN"],
    ["isbn_souboru_publikaci", "ISBN souboru"],
    ["generated_isbn", 'Přidělit ISBN'],
    ["author1", "Autor"],
    ["author2", "Autor 2"],
    ["author3", "Autor 3"],
    ["poradi_vydani", 'Pořadí vydání, verze'],
    ["misto_vydani", 'Místo vydání'],
    ["rok_vydani", "Rok vydání"],
    ["nakladatel_vydavatel", "Nakladatel"],
    ["vydano_v_koedici_s", 'Vydáno v koedici s'],
    ["cena", 'Cena v Kč'],

    ["libraries_accessing", "Oprávnění knihovnám"],
    ["libraries_that_can_access", "Seznam knihoven"],

    ["is_public", 'Vystavení na volném internetu'],
    ["url", "URL"],

    ["offer_to_riv", 'Zpřístupnit pro RIV'],
    ["category_for_riv", "Seznam oborů pro RIV"],

    ["zpracovatel_zaznamu", 'Zpracovatel záznamu'],
    ["format", "Formát souboru"],
    ["filename", "Název souboru"],
    ["internal_url", "Edeposit URL"],
])


# Main program ================================================================
if __name__ == '__main__':
    with open("requests_template.txt") as f:
        template = f.read()

    all_keys = REVIEW.keys()

    # create OrderedDict as key_name: meaning
    semantic_dict = map(
        lambda (key, val): '["%s", "%s"],' % (key, val),
        REVIEW.items()
    )
    semantic_dict = "\n            ".join(
        ["semantic_dict = OrderedDict(["] + semantic_dict
    )
    semantic_dict = semantic_dict + "\n        ])"

    # create help for attributes
    attributes = map(
        lambda (key, val): '%s (any): %s' % (key, val),
        REVIEW.items()
    )
    attributes = "\n        ".join(attributes)

    # construct template
    content = Template(template).substitute(
        warning_mark=COMMENT_WARNING,
        first_key="'" + all_keys[0] + "'",
        other_keys=(",\n" + (51 * " ")).join(
            map(lambda x: "'%s'" % x, all_keys[1:])
        ),
        semantic_dict=semantic_dict,
        attributes=attributes
    )

    with open("requests.py", "w") as f:
        f.write(content)

    print "requests.py rewritten"
