# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetRepositoryArchiveContentResult',
    'AwaitableGetRepositoryArchiveContentResult',
    'get_repository_archive_content',
    'get_repository_archive_content_output',
]

@pulumi.output_type
class GetRepositoryArchiveContentResult:
    """
    A collection of values returned by getRepositoryArchiveContent.
    """
    def __init__(__self__, format=None, id=None, ref_name=None, repository_id=None):
        if format and not isinstance(format, str):
            raise TypeError("Expected argument 'format' to be a str")
        pulumi.set(__self__, "format", format)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ref_name and not isinstance(ref_name, str):
            raise TypeError("Expected argument 'ref_name' to be a str")
        pulumi.set(__self__, "ref_name", ref_name)
        if repository_id and not isinstance(repository_id, str):
            raise TypeError("Expected argument 'repository_id' to be a str")
        pulumi.set(__self__, "repository_id", repository_id)

    @property
    @pulumi.getter
    def format(self) -> Optional[str]:
        return pulumi.get(self, "format")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="refName")
    def ref_name(self) -> Optional[str]:
        return pulumi.get(self, "ref_name")

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> str:
        return pulumi.get(self, "repository_id")


class AwaitableGetRepositoryArchiveContentResult(GetRepositoryArchiveContentResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRepositoryArchiveContentResult(
            format=self.format,
            id=self.id,
            ref_name=self.ref_name,
            repository_id=self.repository_id)


def get_repository_archive_content(format: Optional[str] = None,
                                   ref_name: Optional[str] = None,
                                   repository_id: Optional[str] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRepositoryArchiveContentResult:
    """
    This data source provides details about a specific Repository Archive Content resource in Oracle Cloud Infrastructure Devops service.

    Returns the archived repository information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_repository_archive_content = oci.DevOps.get_repository_archive_content(repository_id=test_repository["id"],
        format=repository_archive_content_format,
        ref_name=repository_archive_content_ref_name)
    ```


    :param str format: The archive format query parameter for downloading repository endpoint.
    :param str ref_name: A filter to return only resources that match the given reference name.
    :param str repository_id: Unique repository identifier.
    """
    __args__ = dict()
    __args__['format'] = format
    __args__['refName'] = ref_name
    __args__['repositoryId'] = repository_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DevOps/getRepositoryArchiveContent:getRepositoryArchiveContent', __args__, opts=opts, typ=GetRepositoryArchiveContentResult).value

    return AwaitableGetRepositoryArchiveContentResult(
        format=pulumi.get(__ret__, 'format'),
        id=pulumi.get(__ret__, 'id'),
        ref_name=pulumi.get(__ret__, 'ref_name'),
        repository_id=pulumi.get(__ret__, 'repository_id'))


@_utilities.lift_output_func(get_repository_archive_content)
def get_repository_archive_content_output(format: Optional[pulumi.Input[Optional[str]]] = None,
                                          ref_name: Optional[pulumi.Input[Optional[str]]] = None,
                                          repository_id: Optional[pulumi.Input[str]] = None,
                                          opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetRepositoryArchiveContentResult]:
    """
    This data source provides details about a specific Repository Archive Content resource in Oracle Cloud Infrastructure Devops service.

    Returns the archived repository information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_repository_archive_content = oci.DevOps.get_repository_archive_content(repository_id=test_repository["id"],
        format=repository_archive_content_format,
        ref_name=repository_archive_content_ref_name)
    ```


    :param str format: The archive format query parameter for downloading repository endpoint.
    :param str ref_name: A filter to return only resources that match the given reference name.
    :param str repository_id: Unique repository identifier.
    """
    ...
