# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetJavaDownloadsJavaDownloadReportResult',
    'AwaitableGetJavaDownloadsJavaDownloadReportResult',
    'get_java_downloads_java_download_report',
    'get_java_downloads_java_download_report_output',
]

@pulumi.output_type
class GetJavaDownloadsJavaDownloadReportResult:
    """
    A collection of values returned by getJavaDownloadsJavaDownloadReport.
    """
    def __init__(__self__, checksum_type=None, checksum_value=None, compartment_id=None, created_bies=None, defined_tags=None, display_name=None, file_size_in_bytes=None, format=None, freeform_tags=None, id=None, java_download_report_id=None, sort_by=None, sort_order=None, state=None, system_tags=None, time_created=None, time_end=None, time_start=None):
        if checksum_type and not isinstance(checksum_type, str):
            raise TypeError("Expected argument 'checksum_type' to be a str")
        pulumi.set(__self__, "checksum_type", checksum_type)
        if checksum_value and not isinstance(checksum_value, str):
            raise TypeError("Expected argument 'checksum_value' to be a str")
        pulumi.set(__self__, "checksum_value", checksum_value)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if created_bies and not isinstance(created_bies, list):
            raise TypeError("Expected argument 'created_bies' to be a list")
        pulumi.set(__self__, "created_bies", created_bies)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if file_size_in_bytes and not isinstance(file_size_in_bytes, str):
            raise TypeError("Expected argument 'file_size_in_bytes' to be a str")
        pulumi.set(__self__, "file_size_in_bytes", file_size_in_bytes)
        if format and not isinstance(format, str):
            raise TypeError("Expected argument 'format' to be a str")
        pulumi.set(__self__, "format", format)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if java_download_report_id and not isinstance(java_download_report_id, str):
            raise TypeError("Expected argument 'java_download_report_id' to be a str")
        pulumi.set(__self__, "java_download_report_id", java_download_report_id)
        if sort_by and not isinstance(sort_by, str):
            raise TypeError("Expected argument 'sort_by' to be a str")
        pulumi.set(__self__, "sort_by", sort_by)
        if sort_order and not isinstance(sort_order, str):
            raise TypeError("Expected argument 'sort_order' to be a str")
        pulumi.set(__self__, "sort_order", sort_order)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_end and not isinstance(time_end, str):
            raise TypeError("Expected argument 'time_end' to be a str")
        pulumi.set(__self__, "time_end", time_end)
        if time_start and not isinstance(time_start, str):
            raise TypeError("Expected argument 'time_start' to be a str")
        pulumi.set(__self__, "time_start", time_start)

    @property
    @pulumi.getter(name="checksumType")
    def checksum_type(self) -> str:
        """
        The algorithm used for calculating the checksum.
        """
        return pulumi.get(self, "checksum_type")

    @property
    @pulumi.getter(name="checksumValue")
    def checksum_value(self) -> str:
        """
        The checksum value of the Java download report file.
        """
        return pulumi.get(self, "checksum_value")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the tenancy scoped to the Java download report.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="createdBies")
    def created_bies(self) -> Sequence['outputs.GetJavaDownloadsJavaDownloadReportCreatedByResult']:
        """
        An authorized principal.
        """
        return pulumi.get(self, "created_bies")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`. (See [Understanding Free-form Tags](https://docs.cloud.oracle.com/iaas/Content/Tagging/Tasks/managingtagsandtagnamespaces.htm)).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Display name for the Java download report.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="fileSizeInBytes")
    def file_size_in_bytes(self) -> str:
        """
        Approximate size of the Java download report file in bytes.
        """
        return pulumi.get(self, "file_size_in_bytes")

    @property
    @pulumi.getter
    def format(self) -> str:
        """
        The file format of the Java download report.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type, or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`. (See [Managing Tags and Tag Namespaces](https://docs.cloud.oracle.com/iaas/Content/Tagging/Concepts/understandingfreeformtags.htm).)
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Java download report.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="javaDownloadReportId")
    def java_download_report_id(self) -> str:
        return pulumi.get(self, "java_download_report_id")

    @property
    @pulumi.getter(name="sortBy")
    def sort_by(self) -> str:
        return pulumi.get(self, "sort_by")

    @property
    @pulumi.getter(name="sortOrder")
    def sort_order(self) -> str:
        return pulumi.get(self, "sort_order")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the Java download report.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). System tags can be viewed by users, but can only be created by the system.  Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the Java download report was created, displayed as an [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339) formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeEnd")
    def time_end(self) -> str:
        """
        The end time until when the download records are included (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_end")

    @property
    @pulumi.getter(name="timeStart")
    def time_start(self) -> str:
        """
        The start time from when the download records are included (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
        """
        return pulumi.get(self, "time_start")


class AwaitableGetJavaDownloadsJavaDownloadReportResult(GetJavaDownloadsJavaDownloadReportResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetJavaDownloadsJavaDownloadReportResult(
            checksum_type=self.checksum_type,
            checksum_value=self.checksum_value,
            compartment_id=self.compartment_id,
            created_bies=self.created_bies,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            file_size_in_bytes=self.file_size_in_bytes,
            format=self.format,
            freeform_tags=self.freeform_tags,
            id=self.id,
            java_download_report_id=self.java_download_report_id,
            sort_by=self.sort_by,
            sort_order=self.sort_order,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_end=self.time_end,
            time_start=self.time_start)


def get_java_downloads_java_download_report(java_download_report_id: Optional[str] = None,
                                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetJavaDownloadsJavaDownloadReportResult:
    """
    This data source provides details about a specific Java Download Report resource in Oracle Cloud Infrastructure Jms Java Downloads service.

    Gets a JavaDownloadReport by the specified identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_java_download_report = oci.Jms.get_java_downloads_java_download_report(java_download_report_id=test_java_download_report_oci_jms_java_downloads_java_download_report["id"])
    ```


    :param str java_download_report_id: Unique Java download report identifier.
    """
    __args__ = dict()
    __args__['javaDownloadReportId'] = java_download_report_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Jms/getJavaDownloadsJavaDownloadReport:getJavaDownloadsJavaDownloadReport', __args__, opts=opts, typ=GetJavaDownloadsJavaDownloadReportResult).value

    return AwaitableGetJavaDownloadsJavaDownloadReportResult(
        checksum_type=pulumi.get(__ret__, 'checksum_type'),
        checksum_value=pulumi.get(__ret__, 'checksum_value'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        created_bies=pulumi.get(__ret__, 'created_bies'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        file_size_in_bytes=pulumi.get(__ret__, 'file_size_in_bytes'),
        format=pulumi.get(__ret__, 'format'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        java_download_report_id=pulumi.get(__ret__, 'java_download_report_id'),
        sort_by=pulumi.get(__ret__, 'sort_by'),
        sort_order=pulumi.get(__ret__, 'sort_order'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_end=pulumi.get(__ret__, 'time_end'),
        time_start=pulumi.get(__ret__, 'time_start'))


@_utilities.lift_output_func(get_java_downloads_java_download_report)
def get_java_downloads_java_download_report_output(java_download_report_id: Optional[pulumi.Input[str]] = None,
                                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetJavaDownloadsJavaDownloadReportResult]:
    """
    This data source provides details about a specific Java Download Report resource in Oracle Cloud Infrastructure Jms Java Downloads service.

    Gets a JavaDownloadReport by the specified identifier.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_java_download_report = oci.Jms.get_java_downloads_java_download_report(java_download_report_id=test_java_download_report_oci_jms_java_downloads_java_download_report["id"])
    ```


    :param str java_download_report_id: Unique Java download report identifier.
    """
    ...
