# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetListingPackageResult',
    'AwaitableGetListingPackageResult',
    'get_listing_package',
    'get_listing_package_output',
]

@pulumi.output_type
class GetListingPackageResult:
    """
    A collection of values returned by getListingPackage.
    """
    def __init__(__self__, app_catalog_listing_id=None, app_catalog_listing_resource_version=None, compartment_id=None, description=None, id=None, image_id=None, listing_id=None, operating_systems=None, package_type=None, package_version=None, pricings=None, regions=None, resource_id=None, resource_link=None, time_created=None, variables=None, version=None):
        if app_catalog_listing_id and not isinstance(app_catalog_listing_id, str):
            raise TypeError("Expected argument 'app_catalog_listing_id' to be a str")
        pulumi.set(__self__, "app_catalog_listing_id", app_catalog_listing_id)
        if app_catalog_listing_resource_version and not isinstance(app_catalog_listing_resource_version, str):
            raise TypeError("Expected argument 'app_catalog_listing_resource_version' to be a str")
        pulumi.set(__self__, "app_catalog_listing_resource_version", app_catalog_listing_resource_version)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if image_id and not isinstance(image_id, str):
            raise TypeError("Expected argument 'image_id' to be a str")
        pulumi.set(__self__, "image_id", image_id)
        if listing_id and not isinstance(listing_id, str):
            raise TypeError("Expected argument 'listing_id' to be a str")
        pulumi.set(__self__, "listing_id", listing_id)
        if operating_systems and not isinstance(operating_systems, list):
            raise TypeError("Expected argument 'operating_systems' to be a list")
        pulumi.set(__self__, "operating_systems", operating_systems)
        if package_type and not isinstance(package_type, str):
            raise TypeError("Expected argument 'package_type' to be a str")
        pulumi.set(__self__, "package_type", package_type)
        if package_version and not isinstance(package_version, str):
            raise TypeError("Expected argument 'package_version' to be a str")
        pulumi.set(__self__, "package_version", package_version)
        if pricings and not isinstance(pricings, list):
            raise TypeError("Expected argument 'pricings' to be a list")
        pulumi.set(__self__, "pricings", pricings)
        if regions and not isinstance(regions, list):
            raise TypeError("Expected argument 'regions' to be a list")
        pulumi.set(__self__, "regions", regions)
        if resource_id and not isinstance(resource_id, str):
            raise TypeError("Expected argument 'resource_id' to be a str")
        pulumi.set(__self__, "resource_id", resource_id)
        if resource_link and not isinstance(resource_link, str):
            raise TypeError("Expected argument 'resource_link' to be a str")
        pulumi.set(__self__, "resource_link", resource_link)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if variables and not isinstance(variables, list):
            raise TypeError("Expected argument 'variables' to be a list")
        pulumi.set(__self__, "variables", variables)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="appCatalogListingId")
    def app_catalog_listing_id(self) -> str:
        """
        The ID of the listing resource associated with this listing package. For more information, see [AppCatalogListing](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/latest/AppCatalogListing/) in the Core Services API.
        """
        return pulumi.get(self, "app_catalog_listing_id")

    @property
    @pulumi.getter(name="appCatalogListingResourceVersion")
    def app_catalog_listing_resource_version(self) -> str:
        """
        The resource version of the listing resource associated with this listing package.
        """
        return pulumi.get(self, "app_catalog_listing_resource_version")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A description of the variable.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> str:
        """
        The ID of the image corresponding to the package.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="listingId")
    def listing_id(self) -> str:
        """
        The ID of the listing that the specified package belongs to.
        """
        return pulumi.get(self, "listing_id")

    @property
    @pulumi.getter(name="operatingSystems")
    def operating_systems(self) -> Sequence['outputs.GetListingPackageOperatingSystemResult']:
        """
        The operating system used by the listing.
        """
        return pulumi.get(self, "operating_systems")

    @property
    @pulumi.getter(name="packageType")
    def package_type(self) -> str:
        """
        The specified package's type.
        """
        return pulumi.get(self, "package_type")

    @property
    @pulumi.getter(name="packageVersion")
    def package_version(self) -> str:
        return pulumi.get(self, "package_version")

    @property
    @pulumi.getter
    def pricings(self) -> Sequence['outputs.GetListingPackagePricingResult']:
        """
        The model for pricing.
        """
        return pulumi.get(self, "pricings")

    @property
    @pulumi.getter
    def regions(self) -> Sequence['outputs.GetListingPackageRegionResult']:
        """
        The regions where you can deploy the listing package. (Some packages have restrictions that limit their deployment to United States regions only.)
        """
        return pulumi.get(self, "regions")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        The unique identifier for the package resource.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourceLink")
    def resource_link(self) -> str:
        """
        Link to the orchestration resource.
        """
        return pulumi.get(self, "resource_link")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time this listing package was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def variables(self) -> Sequence['outputs.GetListingPackageVariableResult']:
        """
        List of variables for the orchestration resource.
        """
        return pulumi.get(self, "variables")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The package version.
        """
        return pulumi.get(self, "version")


class AwaitableGetListingPackageResult(GetListingPackageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetListingPackageResult(
            app_catalog_listing_id=self.app_catalog_listing_id,
            app_catalog_listing_resource_version=self.app_catalog_listing_resource_version,
            compartment_id=self.compartment_id,
            description=self.description,
            id=self.id,
            image_id=self.image_id,
            listing_id=self.listing_id,
            operating_systems=self.operating_systems,
            package_type=self.package_type,
            package_version=self.package_version,
            pricings=self.pricings,
            regions=self.regions,
            resource_id=self.resource_id,
            resource_link=self.resource_link,
            time_created=self.time_created,
            variables=self.variables,
            version=self.version)


def get_listing_package(compartment_id: Optional[str] = None,
                        listing_id: Optional[str] = None,
                        package_version: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetListingPackageResult:
    """
    This data source provides details about a specific Listing Package resource in Oracle Cloud Infrastructure Marketplace service.

    Get the details of the specified version of a package, including information needed to launch the package.

    If you plan to launch an instance from an image listing, you must first subscribe to the listing. When
    you launch the instance, you also need to provide the image ID of the listing resource version that you want.

    Subscribing to the listing requires you to first get a signature from the terms of use agreement for the
    listing resource version. To get the signature, issue a [GetAppCatalogListingAgreements](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/latest/AppCatalogListingResourceVersionAgreements/GetAppCatalogListingAgreements) API call.
    The [AppCatalogListingResourceVersionAgreements](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/latest/AppCatalogListingResourceVersionAgreements) object, including
    its signature, is returned in the response. With the signature for the terms of use agreement for the desired
    listing resource version, create a subscription by issuing a
    [CreateAppCatalogSubscription](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/latest/AppCatalogSubscription/CreateAppCatalogSubscription) API call.

    To get the image ID to launch an instance, issue a [GetAppCatalogListingResourceVersion](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/latest/AppCatalogListingResourceVersion/GetAppCatalogListingResourceVersion) API call.
    Lastly, to launch the instance, use the image ID of the listing resource version to issue a [LaunchInstance](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/latest/Instance/LaunchInstance) API call.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_listing_package = oci.Marketplace.get_listing_package(listing_id=test_listing["id"],
        package_version=listing_package_package_version,
        compartment_id=compartment_id)
    ```


    :param str compartment_id: The unique identifier for the compartment.
    :param str listing_id: The unique identifier for the listing.
    :param str package_version: The version of the package. Package versions are unique within a listing.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['listingId'] = listing_id
    __args__['packageVersion'] = package_version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Marketplace/getListingPackage:getListingPackage', __args__, opts=opts, typ=GetListingPackageResult).value

    return AwaitableGetListingPackageResult(
        app_catalog_listing_id=pulumi.get(__ret__, 'app_catalog_listing_id'),
        app_catalog_listing_resource_version=pulumi.get(__ret__, 'app_catalog_listing_resource_version'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        image_id=pulumi.get(__ret__, 'image_id'),
        listing_id=pulumi.get(__ret__, 'listing_id'),
        operating_systems=pulumi.get(__ret__, 'operating_systems'),
        package_type=pulumi.get(__ret__, 'package_type'),
        package_version=pulumi.get(__ret__, 'package_version'),
        pricings=pulumi.get(__ret__, 'pricings'),
        regions=pulumi.get(__ret__, 'regions'),
        resource_id=pulumi.get(__ret__, 'resource_id'),
        resource_link=pulumi.get(__ret__, 'resource_link'),
        time_created=pulumi.get(__ret__, 'time_created'),
        variables=pulumi.get(__ret__, 'variables'),
        version=pulumi.get(__ret__, 'version'))


@_utilities.lift_output_func(get_listing_package)
def get_listing_package_output(compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                               listing_id: Optional[pulumi.Input[str]] = None,
                               package_version: Optional[pulumi.Input[str]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetListingPackageResult]:
    """
    This data source provides details about a specific Listing Package resource in Oracle Cloud Infrastructure Marketplace service.

    Get the details of the specified version of a package, including information needed to launch the package.

    If you plan to launch an instance from an image listing, you must first subscribe to the listing. When
    you launch the instance, you also need to provide the image ID of the listing resource version that you want.

    Subscribing to the listing requires you to first get a signature from the terms of use agreement for the
    listing resource version. To get the signature, issue a [GetAppCatalogListingAgreements](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/latest/AppCatalogListingResourceVersionAgreements/GetAppCatalogListingAgreements) API call.
    The [AppCatalogListingResourceVersionAgreements](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/latest/AppCatalogListingResourceVersionAgreements) object, including
    its signature, is returned in the response. With the signature for the terms of use agreement for the desired
    listing resource version, create a subscription by issuing a
    [CreateAppCatalogSubscription](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/latest/AppCatalogSubscription/CreateAppCatalogSubscription) API call.

    To get the image ID to launch an instance, issue a [GetAppCatalogListingResourceVersion](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/latest/AppCatalogListingResourceVersion/GetAppCatalogListingResourceVersion) API call.
    Lastly, to launch the instance, use the image ID of the listing resource version to issue a [LaunchInstance](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/latest/Instance/LaunchInstance) API call.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_listing_package = oci.Marketplace.get_listing_package(listing_id=test_listing["id"],
        package_version=listing_package_package_version,
        compartment_id=compartment_id)
    ```


    :param str compartment_id: The unique identifier for the compartment.
    :param str listing_id: The unique identifier for the listing.
    :param str package_version: The version of the package. Package versions are unique within a listing.
    """
    ...
