"""remove required from entity.permalink

Revision ID: 502b60eaa905
Revises: b3c3938bacdb
Create Date: 2025-02-24 13:33:09.790951

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = "502b60eaa905"
down_revision: Union[str, None] = "b3c3938bacdb"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("entity", schema=None) as batch_op:
        batch_op.alter_column("permalink", existing_type=sa.VARCHAR(), nullable=True)
        batch_op.drop_index("ix_entity_permalink")
        batch_op.create_index(batch_op.f("ix_entity_permalink"), ["permalink"], unique=False)
        batch_op.drop_constraint("uix_entity_permalink", type_="unique")
        batch_op.create_index(
            "uix_entity_permalink",
            ["permalink"],
            unique=True,
            sqlite_where=sa.text("content_type = 'text/markdown' AND permalink IS NOT NULL"),
        )

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("entity", schema=None) as batch_op:
        batch_op.drop_index(
            "uix_entity_permalink",
            sqlite_where=sa.text("content_type = 'text/markdown' AND permalink IS NOT NULL"),
        )
        batch_op.create_unique_constraint("uix_entity_permalink", ["permalink"])
        batch_op.drop_index(batch_op.f("ix_entity_permalink"))
        batch_op.create_index("ix_entity_permalink", ["permalink"], unique=1)
        batch_op.alter_column("permalink", existing_type=sa.VARCHAR(), nullable=False)

    # ### end Alembic commands ###
