#!/usr/bin/python
# -*- coding: utf-8 -*-
import re
def tokenizer(text,level='word',delimiter='all'):
    if level=="sentence":
      if delimiter == "all":
        df = list(map(str.strip, re.split('''।(?=(?:[^'"]|'[^']*'|"[^"]*")*$)|!(?=(?:[^'"]|'[^']*'|"[^"]*")*$)|\?(?=(?:[^'"]|'[^']*'|"[^"]*")*$)''', text)))[:-1]
      elif delimiter == "few":
        df = list(map(str.strip, text.split('।')))[:-1]
      return df
    elif level=="word":
      text = remove_punctuation(text)
      return text.split()
    elif level=="character":
      text = remove_punctuation(text)
      if delimiter == "all":
        text = text.replace(' ', '')
        return list(text)
      elif delimiter == "few":
        return list(text)

def remove_punctuation(text):
    text = text.replace('।', '')
    text = text.replace('‘', '')
    text = text.replace('’', '')
    text = text.replace('?', '')
    text = text.replace(',', '')
    text = text.replace(';', '')
    text = text.replace('!', '')
    text = text.replace('\'', '')
    text = text.replace('-', '')
    text = text.replace('”', '')
    text = text.replace('“', '')
    text = text.replace('/', '')
    text = text.replace('৷', '')
    text = text.replace('(', '')
    text = text.replace(')', '')
    text = text.replace(':', '')
    text = text.replace('.', '')
    text = text.replace('"', '')
    text = text.strip()
    return text


def remove_foreign(text):
    text = "".join(i for i in text if i in ["।"] or 2432 <= ord(i) <= 2559 or ord(i)== 32)
    text = re.sub(' +', ' ', text)
    return text.strip()

def find_numbers(text,alphanumeric=True):
    if(str(alphanumeric).capitalize()=='True'):
      regex = "[০১২৩৪৫৬৭৮৯]+.[০১২৩৪৫৬৭৮৯]+|[০১২৩৪৫৬৭৮৯]+[িাুীঅআইঈউঊঋএঐওঔকখগঘঙচছজঝঞযশহটঠডঢণরষতথদধনলসপফবভমড়ঢ়য়ৎংঃ‍ঁ‍্‍্য‍‍্রর্ক]+|[০১২৩৪৫৬৭৮৯]+"
    elif(str(alphanumeric).capitalize()=='False'):
      regex = "([০-৯]+\.[০-৯]+|[০-৯]+)(?=[,।!?‘’;\s])"
    num = re.findall(regex, text)
    return num

def remove_numbers(text,alphanumeric=True):
    if(str(alphanumeric).capitalize()=='True'):
      regex = "[০১২৩৪৫৬৭৮৯]+.[০১২৩৪৫৬৭৮৯]+|[০১২৩৪৫৬৭৮৯]+[িাুীঅআইঈউঊঋএঐওঔকখগঘঙচছজঝঞযশহটঠডঢণরষতথদধনলসপফবভমড়ঢ়য়ৎংঃ‍ঁ‍্‍্য‍‍্রর্ক]+|[০১২৩৪৫৬৭৮৯]+"
    elif(str(alphanumeric).capitalize()=='False'):
      regex = "([০-৯]+\.[০-৯]+|[০-৯]+)(?=[,।!?‘’;\s])"
    num = re.findall(regex, text)
    for x in num:
      text = text.replace(x, '')
    result = ' '.join(w for w in text.split())
    result = re.sub(r' +([,।\?])', r'\1', result)
    result = re.sub(r' +', r' ', result)
    return result


word_list = ['এখানে', 'বললেন', 'নিজের', 'তথা', 'শুরু', 'সে', 'আদ্যভাগে', 'কেন', 'ওঁরা', 'নাকি', 'ইত্যাদি', 'দেয়', 'থাকবেন', 'পারি', 'চায়', 'করিতে', 'সর্বাধিক', 'করা', 'জন্যে', 'সাধারণ', 'এখনও', 'বিষয়টি', 'অবধি', 'এমন', 'কোথায়', 'দেওয়ার', 'করাই', 'এক', 'সামনে', 'স্বয়ং', 'ব্যাপারে', 'বেশি', 'মধ্যভাগে', 'জানিয়ে', 'হয়তো', 'উভয়', 'পরেও', 'কাছ', 'বন্ধ', 'চায়', 'বক্তব্য', 'হয়েছে', 'এতটাই', 'আর', 'হোক', 'যাতে', 'মাঝে', 'যে', 'কোন', 'তাঁরা', 'যদিও', 'যেমন', 'দিয়েছে', 'পাওয়া', 'যাঁর', 'কবে', 'ওঁদের', 'সেখানে', 'সঙ্গে', 'বদলে', 'নিতে', 'অনেকেই', 'সেই', 'অথচ', 'জানানো', 'করবেন', 'দেওয়া', 'হলো', 'আমাকে', 'গোটা', 'কিংবা', 'গিয়েছে', 'বা', 'তাহলে', 'রেখে', 'বলল', 'করেছে', 'বলতে', 'কোনো', 'তারা', 'গিয়ে', 'করি', 'বলেন', 'দিয়েছেন', 'উত্তর', 'যাদের', 'করছে', 'জনকে', 'হয়তো', 'হওয়ায়', 'চার', 'হন', 'করলে', 'হওয়ার', 'দুই', 'গিয়েছে', 'নয়', 'যাওয়া', 'যত', 'আপ', 'সবার', 'এমনি', 'জন্য', 'দেখা', 'ধরা', 'যায়', 'করতে', 'তারপর', 'থাকায়', 'ওকে', 'যেখানে', 'ছিল', 'সেটাও', 'যথেষ্ট', 'বলেছেন', 'এসে', 'ঠিক', 'প্রতি', 'জানিয়ে', 'হয়েছিল', 'অন্তত', 'তাদের', 'রকম', 'নাগাদ', 'হাজার', 'তাদেরকে', 'হওয়ার', 'করায়', 'অন্যান্য', 'করায়', 'ঐ', 'তিনি', 'নাই', 'তুলে', 'এঁদের', 'আরও', 'হইয়া', 'হওয়া', 'এঁরা', 'কারও', 'কি', 'করার', 'নিয়ে', 'থাকায়', 'সঙ্গেও', 'পেয়ে', 'জন্য', 'কিভাবে', 'যার', 'করিয়ে', 'তারা','তাহারা', 'কেখা', 'দেন', 'ছাড়া', 'করেছিলেন', 'অবশ্য', 'হলেও', 'চেয়ে', 'প্রতিটি', 'জানতে', 'নেওয়ার', 'এগুলো', 'নিজেদের', 'রয়েছে', 'প্রযন্ত', 'জন', 'চালু', 'থাকার', 'পেয়ে', 'সেখান', 'নিজেই', 'তো', 'বাদে', 'ছাড়াও', 'হয়েছেন', 'কত', 'করেছেন', 'ই', 'কয়েকটি', 'প্রায়', 'করেই', 'মধ্যেই', 'ও', 'এদের', 'অন্য', 'কমনে', 'নেই', 'যাওয়ার', 'দেখে', 'যা', 'ইহা', 'পারেন', 'যতক্ষণ', 'চান', 'হয়েছে', 'কেউ', 'এটাই', 'একটা', 'সব', 'তেমন', 'নেওয়া', 'নিজেকে', 'ফলে', 'এরা', 'একই', 'হলে', 'তাঁকে', 'দিয়েছেন', 'তখন', 'যেটা', 'কয়েক', 'স্বয়ং', 'তাহার', 'দেয়', 'তবে', 'আমাদের', 'এই', 'কোটি', 'ক্ষেত্রে', 'অধীন', 'গেলে', 'হয়েই', 'কী', 'হয়নি', 'যখন', 'দুটি', 'খুব','গুলি', 'যাকে', 'দেখতে', 'যাক', 'তোমার', 'এটি', 'বেশ', 'হইতে', 'করতে' 'পারেন', 'তাহাতে', 'সাথে', 'যাওয়া', 'হয়', 'কখনও', 'থাকা', 'উনি', 'যিনি', 'আমি', 'আগামী', 'এত', 'তাতে', 'গিয়ে', 'থাকেন', 'কয়েক', 'যাবে', 'চেষ্টা', 'হওয়ায়', 'মনে', 'দিকে', 'মাত্র', 'অনুযায়ী', 'এটা', 'গেল', 'জানা', 'কাউকে', 'ইচ্ছা', 'হচ্ছে', 'হয়নি', 'জানিয়েছে', 'আই', 'অনেক', 'পারে', 'মোট', 'পাচ', 'কয়েকটি', 'এবং', 'নিজে', 'সম্পর্কে', 'পর', 'হইয়া', 'অনুযায়ী', 'তিনি', 'মোটেই', 'হবে', 'তত', 'হতেই', 'সহিত', 'দেওয়ার', 'নীচের', 'কাছে', 'এল', 'করিয়া', 'সমস্ত', 'সেটি', 'টি', 'এ', 'ধরে', 'দিলেন', 'তাঁর', 'অর্থাৎ', 'আছে', 'অথবা', 'হতে', 'ওরা', 'হবেন', 'সময়', 'জনের', 'স্পষ্ট', 'বার', 'একে', 'থাকে', 'সেটাই', 'হলেই', 'হত', 'কিছু', 'লক্ষ', 'বহু', 'মধ্যে', 'তুমি', 'নানা', 'নেওয়া', 'মধ্যেও', 'কাজে', 'হয়েছেন', 'একবার', 'খুব', 'পক্ষে', 'থেকেও', 'জানিয়েছে', 'নয়', 'বরং', 'ধামার', 'এমনকী', 'তার', 'ওদের', 'এতে', 'ফের', 'মাধ্যমে', 'দুটো', 'বিভিন্ন', 'দিয়েছে', 'আজ', 'এখন', 'পরে', 'তাকে', 'রয়েছে', 'ওখানে', 'প্রায়', 'আপনার', 'নতুন', 'যাওয়ার', 'খুবই', 'কিন্তু', 'সহ', 'উপর', 'যেন', 'করিয়া', 'হিসাবে', 'বিরুদ্ধে', 'আমার', 'বলা', 'আগে', 'হল', 'এর', 'এস', 'যাচ্ছে', 'তুলনায়', 'কোনও', 'কে', 'চলে', 'আবার', 'বিনা', 'তাই', 'ফিরে', 'নেওয়ার', 'জানায়', 'উপরে', 'গুলি', 'করছেন', 'অনেকে', 'আপনি', 'যারা', 'গেছে', 'এখানেই', 'ওই', 'করিয়ে', 'কার', 'আগেই', 'প্রাথমিক', 'অতএব', 'সেটা', 'যেতে', 'হইবে', 'বসে', 'ছাড়াও', 'পর্যন্ত', 'উচিত', 'ওর', 'থেকে', 'দিন', 'একটি', 'থেকেই', 'তুলনা', 'যান', 'এবার', 'সম্প্রতি', 'করলেন', 'ওঁর', 'কখন', 'ভাবে', 'কেউই', 'পরেই', 'জানায়', 'জ্নজন', 'দ্বারা', 'যাঁরা', 'অধীনে', 'বিভিন্ন','বিষয়টি', 'হয়ে', 'দিয়ে', 'দেওয়া', 'তাহা', 'তবু', 'মতো', 'ছাড়া', 'ঐ', 'প্রভৃতি', 'কিছুই', 'রাখা', 'বিশেষ', 'দিয়ে', 'শুধু', 'কাজ', 'হয়ে', 'দিতে', 'কারণ', 'প্রথম', 'তাঁদের', 'তাও', 'ছিলেন', 'চেয়ে', 'হয়েই', 'বলে', 'হওয়া', 'নিয়ে', 'পাওয়া', 'হয়', 'সকল', 'হয়েছিল', 'ভাবেই', 'না', 'যতটা', 'করেন', ' সঙ্গে', 'মতোই', 'ব্যবহার', 'যদি', 'সুতরাং', 'করে', 'অন', 'থাকবে', 'আমরা', 'করবে']
def remove_stopwords(text):
    result = ''.join(w for w in re.split(r'([ ,।\?])', text) if w not in word_list)
    result = re.sub(r' +([,।\?])', r'\1', result)
    result = re.sub(r' +', r' ', result)
    return result

def ban_to_eng_num(text):
    text = text.replace('০', '0')
    text = text.replace('১', '1')
    text = text.replace('২', '2')
    text = text.replace('৩', '3')
    text = text.replace('৪', '4')
    text = text.replace('৫', '5')
    text = text.replace('৬', '6')
    text = text.replace('৭', '7')
    text = text.replace('৮', '8')
    text = text.replace('৯', '9')
    text = text.replace('.', '.')
    text = text.strip()

    return text


def eng_to_ban_num(text):
    text = text.replace('0', '০')
    text = text.replace('1', '১')
    text = text.replace('2', '২')
    text = text.replace('3', '৩')
    text = text.replace('4', '৪')
    text = text.replace('5', '৫')
    text = text.replace('6', '৬')
    text = text.replace('7', '৭')
    text = text.replace('8', '৮')
    text = text.replace('9', '৯')
    text = text.replace('.', '.')
    text = text.strip()

    return text

words = [
        '',
        'এক',
        'দুই',
        'তিন',
        'চার',
        'পাঁচ',
        'ছয়',
        'সাত',
        'আট',
        'নয়',
        'দশ',
        'এগারো',
        'বারো',
        'তেরো',
        'চৌদ্দ',
        'পনেরো',
        'ষোল',
        'সতেরো',
        'আঠারো',
        'উনিশ',
        'বিশ',
        'একুশ',
        'বাইশ',
        'তেইশ',
        'চব্বিশ',
        'পঁচিশ',
        'ছাব্বিশ',
        'সাতাশ',
        'আঠাশ',
        'ঊনত্রিশ',
        'ত্রিশ',
        'একত্রিশ',
        'বত্রিশ',
        'তেত্রিশ',
        'চৌত্রিশ',
        'পঁয়ত্রিশ',
        'ছত্রিশ',
        'সাঁইত্রিশ',
        'আটত্রিশ',
        'ঊনচল্লিশ',
        'চল্লিশ',
        'একচল্লিশ',
        'বিয়াল্লিশ',
        'তেতাল্লিশ',
        'চুয়াল্লিশ',
        'পঁয়তাল্লিশ',
        'ছেচল্লিশ',
        'সাতচল্লিশ',
        'আটচল্লিশ',
        'ঊনপঞ্চাশ',
        'পঞ্চাশ',
        'একান্ন',
        'বাহান্ন',
        'তিপ্পান্ন',
        'চুয়ান্ন',
        'পঞ্চান্ন',
        'ছাপ্পান্ন',
        'সাতান্ন',
        'আটান্ন',
        'ঊনষাট',
        'ষাট',
        'একষট্টি',
        'বাষট্টি',
        'তেষট্টি',
        'চৌষট্টি',
        'পঁয়ষট্টি',
        'ছেষট্টি',
        'সাতষট্টি',
        'আটষট্টি',
        'ঊনসত্তর',
        'সত্তর',
        'একাত্তর',
        'বাহাত্তর',
        'তিয়াত্তর',
        'চুয়াত্তর',
        'পঁচাত্তর',
        'ছিয়াত্তর',
        'সাতাত্তর',
        'আটাত্তর',
        'ঊনআশি',
        'আশি',
        'একাশি',
        'বিরাশি',
        'তিরাশি',
        'চুরাশি',
        'পঁচাশি',
        'ছিয়াশি',
        'সাতাশি',
        'আটাশি',
        'ঊননব্বই',
        'নব্বই',
        'একানব্বই',
        'বিরানব্বই',
        'তিরানব্বই',
        'চুরানব্বই',
        'পঁচানব্বই',
        'ছিয়ানব্বই',
        'সাতানব্বই',
        'আটানব্বই',
        'নিরানব্বই'
    ]
bnnum = [
        'শূন্য',
        'এক',
        'দুই',
        'তিন',
        'চার',
        'পাঁচ',
        'ছয়',
        'সাত',
        'আট',
        'নয়'
    ]

numbers = [
        '০',
        '১',
        '২',
        '৩',
        '৪',
        '৫',
        '৬',
        '৭',
        '৮',
        '৯'
    ]
class InvalidNumber(Exception):
    @staticmethod
    def message():
        return "Invalid number"

class InvalidRange(Exception):
    @staticmethod
    def message():
        return "Invalid range"

def is_valid(number):
    if not str(number).isnumeric():
        raise InvalidNumber.message()

    if int(number) > 999999999999999 or 'E' in str(number):
        raise InvalidRange.message()

def bn_num(number):
    is_valid(number)
    return number.translate(str.maketrans(''.join(numbers), ''.join(bn_num)))

def bn_word(number):
    is_valid(number)
    if number == 0:
        return 'শূন্য'

    if isinstance(number, float):
        return number_to_word(number)

    return to_word(number)

def bn_comma_lakh(number):
    is_valid(number)
    n = re.sub(r'(\d+?)(?=(\d\d)+(\d)(?!\d))(\.\d+)?', r'\1,', str(number))
    return n.translate(str.maketrans(''.join(numbers), ''.join(bn_num)))

def to_word(num):
    text = ''
    crore = int(num / 10000000)
    if crore != 0:
        if crore > 99:
            text += bn_word(crore) + ' কোটি '
        else:
            text += words[crore] + ' কোটি '

    crore_div = num % 10000000

    lakh = int(crore_div / 100000)
    if lakh > 0:
        text += words[lakh] + ' লক্ষ '

    lakh_div = crore_div % 100000

    thousand = int(lakh_div / 1000)
    if thousand > 0:
        text += words[thousand] + ' হাজার '

    thousand_div = lakh_div % 1000

    hundred = int(thousand_div / 100)
    if hundred > 0:
        text += words[hundred] + ' শত '

    hundred_div = thousand_div % 100
    if hundred_div > 0:
        text += words[hundred_div]

    return text

def to_decimal_word(num):
    text = ''
    decimal_parts = list(num)
    for decimal_part in decimal_parts:
        text += bnnum[int(decimal_part)] + ' '

    return text

def number_to_word(number):
    decimal_part = str(number).split('.')
    text = to_word(int(decimal_part[0]))
    if len(decimal_part) > 1:
        text += ' দশমিক ' + to_decimal_word(decimal_part[1])
    text = text.strip()
    return text