# coding: utf-8

"""
 Copyright 2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 A copy of the License is located at

     http://www.apache.org/licenses/LICENSE-2.0

 or in the "license" file accompanying this file. This file is distributed
 on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 express or implied. See the License for the specific language governing
 permissions and limitations under the License.
"""

"""
    ProductAdvertisingAPI

    https://webservices.amazon.com/paapi5/documentation/index.html  # noqa: E501
"""


import pprint
import re  # noqa: F401

import six


class OfferMerchantInfo(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'default_shipping_country': 'str',
        'id': 'str',
        'name': 'str'
    }

    attribute_map = {
        'default_shipping_country': 'DefaultShippingCountry',
        'id': 'Id',
        'name': 'Name'
    }

    def __init__(self, default_shipping_country=None, id=None, name=None):  # noqa: E501
        """OfferMerchantInfo - a model defined in Swagger"""  # noqa: E501

        self._default_shipping_country = None
        self._id = None
        self._name = None
        self.discriminator = None

        if default_shipping_country is not None:
            self.default_shipping_country = default_shipping_country
        if id is not None:
            self.id = id
        if name is not None:
            self.name = name

    @property
    def default_shipping_country(self):
        """Gets the default_shipping_country of this OfferMerchantInfo.  # noqa: E501


        :return: The default_shipping_country of this OfferMerchantInfo.  # noqa: E501
        :rtype: str
        """
        return self._default_shipping_country

    @default_shipping_country.setter
    def default_shipping_country(self, default_shipping_country):
        """Sets the default_shipping_country of this OfferMerchantInfo.


        :param default_shipping_country: The default_shipping_country of this OfferMerchantInfo.  # noqa: E501
        :type: str
        """

        self._default_shipping_country = default_shipping_country

    @property
    def id(self):
        """Gets the id of this OfferMerchantInfo.  # noqa: E501


        :return: The id of this OfferMerchantInfo.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this OfferMerchantInfo.


        :param id: The id of this OfferMerchantInfo.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def name(self):
        """Gets the name of this OfferMerchantInfo.  # noqa: E501


        :return: The name of this OfferMerchantInfo.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this OfferMerchantInfo.


        :param name: The name of this OfferMerchantInfo.  # noqa: E501
        :type: str
        """

        self._name = name

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(OfferMerchantInfo, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OfferMerchantInfo):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
