import polars as pl
import polars_talib as plta
import warnings
warnings.filterwarnings("ignore", category=DeprecationWarning)

def func_ts_date(df_group: pl.DataFrame) -> pl.DataFrame:
    # Ensure the data is sorted by date
    df_group = df_group.sort("date")
    
    # Calculate technical indicators
    df_group = df_group.with_columns([
        plta.bbands(timeperiod=20, nbdevup=2, nbdevdn=2).alias('BBANDS'),
        plta.ema(timeperiod=20).alias('EMA_20'),
        plta.macd(fastperiod=12, slowperiod=26, signalperiod=9).alias('MACD'),
        plta.adx(timeperiod=14).alias('ADX_14'),
        plta.cci(timeperiod=14).alias('CCI_14'),
        plta.mfi(timeperiod=14).alias('MFI_14'),
        plta.mom(timeperiod=10).alias('MOM_10'),
        plta.stoch(fastk_period=5, slowk_period=3, slowd_period=3).alias('STOCH'),
        plta.willr(timeperiod=14).alias('WILLR_14'),
        plta.atr(timeperiod=14).alias('ATR_14'),
        plta.obv().alias('OBV'),
        plta.ad().alias('AD'),
        plta.aroon(timeperiod=14).alias('AROON_14'),
        plta.bop().alias('BOP'),
        plta.cmo(timeperiod=14).alias('CMO_14'),
        plta.dx(timeperiod=14).alias('DX_14'),
        plta.kama(timeperiod=30).alias('KAMA_30'),
        plta.ppo().alias('PPO'),
        plta.rocr(timeperiod=10).alias('ROCR_10'),
        plta.trix(timeperiod=30).alias('TRIX_30'),
        plta.ultosc().alias('ULTOSC'),
        plta.natr(timeperiod=14).alias('NATR_14'),
        plta.ht_dcperiod().alias('HT_DCPERIOD'),
        plta.ht_dcphase().alias('HT_DCPHASE'),
        plta.ht_phasor().alias('HT_PHASOR'),
        plta.ht_sine().alias('HT_SINE'),
        plta.ht_trendmode().alias('HT_TRENDMODE'),
        plta.avgprice().alias('AVGPRICE'),
        plta.medprice().alias('MEDPRICE'),
        plta.typprice().alias('TYPPRICE'),
        plta.wclprice().alias('WCLPRICE'),
        plta.beta(timeperiod=5).alias('BETA_5'),
        plta.correl(timeperiod=30).alias('CORREL_30'),
        plta.linearreg(timeperiod=14).alias('LINEARREG_14'),
        plta.linearreg_angle(timeperiod=14).alias('LINEARREG_ANGLE_14'),
        plta.linearreg_intercept(timeperiod=14).alias('LINEARREG_INTERCEPT_14'),
        plta.linearreg_slope(timeperiod=14).alias('LINEARREG_SLOPE_14'),
        plta.tsf(timeperiod=14).alias('TSF_14'),
        plta.var(timeperiod=5).alias('VAR_5'),
        plta.sar(acceleration=0.02, maximum=0.2).alias('SAR'),
        plta.adxr(timeperiod=14).alias('ADXR_14'),
        plta.apo(fastperiod=12, slowperiod=26, matype=0).alias('APO'),
        plta.aroonosc(timeperiod=14).alias('AROONOSC_14'),
        plta.dema(timeperiod=30).alias('DEMA_30'),
        plta.ht_trendline().alias('HT_TRENDLINE'),
        plta.ma(timeperiod=30, matype=0).alias('MA_30'),
        plta.mama().alias('MAMA'),
        plta.mavp(periods=pl.col("volume"), minperiod=2, maxperiod=30, matype=0).alias('MAVP'),
        plta.midpoint(timeperiod=14).alias('MIDPOINT_14'),
        plta.midprice(timeperiod=14).alias('MIDPRICE_14'),
        plta.sarext().alias('SAREXT'),
        plta.sma(timeperiod=30).alias('SMA_30'),
        plta.t3(timeperiod=5, vfactor=0.7).alias('T3_5'),
        plta.tema(timeperiod=30).alias('TEMA_30'),
        plta.trima(timeperiod=30).alias('TRIMA_30'),
        plta.wma(timeperiod=30).alias('WMA_30'),
        plta.cdl2crows().alias('CDL2CROWS'),
        plta.cdl3blackcrows().alias('CDL3BLACKCROWS'),
        plta.cdl3inside().alias('CDL3INSIDE'),
        plta.cdl3linestrike().alias('CDL3LINESTRIKE'),
        plta.cdl3outside().alias('CDL3OUTSIDE'),
        plta.cdl3starsinsouth().alias('CDL3STARSINSOUTH'),
        plta.cdl3whitesoldiers().alias('CDL3WHITESOLDIERS'),
        plta.cdlabandonedbaby().alias('CDLABANDONEDBABY'),
        plta.cdladvanceblock().alias('CDLADVANCEBLOCK'),
        plta.cdlbelthold().alias('CDLBELTHOLD'),
        plta.cdlbreakaway().alias('CDLBREAKAWAY'),
        plta.cdlclosingmarubozu().alias('CDLCLOSINGMARUBOZU'),
        plta.cdlconcealbabyswall().alias('CDLCONCEALBABYSWALL'),
        plta.cdlcounterattack().alias('CDLCOUNTERATTACK'),
        plta.cdldarkcloudcover().alias('CDLDARKCLOUDCOVER'),
        plta.cdldoji().alias('CDLDOJI'),
        plta.cdldojistar().alias('CDLDOJISTAR'),
        plta.cdldragonflydoji().alias('CDLDRAGONFLYDOJI'),
        plta.cdlengulfing().alias('CDLENGULFING'),
        plta.cdleveningdojistar().alias('CDLEVENINGDOJISTAR'),
        plta.cdleveningstar().alias('CDLEVENINGSTAR'),
        plta.cdlgapsidesidewhite().alias('CDLGAPSIDESIDEWHITE'),
        plta.cdlgravestonedoji().alias('CDLGRAVESTONEDOJI'),
        plta.cdlhammer().alias('CDLHAMMER'),
        plta.cdlhangingman().alias('CDLHANGINGMAN'),
        plta.cdlharami().alias('CDLHARAMI'),
        plta.cdlharamicross().alias('CDLHARAMICROSS'),
        plta.cdlhighwave().alias('CDLHIGHWAVE'),
        plta.cdlhikkake().alias('CDLHIKKAKE'),
        plta.cdlhikkakemod().alias('CDLHIKKAKEMOD'),
        plta.cdlhomingpigeon().alias('CDLHOMINGPIGEON'),
        plta.cdlidentical3crows().alias('CDLIDENTICAL3CROWS'),
        plta.cdlinneck().alias('CDLINNECK'),
        plta.cdlinvertedhammer().alias('CDLINVERTEDHAMMER'),
        plta.cdlkicking().alias('CDLKICKING'),
        plta.cdlkickingbylength().alias('CDLKICKINGBYLENGTH'),
        plta.cdlladderbottom().alias('CDLLADDERBOTTOM'),
        plta.cdllongleggeddoji().alias('CDLLONGLEGGEDDOJI'),
        plta.cdllongline().alias('CDLLONGLINE'),
        plta.cdlmarubozu().alias('CDLMARUBOZU'),
        plta.cdlmatchinglow().alias('CDLMATCHINGLOW'),
        plta.cdlmathold().alias('CDLMATHOLD'),
        plta.cdlmorningdojistar().alias('CDLMORNINGDOJISTAR'),
        plta.cdlmorningstar().alias('CDLMORNINGSTAR'),
        plta.cdlonneck().alias('CDLONNECK'),
        plta.cdlpiercing().alias('CDLPIERCING'),
        plta.cdlrickshawman().alias('CDLRICKSHAWMAN'),
        plta.cdlrisefall3methods().alias('CDLRISEFALL3METHODS'),
        plta.cdlseparatinglines().alias('CDLSEPARATINGLINES'),
        plta.cdlshootingstar().alias('CDLSHOOTINGSTAR'),
        plta.cdlshortline().alias('CDLSHORTLINE'),
        plta.cdlspinningtop().alias('CDLSPINNINGTOP'),
        plta.cdlstalledpattern().alias('CDLSTALLEDPATTERN'),
        plta.cdlsticksandwich().alias('CDLSTICKSANDWICH'),
        plta.cdltakuri().alias('CDLTAKURI'),
        plta.cdltasukigap().alias('CDLTASUKIGAP'),
        plta.cdlthrusting().alias('CDLTHRUSTING'),
        plta.cdltristar().alias('CDLTRISTAR'),
        plta.cdlunique3river().alias('CDLUNIQUE3RIVER'),
        plta.cdlupsidegap2crows().alias('CDLUPSIDEGAP2CROWS'),
        plta.cdlxsidegap3methods().alias('CDLXSIDEGAP3METHODS'),
        plta.trange().alias('TRANGE'),
        plta.adosc(fastperiod=3, slowperiod=10).alias('ADOSC'),
        plta.roc(timeperiod=10).alias('ROC_10'),
        plta.rocp(timeperiod=10).alias('ROCP_10'),
        plta.rocr100(timeperiod=10).alias('ROCR100_10'),
        plta.rsi(timeperiod=14).alias('RSI_14'),
        plta.stochf(fastk_period=5, fastd_period=3, fastd_matype=0).alias('STOCHF'),
        plta.stochrsi(timeperiod=14, fastk_period=5, fastd_period=3, fastd_matype=0).alias('STOCHRSI'),
        plta.add(pl.col("high")).alias('ADD'),
        plta.div(pl.col("high")).alias('DIV'),
        plta.max(timeperiod=30).alias('MAX_30'),
        plta.maxindex(timeperiod=30).alias('MAXINDEX_30'),
        plta.min(timeperiod=30).alias('MIN_30'),
        plta.minindex(timeperiod=30).alias('MININDEX_30'),
        plta.minmax(timeperiod=30).alias('MINMAX_30'),
        plta.minmaxindex(timeperiod=30).alias('MINMAXINDEX_30'),
        plta.mult(pl.col("high")).alias('MULT'),
        plta.sub(pl.col("high")).alias('SUB'),
        plta.sum(timeperiod=30).alias('SUM_30'),
        plta.acos().alias('ACOS'),
        plta.asin().alias('ASIN'),
        plta.atan().alias('ATAN'),
        plta.ceil().alias('CEIL'),
        plta.cos().alias('COS'),
        plta.cosh().alias('COSH'),
        plta.exp().alias('EXP'),
        plta.floor().alias('FLOOR'),
        plta.ln().alias('LN'),
        plta.log10().alias('LOG10'),
        plta.sin().alias('SIN'),
        plta.sinh().alias('SINH'),
        plta.sqrt().alias('SQRT'),
        plta.tan().alias('TAN'),
        plta.tanh().alias('TANH'),
        plta.stddev(timeperiod=5).alias('STDDEV_5'),
    ])
    
    # Handle multi-value returns
    df_group = df_group.with_columns([
        pl.col('BBANDS').struct.field('upperband').alias('BBANDS_upper'),
        pl.col('BBANDS').struct.field('middleband').alias('BBANDS_middle'),
        pl.col('BBANDS').struct.field('lowerband').alias('BBANDS_lower'),
        pl.col('MACD').struct.field('macd').alias('MACD_macd'),
        pl.col('MACD').struct.field('macdsignal').alias('MACD_signal'),
        pl.col('MACD').struct.field('macdhist').alias('MACD_hist'),
        pl.col('STOCH').struct.field('slowk').alias('STOCH_slowk'),
        pl.col('STOCH').struct.field('slowd').alias('STOCH_slowd'),
        pl.col('AROON_14').struct.field('aroondown').alias('AROON_down'),
        pl.col('AROON_14').struct.field('aroonup').alias('AROON_up'),
        pl.col('HT_PHASOR').struct.field('inphase').alias('HT_PHASOR_inphase'),
        pl.col('HT_PHASOR').struct.field('quadrature').alias('HT_PHASOR_quadrature'),
        pl.col('HT_SINE').struct.field('sine').alias('HT_SINE_sine'),
        pl.col('HT_SINE').struct.field('leadsine').alias('HT_SINE_leadsine'),
        pl.col('MAMA').struct.field('mama').alias('MAMA_mama'),
        pl.col('MAMA').struct.field('fama').alias('MAMA_fama'),
        pl.col('STOCHF').struct.field('fastk').alias('STOCHF_fastk'),
        pl.col('STOCHF').struct.field('fastd').alias('STOCHF_fastd'),
        pl.col('STOCHRSI').struct.field('fastk').alias('STOCHRSI_fastk'),
        pl.col('STOCHRSI').struct.field('fastd').alias('STOCHRSI_fastd'),
        pl.col('MINMAX_30').struct.field('min').alias('MINMAX_30_min'),
        pl.col('MINMAX_30').struct.field('max').alias('MINMAX_30_max'),
        pl.col('MINMAXINDEX_30').struct.field('minidx').alias('MINMAXINDEX_30_minidx'),
        pl.col('MINMAXINDEX_30').struct.field('maxidx').alias('MINMAXINDEX_30_maxidx'),
    ])
    
    
    # Drop the original struct columns
    df_group = df_group.drop(['BBANDS', 'MACD', 'STOCH', 'AROON_14', 'HT_PHASOR', 'HT_SINE','MAMA','STOCHF','MINMAX_30','MINMAXINDEX_30'])
    
    return df_group


def techn_indicators(df_price):
    # Assuming df_polars is your initial DataFrame
    df_polars = pl.from_pandas(df_price.reset_index())
    df_polars = df_polars.group_by("ticker").map_groups(func_ts_date).to_pandas().set_index(["ticker","date"]).sort_index()
    
    # List of columns to remove
    columns_to_remove = [
        'OBV', 'AD', 'ADOSC', 'VAR_5', 'TRANGE',
        'STOCHRSI',
        'DIV', 'LN', 'LOG10',
        'COS',
        'EMA_20', 'MOM_10', 'AVGPRICE', 'MEDPRICE', 'TYPPRICE', 'WCLPRICE',
        'BETA_5', 'CORREL_30', 'LINEARREG_14', 'TSF_14', 'SAR', 'MAVP', 'SAREXT'
    ]
    
    # Remove problematic columns
    df_polars = df_polars.drop(columns=[col for col in columns_to_remove if col in df_polars.columns])
    
    return df_polars