class PropId:
    """Contains constans for most properties available in cameras."""

    ACQUISITION_BURST_FRAME_COUNT = "AcquisitionBurstFrameCount"
    """Number of frames to acquire for each trigger."""
    ACQUISITION_BURST_INTERVAL = "AcquisitionBurstInterval"
    """Minimum interval between frames in an acquisition burst."""
    ACQUISITION_FRAME_RATE = "AcquisitionFrameRate"
    """Controls the acquisition rate at which the frames are captured."""
    ACQUISITION_MODE = "AcquisitionMode"
    """Sets the acquisition mode of the device. It defines mainly the number of frames to capture during an acquisition and the way the acquisition stops."""
    ACQUISITION_START = "AcquisitionStart"
    """Starts the Acquisition of the device. The number of frames captured is specified by AcquisitionMode."""
    ACQUISITION_STOP = "AcquisitionStop"
    """Stops the Acquisition of the device at the end of the current Frame. It is mainly used when AcquisitionMode is Continuous but can be used in any acquisition mode."""
    ACTION_DEVICE_KEY = "ActionDeviceKey"
    """Provides the device key that allows the device to check the validity of action commands. The device internal assertion of an action signal is only authorized if the ActionDeviceKey and the action device key value in the protocol message are equal."""
    ACTION_GROUP_KEY = "ActionGroupKey"
    """Provides the key that the device will use to validate the action on reception of the action protocol message."""
    ACTION_GROUP_MASK = "ActionGroupMask"
    """Provides the mask that the device will use to validate the action on reception of the action protocol message."""
    ACTION_QUEUE_SIZE = "ActionQueueSize"
    """Indicates the size of the scheduled action commands queue. This number represents the maximum number of scheduled action commands that can be pending at a given point in time."""
    ACTION_SCHEDULER_CANCEL = "ActionSchedulerCancel"
    """Cancels all scheduled actions."""
    ACTION_SCHEDULER_COMMIT = "ActionSchedulerCommit"
    """Schedules the action to be executed time specified by ActionSchedulerTime, with optional repetition in intervals of ActionSchedulerInterval."""
    ACTION_SCHEDULER_INTERVAL = "ActionSchedulerInterval"
    """Action repetition interval. A value of 0 schedules the action to be executed only once."""
    ACTION_SCHEDULER_STATUS = "ActionSchedulerStatus"
    """Indicates whether there are actions scheduled."""
    ACTION_SCHEDULER_TIME = "ActionSchedulerTime"
    """Camera time for when the action is to be scheduled."""
    ACTION_SELECTOR = "ActionSelector"
    """Selects to which Action Signal further Action settings apply."""
    AUTO_FOCUS_ROI_ENABLE = "AutoFocusROIEnable"
    """Enable the region of interest for auto focus."""
    AUTO_FOCUS_ROI_HEIGHT = "AutoFocusROIHeight"
    """Vertical size of the auto focus region of interest."""
    AUTO_FOCUS_ROI_LEFT = "AutoFocusROILeft"
    """Horizontal offset of the auto focus region of interest."""
    AUTO_FOCUS_ROI_TOP = "AutoFocusROITop"
    """Vertical offset of the auto focus region of interest."""
    AUTO_FOCUS_ROI_WIDTH = "AutoFocusROIWidth"
    """Horizontal size of the auto focus region of interest."""
    AUTO_FUNCTIONS_ROI_ENABLE = "AutoFunctionsROIEnable"
    """Enable the region of interest for auto functions."""
    AUTO_FUNCTIONS_ROI_HEIGHT = "AutoFunctionsROIHeight"
    """Vertical size of the auto functions region of interest."""
    AUTO_FUNCTIONS_ROI_LEFT = "AutoFunctionsROILeft"
    """Horizontal offset of the auto functions region of interest."""
    AUTO_FUNCTIONS_ROI_PRESET = "AutoFunctionsROIPreset"
    """Select a predefined region of interest for auto functions."""
    AUTO_FUNCTIONS_ROI_TOP = "AutoFunctionsROITop"
    """Vertical offset of the auto functions region of interest."""
    AUTO_FUNCTIONS_ROI_WIDTH = "AutoFunctionsROIWidth"
    """Horizontal size of the auto functions region of interest."""
    BALANCE_RATIO = "BalanceRatio"
    """Controls ratio of the selected color component to a reference color component. It is used for white balancing."""
    BALANCE_RATIO_SELECTOR = "BalanceRatioSelector"
    """This enumeration selects a balance ratio control to configuration. Once a balance ratio control has been selected, all changes to the balance ratio settings will be applied to the selected control."""
    BALANCE_WHITE_AUTO = "BalanceWhiteAuto"
    """Controls the mode for automatic white balancing between the color channels. The white balancing ratios are automatically adjusted."""
    BALANCE_WHITE_AUTO_PRESET = "BalanceWhiteAutoPreset"
    """Selects a specific preset for automatic white balance."""
    BALANCE_WHITE_MODE = "BalanceWhiteMode"
    """Configures the way auto white balance works."""
    BALANCE_WHITE_TEMPERATURE = "BalanceWhiteTemperature"
    """Adjusts the white balance controls to match the ambient light temperature"""
    BALANCE_WHITE_TEMPERATURE_PRESET = "BalanceWhiteTemperaturePreset"
    """Selects a specific white balance preset."""
    BINNING_HORIZONTAL = "BinningHorizontal"
    """Number of horizontal photo-sensitive cells to combine together. This increases the intensity (or signal to noise ratio) of the pixels and reduces the horizontal resolution (width) of the image. A value of 1 indicates that no horizontal binning is performed by the camera."""
    BINNING_VERTICAL = "BinningVertical"
    """Number of vertical photo-sensitive cells to combine together. This increases the intensity (or signal to noise ratio) of the pixels and reduces the vertical resolution (height) of the image. A value of 1 indicates that no vertical binning is performed by the camera."""
    BLACK_LEVEL = "BlackLevel"
    """Controls the analog black level as an absolute physical value. This represents a DC offset applied to the video signal"""
    CHUNK_BLOCK_ID = "ChunkBlockId"
    """Returns the block ID (frame number) of the image"""
    CHUNK_ENABLE = "ChunkEnable"
    """Enables the inclusion of the selected Chunk data in the payload of the image."""
    CHUNK_EXPOSURE_TIME = "ChunkExposureTime"
    """Returns the exposure time used to capture the image."""
    CHUNK_GAIN = "ChunkGain"
    """Returns the gain used to capture the image."""
    CHUNK_IMAGE = "ChunkImage"
    """Returns the entire image data included in the payload."""
    CHUNK_IMX174_FRAME_ID = "ChunkIMX174FrameId"
    """IMX174 double exposure frame id."""
    CHUNK_IMX174_FRAME_SET = "ChunkIMX174FrameSet"
    """IMX174 double exposure frame set identifier."""
    CHUNK_MODE_ACTIVE = "ChunkModeActive"
    """Activates the inclusion of Chunk data in the payload of the image."""
    CHUNK_MULTI_FRAME_SET_FRAME_ID = "ChunkMultiFrameSetFrameId"
    """Returns the frame id in the frame set in Multi Frame Set Output Mode."""
    CHUNK_MULTI_FRAME_SET_ID = "ChunkMultiFrameSetId"
    """Returns the id of the frame set in Multi Frame Set Output Mode."""
    CHUNK_SELECTOR = "ChunkSelector"
    """Selects which Chunk to enable or control"""
    COLOR_TRANSFORMATION_ENABLE = "ColorTransformationEnable"
    """Activates the selected Color Transformation module."""
    COLOR_TRANSFORMATION_SELECTOR = "ColorTransformationSelector"
    """Selects which Color Transformation module is controlled by the various Color Transformation features."""
    COLOR_TRANSFORMATION_VALUE = "ColorTransformationValue"
    """Represents the value of the selected Gain factor or Offset inside the Transformation matrix."""
    COLOR_TRANSFORMATION_VALUE_SELECTOR = "ColorTransformationValueSelector"
    """Selects the Gain factor or Offset of the Transformation matrix to access in the selected Color Transformation module."""
    CONTRAST = "Contrast"
    """Controls Contrast."""
    DECIMATION_HORIZONTAL = "DecimationHorizontal"
    """Horizontal sub-sampling of the image. This reduces the horizontal resolution (width) of the image by the specified horizontal decimation factor."""
    DECIMATION_VERTICAL = "DecimationVertical"
    """Vertical sub-sampling of the image. This reduces the vertical resolution (height) of the image by the specified vertical decimation factor."""
    DENOISE = "Denoise"
    """Controls the strength of the denoise algorithm."""
    DEVICE_EVENT_CHANNEL_COUNT = "DeviceEventChannelCount"
    """Indicates the number of event channels supported by the device."""
    DEVICE_FACTORY_RESET = "DeviceFactoryReset"
    """Resets all user-programmable non-volatile memory to default. After reset, the device must be rediscovered."""
    DEVICE_FIRMWARE_VERSION = "DeviceFirmwareVersion"
    """Version of the device."""
    DEVICE_LINK_HEARTBEAT_TIMEOUT = "DeviceLinkHeartbeatTimeout"
    """Controls the current heartbeat timeout of the specific Link."""
    DEVICE_LINK_SELECTOR = "DeviceLinkSelector"
    """Selects which Link of the device to control."""
    DEVICE_MODEL_NAME = "DeviceModelName"
    """Model of the device."""
    DEVICE_RESET = "DeviceReset"
    """Resets the device to its power up state. After reset, the device must be rediscovered."""
    DEVICE_SCAN_TYPE = "DeviceScanType"
    """Returns the scan type of the sensor of the device."""
    DEVICE_SERIAL_NUMBER = "DeviceSerialNumber"
    """Device's serial number. This string is a unique identifier of the device."""
    DEVICE_SFNC_VERSION_MAJOR = "DeviceSFNCVersionMajor"
    """Major version of the Standard Features Naming Convention that was used to create the device's GenICam XML"""
    DEVICE_SFNC_VERSION_MINOR = "DeviceSFNCVersionMinor"
    """Minor version of the Standard Features Naming Convention that was used to create the device's GenICam XML"""
    DEVICE_SFNC_VERSION_SUB_MINOR = "DeviceSFNCVersionSubMinor"
    """Sub minor version of the Standard Features Naming Convention that was used to create the device's GenICam XML"""
    DEVICE_STREAM_CHANNEL_COUNT = "DeviceStreamChannelCount"
    """Indicates the number of streaming channels supported by the device."""
    DEVICE_STREAM_CHANNEL_ENDIANNESS = "DeviceStreamChannelEndianness"
    """Endianess of multi-byte pixel data for this stream."""
    DEVICE_STREAM_CHANNEL_LINK = "DeviceStreamChannelLink"
    """Index of device`s Link to use for streaming the specifed stream channel."""
    DEVICE_STREAM_CHANNEL_PACKET_SIZE = "DeviceStreamChannelPacketSize"
    """Specifies the stream packet size, in bytes, to send on the selected channel."""
    DEVICE_STREAM_CHANNEL_SELECTOR = "DeviceStreamChannelSelector"
    """Selects the stream channel to control."""
    DEVICE_STREAM_CHANNEL_TYPE = "DeviceStreamChannelType"
    """Reports the type of the stream channel."""
    DEVICE_TEMPERATURE = "DeviceTemperature"
    """Device temperature in degrees Celsius (°C). It is measured at the location selected by DeviceTemperatureSelector."""
    DEVICE_TEMPERATURE_SELECTOR = "DeviceTemperatureSelector"
    """Selects the location within the device, where the temperature will be measured."""
    DEVICE_TL_TYPE = "DeviceTLType"
    """Transport Layer type of the device."""
    DEVICE_TL_VERSION_MAJOR = "DeviceTLVersionMajor"
    """Major version of the Transport Layer of the device."""
    DEVICE_TL_VERSION_MINOR = "DeviceTLVersionMinor"
    """Minor version of the Transport Layer of the device."""
    DEVICE_TL_VERSION_SUB_MINOR = "DeviceTLVersionSubMinor"
    """Sub minor version of the Transport Layer of the device."""
    DEVICE_TYPE = "DeviceType"
    """Returns the device type."""
    DEVICE_USER_ID = "DeviceUserID"
    """User-programmable device identifier."""
    DEVICE_VENDOR_NAME = "DeviceVendorName"
    """Name of the manufacturer of the device."""
    DEVICE_VERSION = "DeviceVersion"
    """Version of the device."""
    DISABLE_INFO_OVERLAY = "DisableInfoOverlay"
    """Disables the HDMI format info overlay."""
    EVENT_EXPOSURE_END = "EventExposureEnd"
    """Unique identifier of the Exposure End event. Use this parameter to get notified when the event occurs."""
    EVENT_EXPOSURE_END_FRAME_ID = "EventExposureEndFrameID"
    """Frame ID of the Exposure End event."""
    EVENT_EXPOSURE_END_TIMESTAMP = "EventExposureEndTimestamp"
    """Timestamp of the Exposure End event."""
    EVENT_FOCUS_MOVE_COMPLETED = "EventFocusMoveCompleted"
    """Unique identifier of the Focus Move Completed event. Use this parameter to get notified when the event occurs."""
    EVENT_FOCUS_MOVE_COMPLETED_FOCUS = "EventFocusMoveCompletedFocus"
    """Focus value of the Focus Move Completed event."""
    EVENT_FOCUS_MOVE_COMPLETED_TIMESTAMP = "EventFocusMoveCompletedTimestamp"
    """Timestamp of the Focus Move Completed event."""
    EVENT_FRAME_TRIGGER_MISSED = "EventFrameTriggerMissed"
    """Unique identifier of the Frame Trigger Missed event. Use this parameter to get notified when the event occurs."""
    EVENT_FRAME_TRIGGER_MISSED_TIMESTAMP = "EventFrameTriggerMissedTimestamp"
    """Timestamp of the Frame Trigger Missed event."""
    EVENT_LINE1_FALLING_EDGE = "EventLine1FallingEdge"
    """Unique identifier of the Line1 Falling Edge event. Use this parameter to get notified when the event occurs."""
    EVENT_LINE1_FALLING_EDGE_TIMESTAMP = "EventLine1FallingEdgeTimestamp"
    """Timestamp of the Line1 Falling Edge event."""
    EVENT_LINE1_RISING_EDGE = "EventLine1RisingEdge"
    """Unique identifier of the Line1 Rising Edge event. Use this parameter to get notified when the event occurs."""
    EVENT_LINE1_RISING_EDGE_TIMESTAMP = "EventLine1RisingEdgeTimestamp"
    """Timestamp of the Line1 Rising Edge event."""
    EVENT_NOTIFICATION = "EventNotification"
    """Enables event notifications for the currently selected event. The event can selected using the Event Selector parameter."""
    EVENT_SELECTOR = "EventSelector"
    """Sets the event notification to be enabled. The notification can be enabled using the Event Notification parameter."""
    EVENT_TEST = "EventTest"
    """Unique identifier of the Test event. Use this parameter to get notified when the event occurs."""
    EVENT_TEST_TIMESTAMP = "EventTestTimestamp"
    """Timestamp of the test event."""
    EVENT_ZOOM_MOVE_COMPLETED = "EventZoomMoveCompleted"
    """Unique identifier of the Zoom Move Completed event. Use this parameter to get notified when the event occurs."""
    EVENT_ZOOM_MOVE_COMPLETED_TIMESTAMP = "EventZoomMoveCompletedTimestamp"
    """Timestamp of the Zoom Move Completed event."""
    EVENT_ZOOM_MOVE_COMPLETED_ZOOM = "EventZoomMoveCompletedZoom"
    """Zoom value of the Zoom Move Completed event."""
    EXPAND_OUTPUT_RANGE = "ExpandOutputRange"
    """Use the full brightness range when receiving YUV data via HDMI."""
    EXPOSURE_AUTO = "ExposureAuto"
    """Sets the automatic exposure mode when ExposureMode is Timed."""
    EXPOSURE_AUTO_HIGHLIGH_REDUCTION = "ExposureAutoHighlighReduction"
    """Lets the ExposureAuto/GainAuto algorithm try to avoid over-exposures."""
    EXPOSURE_AUTO_HIGHLIGHT_REDUCTION = "ExposureAutoHighlightReduction"
    """Lets the ExposureAuto/GainAuto algorithm try to avoid over-exposures."""
    EXPOSURE_AUTO_LOWER_LIMIT = "ExposureAutoLowerLimit"
    """Lower limit of the ExposureAuto function."""
    EXPOSURE_AUTO_REFERENCE = "ExposureAutoReference"
    """Configures the target image brightness of the ExposureAuto/GainAuto algorithm."""
    EXPOSURE_AUTO_UPPER_LIMIT = "ExposureAutoUpperLimit"
    """Upper limit of the ExposureAuto function."""
    EXPOSURE_AUTO_UPPER_LIMIT_AUTO = "ExposureAutoUpperLimitAuto"
    """Automatically sets the upper limit to match the Acquisition Frame Rate."""
    EXPOSURE_TIME = "ExposureTime"
    """Sets the Exposure time when ExposureMode is Timed and ExposureAuto is Off. This controls the duration where the photosensitive cells are exposed to light."""
    FILE_ACCESS_BUFFER = "FileAccessBuffer"
    """Defines the intermediate access buffer that allows the exchange of data between the device file storage and the application."""
    FILE_ACCESS_LENGTH = "FileAccessLength"
    """Controls the Length of the mapping between the device file storage and the FileAccessBuffer."""
    FILE_ACCESS_OFFSET = "FileAccessOffset"
    """Controls the Offset of the mapping between the device file storage and the FileAccessBuffer."""
    FILE_OPEN_MODE = "FileOpenMode"
    """Selects the access mode in which a file is opened in the device."""
    FILE_OPERATION_EXECUTE = "FileOperationExecute"
    """Executes the operation selected by FileOperationSelector on the selected file."""
    FILE_OPERATION_RESULT = "FileOperationResult"
    """Represents the file operation result. For Read or Write operations, the number of successfully read/written bytes is returned."""
    FILE_OPERATION_SELECTOR = "FileOperationSelector"
    """Selects the target operation for the selected file in the device. This Operation is executed when the FileOperationExecute feature is called."""
    FILE_OPERATION_STATUS = "FileOperationStatus"
    """Represents the file operation execution status."""
    FILE_SELECTOR = "FileSelector"
    """Selects the target file in the device."""
    FILE_SIZE = "FileSize"
    """Represents the size of the selected file in bytes."""
    FOCUS = "Focus"
    """Changes the Focus setting of the lens."""
    FOCUS_AUTO = "FocusAuto"
    """Enables automatic Focus control."""
    GAIN = "Gain"
    """Controls the gain as an absolute physical value. This is an amplification factor applied to he video signal."""
    GAIN_AUTO = "GainAuto"
    """Sets the automatic gain control mode."""
    GAIN_AUTO_LOWER_LIMIT = "GainAutoLowerLimit"
    """Lower limit of the GainAuto function."""
    GAIN_AUTO_UPPER_LIMIT = "GainAutoUpperLimit"
    """Upper limit of the GainAuto function."""
    GAIN_MODE = "GainMode"
    """Configures the sensor-specific Gain (LCG/HCG) setting"""
    GAMMA = "Gamma"
    """Controls the gamma correction of pixel intensity. This is typically used to compensate for nonlinearity of the display system (such as CRT)."""
    GEV_GVSP_EXTENDED_ID_MODE = "GevGVSPExtendedIDMode"
    """Enables the extended IDs mode"""
    GEV_SCPS_DO_NOT_FRAGMENT = "GevSCPSDoNotFragment"
    """The state of this feature is copied into the "do not fragment" bit of IP header of each stream packet. It can be used by the application to prevent IP fragmentation of packets on the stream channel."""
    GEV_SCPS_PACKET_SIZE = "GevSCPSPacketSize"
    """This GigE Vision specific feature corresponds to DeviceStreamChannelPacketSize and should be kept in sync with it. It specifies the stream packet size, in bytes, to send on the selected channel for a GVSP transmitter or specifies the maximum packet size supported by a GVSP receiver."""
    GP_IN = "GPIn"
    """Status of the digital input pin."""
    GP_OUT = "GPOut"
    """Status of the digital output pin."""
    HEIGHT = "Height"
    """Height of the image provided by the device (in pixels)."""
    HEIGHT_MAX = "HeightMax"
    """Maximum height of the image (in pixels). This dimension is calculated after vertical binning, decimation or any other function changing the vertical dimension of the image."""
    HUE = "Hue"
    """Color Hue"""
    IMX174_HARDWARE_WDR_ENABLE = "IMX174HardwareWDREnable"
    """Enable IMX174 WDR mode. This mode enables setting a second, longer exposure time (IMX174 WDR Shutter 2), which is used for every other frame."""
    IMX174_HARDWARE_WDR_SHUTTER_MODE = "IMX174HardwareWDRShutterMode"
    """Select the IMX174 WDR shutter mode. This mode decides whether the second shutter time can be choosen freely, or is fixed at a multiple of the configured ExposureTime."""
    IMX174_WDR_SHUTTER2 = "IMX174WDRShutter2"
    """Exposure time that is used for every other frame, if IMX174 WDR mode is enabled."""
    IMX_LOW_LATENCY_TRIGGER_MODE = "IMXLowLatencyTriggerMode"
    """Enables the low-latency mode for IMX global shutter sensors. This mode reduces the jitter between trigger input and exposure start, but disallows trigger overlap."""
    INPUT_BITS = "InputBits"
    """The detected bits per pixel of the HDMI source."""
    INPUT_FP1KS = "InputFp1ks"
    """The detected frame rate of the HDMI source."""
    INPUT_HEIGHT = "InputHeight"
    """The detected width of the HDMI input image."""
    INPUT_WIDTH = "InputWidth"
    """The detected width of the HDMI input image."""
    IR_CUT_FILTER_ENABLE = "IRCutFilterEnable"
    """Enables the IRCutFilter in from of the sensor."""
    IRIS = "Iris"
    """Changes the Iris setting of the lens."""
    IRIS_AUTO = "IrisAuto"
    """Enables automatic Iris control."""
    LUT_ENABLE = "LUTEnable"
    """Activates the LUT."""
    LUT_INDEX = "LUTIndex"
    """Control the index (offset) of the coefficient to access in the LUT."""
    LUT_SELECTOR = "LUTSelector"
    """Selects which LUT to control."""
    LUT_VALUE = "LUTValue"
    """Returns or sets the Value at entry LUTIndex of the LUT."""
    LUT_VALUE_ALL = "LUTValueAll"
    """Accesses all the LUT coefficients in a single access without using individual LUTIndex."""
    MULTI_FRAME_SET_OUTPUT_MODE_CUSTOM_GAIN = "MultiFrameSetOutputModeCustomGain"
    """Enables the sensor to use customizable gain values for the different frames of a frame set."""
    MULTI_FRAME_SET_OUTPUT_MODE_ENABLE = "MultiFrameSetOutputModeEnable"
    """Enables the sensor to output a sequence of 2 or 4 frames with configurable exposure times and gain values."""
    MULTI_FRAME_SET_OUTPUT_MODE_EXPOSURE_TIME0 = "MultiFrameSetOutputModeExposureTime0"
    """Configures the exposure time for frame 0 of the frame set."""
    MULTI_FRAME_SET_OUTPUT_MODE_EXPOSURE_TIME1 = "MultiFrameSetOutputModeExposureTime1"
    """Configures the exposure time for frame 1 of the frame set."""
    MULTI_FRAME_SET_OUTPUT_MODE_EXPOSURE_TIME2 = "MultiFrameSetOutputModeExposureTime2"
    """Configures the exposure time for frame 2 of the frame set."""
    MULTI_FRAME_SET_OUTPUT_MODE_EXPOSURE_TIME3 = "MultiFrameSetOutputModeExposureTime3"
    """Configures the exposure time for frame 3 of the frame set."""
    MULTI_FRAME_SET_OUTPUT_MODE_FRAME_COUNT = "MultiFrameSetOutputModeFrameCount"
    """Selects the number of frames in multi frame set output mode."""
    MULTI_FRAME_SET_OUTPUT_MODE_GAIN0 = "MultiFrameSetOutputModeGain0"
    """Configures the gain for frame 0 of the frame set."""
    MULTI_FRAME_SET_OUTPUT_MODE_GAIN1 = "MultiFrameSetOutputModeGain1"
    """Configures the gain for frame 1 of the frame set."""
    MULTI_FRAME_SET_OUTPUT_MODE_GAIN2 = "MultiFrameSetOutputModeGain2"
    """Configures the gain for frame 2 of the frame set."""
    MULTI_FRAME_SET_OUTPUT_MODE_GAIN3 = "MultiFrameSetOutputModeGain3"
    """Configures the gain for frame 3 of the frame set."""
    OFFSET_AUTO_CENTER = "OffsetAutoCenter"
    """Automatically adjust the values of OffsetX and OffsetY to select the center region of the sensor."""
    OFFSET_X = "OffsetX"
    """Horizontal offset from the origin to the region of interest (in pixels)."""
    OFFSET_Y = "OffsetY"
    """Vertical offset from the origin to the region of interest (in pixels)."""
    PAYLOAD_SIZE = "PayloadSize"
    """Provides the number of bytes transferred for each image or chunk on the stream channel. This includes any end-of-line, end-of-frame statistics or other stamp data. This is the total size of data payload for a data block."""
    PIXEL_FORMAT = "PixelFormat"
    """Format of the pixels provided by the device"""
    PTP_CLOCK_ACCURACY = "PtpClockAccuracy"
    """Indicates the expected accuracy of the device PTP clock when it is the grandmaster, or in the event it becomes the grandmaster."""
    PTP_ENABLE = "PtpEnable"
    """Enables the Precision Time Protocol (PTP)."""
    PTP_STATUS = "PtpStatus"
    """Returns the current state of the PTP clock."""
    REVERSE_X = "ReverseX"
    """Flip the image horizontally."""
    REVERSE_Y = "ReverseY"
    """Flip the image vertically."""
    SATURATION = "Saturation"
    """Color Saturation"""
    SENSOR_HEIGHT = "SensorHeight"
    """Effective height of the sensor in pixels."""
    SENSOR_PIXEL_HEIGHT = "SensorPixelHeight"
    """Physical size (pitch) in the y direction of a photo sensitive pixel unit."""
    SENSOR_PIXEL_WIDTH = "SensorPixelWidth"
    """Physical size (pitch) in the x direction of a photo sensitive pixel unit."""
    SENSOR_WIDTH = "SensorWidth"
    """Effective width of the sensor in pixels."""
    SHARPNESS = "Sharpness"
    """Controls the strength of the sharpness algorithm."""
    SIDEBAND_USE = "SidebandUse"
    """Enables Trigger/Strobe over USB-C Sideband Use Pins"""
    SIGNAL_DETECTED = "SignalDetected"
    """Indicates whether a signal is detected form the HDMI source."""
    SOFTWARE_TRANSFORM_ENABLE = "SoftwareTransformEnable"
    """Enables Software Transform properties. If enabled, properties like Sharpness, Tone Mapping etc. can be enabled and lead to a software transformation in the driver."""
    SOURCE_CONNECTED = "SourceConnected"
    """Indicates whether a HDMI source is connected."""
    STROBE_DELAY = "StrobeDelay"
    """Configures the delay from start of exposure to the generated strobe pulse."""
    STROBE_DURATION = "StrobeDuration"
    """If StrobeOperation is FixedDuration, specifies the pulse length."""
    STROBE_ENABLE = "StrobeEnable"
    """Enable generation of exposure-synchronized output pulses"""
    STROBE_OPERATION = "StrobeOperation"
    """Configures the mode of specifying the length of exposure-synchronized output pulses"""
    STROBE_POLARITY = "StrobePolarity"
    """Select level of exposure-synchronized output pulses"""
    TEST_EVENT_GENERATE = "TestEventGenerate"
    """Generates a Test event that can be used for testing event notification."""
    TEST_PENDING_ACK = "TestPendingAck"
    """Tests the device's pending acknowledge feature."""
    TIMESTAMP_LATCH = "TimestampLatch"
    """Latches the current timestamp counter into TimestampLatchValue."""
    TIMESTAMP_LATCH_STRING = "TimestampLatchString"
    """Human-readable interpretation of the latched timestamp."""
    TIMESTAMP_LATCH_VALUE = "TimestampLatchValue"
    """Returns the latched value of the timestamp counter. The timestamp must first be latched by using the Timestamp Control Latch command."""
    TIMESTAMP_RESET = "TimestampReset"
    """Resets the current value of the device timestamp counter. After executing this command, the timestamp counter restarts automatically."""
    TL_PARAMS_LOCKED = "TLParamsLocked"
    """Used by the Transport Layer to prevent critical features from changing during acquisition."""
    TONE_MAPPING_ENABLE = "ToneMappingEnable"
    """Enables tone mapping."""
    TONE_MAPPING_GLOBAL_BRIGHTNESS = "ToneMappingGlobalBrightness"
    """Changes the brightness reference used for a individual pixel, which is interpolated between local and global."""
    TONE_MAPPING_INTENSITY = "ToneMappingIntensity"
    """Adjusts the intensity of the tonemapping algorithm."""
    TRIGGER_ACTIVATION = "TriggerActivation"
    """Specifies the activation mode of the trigger"""
    TRIGGER_DEBOUNCER = "TriggerDebouncer"
    """Specifies the time for which trigger input has to be low in order accept the next trigger signal."""
    TRIGGER_DELAY = "TriggerDelay"
    """Specifies the delay to apply after the trigger reception before activating it."""
    TRIGGER_DENOISE = "TriggerDenoise"
    """Specifies the time for which trigger input has to be high in order to be accepted as a trigger signal."""
    TRIGGER_MASK = "TriggerMask"
    """Specifies the time for which trigger pulses are ignored after accepting a trigger signal."""
    TRIGGER_MODE = "TriggerMode"
    """Controls if the selected trigger is active."""
    TRIGGER_OPERATION = "TriggerOperation"
    """Controls the operation mode of the sensor in trigger mode."""
    TRIGGER_OVERLAP = "TriggerOverlap"
    """Specifies the type trigger overlap permitted with the previous frame. This defines when a valid trigger will be accepted for a new frame."""
    TRIGGER_SELECTOR = "TriggerSelector"
    """Selects the type of trigger to configure."""
    TRIGGER_SOFTWARE = "TriggerSoftware"
    """Generates an internal trigger. TriggerSource must be set to Software or Any."""
    TRIGGER_SOURCE = "TriggerSource"
    """Specifies the internal signal or physical input Line to use as the trigger source."""
    USER_SET_DEFAULT = "UserSetDefault"
    """Selects the feature User Set to load and make active by default when the device is reset."""
    USER_SET_LOAD = "UserSetLoad"
    """Loads the User Set specified by UserSetSelector to the device and makes it active."""
    USER_SET_SAVE = "UserSetSave"
    """Save the User Set specified by UserSetSelector to the non-volatile memory of the device."""
    USER_SET_SELECTOR = "UserSetSelector"
    """Selects the feature User Set to load, save or configure."""
    WIDTH = "Width"
    """Width of the image provided by the device (in pixels)."""
    WIDTH_MAX = "WidthMax"
    """Maximum width of the image (in pixels). The dimension is calculated after horizontal binning, decimation or any other function changing the horizontal dimension of the image."""
    ZOOM = "Zoom"
    """Changes the zoom setting of the lens."""
