
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_check_password_srp import TypeInputCheckPasswordSRP


class DeleteAccount(TLRequest[bool]):
    """
    Delete the user's account from the telegram servers.

    Raises:
        `420`TwoFaConfirmWaitError: Since this account is active and protected by a 2FA password, we will delete it in 1 week for security purposes. You can cancel this process at any time, you'll be able to reset your account in {seconds} seconds.
        `400`PasswordHashInvalidError: The provided password hash is invalid.

    """

    _id = 0XA2C0CF74
    _result_id = 0X43B904E1

    def __init__(
        self,
        reason: str,
        password: Optional['TypeInputCheckPasswordSRP'] = None
    ):

        """
        Delete the user's account from the telegram servers.

        Args:
            reason (str): Why is the account being deleted, can be empty
            password (Optional['TypeInputCheckPasswordSRP'], optional): [2FA password](https://core.telegram.org/api/srp): this field can be omitted even for accounts with 2FA enabled: in this case account account deletion will be delayed by 7 days [as specified in the docs](https://core.telegram.org/api/account-deletion)
        """

        self.reason = reason
        self.password = password

    def to_bytes(self, boxed: bool=True):
        with Writer(b't\xcf\xc0\xa2' if boxed else b'') as writer:
            with writer.flag() as flags:
                writer.string(self.reason)

                if flags(self.password, 0):
                    writer.object(
                        self.password,
                        group_id=0X9F1A3F43
                    )

            return writer.getvalue()