
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import List
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


class RegisterDevice(TLRequest[bool]):
    """
    Register device to receive [PUSH notifications](https://core.telegram.org/api/push-updates)

    Raises:
        `400`TokenEmptyError: The specified token is empty.
        `400`TokenInvalidError: The provided token is invalid.
        `400`TokenTypeInvalidError: The specified token type is invalid.
        `400`WebpushAuthInvalidError: The specified web push authentication secret is invalid.
        `400`WebpushKeyInvalidError: The specified web push elliptic curve Diffie-Hellman public key is invalid.
        `400`WebpushTokenInvalidError: The specified web push token is invalid.

    """

    _id = 0XEC86017A
    _result_id = 0X43B904E1

    def __init__(
        self,
        token_type: int,
        token: str,
        app_sandbox: bool,
        secret: bytes,
        other_uids: List[int],
        no_muted: bool = False
    ):

        """
        Register device to receive [PUSH notifications](https://core.telegram.org/api/push-updates)

        Args:
            token_type (int): Device token type, see [PUSH updates](https://core.telegram.org/api/push-updates#subscribing-to-notifications) for the possible values.
            token (str): Device token, see [PUSH updates](https://core.telegram.org/api/push-updates#subscribing-to-notifications) for the possible values.
            app_sandbox (bool): If [(boolTrue)](https://core.telegram.org/constructor/boolTrue) is transmitted, a sandbox-certificate will be used during transmission.
            secret (bytes): For FCM and APNS VoIP, optional encryption key used to encrypt push notifications
            other_uids (List[int]): List of user identifiers of other users currently using the client
            no_muted (bool, optional): Avoid receiving (silent and invisible background) notifications. Useful to save battery.
        """

        self.token_type = token_type
        self.token = token
        self.app_sandbox = app_sandbox
        self.secret = secret
        self.other_uids = other_uids
        self.no_muted = no_muted

    def to_bytes(self, boxed: bool=True):
        with Writer(b'z\x01\x86\xec' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.no_muted, 0)
                writer.int(self.token_type)
                writer.string(self.token)
                writer.object(
                    self.app_sandbox,
                    group_id=0X43B904E1
                )
                writer.bytes(self.secret)
                writer.vector(
                    self.other_uids,
                    writer.long
                )

            return writer.getvalue()