
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_peer import TypeInputPeer
    from ...types.auto_save_settings import TypeAutoSaveSettings


class SaveAutoSaveSettings(TLRequest[bool]):
    """
    Modify autosave settings

    Raises:
        `400`PeerIdInvalidError: The provided peer id is invalid.

    """

    _id = 0XD69B8361
    _result_id = 0X43B904E1

    def __init__(
        self,
        settings: 'TypeAutoSaveSettings',
        users: bool = False,
        chats: bool = False,
        broadcasts: bool = False,
        peer: Optional['TypeInputPeer'] = None
    ):

        """
        Modify autosave settings

        Args:
            settings ('TypeAutoSaveSettings'): The new autosave settings
            users (bool, optional): Whether the new settings should affect all private chats
            chats (bool, optional): Whether the new settings should affect all groups
            broadcasts (bool, optional): Whether the new settings should affect all [channels](https://core.telegram.org/api/channel)
            peer (Optional['TypeInputPeer'], optional): Whether the new settings should affect a specific peer
        """

        self.settings = settings
        self.users = users
        self.chats = chats
        self.broadcasts = broadcasts
        self.peer = peer

    def to_bytes(self, boxed: bool=True):
        with Writer(b'a\x83\x9b\xd6' if boxed else b'') as writer:
            with writer.flag() as flags:
                flags(self.users, 0)
                flags(self.chats, 1)
                flags(self.broadcasts, 2)

                if flags(self.peer, 3):
                    writer.object(
                        self.peer,
                        group_id=0X995DB9DF
                    )
                writer.object(
                    self.settings,
                    group_id=0X5D28B575
                )

            return writer.getvalue()