
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import Optional, TYPE_CHECKING
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_user import TypeInputUser


class SetBotInfo(TLRequest[bool]):
    """
    Set localized name, about text and description of a bot (or of the current account, if called by a bot).

    **Bots can use this method**

    Raises:
        `400`BotInvalidError: This is not a valid bot.
        `400`UserBotInvalidError: User accounts must provide the `bot` method parameter when calling this method. If there is no such method parameter, this method can only be invoked by bot accounts.

    """

    _id = 0X10CF3123
    _result_id = 0X43B904E1

    def __init__(
        self,
        lang_code: str,
        bot: Optional['TypeInputUser'] = None,
        name: Optional[str] = None,
        about: Optional[str] = None,
        description: Optional[str] = None
    ):

        """
        Set localized name, about text and description of a bot (or of the current account, if called by a bot).

        **Bots can use this method**

        Args:
            lang_code (str): Language code, if left empty update the fallback about text and description
            bot (Optional['TypeInputUser'], optional): If called by a user, must contain the peer of a bot we own.
            name (Optional[str], optional): New bot name
            about (Optional[str], optional): New about text
            description (Optional[str], optional): New description
        """

        self.lang_code = lang_code
        self.bot = bot
        self.name = name
        self.about = about
        self.description = description

    def to_bytes(self, boxed: bool=True):
        with Writer(b'#1\xcf\x10' if boxed else b'') as writer:
            with writer.flag() as flags:

                if flags(self.bot, 2):
                    writer.object(
                        self.bot,
                        group_id=0XB628962F
                    )
                writer.string(self.lang_code)

                if flags(self.name, 3):
                    writer.string(self.name)

                if flags(self.about, 0):
                    writer.string(self.about)

                if flags(self.description, 1):
                    writer.string(self.description)

            return writer.getvalue()