
#                     !!! WARNING !!!
#             This is an auto-generated file!
#                 Generated by [Builder].
# Any manual modifications will be lost upon regeneration.
#             DO NOT EDIT THIS FILE DIRECTLY.

from typing import TYPE_CHECKING
from ...types.updates import TypeUpdates
from ....gadgets.tlobject import TLRequest
from ....gadgets.byteutils import Writer


if TYPE_CHECKING:
    from ...types.input_user import TypeInputUser
    from ...types.input_channel import TypeInputChannel
    from ...types.input_check_password_srp import TypeInputCheckPasswordSRP


class EditCreator(TLRequest[TypeUpdates]):
    """
    Transfer channel ownership

    Raises:
        `400`ChannelsAdminPublicTooMuchError: You're admin of too many public channels, make some channels private to change the username of this channel.
        `400`ChannelPrivateError: You haven't joined this channel/supergroup.
        `400`ChatAdminRequiredError: You must be an admin in this chat to do this.
        `400`ChatNotModifiedError: No changes were made to chat information because the new information you passed is identical to the current information.
        `400`PasswordHashInvalidError: The provided password hash is invalid.
        `400`PasswordMissingError: You must [enable 2FA](https://core.telegram.org/api/srp) before executing this operation.
        `400`PasswordTooFreshError: The password was modified less than 24 hours ago, try again in {seconds} seconds.
        `400`SessionTooFreshError: This session was created less than 24 hours ago, try again in {seconds} seconds.
        `400`SrpIdInvalidError: Invalid SRP ID provided.
        `400`UserIdInvalidError: The provided user ID is invalid.
        `403`ChatWriteForbiddenError: You can't write in this chat.

    """

    _id = 0X8F38CD1F
    _result_id = 0XD68D29C0

    def __init__(
        self,
        channel: 'TypeInputChannel',
        user_id: 'TypeInputUser',
        password: 'TypeInputCheckPasswordSRP'
    ):

        """
        Transfer channel ownership

        Args:
            channel ('TypeInputChannel'): Channel
            user_id ('TypeInputUser'): New channel owner
            password ('TypeInputCheckPasswordSRP'): [2FA password](https://core.telegram.org/api/srp) of account
        """

        self.channel = channel
        self.user_id = user_id
        self.password = password

    def to_bytes(self, boxed: bool=True):
        with Writer(b'\x1f\xcd8\x8f' if boxed else b'') as writer:
            writer.object(
                self.channel,
                group_id=0X42691CEF
            )
            writer.object(
                self.user_id,
                group_id=0XB628962F
            )
            writer.object(
                self.password,
                group_id=0X9F1A3F43
            )

            return writer.getvalue()